//Hicham Matragi and Kevin McCormack
//Test Generator

//IMPORTS
import java.io.*;
import javax.swing.*;
import BreezySwing.*;
import java.awt.*;
import java.util.ArrayList;

public class Tester extends GBFrame
{
	//DECLARES PRIVATE OBJECTS OF TYPPE:
	//JRADIOBUTTON
	private JRadioButton A, B, C, D, trueRB, falseRB;
	//MULTICHOICEARRAY
	private MultiChoiceArray javaMCQues, aMCQues;
	//TRUEFALSEARRAY
	private TrueFalseArray javaTFQues, aTFQues;
	//FILLINARRAY
	private FillInArray javaFIQues, aFIQues;
	//JMENUITEM
	private JMenuItem menuJavaMC, menuJavaTF, menuJavaFI, menuAMC, menuATF, menuAFI;
	//JTEXTAREA
	private JTextArea questionTA, fillInBoxTA;
	//INT
	private int curQues=0, numCorrect=0, numQues=0;
	//JBUTTON
	private JButton ansQues, reTake, writeScore;
	//STRING
	private String whichTopic;
	//JLABEL
	private JLabel filler1, filler2;
	//ARRAYLIST
	private ArrayList incorrect;
	//SCORE
	private Score theScore;
	
//CONSTUCTOR FOR TESTER.JAVA
	public Tester()throws IOException //THROWS IOEXCEPTION TO HANDLE IO ERROR
	{
		//INITIALIZE MENU SYSTEM
		menuJavaMC = addMenuItem("Java","Multiple Choice");
		menuJavaTF = addMenuItem("Java","True or False");
		menuJavaFI = addMenuItem("Java","Fill in");	
		menuAMC = addMenuItem("A+","Multiple Choice");
		menuATF = addMenuItem("A+","True or False");
		menuAFI = addMenuItem("A+","Fill in");
		//INITIALIZE TEXTAREAS
		questionTA = addTextArea("",1,1,4,1);
		fillInBoxTA = addTextArea("",6,4,1,1);
		//INITIALIZE BUTTONS
		ansQues = addButton("Answer",5,1,1,1);
		reTake = addButton("Retake Incorrect",5,2,1,1);
		writeScore = addButton("Write Score",5,3,1,1);
		writeScore.setVisible(false);
		reTake.setVisible(false);
		//INITIALIZE LABELS
		filler1 = addLabel("",6,1,1,1);
		filler2 = addLabel("",6,3,2,1);
		//INITIALIZE RADIOBUTTONS
		A= addRadioButton("A",2,1,1,1);
		B= addRadioButton("B",2,2,1,1);
		C= addRadioButton("C",2,3,1,1);
		D= addRadioButton("D",2,4,1,1);
		trueRB= addRadioButton("True",2,1,1,1);
		falseRB= addRadioButton("False",2,2,1,1);	
		A.setVisible(false);
		B.setVisible(false);
		C.setVisible(false);
		D.setVisible(false);
		trueRB.setVisible(false);
		falseRB.setVisible(false);
		fillInBoxTA.setVisible(false);
		//CREATES RADIOBUTTON GROUPS
		ButtonGroup choiceMC = new ButtonGroup();
		choiceMC.add(A);
		choiceMC.add(B);
		choiceMC.add(C);
		choiceMC.add(D);
		ButtonGroup choiceTF = new ButtonGroup();
		choiceTF.add(trueRB);
		choiceTF.add(falseRB);
		//INITIALIZE AND LOADS ARRAYCLASSES WITH TEXTFILES
		javaMCQues = new MultiChoiceArray("JavaMC.txt");
		aMCQues = new MultiChoiceArray("AMC.txt");
		javaTFQues = new TrueFalseArray("JavaTF.txt");
 		aTFQues = new TrueFalseArray("ATF.txt");
 		javaFIQues = new FillInArray("JavaFI.txt");
 		aFIQues = new FillInArray("AFI.txt");
 		theScore = new Score();
 		incorrect = new ArrayList(); 
 	}
 	
 	//BUTTONCLICKED METHOD
 	//JBUTTON CLICKED = BUTTON THAT IS CLICKED
	public void buttonClicked(JButton clicked)
	{
		if(clicked == ansQues)
		{
			if(whichTopic=="jmc")
			//JAVA MULTIPLE CHOICE ANSWER CHECK
			{
				if(curQues<javaMCQues.getSize())
				{
					if (A.isSelected())
						if(javaMCQues.isCorrect(curQues,"a"))
							numCorrect++;
						else
						{
							Toolkit.getDefaultToolkit().beep(); //BEEPS IF CORRECT
							incorrect.add(javaMCQues.getQuesAns(curQues));
						}
					if (B.isSelected())
						if(javaMCQues.isCorrect(curQues,"b"))
							numCorrect++;
						else
						{
							incorrect.add(javaMCQues.getQuesAns(curQues));
							Toolkit.getDefaultToolkit().beep();
						}
					if (C.isSelected())
						if(javaMCQues.isCorrect(curQues,"c"))
							numCorrect++;
						else
						{
							Toolkit.getDefaultToolkit().beep();
							incorrect.add(javaMCQues.getQuesAns(curQues));
						}
					if (D.isSelected())
						if(javaMCQues.isCorrect(curQues,"d"))
							numCorrect++;
						else
						{
							Toolkit.getDefaultToolkit().beep();	
							incorrect.add(javaMCQues.getQuesAns(curQues));
						}
					curQues++;
					if(curQues<javaMCQues.getSize())
						questionTA.setText(javaMCQues.getQuesAns(curQues));		
					if(curQues==javaMCQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
									"Number Correct: "+numCorrect+"\n"+
									"Number Wrong: "+(javaMCQues.getSize()-numCorrect)+"\n"+
									"Percentage Correct: "+(int)((numCorrect/(double)javaMCQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
					}
				}
			}
			
			else if(whichTopic=="amc")
			//A+ MULTIPLE CHOICE ANSWER CHECK
			{
				if(curQues<aMCQues.getSize())
				{
					if (A.isSelected())
						if(aMCQues.isCorrect(curQues,"a"))
						numCorrect++;	
						else
							Toolkit.getDefaultToolkit().beep();
					if (B.isSelected())
						if(aMCQues.isCorrect(curQues,"b"))
						numCorrect++;
							else
							Toolkit.getDefaultToolkit().beep();
					if (C.isSelected())
						if(aMCQues.isCorrect(curQues,"c"))
						numCorrect++;
						else
							Toolkit.getDefaultToolkit().beep();
					if (D.isSelected())
						if(aMCQues.isCorrect(curQues,"d"))
						numCorrect++;
						else
							Toolkit.getDefaultToolkit().beep();
					curQues++;
					if(curQues<aMCQues.getSize())
						questionTA.setText(aMCQues.getQuesAns(curQues));	
					//RESULTS OF TEST
					if(curQues==aMCQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
									"Number Correct: "+numCorrect+"\n"+
									"Number Wrong: "+(aMCQues.getSize()-numCorrect)+"\n"+
									"Percentage Correct: "+(int)((numCorrect/(double)aMCQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
							
					}
				}
			}
			if(whichTopic=="jtf")
			//JAVA TRUE FALSE ANSWER CHECK
			{
				if(curQues<javaTFQues.getSize())
				{
				
					if(trueRB.isSelected() && javaTFQues.isCorrect(curQues,true))
						numCorrect++;
						
					else if(falseRB.isSelected() && javaTFQues.isCorrect(curQues,false))
						numCorrect++;
					else
						Toolkit.getDefaultToolkit().beep();
					curQues++;
					if(curQues<javaTFQues.getSize())
						questionTA.setText(javaTFQues.getQuesAns(curQues));
					//RESULTS OF TEST
					if(curQues==javaTFQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
								"Number Correct: "+numCorrect+"\n"+
								"Number Wrong: "+(javaTFQues.getSize()-numCorrect)+"\n"+
								"Percentage Correct: "+(int)((numCorrect/(double)javaTFQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
					}	
				}
			}
			else if(whichTopic=="atf")
			//A+ TRUE FALSE ANSWER CHECK
			{
				if(curQues<aTFQues.getSize())
				{			
					if(trueRB.isSelected() && aTFQues.isCorrect(curQues,true))
						numCorrect++;
					else if(falseRB.isSelected() && aTFQues.isCorrect(curQues,false))
						numCorrect++;
						else
							Toolkit.getDefaultToolkit().beep();
					curQues++;
					if(curQues<aTFQues.getSize())
						questionTA.setText(aTFQues.getQuesAns(curQues));
					//RESULTS OF TEST
					if(curQues==aTFQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
									"Number Correct: "+numCorrect+"\n"+
									"Number Wrong: "+(aTFQues.getSize()-numCorrect)+"\n"+
									"Percentage Correct: "+(int)((numCorrect/(double)aTFQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
					}
				}
			}
			if(whichTopic=="jfi")
			//Java FILL IN CHECK
			{
				if(curQues<javaFIQues.getSize())
				{
					if(javaFIQues.isCorrect(curQues,fillInBoxTA.getText()))
						numCorrect++;
						else
							Toolkit.getDefaultToolkit().beep();
					curQues++;
					if(curQues<javaFIQues.getSize())
					{
						questionTA.setText(javaFIQues.getQuesAns(curQues));
						fillInBoxTA.setText("");
					}
					//RESULTS OF TEST
					if(curQues==javaFIQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
									"Number Correct: "+numCorrect+"\n"+
									"Number Wrong: "+(javaFIQues.getSize()-numCorrect)+"\n"+
									"Percentage Correct: "+(int)((numCorrect/(double)javaFIQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
					}
				}	 
			}					
			if(whichTopic=="afi")
			//A+ FILL IN CHECK
			{
				if(curQues<aFIQues.getSize())
				{
					if(aFIQues.isCorrect(curQues,fillInBoxTA.getText()))
						numCorrect++;
					else
						Toolkit.getDefaultToolkit().beep();
					curQues++;
					if(curQues<aFIQues.getSize())
					{
						questionTA.setText(aFIQues.getQuesAns(curQues));
						fillInBoxTA.setText("");
					}
					//RESULTS OF TEST
					if(curQues==aFIQues.getSize())
					{
						messageBox("End of section.  Select next section from menu.\n"+
									"Number Correct: "+numCorrect+"\n"+
									"Number Wrong: "+(aFIQues.getSize()-numCorrect)+"\n"+
									"Percentage Correct: "+(int)((numCorrect/(double)aFIQues.getSize())*100)+"%",350,200);
						reTake.setVisible(true);
						writeScore.setVisible(true);
					}
				}	 
			}	
		}		
	 	//RETAKE METHOD RESESTS SCORE AND REINVOKES QUESTIONS
	 	if (reTake==clicked)
 		{
 			curQues=0;
 			numCorrect=0; 	
 			if(whichTopic=="jmc")
 				questionTA.setText(javaMCQues.getQuesAns(curQues));
 			if(whichTopic=="amc")
 				questionTA.setText(aMCQues.getQuesAns(curQues));
 			if(whichTopic=="jtf")
 				questionTA.setText(javaTFQues.getQuesAns(curQues));
 			if(whichTopic=="atf")
 				questionTA.setText(aTFQues.getQuesAns(curQues));
 			if(whichTopic=="jfi")
 				questionTA.setText(javaFIQues.getQuesAns(curQues));
 			if(whichTopic=="afi")
 				questionTA.setText(aFIQues.getQuesAns(curQues));
 		}
	 	
	 	//INVOKES SCORE.JAVA TO ADD STATS TO SCORE.TXT
		if(writeScore==clicked)
		{
     		try
      		{
				scoreIt();
       		}
       		catch(Exception e)//EXCEPTION HANDLING
       		{
        	}
		}	  			
	} 
	//SENDS STRING OF STATS TO SCORE.JAVA
	public void scoreIt() throws IOException
	{
		if(whichTopic.equals("jmc"))
			theScore.write("Java Multiple Choice Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)javaMCQues.getSize())*100)+"%");
									
		if(whichTopic.equals("amc"))
			theScore.write("A+ Multiple Choice Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)aMCQues.getSize())*100)+"%");
		if(whichTopic.equals("jtf"))
			theScore.write("Java True False Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)javaTFQues.getSize())*100)+"%");
		if(whichTopic.equals("atf"))
			theScore.write("A+ True False Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)aTFQues.getSize())*100)+"%");
		if(whichTopic.equals("jfi"))
			theScore.write("Java Fill In Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)javaFIQues.getSize())*100)+"%");
		if(whichTopic.equals("afi"))
			theScore.write("A+ Fill In Score: Number Correct: "+numCorrect+
						" Percentage Correct: "+(int)((numCorrect/(double)aFIQues.getSize())*100)+"%");
	}

	//HANDLES MENU SYSTEM AND RESETS SCORE AND QUESTION POSITION TO 0
 	public void menuItemSelected(JMenuItem clicked)
 	{
 		curQues=0;
 		numCorrect=0;
 		
 		if(clicked==menuJavaMC)
 	 	{
 	 		clearFields();
 	 		whichTopic="jmc";
 	 		A.setVisible(true);
 	 		B.setVisible(true);
 	 		C.setVisible(true);
 	 		D.setVisible(true);	
 			questionTA.setText(javaMCQues.getQuesAns(curQues));	
 	 	}
 		else if(clicked==menuAMC)
 		{
 			clearFields();
 			whichTopic="amc";
 	 		A.setVisible(true);
 	 		B.setVisible(true);
 	 		C.setVisible(true);
 	 		D.setVisible(true);	
 			questionTA.setText(aMCQues.getQuesAns(curQues));	
 		}
 		else if(clicked==menuJavaTF)
 		{	
 			clearFields();
 			whichTopic="jtf";
 			trueRB.setVisible(true);
			falseRB.setVisible(true);
 			questionTA.setText(javaTFQues.getQuesAns(curQues));				
 		}
 	 	else if(clicked==menuATF)
 		{
 			clearFields();
 			whichTopic="atf";
 			trueRB.setVisible(true);
			falseRB.setVisible(true);
 			questionTA.setText(aTFQues.getQuesAns(curQues));				
 		} 		
 		else if(clicked==menuJavaFI)
		{	
			clearFields();
			whichTopic="jfi";
			fillInBoxTA.setVisible(true);
			questionTA.setText(javaFIQues.getQuesAns(curQues));
		}

 		else if(clicked==menuAFI)
 		{
 			clearFields();
 			whichTopic="afi";
			fillInBoxTA.setVisible(true);
			questionTA.setText(aFIQues.getQuesAns(curQues));
 		}
 	}
 	//CLEARS ALL QUESTION FIELDS AND RETURNS TO ORIGINAL GUI MODE
 	public void clearFields()
 	{
		A.setVisible(false);
		B.setVisible(false);
		C.setVisible(false);
		D.setVisible(false); 		
 		trueRB.setVisible(false);
		falseRB.setVisible(false);
		reTake.setVisible(false);
		fillInBoxTA.setVisible(false);
		writeScore.setVisible(false);	
	}

	//MAIN
	public static void main(String [] args) throws IOException
	{
		Tester theTest=new Tester();
		theTest.setSize(600,500);
		theTest.setVisible(true);
	}
}
