/*
 * Decompiled with CFR 0.152.
 */
package BreezySwing;

public class Format {
    private static String padStringToWidth(char leftRight, String str, int width) {
        if (width <= 0) {
            return str;
        }
        int strLength = str.length();
        if (strLength > width) {
            str = "";
            for (int i = 1; i <= width; ++i) {
                str = String.valueOf(str).concat(String.valueOf("*"));
            }
        } else if (leftRight == 'r' || leftRight == 'R') {
            for (int i = 1; i <= width - strLength; ++i) {
                str = String.valueOf(" ").concat(String.valueOf(str));
            }
        } else if (leftRight == 'l' || leftRight == 'L') {
            for (int i = 1; i <= width - strLength; ++i) {
                str = String.valueOf(str).concat(String.valueOf(" "));
            }
        } else {
            int i;
            for (i = 1; i <= (width - strLength) / 2; ++i) {
                str = String.valueOf(" ").concat(String.valueOf(str));
            }
            for (i = 1; i <= (width - strLength) / 2; ++i) {
                str = String.valueOf(str).concat(String.valueOf(" "));
            }
        }
        return str;
    }

    public static String justify(char leftRight, String str, int width) {
        return Format.padStringToWidth(leftRight, str, width);
    }

    public static String justify(char leftRight, char ch, int width) {
        return Format.padStringToWidth(leftRight, String.valueOf("").concat(String.valueOf(ch)), width);
    }

    public static String justify(char leftRight, long x, int width) {
        return Format.padStringToWidth(leftRight, String.valueOf("").concat(String.valueOf(x)), width);
    }

    public static String justify(char leftRight, double x, int width, int precision) {
        int i;
        String sign = "";
        if (x < 0.0) {
            x = -x;
            sign = "-";
        }
        if (precision < 0) {
            precision = 0;
        }
        double rounder = 1.0;
        for (i = 1; i <= precision; ++i) {
            rounder /= 10.0;
        }
        x += 0.5 * rounder;
        int exp = 0;
        while (x >= (double)10) {
            x /= (double)10;
            ++exp;
        }
        while (x < 1.0) {
            x *= (double)10;
            --exp;
        }
        for (i = 1; i <= 14; ++i) {
            x *= 10.0;
        }
        String str = String.valueOf("").concat(String.valueOf((long)x));
        if (exp >= 14) {
            for (i = 1; i <= exp - 14; ++i) {
                str = String.valueOf(str).concat(String.valueOf("0"));
            }
            str = String.valueOf(str).concat(String.valueOf("."));
        } else if (exp >= 0) {
            str = String.valueOf(String.valueOf(String.valueOf(sign).concat(String.valueOf(str.substring(0, exp + 1)))).concat(String.valueOf("."))).concat(String.valueOf(str.substring(exp + 1, str.length())));
        } else if (exp < 0) {
            for (i = 1; i <= -exp - 1; ++i) {
                str = String.valueOf("0").concat(String.valueOf(str));
            }
            str = String.valueOf(String.valueOf(sign).concat(String.valueOf("0."))).concat(String.valueOf(str));
        }
        int posdp = str.indexOf(46);
        if (precision == 0) {
            str = str.substring(0, posdp);
        } else {
            for (i = 1; i <= precision; ++i) {
                str = String.valueOf(str).concat(String.valueOf("0"));
            }
            str = String.valueOf(str.substring(0, posdp + 1)).concat(String.valueOf(str.substring(posdp + 1, posdp + 1 + precision)));
        }
        return Format.padStringToWidth(leftRight, str, width);
    }

    public static void testJustify() {
        System.out.println(String.valueOf(Format.justify('r', "abc", 5)).concat(String.valueOf(":::  abc")));
        System.out.println(String.valueOf(Format.justify('l', "abc", 5)).concat(String.valueOf(":::abc  :::")));
        System.out.println(String.valueOf(Format.justify('l', "abc", 0)).concat(String.valueOf(":::abc:::")));
        System.out.println(String.valueOf(Format.justify('r', "abc", 2)).concat(String.valueOf(":::**")));
        System.out.println("");
        System.out.println(String.valueOf(Format.justify('r', 'a', 2)).concat(String.valueOf("::: a")));
        System.out.println(String.valueOf(Format.justify('l', 'a', 2)).concat(String.valueOf(":::a :::")));
        System.out.println(String.valueOf(Format.justify('r', 'a', -1)).concat(String.valueOf(":::a")));
        System.out.println("");
        System.out.println(String.valueOf(Format.justify('r', 123L, 0)).concat(String.valueOf(":::123")));
        System.out.println(String.valueOf(Format.justify('r', 123L, 4)).concat(String.valueOf("::: 123")));
        System.out.println(String.valueOf(Format.justify('r', 123L, 2)).concat(String.valueOf(":::**")));
        System.out.println(String.valueOf(Format.justify('l', 123L, 0)).concat(String.valueOf(":::123")));
        System.out.println(String.valueOf(Format.justify('l', 123L, 4)).concat(String.valueOf(":::123 :::")));
        System.out.println(String.valueOf(Format.justify('l', 123L, 2)).concat(String.valueOf(":::**")));
        System.out.println("");
        System.out.println(String.valueOf(String.valueOf("0:::").concat(String.valueOf(Format.justify('r', 0.0, 0, 0)))).concat(String.valueOf(":::0")));
        System.out.println(String.valueOf(String.valueOf("0:::").concat(String.valueOf(Format.justify('r', 0.0, 1, 0)))).concat(String.valueOf(":::0")));
        System.out.println(String.valueOf(String.valueOf("0:::").concat(String.valueOf(Format.justify('r', 0.0, 4, 2)))).concat(String.valueOf(":::0.00")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 0, 0)))).concat(String.valueOf(":::-123")));
        System.out.println(String.valueOf(String.valueOf("123:::").concat(String.valueOf(Format.justify('r', 123.0, 0, -3)))).concat(String.valueOf(":::123")));
        System.out.println(String.valueOf(String.valueOf("123.456:::").concat(String.valueOf(Format.justify('r', 123.456, 0, 2)))).concat(String.valueOf(":::123.46")));
        System.out.println(String.valueOf(String.valueOf("123.5:::").concat(String.valueOf(Format.justify('r', 123.5, 0, 0)))).concat(String.valueOf(":::124")));
        System.out.println(String.valueOf(String.valueOf("1.23456789012345E14:::").concat(String.valueOf(Format.justify('r', 1.23456789012345E14, 0, 0)))).concat(String.valueOf(":::123456789012345")));
        System.out.println(String.valueOf(String.valueOf("1.23456789012345E16:::").concat(String.valueOf(Format.justify('r', 1.23456789012345E16, 0, 0)))).concat(String.valueOf(":::12345678901234500")));
        System.out.println(String.valueOf(String.valueOf("1.23456789012345E13:::").concat(String.valueOf(Format.justify('r', 1.23456789012345E13, 0, 0)))).concat(String.valueOf(":::12345678901235")));
        System.out.println(String.valueOf(String.valueOf("1.2346:::").concat(String.valueOf(Format.justify('r', 1.2346, 0, 3)))).concat(String.valueOf(":::1.235")));
        System.out.println(String.valueOf(String.valueOf("0.001235:::").concat(String.valueOf(Format.justify('r', 0.001235, 0, 5)))).concat(String.valueOf(":::0.00124")));
        System.out.println(String.valueOf(String.valueOf("123.789:::").concat(String.valueOf(Format.justify('r', 123.789, 0, 0)))).concat(String.valueOf(":::124")));
        System.out.println(String.valueOf(String.valueOf("123.789:::").concat(String.valueOf(Format.justify('r', 123.789, 0, 1)))).concat(String.valueOf(":::123.8")));
        System.out.println(String.valueOf(String.valueOf("0.789:::").concat(String.valueOf(Format.justify('r', 0.789, 0, 5)))).concat(String.valueOf(":::0.78900")));
        System.out.println(String.valueOf(String.valueOf("0.789:::").concat(String.valueOf(Format.justify('r', 0.789, 7, 5)))).concat(String.valueOf(":::0.78900")));
        System.out.println(String.valueOf(String.valueOf("0.789:::").concat(String.valueOf(Format.justify('r', 0.789, 8, 5)))).concat(String.valueOf("::: 0.78900")));
        System.out.println(String.valueOf(String.valueOf("0.789:::").concat(String.valueOf(Format.justify('r', 0.789, 5, 5)))).concat(String.valueOf(":::*****")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 0, 0)))).concat(String.valueOf(":::-123")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 4, 0)))).concat(String.valueOf(":::-123")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 5, 0)))).concat(String.valueOf("::: -123")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 6, 0)))).concat(String.valueOf(":::  -123")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('r', -123.0, 3, 0)))).concat(String.valueOf(":::***")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('l', -123.0, 5, 0)))).concat(String.valueOf(":::-123 :::")));
        System.out.println(String.valueOf(String.valueOf("-123:::").concat(String.valueOf(Format.justify('l', -123.0, 6, 0)))).concat(String.valueOf(":::-123  :::")));
    }
}

