/*
 * Decompiled with CFR 0.152.
 */
package BreezySwing;

import BreezySwing.Format;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private int precision;
    private double number;

    private void displayNumber() {
        if (this.precision == -1) {
            this.setText(String.valueOf("").concat(String.valueOf(this.number)));
        } else {
            this.setText(Format.justify('l', this.number, 0, this.precision));
        }
    }

    public DoubleField(double num) {
        this.number = num;
        this.precision = -1;
        this.displayNumber();
    }

    public void setPrecision(int prec) {
        this.precision = prec > 10 ? 10 : (prec < 0 ? -1 : prec);
        this.displayNumber();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setNumber(double num) {
        this.number = num;
        this.displayNumber();
    }

    public boolean isValid() {
        try {
            double num = new Double(this.getText().trim());
            boolean bl = true;
            return bl;
        }
        catch (NumberFormatException e) {
            boolean bl = false;
            return bl;
        }
    }

    public double getNumber() {
        try {
            this.number = new Double(this.getText().trim());
        }
        catch (NumberFormatException e) {
            this.number = 0.0;
            this.displayNumber();
        }
        return this.number;
    }
}

