
		/* Magic Square Program */
/*
Programed by Jason Gradziel.
A magic square program, you enter in numbers from 1 to the size of the magic
square squared (3**2=9 or 4**2=16).  In the default square you enter in
numbers from 1 to 9, with out repeating.  You can also change the size of
the square two a number from 2 to 20.
The variable matrix is the numbers of the magic square.
The variable total is the total of the rows, colunms and diagonals added together.
*/

#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <limits.h>
#include <stdlib.h>
#include <dos.h>

int matrix[20][20];
int total[400];

Checkwin ();
Initlize ();
Displayboard ();
Display ();
Getmove ();
Getsize ();
Help ();
Start ();
Exit ();

int null = 1;
int size = 3;

void Pause ()
	{
	lowvideo ();
	cprintf ("\nPress any key to Continue...");
	getch ();
	fflush(stdin);
	highvideo ();
	}

main ()
	{
	clrscr ();
	int choice;

	Start ();
	Displayboard ();
	gotoxy (20,4);
	printf ("A 3 X 3 Magic Square filled with zeros.\n\n\n\n\n\n\n\n\n\n\n\n");

	getch ();
	fflush (stdin);
	clrscr ();

	while (1)
		{
		Initlize ();
		clrscr ();
		printf ("\n\n\n\n\t\t[1] Change the size of the square. (size of square is %d)\n", size);
		printf ("\t\t[2] Enter the numbers into the square.\n");
		printf ("\t\t[3] Help.\n");
		printf ("\t\t[4] Quit.\n");
		printf ("\n\n\t\tEnter in a number of your choice : ");
		scanf ("%d", &choice);
		fflush(stdin);

		if (choice == 1)
			/* You can change the size of the square */
			{
			Getsize ();
			}
		else if (choice == 2)
			/* You enter in the numbers of the square */
			{
			clrscr ();
			null = 1;
			while (null == 1)
				{
				Getmove ();
				if (size == 3)
					{
					Displayboard ();
					}
				else
					{
					Display ();
					}
				Checkwin ();
				if (null == 0)
					break;
				}

			}
		else if (choice == 3)
			/* The help file */
			{
			Help ();
			}
		else
			/* exits */
			{
			break;
			}
		}
	Pause ();
	Exit ();
	fflush(stdin);
	return 0;
	}

Checkwin ()
	{
	int a,row,col,flag;
	char again;
	flag = 0;

	/* Clears the totals for every square */
	for (a=0; a<400; a++)
		{
		total[a] = 0;
		}
	/* Adds up the rows and columns */
	for (row=0; row<size; row++)
		{
		for (col=0; col<size; col++)
			{
			total[row] += matrix[row][col];
			total[row+size] += matrix[col][row];
			}
		}
	/* Adds up the diagonals */
	total[size+size] = matrix[0][0] + matrix[1][1] + matrix[2][2] + matrix[3][3] + matrix[4][4] + matrix[5][5] + matrix[6][6] + matrix[7][7] + matrix[8][8] + matrix[9][9] + matrix[10][10] + matrix[11][11] + matrix[12][12] + matrix[13][13] + matrix[14][14] + matrix[15][15] + matrix[16][16] + matrix[17][17] + matrix[18][18] + matrix[19][19];
	for (col=0; col<size; col++)
		{
		total[size+size+1] += matrix[col][size-col-1];
		}

	/* Displays the totals */
	gotoxy (1,15);
	printf ("Totals of Rows.\t   Totals of Columns.\tTotals of Diagonals.\n");

	int x = 0;
	int y = 0;
	for (row=0; row<400; row++)
		{
		if (total[row] != 0)
			{
			if (row < size)
				{
				gotoxy (3,row+16);
				printf ("Total[%d] = %d\n",row+1,total[row]);
				}
			else if (row > size-1 && row < size+size)
				{
				gotoxy (22,x+16);
				printf ("Total[%d] = %d\n",row+1,total[row]);
				x++;
				}
			else if (row > size+size-1)
				{
				gotoxy (43,y+16);
				printf ("Total[%d] = %d\n",row+1,total[row]);
				y++;
				}
			}
		}

	gotoxy (1,22);
	printf ("      				");

	/* Checks if it is a win or lose */
	for (row=0; row<400; row++)
		{
		if (total[0] == total[row] || total[row] == 0)
			{
			}
		else
			{
			flag = 1;
			row = 400;
			gotoxy (1,22);
			printf ("\nSorry, This is not a magic square.");
			printf ("\nDo you want to continue? ");
			scanf ("%c", &again);
			fflush(stdin);
			if (again == 'Y' || again == 'y')
				{
				}
			else
				{
				null = 0;
				}
			}
		}
		if (flag == 0)
			{
			gotoxy (1,22);
			printf ("\nExcellent!, You have a magic square.");
			printf ("\nThe total of this magic square is %d.\n", total[0]);
			null = 0;
			}
	Pause ();
	return (null);
	}

Initlize ()
	/* make the the slots in the square to zero */
	{
	int row, col;
	for (row=0;row<size;row++)
		{
		for (col=0;col<size;col++)
			{
			matrix [row][col] = 0;
			}
		}
	return 0;
	}

Displayboard ()
	/* displays a 3 X 3 square */
	{
	clrscr ();
	printf ("\n\n\n\t\t\t   A 3 X 3 Magic Square\n\n");
	printf ("\t\t\t\t   COLUMN \n");
	printf ("\t\t\t\t  1   2   3 \n\n");
	printf ("\t\t\t       1  %d | %d | %d \n", matrix [0][0], matrix [0][1], matrix [0][2]);
	printf ("\t\t\t   R     ----------- \n");
	printf ("\t\t\t   O   2  %d | %d | %d \n", matrix [1][0], matrix [1][1], matrix [1][2]);
	printf ("\t\t\t   W     ----------- \n");
	printf ("\t\t\t       3  %d | %d | %d \n", matrix [2][0], matrix [2][1], matrix [2][2]);
	printf ("\n\n\n\n\n\n\n");
	Pause ();
	return 0;
	}

Display ()
	/* Displays the other squares */
	{
	clrscr ();
	int row,col;
	printf ("\n\n\n\t\tA %d X %d Magic Square\n\n\n", size,size);
	for (row=0; row<size; row++)
		{
		printf ("\t\t");
		for (col=0; col<size; col++)
			{
			printf ("%d\t", matrix [row][col]);
			}
		printf ("\n");
		}
	printf ("\n\n");
	return 0;
	}

Getmove ()
	{
	clrscr ();
	int row,col,num;
	printf ("\nEnter in a number in the postion it displays and then press enter.\n");
	printf ("Enter in the numbers for the square : \n\n");
	for (row=0; row<size; row++)
		{
		for (col=0; col<size; col++)
			{
			printf ("Matrix[%d][%d] = ", row+1,col+1);
			scanf ("%d", &num);
			fflush(stdin);
			matrix[row][col] = num;
			}
		}
	return 0;
	}

Getsize ()
	{
	while (size > 1 || size < 21)
		{
		printf ("\n\n\tWhat size of magic square would you like to try? ");
		printf ("\n\t(default 3) (from 2 - 20) : ");
		scanf ("%d", &size);
		if (size < 2 || size > 20)
			{
			printf ("\n\n\tThat is not between 2 and 20!\n");
			printf ("\t\tPlease try again.");
			Pause ();
			}
		else
			{
			break;
			}
		}
	fflush(stdin);
	return size;
	}

Help ()
	{
	clrscr ();
	int num;
	Displayboard ();
	printf ("\nYou enter in numbers from 1 to the number of the square squared.\n");
	printf ("Example. if it where a 3 X 3 square, then 3 squared is 9.\n");
	printf ("You enter in numbers in there given postion.\n");
	printf ("Matrix [1][1] would be in the first postion, enter in a number at\n");
	printf ("Matrix [1][1] = ");
	scanf ("%d", &num);
	matrix [0][0] = num;
	fflush(stdin);
	Displayboard ();
	printf ("\nNow the number you have entered is in row 1, column 1, and stored in \n");
	printf (" position matrix [0][0].\n");
	printf ("If you have any further questions call at 1-800-457-1300 and a \n");
	printf (" charge of $3.00 will be made.\n");
	Pause ();
	return 0;
	}

Start ()
	{
	textcolor (15);
	gotoxy (35,7);
	cprintf ("Magic Squares");

	printf ("\n\n\n\n\tThis is a magic square program which lets you enter in numbers \n");
	printf ("\tinto a magic square form, to be correct the numbers can never \n");
	printf ("\trepeat them selves.\n");
	printf ("\n\t\t\t8\t1\t6\n\t\t\t3\t5\t7\n\t\t\t4\t9\t2\n");
	printf ("\n\n\tProgramed by Jason Gradziel\n\n\n");
	lowvideo ();
	gotoxy (1,30);
	cprintf ("\nPress any key to Continue...");
	highvideo ();
	while (!kbhit())
		{
		lowvideo ();
		gotoxy (35,7);
		cprintf ("Magic Squares");
		delay (150);
		highvideo ();
		gotoxy (35,7);
		cprintf ("Magic Squares");
		delay (150);
		}
	fflush(stdin);
	return 0;
	}

Exit ()
	{
	clrscr();
	printf ("\n\n\n\n\n\n\n\n\n\t\t     Thank You for playing Magic Squares.\n\n\n\n\n");
	lowvideo ();
	gotoxy (1,30);
	cprintf ("\nPress any key to Continue...");
	highvideo ();
	while (!kbhit())
		{
		lowvideo ();
		gotoxy (35,12);
		cprintf ("Bye-Bye.");
		delay (150);
		highvideo ();
		gotoxy (35,12);
		cprintf ("Bye-Bye.");
		delay (150);
		}
	fflush(stdin);
	return 0;
	}