
		/* Magic Square Program */
/*
Programed by Jason Gradziel.
A magic square program, you enter in numbers from 1 to the size of the magic
square squared (3**2=9 or 4**2=16).  In the default square you enter in
numbers from 1 to 9, with out repeating.  You can also change the size of
the square two a number from 2 to 20.
The variable matrix is the numbers of the magic square.
The variable total is the total of the rows, colunms and diagonals added together.
*/

#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <limits.h>
#include <stdlib.h>
#include <dos.h>

int matrix[20][20];
int total[400];

Checkwin ();
Initlize ();
Displayboard ();
Display ();
Getmove ();
Getsize ();
Help ();
Start ();
Exit ();

int null = 1;
int size = 3;

void Pause ()
	{
	lowvideo ();
	gotoxy (1,40);
	cprintf ("\nPress any key to Continue...");
	getch ();
	fflush(stdin);
	highvideo ();
	}

main ()
	{
	clrscr ();
	int choice;

	Start ();
	Displayboard ();
	while (1)
		{
		Initlize ();
		clrscr ();
		printf ("\n\n\n\n\t\t[1] Change the size of the square. (size of square is %d)\n", size);
		printf ("\t\t[2] Enter the numbers into the square.\n");
		printf ("\t\t[3] Help.\n");
		printf ("\t\t[4] Quit.\n");
		printf ("\n\n\t\tEnter in a number of your choice : ");
		scanf ("%d", &choice);
		fflush(stdin);

		if (choice == 1)
			{
			Getsize ();
			}
		else if (choice == 2)
			{
			clrscr ();
			null = 1;
			while (null == 1)
				{
				Getmove ();
				if (size == 3)
					{
					Displayboard ();
					}
				else
					{
					Display ();
					}
				Checkwin ();
				if (null == 0)
					break;
				}

			}
		else if (choice == 3)
			{
			Help ();
			}
		else
			{
			break;
			}
		}
	Pause ();
	Exit ();
	fflush(stdin);
	return 0;
	}

Checkwin ()
	{
	int a,row,col,flag;
	char again;
	flag = 0;

	for (a=0; a<400; a++)
		{
		total[a] = 0;
		}

	if (size == 3)
		{
		for (row=0; row<3; row++)
			{
			total[row] = matrix[row][0] + matrix[row][1] + matrix[row][2];
			}
		for (col=0; col<3; col++)
			{
			total[col+3] = matrix[0][col] + matrix[1][col] + matrix[2][col];
			}
		total[6] = matrix[0][0] + matrix[1][1] + matrix[2][2];
		total[7] = matrix[0][2] + matrix[1][1] + matrix[2][0];

		for (row=0; row<8; row++)
			{
			//if (15 == total[row])
			//	{
			//	}
			//else
			if (total[0] != total[row])
				{
				flag += 1;
				row = 8;
				printf ("\nSorry, This is not a magic square.");
				printf ("\nDo you want to continue? ");
				scanf ("%c", &again);
				fflush(stdin);
				if (again == 'Y' || again == 'y')
					{
					}
				else
					null = 0;
				}
			}
		}
	else if (size == 2)
		{
		for (row=0; row<2; row++)
			{
			total[row] = matrix[row][0] + matrix[row][1];
			}
		for (col=0; col<2; col++)
			{
			total[col+2] = matrix[0][col] + matrix[1][col];
			}
		total[4] = matrix[0][0] + matrix[1][1];
		total[5] = matrix[0][1] + matrix[1][0];

		for (row=0; row<6; row++)
			{
			if (total[0] == total[row])
				{
				}
			else
				{
				flag += 1;
				row = 6;
				printf ("\nSorry, This is not a magic square.");
				printf ("\nDo you want to continue? ");
				scanf ("%c", &again);
				fflush(stdin);
				if (again == 'Y' || again == 'y')
					{
					}
				else
					null = 0;
				}
			}
		}
	if (size == 4)
		{
		for (row=0; row<4; row++)
			{
			total[row] = matrix[row][0] + matrix[row][1] + matrix[row][2] + matrix[row][3];
			}
		for (col=0; col<4; col++)
			{
			total[col+4] = matrix[0][col] + matrix[1][col] + matrix[2][col] + matrix[3][col];
			}
		total[8] = matrix[0][0] + matrix[1][1] + matrix[2][2] + matrix[3][3];
		total[9] = matrix[0][3] + matrix[1][2] + matrix[2][1] + matrix[3][0];

		for (row=0; row<10; row++)
			{
			if (total[0] == total[row])
				{
				}
			else
			//if (total[0] != total[row])
				{
				flag += 1;
				row = 10;
				printf ("\nSorry, This is not a magic square.");
				printf ("\nDo you want to continue? ");
				scanf ("%c", &again);
				fflush(stdin);
				if (again == 'Y' || again == 'y')
					{
					}
				else
					null = 0;
				}
			}
		}
	else
		{
		for (row=0; row<size; row++)
			{
			total[row] = matrix[row][0] + matrix[row][1] + matrix[row][2];
			}
		for (col=0; col<size; col++)
			{
			total[col+size] = matrix[0][col] + matrix[1][col] + matrix[2][col];
			}
		total[size+size] = matrix[0][0] + matrix[1][1] + matrix[2][2] + matrix[3][3] + matrix[4][4] + matrix[5][5] + matrix[6][6] + matrix[7][7] + matrix[8][8] + matrix[9][9] + matrix[10][10] + matrix[11][11] + matrix[12][12] + matrix[13][13] + matrix[14][14] + matrix[15][15] + matrix[16][16] + matrix[17][17] + matrix[18][18] + matrix[19][19];
		total[size+size+1] = matrix[0][size] + matrix[1][size-1] + matrix[2][size-2] + matrix[3][size-3] + matrix[4][size-4] + matrix[5][size-5] + matrix[6][size-6] + matrix[7][size-7] + matrix[8][size-8] + matrix[9][size-9] + matrix[10][size-10] + matrix[11][size-11] + matrix[12][size-12] + matrix[13][size-13] + matrix[14][size-14] + matrix[15][size-15] + matrix[16][size-16] + matrix[17][size-17] + matrix[18][size-18] + matrix[19][size-19];

		for (row=0; row<400; row++)
			{
			if (total[0] == total[row] || total[0] == 0)
				{
				}
			else
				{
				flag += 1;
				row = 400;
				printf ("\nSorry, This is not a magic square.");
				printf ("\nDo you want to continue? ");
				scanf ("%c", &again);
				fflush(stdin);
				if (again == 'Y' || again == 'y')
					{
					}
				else
					null = 0;
				}
			}
		}
		if (flag == 0)
			{
			printf ("\nCongragulation!, You have a magic square.\n");
			printf ("The total of this magic square is %d.\n", matrix[0]);
			null = 0;
			}
	Pause ();
	return (null);
	}

Initlize ()
	{
	int row, col;
	for (row=0;row<size;row++)
		{
		for (col=0;col<size;col++)
			{
			matrix [row][col] = 0;
			}
		}
	return 0;
	}

Displayboard ()
	{
	clrscr ();
	printf ("\n\n\n\t\t\t   A 3 X 3 Magic Square\n\n");
	printf ("\t\t\t\t   COLUMN \n");
	printf ("\t\t\t\t  1   2   3 \n\n");
	printf ("\t\t\t       1  %d | %d | %d \n", matrix [0][0], matrix [0][1], matrix [0][2]);
	printf ("\t\t\t   R     ----------- \n");
	printf ("\t\t\t   O   2  %d | %d | %d \n", matrix [1][0], matrix [1][1], matrix [1][2]);
	printf ("\t\t\t   W     ----------- \n");
	printf ("\t\t\t       3  %d | %d | %d \n", matrix [2][0], matrix [2][1], matrix [2][2]);
	printf ("\n\n");
	Pause ();
	getch ();
	fflush (stdin);
	return 0;
	}

Display ()
	{
	clrscr ();
	int row,col;
	printf ("\n\n\tA %d X %d Magic Square\n\n\n", size,size);
	for (row=0; row<size; row++)
		{
		printf ("\t\t\t");
		for (col=0; col<size; col++)
			{
			printf ("%d\t", matrix [row][col]);
			}
		printf ("\n");
		}
	printf ("\n\n");
	return 0;
	}

Getmove ()
	{
	clrscr ();
	int row,col,num;
	printf ("\nEnter in a number in the postion it displays and then press enter.\n");
	printf ("Enter in the numbers for the square : \n\n");
	for (row=0; row<size; row++)
		{
		for (col=0; col<size; col++)
			{
			printf ("Matrix[%d][%d] = ", row+1,col+1);
			scanf ("%d", &num);
			fflush(stdin);
			matrix[row][col] = num;
			}
		}
	return 0;
	}

Getsize ()
	{
	while (size > 1 || size < 21)
		{
		printf ("\n\n\tWhat size of magic square would you like to try? ");
		printf ("\n\t(default 3) (from 2 - 20) : ");
		scanf ("%d", &size);
		if (size < 2 || size > 20)
			{
			printf ("\n\n\tThat is not between 2 and 20!\n");
			printf ("\t\tPlease try again.");
			Pause ();
			}
		else
			{
			break;
			}
		}
	fflush(stdin);
	return size;
	}

Help ()
	{
	clrscr ();
	int num;
	Displayboard ();
	printf ("\nYou enter in numbers from 1 to the number of the square squared.\n");
	printf ("Example. if it where a 3 X 3 square, then 3 squared is 9.\n");
	printf ("You enter in numbers in there given postion.\n");
	printf ("Matrix [1][1] would be in the first postion, enter in a number at\n");
	printf ("Matrix [1][1] = ");
	scanf ("%d", &num);
	matrix [0][0] = num;
	fflush(stdin);
	Displayboard ();
	printf ("\nNow the number you have entered is in row 1, column 1, and stored in \n");
	printf (" position matrix [0][0].\n");
	printf ("If you have any further questions call at 1-800-457-1300 and a \n");
	printf (" charge of $3.00 will be made.\n");
	Pause ();
	return 0;
	}

Start ()
	{
	textcolor (15);
	gotoxy (35,7);
	cprintf ("Magic Squares");

	printf ("\n\n\n\n\tThis is a magic square program witch lets you enter in numbers \n");
	printf ("\tinto a magic square form, to be correct the numbers can never \n");
	printf ("\trepeat them selves.\n");
	printf ("\n\t\t\t8\t1\t6\n\t\t\t3\t5\t7\n\t\t\t4\t9\t2\n");
	printf ("\n\n\tProgramed by Jason Gradziel\n\n\n");
	lowvideo ();
	gotoxy (1,30);
	cprintf ("\nPress any key to Continue...");
	highvideo ();
	while (!kbhit())
		{
		lowvideo ();
		gotoxy (35,7);
		cprintf ("Magic Squares");
		delay (150);
		highvideo ();
		gotoxy (35,7);
		cprintf ("Magic Squares");
		delay (150);
		}
	fflush(stdin);
	return 0;
	}

Exit ()
	{
	clrscr();
	printf ("\n\n\n\n\n\n\n\n\n\t\t     Thank You for playing Magic Squares.\n\n\n\n\n");
	lowvideo ();
	gotoxy (1,30);
	cprintf ("\nPress any key to Continue...");
	highvideo ();
	while (!kbhit())
		{
		lowvideo ();
		gotoxy (35,12);
		cprintf ("Bye-Bye.");
		delay (150);
		highvideo ();
		gotoxy (35,12);
		cprintf ("Bye-Bye.");
		delay (150);
		}
	fflush(stdin);
	return 0;
	}