
		/* Mode 13 Graphics Program */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include <mem.h>

#define VGA256 0x13
#define TEXT 0x03
char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	/* "graphics main prorgam lines" go here */

	int color, pix;
	setMode (VGA256);
	colorScr (24);
	getch();

	for (color=0; color<256; color++)
		{
		for (pix=0; pix<200; pix++)
			{
			putPixel (color, pix, color);
			}
		}

	getch ();
	setMode (TEXT);
	closegraph ();

	return 0;
}