
		/* Mode 13 Graphics & Classes Program */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode//0x4f02
			//mov bx,0x0104
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}
//{ _AL=color; _CX=x; _DX=y; asm { mov ah,0x0c
//		mov bh,0x00
//		int 0x10 } }

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

class ANIMAL
   {
   protected:
	int height, color, h;
	struct POINT {
		int x, y;
		};
	POINT polygon[4];
	//char *pic[2][3];
	//char *pic1[2][4];

   public:
	void set_color(int c);
	void draw(POINT polygon, int xc, int yc);
	//void draw2(int picnum, int x, int y);
   };

class DOG : public ANIMAL
   {
   public:
	DOG();
   };

/*class MAN : public ANIMAL
   {
   public:
	MAN();
   };
*/
DOG :: DOG()
	{
	polygon[0].x = 50;
	polygon[0].y = 50;

	polygon[1].x = 100;
	polygon[1].y = 100;

	polygon[2].x = 50;
	polygon[2].y = 100;

	polygon[3].x = 50;
	polygon[3].y = 50;

	//height = 2;
	//pic[0][0] = "o____/ ";
	//pic[0][1] = "/|  |\\ ";
	//pic[1][0] = "o____/ ";
	//pic[1][1] = " |\\/| ";
	};

/*MAN :: MAN()
	{
	h = 3;
	pic1[0][0] = "  o ";
	pic1[0][1] = " /|\\ ";
	pic1[0][2] = "  | ";
	pic1[1][0] = "  o ";
	pic1[1][1] = "  | ";
	pic1[1][2] = " /\\ ";
	}
*/
void ANIMAL :: set_color(int c)
	{
	color = c;
	};

void ANIMAL :: draw(POINT polygon, int xc, int yc)
	{
	//textcolor(color);
	for (int i=0; i<3; i++)
		Line (xc + polygon[i].x, yc +polygon[i].y, xc+polygon[i+1].x, yc+ polygon[i+1].y, 1);
		//{
		//gotoxy(x, y+i);
		//putPixel (int x, int y, color);
		//cprintf("%s", pic[picnum][i]);
		//}
	};

/*void ANIMAL :: draw2(int picnum, int x, int y)
	{
	textcolor(color);
	for (int i=0; i<h; i++)
		{
		gotoxy(x, y+i);
		cprintf("%s", pic1[picnum][i]);
		}
	};
*/
int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	int color, pix;
	setMode (VGA256);
	//colorScr (112);
	//getch();

	DOG Fido;
	//MAN Bob;
	//DOG Spot;
	//Fido.set_color(BROWN);
	//Spot.set_color(RED);
	//Bob.set_color(YELLOW);
	//_setcursortype(_NOCURSOR);

while ( !kbhit() )
{
	for (int j=0; j<300; j++)
		{
		Fido.draw(polygon, j, 10);
		//for (int i=0; i<2; i++)
			//{
			//Bob.draw2(i, 65-(j+1), 10);
			//Fido.draw(i, 70-(j+1), 10);
			//Spot.draw(i, 70-(j+1), 12);
			delay(100);
			//}

		if (kbhit())
			break;
		}
	clrscr();
}

	setMode (TEXT);
	closegraph ();

	return 0;
}


/*int main ()
{
	clrscr ();
	DOG Fido;
	MAN Bob;
	DOG Spot;
	Fido.set_color(BROWN);
	Spot.set_color(RED);
	Bob.set_color(YELLOW);
	_setcursortype(_NOCURSOR);

while ( !kbhit() )
{
	for (int j=0; j<65; j++)
		{
		for (int i=0; i<2; i++)
			{
			Bob.draw2(i, 65-(j+1), 10);
			Fido.draw(i, 70-(j+1), 10);
			Spot.draw(i, 70-(j+1), 12);
			delay(100);
			}

		if (kbhit())
			break;
		}
	clrscr();
}

	getch();
	return 0;
}
*/