
		/* Mode 13 Graphics & Classes Program */

//#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
//#include <time.h>
//#include <math.h>
//#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color);

void Oval(int x0, int y0, int a, int b, int color);

class ANIMAL
{
	protected:
	int color, numPts;
	struct POINT {
		int x, y;
		};
	POINT polygon[20][7];

	public:
	void set_color(int c);
	void draw(int polynum, int x, int y);
	void erase(int polynum, int x, int y);

};

class DOG : public ANIMAL
{
	public:
	DOG();
};

DOG :: DOG()
{
	numPts = 4;
	polygon[0][0].x = 0;
	polygon[0][0].y = 0;
	polygon[0][1].x = 0;
	polygon[0][1].y = 50;
	polygon[0][2].x = 50;
	polygon[0][2].y = 0;
	polygon[0][3].x = 0;
	polygon[0][3].y = 0;

	polygon[1][0].x = 0;
	polygon[1][0].y = 0;
	polygon[1][1].x = 50;
	polygon[1][1].y = 50;
	polygon[1][2].x = 50;
	polygon[1][2].y = 0;
	polygon[1][3].x = 0;
	polygon[1][3].y = 0;
};

class STAR : public ANIMAL
   {
   public:
	STAR();
   };

STAR :: STAR()
	{
	numPts = 7;
	polygon[0][0].x = 50;
	polygon[0][0].y = 0;
	polygon[0][1].x = 80;
	polygon[0][1].y = 90;
	polygon[0][2].x = 0;
	polygon[0][2].y = 35;
	polygon[0][3].x = 100;
	polygon[0][3].y = 35;
	polygon[0][4].x = 10;
	polygon[0][4].y = 90;
	polygon[0][5].x = 50;
	polygon[0][5].y = 0;
	polygon[0][6].x = 80;
	polygon[0][6].y = 90;

	polygon[1][0].x = 40;
	polygon[1][0].y = 9;
	polygon[1][1].x = 84;
	polygon[1][1].y = 80;
	polygon[1][2].x = 10;
	polygon[1][2].y = 28;
	polygon[1][3].x = 80;
	polygon[1][3].y = 37;
	polygon[1][4].x = 8;
	polygon[1][4].y = 90;
	polygon[1][5].x = 60;
	polygon[1][5].y = 18;
	polygon[1][6].x = 84;
	polygon[1][6].y = 82;

	polygon[2][0].x = 30;
	polygon[2][0].y = 18;
	polygon[2][1].x = 88;
	polygon[2][1].y = 70;
	polygon[2][2].x = 20;
	polygon[2][2].y = 22;
	polygon[2][3].x = 60;
	polygon[2][3].y = 39;
	polygon[2][4].x = 6;
	polygon[2][4].y = 90;
	polygon[2][5].x = 70;
	polygon[2][5].y = 36;
	polygon[2][6].x = 88;
	polygon[2][6].y = 74;

	polygon[3][0].x = 20;
	polygon[3][0].y = 27;
	polygon[3][1].x = 92;
	polygon[3][1].y = 60;
	polygon[3][2].x = 30;
	polygon[3][2].y = 14;
	polygon[3][3].x = 40;
	polygon[3][3].y = 41;
	polygon[3][4].x = 4;
	polygon[3][4].y = 90;
	polygon[3][5].x = 80;
	polygon[3][5].y = 54;
	polygon[3][6].x = 92;
	polygon[3][6].y = 66;

	polygon[4][0].x = 10;
	polygon[4][0].y = 36;
	polygon[4][1].x = 96;
	polygon[4][1].y = 50;
	polygon[4][2].x = 40;
	polygon[4][2].y = 8;
	polygon[4][3].x = 20;
	polygon[4][3].y = 43;
	polygon[4][4].x = 2;
	polygon[4][4].y = 90;
	polygon[4][5].x = 90;
	polygon[4][5].y = 75;
	polygon[4][6].x = 96;
	polygon[4][6].y = 58;

	polygon[5][0].x = 0;
	polygon[5][0].y = 45;
	polygon[5][1].x = 100;
	polygon[5][1].y = 45;
	polygon[5][2].x = 50;
	polygon[5][2].y = 0;
	polygon[5][3].x = 0;
	polygon[5][3].y = 45;
	polygon[5][4].x = 0;
	polygon[5][4].y = 90;
	polygon[5][5].x = 100;
	polygon[5][5].y = 90;
	polygon[5][6].x = 100;
	polygon[5][6].y = 45;

	};

class BOX : public ANIMAL
{
	public:
	  BOX();
};

BOX :: BOX()
{
	numPts = 5;
	polygon[0][0].x = 0;
	polygon[0][0].y = 0;
	polygon[0][1].x = 50;
	polygon[0][1].y = 0;
	polygon[0][2].x = 50;
	polygon[0][2].y = 50;
	polygon[0][3].x = 0;
	polygon[0][3].y = 50;
	polygon[0][4].x = 0;
	polygon[0][4].y = 0;

	polygon[1][0].x = 10;
	polygon[1][0].y = 10;
	polygon[1][1].x = 40;
	polygon[1][1].y = 10;
	polygon[1][2].x = 40;
	polygon[1][2].y = 40;
	polygon[1][3].x = 10;
	polygon[1][3].y = 40;
	polygon[1][4].x = 10;
	polygon[1][4].y = 10;

	polygon[2][0].x = 20;
	polygon[2][0].y = 20;
	polygon[2][1].x = 30;
	polygon[2][1].y = 20;
	polygon[2][2].x = 30;
	polygon[2][2].y = 30;
	polygon[2][3].x = 20;
	polygon[2][3].y = 30;
	polygon[2][4].x = 20;
	polygon[2][4].y = 20;

	polygon[3][0].x = 30;
	polygon[3][0].y = 30;
	polygon[3][1].x = 20;
	polygon[3][1].y = 30;
	polygon[3][2].x = 20;
	polygon[3][2].y = 20;
	polygon[3][3].x = 30;
	polygon[3][3].y = 20;
	polygon[3][4].x = 30;
	polygon[3][4].y = 30;

	polygon[4][0].x = 40;
	polygon[4][0].y = 40;
	polygon[4][1].x = 10;
	polygon[4][1].y = 40;
	polygon[4][2].x = 10;
	polygon[4][2].y = 10;
	polygon[4][3].x = 40;
	polygon[4][3].y = 10;
	polygon[4][4].x = 40;
	polygon[4][4].y = 40;

	polygon[5][0].x = 50;
	polygon[5][0].y = 50;
	polygon[5][1].x = 0;
	polygon[5][1].y = 50;
	polygon[5][2].x = 0;
	polygon[5][2].y = 0;
	polygon[5][3].x = 50;
	polygon[5][3].y = 0;
	polygon[5][4].x = 50;
	polygon[5][4].y = 50;

};

class TRIANGLE : public ANIMAL
   {
   public:
	TRIANGLE();
   };

TRIANGLE :: TRIANGLE()
	{
	numPts = 4;
	polygon[0][0].x = 10;
	polygon[0][0].y = 5;
	polygon[0][1].x = 0;
	polygon[0][1].y = 20;
	polygon[0][2].x = 20;
	polygon[0][2].y = 20;
	polygon[0][3].x = 10;
	polygon[0][3].y = 5;

	polygon[1][0].x = 14;
	polygon[1][0].y = 6;
	polygon[1][1].x = 0;
	polygon[1][1].y = 20;
	polygon[1][2].x = 20;
	polygon[1][2].y = 20;
	polygon[1][3].x = 14;
	polygon[1][3].y = 6;

	polygon[2][0].x = 18;
	polygon[2][0].y = 7;
	polygon[2][1].x = 0;
	polygon[2][1].y = 20;
	polygon[2][2].x = 20;
	polygon[2][2].y = 20;
	polygon[2][3].x = 18;
	polygon[2][3].y = 7;

	polygon[3][0].x = 22;
	polygon[3][0].y = 8;
	polygon[3][1].x = 0;
	polygon[3][1].y = 20;
	polygon[3][2].x = 20;
	polygon[3][2].y = 20;
	polygon[3][3].x = 22;
	polygon[3][3].y = 8;

	polygon[4][0].x = 26;
	polygon[4][0].y = 10;
	polygon[4][1].x = 0;
	polygon[4][1].y = 20;
	polygon[4][2].x = 20;
	polygon[4][2].y = 20;
	polygon[4][3].x = 26;
	polygon[4][3].y = 10;

	polygon[5][0].x = 30;
	polygon[5][0].y = 12;
	polygon[5][1].x = 0;
	polygon[5][1].y = 20;
	polygon[5][2].x = 20;
	polygon[5][2].y = 20;
	polygon[5][3].x = 30;
	polygon[5][3].y = 12;

	polygon[6][0].x = 34;
	polygon[6][0].y = 14;
	polygon[6][1].x = 0;
	polygon[6][1].y = 20;
	polygon[6][2].x = 20;
	polygon[6][2].y = 20;
	polygon[6][3].x = 34;
	polygon[6][3].y = 14;

	polygon[7][0].x = 36;
	polygon[7][0].y = 16;
	polygon[7][1].x = 0;
	polygon[7][1].y = 20;
	polygon[7][2].x = 20;
	polygon[7][2].y = 20;
	polygon[7][3].x = 36;
	polygon[7][3].y = 16;

	polygon[8][0].x = 37;
	polygon[8][0].y = 18;
	polygon[8][1].x = 0;
	polygon[8][1].y = 20;
	polygon[8][2].x = 20;
	polygon[8][2].y = 20;
	polygon[8][3].x = 37;
	polygon[8][3].y = 18;

	polygon[9][0].x = 39;
	polygon[9][0].y = 19;
	polygon[9][1].x = 0;
	polygon[9][1].y = 20;
	polygon[9][2].x = 20;
	polygon[9][2].y = 20;
	polygon[9][3].x = 39;
	polygon[9][3].y = 19;

	polygon[10][0].x = 40;
	polygon[10][0].y = 19;
	polygon[10][1].x = 0;
	polygon[10][1].y = 20;
	polygon[10][2].x = 20;
	polygon[10][2].y = 20;
	polygon[10][3].x = 40;
	polygon[10][3].y = 19;

	polygon[11][0].x = 40;
	polygon[11][0].y = 19;
	polygon[11][1].x = 1;
	polygon[11][1].y = 19;
	polygon[11][2].x = 20;
	polygon[11][2].y = 20;
	polygon[11][3].x = 40;
	polygon[11][3].y = 19;

	polygon[12][0].x = 40;
	polygon[12][0].y = 19;
	polygon[12][1].x = 2;
	polygon[12][1].y = 18;
	polygon[12][2].x = 20;
	polygon[12][2].y = 20;
	polygon[12][3].x = 40;
	polygon[12][3].y = 19;

	polygon[13][0].x = 40;
	polygon[13][0].y = 19;
	polygon[13][1].x = 3;
	polygon[13][1].y = 16;
	polygon[13][2].x = 20;
	polygon[13][2].y = 20;
	polygon[13][3].x = 40;
	polygon[13][3].y = 19;

	polygon[14][0].x = 40;
	polygon[14][0].y = 19;
	polygon[14][1].x = 4;
	polygon[14][1].y = 14;
	polygon[14][2].x = 20;
	polygon[14][2].y = 20;
	polygon[14][3].x = 40;
	polygon[14][3].y = 19;

	polygon[15][0].x = 40;
	polygon[15][0].y = 19;
	polygon[15][1].x = 5;
	polygon[15][1].y = 12;
	polygon[15][2].x = 20;
	polygon[15][2].y = 20;
	polygon[15][3].x = 40;
	polygon[15][3].y = 19;

	polygon[16][0].x = 40;
	polygon[16][0].y = 19;
	polygon[16][1].x = 6;
	polygon[16][1].y = 10;
	polygon[16][2].x = 20;
	polygon[16][2].y = 20;
	polygon[16][3].x = 40;
	polygon[16][3].y = 19;

	polygon[17][0].x = 40;
	polygon[17][0].y = 19;
	polygon[17][1].x = 7;
	polygon[17][1].y = 8;
	polygon[17][2].x = 20;
	polygon[17][2].y = 20;
	polygon[17][3].x = 40;
	polygon[17][3].y = 19;

	polygon[18][0].x = 40;
	polygon[18][0].y = 19;
	polygon[18][1].x = 8;
	polygon[18][1].y = 7;
	polygon[18][2].x = 20;
	polygon[18][2].y = 20;
	polygon[18][3].x = 40;
	polygon[18][3].y = 19;

	polygon[19][0].x = 40;
	polygon[19][0].y = 19;
	polygon[19][1].x = 9;
	polygon[19][1].y = 6;
	polygon[19][2].x = 20;
	polygon[19][2].y = 20;
	polygon[19][3].x = 40;
	polygon[19][3].y = 19;

	};


void ANIMAL :: set_color(int c)
	{
	color = c;
	};

void ANIMAL :: draw(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
	   Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, color);
	};

void ANIMAL :: erase(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
		Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, 0);
	};


int main ()
{
/*	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}
  */
	setMode (VGA256);
	int c;
	//colorScr (112);

	DOG Fido;
	Fido.set_color(113);
	STAR Star;
	Star.set_color(70);
	BOX Box;
	Box.set_color(15);
	TRIANGLE Tri;
	Tri.set_color(15);

   while ( !kbhit() )
	{
	for (int j=0; j<320; j+=6)
	{
		 for (int i=0; i<20; i++)
		 {
		//Oval(j+3*i+25,40,20,20,113);
		//Fido.draw(i%2, j+3*i, 60);
		//Box.set_color(random(c));
		//Star.draw(i, j+20, 70);
		//Box.draw(i, j, 50);
		Tri.draw(i, j, 10);
		delay(100);
		Tri.erase(i, j, 10);
		//Fido.erase(i%2, j+3*i, 60);
		//Oval(j+3*i+25,40,20,20,0);
		//Star.erase(i, j+20, 70);
		//Box.erase(i, j, 50);
		 }
		if (kbhit())
			break;
	}
	}

	setMode (TEXT);
//	closegraph ();

	return 0;
}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

void Oval(int x0, int y0, int a, int b, int color)
{
	int x, y; 		  		// midpoint algorithm is a
	long aSquared, twoAsquared;             // variation on Bresenham
	long bSquared, twoBsquared;
	long d, dx, dy;

	x = 0;
	y = b;
	aSquared = a * a;
	twoAsquared = 2 * aSquared;
	bSquared = b * b;
	twoBsquared = 2 * bSquared;
						// initial excess distance d
	d = bSquared - aSquared * b + aSquared / 4L;

	dx = 0;			      		// initial run and rise
	dy = twoAsquared * b;         		// magnitudes dx and dy

	while (dx < dy) {			// slow slope > -1

		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d > 0) {		  	// midpoint is outside
			--y;              	// go down one line
			dy -= twoAsquared;
			d -= dy;
			++x;
			dx += twoBsquared;
			d += bSquared + dx;
		}
		else {
			++x;		  	// midpoint is inside
			dx += twoBsquared;
			d += bSquared + dx;
		}
	}
						// reset d for fast slope
	d += (3L * (aSquared - bSquared) / 2L - (dx + dy)) / 2L;

	while (y >= 0) {			// fast slope < -1
		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d < 0) {			// midpoint is outside
			++x;
			dx += twoBsquared;
			d += dx;
		}
		--y;				// midpoint is inside
		dy -= twoAsquared;
		d += aSquared - dy;
	}
}
