
		/* Mode 13 Graphics & Classes Program */

//#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
//#include <time.h>
//#include <math.h>
//#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color);

void Oval(int x0, int y0, int a, int b, int color);

class ANIMAL
{
	protected:
	int color, numPts;
	struct POINT {
		int x, y;
		};
	POINT polygon[2][6];

	public:
	void set_color(int c);
	void draw(int polynum, int x, int y);
	void erase(int polynum, int x, int y);

};

class DOG : public ANIMAL
{
	public:
	DOG();
};

DOG :: DOG()
{
	numPts = 4;
	polygon[0][0].x = 0;
	polygon[0][0].y = 0;
	polygon[0][1].x = 0;
	polygon[0][1].y = 50;
	polygon[0][2].x = 50;
	polygon[0][2].y = 0;
	polygon[0][3].x = 0;
	polygon[0][3].y = 0;

	polygon[1][0].x = 0;
	polygon[1][0].y = 0;
	polygon[1][1].x = 50;
	polygon[1][1].y = 50;
	polygon[1][2].x = 50;
	polygon[1][2].y = 0;
	polygon[1][3].x = 0;
	polygon[1][3].y = 0;
};

class STAR : public ANIMAL
   {
   public:
	STAR();
   };

STAR :: STAR()
	{
	numPts = 6;
	polygon[0][0].x = 50;
	polygon[0][0].y = 0;
	polygon[0][1].x = 80;
	polygon[0][1].y = 90;
	polygon[0][2].x = 0;
	polygon[0][2].y = 35;
	polygon[0][3].x = 100;
	polygon[0][3].y = 35;
	polygon[0][4].x = 10;
	polygon[0][4].y = 90;
	polygon[0][5].x = 50;
	polygon[0][5].y = 0;

	polygon[1][0].x = 50;
	polygon[1][0].y = 0;
	polygon[1][1].x = 90;
	polygon[1][1].y = 90;
	polygon[1][2].x = 0;
	polygon[1][2].y = 35;
	polygon[1][3].x = 100;
	polygon[1][3].y = 35;
	polygon[1][4].x = 0;
	polygon[1][4].y = 90;
	polygon[1][5].x = 50;
	polygon[1][5].y = 0;

	};

void ANIMAL :: set_color(int c)
	{
	color = c;
	};

void ANIMAL :: draw(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
	   Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, color);
	};

void ANIMAL :: erase(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
		Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, 0);
	};


int main ()
{
/*	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}
  */
	setMode (VGA256);
	//colorScr (112);

	DOG Fido;
	Fido.set_color(113);
	STAR Star;
	Star.set_color(70);

   while ( !kbhit() )
	{
	for (int j=0; j<320; j+=6)
	{
		 for (int i=0; i<2; i++)
		 {
		Oval(j+3*i+25,40,20,20,113);
		Fido.draw(i, j+3*i, 60);
		Star.draw(i, j-70, 70);
		delay(100);
		Fido.erase(i, j+3*i, 60);
		Oval(j+3*i+25,40,20,20,0);
		Star.erase(i, j-70, 70);
		 }
		if (kbhit())
			break;
	}
	}

	setMode (TEXT);
//	closegraph ();

	return 0;
}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

void Oval(int x0, int y0, int a, int b, int color)
{
	int x, y; 		  		// midpoint algorithm is a
	long aSquared, twoAsquared;             // variation on Bresenham
	long bSquared, twoBsquared;
	long d, dx, dy;

	x = 0;
	y = b;
	aSquared = a * a;
	twoAsquared = 2 * aSquared;
	bSquared = b * b;
	twoBsquared = 2 * bSquared;
						// initial excess distance d
	d = bSquared - aSquared * b + aSquared / 4L;

	dx = 0;			      		// initial run and rise
	dy = twoAsquared * b;         		// magnitudes dx and dy

	while (dx < dy) {			// slow slope > -1

		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d > 0) {		  	// midpoint is outside
			--y;              	// go down one line
			dy -= twoAsquared;
			d -= dy;
			++x;
			dx += twoBsquared;
			d += bSquared + dx;
		}
		else {
			++x;		  	// midpoint is inside
			dx += twoBsquared;
			d += bSquared + dx;
		}
	}
						// reset d for fast slope
	d += (3L * (aSquared - bSquared) / 2L - (dx + dy)) / 2L;

	while (y >= 0) {			// fast slope < -1
		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d < 0) {			// midpoint is outside
			++x;
			dx += twoBsquared;
			d += dx;
		}
		--y;				// midpoint is inside
		dy -= twoAsquared;
		d += aSquared - dy;
	}
}
