
		/* Mode 13 Graphics & Classes Program */

//#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
//#include <time.h>
//#include <math.h>
//#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color);

struct POINT {
	int x, y; };
POINT polygon[4];
POINT polygon2[6];

class ANIMAL
   {
   protected:
	int color, SIZE, SIZE2;

   public:
	void set_color(int c);
	void draw(POINT polygon[], int xc, int yc);
	void erase(POINT polygon[], int xc, int yc);
	void draw2(POINT polygon2[], int xc, int yc);
   };

class TRI : public ANIMAL
   {
   public:
	TRI();
   };

TRI :: TRI()
	{
	SIZE = 3;
	polygon[0].x = 50;
	polygon[0].y = 50;

	polygon[1].x = 100;
	polygon[1].y = 100;

	polygon[2].x = 50;
	polygon[2].y = 100;

	polygon[3].x = 50;
	polygon[3].y = 50;

	};

class STAR : public ANIMAL
   {
   public:
	STAR();
   };

STAR :: STAR()
	{
	SIZE2 = 6;
	polygon2[0].x = 50;
	polygon2[0].y = 0;

	polygon2[1].x = 90;
	polygon2[1].y = 75;

	polygon2[2].x = 0;
	polygon2[2].y = 25;

	polygon2[3].x = 100;
	polygon2[3].y = 25;

	polygon2[4].x = 10;
	polygon2[4].y = 75;

	polygon2[5].x = 50;
	polygon2[5].y = 0;

	};

void ANIMAL :: set_color(int c)
	{
	color = c;
	};

void ANIMAL :: draw(POINT polygon[], int xc, int yc)
	{
	for (int i=0; i<SIZE; i++)
		Line (xc + polygon[i].x, yc + polygon[i].y,
		  xc + polygon[i+1].x, yc + polygon[i+1].y, color);
	};

void ANIMAL :: erase(POINT polygon[], int xc, int yc)
	{
	for (int i=0; i<SIZE; i++)
		Line (xc + polygon[i].x, yc + polygon[i].y,
		  xc + polygon[i+1].x, yc + polygon[i+1].y, 0);
	};

void ANIMAL :: draw2(POINT polygon2[], int xc, int yc)
	{
	for (int i=0; i<SIZE2; i++)
		Line (xc + polygon2[i].x, yc + polygon2[i].y,
		  xc + polygon2[i+1].x, yc + polygon2[i+1].y, color);
	};

int main ()
{

	setMode (VGA256);
	//colorScr (112);

	TRI Triangle;
	//Triangle.set_color(112);
	STAR Star;
	Star.set_color(YELLOW);

   while ( !kbhit() )
   {
	for (int j=0; j<300; j++)
		{
		Triangle.set_color(j);
		Triangle.draw(polygon, j, 10);
		//Star.draw2(polygon2, j, 10);
		delay(75);
		//Triangle.erase(polygon, j, 10);
		colorScr(0);

		if (kbhit())
			break;
		}
   }

	setMode (TEXT);
//	closegraph ();

	return 0;
}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}
