		/* Structures and Functions Program */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <math.h>

typedef struct
{
	int x, y;
} POINT;
void transPoint (POINT point);
void transPoly (int N, POINT array []);
void drawPoly (int N, POINT array []);

int xc, yc;
float SF = 1.05;
float ANG = 0.1;

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\tclite\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk){
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
	}

	/* "graphics main prorgam lines" go here */

	int i, xmax, ymax;
	xmax = getmaxx();
	ymax = getmaxy();
	xc = xmax / 2;
	yc = ymax / 2;
	const Npts = 5;
	POINT polygon [] =
	{ {-10, 10}, {10, 10}, {10, -10}, {-10, -10}, {-10, 10} };

	setcolor (YELLOW);
	drawPoly (Npts, polygon);

	for (i = 0; i < 100; i++)
	{
		transPoly (Npts, polygon);
		drawPoly (Npts, polygon);
	}

	setcolor (WHITE);
	line (0, getmaxy() / 2, getmaxx(), getmaxy() / 2);
	line (getmaxx() / 2, 0, getmaxx() / 2, getmaxy());

	getch ();
	closegraph ();
	return 0;
}

void transPoint (POINT *point, float SF, float ANG)
{
	float temp;
	temp = SF* (cos (ANG) *point -> x - sin (ANG) *point -> y);
	point -> y = SF* (sin (ANG) *point -> x + cos (ANG) *point -> y);
	point -> x = temp;
}

void transPoly (int N, POINT array[])
{
	int i;
	for (i = 0; i < N; i++){
		transPoint (&array [i], SF, ANG);}
}

void drawPoly (int N, POINT array [])
{
	int i;
	moveto (xc + array [0] .x, yc - array [0] .y);
	for (i = 1; i < N; i++){
		lineto (xc + array [i] .x, yc - array [i] .y);}
}