
		/* Build Ship Program */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s\n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	/* "graphics main prorgam lines" go here */

	randomize;
	//int MaxX, MaxY;
	//MaxX = 320;
	//MaxY = 200;

	int MaxX, MaxY, MaxColors;
	MaxX = getmaxx();
	MaxY = getmaxy();

	static int r	  = 20;
	static int StartX = 100;
	static int StartY = 50;

	struct viewporttype vp;
	//struct viewporttype vp2;
	int PauseTime, x, y, ulx, uly, lrx, lry,
	size, size2, i, width, height, step, y1, x1;
	void *Saucer;
	void *TyFighter;

	//setMode (VGA256);
	//colorScr (112);
	//Line (0, 0, maxx, maxy, 15);

	getviewsettings( &vp );
	setcolor(15);
	circle(StartX, StartY, r-5);				//main circle
	ellipse(StartX-22, StartY-8, 200, 0, 8, 4);		//left side of attachment
	ellipse(StartX-22, StartY+8, 0, 160, 8, 4);
	ellipse(StartX+22, StartY-8, 180, 340, 8, 4);		//right side of attachment
	ellipse(StartX+22, StartY+8, 20, 180, 8, 4);
	line(StartX-30, StartY-20, StartX-30, StartY+20);	//left side wing
	line(StartX-30, StartY-20, StartX-32, StartY-22);
	line(StartX-32, StartY-22, StartX-34, StartY-20);
	line(StartX-30, StartY+20, StartX-32, StartY+22);
	line(StartX-32, StartY+22, StartX-34, StartY+20);
	line(StartX-34, StartY-20, StartX-34, StartY+20);
	setcolor(1);
	line(StartX-32, StartY-6, StartX-32, StartY+6);
	setcolor(15);
	line(StartX+30, StartY-20, StartX+30, StartY+20);	//right side wing
	line(StartX+30, StartY-20, StartX+32, StartY-22);
	line(StartX+32, StartY-22, StartX+34, StartY-20);
	line(StartX+30, StartY+20, StartX+32, StartY+22);
	line(StartX+32, StartY+22, StartX+34, StartY+20);
	line(StartX+34, StartY-20, StartX+34, StartY+20);
	setcolor(1);
	line(StartX+32, StartY-6, StartX+32, StartY+6);
	setcolor(7);
	circle(StartX, StartY, 7);				//window
	circle(StartX, StartY, 1);
	line(StartX-1, StartY, StartX-7, StartY);
	line(StartX+1, StartY, StartX+7, StartY);
	line(StartX, StartY, StartX-5, StartY-5);
	line(StartX, StartY, StartX+5, StartY+5);
	line(StartX, StartY, StartX-5, StartY+5);
	line(StartX, StartY, StartX+5, StartY-5);
	setcolor(1);
	ellipse(StartX-23, StartY-4, 270, 0, 7, 4);		//left side decal
	ellipse(StartX-23, StartY+4, 0, 90, 7, 4);
	ellipse(StartX+23, StartY-4, 180, 270, 7, 4);		//right side decal
	ellipse(StartX+23, StartY+4, 90, 180, 7, 4);
	setcolor(14);
	line(StartX, StartY-15, StartX, StartY-17);		//lights on ship
	setcolor(4);
	line(StartX-8, StartY+14, StartX-8, StartY+16);
	setcolor(2);
	line(StartX+8, StartY+14, StartX+8, StartY+16);

	/* Read saucer image */
	ulx = StartX-(r+14);
	uly = StartY-22;
	lrx = StartX+(r+14);
	lry = StartY+(r/3)+16;
	width = lrx - ulx + 1;
	height = lry - uly + 1;
	size2 = imagesize(ulx, uly, lrx, lry);

	TyFighter = malloc( size2 );
	getimage(ulx, uly, lrx, lry, TyFighter);
	putimage(ulx, uly, TyFighter, XOR_PUT);

	setfillstyle( SOLID_FILL, getmaxcolor() );		//main part
	setcolor(15);
	ellipse(StartX, StartY, 0, 360, r, (r/3)+2);
	fillellipse(StartX, StartY, r, (r/3)+2);
	line(StartX+7, StartY+7, StartX+12, StartY+13);		//Bellow wheels
	setcolor(7);
	setfillstyle( SOLID_FILL, 7);
	fillellipse(StartX+12, StartY+13, 2, 2);
	//circle(StartX+12, StartY+13, 2);
	setcolor(15);
	line(StartX-7, StartY+7, StartX-12, StartY+13);
	setcolor(7);
	setfillstyle( SOLID_FILL, 7);
	fillellipse(StartX-12, StartY+13, 2, 2);
	//circle(StartX-12, StartY+13, 2);
	line(StartX, StartY-8, StartX, StartY-15);		//entena on top
	setcolor(14);
	circle(StartX, StartY-15, 1);
	setcolor(15);
	line(StartX-4, StartY-15, StartX-5, StartY-15);		// line around entena
	line(StartX+4, StartY-15, StartX+5, StartY-15);
	line(StartX, StartY-19, StartX, StartY-20);
	line(StartX-3, StartY-17, StartX-4, StartY-18);
	line(StartX+3, StartY-17, StartX+4, StartY-18);
	line(StartX-23, StartY, StartX-20, StartY);		//lines on the side
	line(StartX+20, StartY, StartX+23, StartY);
	setcolor(8);
	setfillstyle( SOLID_FILL, 8);
	fillellipse(StartX-6, StartY-3, 3, 2);			// eyes
	fillellipse(StartX+6, StartY-3, 3, 2);
	setcolor(4);
	ellipse(StartX-6, StartY-3, 0, 360, 1, 1);		// iner eyes
	ellipse(StartX+6, StartY-3, 0, 360, 1, 1);
	setcolor(8);
	ellipse(StartX, StartY+2, 200, 340, 8, 2);		//mouth


	/* Read saucer image */
	ulx = StartX-(r+14);
	uly = StartY-22;
	lrx = StartX+(r+14);
	lry = StartY+(r/3)+16;
	width = lrx - ulx + 1;
	height = lry - uly + 1;
	size = imagesize(ulx, uly, lrx, lry);

	Saucer = malloc( size );
	getimage(ulx, uly, lrx, lry, Saucer);
	putimage(ulx, uly, Saucer, XOR_PUT);



	x = MaxX/2-40;
	y = MaxY/2;
	x1 = MaxX/2+40;
	y1 = MaxY/2;
	//y1 = random(MaxY/2+100);
	//PauseTime = 0;


	/* until a key is hit */
	//while ( !kbhit() ) {

	/* Draw the Saucer */
	putimage(x, y, Saucer, COPY_PUT);	     /*  draw image  */
	putimage(x1, y1, TyFighter, COPY_PUT);	     /*  draw image  */
	//delay(PauseTime);
	//delay (30);
	//putimage(x, y, Saucer, XOR_PUT);	      /* erase image  */

	/* Move Saucer */
	//x--;

	//for (i=0; i<1; i++ )
	//delay (1);
	/*
	if (x <= 0)
	{
	//return 0;
	x = getmaxx();
	}
	*/

	/*step = random( 2*r );
	if ((step/2) % 2 != 0 )
		step = -1 * step;
	x = x + step;
	step = random( r );
	if ((step/2) % 2 != 0 )
		step = -1 * step;
	y = y + step;
	*/
	/*
	if (vp.left + x + width - 1 > vp.right)
		x = vp.right-vp.left-width + 1;
	else
		if (x < 0)
			x = 0;
		if (vp.top + y + height - 1 > vp.bottom)
			y = vp.bottom-vp.top-height + 1;
		else
			if (y < 0)
				y = 0;
	*/
	//}
	free( Saucer );
	free( TyFighter );
	getch ();
	//setMode (TEXT);
	closegraph ();
	return 0;
}