
		/* Mode 13 Graphics Program with Line
			and others */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03
char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "c:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	/* "graphics main prorgam lines" go here */

	int color, pix;
	setMode (VGA256);
	colorScr (24);
	getch();
	int x1=0,y1,x2=0,y2,c=0;

	while (!kbhit())
	{
	y1 = 0;
	y2 = 200;
	//x1 = random (320);
	//y1 = random (200);
	//x2 = random (320);
	//y2 = random (200);
	//c = random (255);

	Line (x1, y1, x2, y2, c);
	x1++;
	x2++;
	c++;
	//delay (100);
	}
	//for (color=0; color<256; color++)
	  //	{
	    //	for (pix=0; pix<200; pix++)
	     //		{
	     //		putPixel (color, pix, color);
	       //		}
	       //	}

	getch ();
	setMode (TEXT);
	closegraph ();

	return 0;
}