
		/* Bitmap Graphics Program with Line */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>

#define VGA256 0x13
#define TEXT 0x03

void setMode (int mode)
{
asm	{	mov ax, mode
		int 0x10	}
}

unsigned char far *videoBuffer = (unsigned char far *) 0xA0000000L;

void putPixel (int x, int y, int color)
{
	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;
}

void Draw_Line (int x0, int y0, int x1, int y1, unsigned char color)
{
int dx, dy, x_inc, y_inc, error=0, index;

unsigned char far *vb_start = videoBuffer;

vb_start = vb_start + ((unsigned int) y0<<6) +
		      ((unsigned int) y0<<8) +
		      (unsigned int) x0;

dx = x1 - x0;
dy = y1 - y0;

if (dx>=0)
	{
	x_inc = 1;
	}
else
	{
	x_inc = -1;
	dx = -dx;
	}

if (dy>=0)
	{
	y_inc = 320;
	}
else
	{
	y_inc = -320;
	dy = -dy;
	}

if (dx>dy)
	{
	for (index=0; index<=dx; index++)
		{
		*vb_start = color;
		error += dy;
		if (error>dx)
			{
			error -= dx;
			vb_start += y_inc;
			}
		vb_start += x_inc;
		}
	}
else
	{
	for (index=0; index<=dy; index++)
		{
		*vb_start = color;
		error += dx;
		if (error>0)
			{
			error -= dy;
			vb_start += x_inc;
			}
		vb_start += y_inc;
		}
	}
}

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	/* "graphics main prorgam lines" go here */

	int color, j;
	setMode (VGA256);

	for (color=0; color<256; color++)
		{
		for (j=0; j<200; j++)
			{
			putPixel (color, j, color);
			}
		}

	Draw_Line (0, 0, 320, 200, 16);

	getch ();
	setMode (TEXT);
	closegraph ();

	return 0;
}