
		/* ISU test project */

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include <mem.h>
#include <dos.h>

#define VGA256 0x13
#define TEXT 0x03

char far *videoBuffer = (char far *) 0xA0000000L;

void setMode (int mode)
{	asm	{	mov ax, mode
			int 0x10	}	}

void putPixel (int x, int y, int color)
{	videoBuffer [((y<<8) + (y<<6)) + x] = (unsigned char) color;	}

void colorScr (int color)
{	_fmemset (videoBuffer, color, 64000L);	}

void Line (int x1, int y1, int x2, int y2, int color);

void Oval(int x0, int y0, int a, int b, int color);



class ANIMAL
{
	protected:
	int color, numPts;
	struct POINT {
		int x, y;
		};
	POINT polygon[20][7];

	public:
	void set_color(int c);
	void draw(int polynum, int x, int y);
	void erase(int polynum, int x, int y);

};

class DOG : public ANIMAL
{
	public:
	DOG();
};

DOG :: DOG()
{
	numPts = 4;
	polygon[0][0].x = 0;
	polygon[0][0].y = 0;
	polygon[0][1].x = 0;
	polygon[0][1].y = 50;
	polygon[0][2].x = 50;
	polygon[0][2].y = 0;
	polygon[0][3].x = 0;
	polygon[0][3].y = 0;

	polygon[1][0].x = 0;
	polygon[1][0].y = 0;
	polygon[1][1].x = 50;
	polygon[1][1].y = 50;
	polygon[1][2].x = 50;
	polygon[1][2].y = 0;
	polygon[1][3].x = 0;
	polygon[1][3].y = 0;
};

class STAR2 : public ANIMAL
   {
   public:
	STAR2();
   };

STAR2 :: STAR2()
	{
	numPts = 6;
	polygon[0][0].x = 50;
	polygon[0][0].y = 0;
	polygon[0][1].x = 80;
	polygon[0][1].y = 90;
	polygon[0][2].x = 0;
	polygon[0][2].y = 35;
	polygon[0][3].x = 100;
	polygon[0][3].y = 35;
	polygon[0][4].x = 10;
	polygon[0][4].y = 90;
	polygon[0][5].x = 50;
	polygon[0][5].y = 0;

	polygon[1][0].x = 50;
	polygon[1][0].y = 5;
	polygon[1][1].x = 82;
	polygon[1][1].y = 80;
	polygon[1][2].x = 12;
	polygon[1][2].y = 40;
	polygon[1][3].x = 89;
	polygon[1][3].y = 33;
	polygon[1][4].x = 8;
	polygon[1][4].y = 88;
	polygon[1][5].x = 50;
	polygon[1][5].y = 5;

	polygon[2][0].x = 50;
	polygon[2][0].y = 10;
	polygon[2][1].x = 84;
	polygon[2][1].y = 74;
	polygon[2][2].x = 23;
	polygon[2][2].y = 45;
	polygon[2][3].x = 78;
	polygon[2][3].y = 31;
	polygon[2][4].x = 7;
	polygon[2][4].y = 87;
	polygon[2][5].x = 50;
	polygon[2][5].y = 10;

	polygon[3][0].x = 50;
	polygon[3][0].y = 15;
	polygon[3][1].x = 86;
	polygon[3][1].y = 68;
	polygon[3][2].x = 34;
	polygon[3][2].y = 50;
	polygon[3][3].x = 67;
	polygon[3][3].y = 29;
	polygon[3][4].x = 6;
	polygon[3][4].y = 86;
	polygon[3][5].x = 50;
	polygon[3][5].y = 15;

	polygon[4][0].x = 50;
	polygon[4][0].y = 20;
	polygon[4][1].x = 88;
	polygon[4][1].y = 60;
	polygon[4][2].x = 45;
	polygon[4][2].y = 55;
	polygon[4][3].x = 56;
	polygon[4][3].y = 27;
	polygon[4][4].x = 5;
	polygon[4][4].y = 85;
	polygon[4][5].x = 50;
	polygon[4][5].y = 20;

	polygon[5][0].x = 50;
	polygon[5][0].y = 25;
	polygon[5][1].x = 90;
	polygon[5][1].y = 52;
	polygon[5][2].x = 56;
	polygon[5][2].y = 60;
	polygon[5][3].x = 45;
	polygon[5][3].y = 25;
	polygon[5][4].x = 4;
	polygon[5][4].y = 84;
	polygon[5][5].x = 50;
	polygon[5][5].y = 25;

	polygon[6][0].x = 50;
	polygon[6][0].y = 32;
	polygon[6][1].x = 92;
	polygon[6][1].y = 44;
	polygon[6][2].x = 67;
	polygon[6][2].y = 65;
	polygon[6][3].x = 34;
	polygon[6][3].y = 23;
	polygon[6][4].x = 3;
	polygon[6][4].y = 83;
	polygon[6][5].x = 50;
	polygon[6][5].y = 32;

	polygon[7][0].x = 50;
	polygon[7][0].y = 38;
	polygon[7][1].x = 94;
	polygon[7][1].y = 36;
	polygon[7][2].x = 78;
	polygon[7][2].y = 70;
	polygon[7][3].x = 23;
	polygon[7][3].y = 22;
	polygon[7][4].x = 2;
	polygon[7][4].y = 82;
	polygon[7][5].x = 50;
	polygon[7][5].y = 38;

	polygon[8][0].x = 50;
	polygon[8][0].y = 44;
	polygon[8][1].x = 97;
	polygon[8][1].y = 28;
	polygon[8][2].x = 89;
	polygon[8][2].y = 75;
	polygon[8][3].x = 12;
	polygon[8][3].y = 21;
	polygon[8][4].x = 1;
	polygon[8][4].y = 81;
	polygon[8][5].x = 50;
	polygon[8][5].y = 44;

	polygon[9][0].x = 50;
	polygon[9][0].y = 50;
	polygon[9][1].x = 100;
	polygon[9][1].y = 20;
	polygon[9][2].x = 100;
	polygon[9][2].y = 80;
	polygon[9][3].x = 0;
	polygon[9][3].y = 20;
	polygon[9][4].x = 0;
	polygon[9][4].y = 80;
	polygon[9][5].x = 50;
	polygon[9][5].y = 50;

	polygon[10][0].x = 50;
	polygon[10][0].y = 44;
	polygon[10][1].x = 97;
	polygon[10][1].y = 28;
	polygon[10][2].x = 89;
	polygon[10][2].y = 75;
	polygon[10][3].x = 12;
	polygon[10][3].y = 21;
	polygon[10][4].x = 1;
	polygon[10][4].y = 81;
	polygon[10][5].x = 50;
	polygon[10][5].y = 44;

	polygon[11][0].x = 50;
	polygon[11][0].y = 38;
	polygon[11][1].x = 94;
	polygon[11][1].y = 36;
	polygon[11][2].x = 78;
	polygon[11][2].y = 70;
	polygon[11][3].x = 23;
	polygon[11][3].y = 22;
	polygon[11][4].x = 2;
	polygon[11][4].y = 82;
	polygon[11][5].x = 50;
	polygon[11][5].y = 38;

	polygon[12][0].x = 50;
	polygon[12][0].y = 32;
	polygon[12][1].x = 92;
	polygon[12][1].y = 44;
	polygon[12][2].x = 67;
	polygon[12][2].y = 65;
	polygon[12][3].x = 34;
	polygon[12][3].y = 23;
	polygon[12][4].x = 3;
	polygon[12][4].y = 83;
	polygon[12][5].x = 50;
	polygon[12][5].y = 32;

	polygon[13][0].x = 50;
	polygon[13][0].y = 25;
	polygon[13][1].x = 90;
	polygon[13][1].y = 52;
	polygon[13][2].x = 56;
	polygon[13][2].y = 60;
	polygon[13][3].x = 45;
	polygon[13][3].y = 25;
	polygon[13][4].x = 4;
	polygon[13][4].y = 84;
	polygon[13][5].x = 50;
	polygon[13][5].y = 25;

	polygon[14][0].x = 50;
	polygon[14][0].y = 20;
	polygon[14][1].x = 88;
	polygon[14][1].y = 60;
	polygon[14][2].x = 45;
	polygon[14][2].y = 55;
	polygon[14][3].x = 56;
	polygon[14][3].y = 27;
	polygon[14][4].x = 5;
	polygon[14][4].y = 85;
	polygon[14][5].x = 50;
	polygon[14][5].y = 20;

	polygon[15][0].x = 50;
	polygon[15][0].y = 15;
	polygon[15][1].x = 86;
	polygon[15][1].y = 68;
	polygon[15][2].x = 34;
	polygon[15][2].y = 50;
	polygon[15][3].x = 67;
	polygon[15][3].y = 29;
	polygon[15][4].x = 6;
	polygon[15][4].y = 86;
	polygon[15][5].x = 50;
	polygon[15][5].y = 15;

	polygon[16][0].x = 50;
	polygon[16][0].y = 10;
	polygon[16][1].x = 84;
	polygon[16][1].y = 74;
	polygon[16][2].x = 23;
	polygon[16][2].y = 45;
	polygon[16][3].x = 78;
	polygon[16][3].y = 31;
	polygon[16][4].x = 7;
	polygon[16][4].y = 87;
	polygon[16][5].x = 50;
	polygon[16][5].y = 10;

	polygon[17][0].x = 50;
	polygon[17][0].y = 5;
	polygon[17][1].x = 82;
	polygon[17][1].y = 80;
	polygon[17][2].x = 12;
	polygon[17][2].y = 40;
	polygon[17][3].x = 89;
	polygon[17][3].y = 33;
	polygon[17][4].x = 8;
	polygon[17][4].y = 88;
	polygon[17][5].x = 50;
	polygon[17][5].y = 5;


	};

class STAR : public ANIMAL
   {
   public:
	STAR();
   };

STAR :: STAR()
	{
	numPts = 7;
	polygon[0][0].x = 50;
	polygon[0][0].y = 0;
	polygon[0][1].x = 80;
	polygon[0][1].y = 90;
	polygon[0][2].x = 0;
	polygon[0][2].y = 35;
	polygon[0][3].x = 100;
	polygon[0][3].y = 35;
	polygon[0][4].x = 10;
	polygon[0][4].y = 90;
	polygon[0][5].x = 50;
	polygon[0][5].y = 0;
	polygon[0][6].x = 80;
	polygon[0][6].y = 90;

	polygon[1][0].x = 40;
	polygon[1][0].y = 9;
	polygon[1][1].x = 84;
	polygon[1][1].y = 80;
	polygon[1][2].x = 10;
	polygon[1][2].y = 28;
	polygon[1][3].x = 80;
	polygon[1][3].y = 37;
	polygon[1][4].x = 8;
	polygon[1][4].y = 90;
	polygon[1][5].x = 60;
	polygon[1][5].y = 18;
	polygon[1][6].x = 84;
	polygon[1][6].y = 82;

	polygon[2][0].x = 30;
	polygon[2][0].y = 18;
	polygon[2][1].x = 88;
	polygon[2][1].y = 70;
	polygon[2][2].x = 20;
	polygon[2][2].y = 22;
	polygon[2][3].x = 60;
	polygon[2][3].y = 39;
	polygon[2][4].x = 6;
	polygon[2][4].y = 90;
	polygon[2][5].x = 70;
	polygon[2][5].y = 36;
	polygon[2][6].x = 88;
	polygon[2][6].y = 74;

	polygon[3][0].x = 20;
	polygon[3][0].y = 27;
	polygon[3][1].x = 92;
	polygon[3][1].y = 60;
	polygon[3][2].x = 30;
	polygon[3][2].y = 14;
	polygon[3][3].x = 40;
	polygon[3][3].y = 41;
	polygon[3][4].x = 4;
	polygon[3][4].y = 90;
	polygon[3][5].x = 80;
	polygon[3][5].y = 54;
	polygon[3][6].x = 92;
	polygon[3][6].y = 66;

	polygon[4][0].x = 10;
	polygon[4][0].y = 36;
	polygon[4][1].x = 96;
	polygon[4][1].y = 50;
	polygon[4][2].x = 40;
	polygon[4][2].y = 8;
	polygon[4][3].x = 20;
	polygon[4][3].y = 43;
	polygon[4][4].x = 2;
	polygon[4][4].y = 90;
	polygon[4][5].x = 90;
	polygon[4][5].y = 75;
	polygon[4][6].x = 96;
	polygon[4][6].y = 58;

	polygon[5][0].x = 0;
	polygon[5][0].y = 45;
	polygon[5][1].x = 100;
	polygon[5][1].y = 45;
	polygon[5][2].x = 50;
	polygon[5][2].y = 0;
	polygon[5][3].x = 0;
	polygon[5][3].y = 45;
	polygon[5][4].x = 0;
	polygon[5][4].y = 90;
	polygon[5][5].x = 100;
	polygon[5][5].y = 90;
	polygon[5][6].x = 100;
	polygon[5][6].y = 45;

	};

class BOX : public ANIMAL
{
	public:
	  BOX();
};

BOX :: BOX()
{
	numPts = 5;
	int i;
	for (i=0; i<10; i++)
	{
	polygon[i][0].x = 0;
	polygon[i][0].y = i;
	polygon[i][1].x = 20;
	polygon[i][1].y = i;
	polygon[i][2].x = 20;
	polygon[i][2].y = 20-i;
	polygon[i][3].x = 0;
	polygon[i][3].y = 20-i;
	polygon[i][4].x = 0;
	polygon[i][4].y = i;
	}
	for (i=10; i<20; i++)
	{
	polygon[i][0].x = 0;
	polygon[i][0].y = 20-i;
	polygon[i][1].x = 20;
	polygon[i][1].y = 20-i;
	polygon[i][2].x = 20;
	polygon[i][2].y = i;
	polygon[i][3].x = 0;
	polygon[i][3].y = i;
	polygon[i][4].x = 0;
	polygon[i][4].y = 20-i;
	}

};

class BOX2 : public ANIMAL
{
	public:
	  BOX2();
};

BOX2 :: BOX2()
{
	numPts = 5;
	int i;
	for (i=0; i<10; i++)
	{
	polygon[i][0].x = i*2;
	polygon[i][0].y = 0;
	polygon[i][1].x = 20;
	polygon[i][1].y = 0;
	polygon[i][2].x = 20;
	polygon[i][2].y = 20;
	polygon[i][3].x = i*2;
	polygon[i][3].y = 20;
	polygon[i][4].x = i*2;
	polygon[i][4].y = 0;
	}
	for (i=10; i<20; i++)
	{
	polygon[i][0].x = 20;
	polygon[i][0].y = 0;
	polygon[i][1].x = 20+i;
	polygon[i][1].y = 0;
	polygon[i][2].x = 20+i;
	polygon[i][2].y = 20;
	polygon[i][3].x = 20;
	polygon[i][3].y = 20;
	polygon[i][4].x = 20;
	polygon[i][4].y = 0;
	}

};

class BOX3 : public ANIMAL
{
	public:
	  BOX3();
};

BOX3 :: BOX3()
{
	numPts = 5;
	int i;
	for (i=0; i<10; i++)
	{
	polygon[i][0].x = i*2;
	polygon[i][0].y = 0;
	polygon[i][1].x = 20-(i*2);
	polygon[i][1].y = 20;
	polygon[i][2].x = i*2;
	polygon[i][2].y = 20;
	polygon[i][3].x = 20-(i*2);
	polygon[i][3].y = 0;
	polygon[i][4].x = i*2;
	polygon[i][4].y = 0;
	}
	for (i=0; i<10; i++)
	{
	polygon[i+10][0].x = 20-(i*2);
	polygon[i+10][0].y = 0;
	polygon[i+10][1].x = i*2;
	polygon[i+10][1].y = 20;
	polygon[i+10][2].x = 20-(i*2);
	polygon[i+10][2].y = 20;
	polygon[i+10][3].x = i*2;
	polygon[i+10][3].y = 0;
	polygon[i+10][4].x = 20-(i*2);
	polygon[i+10][4].y = 0;
	}

};

class BOX4 : public ANIMAL
{
	public:
	  BOX4();
};

BOX4 :: BOX4()
{
	numPts = 5;
	int i;
	for (i=0; i<10; i++)
	{
	polygon[i][0].x = i*2;
	polygon[i][0].y = 0;
	polygon[i][1].x = 20;
	polygon[i][1].y = 20;
	polygon[i][2].x = 0;
	polygon[i][2].y = 20;
	polygon[i][3].x = 20-(i*2);
	polygon[i][3].y = 0;
	polygon[i][4].x = i*2;
	polygon[i][4].y = 0;
	}
	for (i=0; i<10; i++)
	{
	polygon[i+10][0].x = 20-(i*2);
	polygon[i+10][0].y = 0;
	polygon[i+10][1].x = 20;
	polygon[i+10][1].y = 20;
	polygon[i+10][2].x = 0;
	polygon[i+10][2].y = 20;
	polygon[i+10][3].x = i*2;
	polygon[i+10][3].y = 0;
	polygon[i+10][4].x = 20-(i*2);
	polygon[i+10][4].y = 0;
	}

};

class TRIANGLE : public ANIMAL
   {
   public:
	TRIANGLE();
   };

TRIANGLE :: TRIANGLE()
	{
	numPts = 4;
	polygon[0][0].x = 10;
	polygon[0][0].y = 5;
	polygon[0][1].x = 0;
	polygon[0][1].y = 20;
	polygon[0][2].x = 20;
	polygon[0][2].y = 20;
	polygon[0][3].x = 10;
	polygon[0][3].y = 5;

	polygon[1][0].x = 14;
	polygon[1][0].y = 6;
	polygon[1][1].x = 0;
	polygon[1][1].y = 20;
	polygon[1][2].x = 20;
	polygon[1][2].y = 20;
	polygon[1][3].x = 14;
	polygon[1][3].y = 6;

	polygon[2][0].x = 18;
	polygon[2][0].y = 7;
	polygon[2][1].x = 0;
	polygon[2][1].y = 20;
	polygon[2][2].x = 20;
	polygon[2][2].y = 20;
	polygon[2][3].x = 18;
	polygon[2][3].y = 7;

	polygon[3][0].x = 22;
	polygon[3][0].y = 8;
	polygon[3][1].x = 0;
	polygon[3][1].y = 20;
	polygon[3][2].x = 20;
	polygon[3][2].y = 20;
	polygon[3][3].x = 22;
	polygon[3][3].y = 8;

	polygon[4][0].x = 26;
	polygon[4][0].y = 10;
	polygon[4][1].x = 0;
	polygon[4][1].y = 20;
	polygon[4][2].x = 20;
	polygon[4][2].y = 20;
	polygon[4][3].x = 26;
	polygon[4][3].y = 10;

	polygon[5][0].x = 30;
	polygon[5][0].y = 12;
	polygon[5][1].x = 0;
	polygon[5][1].y = 20;
	polygon[5][2].x = 20;
	polygon[5][2].y = 20;
	polygon[5][3].x = 30;
	polygon[5][3].y = 12;

	polygon[6][0].x = 34;
	polygon[6][0].y = 14;
	polygon[6][1].x = 0;
	polygon[6][1].y = 20;
	polygon[6][2].x = 20;
	polygon[6][2].y = 20;
	polygon[6][3].x = 34;
	polygon[6][3].y = 14;

	polygon[7][0].x = 36;
	polygon[7][0].y = 16;
	polygon[7][1].x = 0;
	polygon[7][1].y = 20;
	polygon[7][2].x = 20;
	polygon[7][2].y = 20;
	polygon[7][3].x = 36;
	polygon[7][3].y = 16;

	polygon[8][0].x = 37;
	polygon[8][0].y = 18;
	polygon[8][1].x = 0;
	polygon[8][1].y = 20;
	polygon[8][2].x = 20;
	polygon[8][2].y = 20;
	polygon[8][3].x = 37;
	polygon[8][3].y = 18;

	polygon[9][0].x = 39;
	polygon[9][0].y = 19;
	polygon[9][1].x = 0;
	polygon[9][1].y = 20;
	polygon[9][2].x = 20;
	polygon[9][2].y = 20;
	polygon[9][3].x = 39;
	polygon[9][3].y = 19;

	polygon[10][0].x = 40;
	polygon[10][0].y = 19;
	polygon[10][1].x = 3;
	polygon[10][1].y = 20;
	polygon[10][2].x = 20;
	polygon[10][2].y = 20;
	polygon[10][3].x = 40;
	polygon[10][3].y = 19;

	polygon[11][0].x = 40;
	polygon[11][0].y = 19;
	polygon[11][1].x = 6;
	polygon[11][1].y = 19;
	polygon[11][2].x = 20;
	polygon[11][2].y = 20;
	polygon[11][3].x = 40;
	polygon[11][3].y = 19;

	polygon[12][0].x = 40;
	polygon[12][0].y = 19;
	polygon[12][1].x = 9;
	polygon[12][1].y = 18;
	polygon[12][2].x = 20;
	polygon[12][2].y = 20;
	polygon[12][3].x = 40;
	polygon[12][3].y = 19;

	polygon[13][0].x = 40;
	polygon[13][0].y = 19;
	polygon[13][1].x = 12;
	polygon[13][1].y = 16;
	polygon[13][2].x = 20;
	polygon[13][2].y = 20;
	polygon[13][3].x = 40;
	polygon[13][3].y = 19;

	polygon[14][0].x = 40;
	polygon[14][0].y = 19;
	polygon[14][1].x = 14;
	polygon[14][1].y = 14;
	polygon[14][2].x = 20;
	polygon[14][2].y = 20;
	polygon[14][3].x = 40;
	polygon[14][3].y = 19;

	polygon[15][0].x = 40;
	polygon[15][0].y = 19;
	polygon[15][1].x = 16;
	polygon[15][1].y = 12;
	polygon[15][2].x = 20;
	polygon[15][2].y = 20;
	polygon[15][3].x = 40;
	polygon[15][3].y = 19;

	polygon[16][0].x = 40;
	polygon[16][0].y = 19;
	polygon[16][1].x = 18;
	polygon[16][1].y = 10;
	polygon[16][2].x = 20;
	polygon[16][2].y = 20;
	polygon[16][3].x = 40;
	polygon[16][3].y = 19;

	polygon[17][0].x = 40;
	polygon[17][0].y = 19;
	polygon[17][1].x = 22;
	polygon[17][1].y = 9;
	polygon[17][2].x = 20;
	polygon[17][2].y = 20;
	polygon[17][3].x = 40;
	polygon[17][3].y = 19;

	polygon[18][0].x = 40;
	polygon[18][0].y = 19;
	polygon[18][1].x = 26;
	polygon[18][1].y = 7;
	polygon[18][2].x = 20;
	polygon[18][2].y = 20;
	polygon[18][3].x = 40;
	polygon[18][3].y = 19;

	polygon[19][0].x = 40;
	polygon[19][0].y = 19;
	polygon[19][1].x = 30;
	polygon[19][1].y = 5;
	polygon[19][2].x = 20;
	polygon[19][2].y = 20;
	polygon[19][3].x = 40;
	polygon[19][3].y = 19;

	};


void ANIMAL :: set_color(int c)
	{
	color = c;
	};

void ANIMAL :: draw(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
	   Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, color);
	};

void ANIMAL :: erase(int num, int xc, int yc)
	{
	for (int i=0; i<numPts-1; i++)
		Line (xc + polygon[num][i].x, yc + polygon[num][i].y,
	    xc + polygon[num][i+1].x, yc + polygon[num][i+1].y, 0);
	};

int Phrase(int amount, char *phrase, char *answer)
	{
	clrscr();
	char letter;
	printf ("%s ", phrase);
	printf ("\n$ %d", amount);
	printf("\nENTER in a letter. ");
	scanf("%c", &letter);
	fflush(stdin);
	int num=0,flag=0;
	for(int a=0; a<18; a++)
		{
		if (letter == 'A' || letter == 'E' || letter == 'I' || letter == 'O' || letter == 'U')
			{
			printf("\nThat is a Vowel.");
			amount = 0;
			break;
			}
		else if (letter == answer[a])
			{
			printf("\nThat letter has already been used.");
			amount = 0;
			break;
			}
		else if (letter == phrase[a])
			{
			num+=1;
			answer[a] = letter;
			}
		else
			{
			flag+=1;
			}
		}
	if (flag == 18)
		{
		printf("\nSorry, no %c's", letter);
		amount = 0;
		}
	if (num >= 1)
		{
		if (num == 1)
			{
			printf("\nThere is %d %c.", num, letter);
			}
		else if (num > 1)
			{
			printf("\nThere are %d %c's.", num, letter);
			}
		}
	printf("\n%s", answer);
	//printf("\nYour score is %d.", score);
	getch();
	flag=0;
	for(a=0; a<sizeof(phrase); a++)
		{
		if(phrase[a] == answer[a])
			{
			flag += 1;
			}
		}
	if (flag == sizeof(phrase))
		{
		return 0;
		//End();
		}
	//getch();
	return amount;
	}

int Spin(char *phrase, char *answer)
	{
	clrscr();
	int amount;
	char bankrupt[] = "BANKRUPT";
	char jackpot[] = "JACKPOT";
	for (int a=0; a<20; a++)
	{
		amount = random (21) * 50;
		if (amount == 0)
			{
			//amount_word[] = "BANKRUPT";
			printf("%s\n", bankrupt);
			//amount_word);
			}
		else if (amount == 1000)
			{
			//amount_word[7] = "JACKPOT";
			printf("%s\n", jackpot);
			}
		else
			{
			printf("%d\n", amount);
			}
	}
	getch();
	if (amount == 0)
		{
		printf("LOSE A TURN.");
		getch();
		}
	else
		{
		Phrase(amount, (char *)phrase, (char *)answer);
		}

	return amount;
	}

int Vowel(char *phrase, char *answer)
	{
	clrscr();
	char vowel;
	printf("%s", phrase);
	printf("\n\nENTER in a vowel. ");
	scanf("%c", &vowel);
	fflush(stdin);
	int num=0,flag=0;
	if (vowel == 'A' || vowel == 'E' || vowel == 'I' || vowel == 'O' || vowel == 'U')
		{
		for (int a=0; a<18; a++)
			{
			if (vowel == answer[a])
				{
				printf("\nThat vowel has already been used.");
				break;
				}
			else if (vowel == phrase[a])
				{
				answer[a] = vowel;
				num+=1;
				}
			else
				{
				flag+=1;
				}
			}
		}
	else
		{
		printf("\nThat is not a vowel.");
		getch();
		return 0;
		}
	if (num > 0)
		{
		if (num == 1)
			{
			printf("\nThere is %d %c.", num, vowel);
			//getch();
			}
		else if (num > 1)
			{
			printf("\nThere are %d %c's.", num, vowel);
			//getch();
			}
		}
	if (flag >= 18)
		{
		printf("\nSorry, no %c's.", vowel);
		}
	printf("\n%s ", answer);
	getch();
	flag=0;
	for(int a=0; a<sizeof(phrase); a++)
		{
		if(phrase[a] == answer[a])
			{
			flag += 1;
			}
		}
	if (flag == sizeof(phrase))
		{
		return 0;
		//End();
		}

	//getch();
	return 0;
	}

int Solve(char *phrase, char *answer)
	{
	clrscr();
	char solve[18] = "                 ";
	printf("\n%s", answer);
	//const char *buffer = (char *);
	//sizeof(answer)];
	//printf("\n%s", answer);
	//printf("\n%s", phrase);
	//printf("\n%d\n%d", sizeof(answer), sizeof(solve));
	//getch();
	int flag=0;
	for (int a=0; a<18; a++)
		{
		if (answer[a] == phrase[a])
			{
			flag+=1;
			}
		}
	if (flag == 18)
		{
		printf("\n%s", answer);
		printf("\nThat is correct.  You win!");
		getch();
		return 0;
		}
	fflush(stdin);
	printf("\nENTER in the whole puzzle.\n");
	gets(solve);
	//scanf("%s", solve);
	fflush(stdin);
	//printf("%s", solve);
	flag=0;
	for (a=0; a<18; a++)
		{
		if (solve[a] == phrase[a])
			{
			flag+=1;
			}
		else
			{
			printf("\nSorry that is incorrect.");
			getch();
			break;
			}
		}
	if (flag == 18)
	//sizeof(answer))
		{
		printf("\nThat is correct.  You win!");
		getch();
		return 0;
		}
	return 0;
	}

int main ()
{
	clrscr ();
	int gdriver = DETECT, gmode, errorcode;
	initgraph (&gdriver, &gmode, "g:\\turboc\\bgi");
	errorcode = graphresult ();

	if (errorcode != grOk)
		{
		printf ("Graphics error: %s \n", grapherrormsg (errorcode));
		printf ("Press Anykey to halt: ");
		getch ();
		exit (1);
		}

	//setMode (VGA256);
	setMode (TEXT);
	int what,spin,score=0;
	char phrase[] = "CAN I BUY A VOWEL";
	char answer[sizeof(phrase)] = "                 ";
	int go=1;
	while (go != 0)
		{
		clrscr();
		printf("\nYour score is %d.", score);
		printf("\n\n1. Spin\n2. Buy a Vowel\n3. Solve\n4. Exit");
		printf("\n\nEnter in a number. ");
		scanf("%d", &what);
		fflush(stdin);
		if (what == 1)
			{
			randomize();
			printf ("\n");
			score += Spin((char *)phrase, (char *)answer);
			}
		else if (what == 2)
			{
			if (score < 250)
				{
				printf("\nYou do not have enough money.");
				getch();
				}
			else if (score >= 250)
				{
				score -= 250;
				Vowel((char *)phrase, (char *)answer);
				}
			}
		else if (what == 3)
			{
			Solve((char *)phrase, (char *)answer);
			}
		else
			{
			char quit,y,Y,n,N;
			printf("\nDo you really want to quit? ");
			scanf("%c", &quit);
			fflush(stdin);
			if (quit == 'Y' || quit == 'y')
				{
				printf("\nBye Bye!");
				getch();
				go = 0;
				}
			else if (quit == 'N' || quit == 'n')
				{
				printf("\nStarting over again!");
				score = 0;
				//answer[] = "                ";
				getch();
				go = 1;
				}
			else
				{
				printf("\nBack to main menu.");
				getch();
				}
			}

		}




	//colorScr (112);

/*	DOG Fido;
	Fido.set_color(113);
	STAR Star;
	Star.set_color(70);
	STAR2 Star2;
	BOX Box;
	BOX2 Box2;
	BOX3 Box3;
	BOX4 Box4;
	TRIANGLE Tri;

	Line (0, 100, 320, 100, 15);

   while ( !kbhit() )
	{
	for (int j=0; j<320; j+=20)
	{
	randomize;
	Box.set_color(j+1);
	Box2.set_color(j+34);
	Box3.set_color(j+50);
	Box4.set_color(random(254)+1);
	Tri.set_color(j+16);
		 for (int i=0; i<20; i++)
		 {
		Oval(j+3*i+25,40,20,20,113);
		Fido.draw(i%2, j+3*i, 120);
		Box.draw(i, j-20, 80);
		Box2.draw(i, j-60, 80);
		Box3.draw(i, j-80, 80);
		Box4.draw(i, j-100, 80);
		Tri.draw(i, j, 80);
		delay(100);
		Tri.erase(i, j, 80);
		Fido.erase(i%2, j+3*i, 120);
		Oval(j+3*i+25,40,20,20,0);
		Box.erase(i, j-20, 80);
		Box2.erase(i, j-60, 80);
		Box3.erase(i, j-80, 80);
		Box4.erase(i, j-100, 80);
		 }
		if (kbhit())
			break;
	}
	}

	getch();
	colorScr(0);
	Star.set_color(15);

	while ( !kbhit() )
	{
	Star.set_color(random(254)+1);
		 for (int i=0; i<6; i++)
		 {
		Star.draw(i, 90, 70);
		delay(150);
		Star.erase(i, 90, 70);
		 }
		if (kbhit())
			break;

	}
	getch();
	colorScr(0);
	while ( !kbhit() )
	{
	 Star2.set_color(random(254)+1);
		 for (int i=0; i<18; i++)
		 {
		Star2.draw(i, 100, 70);
		delay(100);
		Star2.erase(i, 100, 70);
		 }
		if (kbhit())
			break;

	}
*/
	//getch();
	setMode (TEXT);
	closegraph ();

	return 0;
}


void Line (int x1, int y1, int x2, int y2, int color)
{
	int dx, dy, xInc, yInc, error=0, i;
	unsigned char far *vBptr = videoBuffer;

	vBptr = vBptr + ((unsigned int) y1<<6) +
			((unsigned int) y1<<8) +
			(unsigned int) x1;

	dx = x2 - x1;
	dy = y2 - y1;

	if (dx>=0)
		{
		xInc = 1;
		}
	else
		{
		xInc = -1;
		dx = -dx;
		}

	if (dy>=0)
		{
		yInc = 320;
		}
	else
		{
		yInc = -320;
		dy = -dy;
		}

	if (dx>dy)
		{
		for (i=0; i<=dx; i++)
			{
			*vBptr = color;
			error += dy;
			if (error>dx)
				{
				error -= dx;
				vBptr += yInc;
				}
			vBptr += xInc;
			}
		}
	else
		{
		for (i=0; i<=dy; i++)
			{
			*vBptr = color;
			error += dx;
			if (error>0)
				{
				error -= dy;
				vBptr += xInc;
				}
			vBptr += yInc;
			}
		}
}

void Oval(int x0, int y0, int a, int b, int color)
{
	int x, y; 		  		// midpoint algorithm is a
	long aSquared, twoAsquared;             // variation on Bresenham
	long bSquared, twoBsquared;
	long d, dx, dy;

	x = 0;
	y = b;
	aSquared = a * a;
	twoAsquared = 2 * aSquared;
	bSquared = b * b;
	twoBsquared = 2 * bSquared;
						// initial excess distance d
	d = bSquared - aSquared * b + aSquared / 4L;

	dx = 0;			      		// initial run and rise
	dy = twoAsquared * b;         		// magnitudes dx and dy

	while (dx < dy) {			// slow slope > -1

		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d > 0) {		  	// midpoint is outside
			--y;              	// go down one line
			dy -= twoAsquared;
			d -= dy;
			++x;
			dx += twoBsquared;
			d += bSquared + dx;
		}
		else {
			++x;		  	// midpoint is inside
			dx += twoBsquared;
			d += bSquared + dx;
		}
	}
						// reset d for fast slope
	d += (3L * (aSquared - bSquared) / 2L - (dx + dy)) / 2L;

	while (y >= 0) {			// fast slope < -1
		putPixel(x0+x, y0+y, color);
		putPixel(x0+x, y0-y, color);
		putPixel(x0-x, y0+y, color);
		putPixel(x0-x, y0-y, color);

		if (d < 0) {			// midpoint is outside
			++x;
			dx += twoBsquared;
			d += dx;
		}
		--y;				// midpoint is inside
		dy -= twoAsquared;
		d += aSquared - dy;
	}
}



















































































































































