	/*
	File Name	: Address.cpp
	Course Number   : ISYS 291 01
	Student Name    : Jason Gradziel
	Student Number  : 826-135-535
	Professors Name : Brian Perry
	Lab Title       :
	*/
	/* Address.cpp */

#include <stdio.h>	/*sprintf*/
#include <string.h>	/*strcpy, strcat, strtok*/
#include <ctype.h>	/*isalpha*/
#include <iostream.h>	/*cin, cout, endl*/
#include "Address.h"

Address::Address(void)
{
   emptyvalues();
}

void Address::emptyvalues(void)
{
   street[0] = '\0';
   city[0] = '\0';
   province[0] = '\0';
   postalcode[0] = '\0';
   telenum[0] = '\0';
}

char* Address::display (void)
{
   static char temp[1256];
   /*sprintf(temp, "\tStreet : %s \n", street,
		 "\tCity/Town : %s \n", city,
		 "\tProvince/State : %s \n", province,
		 "\tPostal Code/Zip Code : %s \n", postalcode,
		 "\tTelephone Number : %s ", telenum);*/
   sprintf(temp, "\tStreet : %s \n\tCity/Town : %s \n\tProvince/State : %s \n\tPostal Code/Zip Code : %7s \n\tTelephone Number : %s ",street, city, province, postalcode, telenum);

   return temp;
}

int Address::update(char* data)
{
   char temp[1024] = "\0";
   char* p = NULL;
   int err = 0;

   strcpy (temp, data);

   p = strtok(temp, "\n");
   if (p == NULL) return -1;
   /*(err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(street, p);

   p = strtok(NULL, "\n");
   if (p == NULL) return -1;
   /*err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(city, p);

   p = strtok(NULL, "\n");
   if (p == NULL) return -1;
   /*err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(province, p);

   p = strtok(NULL, "\n");
   if (p == NULL) return -1;
   /*err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(postalcode, p);

   p = strtok(NULL, "\n");
   if (p == NULL) return -1;
   /*err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(telenum, p);

   if (err != 0)
	   return err;

   p = strtok(NULL, "\n");
   if (p == NULL)
	return 0;
   return 0;
}

char* Address::mailLabel(void)
{
   static char temp[1256] = "\0";
   /*sprintf (temp, "\n%s", street,
		  "\n%s, %s", city, province,
		  "\n%s", postalcode);*/
   sprintf (temp, "\n%s\n%s, %s\n%7s",street, city, province, postalcode);
   return temp;
}

/* IOstream operators */
ostream& operator<< (ostream& s, Address& x)
{
	s << x.street << endl
	  << x.city << endl
	  << x.province << endl
	  << x.postalcode << endl
	  << x.telenum << endl;
	return s;
}
istream& operator>> (istream& s, Address& x)
{
	return s;
}