/*  busrep4.c  -  Assignment #3 for ISYS290-04
	       - functions for use with awkfilt3.c to:

   PRODUCE A TYPICAL BUSINESS REPORT

      this is a typical "list and total" report

      Input is text records containing five fields as follows, a simplified
      "cash register" example:

      INPUT FORMAT

  Inventory_class       three characters used to classify inventory
  Inventory_code        five   characters
  Inventory_description one word up to 12 characters
  Item_cost             unit cost, values up to $999.99
  QOH_start             Quantity on hand at start of period, whole number
			5 digits
  Receipts              Items received into inventory during period, whole
			number, 5 digits
  Withdrawals           Items withdrawn from  inventory during period, whole
			number, 5 digits

      a static global array (of float) is used to hold the totals

      FUNCTION begin
	 intializes the array used to total the items
	 formats the header line for the report
      FUNCTION process
	 totals the items
	 formats each detail line for the report
      FUNCTION finish
	 formats the total line for the report

      ***NOTE***
	 all the actual output is done by the main() function
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*#include "\bpbc50\busrep3\busrep3.h"*/   /* function prototypes */
/*#include "c:\turboc\isys290\busrep3.h"*/
/*#include "a:\busrep3.h"*/
void do_print(char* line);
int count_lines(char* line);
int do_header(char* header);
void clrscr(void);

/*--- global data */

/* array totals[] is used to accumulate then print variouse totals         */
/* elements of the array totals are accessed using the following defines   */
static float totals[4];
#define QOH_START 0
#define WITHDRAWALS 1
#define QOH_END 2
#define VALUE 3

static int page_number = 0;
static int lines_per_page = 55;
static int lines_printed = 55;

/*--- function prototypes */

int begin(char* dest, char* source);    /* user supplied function */
int process(char* dest, char* source);  /* user supplied function */
int finish(char* dest, char* source);   /* user supplied function */

int split_tokens(char* str, char* delims, int expect, char* tokens[]);

/*==================== awk-like BEGIN processing ===================*/
int begin(char* dest, char* source)     /* user supplied function */
{
  int k = 3;        /* loop control*/

  /* clear screen */
  clrscr();

  /* initialize totals to zeros */
  for (k = 0; k < 3; k++)
  {
    totals[k] = 0.0;
  }
	return 1;          /* by default write nothing to stdout at start */
}

/*====================== per-record processing =======================*/
int process(char* dest, char* source)  /* user supplied function */
{
  int word_count = 0;
  char* words[8];   /* words from input (8 is big enough ... expecting 7) */
  char temp[81];     /* used in formatting */
  int QOH_end = 0;  /* Quantity on hand at end of period, whole number 5 digits */
  int num =0;

 /* split up input line into array*/
  word_count = split_tokens(source, " \t", 7, words);
  /* word_count should be 7 ... check and flag error if necessary */
  if (word_count != 7)
  {

	  strcpy(dest, source);   /*--- by default copy source -> dest        */
    return 99;
  }

  /*--- accumulate totals */
  num = words[5];
  QOH_end = words[4] + num - words[6];
  totals[QOH_START] = totals[QOH_START] + atof(words[5]);
  totals[WITHDRAWALS] = totals[WITHDRAWALS] + atof(words[6]);
  totals[QOH_END] = totals[QOH_END] + QOH_end;
  totals[VALUE] = totals[VALUE] + (atof(words[3]) * QOH_end);

  /*--- format detail line for output */
  sprintf(temp, "%-3s   %-5s %-12s %4.2f %5d %5d   %5d      %5d   %7.2f",
	    words[0], words[1], words[2], atof(words[3]),
	    words[4], words[5], words[6], QOH_end,
	    atof(words[3]) * atof(words[4]) );
	strcpy(dest, temp);   /*--- by default copy source -> dest        */
	return 0;               /*--- by default cause dest to go to stdout */
}

/*================== awk-like END processing =======================*/
int finish(char* dest, char* source)     /* user supplied function */
{
  char temp[81];

  /*--- format data line */
  sprintf(temp,	 "Total Quantity on Hand at Start of Period %9.2f\n"
		 "	Number of Withdrawals               %9.2f\n"
		 "	Quantity on Hand as End of Period   %9.2f\n"
		 "                                  VALUE = %1.0f\n\n",
     totals[QOH_START], totals[WITHDRAWALS], totals[QOH_END], totals[VALUE]);

  /*--- arrange to display/print */
  strcat(dest, "============================================================================\n");
  strcat(dest, temp);
	return 0;
}

/* ============= does printing - handles page-breaks ======= */
void do_print (char* text)
{
  int err = 0;              /* holds return value of called funcs */
  char output[1056] = "\0";  /* holds output text */

  /* ---- check if headings are needed ... do them if needed */
  if (lines_printed >= lines_per_page)
  {
    page_number++;
    err = do_header(output);  /* filled by function called */
    if (!err) puts(output);   /* output header */
    lines_printed = 1+ count_lines(output);
  }
  /* ---- in any case (with or without headings */
  puts(text);
  lines_printed = lines_printed + 1 + count_lines(text);
}

/* ================ counts lines in text =================== */
int count_lines(char* text)
{
  int k = 0;        /* loop control */
  int count = 0;    /* holds count of '\n' characters */

  for (k = 0; text[k] != '\0'; k++)
  {
    if (text[k] == '\n')
    {
      count++;
    }
  }
  return count;
}

/* ================ format header lines =================== */

int do_header(char* heading)
{
  char temp[81];     /* used in formatting */

  /*--- format heading line */
  sprintf(heading, "\f\n\n%-5s %-5s %-12s %-7s %-6s %-7s %-10s %-6s %-5s\n",
	  "Inv", "Inv", "Inv", "Item",
	  "QOH", "Receipt", "Withdrawal", "QOH", "Value");

  sprintf(temp, "\f\n\n%-5s %-5s %-12s %-7s %-6s                    %-6s \n",
	  "Class", "Code", "Des", "Cost",
	  "Start",  "End");

  /* add next line on heading */
  strcat(heading, temp);
  /*--- arrange to display/print */
  strcat(heading, "================================================================================\n");
  return 0;
}
