	/*
	Course Number   : ISYS 116
	Student Name    : Jason Gradziel
	Student Number  : 826-135-535
	Professors Name : Gene Rychlewski
	Class Name      : Thursday
	Lab Title       : ORDERING
	*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>

/* Global Variables */
double itemcost,
       total,
       subtotal = 0,
       pstrate  = 0.08,
       gstrate  = 0.07,
       gst,
       pst;
int    ccode,
       qty,
       row      = 5,
       numitems = 0;
char   desc[21];

/* Function Prototypes */
/* Mainline functions */
int setup();
int process();
int wrapup();
/* Subroutine functions */
void prtitle();
void prthdrs();
void getdata();
void calcs();
void getcode();
void prtmsg();
void fincalcs();
void prtsummary();

/* Mainline */
void main(void)
{
	setup();
	process();
	wrapup();
}

/* Subroutines */
int setup()
{
	clrscr();
	prtitle(); /* call print title routine */
	prthdrs(); /* call print headers routine */
	prtmsg();  /* call screen bottom message routine */
	getcode();  /* call get class code routine */

	return 0;
}

int process()
{
	/* Loop to process items */
	while (ccode != 999)
	{
		getdata(); /* call get item details routine */
		calcs();   /* call calcutations & print item total routine */
		getcode(); /* call get class code routine */
	}

	return 0;
}

int wrapup()
{
	fincalcs();   /* call final calcs routine */
	prtsummary(); /* call print summary routine */

	/* clean up */
	getch();
	fflush(stdin);
	clrscr();
	return 0;
}

/* Lower level subroutines */
/*** Print Screen Title ***/
void prtitle()
{
	clrscr();
	gotoxy(26,1);   printf("*--------------------------*");
	gotoxy(26,2);   printf("* General Merchandise Ltd. *");
	gotoxy(26,3);   printf("*--------------------------*");
}

/*** Print Data Headers ***/
void prthdrs()
{
	gotoxy(5,row);   printf("Code");
	gotoxy(12,row);  printf("Description");
	gotoxy(40,row);  printf("Quantity");
	gotoxy(50,row);  printf("Price");
	gotoxy(63,row);  printf("Total");
	row++;
	gotoxy(5,row);   printf("====");
	gotoxy(12,row);  printf("===========");
	gotoxy(40,row);  printf("========");
	gotoxy(50,row);  printf("=====");
	gotoxy(63,row);  printf("=====");
	row++;
}

/*** Get Class Code ***/
void getcode()
{
	gotoxy(5,row);   scanf("%d",&ccode);
}

/*** Print message at screen bottom ***/
void prtmsg()
{
	gotoxy(20,22);   printf("Enter a 999 Code to End the Transaction");
	gotoxy(20,23);   printf("\tNumber of Items Processed: %d",numitems);
}

/*** Get item details ***/
void getdata()
{
	gotoxy(12,row); fflush(stdin);  gets(desc);
	gotoxy(40,row); 		scanf("%d",&qty);
	gotoxy(50,row);			scanf("%lf",&itemcost);
}

/*** Calculations ***/
void calcs()
{
	itemcost *= qty;				/* total item cost     */
	subtotal += itemcost;				/* accumulate subtotal */
	gotoxy(59,row);  printf("%10.2f",itemcost);     /* print extended cost */
	row++;						/* increment row       */
	numitems++;					/* increment item ctr  */
	prtmsg(); /* call screen bottom message */
}

/*** Calculate taxes & total ***/
void fincalcs()
{
	pst   = subtotal * pstrate;
	gst   = subtotal * gstrate;
	total = subtotal + pst + gst;
}

/*** Print taxes, total & thanx */
void prtsummary()
{
	gotoxy(1,row);
	printf("================================================================================");
	gotoxy(45,row+2);	printf("Subtotal    : %10.2f",subtotal);
	gotoxy(45,row+3);	printf("PST         : %10.2f",pst);
	gotoxy(45,row+4);	printf("GST	    : %10.2f",gst);
	gotoxy(45,row+5);	printf("Amount Due  : %10.2f",total);
	/* print thanx box and clear 999 msg */
	gotoxy(5,row+3);	printf("*-------- THANX -------*");
	gotoxy(5,row+4);	printf("* for shopping GENERAL *");
	gotoxy(5,row+5);	printf("*----------------------*");
	gotoxy(20,22);		printf("                                                    ");
	gotoxy(1,1);
}