	/*
	Course Number   : ISYS 116
	Student Name    : Jason Gradziel
	Student Number  : 826-135-535
	Professors Name : Gene Rychlewski
	Class Name      : Thursday
	Lab Title       : Menu Case Structure
	*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>

/* Function Prototypes */
void setup(void);
void process(void);
void wrapup(void);

void prtmenu(void);
void choose(void);
void GPA(void);
void lineprt(void);
void tabledata(void);
/* Function Prototypes - for GPA */
/* Mainline functions */
int setupGPA();
int processGPA();
int wrapupGPA();
/* Subroutine functions */
void titleGPA();
void getnumsubjectsGPA();
void prtheadersGPA();
void prtnumsubjectsGPA();
void prttotalGPA();
void getinputGPA();
void calcsGPA();
void finalGPA();
void prtGPAmsgGPA();
void getyesnoGPA();
/* Function Prototypes - for line print */
/* Mainline functions */
int setupLPRT();
int processLPRT();
int wrapupLPRT();
/* Function Prototypes - for table data */
/* Mainline functions */
int setupTDATA();
int processTDATA();
int wrapupTDATA();

/* Globle Variables */
int choice;
/* Global Variables - for GPA */
char   fname[16],
       lname[21],
       snum[12], //= "___-___-___",
       ccode[9];
int    numsubjt,
       mark,
       credits,
       wmark,
       num,
       flag=1;
double totalGPA,
       totalcrdt,
       gpa;
/* Global Variables - for line print */
char alpha;
int  length;
/* Global Variables - for table data */
int total=0;

/* Mainline logic */
void main (void)
{
	setup();
	process();
	wrapup();
}

/* Subroutines */

void setup(void)
{
	prtmenu();
	choose();
}

void process(void)
{
	/* loop to process choice */
	while (choice != 0)
	{
		switch (choice)
		{
			case 1:
				GPA();
				break;
			case 2:
				lineprt();
				break;
			case 3:
				tabledata();
				break;
			case 0:
				break;
			default:
				gotoxy(26,15);
				printf("Invalid choice - try again");
				gotoxy(26,16);
				printf("Press any key to continue");
				getch();
		}
		setup();
	}
}

void wrapup(void)
{
	gotoxy(35,23);
	printf("D O N E !!");
	getch();
}

void prtmenu(void)
{
	/* print screen, title & prompt for choice */
	clrscr();
	gotoxy(26,1);	printf("**************************");
	gotoxy(26,2);	printf("* Sample of Menu Program *");
	gotoxy(26,3);	printf("**************************");

	gotoxy(26,5);	printf("Select one of the following");
	textcolor(1);
	gotoxy(30,7);	cprintf("1 Calculate GPA average");
	textcolor(2);
	gotoxy(30,8);	cprintf("2 Line print");
	textcolor(4);
	gotoxy(30,9);	cprintf("3 Table of ASCII Data");
	textcolor(5);
	gotoxy(30,10);	cprintf("0 Exit");
}

void choose(void)
{
	/* get maenu choice */
	gotoxy(26,15);	printf("Enter your choice: ");
	scanf("%d", &choice);
}

void GPA(void)
{
	flag = 1;
	while (flag==1)
	{
		totalGPA=0; totalcrdt=0; gpa=0;
		for (int a=0; a<11; a++)
			snum[a]= ' ';
		setupGPA();
		processGPA();
		wrapupGPA();
		getyesnoGPA();
	}

	/* clean up */
	fflush(stdin);
	//getch();
	clrscr();
}

void lineprt(void)
{
	setupLPRT();
	processLPRT();
	wrapupLPRT();
	/* clean up */
	fflush(stdin);
	getch();
	clrscr();
}

void tabledata(void)
{
	setupTDATA();
	processTDATA();
	wrapupTDATA();
}

/* Subroutines - for GPA */
int setupGPA()
{
	fflush(stdin);
	titleGPA();
	getnumsubjectsGPA();
	prtheadersGPA();
	prtnumsubjectsGPA();
	return 0;
}

int processGPA()
{
	for(num=0; num<numsubjt; num++)
	{
		getinputGPA();
		calcsGPA();
		prttotalGPA();
	}
	return 0;
}

int wrapupGPA()
{
	finalGPA();
	prtGPAmsgGPA();
	return 0;
}

/* Lower level subroutines */
void titleGPA()
{
	clrscr();
	gotoxy(30,2);	printf("***********************");
	gotoxy(30,3);	printf("* GRADE POINT AVERAGE *");
	gotoxy(30,4);	printf("***********************");
}

void getnumsubjectsGPA()
{
	gotoxy(18,10);	printf("Enter in the following :");
	gotoxy(20,11);	printf("First Name");
	gotoxy(31,11);	gets(fname);
	gotoxy(20,12);	printf("Last Name");
	gotoxy(31,12);	gets(lname);
	gotoxy(18,13);	printf("Student Number %s",snum);
	gotoxy(33,13);	snum[0] = getche();
			snum[1] = getche();
			snum[2] = getche();
	gotoxy(37,13);	snum[4] = getche();
			snum[5] = getche();
			snum[6] = getche();
	gotoxy(41,13);	snum[8] = getche();
			snum[9] = getche();
			snum[10] = getche();
	gotoxy(18,14);	printf("How many subjects are you taking? (max 7) : ");
			scanf("%d",&numsubjt);
	if (numsubjt > 7)
		numsubjt = 7;
}

void prtheadersGPA()
{
	clrscr();
	titleGPA();
	gotoxy(30,6);	printf("%s %s %s",fname,lname,snum);

	gotoxy(10,10);	printf("#");
	gotoxy(15,9);	printf("Course");
	gotoxy(16,10);	printf("Code");
	gotoxy(30,10);	printf("Mark");
	gotoxy(40,10);	printf("Credits");
	gotoxy(50,9);	printf("Weighted");
	gotoxy(51,10);	printf("Mark");
	gotoxy(10,11);	printf("=");
	gotoxy(15,11);	printf("======");
	gotoxy(30,11);	printf("====");
	gotoxy(40,11);	printf("=======");
	gotoxy(51,11);	printf("====");
}

void prtnumsubjectsGPA()
{
	for (num=0; num<numsubjt; num++)
	{
		gotoxy(10,num+12);	printf("%d",num+1);
	}
}

void prttotalGPA()
{
	gotoxy(30,13+numsubjt);	printf("Totals");
	gotoxy(41,13+numsubjt);	printf("%.0f",totalcrdt);
	gotoxy(51,13+numsubjt);	printf("%.0f",totalGPA);
}

void getinputGPA()
{
	gotoxy(15,num+12);	fflush(stdin);	gets(ccode);
	gotoxy(31,num+12);			scanf("%d",&mark);
	gotoxy(41,num+12);			scanf("%d",&credits);
}

void calcsGPA()
{
	totalcrdt += credits;
	wmark = mark * credits;
	gotoxy(51,num+12);	printf("%d",wmark);
	totalGPA += wmark;
}

void finalGPA()
{
	gpa = totalGPA / totalcrdt;
	gotoxy(20,num+15);
	printf("Your Grade Point Average is %.2f",gpa);
}

void prtGPAmsgGPA()
{
	if (gpa < 60)
	{
		gotoxy(25,num+16);
		printf("Failing!...Please see your coordinator.");
	}
	else if (gpa > 79)
	{
		gotoxy(25,num+16);
		printf("Congratulations!...You have Honours!");
	}
	else
	{
		gotoxy(25,num+16);
		printf("Passing!...Keep up the good work.");
	}
}

void getyesnoGPA()
{
	int flag2=1;
	while (flag2==1)
	{
	char quit;
	printf("\n\n\tDo you want to quit?(Y/N) ");
	quit=getch();
	if (quit == 'Y' || quit == 'y')
		{
		printf("\n\tBye Bye!");
		flag = 0; flag2=0;
		delay(500);
		//getch();
		}
	else if (quit == 'N' || quit == 'n')
		{
		printf("\n\tO.K.");
		delay(500);
		flag2=0;
		//getch();
		}
	else
		{
		printf("\n\tThat is incorrect.");
		delay(500);
		//getch();
		}
	}
}

/* Subroutines - for line print */
int setupLPRT()
{
	clrscr();
	printf("\n\t\tLine Print Program\n\n");
	printf("\nEnter in a character to be displayed : ");
	alpha = getche();
	//getch();
	printf("\nEnter in the number of times (1 to 80) : ");
	scanf("%d",&length);
	printf("\n\n\n");
	return 0;
}

int processLPRT()
{
	for (int times=0; times<length; times++)
		printf("%c",alpha);
	return 0;
}

int wrapupLPRT()
{
	printf("\n\n\n\tProgram Complete.\n\tPress any key to continue.");
	return 0;
}

/* Subroutines - for table data */
int setupTDATA()
{
	/* print headers & output design */
	clrscr();
	printf("     Dec Hex Sym   Dec Hex Sym   Dec Hex Sym   Dec Hex Sym   Dec Hex Sym");
	printf("\n");
	for(int x=4; x<75; x++)
	{
		gotoxy(x,2);
		printf("");
	}
	for(x=4;x<81;x+=14)
	{
		for(int y=1;y<26;y++)
		{
			gotoxy(x,y);
			printf("");
		}
	}
	for(x=4;x<81;x+=14)
	{
		gotoxy(x,2);
		printf("");
	}
	gotoxy(4,2);
	printf("");
	gotoxy(74,2);
	printf("");

	return 0;
}

int processTDATA()
{
	/* nested for loop to print output for
	x - each coloumn
	dec - rows */
	/* for the first page - 3 pages */
	for (int x=0; x<60; x+=14)
	{
		for (int dec=0; dec<=22; dec++)
		{
			if (total!=7)
			{
				gotoxy(x+5,dec+3);
				printf(" %d   %x   %c",total,total,total);
			}
			/* if number printed is 7 then it prints it but
				not beep */
			else
			{
				gotoxy(x+5,dec+3);
				printf(" %d   %x  Beep",total,total);
			}
			/*  if number is 9 then it fixes the tab command
				and prints it */
			if (total==9)
			{
				gotoxy(x+5,dec+3);
				printf(" %d   %x   TAB ",total,total);
			}
			/*  increment counter */
			total+=1;
		}
	}

	/* for the second page */
	getch();
	setupTDATA();
	for (x=0; x<60; x+=14)
	{
		for (int dec=0; dec<=22; dec++)
		{
			gotoxy(x+5,dec+3);
			printf(" %d  %x  %c",total,total,total);
			total+=1;
		}
	}

	/* for the third page */
	getch();
	setupTDATA();
	/* prints first coloumn */
	for (x=0; x<14; x+=14)
	{
		for (int dec=0; dec<=22; dec++)
		{
			gotoxy(x+5,dec+3);
			printf(" %d  %x  %c",total,total,total);
			total+=1;
		}
	}
	/* prints the last 3 numbers */
	for (int dec=0; dec<=2; dec++)
	{
		gotoxy(19,dec+3);
		printf(" %d  %x  %c",total,total,total);
		total+=1;
	}

	return 0;
}

int wrapupTDATA()
{
	/* pauses the screen - then prints message */
	getch();
	clrscr();
	gotoxy(26,20);
	printf("Program complete");
	/* clean up */
	fflush(stdin);
	getch();
	clrscr();
	return 0;
}
