	/*
	File Name	: Customer.cpp
	Course Number   : ISYS 291 01
	Student Name    : Jason Gradziel
	Student Number  : 826-135-535
	Professors Name : Brian Perry
	*/
	/* Customer.cpp */

/* all includes are for functions listed below*/
#include <iostream.h>    /*cin, cout, endl*/
#include <ctype.h>       /*isalpa*/
#include <string.h>	 /*strcpy, strcat, strtok*/
#include <stdlib.h>	 /*atof*/
#include <stdio.h>       /*sprintf*/
#include <time.h>	 /*_strdate*/
#include "Customer.h"

Customer::Customer(void)
{
   counter++;
   emptyvalues();
   sprintf(id, "%d", counter); /* sets id equal to counter */
}

int Customer::counter = 0;

void Customer::emptyvalues(void)
{
   id[0] = '\0';
   company[0] = '\0';
   balance = 0.00;
   numOrds = 0;
   dateLastOrd[0] = '\0';
}

int Customer::update(char* data)
{
   char temp[1024] = "\0";	/* holds copy of input */
   char* p = NULL;		/* holds pointer to token */
   int err = 0;			/* returns error code */

   strcpy (temp, data);

   p = strtok(temp, "\n");
   if (p == NULL) return -1;
   /*err = isalpha(*p); /* err check p */
   /*if (err == 0) return 1;*/
   strcpy(company, p);

   p = strtok(NULL, "\n");
   if (p == NULL) return -1;
   /*valsdec.c
   err = isdigit(*p);   /* err check ptr */
   /*if (err == 0) return 1;*/
   balance = (float) atof (p);

   /* class address*/
   p = p + strlen(p) + 1;
   err = home.update(p);

   return err;
}

char* Customer::display(void)
{
   static char temp[1256] = "\0";
   sprintf(temp, "Employee Id '%s',\nCompany Name '%s',\nBalance $%1.2f,\nNumber of Orders '%d',\nDate Last Ordered '%s'.\n", id, company, balance, numOrds, dateLastOrd);
   strcat (temp, home.display());

   return temp;
}

char* Customer::mailLabel(void)
{
   static char temp[256] = "\0";
   sprintf(temp, "\n%s", company);
   strcat (temp, home.mailLabel());

   return temp;
}

void Customer::addOrder(void)
{
   numOrds++;
   char datebuf[9];

   _strdate(datebuf);
   strcpy (dateLastOrd, datebuf);
}

/* IOstream operators */
ostream& operator<< (ostream& s, Customer& x)
{
	s << x.company << endl
	  << x.home << endl
	  << x.balance << endl
	  << x.numOrds << endl
	  << x.dateLastOrd << endl;
	return s;
}
istream& operator>> (istream& s, Customer& x)
{
	return s;
}