/*******************************/
/* Course number: ISYS 116                  */
/* Student:  Peter Newton & Jason Gradziel  */
/* Student No. 826135725     826-135-535    */
/* Professor:  Gene Rychlewski              */
/* Class name:  Thursday                    */
/* Program:  Payentry                       */
/***************************** */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

/* FUNCTION PROTOTYPES  */
/* Mainline Functions */
void setup (void);
void process(void);
void wrapup(void);
FILE * Safe_fopen(char *, char *);
void Safe_fclose(FILE *);
void getdata(void);
void prtheader(void);
void textattr(int color);

typedef struct
{
	char 	emp_id[5];
	float 	pay_rate;
	float	week_day[5];
}	EMP_REC;

/* GLOBAL VARIABLES */

FILE * output_file;
EMP_REC	emprec;
int	line,
	day,
	yes_no,
	record_count = 0;
char	output_file_name[51];

/* MAINLINE LOGIC  */
void main (void)
/* CALL MAINLINE FUNCTIONS */
{
	setup();
	process();
	wrapup();
}

/* MAINLINE FUNCTIONS*/

/* Setup */

void setup (void)
{
	//textattr(BROWN *16 | LIGHTGRAY);
	clrscr();
	gotoxy(1,1);
	//printf("Enter the name of the output file:  ");
	//gets(output_file_name);
	output_file = Safe_fopen("a:input.dat", "wb");
	printf("\n\nStrike any key to continue...");
	getche();
	prtheader();
}

void prtheader(void)
{
	clrscr();
	fflush(stdin);
	gotoxy(35,1);
	printf("$$$  PAYROLL  $$$");
	gotoxy(1,3);
	printf("Please type the following data as requested, pressing enter ");
	printf("after each item.");
	gotoxy(10,5);
	printf("Employee identification number:  _____");
	gotoxy(20,7);
	printf("Hours worked Monday:     0.0");
	gotoxy(33,9);
	printf("Tuesday:    0.0 ");
	gotoxy(33,11);
	printf("Wednesday:  0.0");
	gotoxy(33,13);
	printf("Thursday:   0.0");
	gotoxy(33,15);
	printf("Friday:     0.0");
	gotoxy(20,17);
	printf("Hourly rate:          $00.00");
	getdata();
}

void getdata(void)
{
	fflush(stdin);
	fflush(stdout);
	fflush(stderr);
	gotoxy(43,5);
	scanf("%s", &emprec.emp_id);
	fflush(stdin);
	line = 7;
	for (day = 0; day <= 4; ++day)
	{
		gotoxy(45,line);
		scanf("%f", &emprec.week_day[day]);
		line += 2;
		while (emprec.week_day[day] > 9.9)
		{
			gotoxy(1,19);
			printf("\aHours entered exceed 9.9.  Please try again!");
			gotoxy(45,line - 2);
			printf("_._   ");
			gotoxy(45,line - 2);
			scanf("%f", &emprec.week_day[day]);
			gotoxy(1, 19);
			printf("                                                           ");
		}
	}
	gotoxy(43,17);
	scanf("%f", &emprec.pay_rate);
	while (emprec.pay_rate > 29.99)
	{
		gotoxy(1,19);
		printf("\aPay rate may not exceed $29.99.  Please try again!");
		gotoxy(43,17);
		printf("__.__  ");
		gotoxy(43,17);
		scanf("%f", &emprec.pay_rate);
		gotoxy(1,19);
		printf("                                                        ");
	}
	gotoxy (1,19);
	fflush(stdin);
	printf("Are the data entered above correct (Y/N)?  ");
	scanf("%c", &yes_no);
	if (yes_no == 'N' || yes_no == 'n')
		{
			gotoxy(1,19);
			printf("You may now re-enter the data for this employee.  Press any key to continue.");
			getche();
			prtheader();
		}
	else
	{/*
	gotoxy(1,25);
	printf("%d, %1.1f, %1.1f, %1.1f, %1.1f, %1.1f, %2.2f", emprec.emp_id, emprec.week_day[0], emprec.week_day[1], emprec.week_day[2], emprec.week_day[3], emprec.week_day[4], emprec.pay_rate);
	getche();*/
	process();
	}
}

/* Process*/

void process (void)
{
/*	while (emprec.emp_id > 0)
	{*/
	fwrite(&emprec, sizeof(EMP_REC), 1, output_file);
	++ record_count;
/*	emprec.emp_id = 0;
	}*/
	fflush(stdin);
	gotoxy(1,19);
	printf("Would you like to enter another employee's payroll data (Y/N)?  ");
	scanf("%c", &yes_no);
	if (yes_no == 'Y' || yes_no == 'y')
		prtheader();
	else
		wrapup();
}

/* Wrapup */

void wrapup (void)
{
	Safe_fclose(output_file);
	gotoxy(1,21);
	printf("%d record(s) written to disk.", record_count);
	gotoxy(1,23);
	printf("Program completed!");
	getche();
	exit(1);
}

/*	Safe Open Routine */

FILE * Safe_fopen(char * f_name, char * mode)
{
	FILE * file_ptr;

	if ( (file_ptr = fopen(f_name, mode))  == NULL )
	{
		fprintf(stderr, "\nERROR: File %s cannot be opened.", f_name);
		getche();
		exit(1);
	}
	else fprintf(stderr, "\nFile %s opened successfully.", f_name);
	return file_ptr;
}

void Safe_fclose(FILE * file_ptr)
{
	if (fclose(file_ptr) == EOF )
		{
			fprintf(stderr, "\nERROR: File cannot be closed.");
			exit(1);
		}
	else fprintf(stderr, "\n\nFile closed successfully.");
	return;
}

