	/*
	Course Number   : ISYS 116
	Student Name    : Jason Gradziel
	Student Number  : 826-135-535
	Professors Name : Gene Rychlewski
	Class Name      : Thursday
	Lab Title       : ISYS 103
	*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

/* Global Variables */
	int grade[10];// = {50,10,100,40,90,60,20,70,30,80};
	int quiz,
	    temp,
	    NUM_QUIZZES,
	    order,
	    choice;

/* Function Prototypes */
/* Mainline functions */
setup();
process();
wrapup();
/* Subroutine functions */
bubble_sort();
printheaders();
stats();
getdata();
displaymenu();

/* Mainline */
main()
{
	setup();
	process();
	wrapup();
	return 0;
}

/* Subroutines */
int setup()
{
	getdata();
	return 0;
}

int process()
{
	displaymenu();

	/* loop to process choice */
	while (choice != 0)
	{
		switch (choice)
		{
			case 1:
				getdata();
				break;
			case 2:
				stats();
				break;
			case 3:
				bubble_sort();
				break;
			case 0:
				break;
			default:
				gotoxy(26,15);
				printf("Invalid choice - try again");
				gotoxy(26,16);
				printf("Press any key to continue");
				getch();

		}
		displaymenu();
	}
	return 0;
}

int wrapup()
{
	clrscr();
	gotoxy(26,15);	printf("Closing Message...");
	gotoxy(20,20);	printf("Press any key to continue..");
	/*int num=47;
	quiz=1;
	while(quiz!=0)
	{
		gotoxy(20,num++);	printf(".");
		quiz=getch();
	}*/
	/* clean up */
	fflush(stdin);
	getch();
	clrscr();
	return 0;
}

/* Lower level subroutines */
displaymenu()
{
	clrscr();
	gotoxy(26,5);	printf("Select one of the following");
	gotoxy(30,7);	printf("1 Get Data");
	gotoxy(30,8);	printf("2 Stats");
	gotoxy(30,9);	printf("3 Sort");
	gotoxy(30,10);	printf("0 Exit  ");
	gotoxy(30,11);	printf(": ");
	scanf("%d",&choice);

	return 0;
}

printheaders()
{
	clrscr();
	gotoxy(26,1);	printf("**************************");
	gotoxy(26,2);	printf("*     Program Title      *");
	gotoxy(26,3);	printf("**************************");
	return 0;
}

getdata()
{
	int flag2=1;
	while(flag2==1)
	{
		printheaders();

		gotoxy(20,5);	printf("Enter in the number of tests (max 10)");
		gotoxy(26,6);	printf(": ");	scanf("%d",&NUM_QUIZZES);

		if (NUM_QUIZZES > 10)
		{
			gotoxy(26,9);	printf("Choice is greater than 10!   Enter again.");
			gotoxy(26,10);	printf("Press any key to continue");
			getch();
		}
		else if (NUM_QUIZZES < 0)
		{
			gotoxy(26,9);	printf("Choice is less than 0!   Enter again.");
			gotoxy(26,10);	printf("Press any key to continue");
			getch();
		}
		else
			flag2=0;
	}

	/* get the grades */
	gotoxy(20,8);	printf("Please enter %d integer quiz grades.", NUM_QUIZZES);

	for (quiz=0; quiz<NUM_QUIZZES; ++quiz)
	{
		gotoxy(23,quiz+10);	printf("Enter grade for quiz %d:",quiz+1);
		gotoxy(47,quiz+10);	scanf("%d", &grade[quiz]);
	}

	/* displayes the quiz grades */
	printf("\n\n\tThe grades you entered are as follows:\n");
	for (quiz=0; quiz<NUM_QUIZZES; ++quiz)
		printf("%6d", grade[quiz]);
	printf("\n\tPress any key to continue..");
	getch();
	return 0;
}


stats()
{
	clrscr();
	printheaders();

	int totalmark=0,
	    mean=0,
	    passes=0,
	    highest = grade[0],
	    lowest = grade[0];

	for (quiz=0; quiz<NUM_QUIZZES; ++quiz)
	{
		totalmark += grade[quiz];
		if (highest < grade[quiz])
			highest = grade[quiz];
		if (lowest > grade[quiz])
			lowest = grade[quiz];
		if (grade[quiz]>59)
			passes++;
	}
	mean = totalmark/NUM_QUIZZES;
	/* displayes the quiz grades */
	gotoxy(6,6);	printf("The grades you entered are as follows:\n");
	for (quiz=0; quiz<NUM_QUIZZES; ++quiz)
		printf("%6d", grade[quiz]);

	printf("\n\n\tThe mean mark is %d",mean);
	printf("\n\tThe highest mark is %d",highest);
	printf("\n\tThe lowest mark is %d",lowest);
	printf("\n\tThe number of passes are : %d",passes);
	printf("\n\tThe number of failures are : %d",NUM_QUIZZES-passes);
	printf("\n\nPress any key to continue..");
	getch();
	return 0;
}

bubble_sort()
{
	int pass,
	    limit;

	/* do the bubble sort */
	limit = NUM_QUIZZES-2;

	for (pass=1; pass<=NUM_QUIZZES-1; ++pass)
	{
		for (quiz=0; quiz<=limit; ++quiz)

			if (grade[quiz] > grade[quiz+1])
			{
				temp=grade[quiz];
				grade[quiz] = grade[quiz+1];
				grade[quiz+1]=temp;
			}

	--limit;
	}

	int flag1=1;
	while(flag1==1)
	{
		clrscr();
		printheaders();
		gotoxy(10,5);	printf("Do you want the sort to be displayed");
		gotoxy(12,6);	printf("ascending or decending?");
		gotoxy(10,7);	printf("For ascending press (1)");
		gotoxy(10,8);	printf("For decending press (2)");
		gotoxy(37,6);	scanf("%d",&order);

		if (order==1)
		{
			/* display the sorted quiz grades */
			gotoxy(6,10);	printf("The grades in ascending order are as follows:\n");
			for (quiz=0; quiz<NUM_QUIZZES; ++quiz)
			{
				printf("%6d",grade[quiz]);
			}
			flag1=0;
		}
		else if (order == 2)
		{
			gotoxy(6,10);	printf("The grades in decending order are as follows:\n");
			for (quiz=NUM_QUIZZES-1; quiz>=0; --quiz)
			{
				printf("%6d",grade[quiz]);
			}
			flag1=0;
		}
		else
		{
			gotoxy(10,11);	printf("Incorrect number");
			getch();
		}
	}

	gotoxy(1,20);
	printf("Press any key to continue..");
	getch();
	return 0;
}

