/* testit.c - builds a mail file for test/assignment submission */
/*
        You should save this message as a text file, then compile it
        then use (i.e. run) it to prepare/package your work to submit
        assignments to me.

        If you have any questions about how it works, please ask them in
        class.
*/
/*
                  USAGE:

                testit COURSE function filename [filename...]

                          COURSE      : must have the format:  ISYS291-50 or CENG303-51
                          function    : matches the function or assignment you are sending
                          filename(s) : should be lower case

        this creates a temporary file "testit.tmp" which is in the format
        required to submit as a mail message for testing assignments

        The number of arguments is checked BUT ...
        Currently NO CHECKING is done on the arguments for suitablility
        filename(s) are assumed to be existing files in the current directory

*/
/*
  HISTORY
  =======

  19960925      original - DOS program duplicates funtion of testit shell
                                script used in Unix course
  19961003      REVISION 2 - checked number of parameters on command line
  19970120      REVISION 3 - inserted ### END to stop the inclusion of
                                signatures and other e-mail rubbish on the end of the last
                                submitted file
  19980118      REVISION 4 - rewrite without using system() ... Borland seems
                                to have decided that system() is not, after all, an ANSI
                                function ... problem is present in BORLAND C++ v4.52, possibly
                                v5.0 (though previouse students have definitely used 5.0,
                                apparently without problem.)  TURBOC C++ is happy with Revision 3
*/
/*
        STRATEGY:

                pick off the arguments one at time and write the output in the
                appropriate format for the mail message as follows:

                Subject: testing <course_id> <function>

                ### TESTIT REVISION 4 DOS

                ### FILE filename    )repeated for
                <contents of file>   )each file

                ### END
*/
#include <stdlib.h>  /* for system() */
#include <stdio.h>   /* for fprintf() */
#include <string.h>  /* for str...() */

#define MAXLEN 1024

int main(int argc, char *argv[])
{
        char temp[MAXLEN+1];    /* holds various input lines */
        int k = 0;           /* index/loop control */
        FILE *in = NULL;                /* input file pointer */
        FILE *out = NULL;               /* output file pointer */

        if (argc < 3)
        {
                fprintf(stderr, "\nUSAGE IS: testit course_id function filename [filename...]\n");
                exit (1);
        }
        /*--- if enough arguments, assume for now they are correctly used */

        /*--- open output file */
        out = fopen("TESTIT.TMP", "w");
        fprintf(out, "Subject: testing %s %s\n", argv[1], argv[2]);
        fprintf(out, "\n");
        fprintf(out, "### TESTIT REVISION 4 DOS\n");
        fprintf(out, "\n");

        for (k = 3; k < argc; k++)
        {
                in = fopen(argv[k], "r"); /* open current input file */
                if (in == NULL)
                {
                        fprintf(stderr, "\nCannot open input file %s\n", argv[k]);
                        fprintf(stderr, "**** INVALID OUTPUT ---- DO NOT MAIL ****\n\n");
                        exit (99);
                }
                fprintf(out, "  ### FILE %s\n", argv[k]);

                fgets(temp, MAXLEN, in);   /* read (next) line from input file */
                while (!feof(in))
                {
                        fprintf(out, "%s", temp);       /* write out current source line */
                        fgets(temp, MAXLEN, in);   /* read (next) line from input file */
                }
                fclose (in);    /* close current input file */
        }

        /*--------- wrap up -------*/
        fprintf(out, "\n### END\n");
        fclose(out);
        fprintf(stderr, "\n**OK --- output file TESTIT.TMP is mailable **\n\n");
        return 0;
}



