/* diskex2.c
*/

#include<stdio.h>
#include<string.h>
#define RECSIZE 21

int begin(char* dest, char* src);
int process(char* dest, char* src);
int finish(char* dest, char* src);

static FILE *input;
static int read_count = 0;

int begin(char* d, char* s)
{
	input = fopen("diskex1.dat","r");
	if (input == NULL)
	{
		strcpy(d, "File open ERROR ");
		return 0;
	}
	else
	{
		strcpy(d,"File opened SUCCESSFULLY ");
		*s=NULL;
		return 0;
	}
}

int finish(char* d, char* s)
{
	fclose(input);
	sprintf(d,"File closed successfully %d records written", read_count);
	*s=NULL;
	return 0;
}

int process(char* d, char* s)
{
	int rcount = 1;
	int acount = 0;
	int recno = 0;
	long offset = 0L;
	char temp[RECSIZE] = "";

	recno = atoi(s);
	if (recno < 1)
	{
		sprintf(d, "Invalid record number: %s", s);
		return 0;
	}

	offset = (recno -1) * sizeof(temp);
	acount = fseek (input, offset, SEEK_SET);

	if (acount != 0)
	{
		sprintf(d, "Seek failed ... return value was %d", acount);
		return 0;
	}

	acount = fread(temp, sizeof(temp), rcount, input);
	if (acount != rcount)
	{
		sprintf(d, "Error reading record: %d", recno);
		return 0;
	}
	else
	{
		sprintf(d, "Record read successfully: %s", temp);
		read_count++;
		return 0;
	}
}
