/* busrep3.c - functions for use with awkfilt3.c to:

   PRODUCE A TYPICAL BUSINESS REPORT

      this is a typical "list and total" report

      Input is text records containing five fields as follows, a simplified
      "cash register" example:

      customer id
      invoice number
      inventory item (code or description - developer's choice)
      quantity sold
      unit price of inventory item

      a static global array (of float) is used to hold the totals

      FUNCTION begin
         intializes the array used to total the items
         formats the header line for the report
      FUNCTION process
         totals the items
         formats each detail line for the report
      FUNCTION finish
         formats the total line for the report

      ***NOTE***
         all the actual output is done by the main() function
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*#include "\bpbc50\busrep3\busrep3.h"*/    /* function prototypes */
#include "a:\busrep3.h"

/*--- global data */

/* array totals[] is used to accumulate then print variouse totals         */
/* elements of the array totals are accessed using the following defines   */
static float totals[3];
#define QTY 0
#define VALUE 1
#define COUNT 2

static int page_number = 0;
static int lines_per_page = 55;
static int lines_printed = 55;

/*--- function prototypes */

int begin(char* dest, char* source);    /* user supplied function */
int process(char* dest, char* source);  /* user supplied function */
int finish(char* dest, char* source);   /* user supplied function */

int split_tokens(char* str, char* delims, int expect, char* tokens[]);

/*==================== awk-like BEGIN processing ===================*/
int begin(char* dest, char* source)     /* user supplied function */
{
  int k = 3;        /* loop control*/

  /* initialize totals to zeros */
  for (k = 0; k < 3; k++)
  {
    totals[k] = 0.0;
  }
	return 1;          /* by default write nothing to stdout at start */
}

/*====================== per-record processing =======================*/
int process(char* dest, char* source)  /* user supplied function */
{
  int word_count = 0;
  char* words[6];   /* words from input (6 is big enough ... expecting 5) */
  char temp[81];     /* used in formatting */

  /* split up input line into array*/
  word_count = split_tokens(source, " \t", 5, words);
  /* word_count should be 5 ... check and flag error if necessary */
  if (word_count != 5)
  {

	  strcpy(dest, source);   /*--- by default copy source -> dest        */
    return 99;
  }

  /*--- accumulate totals */
  totals[QTY] = totals[QTY] + atof(words[3]);
  totals[VALUE] = totals[VALUE] + (atof(words[3]) * atof(words[4]) );
  totals[COUNT]++;

  /*--- format detail line for output */
  sprintf(temp, "%-5s %-5s %-20s %5.2f %7.2f %7.2f",
	    words[0], words[1], words[2], atof(words[3]),
	    atof(words[4]), atof(words[3]) * atof(words[4]) );
	strcpy(dest, temp);   /*--- by default copy source -> dest        */
	return 0;               /*--- by default cause dest to go to stdout */
}

/*================== awk-like END processing =======================*/
int finish(char* dest, char* source)     /* user supplied function */
{
  char temp[81];

  /*--- format data line */
  sprintf(temp,
	 "Total QTY and VALUE          %9.2f       %9.2f\nITEMS=%1.0f\n\n",
		totals[QTY], totals[VALUE], totals[COUNT]);

  /*--- arrange to display/print */
  strcat(dest, "======================================================\n");
  strcat(dest, temp);
	return 0;
}

/* ============= does printing - handles page-breaks ======= */
void do_print (char* text)
{
  int err = 0;              /* holds return value of called funcs */
  char output[256] = "\0";  /* holds output text */

  /* ---- check if headings are needed ... do them if needed */
  if (lines_printed >= lines_per_page)
  {
    page_number++;
    err = do_header(output);  /* filled by function called */
    if (!err) puts(output);   /* output header */
    lines_printed = 1+ count_lines(output);
  }
  /* ---- in any case (with or without headings */
  puts(text);
  lines_printed = lines_printed + 1+ count_lines(text);
}

/* ================ counts lines in text =================== */
int count_lines(char* text)
{
  int k = 0;        /* loop control */
  int count = 0;    /* holds count of '\n' characters */

  for (k = 0; text[k] != '\0'; k++)
  {
    if (text[k] == '\n')
    {
      count++;
    }
  }
  return count;
}

/* ================ format header lines =================== */

int do_header(char* heading)
{
  /*--- format heading line */
  sprintf(heading, "\f\n\n%-5s %-5s %-20s %5s %7s %7s\n",
            "Cust#", "Inv#", "Inventory Item", "Qty", "Price", "Value");

  /*--- arrange to display/print */
  strcat(heading, "======================================================\n");
  return 0;
}
