// Copyright (C) 1999-2000 Id Software, Inc.
//
#include "ui_local.h"

#define ART_FRAMEL			"menu/art/frame2_l"
#define ART_FRAMER			"menu/art/frame1_r"
#define ART_MODEL0			"menu/art/model_0"
#define ART_MODEL1			"menu/art/model_1"
#define ART_BACK0			"menu/art/back_0"
#define ART_BACK1			"menu/art/back_1"
#define ART_FX_BASE			"menu/art/fx_base"
// q3app
#define ART_FX_SELECT                   "menu/art/colorsel"
#define ART_FX_SELOFF                   "menu/art/coloroff"
// not used anymore
/*
#define ART_FX_BLUE			"menu/art/fx_blue"
#define ART_FX_CYAN			"menu/art/fx_cyan"
#define ART_FX_GREEN		"menu/art/fx_grn"
#define ART_FX_RED			"menu/art/fx_red"
#define ART_FX_TEAL			"menu/art/fx_teal"
#define ART_FX_WHITE		"menu/art/fx_white"
#define ART_FX_YELLOW		"menu/art/fx_yel"
*/
// --
#define ID_NAME			10
// q3app
#define ID_CLAN                 11
#define ID_HANDICAP             12
//#define ID_EFFECTS              12
#define ID_TOPCOLOR             13
#define ID_LOWERCOLOR           14
#define ID_ROTATE               15
#define ID_BACK                 16
#define ID_MODEL                17
// --

#define MAX_NAMELENGTH	20
// q3app
#define MAX_CLANLENGTH  13

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
	menubitmap_s		player;

        menufield_s                     name;
// q3app (added clan)
        menufield_s                     clan;
	menulist_s			handicap;
// q3app (removed effects, added topcolor and lowcolor)
//        menulist_s                      effects;
        menulist_s                      topcolor;
        menulist_s                      lowercolor;
// --

// q3app (added rotate)
        menuslider_s            rotate;
	menubitmap_s		model;
	menubitmap_s		back;
	menubitmap_s		item_null;
	qhandle_t			fxBasePic;
//q3app
//        qhandle_t                       fxPic[7];
        qhandle_t                       fxSelectPic;
        qhandle_t                       fxSelOffPic;
// --
	playerInfo_t		playerinfo;
	int					current_fx;
	char				playerModel[MAX_QPATH];
} playersettings_t;

static playersettings_t	s_playersettings;
// q3app (not used anymore)
/*
static int gamecodetoui[] = {4,2,3,0,5,1,6};
static int uitogamecode[] = {4,6,2,3,1,5,7};
*/

static const char *handicap_items[] = {
	"None",
	"95",
	"90",
	"85",
	"80",
	"75",
	"70",
	"65",
	"60",
	"55",
	"50",
	"45",
	"40",
	"35",
	"30",
	"25",
	"20",
	"15",
	"10",
	"5",
	0
};

// q3app
static  int                     delta_time;

/*
=================
PlayerSettings_DrawName
=================
*/
static void PlayerSettings_DrawName( void *self ) {
	menufield_s		*f;
	qboolean		focus;
	int				style;
	char			*txt;
	char			c;
	float			*color;
	int				n;
	int				basex, x, y;
        char                    name[MAX_NAMELENGTH + MAX_CLANLENGTH + 2];

	f = (menufield_s*)self;
	basex = f->generic.x;
	y = f->generic.y;
	focus = (f->generic.parent->cursor == f->generic.menuPosition);

	style = UI_LEFT|UI_SMALLFONT;
	color = text_color_normal;
	if( focus ) {
		style |= UI_PULSE;
		color = text_color_highlight;
	}

	UI_DrawProportionalString( basex, y, "Name", style, color );

	// draw the actual name
	basex += 64;
	y += PROP_HEIGHT;
	txt = f->field.buffer;
	color = g_color_table[ColorIndex(COLOR_WHITE)];
	x = basex;
	while ( (c = *txt) != 0 ) {
		if ( !focus && Q_IsColorString( txt ) ) {
			n = ColorIndex( *(txt+1) );
			if( n == 0 ) {
				n = 7;
			}
			color = g_color_table[n];
			txt += 2;
			continue;
		}
		UI_DrawChar( x, y, c, style, color );
		txt++;
		x += SMALLCHAR_WIDTH;
	}

	// draw cursor if we have focus
	if( focus ) {
		if ( trap_Key_GetOverstrikeMode() ) {
			c = 11;
		} else {
			c = 10;
		}

		style &= ~UI_PULSE;
		style |= UI_BLINK;

		UI_DrawChar( basex + f->field.cursor * SMALLCHAR_WIDTH, y, c, style, color_white );
	}

	// draw at bottom also using proportional font
        Q_strncpyz( name, f->field.buffer, sizeof( name ) );

        if ( s_playersettings.clan.field.buffer[0] && Q_stricmp( s_playersettings.clan.field.buffer, "none" ) ) {
                char                    clan[MAX_CLANLENGTH];

                Q_strncpyz( clan, s_playersettings.clan.field.buffer, MAX_CLANLENGTH );
                while ( Q_PrintStrlen( clan ) > 4 )
                        clan[ strlen( clan ) - 1 ] = 0;
                strcat( name, "^7\16" );
                strcat( name, clan );
        }
// q3app (display name with scoreboard text)
//        Q_CleanStr( name );
//        UI_DrawProportionalString( 320, 440, name, UI_CENTER|UI_BIGFONT, text_color_normal );
        UI_DrawString( 320, 440, name, UI_CENTER|UI_BIGFONT, color_white );
// --
}

/* q3app
=================
PlayerSettings_DrawClan
=================
*/
static void PlayerSettings_DrawClan( void *self ) {
	menufield_s		*f;
	qboolean		focus;
	int				style;
	char			*txt;
	char			c;
	float			*color;
	int				n;
	int				basex, x, y;

	f = (menufield_s*)self;
	basex = f->generic.x;
	y = f->generic.y;
	focus = (f->generic.parent->cursor == f->generic.menuPosition);

	style = UI_LEFT|UI_SMALLFONT;
	color = text_color_normal;
	if( focus ) {
		style |= UI_PULSE;
		color = text_color_highlight;
	}

        UI_DrawProportionalString( basex, y, "Clan", style, color );

	// draw the actual name
	basex += 64;
	y += PROP_HEIGHT;
	txt = f->field.buffer;
	color = g_color_table[ColorIndex(COLOR_WHITE)];
	x = basex;
	while ( (c = *txt) != 0 ) {
		if ( !focus && Q_IsColorString( txt ) ) {
			n = ColorIndex( *(txt+1) );
			if( n == 0 ) {
				n = 7;
			}
			color = g_color_table[n];
			txt += 2;
			continue;
		}
		UI_DrawChar( x, y, c, style, color );
		txt++;
		x += SMALLCHAR_WIDTH;
	}

	// draw cursor if we have focus
	if( focus ) {
		if ( trap_Key_GetOverstrikeMode() ) {
			c = 11;
		} else {
			c = 10;
		}

		style &= ~UI_PULSE;
		style |= UI_BLINK;

		UI_DrawChar( basex + f->field.cursor * SMALLCHAR_WIDTH, y, c, style, color_white );
	}

}

/*
=================
PlayerSettings_DrawHandicap
=================
*/
static void PlayerSettings_DrawHandicap( void *self ) {
	menulist_s		*item;
	qboolean		focus;
	int				style;
	float			*color;

	item = (menulist_s *)self;
	focus = (item->generic.parent->cursor == item->generic.menuPosition);

	style = UI_LEFT|UI_SMALLFONT;
	color = text_color_normal;
	if( focus ) {
		style |= UI_PULSE;
		color = text_color_highlight;
	}

	UI_DrawProportionalString( item->generic.x, item->generic.y, "Handicap", style, color );
	UI_DrawProportionalString( item->generic.x + 64, item->generic.y + PROP_HEIGHT, handicap_items[item->curvalue], style, color );
}

// q3app (all future references to "PlayerSettings_DrawEffects" changed to "PlayerSettings_DrawTopColor")
/*
=================
PlayerSettings_DrawTopColor
=================
*/
static void PlayerSettings_DrawTopColor( void *self ) {
	menulist_s		*item;
	qboolean		focus;
	int				style;
	float			*color;

	item = (menulist_s *)self;
        focus = ( item->generic.parent->cursor == item->generic.menuPosition )
        || ( item->generic.parent->cursor == (item->generic.menuPosition + 1) );

	style = UI_LEFT|UI_SMALLFONT;
	color = text_color_normal;
        if ( focus ) {
		style |= UI_PULSE;
		color = text_color_highlight;
// q3app (color change)
                if ( item->generic.parent->cursor == item->generic.menuPosition ) {
                        s_playersettings.playerinfo.tc = item->curvalue + 1;
                }
// --                
	}

// q3app (changed "Effects" to "Colors")
        UI_DrawProportionalString( item->generic.x, item->generic.y, "Colors", style, color );
// q3app (changed fx_basepic size from 128 to 256)
        UI_DrawHandlePic( item->generic.x, item->generic.y + PROP_HEIGHT + 8, 256, 8, s_playersettings.fxBasePic );
// q3app
        if ( item->generic.parent->cursor == item->generic.menuPosition ) {
                UI_DrawHandlePic( item->generic.x + item->curvalue * 16, item->generic.y + PROP_HEIGHT + 5, 18, 14, s_playersettings.fxSelectPic );
                UI_DrawProportionalString( item->generic.x + 272, item->generic.y + PROP_HEIGHT, va("%i", item->curvalue + 1), UI_LEFT|UI_SMALLFONT|UI_CENTER|UI_PULSE, text_color_highlight );
        } else {
                UI_DrawHandlePic( item->generic.x + item->curvalue * 16, item->generic.y + PROP_HEIGHT + 5, 18, 14, s_playersettings.fxSelOffPic );
                UI_DrawProportionalString( item->generic.x + 272, item->generic.y + PROP_HEIGHT, va("%i", item->curvalue + 1), UI_LEFT|UI_SMALLFONT|UI_CENTER, text_color_normal );
        }

// --
}

/* q3app
=================
PlayerSettings_DrawLowerColor
=================
*/
static void PlayerSettings_DrawLowerColor( void *self ) {
	menulist_s		*item;
	qboolean		focus;
	int				style;
	float			*color;

	item = (menulist_s *)self;
        focus = ( item->generic.parent->cursor == item->generic.menuPosition );

        if ( focus ) {
                        s_playersettings.playerinfo.lc = item->curvalue + 1;
	}

        UI_DrawHandlePic( item->generic.x, item->generic.y + PROP_HEIGHT + 8, 256, 8, s_playersettings.fxBasePic );
        if ( focus ) {
                UI_DrawHandlePic( item->generic.x + item->curvalue * 16, item->generic.y + PROP_HEIGHT + 5, 18, 14, s_playersettings.fxSelectPic );
                UI_DrawProportionalString( item->generic.x + 272, item->generic.y + PROP_HEIGHT, va("%i", item->curvalue + 1 ), UI_LEFT|UI_SMALLFONT|UI_CENTER|UI_PULSE, text_color_highlight );
        } else {
                UI_DrawHandlePic( item->generic.x + item->curvalue * 16, item->generic.y + PROP_HEIGHT + 5, 18, 14, s_playersettings.fxSelOffPic );
                UI_DrawProportionalString( item->generic.x + 272, item->generic.y + PROP_HEIGHT, va("%i", item->curvalue + 1 ), UI_LEFT|UI_SMALLFONT|UI_CENTER, text_color_normal );
        }

}

/*
=================
PlayerSettings_DrawPlayer
=================
*/
// q3app
#define ANGLE_STEP_PER_TIME 10
#define ANGLE_TIME_STEP 27
// --
static void PlayerSettings_DrawPlayer( void *self ) {
	menubitmap_s	*b;
	vec3_t			viewangles;
// q3app (was buf[MAX_QPATH])
        char                    buf[MAX_INFO_STRING];
        int                     delta_angle;
// --

	trap_Cvar_VariableStringBuffer( "model", buf, sizeof( buf ) );
	if ( strcmp( buf, s_playersettings.playerModel ) != 0 ) {
		UI_PlayerInfo_SetModel( &s_playersettings.playerinfo, buf );
		strcpy( s_playersettings.playerModel, buf );
// q3app (was 180 - 30)
                viewangles[YAW]   = s_playersettings.rotate.curvalue * 30;
		viewangles[PITCH] = 0;
		viewangles[ROLL]  = 0;
                UI_PlayerInfo_SetInfo( &s_playersettings.playerinfo, LEGS_IDLE, TORSO_STAND, viewangles, vec3_origin, WP_MACHINEGUN, qfalse );
// q3app (set colors)
                s_playersettings.playerinfo.tc = s_playersettings.topcolor.curvalue + 1;
                s_playersettings.playerinfo.lc = s_playersettings.lowercolor.curvalue + 1;
// --
// q3app (check for value changes on cg_color)
        } else {

                trap_Cvar_VariableStringBuffer( "cg_color", buf, MAX_INFO_STRING );
        
                if ( strcmp( buf, cg_color ) != 0 ) {
                        int     temp_tc, temp_lc;
        
                        Q_strncpyz( cg_color, buf, MAX_INFO_STRING );
                        temp_tc = atoi( cvar_argv( cg_color, 1) );
                        temp_lc = atoi( cvar_argv( cg_color, 2) );
                        if ( temp_tc > 16 || temp_tc < 1 ) {
                                temp_tc = 16;
                        }
                        if ( temp_lc > 16 || temp_lc < 1 ) {
                                temp_lc = 16;
                        }
                        s_playersettings.topcolor.curvalue = temp_tc - 1;
                        s_playersettings.lowercolor.curvalue = temp_lc - 1;
                        s_playersettings.playerinfo.tc = temp_tc;
                        s_playersettings.playerinfo.lc = temp_lc;
                }
        
                if ( delta_time < uis.realtime ) {
                        delta_angle = ( ( s_playersettings.rotate.curvalue * 30) - s_playersettings.playerinfo.viewAngles[YAW] );
                        delta_angle = delta_angle < ANGLE_STEP_PER_TIME ? delta_angle > -ANGLE_STEP_PER_TIME ? 0 : -ANGLE_STEP_PER_TIME : ANGLE_STEP_PER_TIME;
                        s_playersettings.playerinfo.viewAngles[YAW] += delta_angle;
                        delta_time = uis.realtime + ANGLE_TIME_STEP;
                }
        }
// --
	b = (menubitmap_s*) self;
	UI_DrawPlayer( b->generic.x, b->generic.y, b->width, b->height, &s_playersettings.playerinfo, uis.realtime/2 );
}


/*
=================
PlayerSettings_SaveChanges
=================
*/
static void PlayerSettings_SaveChanges( void ) {
	// name
	trap_Cvar_Set( "name", s_playersettings.name.field.buffer );
// q3app
        // clan
        trap_Cvar_Set( "clan", s_playersettings.clan.field.buffer );
// --
	// handicap
	trap_Cvar_SetValue( "handicap", 100 - s_playersettings.handicap.curvalue * 5 );

	// effects color
// q3app
//        trap_Cvar_SetValue( "color", uitogamecode[s_playersettings.effects.curvalue] );
        trap_Cvar_Set( "cg_color", va("%i %i", s_playersettings.topcolor.curvalue + 1, s_playersettings.lowercolor.curvalue + 1) );
// --
}


/*
=================
PlayerSettings_MenuKey
=================
*/
static sfxHandle_t PlayerSettings_MenuKey( int key ) {
	if( key == K_MOUSE2 || key == K_ESCAPE ) {
		PlayerSettings_SaveChanges();
	}
	return Menu_DefaultKey( &s_playersettings.menu, key );
}


/*
=================
PlayerSettings_SetMenuItems
=================
*/
static void PlayerSettings_SetMenuItems( void ) {
	vec3_t	viewangles;
	int		c;
	int		h;

// q3app
        delta_time = 0;

	// name
	Q_strncpyz( s_playersettings.name.field.buffer, UI_Cvar_VariableString("name"), sizeof(s_playersettings.name.field.buffer) );

// q3app
        // clan
        Q_strncpyz( s_playersettings.clan.field.buffer, UI_Cvar_VariableString("clan"), sizeof(s_playersettings.clan.field.buffer) );
// --

        // model/skin
	memset( &s_playersettings.playerinfo, 0, sizeof(playerInfo_t) );

        viewangles[YAW]   = 180 - 30;
	viewangles[PITCH] = 0;
	viewangles[ROLL]  = 0;

	UI_PlayerInfo_SetModel( &s_playersettings.playerinfo, UI_Cvar_VariableString( "model" ) );
	UI_PlayerInfo_SetInfo( &s_playersettings.playerinfo, LEGS_IDLE, TORSO_STAND, viewangles, vec3_origin, WP_MACHINEGUN, qfalse );

// q3app (update cg_force)
        trap_Cvar_VariableStringBuffer( "cg_force", cg_force, MAX_INFO_STRING );

	// effects color
// q3app (top and lower colors)
        trap_Cvar_VariableStringBuffer( "cg_color", cg_color, MAX_INFO_STRING );
        c = atoi( cvar_argv( cg_color, 1 ) );
        if( c < 1 || c > 16 ) {
                c = 16;
	}

        s_playersettings.playerinfo.tc = c;
        s_playersettings.topcolor.curvalue = c - 1;

        c = atoi( cvar_argv( cg_color, 2 ) );
        if( c < 1 || c > 16 ) {
                c = 16;
	}

        s_playersettings.playerinfo.lc = c;
        s_playersettings.lowercolor.curvalue = c - 1;

// --

	// handicap
	h = Com_Clamp( 5, 100, trap_Cvar_VariableValue("handicap") );
	s_playersettings.handicap.curvalue = 20 - h / 5;

// q3app
        s_playersettings.rotate.curvalue = 5;

}


/*
=================
PlayerSettings_MenuEvent
=================
*/
static void PlayerSettings_MenuEvent( void* ptr, int event ) {
// q3app
vec3_t          viewangles;

	if( event != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_HANDICAP:
		trap_Cvar_Set( "handicap", va( "%i", 100 - 25 * s_playersettings.handicap.curvalue ) );
		break;

	case ID_MODEL:                
		PlayerSettings_SaveChanges();
		UI_PlayerModelMenu();
// q3app
                PlayerSettings_SetMenuItems();
                s_playersettings.playerModel[0] = '\0'; // hackish
// --
		break;

	case ID_BACK:
		PlayerSettings_SaveChanges();
		UI_PopMenu();
		break;
	}
}


/*
=================
PlayerSettings_MenuInit
=================
*/
static void PlayerSettings_MenuInit( void ) {
	int		y;

	memset(&s_playersettings,0,sizeof(playersettings_t));

	PlayerSettings_Cache();

	s_playersettings.menu.key        = PlayerSettings_MenuKey;
	s_playersettings.menu.wrapAround = qtrue;
	s_playersettings.menu.fullscreen = qtrue;

	s_playersettings.banner.generic.type  = MTYPE_BTEXT;
	s_playersettings.banner.generic.x     = 320;
	s_playersettings.banner.generic.y     = 16;
	s_playersettings.banner.string        = "PLAYER SETTINGS";
	s_playersettings.banner.color         = color_white;
	s_playersettings.banner.style         = UI_CENTER;

	s_playersettings.framel.generic.type  = MTYPE_BITMAP;
	s_playersettings.framel.generic.name  = ART_FRAMEL;
	s_playersettings.framel.generic.flags = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_playersettings.framel.generic.x     = 0;
	s_playersettings.framel.generic.y     = 78;
	s_playersettings.framel.width         = 256;
	s_playersettings.framel.height        = 329;

	s_playersettings.framer.generic.type  = MTYPE_BITMAP;
	s_playersettings.framer.generic.name  = ART_FRAMER;
	s_playersettings.framer.generic.flags = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_playersettings.framer.generic.x     = 376;
	s_playersettings.framer.generic.y     = 76;
	s_playersettings.framer.width         = 256;
	s_playersettings.framer.height        = 334;

// q3app (raised this a bit, was 144)
        y = 100;
	s_playersettings.name.generic.type			= MTYPE_FIELD;
	s_playersettings.name.generic.flags			= QMF_NODEFAULTINIT;
	s_playersettings.name.generic.ownerdraw		= PlayerSettings_DrawName;
	s_playersettings.name.field.widthInChars	= MAX_NAMELENGTH;
	s_playersettings.name.field.maxchars		= MAX_NAMELENGTH;
	s_playersettings.name.generic.x				= 192;
	s_playersettings.name.generic.y				= y;
	s_playersettings.name.generic.left			= 192 - 8;
	s_playersettings.name.generic.top			= y - 8;
	s_playersettings.name.generic.right			= 192 + 200;
	s_playersettings.name.generic.bottom		= y + 2 * PROP_HEIGHT;

// q3app (added clan)
        y += 2.5 * PROP_HEIGHT;
        s_playersettings.clan.generic.type                      = MTYPE_FIELD;
        s_playersettings.clan.generic.flags                     = QMF_NODEFAULTINIT;
        s_playersettings.clan.generic.id                        = ID_CLAN;
        s_playersettings.clan.generic.ownerdraw         = PlayerSettings_DrawClan;
        s_playersettings.clan.field.widthInChars        = MAX_CLANLENGTH;
        s_playersettings.clan.field.maxchars            = MAX_CLANLENGTH;
        s_playersettings.clan.generic.x                         = 192;
        s_playersettings.clan.generic.y                         = y;
        s_playersettings.clan.generic.left                      = 192 - 8;
        s_playersettings.clan.generic.top                       = y - 8;
        s_playersettings.clan.generic.right                     = 192 + 200;
        s_playersettings.clan.generic.bottom            = y + 2 * PROP_HEIGHT;
// --
// q3app (was "y += 3 * PROP_HEIGHT;")
        y += 2.5 * PROP_HEIGHT;
	s_playersettings.handicap.generic.type		= MTYPE_SPINCONTROL;
	s_playersettings.handicap.generic.flags		= QMF_NODEFAULTINIT;
	s_playersettings.handicap.generic.id		= ID_HANDICAP;
	s_playersettings.handicap.generic.ownerdraw	= PlayerSettings_DrawHandicap;
	s_playersettings.handicap.generic.x			= 192;
	s_playersettings.handicap.generic.y			= y;
	s_playersettings.handicap.generic.left		= 192 - 8;
	s_playersettings.handicap.generic.top		= y - 8;
        s_playersettings.handicap.generic.right         = 192 + 200;
	s_playersettings.handicap.generic.bottom	= y + 2 * PROP_HEIGHT;
	s_playersettings.handicap.numitems			= 20;

// q3app (was "y += 3 * PROP_HEIGHT;")
        y += 2.5 * PROP_HEIGHT;
// q3app (changed effects to topcolor)
        s_playersettings.topcolor.generic.type           = MTYPE_SPINCONTROL;
        s_playersettings.topcolor.generic.flags          = QMF_NODEFAULTINIT;
        s_playersettings.topcolor.generic.id                     = ID_TOPCOLOR;
        s_playersettings.topcolor.generic.ownerdraw      = PlayerSettings_DrawTopColor;
        s_playersettings.topcolor.generic.x                      = 192;
        s_playersettings.topcolor.generic.y                      = y;
        s_playersettings.topcolor.generic.left           = 192 - 8;
        s_playersettings.topcolor.generic.top            = y - 8;
        s_playersettings.topcolor.generic.right          = 192 + 256;
        s_playersettings.topcolor.generic.bottom         = y + 2* PROP_HEIGHT;
        s_playersettings.topcolor.numitems                       = 16;
// --
// q3app (added lowercolor)
        y += PROP_HEIGHT;
        s_playersettings.lowercolor.generic.type           = MTYPE_SPINCONTROL;
        s_playersettings.lowercolor.generic.flags          = QMF_NODEFAULTINIT;
        s_playersettings.lowercolor.generic.id                     = ID_LOWERCOLOR;
        s_playersettings.lowercolor.generic.ownerdraw      = PlayerSettings_DrawLowerColor;
        s_playersettings.lowercolor.generic.x                      = 192;
        s_playersettings.lowercolor.generic.y                      = y;
        s_playersettings.lowercolor.generic.left           = 192 - 8;
        s_playersettings.lowercolor.generic.top            = y - 8;
        s_playersettings.lowercolor.generic.right          = 192 + 256;
        s_playersettings.lowercolor.generic.bottom         = y + 2* PROP_HEIGHT;
        s_playersettings.lowercolor.numitems                       = 16;
// --

	s_playersettings.model.generic.type			= MTYPE_BITMAP;
	s_playersettings.model.generic.name			= ART_MODEL0;
        s_playersettings.model.generic.flags            = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_playersettings.model.generic.id			= ID_MODEL;
	s_playersettings.model.generic.callback		= PlayerSettings_MenuEvent;
        s_playersettings.model.generic.x                        = 640;
        s_playersettings.model.generic.y                        = 480-64;
// --
	s_playersettings.model.width				= 128;
	s_playersettings.model.height				= 64;
	s_playersettings.model.focuspic				= ART_MODEL1;

// q3app (added rotate)
        s_playersettings.rotate.generic.type                       = MTYPE_SLIDER;
        s_playersettings.rotate.generic.name                       = "";
        s_playersettings.rotate.generic.callback                   = PlayerSettings_MenuEvent;
        s_playersettings.rotate.generic.id                         = ID_ROTATE;
        s_playersettings.rotate.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_playersettings.rotate.generic.x                          = 640-128;
        s_playersettings.rotate.generic.y                          = 480-96;
        s_playersettings.rotate.minvalue                           = 0;
        s_playersettings.rotate.maxvalue                           = 12;

// --

	s_playersettings.player.generic.type		= MTYPE_BITMAP;
	s_playersettings.player.generic.flags		= QMF_INACTIVE;
	s_playersettings.player.generic.ownerdraw	= PlayerSettings_DrawPlayer;
	s_playersettings.player.generic.x			= 400;
	s_playersettings.player.generic.y			= -40;
	s_playersettings.player.width				= 32*10;
	s_playersettings.player.height				= 56*10;

	s_playersettings.back.generic.type			= MTYPE_BITMAP;
	s_playersettings.back.generic.name			= ART_BACK0;
	s_playersettings.back.generic.flags			= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_playersettings.back.generic.id			= ID_BACK;
	s_playersettings.back.generic.callback		= PlayerSettings_MenuEvent;
	s_playersettings.back.generic.x				= 0;
	s_playersettings.back.generic.y				= 480-64;
	s_playersettings.back.width					= 128;
	s_playersettings.back.height				= 64;
	s_playersettings.back.focuspic				= ART_BACK1;

	s_playersettings.item_null.generic.type		= MTYPE_BITMAP;
	s_playersettings.item_null.generic.flags	= QMF_LEFT_JUSTIFY|QMF_MOUSEONLY|QMF_SILENT;
	s_playersettings.item_null.generic.x		= 0;
	s_playersettings.item_null.generic.y		= 0;
	s_playersettings.item_null.width			= 640;
	s_playersettings.item_null.height			= 480;

	Menu_AddItem( &s_playersettings.menu, &s_playersettings.banner );
	Menu_AddItem( &s_playersettings.menu, &s_playersettings.framel );
	Menu_AddItem( &s_playersettings.menu, &s_playersettings.framer );

// q3app (moved it up here, so it'll render before others
	Menu_AddItem( &s_playersettings.menu, &s_playersettings.player );

	Menu_AddItem( &s_playersettings.menu, &s_playersettings.name );
// q3app
        Menu_AddItem( &s_playersettings.menu, &s_playersettings.clan );

	Menu_AddItem( &s_playersettings.menu, &s_playersettings.handicap );
// q3app (changed effects to topcolor and added lowercolor and rotate)
        Menu_AddItem( &s_playersettings.menu, &s_playersettings.topcolor );
        Menu_AddItem( &s_playersettings.menu, &s_playersettings.lowercolor );

        Menu_AddItem( &s_playersettings.menu, &s_playersettings.rotate );
// --
	Menu_AddItem( &s_playersettings.menu, &s_playersettings.model );

	Menu_AddItem( &s_playersettings.menu, &s_playersettings.back );

	Menu_AddItem( &s_playersettings.menu, &s_playersettings.item_null );

	PlayerSettings_SetMenuItems();
}


/*
=================
PlayerSettings_Cache
=================
*/
void PlayerSettings_Cache( void ) {
	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_MODEL0 );
	trap_R_RegisterShaderNoMip( ART_MODEL1 );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );

	s_playersettings.fxBasePic = trap_R_RegisterShaderNoMip( ART_FX_BASE );

// q3app
        s_playersettings.fxSelectPic = trap_R_RegisterShaderNoMip( ART_FX_SELECT );
        s_playersettings.fxSelOffPic = trap_R_RegisterShaderNoMip( ART_FX_SELOFF );
// (not using these anymore)
/*
	s_playersettings.fxPic[0] = trap_R_RegisterShaderNoMip( ART_FX_RED );
	s_playersettings.fxPic[1] = trap_R_RegisterShaderNoMip( ART_FX_YELLOW );
	s_playersettings.fxPic[2] = trap_R_RegisterShaderNoMip( ART_FX_GREEN );
	s_playersettings.fxPic[3] = trap_R_RegisterShaderNoMip( ART_FX_TEAL );
	s_playersettings.fxPic[4] = trap_R_RegisterShaderNoMip( ART_FX_BLUE );
	s_playersettings.fxPic[5] = trap_R_RegisterShaderNoMip( ART_FX_CYAN );
	s_playersettings.fxPic[6] = trap_R_RegisterShaderNoMip( ART_FX_WHITE );
*/
// --
}


/*
=================
UI_PlayerSettingsMenu
=================
*/
void UI_PlayerSettingsMenu( void ) {
	PlayerSettings_MenuInit();
	UI_PushMenu( &s_playersettings.menu );
}
