// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

Q3APP MESSAGE MODE INPUT

=======================================================================
*/


#include "ui_local.h"

#define MSGMODE_HISTORY_SIZE 16
#define MSG_SIZE 149

typedef struct {
	menuframework_s		menu;

        menufield_s             text;
} msgmode_t;

static msgmode_t s_msgmode;

static int                      overstrike_mode;

static char                     msg_history[MSGMODE_HISTORY_SIZE][MSG_SIZE];

int                             msg_history_pos;

/*
=================
UI_MsgMode_f
=================
*/
void UI_MsgMode_f( void ) {
        trap_Key_SetCatcher( KEYCATCH_UI );
        uis.menusp = 0;
        UI_MsgModeMenu();
}

static void MsgMode_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {

        case 1:
                break;
        }
}

/*
=================
MsgMode_AddToHistory
=================
*/
static void MsgMode_AddToHistory( void ) {
        int     i, j;
        char    temp_buffer1[MSG_SIZE], temp_buffer2[MSG_SIZE];

        if ( !s_msgmode.text.field.buffer[0] )
                return;

        for ( i = 0; i <= MSGMODE_HISTORY_SIZE; i++ ) { // erase any previous occurences
                if ( !strcmp( s_msgmode.text.field.buffer, msg_history[i] ) ) {
                        msg_history[i][0] = '\0';
                }
        }

        Q_strncpyz( temp_buffer2, s_msgmode.text.field.buffer, MSG_SIZE );

        for ( i = 0, j = 0; i < MSGMODE_HISTORY_SIZE; i++ ) {
                if ( msg_history[i][0] ) {
                        Q_strncpyz( temp_buffer1, msg_history[i], MSG_SIZE );
                        Q_strncpyz( msg_history[j], temp_buffer2, MSG_SIZE );
                        Q_strncpyz( temp_buffer2, temp_buffer1, MSG_SIZE );
                        j++;
                }
        }

        Q_strncpyz( msg_history[j > MSGMODE_HISTORY_SIZE ? MSGMODE_HISTORY_SIZE : j], temp_buffer2, MSG_SIZE );
}

/*
=================
MsgMode_DrawText
=================
*/
static void MsgMode_DrawText( void *self ) {
	menufield_s		*f;
	qboolean		focus;
	int				style;
	char			*txt;
	char			c;
	float			*color;
	int				n;
        int                             basex, basey, x, y;
	char			name[32];
        vec4_t                  color_say = { 0.00, 0.00, 0.00, 0.50};

	f = (menufield_s*)self;
	basex = f->generic.x;
        basey = f->generic.y;
	focus = (f->generic.parent->cursor == f->generic.menuPosition);

        style = UI_LEFT|UI_BIGFONT|UI_DROPSHADOW;
	color = text_color_normal;

        UI_FillRect( basex - 8, basey - 28, basex + BIGCHAR_WIDTH * 38, basey + ( ( strlen( f->field.buffer ) / 38 ) * BIGCHAR_HEIGHT), color_say );
        UI_DrawProportionalString( basex, basey - 20, "Say:", UI_LEFT|UI_SMALLFONT|UI_DROPSHADOW, color_white );

	if( focus ) {
//                style |= UI_PULSE;
		color = text_color_highlight;
	}

        // draw the actual text
	txt = f->field.buffer;
	color = g_color_table[ColorIndex(COLOR_WHITE)];
	x = basex;
        y = basey;
	while ( (c = *txt) != 0 ) {
                if ( !focus && Q_IsColorString( txt ) ) {
			n = ColorIndex( *(txt+1) );
			if( n == 0 ) {
				n = 7;
			}
			color = g_color_table[n];
			txt += 2;
			continue;
		}
		UI_DrawChar( x, y, c, style, color );
		txt++;
                x += BIGCHAR_WIDTH;
                if ( x > basex + BIGCHAR_WIDTH * 37 ) {
                        x = basex;
                        y += BIGCHAR_HEIGHT;
                }
	}

	// draw cursor if we have focus
	if( focus ) {
		if ( trap_Key_GetOverstrikeMode() ) {
                        c = 10;
		} else {
                        c = 11;
		}

		style &= ~UI_PULSE;
		style |= UI_BLINK;

                UI_DrawChar( basex + ( f->field.cursor % 38 ) * BIGCHAR_WIDTH, basey + ( (int)( f->field.cursor / 38) ) * BIGCHAR_HEIGHT, c, style, color_white );
	}
        f->generic.bottom = y + BIGCHAR_HEIGHT;
}

static sfxHandle_t MsgMode_MenuKey( int key ) {
        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
//                trap_Key_SetBinding( 96, "toggleconsole" );
//                trap_Key_SetBinding( 126, "toggleconsole" );
                trap_Key_SetOverstrikeMode( !trap_Key_GetOverstrikeMode() );
		break;
        case K_BACKSPACE:
        case K_LEFTARROW:
        case K_HOME:
                if ( !s_msgmode.text.field.cursor )
                        return menu_buzz_sound;
                break;
        case K_ENTER:
                MsgMode_AddToHistory();
//                trap_Key_SetBinding( 96, "toggleconsole" );
//                trap_Key_SetBinding( 126, "toggleconsole" );
                trap_Cmd_ExecuteText( EXEC_APPEND, va( "say_all \"%s\"\n", s_msgmode.text.field.buffer ) );
                trap_Key_SetOverstrikeMode( !trap_Key_GetOverstrikeMode() );
                UI_PopMenu();
                break;
        case K_UPARROW:
                msg_history_pos++;
                if ( msg_history_pos > MSGMODE_HISTORY_SIZE ) {
                        msg_history_pos = MSGMODE_HISTORY_SIZE;
                        return menu_buzz_sound;
                }

                if ( !msg_history[msg_history_pos][0] ) {
                        msg_history_pos--;
                        return menu_buzz_sound;
                }

                strcpy( s_msgmode.text.field.buffer, msg_history[msg_history_pos] );
                s_msgmode.text.field.cursor = strlen( s_msgmode.text.field.buffer );
                return menu_move_sound;
                break;
        case K_DOWNARROW:
                msg_history_pos--;
                if ( msg_history_pos < -1 ) {
                        msg_history_pos = -1;
                        return menu_buzz_sound;
                }

                strcpy( s_msgmode.text.field.buffer, msg_history[msg_history_pos] );
                s_msgmode.text.field.cursor = strlen( s_msgmode.text.field.buffer );
                return menu_move_sound;
                break;
        default:
                if ( s_msgmode.text.field.cursor == MSG_SIZE )
                        return menu_buzz_sound;
	}

        return ( Menu_DefaultKey( &s_msgmode.menu, key ) );

}

static void MsgMode_MenuInit( void ) {

        memset( &s_msgmode, 0 ,sizeof(msgmode_t) );

        MsgMode_Cache();

        s_msgmode.text.generic.type                     = MTYPE_FIELD;
        s_msgmode.text.generic.flags                    = QMF_NODEFAULTINIT;
        s_msgmode.text.generic.ownerdraw                = MsgMode_DrawText;
        s_msgmode.text.field.widthInChars               = MSG_SIZE;
        s_msgmode.text.field.maxchars                   = MSG_SIZE;
        s_msgmode.text.generic.x                        = 16;
        s_msgmode.text.generic.y                        = 59;
        s_msgmode.text.generic.left                     = 16;
        s_msgmode.text.generic.top                      = 59;
        s_msgmode.text.generic.right                    = 624;
        s_msgmode.text.generic.bottom                   = 59 + BIGCHAR_HEIGHT;

        s_msgmode.menu.key        = MsgMode_MenuKey;
        s_msgmode.menu.wrapAround = qtrue;
        s_msgmode.menu.fullscreen = qfalse;

        Menu_AddItem( &s_msgmode.menu, &s_msgmode.text );

        overstrike_mode = trap_Key_GetOverstrikeMode();

        trap_Key_SetOverstrikeMode( !overstrike_mode );

//        trap_Key_SetBinding( 96, "" );
//        trap_Key_SetBinding( 126, "" );

        msg_history_pos = -1;
}


/*
===============
MsgMode_Cache
===============
*/
void MsgMode_Cache( void ) {

}


/*
===============
UI_MsgModeMenu
===============
*/
void UI_MsgModeMenu( void ) {
        MsgMode_MenuInit();
        UI_PushMenu( &s_msgmode.menu );
}
