// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

GAME OPTIONS HUD MENU

=======================================================================
*/


#include "ui_local.h"


#define ART_FRAMEL				"menu/art/frame2_l"
#define ART_FRAMER				"menu/art/frame1_r"
#define ART_BACK0				"menu/art/back_0"
#define ART_BACK1				"menu/art/back_1"

#define GAME_OPTIONS_MAIN_X_POS          210

#define GAME_OPTIONS_X_POS               384

#define ID_HUD                          127
#define ID_XHAIR                        128
#define ID_EFFECTS                      129
#define ID_WEAPONS                      130
#define ID_SCORES                       131
#define ID_MISC                         132

// menu-specific IDs
#define ID_HUD_NOTHING                  140
#define ID_HUD_ATTACKER                 141
#define ID_HUD_SCORE                    142
#define ID_HUD_FPS                      143
#define ID_HUD_TIMER                    144
#define ID_HUD_AMMOWARNING              145
#define ID_HUD_DAMAGE                   146
#define ID_HUD_REWARDS                  147
#define ID_HUD_LAGOMETER                148
#define ID_HUD_ALLAMMO                  149
#define ID_HUD_PICKUP                   150
#define ID_HUD_MEMORY                   151
#define ID_HUD_ICONS                    152
#define ID_HUD_OVERLAY                  153

#define ID_XHAIR_STYLE                  154
#define ID_XHAIR_SIZE                   155
#define ID_XHAIR_COLOR_R                156
#define ID_XHAIR_COLOR_G                157
#define ID_XHAIR_COLOR_B                158
#define ID_XHAIR_HEALTH                 159
#define ID_XHAIR_NAME                   160
#define ID_XHAIR_PICKUP                 161

#define ID_WEAPONS_POS                  162
#define ID_WEAPONS_FLASH                163
#define ID_WEAPONS_AUTO                 164
#define ID_WEAPONS_NOAMMO               165
#define ID_WEAPONS_LIST                 166

#define ID_EFFECTS_DLIGHTS              167
#define ID_EFFECTS_NUMMARKS             168
#define ID_EFFECTS_MARKTIME             169
#define ID_EFFECTS_NUMGIBS              170
#define ID_EFFECTS_GIBTIME              171
#define ID_EFFECTS_RAILTIME             172
#define ID_EFFECTS_BRASSTIME            173
#define ID_EFFECTS_SMOKEALPHA           174
#define ID_EFFECTS_BLOODALPHA           175

#define ID_MISC_FASTRESPAWN             178
#define ID_MISC_SIMPLEITEMS             179
#define ID_MISC_DEFERPLAYERS            180

#define ID_MISC_ZOOM_FOV                181
#define ID_MISC_ZOOM_TIME               182
#define ID_MISC_ZOOM_SENS               183

#define ID_MISC_ANNOUNCER_LEADTIED      184
#define ID_MISC_ANNOUNCER_COUNTDOWN     185
#define ID_MISC_ANNOUNCER_REWARDS       186
#define ID_MISC_ANNOUNCER_POWERUPS      187
#define ID_MISC_ANNOUNCER_EXTRA         188

#define ID_MISC_HITBEEP                 189
#define ID_MISC_PAINBEEP                190
#define ID_MISC_TEAMBEEP                191
#define ID_MISC_TIMEBEEP                192

#define ID_MISC_FORCE_STD_SKIN          193
#define ID_MISC_FORCE_STD_MODEL         194
#define ID_MISC_FORCE_STD_SOUND         195
#define ID_MISC_FORCE_TEAM_COLOR        196
#define ID_MISC_FORCE_SAME_MODEL        197

#define ID_BACK                         200

static  char                            cg_alpha[MAX_INFO_STRING];
static  char                            cg_announcer[MAX_INFO_STRING];
static  char                            cg_draw[MAX_INFO_STRING];
static  char                            cg_fx[MAX_INFO_STRING];
static  char                            cg_gun[MAX_INFO_STRING];
static  char                            cg_noBeeps[MAX_INFO_STRING];
static  char                            cg_switch[MAX_INFO_STRING];
static  char                            cg_team[MAX_INFO_STRING];
static  char                            cg_xhair[MAX_INFO_STRING];
static  char                            cg_zoom[MAX_INFO_STRING];

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

        menutext_s              hud;
        menutext_s              crosshair;
        menutext_s              weapons;
        menutext_s              effects;
        menutext_s              scores;
        menutext_s              misc;

// menu-specific stuff
        menuradiobutton_s       nothing;
        menuradiobutton_s       attacker;
        menuradiobutton_s       score;
        menuradiobutton_s       fps;
        menuradiobutton_s       timer;
        menuradiobutton_s       ammowarn;
        menuradiobutton_s       damage;
        menuradiobutton_s       rewards;
        menuradiobutton_s       lagometer;
        menuradiobutton_s       allammo;
        menuradiobutton_s       pickup;
        menuradiobutton_s       memory;
        menulist_s              icons;
        menulist_s              teamoverlay;

	menubitmap_s		back;

} optionshud_t;

static optionshud_t s_optionshud;

static const char *teamoverlay_names[] =
{
	"off",
	"upper right",
	"lower right",
	"lower left",
	0
};

static const char *icons_names[] =
{
	"off",
        "2D Icons",
        "3D Icons",
/*        "3D Icons(2)",
        "3D Icons(3)", */
	0
};

static void OptionsHUD_Nothing( void ) {
        int     i;
        if ( s_optionshud.nothing.curvalue ) {
                s_optionshud.attacker.generic.flags |= QMF_GRAYED;
                s_optionshud.score.generic.flags |= QMF_GRAYED;
                s_optionshud.fps.generic.flags |= QMF_GRAYED;
                s_optionshud.timer.generic.flags |= QMF_GRAYED;
                s_optionshud.ammowarn.generic.flags |= QMF_GRAYED;
                s_optionshud.damage.generic.flags |= QMF_GRAYED;
                s_optionshud.rewards.generic.flags |= QMF_GRAYED;
                s_optionshud.lagometer.generic.flags |= QMF_GRAYED;
                s_optionshud.allammo.generic.flags |= QMF_GRAYED;
                s_optionshud.pickup.generic.flags |= QMF_GRAYED;
                s_optionshud.memory.generic.flags |= QMF_GRAYED;
                s_optionshud.icons.generic.flags |= QMF_GRAYED;
                s_optionshud.teamoverlay.generic.flags |= QMF_GRAYED;
        } else {
                s_optionshud.attacker.generic.flags &= ~QMF_GRAYED;
                s_optionshud.score.generic.flags &= ~QMF_GRAYED;
                s_optionshud.fps.generic.flags &= ~QMF_GRAYED;
                s_optionshud.timer.generic.flags &= ~QMF_GRAYED;
                s_optionshud.ammowarn.generic.flags &= ~QMF_GRAYED;
                s_optionshud.damage.generic.flags &= ~QMF_GRAYED;
                s_optionshud.rewards.generic.flags &= ~QMF_GRAYED;
                s_optionshud.lagometer.generic.flags &= ~QMF_GRAYED;
                s_optionshud.allammo.generic.flags &= ~QMF_GRAYED;
                s_optionshud.pickup.generic.flags &= ~QMF_GRAYED;
                s_optionshud.memory.generic.flags &= ~QMF_GRAYED;
                s_optionshud.icons.generic.flags &= ~QMF_GRAYED;
                s_optionshud.teamoverlay.generic.flags &= ~QMF_GRAYED;
        }
}

static void OptionsHUD_SetMenuItems( void ) {
        int     i;

        trap_Cvar_VariableStringBuffer( "cg_draw", cg_draw, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_draw, 1 ) );

        s_optionshud.attacker.curvalue = i & CG_DRAW_NOATTACKER ? 0 : 1;
        s_optionshud.score.curvalue = i & CG_DRAW_NOSCORES ? 0 : 1;
        s_optionshud.fps.curvalue = i & CG_DRAW_FPS ? 1 : 0;
        s_optionshud.timer.curvalue = i & CG_DRAW_NOTIMER ? 0 : 1;
        s_optionshud.ammowarn.curvalue = i & CG_DRAW_NOAMMOWARN ? 0 : 1;
        s_optionshud.damage.curvalue = i & CG_DRAW_NODAMAGE ? 0 : 1;
        s_optionshud.rewards.curvalue = i & CG_DRAW_NOREWARDS ? 0 : 1;
        s_optionshud.lagometer.curvalue = i & CG_DRAW_NOLAGOMETER ? 0 : 1;
        s_optionshud.allammo.curvalue = i & CG_DRAW_ALLAMMO ? 1 : 0;
        s_optionshud.pickup.curvalue = i & CG_DRAW_NOPICKUP ? 0 : 1;
        s_optionshud.memory.curvalue = i & CG_DRAW_MEMORY ? 1 : 0;
        s_optionshud.nothing.curvalue = i & CG_DRAW_NOTHING ? 1 : 0;

        i = atoi( cvar_argv( cg_draw, 2 ) );

        s_optionshud.icons.curvalue = i;

        trap_Cvar_VariableStringBuffer( "cg_team", cg_team, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_team, 1 ) );

        s_optionshud.teamoverlay.curvalue = i;

        OptionsHUD_Nothing();
}

static void OptionsHUD_SaveChanges( void ) {
        int     i;

        trap_Cvar_VariableStringBuffer( "cg_draw", cg_draw, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_draw, 1 ) );

        i = !s_optionshud.attacker.curvalue ? i | CG_DRAW_NOATTACKER : i & ~CG_DRAW_NOATTACKER;
        i = !s_optionshud.score.curvalue ? i | CG_DRAW_NOSCORES : i & ~CG_DRAW_NOSCORES;
        i = s_optionshud.fps.curvalue ? i | CG_DRAW_FPS : i & ~CG_DRAW_FPS;
        i = !s_optionshud.timer.curvalue ? i | CG_DRAW_NOTIMER : i & ~CG_DRAW_NOTIMER;
        i = !s_optionshud.ammowarn.curvalue ? i | CG_DRAW_NOAMMOWARN : i & ~CG_DRAW_NOAMMOWARN;
        i = !s_optionshud.damage.curvalue ? i | CG_DRAW_NODAMAGE : i & ~CG_DRAW_NODAMAGE;
        i = !s_optionshud.rewards.curvalue ? i | CG_DRAW_NOREWARDS : i & ~CG_DRAW_NOREWARDS;
        i = !s_optionshud.lagometer.curvalue ? i | CG_DRAW_NOLAGOMETER : i & ~CG_DRAW_NOLAGOMETER;
        i = s_optionshud.allammo.curvalue ? i | CG_DRAW_ALLAMMO : i & ~CG_DRAW_ALLAMMO;
        i = !s_optionshud.pickup.curvalue ? i | CG_DRAW_NOPICKUP : i & ~CG_DRAW_NOPICKUP;
        i = s_optionshud.memory.curvalue ? i | CG_DRAW_MEMORY : i & ~CG_DRAW_MEMORY;
        i = s_optionshud.nothing.curvalue ? i | CG_DRAW_NOTHING : i & ~CG_DRAW_NOTHING;

        Q_strncpyz( cg_draw, set_argv( cg_draw, 1, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionshud.icons.curvalue;

        Q_strncpyz( cg_draw, set_argv( cg_draw, 2, va("%i", i ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_draw", cg_draw );

        trap_Cvar_VariableStringBuffer( "cg_team", cg_team, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_team, 1 ) );

        i = s_optionshud.teamoverlay.curvalue;

        trap_Cvar_Set( "cg_team", set_argv( cg_team, 1, va("%i", i ) ) );
}

static sfxHandle_t OptionsHUD_MenuKey( int key ) {

        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
                OptionsHUD_SaveChanges();
		break;
	}

        return ( Menu_DefaultKey( &s_optionshud.menu, key ) );
}

static void OptionsHUD_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
        case ID_XHAIR:
                OptionsHUD_SaveChanges();
		UI_PopMenu();
                UI_OptionsXHairMenu();
		break;
        case ID_WEAPONS:
                OptionsHUD_SaveChanges();
                UI_PopMenu();
                UI_OptionsWepsMenu();
                break;
        case ID_EFFECTS:
                OptionsHUD_SaveChanges();
                UI_PopMenu();
                UI_OptionsFXMenu();
                break;
        case ID_MISC:
                OptionsHUD_SaveChanges();
                UI_PopMenu();
                UI_OptionsMiscMenu();
                break;

        case ID_HUD_NOTHING:
                OptionsHUD_Nothing();
                break;
	case ID_BACK:
                OptionsHUD_SaveChanges();
		UI_PopMenu();
		break;
	}
}

static void OptionsHUD_MenuInit( void ) {
	int				y;

        memset( &s_optionshud, 0 ,sizeof(optionshud_t) );

        OptionsHUD_Cache();

        s_optionshud.menu.key        = OptionsHUD_MenuKey;
        s_optionshud.menu.wrapAround = qtrue;
        s_optionshud.menu.fullscreen = qtrue;

        s_optionshud.banner.generic.type  = MTYPE_BTEXT;
        s_optionshud.banner.generic.x     = 320;
        s_optionshud.banner.generic.y     = 16;
        s_optionshud.banner.string                = "GAME OPTIONS";
        s_optionshud.banner.color         = color_white;
        s_optionshud.banner.style         = UI_CENTER;

        s_optionshud.framel.generic.type  = MTYPE_BITMAP;
        s_optionshud.framel.generic.name  = ART_FRAMEL;
        s_optionshud.framel.generic.flags = QMF_INACTIVE;
        s_optionshud.framel.generic.x     = 0;
        s_optionshud.framel.generic.y     = 78;
        s_optionshud.framel.width         = 256;
        s_optionshud.framel.height        = 329;

        s_optionshud.framer.generic.type  = MTYPE_BITMAP;
        s_optionshud.framer.generic.name  = ART_FRAMER;
        s_optionshud.framer.generic.flags = QMF_INACTIVE;
        s_optionshud.framer.generic.x     = 376;
        s_optionshud.framer.generic.y     = 76;
        s_optionshud.framer.width         = 256;
        s_optionshud.framer.height        = 334;

        s_optionshud.hud.generic.type         = MTYPE_PTEXT;
        s_optionshud.hud.generic.flags        = QMF_RIGHT_JUSTIFY;
        s_optionshud.hud.generic.id           = ID_HUD;
        s_optionshud.hud.generic.callback     = OptionsHUD_Event;
        s_optionshud.hud.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.hud.generic.y            = 240 - 2.8 * PROP_HEIGHT;
        s_optionshud.hud.string                       = "HUD";
        s_optionshud.hud.style                        = UI_RIGHT;
        s_optionshud.hud.color                        = color_red;

        s_optionshud.crosshair.generic.type         = MTYPE_PTEXT;
        s_optionshud.crosshair.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.crosshair.generic.id           = ID_XHAIR;
        s_optionshud.crosshair.generic.callback     = OptionsHUD_Event;
        s_optionshud.crosshair.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.crosshair.generic.y            = 240 - 1.75 * PROP_HEIGHT;
        s_optionshud.crosshair.string                       = "CROSSHAIR";
        s_optionshud.crosshair.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionshud.crosshair.color                        = color_red;

        s_optionshud.weapons.generic.type         = MTYPE_PTEXT;
        s_optionshud.weapons.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.weapons.generic.id           = ID_WEAPONS;
        s_optionshud.weapons.generic.callback     = OptionsHUD_Event;
        s_optionshud.weapons.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.weapons.generic.y            = 240 - 1 * PROP_HEIGHT;
        s_optionshud.weapons.string                       = "WEAPONS";
        s_optionshud.weapons.style                        = UI_RIGHT;
        s_optionshud.weapons.color                        = color_red;

        s_optionshud.effects.generic.type         = MTYPE_PTEXT;
        s_optionshud.effects.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.effects.generic.id           = ID_EFFECTS;
        s_optionshud.effects.generic.callback     = OptionsHUD_Event;
        s_optionshud.effects.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.effects.generic.y            = 240;
        s_optionshud.effects.string                       = "EFFECTS";
        s_optionshud.effects.style                        = UI_RIGHT;
        s_optionshud.effects.color                        = color_red;

        s_optionshud.scores.generic.type         = MTYPE_PTEXT;
        s_optionshud.scores.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.scores.generic.id           = ID_SCORES;
        s_optionshud.scores.generic.callback     = OptionsHUD_Event;
        s_optionshud.scores.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.scores.generic.y            = 240 + 1.1 * PROP_HEIGHT;
        s_optionshud.scores.string                       = "SCOREBOARD";
        s_optionshud.scores.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionshud.scores.color                        = color_red;

        s_optionshud.misc.generic.type         = MTYPE_PTEXT;
        s_optionshud.misc.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.misc.generic.id           = ID_MISC;
        s_optionshud.misc.generic.callback     = OptionsHUD_Event;
        s_optionshud.misc.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionshud.misc.generic.y            = 240 + 1.9 * PROP_HEIGHT;
        s_optionshud.misc.string                       = "MISC";
        s_optionshud.misc.style                        = UI_RIGHT;
        s_optionshud.misc.color                        = color_red;

// menu-specific stuff

        y = 128;

        s_optionshud.attacker.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.attacker.generic.name              = "Attacker:";
        s_optionshud.attacker.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.attacker.generic.callback          = OptionsHUD_Event;
        s_optionshud.attacker.generic.id                = ID_HUD_ATTACKER;
        s_optionshud.attacker.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.attacker.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.score.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.score.generic.name              = "Scores:";
        s_optionshud.score.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.score.generic.callback          = OptionsHUD_Event;
        s_optionshud.score.generic.id                = ID_HUD_SCORE;
        s_optionshud.score.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.score.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.fps.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.fps.generic.name              = "FPS:";
        s_optionshud.fps.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.fps.generic.callback          = OptionsHUD_Event;
        s_optionshud.fps.generic.id                = ID_HUD_FPS;
        s_optionshud.fps.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.fps.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.timer.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.timer.generic.name              = "Timer:";
        s_optionshud.timer.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.timer.generic.callback          = OptionsHUD_Event;
        s_optionshud.timer.generic.id                = ID_HUD_TIMER;
        s_optionshud.timer.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.timer.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.ammowarn.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.ammowarn.generic.name              = "Ammo Warning:";
        s_optionshud.ammowarn.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.ammowarn.generic.callback          = OptionsHUD_Event;
        s_optionshud.ammowarn.generic.id                = ID_HUD_AMMOWARNING;
        s_optionshud.ammowarn.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.ammowarn.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.damage.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.damage.generic.name              = "Damage Feedback:";
        s_optionshud.damage.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.damage.generic.callback          = OptionsHUD_Event;
        s_optionshud.damage.generic.id                = ID_HUD_DAMAGE;
        s_optionshud.damage.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.damage.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.rewards.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.rewards.generic.name              = "Rewards:";
        s_optionshud.rewards.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.rewards.generic.callback          = OptionsHUD_Event;
        s_optionshud.rewards.generic.id                = ID_HUD_REWARDS;
        s_optionshud.rewards.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.rewards.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.lagometer.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.lagometer.generic.name              = "Lag-O-Meter:";
        s_optionshud.lagometer.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.lagometer.generic.callback          = OptionsHUD_Event;
        s_optionshud.lagometer.generic.id                = ID_HUD_LAGOMETER;
        s_optionshud.lagometer.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.lagometer.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.allammo.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.allammo.generic.name              = "All Ammo Display:";
        s_optionshud.allammo.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.allammo.generic.callback          = OptionsHUD_Event;
        s_optionshud.allammo.generic.id                = ID_HUD_ALLAMMO;
        s_optionshud.allammo.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.allammo.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.pickup.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.pickup.generic.name              = "Picked Item:";
        s_optionshud.pickup.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.pickup.generic.callback          = OptionsHUD_Event;
        s_optionshud.pickup.generic.id                = ID_HUD_PICKUP;
        s_optionshud.pickup.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.pickup.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.memory.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.memory.generic.name              = "Memory:";
        s_optionshud.memory.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.memory.generic.callback          = OptionsHUD_Event;
        s_optionshud.memory.generic.id                = ID_HUD_MEMORY;
        s_optionshud.memory.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.memory.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionshud.icons.generic.type     = MTYPE_SPINCONTROL;
        s_optionshud.icons.generic.name         = "Icons:";
        s_optionshud.icons.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.icons.generic.callback = OptionsHUD_Event;
        s_optionshud.icons.generic.id       = ID_HUD_ICONS;
        s_optionshud.icons.generic.x        = GAME_OPTIONS_X_POS;
        s_optionshud.icons.generic.y        = y;
        s_optionshud.icons.itemnames                 = icons_names;

	y += BIGCHAR_HEIGHT;
        s_optionshud.teamoverlay.generic.type     = MTYPE_SPINCONTROL;
        s_optionshud.teamoverlay.generic.name         = "Team Overlay:";
        s_optionshud.teamoverlay.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.teamoverlay.generic.callback = OptionsHUD_Event;
        s_optionshud.teamoverlay.generic.id       = ID_HUD_OVERLAY;
        s_optionshud.teamoverlay.generic.x        = GAME_OPTIONS_X_POS;
        s_optionshud.teamoverlay.generic.y        = y;
        s_optionshud.teamoverlay.itemnames                 = teamoverlay_names;

        y += 2 * BIGCHAR_HEIGHT;
        s_optionshud.nothing.generic.type              = MTYPE_RADIOBUTTON;
        s_optionshud.nothing.generic.name              = "Nothing:";
        s_optionshud.nothing.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionshud.nothing.generic.callback          = OptionsHUD_Event;
        s_optionshud.nothing.generic.id                = ID_HUD_NOTHING;
        s_optionshud.nothing.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionshud.nothing.generic.y                 = y;

        s_optionshud.back.generic.type     = MTYPE_BITMAP;
        s_optionshud.back.generic.name     = ART_BACK0;
        s_optionshud.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionshud.back.generic.callback = OptionsHUD_Event;
        s_optionshud.back.generic.id       = ID_BACK;
        s_optionshud.back.generic.x            = 0;
        s_optionshud.back.generic.y            = 480-64;
        s_optionshud.back.width                    = 128;
        s_optionshud.back.height                   = 64;
        s_optionshud.back.focuspic         = ART_BACK1;

        Menu_AddItem( &s_optionshud.menu, &s_optionshud.banner );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.framel );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.framer );

        Menu_AddItem( &s_optionshud.menu, &s_optionshud.hud );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.crosshair );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.weapons );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.effects );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.scores );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.misc );

// menu-specific stuff
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.attacker );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.score );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.fps );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.timer );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.ammowarn );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.damage );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.rewards );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.lagometer );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.allammo );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.pickup );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.memory );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.icons );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.teamoverlay );
        Menu_AddItem( &s_optionshud.menu, &s_optionshud.nothing );

        Menu_AddItem( &s_optionshud.menu, &s_optionshud.back );

        OptionsHUD_SetMenuItems();
}


/*
===============
OptionsHUD_Cache
===============
*/
void OptionsHUD_Cache( void ) {

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );

}


/*
===============
UI_OptionsHUDMenu
===============
*/
void UI_OptionsHUDMenu( void ) {
        OptionsHUD_MenuInit();
        UI_PushMenu( &s_optionshud.menu );
        Menu_SetCursorToItem( &s_optionshud.menu, &s_optionshud.hud );
}

/*
=======================================================================

GAME OPTIONS CROSSHAIR MENU

=======================================================================
*/

#define	NUM_CROSSHAIRS			10

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

        menutext_s              hud;
        menutext_s              crosshair;
        menutext_s              weapons;
        menutext_s              effects;
        menutext_s              scores;
        menutext_s              misc;

// menu-specific stuff

        menulist_s              style;
        menuslider_s            size;
        menuslider_s            color_r;
        menuslider_s            color_g;
        menuslider_s            color_b;
        menuradiobutton_s       health;
        menuradiobutton_s       name;
        menuradiobutton_s       pickup;

        qhandle_t               xhairShader[NUM_CROSSHAIRS];

	menubitmap_s		back;

} optionsxhair_t;

static optionsxhair_t   s_optionsxhair;

static int              pickup_time;
static char             identify_name[32];

static void OptionsXHair_Health( void ) {
        int     i;
        if ( s_optionsxhair.health.curvalue ) {
                s_optionsxhair.color_r.generic.flags |= QMF_GRAYED;
                s_optionsxhair.color_g.generic.flags |= QMF_GRAYED;
                s_optionsxhair.color_b.generic.flags |= QMF_GRAYED;
        } else {
                s_optionsxhair.color_r.generic.flags &= ~QMF_GRAYED;
                s_optionsxhair.color_g.generic.flags &= ~QMF_GRAYED;
                s_optionsxhair.color_b.generic.flags &= ~QMF_GRAYED;
        }
}


static void OptionsXHair_SetMenuItems( void ) {
        int     i;
        float   f;

        trap_Cvar_VariableStringBuffer( "cg_xhair", cg_xhair, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_xhair, 1 ) );
        s_optionsxhair.style.curvalue = i;

        i = atoi( cvar_argv( cg_xhair, 2 ) );
        s_optionsxhair.name.curvalue = i & CG_XHAIR_NAME ? 1 : 0;
        s_optionsxhair.health.curvalue = i & CG_XHAIR_HEALTH ? 1 : 0;
        s_optionsxhair.pickup.curvalue = i & CG_XHAIR_NOPICKUP ? 0 : 1;

        i = atoi( cvar_argv( cg_xhair, 5 ) );
        s_optionsxhair.size.curvalue = i / 4;

        f = atof( cvar_argv( cg_xhair, 6 ) );
        s_optionsxhair.color_r.curvalue = f * 20;

        f = atof( cvar_argv( cg_xhair, 7 ) );
        s_optionsxhair.color_g.curvalue = f * 20;

        f = atof( cvar_argv( cg_xhair, 8 ) );
        s_optionsxhair.color_b.curvalue = f * 20;

        OptionsXHair_Health();
}

static void OptionsXHair_SaveChanges( void ) {
        int     i;
        float   f;

        trap_Cvar_VariableStringBuffer( "cg_xhair", cg_xhair, MAX_INFO_STRING );

        i = s_optionsxhair.style.curvalue;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 1, va("%i", i ) ), MAX_INFO_STRING );

        i = atoi( cvar_argv( cg_xhair, 2 ) );

        i = s_optionsxhair.name.curvalue ? i | CG_XHAIR_NAME : i & ~CG_XHAIR_NAME;
        i = s_optionsxhair.health.curvalue ? i | CG_XHAIR_HEALTH : i & ~CG_XHAIR_HEALTH;
        i = !s_optionsxhair.pickup.curvalue ? i | CG_XHAIR_NOPICKUP : i & ~CG_XHAIR_NOPICKUP;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 2, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsxhair.size.curvalue * 4;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 5, va("%i", i ) ), MAX_INFO_STRING );

        f = s_optionsxhair.color_r.curvalue / 20;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 6, va("%1.1f", f ) ), MAX_INFO_STRING );

        f = s_optionsxhair.color_g.curvalue / 20;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 7, va("%1.1f", f ) ), MAX_INFO_STRING );

        f = s_optionsxhair.color_b.curvalue / 20;
        Q_strncpyz( cg_xhair, set_argv( cg_xhair, 8, va("%1.1f", f ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_xhair", cg_xhair );
}

static sfxHandle_t OptionsXHair_MenuKey( int key ) {

        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
                OptionsXHair_SaveChanges();
		break;
	}

        return ( Menu_DefaultKey( &s_optionsxhair.menu, key ) );
}

static void OptionsXHair_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
        case ID_HUD:
                OptionsXHair_SaveChanges();
		UI_PopMenu();
                UI_OptionsHUDMenu();
		break;
        case ID_WEAPONS:
                OptionsXHair_SaveChanges();
                UI_PopMenu();
                UI_OptionsWepsMenu();
                break;
        case ID_EFFECTS:
                OptionsXHair_SaveChanges();
                UI_PopMenu();
                UI_OptionsFXMenu();
                break;
        case ID_MISC:
                OptionsXHair_SaveChanges();
                UI_PopMenu();
                UI_OptionsMiscMenu();
                break;

        case ID_XHAIR_STYLE:
                s_optionsxhair.style.curvalue++;
                if( s_optionsxhair.style.curvalue >= NUM_CROSSHAIRS ) {
                        s_optionsxhair.style.curvalue = 0;
		}
                break;
        case ID_XHAIR_PICKUP:
                if ( s_optionsxhair.pickup.curvalue != 0 )
                        pickup_time = uis.realtime;
                break;
        case ID_XHAIR_HEALTH:
                OptionsXHair_Health();
                break;
	case ID_BACK:
                OptionsXHair_SaveChanges();
		UI_PopMenu();
		break;
	}
}

/*
=================
optionsXHair_XHairDraw
=================
*/
static void OptionsXHair_XHairDraw( void *self ) {
	menulist_s	*s;
	float		*color;
        int                     x, y, y2;
	int			style;
	qboolean	focus;
        vec4_t          vec_color;
        float           f;

	s = (menulist_s *)self;
	x = s->generic.x;
	y =	s->generic.y;
// q3app (was 124)
        y2 = 148;

	style = UI_SMALLFONT;
	focus = (s->generic.parent->cursor == s->generic.menuPosition);

	if ( s->generic.flags & QMF_GRAYED )
		color = text_color_disabled;
	else if ( focus )
	{
		color = text_color_highlight;
		style |= UI_PULSE;
	}
	else if ( s->generic.flags & QMF_BLINK )
	{
		color = text_color_highlight;
		style |= UI_BLINK;
	}
	else
		color = text_color_normal;

	if ( focus )
	{
		// draw cursor
		UI_FillRect( s->generic.left, s->generic.top, s->generic.right-s->generic.left+1, s->generic.bottom-s->generic.top+1, listbar_color ); 
		UI_DrawChar( x, y, 13, UI_CENTER|UI_BLINK|UI_SMALLFONT, color);
	}

	UI_DrawString( x - SMALLCHAR_WIDTH, y, s->generic.name, style|UI_RIGHT, color );
        if( !s->curvalue ) {
                return;
        }
        UI_DrawHandlePic( x + SMALLCHAR_WIDTH, y - 4, 24, 24, s_optionsxhair.xhairShader[s->curvalue] );

// big xhair
        vec_color[0] = 1;
        vec_color[1] = 1;
        vec_color[2] = 1;
        vec_color[3] = 0.5;
        if ( s_optionsxhair.name.curvalue )
                UI_DrawString( 320, y2 - 70, identify_name, UI_BIGFONT|UI_CENTER|UI_DROPSHADOW, vec_color );

        vec_color[0] = s_optionsxhair.color_r.curvalue / 20;
        vec_color[1] = s_optionsxhair.color_g.curvalue / 20;
        vec_color[2] = s_optionsxhair.color_b.curvalue / 20;
        vec_color[3] = 1;

        if ( s_optionsxhair.health.curvalue )
                color = color_white;
        else
                color = vec_color;

                trap_R_SetColor( color );

        // item pickup pulse
        f = uis.realtime - pickup_time;
        if ( f > 0 && f < 200 ) {
                f /= 200;
        } else
                f = 0;

        UI_DrawHandlePic( 320 - (s_optionsxhair.size.curvalue * 2 * (1 + f) ), y2 - (s_optionsxhair.size.curvalue * 2 * (1 + f) ), s_optionsxhair.size.curvalue * 4 * (1 + f), s_optionsxhair.size.curvalue * 4 * (1 + f), s_optionsxhair.xhairShader[s->curvalue] );

        trap_R_SetColor( NULL );
// not most elegant place for this, should be in another function
        UI_DrawString( GAME_OPTIONS_X_POS+108, 192+4+BIGCHAR_HEIGHT, va("%f", s_optionsxhair.size.curvalue * 4 ), UI_SMALLFONT, text_color_normal );

}

static void OptionsXHair_MenuInit( void ) {
	int				y;

        memset( &s_optionsxhair, 0 ,sizeof(optionsxhair_t) );

        pickup_time = 0;
        trap_Cvar_VariableStringBuffer( "name", identify_name, 32 );
        if ( !identify_name[0] )
                Q_strncpyz( identify_name, "UnnamedPlayer", 32 );

        OptionsXHair_Cache();

        s_optionsxhair.menu.key        = OptionsXHair_MenuKey;
        s_optionsxhair.menu.wrapAround = qtrue;
        s_optionsxhair.menu.fullscreen = qtrue;

        s_optionsxhair.banner.generic.type  = MTYPE_BTEXT;
        s_optionsxhair.banner.generic.x     = 320;
        s_optionsxhair.banner.generic.y     = 16;
        s_optionsxhair.banner.string                = "GAME OPTIONS";
        s_optionsxhair.banner.color         = color_white;
        s_optionsxhair.banner.style         = UI_CENTER;

        s_optionsxhair.framel.generic.type  = MTYPE_BITMAP;
        s_optionsxhair.framel.generic.name  = ART_FRAMEL;
        s_optionsxhair.framel.generic.flags = QMF_INACTIVE;
        s_optionsxhair.framel.generic.x     = 0;
        s_optionsxhair.framel.generic.y     = 78;
        s_optionsxhair.framel.width         = 256;
        s_optionsxhair.framel.height        = 329;

        s_optionsxhair.framer.generic.type  = MTYPE_BITMAP;
        s_optionsxhair.framer.generic.name  = ART_FRAMER;
        s_optionsxhair.framer.generic.flags = QMF_INACTIVE;
        s_optionsxhair.framer.generic.x     = 376;
        s_optionsxhair.framer.generic.y     = 76;
        s_optionsxhair.framer.width         = 256;
        s_optionsxhair.framer.height        = 334;

        s_optionsxhair.hud.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.hud.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.hud.generic.id           = ID_HUD;
        s_optionsxhair.hud.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.hud.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.hud.generic.y            = 240 - 2.8 * PROP_HEIGHT;
        s_optionsxhair.hud.string                       = "HUD";
        s_optionsxhair.hud.style                        = UI_RIGHT;
        s_optionsxhair.hud.color                        = color_red;

        s_optionsxhair.crosshair.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.crosshair.generic.flags        = QMF_RIGHT_JUSTIFY;
        s_optionsxhair.crosshair.generic.id           = ID_XHAIR;
        s_optionsxhair.crosshair.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.crosshair.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.crosshair.generic.y            = 240 - 1.75 * PROP_HEIGHT;
        s_optionsxhair.crosshair.string                       = "CROSSHAIR";
        s_optionsxhair.crosshair.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsxhair.crosshair.color                        = color_red;

        s_optionsxhair.weapons.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.weapons.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.weapons.generic.id           = ID_WEAPONS;
        s_optionsxhair.weapons.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.weapons.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.weapons.generic.y            = 240 - 1 * PROP_HEIGHT;
        s_optionsxhair.weapons.string                       = "WEAPONS";
        s_optionsxhair.weapons.style                        = UI_RIGHT;
        s_optionsxhair.weapons.color                        = color_red;

        s_optionsxhair.effects.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.effects.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.effects.generic.id           = ID_EFFECTS;
        s_optionsxhair.effects.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.effects.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.effects.generic.y            = 240;
        s_optionsxhair.effects.string                       = "EFFECTS";
        s_optionsxhair.effects.style                        = UI_RIGHT;
        s_optionsxhair.effects.color                        = color_red;

        s_optionsxhair.scores.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.scores.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.scores.generic.id           = ID_SCORES;
        s_optionsxhair.scores.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.scores.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.scores.generic.y            = 240 + 1.1 * PROP_HEIGHT;
        s_optionsxhair.scores.string                       = "SCOREBOARD";
        s_optionsxhair.scores.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsxhair.scores.color                        = color_red;

        s_optionsxhair.misc.generic.type         = MTYPE_PTEXT;
        s_optionsxhair.misc.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.misc.generic.id           = ID_MISC;
        s_optionsxhair.misc.generic.callback     = OptionsXHair_Event;
        s_optionsxhair.misc.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsxhair.misc.generic.y            = 240 + 1.9 * PROP_HEIGHT;
        s_optionsxhair.misc.string                       = "MISC";
        s_optionsxhair.misc.style                        = UI_RIGHT;
        s_optionsxhair.misc.color                        = color_red;

// menu-specific stuff

        y = 192;

        s_optionsxhair.style.generic.type            = MTYPE_TEXT;
        s_optionsxhair.style.generic.flags           = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_NODEFAULTINIT|QMF_OWNERDRAW;
        s_optionsxhair.style.generic.x                       = GAME_OPTIONS_X_POS;
        s_optionsxhair.style.generic.y                       = y;
        s_optionsxhair.style.generic.name            = "Style:";
        s_optionsxhair.style.generic.callback        = OptionsXHair_Event;
        s_optionsxhair.style.generic.ownerdraw       = OptionsXHair_XHairDraw;
        s_optionsxhair.style.generic.id                      = ID_XHAIR_STYLE;
        s_optionsxhair.style.generic.top                     = y - 4;
        s_optionsxhair.style.generic.bottom          = y + 20;
        s_optionsxhair.style.generic.left            = GAME_OPTIONS_X_POS - ( ( strlen(s_optionsxhair.style.generic.name) + 1 ) * SMALLCHAR_WIDTH );
        s_optionsxhair.style.generic.right           = GAME_OPTIONS_X_POS + 48;

        y += 4+BIGCHAR_HEIGHT;
        s_optionsxhair.size.generic.type                       = MTYPE_SLIDER;
        s_optionsxhair.size.generic.name                       = "Size:";
        s_optionsxhair.size.generic.callback                   = OptionsXHair_Event;
        s_optionsxhair.size.generic.id                         = ID_XHAIR_SIZE;
        s_optionsxhair.size.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.size.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsxhair.size.generic.y                          = y;
        s_optionsxhair.size.minvalue                           = 0;
        s_optionsxhair.size.maxvalue                           = 32;

        y += BIGCHAR_HEIGHT;
        s_optionsxhair.name.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsxhair.name.generic.name              = "Identify Target:";
        s_optionsxhair.name.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.name.generic.callback          = OptionsXHair_Event;
        s_optionsxhair.name.generic.id                = ID_XHAIR_NAME;
        s_optionsxhair.name.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsxhair.name.generic.y                 = y;

        y += BIGCHAR_HEIGHT;
        s_optionsxhair.pickup.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsxhair.pickup.generic.name              = "Pulse on Pickup:";
        s_optionsxhair.pickup.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.pickup.generic.callback          = OptionsXHair_Event;
        s_optionsxhair.pickup.generic.id                = ID_XHAIR_PICKUP;
        s_optionsxhair.pickup.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsxhair.pickup.generic.y                 = y;

        y += BIGCHAR_HEIGHT;
        s_optionsxhair.health.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsxhair.health.generic.name              = "Health Color:";
        s_optionsxhair.health.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.health.generic.callback          = OptionsXHair_Event;
        s_optionsxhair.health.generic.id                = ID_XHAIR_HEALTH;
        s_optionsxhair.health.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsxhair.health.generic.y                 = y;

        y += 2 * BIGCHAR_HEIGHT;
        s_optionsxhair.color_r.generic.type                       = MTYPE_SLIDER;
        s_optionsxhair.color_r.generic.name                       = "Red:";
        s_optionsxhair.color_r.generic.callback                   = OptionsXHair_Event;
        s_optionsxhair.color_r.generic.id                         = ID_XHAIR_COLOR_R;
        s_optionsxhair.color_r.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.color_r.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsxhair.color_r.generic.y                          = y;
        s_optionsxhair.color_r.minvalue                           = 0;
        s_optionsxhair.color_r.maxvalue                           = 20;

        y += BIGCHAR_HEIGHT;
        s_optionsxhair.color_g.generic.type                       = MTYPE_SLIDER;
        s_optionsxhair.color_g.generic.name                       = "Green:";
        s_optionsxhair.color_g.generic.callback                   = OptionsXHair_Event;
        s_optionsxhair.color_g.generic.id                         = ID_XHAIR_COLOR_G;
        s_optionsxhair.color_g.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.color_g.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsxhair.color_g.generic.y                          = y;
        s_optionsxhair.color_g.minvalue                           = 0;
        s_optionsxhair.color_g.maxvalue                           = 20;

        y += BIGCHAR_HEIGHT;
        s_optionsxhair.color_b.generic.type                       = MTYPE_SLIDER;
        s_optionsxhair.color_b.generic.name                       = "Blue:";
        s_optionsxhair.color_b.generic.callback                   = OptionsXHair_Event;
        s_optionsxhair.color_b.generic.id                         = ID_XHAIR_COLOR_B;
        s_optionsxhair.color_b.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsxhair.color_b.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsxhair.color_b.generic.y                          = y;
        s_optionsxhair.color_b.minvalue                           = 0;
        s_optionsxhair.color_b.maxvalue                           = 20;

        s_optionsxhair.back.generic.type     = MTYPE_BITMAP;
        s_optionsxhair.back.generic.name     = ART_BACK0;
        s_optionsxhair.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsxhair.back.generic.callback = OptionsXHair_Event;
        s_optionsxhair.back.generic.id       = ID_BACK;
        s_optionsxhair.back.generic.x            = 0;
        s_optionsxhair.back.generic.y            = 480-64;
        s_optionsxhair.back.width                    = 128;
        s_optionsxhair.back.height                   = 64;
        s_optionsxhair.back.focuspic         = ART_BACK1;

        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.banner );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.framel );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.framer );

        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.hud );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.crosshair );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.weapons );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.effects );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.scores );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.misc );

// menu-specific stuff
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.style );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.size );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.name );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.pickup );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.health );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.color_r );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.color_g );
        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.color_b );

        Menu_AddItem( &s_optionsxhair.menu, &s_optionsxhair.back );

        OptionsXHair_SetMenuItems();
}


/*
===============
OptionsXHair_Cache
===============
*/
void OptionsXHair_Cache( void ) {
	int		n;

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
        for( n = 0; n < NUM_CROSSHAIRS; n++ ) {
                s_optionsxhair.xhairShader[n] = trap_R_RegisterShaderNoMip( va("gfx/2d/crosshair%c", 'a' + n ) );
	}

}


/*
===============
UI_OptionsXHairMenu
===============
*/
void UI_OptionsXHairMenu( void ) {
        OptionsXHair_MenuInit();
        UI_PushMenu( &s_optionsxhair.menu );
        Menu_SetCursorToItem( &s_optionsxhair.menu, &s_optionsxhair.crosshair );
}

/*
=======================================================================

GAME OPTIONS WEAPONS MENU

=======================================================================
*/

#define MAX_LISTLENGTH 30
#define NUM_WEAPONS 10

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

        menutext_s              hud;
        menutext_s              crosshair;
        menutext_s              weapons;
        menutext_s              effects;
        menutext_s              scores;
        menutext_s              misc;

// menu-specific stuff
        menulist_s              pos;
        menuslider_s            flash;
        menulist_s              autoswitch;
        menulist_s              noammo;
        menufield_s             list;

        qhandle_t               weaponShader[NUM_WEAPONS];


	menubitmap_s		back;

} optionsweps_t;

static optionsweps_t s_optionsweps;

static const char *pos_names[] =
{
        "Off",
        "Right",
        "Center",
	0
};

static const char *auto_names[] =
{
        "Off",
        "Weapon Pickup",
        "Weapon & Ammo",
	0
};

static const char *noammo_names[] =
{
        "Normal Switch",
        "Switch on Fire",
        "Switch ASAP",
	0
};

static void OptionsWeps_Pos( void ) {
        int     i;
        if ( !s_optionsweps.pos.curvalue ) {
                s_optionsweps.flash.generic.flags |= QMF_GRAYED;
        } else {
                s_optionsweps.flash.generic.flags &= ~QMF_GRAYED;
        }
}

static void OptionsWeps_SetMenuItems( void ) {
        int     i;
        float   f;
        char    *s;

        trap_Cvar_VariableStringBuffer( "cg_gun", cg_gun, MAX_INFO_STRING );

        i = atoi( cvar_argv( cg_gun, 4 ) );

        s_optionsweps.pos.curvalue = i;

        f = atof( cvar_argv( cg_gun, 5 ) );

        s_optionsweps.flash.curvalue = f * 10;

        trap_Cvar_VariableStringBuffer( "cg_switch", cg_switch, MAX_INFO_STRING );
        i = atoi( cvar_argv( cg_switch, 1 ) );

        s_optionsweps.autoswitch.curvalue = i;

        i = atoi( cvar_argv( cg_switch, 2 ) );

        s_optionsweps.noammo.curvalue = i;

        s = (char*)cvar_argv( cg_switch, 3 );

        if ( s[0] )
                Q_strncpyz( s_optionsweps.list.field.buffer, s, sizeof(s_optionsweps.list.field.buffer) );
        else
                s_optionsweps.list.field.buffer[0] = '\0';

        OptionsWeps_Pos();
}

static void OptionsWeps_SaveChanges( void ) {
        int     i;
        float   f;
        char    *s;

        trap_Cvar_VariableStringBuffer( "cg_gun", cg_gun, MAX_INFO_STRING );

        i = s_optionsweps.pos.curvalue;

        Q_strncpyz( cg_gun, set_argv( cg_gun, 4, va("%i", i ) ), MAX_INFO_STRING );

        f = s_optionsweps.flash.curvalue / 10;

        Q_strncpyz( cg_gun, set_argv( cg_gun, 5, va("%1.1f", f ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_gun", cg_gun );

        trap_Cvar_VariableStringBuffer( "cg_switch", cg_switch, MAX_INFO_STRING );

        i = s_optionsweps.autoswitch.curvalue;

        Q_strncpyz( cg_switch, set_argv( cg_switch, 1, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsweps.noammo.curvalue;

        Q_strncpyz( cg_switch, set_argv( cg_switch, 2, va("%i", i ) ), MAX_INFO_STRING );

        s = s_optionsweps.list.field.buffer;

        Q_strncpyz( cg_switch, set_argv( cg_switch, 3, s ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_switch", cg_switch );
}

static sfxHandle_t OptionsWeps_MenuKey( int key ) {

        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
                OptionsWeps_SaveChanges();
		break;
	}

        return ( Menu_DefaultKey( &s_optionsweps.menu, key ) );
}

static void OptionsWeps_DrawList( void *self) {
	menufield_s		*f;
	qboolean		focus;
	int				style;
	char			*txt;
	char			c;
	float			*color;
	int				n;
	int				basex, x, y;
        char                    name[32];
// weapon icon stuff
        int                     wep_x, wep_y, wep_x2, c_n, i;
        vec4_t                  color_disable = { 0.00, 0.00, 0.00, 0.50};
        char                    temp_list[MAX_INFO_STRING];
        qboolean                n_happened, n_just_happened;

	f = (menufield_s*)self;
	basex = f->generic.x;
	y = f->generic.y;
	focus = (f->generic.parent->cursor == f->generic.menuPosition);

	style = UI_LEFT|UI_SMALLFONT;
	color = text_color_normal;
	if( focus ) {
		style |= UI_PULSE;
		color = text_color_highlight;
	}

        UI_DrawProportionalString( basex, y, "Priority List", style|UI_CENTER, color );

	// draw the actual name
	y += PROP_HEIGHT;
	txt = f->field.buffer;
        basex -= Q_PrintStrlen(txt) * SMALLCHAR_WIDTH * 0.5;
	color = g_color_table[ColorIndex(COLOR_WHITE)];
	x = basex;
	while ( (c = *txt) != 0 ) {
		if ( !focus && Q_IsColorString( txt ) ) {
			n = ColorIndex( *(txt+1) );
			if( n == 0 ) {
				n = 7;
			}
			color = g_color_table[n];
			txt += 2;
			continue;
		}
		UI_DrawChar( x, y, c, style, color );
		txt++;
		x += SMALLCHAR_WIDTH;
	}

// draw weapon icons

        wep_y = 336;

        if ( cvar_argv(f->field.buffer, 1) ) {
                Q_strncpyz(temp_list, cvar_argv(f->field.buffer, 1), MAX_INFO_STRING );
        } else {
                temp_list[5] = '\0';
        }

        i = 0;
        while ( temp_list[i] ) { // prepare temp_list
                if (temp_list[i] == '<' || temp_list[i] == ',')
                        temp_list[i] = ' ';
                i++;
        }

        Q_strupr( temp_list );

        txt = strstr(temp_list, "N");
        i = cvar_argc( txt );
        wep_x2 = 320 - ( i * 16 );
        wep_x = 320 - ( ( cvar_argc( temp_list ) - i ) * 16 );

        i = 1; n_happened = n_just_happened = qfalse;
        while ( 1 ) {
                txt = (char*)cvar_argv( temp_list, i );
                if ( !*txt )
                        break;

                c_n = atoi(txt);

                if ( c_n || *txt == '0' ) { // number found
                        if ( i > 1 ) {
                                if (n_happened) {
                                        if ( n_just_happened ) {
                                                UI_DrawChar( wep_x, wep_y, ',', UI_BIGFONT, color );
                                                UI_FillRect( wep_x, wep_y, 16, 16, color_disable);
                                        } else {
                                                n_just_happened = qtrue;
                                        }
                                } else {
                                        UI_DrawChar( wep_x, wep_y, '<', UI_BIGFONT, color );
                                }
                                wep_x += 16;
                        }

                        if ( c_n < 11 && c_n > 0 ) { // weapon number
                                UI_DrawHandlePic( wep_x, wep_y, 16, 16, s_optionsweps.weaponShader[c_n - 1]);
                                if (n_happened) UI_FillRect( wep_x, wep_y, 16, 16, color_disable);
                        } else { // unrecognized number
                                UI_DrawString( wep_x, wep_y, "??", UI_PULSE|UI_SMALLFONT, color_red );
                        }
                        wep_x += 16;

                } else if ( *txt == 'N') {
                        if ( !n_happened ) {
                                wep_x = wep_x2;
                                wep_y += SMALLCHAR_HEIGHT * 1.5;
                        }
                        n_happened = qtrue;
                }
                i++;
        }
/*
        txt = f->field.buffer;
        wep_x = 130; n_happened = qfalse;
        wep_y = 336;
        while ( (c = *txt) != 0 ) {
                c_n = atoi(txt);
                if ( c_n > 0 && c != '0' ) { // we have a weapon
                        if ( c_n <= 10 ) {
                                UI_DrawHandlePic( wep_x, wep_y, 16, 16, s_optionsweps.weaponShader[c_n - 1]);
                                if (n_happened) UI_FillRect( wep_x, wep_y, 16, 16, color_disable);
                        } else {
                                UI_DrawString( wep_x, wep_y, "??", UI_PULSE|UI_SMALLFONT, color_red );
                        }
                        wep_x += 16;

                        while ( atoi(txt) && *txt != 0 )
                                txt++;
                } else if ( txt > f->field.buffer && ( c == ',' || c == '<' ) ) { // we have a '<' or ',' sign
                        UI_DrawChar( wep_x, wep_y, '<', UI_BIGFONT, color );
                        if (n_happened) UI_FillRect( wep_x, wep_y, 16, 16, color_disable);
                        wep_x += 16;
                        txt++;
                } else if ( c == 'n' || c == 'N' ) {                        
                        if ( !n_happened ) {
                                wep_x = 130;
                                wep_y += SMALLCHAR_HEIGHT;
                        }
                        n_happened = qtrue;
                        txt++;
                } else {             
                        txt++;
                }
        }
*/
	// draw cursor if we have focus
	if( focus ) {
		if ( trap_Key_GetOverstrikeMode() ) {
			c = 11;
		} else {
			c = 10;
		}

		style &= ~UI_PULSE;
		style |= UI_BLINK;

		UI_DrawChar( basex + f->field.cursor * SMALLCHAR_WIDTH, y, c, style, color_white );
	}
// not most elegant place for this, should be in another function
        if ( s_optionsweps.flash.curvalue )
                UI_DrawString( GAME_OPTIONS_X_POS+108, 192+BIGCHAR_HEIGHT, va("%1.2fx", s_optionsweps.flash.curvalue / 10), UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( GAME_OPTIONS_X_POS+108, 192+BIGCHAR_HEIGHT, "no flash", UI_SMALLFONT, text_color_normal );
}

static void OptionsWeps_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
        case ID_HUD:
                OptionsWeps_SaveChanges();
		UI_PopMenu();
                UI_OptionsHUDMenu();
		break;
        case ID_XHAIR:
                OptionsWeps_SaveChanges();
		UI_PopMenu();
                UI_OptionsXHairMenu();
		break;
        case ID_EFFECTS:
                OptionsWeps_SaveChanges();
                UI_PopMenu();
                UI_OptionsFXMenu();
                break;
        case ID_MISC:
                OptionsWeps_SaveChanges();
                UI_PopMenu();
                UI_OptionsMiscMenu();
                break;

        case ID_WEAPONS_POS:
                OptionsWeps_Pos();
                break;
        case ID_WEAPONS_FLASH:
                s_optionsweps.flash.curvalue = s_optionsweps.flash.curvalue > 20 ? 20 : s_optionsweps.flash.curvalue < 0 ? 0 : s_optionsweps.flash.curvalue;
                break;
	case ID_BACK:
                OptionsWeps_SaveChanges();
		UI_PopMenu();
		break;
	}
}

static void OptionsWeps_MenuInit( void ) {
	int				y;

        memset( &s_optionsweps, 0 ,sizeof(optionsweps_t) );

        OptionsWeps_Cache();

        s_optionsweps.menu.key        = OptionsWeps_MenuKey;
        s_optionsweps.menu.wrapAround = qtrue;
        s_optionsweps.menu.fullscreen = qtrue;

        s_optionsweps.banner.generic.type  = MTYPE_BTEXT;
        s_optionsweps.banner.generic.x     = 320;
        s_optionsweps.banner.generic.y     = 16;
        s_optionsweps.banner.string                = "GAME OPTIONS";
        s_optionsweps.banner.color         = color_white;
        s_optionsweps.banner.style         = UI_CENTER;

        s_optionsweps.framel.generic.type  = MTYPE_BITMAP;
        s_optionsweps.framel.generic.name  = ART_FRAMEL;
        s_optionsweps.framel.generic.flags = QMF_INACTIVE;
        s_optionsweps.framel.generic.x     = 0;
        s_optionsweps.framel.generic.y     = 78;
        s_optionsweps.framel.width         = 256;
        s_optionsweps.framel.height        = 329;

        s_optionsweps.framer.generic.type  = MTYPE_BITMAP;
        s_optionsweps.framer.generic.name  = ART_FRAMER;
        s_optionsweps.framer.generic.flags = QMF_INACTIVE;
        s_optionsweps.framer.generic.x     = 376;
        s_optionsweps.framer.generic.y     = 76;
        s_optionsweps.framer.width         = 256;
        s_optionsweps.framer.height        = 334;

        s_optionsweps.hud.generic.type         = MTYPE_PTEXT;
        s_optionsweps.hud.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.hud.generic.id           = ID_HUD;
        s_optionsweps.hud.generic.callback     = OptionsWeps_Event;
        s_optionsweps.hud.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.hud.generic.y            = 240 - 2.8 * PROP_HEIGHT;
        s_optionsweps.hud.string                       = "HUD";
        s_optionsweps.hud.style                        = UI_RIGHT;
        s_optionsweps.hud.color                        = color_red;

        s_optionsweps.crosshair.generic.type         = MTYPE_PTEXT;
        s_optionsweps.crosshair.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.crosshair.generic.id           = ID_XHAIR;
        s_optionsweps.crosshair.generic.callback     = OptionsWeps_Event;
        s_optionsweps.crosshair.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.crosshair.generic.y            = 240 - 1.75 * PROP_HEIGHT;
        s_optionsweps.crosshair.string                       = "CROSSHAIR";
        s_optionsweps.crosshair.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsweps.crosshair.color                        = color_red;

        s_optionsweps.weapons.generic.type         = MTYPE_PTEXT;
        s_optionsweps.weapons.generic.flags        = QMF_RIGHT_JUSTIFY;
        s_optionsweps.weapons.generic.id           = ID_WEAPONS;
        s_optionsweps.weapons.generic.callback     = OptionsWeps_Event;
        s_optionsweps.weapons.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.weapons.generic.y            = 240 - 1 * PROP_HEIGHT;
        s_optionsweps.weapons.string                       = "WEAPONS";
        s_optionsweps.weapons.style                        = UI_RIGHT;
        s_optionsweps.weapons.color                        = color_red;

        s_optionsweps.effects.generic.type         = MTYPE_PTEXT;
        s_optionsweps.effects.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.effects.generic.id           = ID_EFFECTS;
        s_optionsweps.effects.generic.callback     = OptionsWeps_Event;
        s_optionsweps.effects.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.effects.generic.y            = 240;
        s_optionsweps.effects.string                       = "EFFECTS";
        s_optionsweps.effects.style                        = UI_RIGHT;
        s_optionsweps.effects.color                        = color_red;

        s_optionsweps.scores.generic.type         = MTYPE_PTEXT;
        s_optionsweps.scores.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.scores.generic.id           = ID_SCORES;
        s_optionsweps.scores.generic.callback     = OptionsWeps_Event;
        s_optionsweps.scores.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.scores.generic.y            = 240 + 1.1 * PROP_HEIGHT;
        s_optionsweps.scores.string                       = "SCOREBOARD";
        s_optionsweps.scores.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsweps.scores.color                        = color_red;

        s_optionsweps.misc.generic.type         = MTYPE_PTEXT;
        s_optionsweps.misc.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.misc.generic.id           = ID_MISC;
        s_optionsweps.misc.generic.callback     = OptionsWeps_Event;
        s_optionsweps.misc.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsweps.misc.generic.y            = 240 + 1.9 * PROP_HEIGHT;
        s_optionsweps.misc.string                       = "MISC";
        s_optionsweps.misc.style                        = UI_RIGHT;
        s_optionsweps.misc.color                        = color_red;

// menu-specific stuff

        y = 192;

        s_optionsweps.pos.generic.type     = MTYPE_SPINCONTROL;
        s_optionsweps.pos.generic.name         = "Position:";
        s_optionsweps.pos.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsweps.pos.generic.callback = OptionsWeps_Event;
        s_optionsweps.pos.generic.id       = ID_WEAPONS_POS;
        s_optionsweps.pos.generic.x        = GAME_OPTIONS_X_POS;
        s_optionsweps.pos.generic.y        = y;
        s_optionsweps.pos.itemnames                 = pos_names;

	y += BIGCHAR_HEIGHT;
        s_optionsweps.flash.generic.type                       = MTYPE_SLIDER;
        s_optionsweps.flash.generic.name                       = "Flash Size:";
        s_optionsweps.flash.generic.callback                   = OptionsWeps_Event;
        s_optionsweps.flash.generic.id                         = ID_WEAPONS_FLASH;
        s_optionsweps.flash.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsweps.flash.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsweps.flash.generic.y                          = y;
        s_optionsweps.flash.minvalue                           = 0;
        s_optionsweps.flash.maxvalue                           = 20;

	y += BIGCHAR_HEIGHT;
        s_optionsweps.autoswitch.generic.type     = MTYPE_SPINCONTROL;
        s_optionsweps.autoswitch.generic.name         = "Auto Switch:";
        s_optionsweps.autoswitch.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsweps.autoswitch.generic.callback = OptionsWeps_Event;
        s_optionsweps.autoswitch.generic.id       = ID_WEAPONS_AUTO;
        s_optionsweps.autoswitch.generic.x        = GAME_OPTIONS_X_POS;
        s_optionsweps.autoswitch.generic.y        = y;
        s_optionsweps.autoswitch.itemnames                 = auto_names;

	y += BIGCHAR_HEIGHT;
        s_optionsweps.noammo.generic.type     = MTYPE_SPINCONTROL;
        s_optionsweps.noammo.generic.name         = "Out of Ammo:";
        s_optionsweps.noammo.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsweps.noammo.generic.callback = OptionsWeps_Event;
        s_optionsweps.noammo.generic.id       = ID_WEAPONS_NOAMMO;
        s_optionsweps.noammo.generic.x        = GAME_OPTIONS_X_POS;
        s_optionsweps.noammo.generic.y        = y;
        s_optionsweps.noammo.itemnames                 = noammo_names;

        y += 2 * BIGCHAR_HEIGHT;
        s_optionsweps.list.generic.type                      = MTYPE_FIELD;
        s_optionsweps.list.generic.flags                     = QMF_NODEFAULTINIT;
        s_optionsweps.list.generic.id                        = ID_WEAPONS_LIST;
        s_optionsweps.list.generic.ownerdraw         = OptionsWeps_DrawList;
        s_optionsweps.list.field.widthInChars        = MAX_LISTLENGTH;
        s_optionsweps.list.field.maxchars            = MAX_LISTLENGTH;
        s_optionsweps.list.generic.x                         = GAME_OPTIONS_X_POS;
        s_optionsweps.list.generic.y                         = y;
        s_optionsweps.list.generic.left                      = GAME_OPTIONS_X_POS - 150;
        s_optionsweps.list.generic.top                       = y - 8;
        s_optionsweps.list.generic.right                     = GAME_OPTIONS_X_POS + 150;
        s_optionsweps.list.generic.bottom            = y + 2 * PROP_HEIGHT;

        s_optionsweps.back.generic.type     = MTYPE_BITMAP;
        s_optionsweps.back.generic.name     = ART_BACK0;
        s_optionsweps.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsweps.back.generic.callback = OptionsWeps_Event;
        s_optionsweps.back.generic.id       = ID_BACK;
        s_optionsweps.back.generic.x            = 0;
        s_optionsweps.back.generic.y            = 480-64;
        s_optionsweps.back.width                    = 128;
        s_optionsweps.back.height                   = 64;
        s_optionsweps.back.focuspic         = ART_BACK1;

        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.banner );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.framel );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.framer );

        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.hud );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.crosshair );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.weapons );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.effects );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.scores );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.misc );

// menu-specific stuff
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.pos );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.flash );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.autoswitch );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.noammo );
        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.list );

        Menu_AddItem( &s_optionsweps.menu, &s_optionsweps.back );

        OptionsWeps_SetMenuItems();
}


/*
===============
OptionsWeps_Cache
===============
*/
void OptionsWeps_Cache( void ) {

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );

        s_optionsweps.weaponShader[0] = trap_R_RegisterShaderNoMip( "icons/iconw_gauntlet" );
        s_optionsweps.weaponShader[1] = trap_R_RegisterShaderNoMip( "icons/iconw_machinegun" );
        s_optionsweps.weaponShader[2] = trap_R_RegisterShaderNoMip( "icons/iconw_shotgun" );
        s_optionsweps.weaponShader[3] = trap_R_RegisterShaderNoMip( "icons/iconw_grenade" );
        s_optionsweps.weaponShader[4] = trap_R_RegisterShaderNoMip( "icons/iconw_rocket" );
        s_optionsweps.weaponShader[5] = trap_R_RegisterShaderNoMip( "icons/iconw_lightning" );
        s_optionsweps.weaponShader[6] = trap_R_RegisterShaderNoMip( "icons/iconw_railgun" );
        s_optionsweps.weaponShader[7] = trap_R_RegisterShaderNoMip( "icons/iconw_plasma" );
        s_optionsweps.weaponShader[8] = trap_R_RegisterShaderNoMip( "icons/iconw_bfg" );
        s_optionsweps.weaponShader[9] = trap_R_RegisterShaderNoMip( "icons/iconw_grapple" );

}

/*
===============
UI_OptionsWepsMenu
===============
*/
void UI_OptionsWepsMenu( void ) {
        OptionsWeps_MenuInit();
        UI_PushMenu( &s_optionsweps.menu );
        Menu_SetCursorToItem( &s_optionsweps.menu, &s_optionsweps.weapons );
}

/*
=======================================================================

GAME OPTIONS EFFECTS MENU

=======================================================================
*/

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

        menutext_s              hud;
        menutext_s              crosshair;
        menutext_s              weapons;
        menutext_s              effects;
        menutext_s              scores;
        menutext_s              misc;

// menu-specific stuff
        menuradiobutton_s       dlights;
        menuslider_s            nummarks;
        menuslider_s            marktime;
        menuslider_s            numgibs;
        menuslider_s            gibtime;
        menuslider_s            railtime;
        menuslider_s            brasstime;
        menuslider_s            smokealpha;
        menuslider_s            bloodalpha;

        menutext_s              draw;

        qhandle_t               FXShader[2];

	menubitmap_s		back;

} optionsfx_t;

static optionsfx_t s_optionsfx;

static void OptionsFX_MarkGib( void ) {
        int     i;
        if ( !s_optionsfx.nummarks.curvalue ) {
                s_optionsfx.marktime.generic.flags |= QMF_GRAYED;
        } else {
                s_optionsfx.marktime.generic.flags &= ~QMF_GRAYED;
        }

        if ( !s_optionsfx.numgibs.curvalue ) {
                s_optionsfx.gibtime.generic.flags |= QMF_GRAYED;
        } else {
                s_optionsfx.gibtime.generic.flags &= ~QMF_GRAYED;
        }
}

static void OptionsFX_SetMenuItems( void ) {
        int     i;
        float   f;

        i = trap_Cvar_VariableValue( "r_dynamiclight" );

        s_optionsfx.dlights.curvalue = i ? 1 : 0;

        trap_Cvar_VariableStringBuffer( "cg_fx", cg_fx, MAX_INFO_STRING );

        i = atoi( cvar_argv( cg_fx, 1 ) );
        s_optionsfx.nummarks.curvalue = i;

        i = atoi( cvar_argv( cg_fx, 2 ) );
        s_optionsfx.marktime.curvalue = i / 100;

        i = atoi( cvar_argv( cg_fx, 3 ) );
        s_optionsfx.numgibs.curvalue = i;

        i = atoi( cvar_argv( cg_fx, 4 ) );
        s_optionsfx.gibtime.curvalue = i / 100;

        i = atoi( cvar_argv( cg_fx, 5 ) );
        s_optionsfx.brasstime.curvalue = i / 100;

        i = atoi( cvar_argv( cg_fx, 6 ) );
        s_optionsfx.railtime.curvalue = i / 100;

        trap_Cvar_VariableStringBuffer( "cg_alpha", cg_alpha, MAX_INFO_STRING );

        f = atof( cvar_argv( cg_alpha, 1 ) );
        s_optionsfx.smokealpha.curvalue = f * 20;

        f = atof( cvar_argv( cg_alpha, 2 ) );
        s_optionsfx.bloodalpha.curvalue = f * 20;

        OptionsFX_MarkGib();
}

static void OptionsFX_SaveChanges( void ) {
        int     i;
        float   f;

        trap_Cvar_SetValue( "r_dynamiclight", s_optionsfx.dlights.curvalue );

        i = s_optionsfx.nummarks.curvalue;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 1, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsfx.marktime.curvalue * 100;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 2, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsfx.numgibs.curvalue;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 3, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsfx.gibtime.curvalue * 100;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 4, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsfx.brasstime.curvalue * 100;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 5, va("%i", i ) ), MAX_INFO_STRING );

        i = s_optionsfx.railtime.curvalue * 100;
        Q_strncpyz( cg_fx, set_argv( cg_fx, 6, va("%i", i ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_fx", cg_fx );

        f = s_optionsfx.smokealpha.curvalue / 20;
        Q_strncpyz( cg_alpha, set_argv( cg_alpha, 1, va("%1.2f", f ) ), MAX_INFO_STRING );

        f = s_optionsfx.bloodalpha.curvalue / 20;
        Q_strncpyz( cg_alpha, set_argv( cg_alpha, 2, va("%1.2f", f ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_alpha", cg_alpha );
}

static sfxHandle_t OptionsFX_MenuKey( int key ) {

        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
                OptionsFX_SaveChanges();
		break;
	}

        return ( Menu_DefaultKey( &s_optionsfx.menu, key ) );
}

static void OptionsFX_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
        case ID_HUD:
                OptionsFX_SaveChanges();
		UI_PopMenu();
                UI_OptionsHUDMenu();
                break;
        case ID_XHAIR:
                OptionsFX_SaveChanges();
		UI_PopMenu();
                UI_OptionsXHairMenu();
		break;
        case ID_WEAPONS:
                OptionsFX_SaveChanges();
                UI_PopMenu();
                UI_OptionsWepsMenu();
                break;
        case ID_MISC:
                OptionsFX_SaveChanges();
                UI_PopMenu();
                UI_OptionsMiscMenu();
                break;

        case ID_EFFECTS_NUMMARKS:
                OptionsFX_MarkGib();
                break;
        case ID_EFFECTS_NUMGIBS:
                OptionsFX_MarkGib();
                break;
        case ID_EFFECTS_SMOKEALPHA:
                s_optionsfx.smokealpha.curvalue = s_optionsfx.smokealpha.curvalue > 20 ? 20 : s_optionsfx.smokealpha.curvalue < 0 ? 0 : s_optionsfx.smokealpha.curvalue;
                break;
        case ID_EFFECTS_BLOODALPHA:
                s_optionsfx.bloodalpha.curvalue = s_optionsfx.bloodalpha.curvalue > 20 ? 20 : s_optionsfx.bloodalpha.curvalue < 0 ? 0 : s_optionsfx.bloodalpha.curvalue;
                break;
	case ID_BACK:
                OptionsFX_SaveChanges();
		UI_PopMenu();
		break;
	}
}

static void OptionsFX_DrawStuff( void *self ) {
        vec4_t          fx_color;
        int             x, y;

        fx_color[0] = 1.00;
        fx_color[1] = 1.00;
        fx_color[2] = 1.00;
        fx_color[3] = s_optionsfx.smokealpha.curvalue / 20;

        trap_R_SetColor( fx_color );
        UI_DrawHandlePic( 240, 312, 64, 64, s_optionsfx.FXShader[0] );

        fx_color[3] = s_optionsfx.bloodalpha.curvalue / 20;

        trap_R_SetColor( fx_color );
        UI_DrawHandlePic( 312, 312, 64, 64, s_optionsfx.FXShader[1] );

        trap_R_SetColor( NULL );

        y = 152 + BIGCHAR_HEIGHT;
        x = GAME_OPTIONS_X_POS + 108;

        if ( s_optionsfx.nummarks.curvalue )
                UI_DrawString( x, y, va("%f marks", s_optionsfx.nummarks.curvalue ), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no marks", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        UI_DrawString( x, y, va("%1.2f sec", s_optionsfx.marktime.curvalue / 10 ), UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        if ( s_optionsfx.numgibs.curvalue )
                UI_DrawString( x, y, va("%f gibs", s_optionsfx.numgibs.curvalue ), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no gibs", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        UI_DrawString( x, y, va("%1.2f sec", s_optionsfx.gibtime.curvalue / 10 ), UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        if ( s_optionsfx.brasstime.curvalue )
                UI_DrawString( x, y, va("%1.2f sec", s_optionsfx.brasstime.curvalue / 10), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no brass", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        if ( s_optionsfx.railtime.curvalue )
                UI_DrawString( x, y, va("%1.2f sec", s_optionsfx.railtime.curvalue / 10), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no trail", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += 2 * BIGCHAR_HEIGHT;

        if ( s_optionsfx.smokealpha.curvalue )
                UI_DrawString( x, y, va("%1.2f", s_optionsfx.smokealpha.curvalue / 20), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no smoke", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += BIGCHAR_HEIGHT;

        if ( s_optionsfx.bloodalpha.curvalue )
                UI_DrawString( x, y, va("%1.2f", s_optionsfx.bloodalpha.curvalue / 20), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( x, y, "no blood", UI_LEFT|UI_SMALLFONT, text_color_normal );

}

static void OptionsFX_MenuInit( void ) {
	int				y;

        memset( &s_optionsfx, 0 ,sizeof(optionsfx_t) );

        OptionsFX_Cache();

        s_optionsfx.menu.key        = OptionsFX_MenuKey;
        s_optionsfx.menu.wrapAround = qtrue;
        s_optionsfx.menu.fullscreen = qtrue;

        s_optionsfx.banner.generic.type  = MTYPE_BTEXT;
        s_optionsfx.banner.generic.x     = 320;
        s_optionsfx.banner.generic.y     = 16;
        s_optionsfx.banner.string                = "GAME OPTIONS";
        s_optionsfx.banner.color         = color_white;
        s_optionsfx.banner.style         = UI_CENTER;

        s_optionsfx.framel.generic.type  = MTYPE_BITMAP;
        s_optionsfx.framel.generic.name  = ART_FRAMEL;
        s_optionsfx.framel.generic.flags = QMF_INACTIVE;
        s_optionsfx.framel.generic.x     = 0;
        s_optionsfx.framel.generic.y     = 78;
        s_optionsfx.framel.width         = 256;
        s_optionsfx.framel.height        = 329;

        s_optionsfx.framer.generic.type  = MTYPE_BITMAP;
        s_optionsfx.framer.generic.name  = ART_FRAMER;
        s_optionsfx.framer.generic.flags = QMF_INACTIVE;
        s_optionsfx.framer.generic.x     = 376;
        s_optionsfx.framer.generic.y     = 76;
        s_optionsfx.framer.width         = 256;
        s_optionsfx.framer.height        = 334;

        s_optionsfx.hud.generic.type         = MTYPE_PTEXT;
        s_optionsfx.hud.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.hud.generic.id           = ID_HUD;
        s_optionsfx.hud.generic.callback     = OptionsFX_Event;
        s_optionsfx.hud.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.hud.generic.y            = 240 - 2.8 * PROP_HEIGHT;
        s_optionsfx.hud.string                       = "HUD";
        s_optionsfx.hud.style                        = UI_RIGHT;
        s_optionsfx.hud.color                        = color_red;

        s_optionsfx.crosshair.generic.type         = MTYPE_PTEXT;
        s_optionsfx.crosshair.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.crosshair.generic.id           = ID_XHAIR;
        s_optionsfx.crosshair.generic.callback     = OptionsFX_Event;
        s_optionsfx.crosshair.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.crosshair.generic.y            = 240 - 1.75 * PROP_HEIGHT;
        s_optionsfx.crosshair.string                       = "CROSSHAIR";
        s_optionsfx.crosshair.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsfx.crosshair.color                        = color_red;

        s_optionsfx.weapons.generic.type         = MTYPE_PTEXT;
        s_optionsfx.weapons.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.weapons.generic.id           = ID_WEAPONS;
        s_optionsfx.weapons.generic.callback     = OptionsFX_Event;
        s_optionsfx.weapons.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.weapons.generic.y            = 240 - 1 * PROP_HEIGHT;
        s_optionsfx.weapons.string                       = "WEAPONS";
        s_optionsfx.weapons.style                        = UI_RIGHT;
        s_optionsfx.weapons.color                        = color_red;

        s_optionsfx.effects.generic.type         = MTYPE_PTEXT;
        s_optionsfx.effects.generic.flags        = QMF_RIGHT_JUSTIFY;
        s_optionsfx.effects.generic.id           = ID_EFFECTS;
        s_optionsfx.effects.generic.callback     = OptionsFX_Event;
        s_optionsfx.effects.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.effects.generic.y            = 240;
        s_optionsfx.effects.string                       = "EFFECTS";
        s_optionsfx.effects.style                        = UI_RIGHT;
        s_optionsfx.effects.color                        = color_red;

        s_optionsfx.scores.generic.type         = MTYPE_PTEXT;
        s_optionsfx.scores.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.scores.generic.id           = ID_SCORES;
        s_optionsfx.scores.generic.callback     = OptionsFX_Event;
        s_optionsfx.scores.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.scores.generic.y            = 240 + 1.1 * PROP_HEIGHT;
        s_optionsfx.scores.string                       = "SCOREBOARD";
        s_optionsfx.scores.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsfx.scores.color                        = color_red;

        s_optionsfx.misc.generic.type         = MTYPE_PTEXT;
        s_optionsfx.misc.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.misc.generic.id           = ID_MISC;
        s_optionsfx.misc.generic.callback     = OptionsFX_Event;
        s_optionsfx.misc.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsfx.misc.generic.y            = 240 + 1.9 * PROP_HEIGHT;
        s_optionsfx.misc.string                       = "MISC";
        s_optionsfx.misc.style                        = UI_RIGHT;
        s_optionsfx.misc.color                        = color_red;

// menu-specific stuff

        y = 152;

        s_optionsfx.dlights.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsfx.dlights.generic.name              = "Dynamic Lights:";
        s_optionsfx.dlights.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.dlights.generic.callback          = OptionsFX_Event;
        s_optionsfx.dlights.generic.id                = ID_EFFECTS_DLIGHTS;
        s_optionsfx.dlights.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsfx.dlights.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.nummarks.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.nummarks.generic.name                       = "# of Marks:";
        s_optionsfx.nummarks.generic.callback                   = OptionsFX_Event;
        s_optionsfx.nummarks.generic.id                         = ID_EFFECTS_NUMMARKS;
        s_optionsfx.nummarks.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.nummarks.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.nummarks.generic.y                          = y;
        s_optionsfx.nummarks.minvalue                           = 0;
        s_optionsfx.nummarks.maxvalue                           = 4096;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.marktime.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.marktime.generic.name                       = "Mark Stay Time:";
        s_optionsfx.marktime.generic.callback                   = OptionsFX_Event;
        s_optionsfx.marktime.generic.id                         = ID_EFFECTS_MARKTIME;
        s_optionsfx.marktime.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.marktime.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.marktime.generic.y                          = y;
        s_optionsfx.marktime.minvalue                           = 0;
        s_optionsfx.marktime.maxvalue                           = 600;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.numgibs.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.numgibs.generic.name                       = "Gibs/Body Ratio:";
        s_optionsfx.numgibs.generic.callback                   = OptionsFX_Event;
        s_optionsfx.numgibs.generic.id                         = ID_EFFECTS_NUMGIBS;
        s_optionsfx.numgibs.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.numgibs.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.numgibs.generic.y                          = y;
        s_optionsfx.numgibs.minvalue                           = 0;
        s_optionsfx.numgibs.maxvalue                           = 50;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.gibtime.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.gibtime.generic.name                       = "Gib Stay Time:";
        s_optionsfx.gibtime.generic.callback                   = OptionsFX_Event;
        s_optionsfx.gibtime.generic.id                         = ID_EFFECTS_GIBTIME;
        s_optionsfx.gibtime.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.gibtime.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.gibtime.generic.y                          = y;
        s_optionsfx.gibtime.minvalue                           = 0;
        s_optionsfx.gibtime.maxvalue                           = 600;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.brasstime.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.brasstime.generic.name                       = "Brass Stay Time:";
        s_optionsfx.brasstime.generic.callback                   = OptionsFX_Event;
        s_optionsfx.brasstime.generic.id                         = ID_EFFECTS_BRASSTIME;
        s_optionsfx.brasstime.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.brasstime.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.brasstime.generic.y                          = y;
        s_optionsfx.brasstime.minvalue                           = 0;
        s_optionsfx.brasstime.maxvalue                           = 50;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.railtime.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.railtime.generic.name                       = "Rail Trail Time:";
        s_optionsfx.railtime.generic.callback                   = OptionsFX_Event;
        s_optionsfx.railtime.generic.id                         = ID_EFFECTS_RAILTIME;
        s_optionsfx.railtime.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.railtime.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.railtime.generic.y                          = y;
        s_optionsfx.railtime.minvalue                           = 0;
        s_optionsfx.railtime.maxvalue                           = 50;

        y += 2 * BIGCHAR_HEIGHT;
        s_optionsfx.smokealpha.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.smokealpha.generic.name                       = "Smoke Opacity:";
        s_optionsfx.smokealpha.generic.callback                   = OptionsFX_Event;
        s_optionsfx.smokealpha.generic.id                         = ID_EFFECTS_SMOKEALPHA;
        s_optionsfx.smokealpha.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.smokealpha.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.smokealpha.generic.y                          = y;
        s_optionsfx.smokealpha.minvalue                           = 0;
        s_optionsfx.smokealpha.maxvalue                           = 20;

	y += BIGCHAR_HEIGHT;
        s_optionsfx.bloodalpha.generic.type                       = MTYPE_SLIDER;
        s_optionsfx.bloodalpha.generic.name                       = "Blood Opacity:";
        s_optionsfx.bloodalpha.generic.callback                   = OptionsFX_Event;
        s_optionsfx.bloodalpha.generic.id                         = ID_EFFECTS_BLOODALPHA;
        s_optionsfx.bloodalpha.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsfx.bloodalpha.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsfx.bloodalpha.generic.y                          = y;
        s_optionsfx.bloodalpha.minvalue                           = 0;
        s_optionsfx.bloodalpha.maxvalue                           = 20;

        s_optionsfx.draw.generic.type         = MTYPE_PTEXT;
        s_optionsfx.draw.generic.flags        = QMF_INACTIVE|QMF_GRAYED;
        s_optionsfx.draw.generic.callback     = OptionsFX_Event;
        s_optionsfx.draw.generic.ownerdraw    = OptionsFX_DrawStuff;
        s_optionsfx.draw.string                       = "";

        s_optionsfx.back.generic.type     = MTYPE_BITMAP;
        s_optionsfx.back.generic.name     = ART_BACK0;
        s_optionsfx.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsfx.back.generic.callback = OptionsFX_Event;
        s_optionsfx.back.generic.id       = ID_BACK;
        s_optionsfx.back.generic.x            = 0;
        s_optionsfx.back.generic.y            = 480-64;
        s_optionsfx.back.width                    = 128;
        s_optionsfx.back.height                   = 64;
        s_optionsfx.back.focuspic         = ART_BACK1;

        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.banner );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.framel );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.framer );

        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.hud );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.crosshair );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.weapons );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.effects );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.scores );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.misc );

// menu-specific stuff
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.dlights );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.nummarks );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.marktime );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.numgibs );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.gibtime );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.brasstime );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.railtime );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.smokealpha );
        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.bloodalpha );

        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.draw );

        Menu_AddItem( &s_optionsfx.menu, &s_optionsfx.back );

        OptionsFX_SetMenuItems();
}


/*
===============
OptionsFX_Cache
===============
*/
void OptionsFX_Cache( void ) {

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );

        if ( uis.glconfig.hardwareType == GLHW_RAGEPRO ) {
                s_optionsfx.FXShader[0] = trap_R_RegisterShaderNoMip( "smokePuffRagePro" );
        } else {
                s_optionsfx.FXShader[0] = trap_R_RegisterShaderNoMip( "smokePuff" );
        }

        s_optionsfx.FXShader[1] = trap_R_RegisterShaderNoMip( "bloodTrail" );
}


/*
===============
UI_OptionsFXMenu
===============
*/
void UI_OptionsFXMenu( void ) {
        OptionsFX_MenuInit();
        UI_PushMenu( &s_optionsfx.menu );
        Menu_SetCursorToItem( &s_optionsfx.menu, &s_optionsfx.effects );
}

/*
=======================================================================

GAME OPTIONS MISC MENU

=======================================================================
*/

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

        menutext_s              hud;
        menutext_s              crosshair;
        menutext_s              weapons;
        menutext_s              effects;
        menutext_s              scores;
        menutext_s              misc;

// menu-specific stuff

        menulist_s              fastrespawn;
        menulist_s              deferplayers;
        menuradiobutton_s       simpleitems;

        menuslider_s            zoom_fov;
        menuslider_s            zoom_time;
        menuslider_s            zoom_sens;

        menuradiobutton_s       announcer_leadtied;
        menuradiobutton_s       announcer_countdown;
        menuradiobutton_s       announcer_rewards;
        menuradiobutton_s       announcer_powerups;
        menuradiobutton_s       announcer_extra;

        menuradiobutton_s       hitbeep;
        menuradiobutton_s       painbeep;
        menuradiobutton_s       teambeep;
        menuradiobutton_s       timebeep;

        menuradiobutton_s       force_std_skin;
        menuradiobutton_s       force_std_model;
        menuradiobutton_s       force_std_sound;
        menuradiobutton_s       force_team_color;
        menuradiobutton_s       force_same_model;

        menutext_s              draw;

	menubitmap_s		back;

} optionsmisc_t;

static optionsmisc_t s_optionsmisc;

static const char *respawn_names[] =
{
        "off",
        "on button press",
        "on death (ASAP)",
	0
};

static const char *defer_options[] =
{
        "no",
        "yes",
        "forever",
	0
};

static void OptionsMisc_SetMenuItems( void ) {
        int     i;
        float   f;

        f = trap_Cvar_VariableValue( "cg_fastRespawn" );
        s_optionsmisc.fastrespawn.curvalue = f;

        f = trap_Cvar_VariableValue( "cg_deferPlayers" );
        s_optionsmisc.deferplayers.curvalue = f ? 1 : 0;

        f = trap_Cvar_VariableValue( "cg_simpleItems" );
        s_optionsmisc.simpleitems.curvalue = f ? 1 : 0;

        trap_Cvar_VariableStringBuffer( "cg_zoom", cg_zoom, MAX_INFO_STRING );
        s_optionsmisc.zoom_fov.curvalue = atof( cvar_argv(cg_zoom, 1 ) ) * 2;

        s_optionsmisc.zoom_time.curvalue = atof( cvar_argv(cg_zoom, 2 ) ) / 50;

        s_optionsmisc.zoom_sens.curvalue = atof( cvar_argv(cg_zoom, 3 ) ) * 10;

        trap_Cvar_VariableStringBuffer( "cg_announcer", cg_announcer, MAX_INFO_STRING );
        i = atoi( cvar_argv(cg_announcer, 1 ) );
        s_optionsmisc.announcer_leadtied.curvalue = i & CG_ANNOUNCER_NOLEADTIED ? 0 : 1;
        s_optionsmisc.announcer_countdown.curvalue = i & CG_ANNOUNCER_NOCOUNTDOWN ? 0 : 1;
        s_optionsmisc.announcer_rewards.curvalue = i & CG_ANNOUNCER_NOAWARDS ? 0 : 1;
        s_optionsmisc.announcer_powerups.curvalue = i & CG_ANNOUNCER_NOPOWERUPS ? 0 : 1;
        s_optionsmisc.announcer_extra.curvalue = i & CG_ANNOUNCER_NOEXTRA ? 0 : 1;

        trap_Cvar_VariableStringBuffer( "cg_noBeeps", cg_noBeeps, MAX_INFO_STRING );
        i = atoi( cvar_argv(cg_noBeeps, 1 ) );
        s_optionsmisc.hitbeep.curvalue = i & CG_NOBEEPS_HIT ? 0 : 1;
        s_optionsmisc.painbeep.curvalue = i & CG_NOBEEPS_PAIN ? 0 : 1;
        s_optionsmisc.teambeep.curvalue = i & CG_NOBEEPS_TEAMHIT ? 0 : 1;
        s_optionsmisc.timebeep.curvalue = i & CG_NOBEEPS_TIMEWARN ? 0 : 1;

        trap_Cvar_VariableStringBuffer( "cg_force", cg_force, MAX_INFO_STRING );
        i = atoi( cvar_argv(cg_force, 1 ) );
        s_optionsmisc.force_std_skin.curvalue = i & CG_FORCE_STD_SKIN ? 1 : 0;
        s_optionsmisc.force_std_model.curvalue = i & CG_FORCE_STD_MODEL ? 1 : 0;
        s_optionsmisc.force_std_sound.curvalue = i & CG_FORCE_STD_SOUND ? 1 : 0;
        s_optionsmisc.force_same_model.curvalue = i & CG_FORCE_SAME_MODEL ? 1 : 0;
        s_optionsmisc.force_team_color.curvalue = i & CG_FORCE_TEAM_COLOR ? 1 : 0;

}

static void OptionsMisc_SaveChanges( void ) {
        int     i;
        float   f;

        trap_Cvar_SetValue( "cg_fastRespawn", s_optionsmisc.fastrespawn.curvalue );

        trap_Cvar_SetValue( "cg_deferPlayers", s_optionsmisc.deferplayers.curvalue );

        trap_Cvar_SetValue( "cg_simpleItems", s_optionsmisc.simpleitems.curvalue );

        f = s_optionsmisc.zoom_fov.curvalue / 2;
        Q_strncpyz( cg_zoom, set_argv( cg_zoom, 1, va("%1.2f", f ) ), MAX_INFO_STRING );

        i = s_optionsmisc.zoom_time.curvalue * 50;
        Q_strncpyz( cg_zoom, set_argv( cg_zoom, 2, va("%i", i ) ), MAX_INFO_STRING );

        f = s_optionsmisc.zoom_sens.curvalue / 10;
        Q_strncpyz( cg_zoom, set_argv( cg_zoom, 3, va("%1.2f", f ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_zoom", cg_zoom );

        i = atoi( cvar_argv( cg_announcer, 1 ) );

        i = !s_optionsmisc.announcer_leadtied.curvalue ? i | CG_ANNOUNCER_NOLEADTIED : i & ~CG_ANNOUNCER_NOLEADTIED;
        i = !s_optionsmisc.announcer_countdown.curvalue ? i | CG_ANNOUNCER_NOCOUNTDOWN : i & ~CG_ANNOUNCER_NOCOUNTDOWN;
        i = !s_optionsmisc.announcer_rewards.curvalue ? i | CG_ANNOUNCER_NOAWARDS : i & ~CG_ANNOUNCER_NOAWARDS;
        i = !s_optionsmisc.announcer_powerups.curvalue ? i | CG_ANNOUNCER_NOPOWERUPS : i & ~CG_ANNOUNCER_NOPOWERUPS;
        i = !s_optionsmisc.announcer_extra.curvalue ? i | CG_ANNOUNCER_NOEXTRA : i & ~CG_ANNOUNCER_NOEXTRA;

        Q_strncpyz( cg_announcer, set_argv( cg_announcer, 1, va("%i", i ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_announcer", cg_announcer );

        i = atoi( cvar_argv( cg_noBeeps, 1 ) );

        i = !s_optionsmisc.hitbeep.curvalue ? i | CG_NOBEEPS_HIT : i & ~CG_NOBEEPS_HIT;
        i = !s_optionsmisc.painbeep.curvalue ? i | CG_NOBEEPS_PAIN : i & ~CG_NOBEEPS_PAIN;
        i = !s_optionsmisc.teambeep.curvalue ? i | CG_NOBEEPS_TEAMHIT : i & ~CG_NOBEEPS_TEAMHIT;
        i = !s_optionsmisc.timebeep.curvalue ? i | CG_NOBEEPS_TIMEWARN : i & ~CG_NOBEEPS_TIMEWARN;

        Q_strncpyz( cg_noBeeps, set_argv( cg_noBeeps, 1, va("%i", i ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_noBeeps", cg_noBeeps );

        i = atoi( cvar_argv( cg_force, 1 ) );

        i = s_optionsmisc.force_std_skin.curvalue ? i | CG_FORCE_STD_SKIN : i & ~CG_FORCE_STD_SKIN;
        i = s_optionsmisc.force_std_model.curvalue ? i | CG_FORCE_STD_MODEL : i & ~CG_FORCE_STD_MODEL;
        i = s_optionsmisc.force_std_sound.curvalue ? i | CG_FORCE_STD_SOUND : i & ~CG_FORCE_STD_SOUND;
        i = s_optionsmisc.force_same_model.curvalue ? i | CG_FORCE_SAME_MODEL : i & ~CG_FORCE_SAME_MODEL;
        i = s_optionsmisc.force_team_color.curvalue ? i | CG_FORCE_TEAM_COLOR : i & ~CG_FORCE_TEAM_COLOR;

        Q_strncpyz( cg_force, set_argv( cg_force, 1, va("%i", i ) ), MAX_INFO_STRING );

        trap_Cvar_Set( "cg_force", cg_force );
}

static sfxHandle_t OptionsMisc_MenuKey( int key ) {

        switch( key ) {
        case K_MOUSE2:
        case K_ESCAPE:
                OptionsMisc_SaveChanges();
		break;
	}

        return ( Menu_DefaultKey( &s_optionsmisc.menu, key ) );
}

static void OptionsMisc_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
        case ID_HUD:
                OptionsMisc_SaveChanges();
		UI_PopMenu();
                UI_OptionsHUDMenu();
                break;
        case ID_XHAIR:
                OptionsMisc_SaveChanges();
		UI_PopMenu();
                UI_OptionsXHairMenu();
		break;
        case ID_WEAPONS:
                OptionsMisc_SaveChanges();
                UI_PopMenu();
                UI_OptionsWepsMenu();
                break;
        case ID_EFFECTS:
                OptionsMisc_SaveChanges();
                UI_PopMenu();
                UI_OptionsFXMenu();
                break;

	case ID_BACK:
                OptionsMisc_SaveChanges();
		UI_PopMenu();
		break;
	}
}

static void OptionsMisc_DrawStuff( void *self ) {
        int     y, i, style;
        float  *temp_color;

        i = s_optionsmisc.menu.cursor;
        style = UI_CENTER|UI_SMALLFONT;

        if ( i > 8 && i < 14 ) { style |= UI_PULSE; temp_color = text_color_highlight; } else { style &= ~UI_PULSE; temp_color = text_color_normal; }
        UI_DrawProportionalString( GAME_OPTIONS_X_POS - 54, 73, "Force", style, temp_color );
        
        if ( i > 16 && i < 22 ) { style |= UI_PULSE; temp_color = text_color_highlight; } else { style &= ~UI_PULSE; temp_color = text_color_normal; }
        UI_DrawProportionalString( GAME_OPTIONS_X_POS - 58, 242, "Announcer", style, temp_color );

        if ( i > 21 && i < 26 ) { style |= UI_PULSE; temp_color = text_color_highlight; } else { style &= ~UI_PULSE; temp_color = text_color_normal; }
        UI_DrawProportionalString( GAME_OPTIONS_X_POS + 96, 242, "Beeps", style, temp_color );
        y = 186;
        UI_DrawString( GAME_OPTIONS_X_POS + 108, y, va( "%1.2f", s_optionsmisc.zoom_fov.curvalue / 2 ), UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += SMALLCHAR_HEIGHT;
        if ( s_optionsmisc.zoom_time.curvalue )
                UI_DrawString( GAME_OPTIONS_X_POS + 108, y, va( "%1.2f sec", s_optionsmisc.zoom_time.curvalue * 0.05), UI_LEFT|UI_SMALLFONT, text_color_normal );
        else
                UI_DrawString( GAME_OPTIONS_X_POS + 108, y, "no delay", UI_LEFT|UI_SMALLFONT, text_color_normal );
        y += SMALLCHAR_HEIGHT;
        UI_DrawString( GAME_OPTIONS_X_POS + 108, y, va( "%1.2fx", s_optionsmisc.zoom_sens.curvalue / 10), UI_LEFT|UI_SMALLFONT, text_color_normal );

}

static void OptionsMisc_MenuInit( void ) {
	int				y;

        memset( &s_optionsmisc, 0 ,sizeof(optionsmisc_t) );

        OptionsMisc_Cache();

        s_optionsmisc.menu.key        = OptionsMisc_MenuKey;
        s_optionsmisc.menu.wrapAround = qtrue;
        s_optionsmisc.menu.fullscreen = qtrue;

        s_optionsmisc.banner.generic.type  = MTYPE_BTEXT;
        s_optionsmisc.banner.generic.x     = 320;
        s_optionsmisc.banner.generic.y     = 16;
        s_optionsmisc.banner.string                = "GAME OPTIONS";
        s_optionsmisc.banner.color         = color_white;
        s_optionsmisc.banner.style         = UI_CENTER;

        s_optionsmisc.framel.generic.type  = MTYPE_BITMAP;
        s_optionsmisc.framel.generic.name  = ART_FRAMEL;
        s_optionsmisc.framel.generic.flags = QMF_INACTIVE;
        s_optionsmisc.framel.generic.x     = 0;
        s_optionsmisc.framel.generic.y     = 78;
        s_optionsmisc.framel.width         = 256;
        s_optionsmisc.framel.height        = 329;

        s_optionsmisc.framer.generic.type  = MTYPE_BITMAP;
        s_optionsmisc.framer.generic.name  = ART_FRAMER;
        s_optionsmisc.framer.generic.flags = QMF_INACTIVE;
        s_optionsmisc.framer.generic.x     = 376;
        s_optionsmisc.framer.generic.y     = 76;
        s_optionsmisc.framer.width         = 256;
        s_optionsmisc.framer.height        = 334;

        s_optionsmisc.hud.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.hud.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.hud.generic.id           = ID_HUD;
        s_optionsmisc.hud.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.hud.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.hud.generic.y            = 240 - 2.8 * PROP_HEIGHT;
        s_optionsmisc.hud.string                       = "HUD";
        s_optionsmisc.hud.style                        = UI_RIGHT;
        s_optionsmisc.hud.color                        = color_red;

        s_optionsmisc.crosshair.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.crosshair.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.crosshair.generic.id           = ID_XHAIR;
        s_optionsmisc.crosshair.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.crosshair.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.crosshair.generic.y            = 240 - 1.75 * PROP_HEIGHT;
        s_optionsmisc.crosshair.string                       = "CROSSHAIR";
        s_optionsmisc.crosshair.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsmisc.crosshair.color                        = color_red;

        s_optionsmisc.weapons.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.weapons.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.weapons.generic.id           = ID_WEAPONS;
        s_optionsmisc.weapons.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.weapons.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.weapons.generic.y            = 240 - 1 * PROP_HEIGHT;
        s_optionsmisc.weapons.string                       = "WEAPONS";
        s_optionsmisc.weapons.style                        = UI_RIGHT;
        s_optionsmisc.weapons.color                        = color_red;

        s_optionsmisc.effects.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.effects.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.effects.generic.id           = ID_EFFECTS;
        s_optionsmisc.effects.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.effects.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.effects.generic.y            = 240;
        s_optionsmisc.effects.string                       = "EFFECTS";
        s_optionsmisc.effects.style                        = UI_RIGHT;
        s_optionsmisc.effects.color                        = color_red;

        s_optionsmisc.scores.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.scores.generic.flags        = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.scores.generic.id           = ID_SCORES;
        s_optionsmisc.scores.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.scores.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.scores.generic.y            = 240 + 1.1 * PROP_HEIGHT;
        s_optionsmisc.scores.string                       = "SCOREBOARD";
        s_optionsmisc.scores.style                        = UI_RIGHT|UI_SMALLFONT;
        s_optionsmisc.scores.color                        = color_red;

        s_optionsmisc.misc.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.misc.generic.flags        = QMF_RIGHT_JUSTIFY;
        s_optionsmisc.misc.generic.id           = ID_MISC;
        s_optionsmisc.misc.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.misc.generic.x            = GAME_OPTIONS_MAIN_X_POS;
        s_optionsmisc.misc.generic.y            = 240 + 1.9 * PROP_HEIGHT;
        s_optionsmisc.misc.string                       = "MISC";
        s_optionsmisc.misc.style                        = UI_RIGHT;
        s_optionsmisc.misc.color                        = color_red;

// menu-specific stuff

        y = 98;

        s_optionsmisc.force_std_skin.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.force_std_skin.generic.name              = "Standard Skins:";
        s_optionsmisc.force_std_skin.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.force_std_skin.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.force_std_skin.generic.id                = ID_MISC_FORCE_STD_SKIN;
        s_optionsmisc.force_std_skin.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.force_std_skin.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.force_std_model.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.force_std_model.generic.name              = "Standard Model:";
        s_optionsmisc.force_std_model.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.force_std_model.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.force_std_model.generic.id                = ID_MISC_FORCE_STD_MODEL;
        s_optionsmisc.force_std_model.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.force_std_model.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.force_std_sound.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.force_std_sound.generic.name              = "Standard Sounds:";
        s_optionsmisc.force_std_sound.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.force_std_sound.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.force_std_sound.generic.id                = ID_MISC_FORCE_STD_SOUND;
        s_optionsmisc.force_std_sound.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.force_std_sound.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.force_team_color.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.force_team_color.generic.name              = "Strict Team Color:";
        s_optionsmisc.force_team_color.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.force_team_color.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.force_team_color.generic.id                = ID_MISC_FORCE_TEAM_COLOR;
        s_optionsmisc.force_team_color.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.force_team_color.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.force_same_model.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.force_same_model.generic.name              = "Same Model:";
        s_optionsmisc.force_same_model.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.force_same_model.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.force_same_model.generic.id                = ID_MISC_FORCE_SAME_MODEL;
        s_optionsmisc.force_same_model.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.force_same_model.generic.y                 = y;

        y += 1.5 * BIGCHAR_HEIGHT;
        s_optionsmisc.zoom_fov.generic.type                       = MTYPE_SLIDER;
        s_optionsmisc.zoom_fov.generic.name                       = "Zoom FOV:";
        s_optionsmisc.zoom_fov.generic.callback                   = OptionsFX_Event;
        s_optionsmisc.zoom_fov.generic.id                         = ID_MISC_ZOOM_FOV;
        s_optionsmisc.zoom_fov.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.zoom_fov.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsmisc.zoom_fov.generic.y                          = y;
        s_optionsmisc.zoom_fov.minvalue                           = 0;
        s_optionsmisc.zoom_fov.maxvalue                           = 120;

        y += BIGCHAR_HEIGHT;
        s_optionsmisc.zoom_time.generic.type                       = MTYPE_SLIDER;
        s_optionsmisc.zoom_time.generic.name                       = "Zoom Delay:";
        s_optionsmisc.zoom_time.generic.callback                   = OptionsFX_Event;
        s_optionsmisc.zoom_time.generic.id                         = ID_MISC_ZOOM_TIME;
        s_optionsmisc.zoom_time.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.zoom_time.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsmisc.zoom_time.generic.y                          = y;
        s_optionsmisc.zoom_time.minvalue                           = 0;
        s_optionsmisc.zoom_time.maxvalue                           = 20;

        y += BIGCHAR_HEIGHT;
        s_optionsmisc.zoom_sens.generic.type                       = MTYPE_SLIDER;
        s_optionsmisc.zoom_sens.generic.name                       = "Zoom Sensitivity:";
        s_optionsmisc.zoom_sens.generic.callback                   = OptionsFX_Event;
        s_optionsmisc.zoom_sens.generic.id                         = ID_MISC_ZOOM_SENS;
        s_optionsmisc.zoom_sens.generic.flags                      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.zoom_sens.generic.x                          = GAME_OPTIONS_X_POS;
        s_optionsmisc.zoom_sens.generic.y                          = y;
        s_optionsmisc.zoom_sens.minvalue                           = 0;
        s_optionsmisc.zoom_sens.maxvalue                           = 50;

        y += 3 * BIGCHAR_HEIGHT;
        s_optionsmisc.announcer_leadtied.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.announcer_leadtied.generic.name              = "Lead/Tied:";
        s_optionsmisc.announcer_leadtied.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.announcer_leadtied.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.announcer_leadtied.generic.id                = ID_MISC_ANNOUNCER_LEADTIED;
        s_optionsmisc.announcer_leadtied.generic.x                 = GAME_OPTIONS_X_POS - 42;
        s_optionsmisc.announcer_leadtied.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.announcer_countdown.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.announcer_countdown.generic.name              = "Countdowns:";
        s_optionsmisc.announcer_countdown.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.announcer_countdown.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.announcer_countdown.generic.id                = ID_MISC_ANNOUNCER_COUNTDOWN;
        s_optionsmisc.announcer_countdown.generic.x                 = GAME_OPTIONS_X_POS - 42;
        s_optionsmisc.announcer_countdown.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.announcer_rewards.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.announcer_rewards.generic.name              = "Awards:";
        s_optionsmisc.announcer_rewards.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.announcer_rewards.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.announcer_rewards.generic.id                = ID_MISC_ANNOUNCER_REWARDS;
        s_optionsmisc.announcer_rewards.generic.x                 = GAME_OPTIONS_X_POS - 42;
        s_optionsmisc.announcer_rewards.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.announcer_powerups.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.announcer_powerups.generic.name              = "Power-Ups:";
        s_optionsmisc.announcer_powerups.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.announcer_powerups.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.announcer_powerups.generic.id                = ID_MISC_ANNOUNCER_POWERUPS;
        s_optionsmisc.announcer_powerups.generic.x                 = GAME_OPTIONS_X_POS - 42;
        s_optionsmisc.announcer_powerups.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.announcer_extra.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.announcer_extra.generic.name              = "Extra:";
        s_optionsmisc.announcer_extra.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.announcer_extra.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.announcer_extra.generic.id                = ID_MISC_ANNOUNCER_EXTRA;
        s_optionsmisc.announcer_extra.generic.x                 = GAME_OPTIONS_X_POS - 42;
        s_optionsmisc.announcer_extra.generic.y                 = y;

        y -= 4 * BIGCHAR_HEIGHT;
        s_optionsmisc.hitbeep.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.hitbeep.generic.name              = "Hit:";
        s_optionsmisc.hitbeep.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.hitbeep.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.hitbeep.generic.id                = ID_MISC_HITBEEP;
        s_optionsmisc.hitbeep.generic.x                 = GAME_OPTIONS_X_POS + 96;
        s_optionsmisc.hitbeep.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.painbeep.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.painbeep.generic.name              = "Pain:";
        s_optionsmisc.painbeep.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.painbeep.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.painbeep.generic.id                = ID_MISC_PAINBEEP;
        s_optionsmisc.painbeep.generic.x                 = GAME_OPTIONS_X_POS + 96;
        s_optionsmisc.painbeep.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.teambeep.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.teambeep.generic.name              = "Team Hit:";
        s_optionsmisc.teambeep.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.teambeep.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.teambeep.generic.id                = ID_MISC_TEAMBEEP;
        s_optionsmisc.teambeep.generic.x                 = GAME_OPTIONS_X_POS + 96;
        s_optionsmisc.teambeep.generic.y                 = y;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.timebeep.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.timebeep.generic.name              = "Timer:";
        s_optionsmisc.timebeep.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.timebeep.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.timebeep.generic.id                = ID_MISC_TIMEBEEP;
        s_optionsmisc.timebeep.generic.x                 = GAME_OPTIONS_X_POS + 96;
        s_optionsmisc.timebeep.generic.y                 = y;

        y += 2.5 * BIGCHAR_HEIGHT;
        s_optionsmisc.fastrespawn.generic.type     = MTYPE_SPINCONTROL;
        s_optionsmisc.fastrespawn.generic.name         = "Fast Respawn:";
        s_optionsmisc.fastrespawn.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.fastrespawn.generic.callback = OptionsMisc_Event;
        s_optionsmisc.fastrespawn.generic.id       = ID_MISC_FASTRESPAWN;
        s_optionsmisc.fastrespawn.generic.x        = GAME_OPTIONS_X_POS;
        s_optionsmisc.fastrespawn.generic.y        = y;
        s_optionsmisc.fastrespawn.itemnames                 = respawn_names;

	y += BIGCHAR_HEIGHT;
        s_optionsmisc.deferplayers.generic.type     = MTYPE_SPINCONTROL;
        s_optionsmisc.deferplayers.generic.name         = "Defer Players:";
        s_optionsmisc.deferplayers.generic.flags        = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.deferplayers.generic.callback = OptionsMisc_Event;
        s_optionsmisc.deferplayers.generic.id       = ID_MISC_DEFERPLAYERS;
        s_optionsmisc.deferplayers.generic.x        = GAME_OPTIONS_X_POS;
        s_optionsmisc.deferplayers.generic.y        = y;
        s_optionsmisc.deferplayers.itemnames                 = defer_options;

        y += BIGCHAR_HEIGHT;
        s_optionsmisc.simpleitems.generic.type              = MTYPE_RADIOBUTTON;
        s_optionsmisc.simpleitems.generic.name              = "Simple Items:";
        s_optionsmisc.simpleitems.generic.flags             = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
        s_optionsmisc.simpleitems.generic.callback          = OptionsMisc_Event;
        s_optionsmisc.simpleitems.generic.id                = ID_MISC_SIMPLEITEMS;
        s_optionsmisc.simpleitems.generic.x                 = GAME_OPTIONS_X_POS;
        s_optionsmisc.simpleitems.generic.y                 = y;

        s_optionsmisc.draw.generic.type         = MTYPE_PTEXT;
        s_optionsmisc.draw.generic.flags        = QMF_INACTIVE|QMF_GRAYED;
        s_optionsmisc.draw.generic.callback     = OptionsMisc_Event;
        s_optionsmisc.draw.generic.ownerdraw    = OptionsMisc_DrawStuff;
        s_optionsmisc.draw.string                       = "";

        s_optionsmisc.back.generic.type     = MTYPE_BITMAP;
        s_optionsmisc.back.generic.name     = ART_BACK0;
        s_optionsmisc.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
        s_optionsmisc.back.generic.callback = OptionsMisc_Event;
        s_optionsmisc.back.generic.id       = ID_BACK;
        s_optionsmisc.back.generic.x            = 0;
        s_optionsmisc.back.generic.y            = 480-64;
        s_optionsmisc.back.width                    = 128;
        s_optionsmisc.back.height                   = 64;
        s_optionsmisc.back.focuspic         = ART_BACK1;

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.banner );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.framel );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.framer );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.hud );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.crosshair );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.weapons );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.effects );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.scores );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.misc );

// menu-specific stuff

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.force_std_skin );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.force_std_model );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.force_std_sound );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.force_team_color );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.force_same_model );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.zoom_fov );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.zoom_time );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.zoom_sens );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.announcer_leadtied );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.announcer_countdown );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.announcer_rewards );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.announcer_powerups );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.announcer_extra );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.hitbeep );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.painbeep );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.teambeep );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.timebeep );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.fastrespawn );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.deferplayers );
        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.simpleitems );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.draw );

        Menu_AddItem( &s_optionsmisc.menu, &s_optionsmisc.back );

        OptionsMisc_SetMenuItems();
}


/*
===============
OptionsMisc_Cache
===============
*/
void OptionsMisc_Cache( void ) {

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );

}


/*
===============
UI_OptionsMiscMenu
===============
*/
void UI_OptionsMiscMenu( void ) {
        OptionsMisc_MenuInit();
        UI_PushMenu( &s_optionsmisc.menu );
        Menu_SetCursorToItem( &s_optionsmisc.menu, &s_optionsmisc.misc );
}

