// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

DEMOS MENU

=======================================================================
*/


#include "ui_local.h"


#define ART_BACK0			"menu/art/back_0"
#define ART_BACK1			"menu/art/back_1"	
#define ART_GO0				"menu/art/play_0"
#define ART_GO1				"menu/art/play_1"
#define ART_FRAMEL			"menu/art/frame2_l"
#define ART_FRAMER			"menu/art/frame1_r"
#define ART_ARROWS			"menu/art/arrows_horz_0"
#define ART_ARROWLEFT		"menu/art/arrows_horz_left"
#define ART_ARROWRIGHT		"menu/art/arrows_horz_right"

#define MAX_DEMOS			128
#define NAMEBUFSIZE			( MAX_DEMOS * 16 )

#define ID_BACK				10
#define ID_GO				11
#define ID_LIST				12
#define ID_RIGHT			13
#define ID_LEFT				14

#define ARROWS_WIDTH		128
#define ARROWS_HEIGHT		48


typedef struct {
	menuframework_s	menu;

	menutext_s		banner;
	menubitmap_s	framel;
	menubitmap_s	framer;

	menulist_s		list;

	menubitmap_s	arrows;
	menubitmap_s	left;
	menubitmap_s	right;
	menubitmap_s	back;
	menubitmap_s	go;

	int				numDemos;
	char			names[NAMEBUFSIZE];
	char			*demolist[MAX_DEMOS];
} demos_t;

static demos_t	s_demos;

/* CORIOLIS 3/18/00 */
static int ms_click = -2000;
// q3app (moved this to ui_main.c, where other cvars are defined)
// static vmCvar_t ui_dblclick;
/* END CORIOLIS */

/* CORIOLIS 1/29/00 */
static char basedir[1024];
static int  maxlen;
static void UI_DemosMenuInternal( const char* rootdir, const char* subdir );

/*
===============
Demos_ActivateItem
===============
*/
static void Demos_ActivateItem( void ) {
	const char* demo;

	demo = s_demos.list.itemnames[s_demos.list.curvalue];
	if (demo[0]!='/') {
		if (!Q_stricmp( basedir, "demos" )) {
			trap_Cmd_ExecuteText( EXEC_APPEND, va( "demo \"%s.dm3\"\n", demo ) );
		}
		else {
			trap_Cmd_ExecuteText( EXEC_APPEND, va( "demo \"%s/%s.dm3\"\n", &basedir[6], demo ) );
		}
	}
	else {
		UI_DemosMenuInternal( basedir, demo );
	}
}

/* END CORIOLIS */

/*
===============
Demos_MenuEvent
===============
*/
static void Demos_MenuEvent( void *ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_GO:
		UI_ForceMenuOff ();
/* CORIOLIS 1/29/00
		trap_Cmd_ExecuteText( EXEC_APPEND, va( "demo %s.dm3\n", s_demos.list.itemnames[s_demos.list.curvalue] ) );
END CORIOLIS */
		/* CORIOLIS 1/29/00 */
		Demos_ActivateItem();
		/* END CORIOLIS */
		break;

	case ID_BACK:
		UI_PopMenu();
		break;

	case ID_LEFT:
		ScrollList_Key( &s_demos.list, K_LEFTARROW );
		break;

	case ID_RIGHT:
		ScrollList_Key( &s_demos.list, K_RIGHTARROW );
		break;
	}
}


/*
=================
UI_DemosMenu_Key
=================
*/
static sfxHandle_t UI_DemosMenu_Key( int key ) {
	menucommon_s	*item;

	/* CORIOLIS: 3/18/00 */
	int	x;
	int	y;
	int	w;
	int	cursorx;
	int	cursory;
	int	column;
	int	index;
	int msec;
	/* END CORIOLIS */

	item = Menu_ItemAtCursor( &s_demos.menu );
	/* CORIOLIS 1/29/00 */
	switch (key) {
	case K_ENTER:
		if (item == (menucommon_s*)&s_demos.list) {
			Demos_ActivateItem();
			return menu_null_sound;
		}
		break;

	case K_ESCAPE:
		if (!Q_stricmp( basedir, "demos" )) break;
		s_demos.list.curvalue = 0;
		Demos_ActivateItem();
		return menu_out_sound;

	case K_BACKSPACE:
		if (!Q_stricmp( basedir, "demos" )) return menu_buzz_sound;
		s_demos.list.curvalue = 0;
		Demos_ActivateItem();
		return menu_out_sound;

		/* CORIOLIS 3/18/00 */
		// most of this code is copied from lines 913-943 of ui_qmenu.c
	case K_MOUSE1:
		if (item == (menucommon_s*)&s_demos.list) {
			// check for a double-click
			if (s_demos.list.generic.flags & QMF_HASMOUSEFOCUS)
			{
				// check scroll region
				x = s_demos.list.generic.x;
				y = s_demos.list.generic.y;
				w = ( (s_demos.list.width + s_demos.list.seperation) * s_demos.list.columns - s_demos.list.seperation) * SMALLCHAR_WIDTH;
				if( s_demos.list.generic.flags & QMF_CENTER_JUSTIFY ) {
					x -= w / 2;
				}
				if (UI_CursorInRect( x, y, w, s_demos.list.height*SMALLCHAR_HEIGHT ))
				{
					cursorx = (uis.cursorx - x)/SMALLCHAR_WIDTH;
					column = cursorx / (s_demos.list.width + s_demos.list.seperation);
					cursory = (uis.cursory - y)/SMALLCHAR_HEIGHT;
					index = column * s_demos.list.height + cursory;
					if (s_demos.list.top + index < s_demos.list.numitems)
					{
						s_demos.list.oldvalue = s_demos.list.curvalue;
						s_demos.list.curvalue = s_demos.list.top + index;

						msec = trap_Milliseconds();

						if (s_demos.list.oldvalue != s_demos.list.curvalue && s_demos.list.generic.callback)
						{
							s_demos.list.generic.callback( &s_demos.list, QM_GOTFOCUS );
							ms_click = msec;			// added this to track double-click delay
							return (menu_move_sound);
						}
						else
						{
							// added the else statement to catch double-clicks
							trap_Cvar_Update( &ui_dblclick );
							if (msec-ms_click <= ui_dblclick.integer) Demos_ActivateItem();
							else ms_click = msec;
						}
					}
				}

				// absorbed, silent sound effect
				return (menu_null_sound);
			}
		}
		break;
		/* END CORIOLIS */
	}
	/* END CORIOLIS */

	return Menu_DefaultKey( &s_demos.menu, key );
}

/* CORIOLIS 1/29/00 */

/*
===============
Demos_BuildList
===============
*/
static int Demos_BuildList( char* names, int bufsize ) {
	int i, j, len, numdirs, numdemos, numitems;
	char dirs[NAMEBUFSIZE], demos[NAMEBUFSIZE], demoname[NAMEBUFSIZE];
	char *name, *checkname;

	// get a list of all demos and directories
	numdirs = trap_FS_GetFileList( basedir, "/", dirs, sizeof(dirs) );
	numdemos = trap_FS_GetFileList( basedir, "dm3", demos, sizeof(demos) );
	numitems = 0;
	maxlen = 0;

	// add the directories to the list
	name = dirs;
	j = 0;
	if (Q_stricmp( basedir, "Demos" )) {
		// all but the "demos" directory has a ".." directory
		Q_strncpyz( &names[j], "/..", bufsize-j );
		j += strlen( &names[j] ) + 1;
		numitems++;
	}

	for (i = 0; i < numdirs && j < bufsize; i++) {
		// skip any empty, ".", or ".." directories
		if (name[0]=='\0' || name[0]=='.')
		{
			name += strlen( name ) + 1;
			continue;
		}
		// skip any duplicate directory names
		checkname = dirs;
		len = strlen( name );
		if (name[len-1]=='/') name[len-1] = '\0';
		while (checkname < name && Q_stricmp(checkname,name)) checkname += strlen( checkname ) + 1;
		if (checkname != name) {
			name += len + 1;		// fixed bug: 2/1/00
			continue;
		}

		// add the new, unique directory
		names[j++] = '/';
		Q_strncpyz( &names[j], name, bufsize-j );
		name += len + 1;
		len = strlen( &names[j] ) + 1;	// +1 for the '/' character (and the '\0' character)
		if (len > maxlen) maxlen = len;
		j += len;
		numitems++;
	}

	// add the demos to the list
	name = demos;
	for (i = 0; i < numdemos && j < bufsize; i++) {
		if (strstr(name,"/")) continue;

		COM_StripExtension( name, demoname );
		Q_strncpyz( &names[j], demoname, bufsize-j );

		len = strlen( &names[j] );
		if (len > maxlen) maxlen = len;
		j += len + 1;
		name += strlen( name ) + 1;
		numitems++;
	}

	return numitems;
}

/*
===============
Demos_SortCompare
===============
*/
static int QDECL Demos_SortCompare( const void* arg1, const void* arg2 ) {
	const char** str1 = (const char**)arg1;
	const char** str2 = (const char**)arg2;

	// ensure that directories come before files, and that the .. directory is first
	if (**str1 == '/') {
		if (**str2 != '/' || !Q_stricmp( *str1, "/.." )) return -1;
		if (!Q_stricmp( *str2, "/.." )) return +1;
	}
	else if (**str2 == '/') return +1;

	return Q_stricmp( *str1, *str2 );
}

/* END CORIOLIS */

/*
===============
Demos_MenuInit
===============
*/
static void Demos_MenuInit( void ) {
	int		i;
/* CORIOLIS 1/30/00 - removed the references to this variable
	int		len;
END CORIOLIS */
	char	*demoname;

	memset( &s_demos, 0 ,sizeof(demos_t) );
	s_demos.menu.key = UI_DemosMenu_Key;

	Demos_Cache();

	s_demos.menu.fullscreen = qtrue;
	s_demos.menu.wrapAround = qtrue;

	s_demos.banner.generic.type		= MTYPE_BTEXT;
	s_demos.banner.generic.x		= 320;
	s_demos.banner.generic.y		= 16;
	s_demos.banner.string			= "DEMOS";
	s_demos.banner.color			= color_white;
	s_demos.banner.style			= UI_CENTER;

	s_demos.framel.generic.type		= MTYPE_BITMAP;
	s_demos.framel.generic.name		= ART_FRAMEL;
	s_demos.framel.generic.flags	= QMF_INACTIVE;
	s_demos.framel.generic.x		= 0;  
	s_demos.framel.generic.y		= 78;
	s_demos.framel.width			= 256;
	s_demos.framel.height			= 329;

	s_demos.framer.generic.type		= MTYPE_BITMAP;
	s_demos.framer.generic.name		= ART_FRAMER;
	s_demos.framer.generic.flags	= QMF_INACTIVE;
	s_demos.framer.generic.x		= 376;
	s_demos.framer.generic.y		= 76;
	s_demos.framer.width			= 256;
	s_demos.framer.height			= 334;

	s_demos.arrows.generic.type		= MTYPE_BITMAP;
	s_demos.arrows.generic.name		= ART_ARROWS;
	s_demos.arrows.generic.flags	= QMF_INACTIVE;
	s_demos.arrows.generic.x		= 320-ARROWS_WIDTH/2;
	s_demos.arrows.generic.y		= 400;
	s_demos.arrows.width			= ARROWS_WIDTH;
	s_demos.arrows.height			= ARROWS_HEIGHT;

	s_demos.left.generic.type		= MTYPE_BITMAP;
	s_demos.left.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS|QMF_MOUSEONLY;
	s_demos.left.generic.x			= 320-ARROWS_WIDTH/2;
	s_demos.left.generic.y			= 400;
	s_demos.left.generic.id			= ID_LEFT;
	s_demos.left.generic.callback	= Demos_MenuEvent;
	s_demos.left.width				= ARROWS_WIDTH/2;
	s_demos.left.height				= ARROWS_HEIGHT;
	s_demos.left.focuspic			= ART_ARROWLEFT;

	s_demos.right.generic.type		= MTYPE_BITMAP;
	s_demos.right.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS|QMF_MOUSEONLY;
	s_demos.right.generic.x			= 320;
	s_demos.right.generic.y			= 400;
	s_demos.right.generic.id		= ID_RIGHT;
	s_demos.right.generic.callback	= Demos_MenuEvent;
	s_demos.right.width				= ARROWS_WIDTH/2;
	s_demos.right.height			= ARROWS_HEIGHT;
	s_demos.right.focuspic			= ART_ARROWRIGHT;

	s_demos.back.generic.type		= MTYPE_BITMAP;
	s_demos.back.generic.name		= ART_BACK0;
	s_demos.back.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_demos.back.generic.id			= ID_BACK;
	s_demos.back.generic.callback	= Demos_MenuEvent;
	s_demos.back.generic.x			= 0;
	s_demos.back.generic.y			= 480-64;
	s_demos.back.width				= 128;
	s_demos.back.height				= 64;
	s_demos.back.focuspic			= ART_BACK1;

	s_demos.go.generic.type			= MTYPE_BITMAP;
	s_demos.go.generic.name			= ART_GO0;
	s_demos.go.generic.flags		= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_demos.go.generic.id			= ID_GO;
	s_demos.go.generic.callback		= Demos_MenuEvent;
	s_demos.go.generic.x			= 640;
	s_demos.go.generic.y			= 480-64;
	s_demos.go.width				= 128;
	s_demos.go.height				= 64;
	s_demos.go.focuspic				= ART_GO1;

	s_demos.list.generic.type		= MTYPE_SCROLLLIST;
	s_demos.list.generic.flags		= QMF_PULSEIFFOCUS;
	s_demos.list.generic.callback	= Demos_MenuEvent;
	s_demos.list.generic.id			= ID_LIST;
	s_demos.list.generic.x			= 118;
	s_demos.list.generic.y			= 130;

/* CORIOLIS 1/29/00
	s_demos.list.width				= 16;
	s_demos.list.height				= 14;
	s_demos.list.numitems			= trap_FS_GetFileList( "demos", "dm3", s_demos.names, NAMEBUFSIZE );
	s_demos.list.itemnames			= (const char **)s_demos.demolist;
	s_demos.list.columns			= 3;
END CORIOLIS */
	/* CORIOLIS 1/29/00 */
	s_demos.list.height				= 14;
	s_demos.list.numitems			= Demos_BuildList( s_demos.names, NAMEBUFSIZE );
	s_demos.list.itemnames			= (const char **)s_demos.demolist;
	if (maxlen <= 0) {
		s_demos.list.columns        = 3;
		s_demos.list.width          = 16;
	}
	else if (maxlen >= 51) {
		s_demos.list.columns        = 1;
		s_demos.list.width          = 51;
	}
	else {
		s_demos.list.columns        = 54 / (maxlen+4);
		s_demos.list.width			= 54 / s_demos.list.columns - 3;
	}
	/* END CORIOLIS */

	if (!s_demos.list.numitems) {
		strcpy( s_demos.names, "No Demos Found." );
		s_demos.list.numitems = 1;

		//degenerate case, not selectable
		s_demos.go.generic.flags |= (QMF_INACTIVE|QMF_HIDDEN);
	}
	else if (s_demos.list.numitems > MAX_DEMOS)
		s_demos.list.numitems = MAX_DEMOS;

	demoname = s_demos.names;
	for ( i = 0; i < s_demos.list.numitems; i++ ) {
		s_demos.list.itemnames[i] = demoname;

/* CORIOLIS 1/30/00 -- already done in Demos_BuildList

		// strip extension
		len = strlen( demoname );
		if (!Q_stricmp(demoname +  len - 4,".dm3"))
			demoname[len-4] = '\0';

		Q_strupr(demoname);

		demoname += len + 1;

END CORIOLIS */
		/* CORIOLIS 1/30/00 - replaces the above code */
		Q_strupr(demoname);
		demoname += strlen( demoname ) + 1;
		/* END CORIOLIS */
	}

	/* CORIOLIS 1/30/00 */
	// sort the list alphabetically
	qsort ((void*)s_demos.list.itemnames, s_demos.list.numitems, sizeof(*s_demos.list.itemnames), Demos_SortCompare);
	/* END CORIOLIS */

	/* CORIOLIS 3/18/00 */
	trap_Cvar_Register( &ui_dblclick, "ui_DoubleClickTime", "300", CVAR_ARCHIVE );
	ms_click = trap_Milliseconds() - ui_dblclick.integer;
	/* END CORIOLIS */

	Menu_AddItem( &s_demos.menu, &s_demos.banner );
	Menu_AddItem( &s_demos.menu, &s_demos.framel );
	Menu_AddItem( &s_demos.menu, &s_demos.framer );
	Menu_AddItem( &s_demos.menu, &s_demos.list );
	Menu_AddItem( &s_demos.menu, &s_demos.arrows );
	Menu_AddItem( &s_demos.menu, &s_demos.left );
	Menu_AddItem( &s_demos.menu, &s_demos.right );
	Menu_AddItem( &s_demos.menu, &s_demos.back );
	Menu_AddItem( &s_demos.menu, &s_demos.go );
}

/*
=================
Demos_Cache
=================
*/
void Demos_Cache( void ) {
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
	trap_R_RegisterShaderNoMip( ART_GO0 );
	trap_R_RegisterShaderNoMip( ART_GO1 );
	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
	trap_R_RegisterShaderNoMip( ART_ARROWS );
	trap_R_RegisterShaderNoMip( ART_ARROWLEFT );
	trap_R_RegisterShaderNoMip( ART_ARROWRIGHT );
}

/* CORIOLIS - doing the following funkiness allows me to not change the .h */

/*
===============
UI_DemosMenuInternal
===============
*/
static void UI_DemosMenuInternal( const char* rootdir, const char* subdir ) {
	int j;

	Q_strncpyz( basedir, rootdir, sizeof(basedir) );
	if (!Q_stricmp(subdir,"/..")) {
		j = strlen( basedir );
		do {
			--j;
		} while (j >= 0 && basedir[j] != '/');
		if (j >= 0)
			basedir[j] = '\0';
	}
	else {
		strcat( basedir,subdir );
	}

	Demos_MenuInit();
	UI_PushMenu( &s_demos.menu );
}

/*
===============
UI_DemosMenu
===============
*/
void UI_DemosMenu( void ) {
	UI_DemosMenuInternal ( "Demos", "" );
}

/* END CORIOLIS */
