// Copyright (C) 1999-2000 Id Software, Inc.
//
// cg_scoreboard -- draw the scoreboard on top of the game screen
#include "cg_local.h"


#define	SCOREBOARD_X		(16)

#define SB_HEADER			86
#define SB_TOP				(SB_HEADER+32)

// Where the status bar starts, so we don't overwrite it
#define SB_STATUSBAR		420

#define SB_NORMAL_HEIGHT	40
#define SB_INTER_HEIGHT		16 // interleaved height

#define SB_MAXCLIENTS_NORMAL  ((SB_STATUSBAR - SB_TOP) / SB_NORMAL_HEIGHT)
#define SB_MAXCLIENTS_INTER   ((SB_STATUSBAR - SB_TOP) / SB_INTER_HEIGHT - 1)

// Used when interleaved



#define SB_LEFT_BOTICON_X	(SCOREBOARD_X+0)
#define SB_LEFT_HEAD_X		(SCOREBOARD_X+32)
#define SB_RIGHT_BOTICON_X	(SCOREBOARD_X+64)
#define SB_RIGHT_HEAD_X		(SCOREBOARD_X+96)
// Normal
#define SB_BOTICON_X		(SCOREBOARD_X+32)
#define SB_HEAD_X			(SCOREBOARD_X+64)

#define SB_SCORELINE_X		128

#define SB_SCORE_X			(SB_SCORELINE_X + BIGCHAR_WIDTH) // width 6
#define SB_PING_X			(SB_SCORELINE_X + 6 * BIGCHAR_WIDTH + 8) // width 5
#define SB_TIME_X			(SB_SCORELINE_X + 11 * BIGCHAR_WIDTH + 8) // width 5
#define SB_NAME_X			(SB_SCORELINE_X + 16 * BIGCHAR_WIDTH) // width 15

// The new and improved score board
//
// In cases where the number of clients is high, the score board heads are interleaved
// here's the layout

//
//	0   32   80  112  144   240  320  400   <-- pixel position
//  bot head bot head score ping time name
//  
//  wins/losses are drawn on bot icon now

static qboolean localClient; // true if local client has been displayed


/*
=================
CG_DrawScoreboard
=================
*/
#define NETWORK_STRING_LIMIT 8
#define SCORE_STRING_LIMIT 7
#define YELLOW_PING 200
#define RED_PING 400
#define YELLOW_PL 50
#define RED_PL 75
#define MARGIN_WIDTH 8
static void CG_DrawClientScore( int y, score_t *score, float *color, float fade, qboolean largeFormat ) {
        char    string[1024];
// q3app
        int     len;
        float   fadeColor[4];
        int     textx, old_textx;
// --
	vec3_t	headAngles;
	clientInfo_t	*ci;
	int iconx, headx;

// q3app (added skincolor)
        vec4_t          skincolor;

	if ( score->client < 0 || score->client >= cgs.maxclients ) {
		Com_Printf( "Bad score->client: %i\n", score->client );
		return;
	}
	
	ci = &cgs.clientinfo[score->client];

	iconx = SB_BOTICON_X;
// q3app
        headx = cgv.cg_scoreboard.id & CG_SB_ID_NOINFO ? SB_HEAD_X - BIGCHAR_WIDTH*4 : SB_HEAD_X;

// q3app (draw the skin colors)
        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NOCOLORS ) ) {
                int     width, start;

                width = cgv.cg_scoreboard.id & CG_SB_ID_NOHEAD ? BIGCHAR_WIDTH*2 : BIGCHAR_WIDTH*4;
                start = cgv.cg_scoreboard.id & CG_SB_ID_NOINFO ? BIGCHAR_WIDTH : BIGCHAR_WIDTH*5;

                skincolor[0] = ci->topColor[0];
                skincolor[1] = ci->topColor[1];
                skincolor[2] = ci->topColor[2];
                skincolor[3] = 0.66;
                CG_FillRect( start, y+1, width, 7, skincolor );
                skincolor[0] = ci->lowerColor[0];
                skincolor[1] = ci->lowerColor[1];
                skincolor[2] = ci->lowerColor[2];
                CG_FillRect( start, y + 8, width, 8, skincolor );
        }
// --
// q3app (draw skill/handicap/flag/tournament wins/losses stuff)
        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NOINFO ) ) {
                // draw the handicap or bot skill marker (unless player has flag)
                if ( ci->powerups & ( 1 << PW_REDFLAG ) ) {
                        if( largeFormat ) {
                                CG_DrawFlagModel( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, TEAM_RED );
                        }
                        else {
                                CG_DrawFlagModel( iconx, y, 16, 16, TEAM_RED );
                        }
                } else if ( ci->powerups & ( 1 << PW_BLUEFLAG ) ) {
                        if( largeFormat ) {
                                CG_DrawFlagModel( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, TEAM_BLUE );
                        }
                        else {
                                CG_DrawFlagModel( iconx, y, 16, 16, TEAM_BLUE );
                        }
                } else {
                        if ( ci->botSkill > 0 && ci->botSkill <= 5 ) {
                                if ( cgv.cg_draw.icons ) {
                                        if( largeFormat ) {
                                                CG_DrawPic( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, cgs.media.botSkillShaders[ ci->botSkill - 1 ] );
                                        }
                                        else {
                                                CG_DrawPic( iconx, y, 16, 16, cgs.media.botSkillShaders[ ci->botSkill - 1 ] );
                                        }
                                }
                        } else if ( ci->handicap < 100 ) {
                                Com_sprintf( string, sizeof( string ), "%i", ci->handicap );
                                if ( cgs.gametype == GT_TOURNAMENT )
                                        CG_DrawSmallStringColor( iconx, y - SMALLCHAR_HEIGHT/2, string, color );
                                else
                                        CG_DrawSmallStringColor( iconx, y, string, color );
                        }
        
                        // draw the wins / losses
                        if ( cgs.gametype == GT_TOURNAMENT ) {
                                Com_sprintf( string, sizeof( string ), "%i/%i", ci->wins, ci->losses );
                                if( ci->handicap < 100 && !ci->botSkill ) {
                                        CG_DrawSmallStringColor( iconx, y + SMALLCHAR_HEIGHT/2, string, color );
                                }
                                else {
                                        CG_DrawSmallStringColor( iconx, y, string, color );
                                }
                        }
                }
        }
// --
	// draw the face
	VectorClear( headAngles );
	headAngles[YAW] = 180;
// q3app (draw head)
        if ( !(cgv.cg_scoreboard.id & CG_SB_ID_NOHEAD) ) {
                if( largeFormat ) {
                        CG_DrawHead( headx, y - ( ICON_SIZE - BIGCHAR_HEIGHT ) / 2, ICON_SIZE, ICON_SIZE, 
                                score->client, headAngles );
                }
                else {
                        CG_DrawHead( headx, y, 16, 16, score->client, headAngles );
                }
        }
// --
	// draw the score line

// q3app
/*
        network[0] = 0;

        if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_VARIANCE )
                strcat( network, va( "%s%03i^7/%s%03i^7/%s%03i ",
                score->minPing > RED_PING ? S_COLOR_RED : score->minPing > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->minPing,
                score->ping > RED_PING ? S_COLOR_RED : score->ping > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->ping,
                score->maxPing > RED_PING ? S_COLOR_RED : score->maxPing > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->maxPing
                ) );
        else if ( !( cgv.cg_scoreboard.network & CG_SB_NETWORK_NOPING ) )
                strcat( network, va( "%s%4i ",
                score->ping > RED_PING ? S_COLOR_RED : score->ping > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->ping
                ) );

        if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_PL )
                strcat( network, va( "%s%2i ",
                score->packetLoss > RED_PL ? S_COLOR_RED : score->packetLoss > YELLOW_PL ? S_COLOR_YELLOW : S_COLOR_GREEN, score->packetLoss
                ) );

//        if ( network[ strlen( network ) ] == ' ' ) // don't allow a space at the end
//                network[ strlen( network ) ] = '0'; 

        scores[0] = 0;

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS )
                strcat( scores, va( "^3%2i^5%2i^1%2i^7 ", score->excellent, score->impressive, score->gauntlet ) );

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY )
                strcat( scores, va( "%3i%% ", score->accuracy ) );

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_EFFICIENCY )
                strcat( scores, va( "%2.1f% ", score->time ? score->score / score->time : 0 ) );

        frags[0] = 0;

        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) )
                strcat( frags, va( "%4i%s", score->score, ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS ) ? "/" : "" ) );

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS )
                strcat( frags, va( "%i%s ", score->deaths, score->deaths > 999 ? "" : score->deaths > 99 ? " " : score->deaths > 9 ? "  " : "   " ) );
        else
                strcat( frags, " " );

//        if ( scores[ strlen( scores ) ] == ' ' ) // don't allow a space at the end
//                network[ strlen( scores ) ] = '0';

        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NONAME ) )
                if ( ci->clan[0] && !( cgv.cg_scoreboard.id & CG_SB_ID_NOCLAN ) )
                        Com_sprintf(id, sizeof( id ), "%s^7[%s^7]", ci->name, ci->clan );
                else
                        Com_sprintf(id, sizeof( id ), "%s", ci->name );
        else
                id[0] = 0;
*/
// --

/* q3app
	if ( score->ping == -1 ) {
                Com_sprintf(string, sizeof(string),
                        " connecting    %s", ci->name);
	} else if ( ci->team == TEAM_SPECTATOR ) {
                Com_sprintf(string, sizeof(string),
                        " SPECT %3i %4i %s", score->ping, score->time, ci->name);
	} else {
                Com_sprintf(string, sizeof(string),
                        "%5i %4i %4i %s", score->score, score->ping, score->time, ci->name);
	}
*/

// q3app (if no head, no skill and nocolors, start text closer to the left )

        textx = 144;
        if ( cgv.cg_scoreboard.id & CG_SB_ID_NOINFO )
                textx -= BIGCHAR_WIDTH*4;

        if ( cgv.cg_scoreboard.id & CG_SB_ID_NOHEAD ) {
                textx -= BIGCHAR_WIDTH*2;
                if ( cgv.cg_scoreboard.id & CG_SB_ID_NOCOLORS )
                        textx -= BIGCHAR_WIDTH*2;
        }

	// highlight your position
	if ( score->client == cg.snap->ps.clientNum ) {
		float	hcolor[4];
		int		rank;

		localClient = qtrue;

		if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR 
			|| cgs.gametype >= GT_TEAM ) {
			rank = -1;
		} else {
			rank = cg.snap->ps.persistant[PERS_RANK] & ~RANK_TIED_FLAG;
		}
		if ( rank == 0 ) {
			hcolor[0] = 0;
			hcolor[1] = 0;
			hcolor[2] = 0.7;
		} else if ( rank == 1 ) {
			hcolor[0] = 0.7;
			hcolor[1] = 0;
			hcolor[2] = 0;
		} else if ( rank == 2 ) {
			hcolor[0] = 0.7;
			hcolor[1] = 0.7;
			hcolor[2] = 0;
		} else {
			hcolor[0] = 0.7;
			hcolor[1] = 0.7;
			hcolor[2] = 0.7;
		}

		hcolor[3] = fade * 0.7;
// q3app
                CG_FillRect( textx, y,
                        640 - textx - BIGCHAR_WIDTH, BIGCHAR_HEIGHT+1, hcolor );
// --
	}

// q3app
//        CG_DrawBigString( SB_SCORELINE_X, y, string, fade );

        fadeColor[0] = fadeColor[1] = fadeColor[2] = 1.0;
        fadeColor[3] = fade;

        string[0] = 0; len = 0;
        old_textx = textx;

        if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_VARIANCE ) {
                strcat( string, va( "%s%-3i^7/%s%-3i^7/%s%-3i",
                score->minPing > RED_PING ? S_COLOR_RED : score->minPing > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->minPing,
                score->ping > RED_PING ? S_COLOR_RED : score->ping > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->ping,
                score->maxPing > RED_PING ? S_COLOR_RED : score->maxPing > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->maxPing
                ) );
                len = 11;
        } else if ( !( cgv.cg_scoreboard.network & CG_SB_NETWORK_NOPING ) ) {
                strcat( string, va( "%s%3i",
                score->ping > RED_PING ? S_COLOR_RED : score->ping > YELLOW_PING ? S_COLOR_YELLOW : S_COLOR_GREEN, score->ping
                ) );
                len += 3;
        }
        if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_PL ) {
                if ( string[0] ) {
                        strcat( string, " ");
                        len++;
                }

                strcat( string, va("%s%2i", score->packetLoss > RED_PL ? S_COLOR_RED : score->packetLoss > YELLOW_PL ? S_COLOR_YELLOW : S_COLOR_GREEN, score->packetLoss ) );
                len += 2;
        }

        if ( len > NETWORK_STRING_LIMIT ) { // small chars
                if ( score->ping != -1 )
                        CG_DrawStringExt( textx, y, string, fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                textx += len * SMALLCHAR_WIDTH + MARGIN_WIDTH;
        } else if ( len ) {
                if ( score->ping != -1 )
                        CG_DrawBigString( textx, y, string, fade );
                textx += len * BIGCHAR_WIDTH + MARGIN_WIDTH;
        }

        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOTIME ) ) {
                if ( score->ping != -1 ) {
                        int time;

                        time = ( cg.time - ci->enterTime ) / 60000;
                        if ( time > 999 )
                                CG_DrawStringExt( textx, y, va( "%6i", time ), fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                        else
                                CG_DrawBigString( textx, y, va("%3i", time ), fade );
                }

                textx += 3 * BIGCHAR_WIDTH + MARGIN_WIDTH;
        }

        if ( ci->team == TEAM_SPECTATOR ) 
                old_textx = textx;

        string[0] = 0; len = 0;

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS ) {
                strcat( string, va( "^3%2i^5%2i^1%2i^7", score->excellent, score->impressive, score->gauntlet ) );
                len = 6;
        }

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY ) {
                if ( string[0] ) {
                        strcat( string, " ");
                        len++;
                }

                strcat( string, va( "%02i%%", score->accuracy > 99 ? 99 : score->accuracy ) );
                len += 3;
        }

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_EFFICIENCY ) {
                int     eff;

                if ( string[0] ) {
                        strcat( string, " ");
                        len++;
                }

                eff = ( cg.time - ci->enterTime ) > 1000 ? ( score->score * 3600 ) / ( ( cg.time - ci->enterTime ) / 1000 ) : 0;
                eff = eff > 9999 ? 9999 : eff;
                strcat( string, va( "%4i", eff ) );
                len += 4;
        }

        if ( len > SCORE_STRING_LIMIT ) { // small chars
                if ( score->ping != -1 && ci->team != TEAM_SPECTATOR )
                        CG_DrawStringExt( textx, y, string, fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                textx += len * SMALLCHAR_WIDTH + MARGIN_WIDTH;
        } else if ( len ) {
                if ( score->ping != -1 && ci->team != TEAM_SPECTATOR )
                        CG_DrawBigString( textx, y, string, fade );
                textx += len * BIGCHAR_WIDTH + MARGIN_WIDTH;
        }

        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) ) {

                if ( score->ping != -1 && ci->team != TEAM_SPECTATOR ) {
                        if ( score->score > 999 )
                                CG_DrawStringExt( textx, y, va( "%6i", score->score ), fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                        else
                                CG_DrawBigString( textx, y, va( "%3i", score->score ), fade );
                }

                textx += 3 * BIGCHAR_WIDTH;

                if ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS ) {
                        if ( score->ping != -1 && ci->team != TEAM_SPECTATOR )
                                CG_DrawStringExt( textx, y, "/", fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );

                        textx += SMALLCHAR_WIDTH;
                } else
                        textx += MARGIN_WIDTH;
        }

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS ) {

                if ( score->ping != -1 && ci->team != TEAM_SPECTATOR ) {
                        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) ) {
                                CG_DrawStringExt( textx, y, va( "%i", score->deaths ), fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                                textx += 3 * SMALLCHAR_WIDTH + MARGIN_WIDTH;
                        } else {
                                if ( score->deaths > 999 )
                                        CG_DrawStringExt( textx, y, va( "%6i", score->deaths ), fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
                                else
                                        CG_DrawBigString( textx, y, va( "%3i", score->deaths ), fade );
                                textx += 3 * BIGCHAR_WIDTH + MARGIN_WIDTH;
                        }
                }
        }

        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NONAME ) )
                if ( ci->clan[0] && !( cgv.cg_scoreboard.id & CG_SB_ID_NOCLAN ) )
                        Com_sprintf( string, sizeof( string ), "%s^7\16%s^7", ci->name, ci->clan );
                else
                        Com_sprintf( string, sizeof( string ), "%s", ci->name );
        else
                string[0] = 0;

        len = ( 626 - textx ) / BIGCHAR_WIDTH; // 626 = 640 - BIGCHAR_WIDTH
        if ( Q_PrintStrlen( string ) > len ) {
                len = ( 626 - textx ) / SMALLCHAR_WIDTH; // 626 = 640 - BIGCHAR_WIDTH

                while ( Q_PrintStrlen( string ) > len && len > 0 ) // crop the string
                        string[ strlen(string) - 1 ] = 0;
                if ( len > 0 )
                        CG_DrawStringExt( textx, y, string, fadeColor, qfalse, qtrue, SMALLCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
        } else if ( len > 0 )
                CG_DrawBigString( textx, y, string, fade );

        if ( score->ping == -1 ) {
                strcpy( string, "connecting ..." );
                len = ( textx - old_textx ) / BIGCHAR_WIDTH;
                if ( len < strlen( string ) )
                        string[len] = 0;
                CG_DrawBigString( old_textx, y, string, fade );
        } else if ( ci->team == TEAM_SPECTATOR ) {
                strcpy( string, "SPECTATOR" );
                len = ( textx - old_textx ) / BIGCHAR_WIDTH;
                if ( len < strlen( string ) )
                        string[len] = 0;
                CG_DrawBigString( old_textx, y, string, fade );
        }

// --
	// add the "ready" marker for intermission exiting
	if ( cg.snap->ps.stats[ STAT_CLIENTS_READY ] & ( 1 << score->client ) ) {
// q3app (proportional font for "ready")
//                CG_DrawBigStringColor( iconx, y, "READY", color );
                UI_DrawProportionalString( 16, y, "READY", UI_SMALLFONT|UI_DROPSHADOW, colorYellow );
// --
	}
}

/*
=================
CG_TeamScoreboard
=================
*/
static int CG_TeamScoreboard( int y, team_t team, float fade, int maxClients, int lineHeight ) {
	int		i;
	score_t	*score;
	float	color[4];
	int		count;
	clientInfo_t	*ci;

	color[0] = color[1] = color[2] = 1.0;
	color[3] = fade;

	count = 0;

	for ( i = 0 ; i < cg.numScores && count < maxClients ; i++ ) {
		score = &cg.scores[i];
		ci = &cgs.clientinfo[ score->client ];

		if ( team != ci->team ) {
			continue;
		}

		CG_DrawClientScore( y + lineHeight * count, score, color, fade, lineHeight == SB_NORMAL_HEIGHT );

		count++;
	}

	return count;
}

/* q3app
=================
CG_DrawScoreboardHeader

Draw the scoreboard header
=================
*/
void CG_DrawScoreboardHeader( void ) {
        int     x, y, y2, len, subx;

        x = 16;
        y = SB_HEADER;
        y2 = y + BIGCHAR_HEIGHT + 4;

        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NOINFO ) )
                x += BIGCHAR_WIDTH * 4;
        if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NOHEAD ) ) {
                x += BIGCHAR_WIDTH * 2;

                if ( !( cgv.cg_scoreboard.id & CG_SB_ID_NOCOLORS ) )
                        x += BIGCHAR_WIDTH * 2;
        }

        if ( !( cgv.cg_scoreboard.network & CG_SB_NETWORK_NOPING ) ||
        cgv.cg_scoreboard.network & CG_SB_NETWORK_VARIANCE ||
        cgv.cg_scoreboard.network & CG_SB_NETWORK_PL ) {

                UI_DrawProportionalString( x, y, "PING", UI_SMALLFONT|UI_THINFONT|UI_DROPSHADOW, colorRed );

                len = 0;

                if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_VARIANCE ) {
                        CG_DrawStringExt( x, y2, "MIN/CUR/MAX", colorRed, qfalse, qtrue, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );
                        len = 11;                        
                } else if ( !( cgv.cg_scoreboard.network & CG_SB_NETWORK_NOPING ) ) {
                        len = 3;
                }
                if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_PL ) {
// ugly code
                        if ( cgv.cg_scoreboard.network & CG_SB_NETWORK_VARIANCE )
                                subx = x + ( len + 1 ) * SMALLCHAR_WIDTH;
                        else if ( !( cgv.cg_scoreboard.network & CG_SB_NETWORK_NOPING ) )
                                subx = x + ( len + 1 ) * BIGCHAR_WIDTH;
                        CG_DrawStringExt( subx, y2, "PL", colorRed, qfalse, qtrue, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );
// --
                        len = len ? len + 3 : 2;
                }

                if ( len > NETWORK_STRING_LIMIT )
                        x += len * SMALLCHAR_WIDTH + MARGIN_WIDTH;
                else if ( len )
                        x += len * BIGCHAR_WIDTH + MARGIN_WIDTH;
        }

        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOTIME ) ) {
                UI_DrawProportionalString( x, y, "TIME", UI_SMALLFONT|UI_THINFONT|UI_DROPSHADOW, colorRed );
                x += 3 * BIGCHAR_WIDTH + MARGIN_WIDTH;
        }

        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS ||
                cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY ||
                cgv.cg_scoreboard.score & CG_SB_SCORE_EFFICIENCY ||
                !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) ||
                cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS ) {

                UI_DrawProportionalString( x, y, "SCORE", UI_SMALLFONT|UI_THINFONT|UI_DROPSHADOW, colorRed );                

                len = 0;

                if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS ) {
// ugly code
                        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY || cgv.cg_scoreboard.score & CG_SB_SCORE_EFFICIENCY )
                                subx = SMALLCHAR_WIDTH;
                        else
                                subx = BIGCHAR_WIDTH;

                        CG_DrawPic( x, y2, subx * 2, BIGCHAR_HEIGHT, cgs.media.medalExcellent );
                        CG_DrawPic( x + subx * 2, y2, subx*2, BIGCHAR_HEIGHT, cgs.media.medalImpressive );
                        CG_DrawPic( x + subx * 4, y2, subx*2, BIGCHAR_HEIGHT, cgs.media.medalGauntlet );
// --
                        len = 6;
                }
                if ( cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY ) {
// ugly code
                        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS )
                                CG_DrawPic( x + len * SMALLCHAR_WIDTH + MARGIN_WIDTH, y2, SMALLCHAR_WIDTH * 2, BIGCHAR_HEIGHT, cgs.media.medalAccuracy );
                        else
                                CG_DrawPic( x, y2, SMALLCHAR_WIDTH * 2, BIGCHAR_HEIGHT, cgs.media.medalAccuracy );
// --
                        len = len ? len + 4 : 3;
                }
                if ( cgv.cg_scoreboard.score & CG_SB_SCORE_EFFICIENCY ) {
// ugly code
                        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_AWARDS )
                                subx = x + len * SMALLCHAR_WIDTH + MARGIN_WIDTH;
                        else if ( cgv.cg_scoreboard.score & CG_SB_SCORE_ACCURACY )
                                subx = x + len * BIGCHAR_WIDTH + MARGIN_WIDTH;
                        else
                                subx = x;

                        CG_DrawPic( subx, y2, SMALLCHAR_WIDTH * 2, BIGCHAR_HEIGHT, cgs.media.medalFrags );
                        CG_DrawStringExt( subx + SMALLCHAR_WIDTH * 2, y2, "ph", colorRed, qfalse, qtrue, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );
// --
                        len = len ? len + 5 : 4;
                }
                if ( len > SCORE_STRING_LIMIT )
                        x += len * SMALLCHAR_WIDTH + MARGIN_WIDTH;
                else if ( len )
                        x += len * BIGCHAR_WIDTH + MARGIN_WIDTH;

                if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) ) {
                        x += 3 * BIGCHAR_WIDTH;
                        if ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS )
                                x += SMALLCHAR_WIDTH;
                        else
                                x += MARGIN_WIDTH;
                }

                if ( cgv.cg_scoreboard.score & CG_SB_SCORE_DEATHS ) {
                        CG_DrawStringExt( x, y2, "DEATHS", colorRed, qfalse, qtrue, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );

                        if ( !( cgv.cg_scoreboard.score & CG_SB_SCORE_NOFRAGS ) )
                                x += 3 * SMALLCHAR_WIDTH + MARGIN_WIDTH;
                        else
                                x += 3 * BIGCHAR_WIDTH + MARGIN_WIDTH;                        
                }
        }

        if ( !(cgv.cg_scoreboard.id & CG_SB_ID_NONAME) )
                UI_DrawProportionalString( x, y, "NAME", UI_SMALLFONT|UI_THINFONT|UI_DROPSHADOW, colorRed );

}

/*
=================
CG_DrawScoreboard

Draw the normal in-game scoreboard
=================
*/
qboolean CG_DrawScoreboard( void ) {
	int		x, y, w, i, n1, n2;
	float	fade;
	float	*fadeColor;
	char	*s;
	int maxClients;
	int lineHeight;
	int topBorderSize, bottomBorderSize;

	// don't draw amuthing if the menu or console is up
	if ( cg_paused.integer ) {
		cg.deferredPlayerLoading = 0;
		return qfalse;
	}

	if ( cgs.gametype == GT_SINGLE_PLAYER && cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
		cg.deferredPlayerLoading = 0;
		return qfalse;
	}

	// don't draw scoreboard during death while warmup up
	if ( cg.warmup && !cg.showScores ) {
		return qfalse;
	}

	if ( cg.showScores || cg.predictedPlayerState.pm_type == PM_DEAD ||
		 cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
		fade = 1.0;
		fadeColor = colorWhite;
	} else {
		fadeColor = CG_FadeColor( cg.scoreFadeTime, FADE_TIME );
		
		if ( !fadeColor ) {
			// next time scoreboard comes up, don't print killer
			cg.deferredPlayerLoading = 0;
			cg.killerName[0] = 0;
			return qfalse;
		}
		fade = *fadeColor;
	}


	// fragged by ... line
	if ( cg.killerName[0] ) {
		s = va("Fragged by %s", cg.killerName );
		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
		x = ( SCREEN_WIDTH - w ) / 2;
		y = 40;
		CG_DrawBigString( x, y, s, fade );
	}

	// current rank
	if ( cgs.gametype < GT_TEAM) {
		if (cg.snap->ps.persistant[PERS_TEAM] != TEAM_SPECTATOR ) {
			s = va("%s place with %i",
				CG_PlaceString( cg.snap->ps.persistant[PERS_RANK] + 1 ),
				cg.snap->ps.persistant[PERS_SCORE] );
			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
			x = ( SCREEN_WIDTH - w ) / 2;
			y = 60;
			CG_DrawBigString( x, y, s, fade );
		}
	} else {
		if ( cg.teamScores[0] == cg.teamScores[1] ) {
			s = va("Teams are tied at %i", cg.teamScores[0] );
		} else if ( cg.teamScores[0] >= cg.teamScores[1] ) {
			s = va("Red leads %i to %i",cg.teamScores[0], cg.teamScores[1] );
		} else {
			s = va("Blue leads %i to %i",cg.teamScores[1], cg.teamScores[0] );
		}

		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
		x = ( SCREEN_WIDTH - w ) / 2;
		y = 60;
		CG_DrawBigString( x, y, s, fade );
	}

	// scoreboard
	y = SB_HEADER;
// q3app

        CG_DrawScoreboardHeader();

//        UI_DrawProportionalString( SB_PING_X, y, "Time", UI_SMALLFONT|UI_DROPSHADOW, colorRed );
//        UI_DrawProportionalString( SB_TIME_X, y, "Score", UI_SMALLFONT|UI_DROPSHADOW, colorRed );
//        UI_DrawProportionalString( SB_NAME_X, y, "Name", UI_SMALLFONT|UI_DROPSHADOW, colorRed );

//        CG_DrawPic( SB_SCORE_X, y, 64, 32, cgs.media.scoreboardScore );
//        CG_DrawPic( SB_PING_X, y, 64, 32, cgs.media.scoreboardPing );
//        CG_DrawPic( SB_TIME_X, y, 64, 32, cgs.media.scoreboardTime );
//        CG_DrawPic( SB_NAME_X, y, 64, 32, cgs.media.scoreboardName );
// --

// q3app (added BIGCHAR_HEIGHT)
        y = SB_TOP + BIGCHAR_HEIGHT;

	// If there are more than SB_MAXCLIENTS_NORMAL, use the interleaved scores
	if ( cg.numScores > SB_MAXCLIENTS_NORMAL ) {
		maxClients = SB_MAXCLIENTS_INTER;
		lineHeight = SB_INTER_HEIGHT;
		topBorderSize = 8;
		bottomBorderSize = 16;
	} else {
		maxClients = SB_MAXCLIENTS_NORMAL;
		lineHeight = SB_NORMAL_HEIGHT;
		topBorderSize = 16;
		bottomBorderSize = 16;
	}

	localClient = qfalse;

	if ( cgs.gametype >= GT_TEAM ) {
		//
		// teamplay scoreboard
		//
		y += lineHeight/2;

		if ( cg.teamScores[0] >= cg.teamScores[1] ) {
			n1 = CG_TeamScoreboard( y, TEAM_RED, fade, maxClients, lineHeight );
			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n1 * lineHeight + bottomBorderSize, 0.33, TEAM_RED );
			y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
			maxClients -= n1;
			n2 = CG_TeamScoreboard( y, TEAM_BLUE, fade, maxClients, lineHeight );
			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n2 * lineHeight + bottomBorderSize, 0.33, TEAM_BLUE );
			y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
			maxClients -= n2;
		} else {
			n1 = CG_TeamScoreboard( y, TEAM_BLUE, fade, maxClients, lineHeight );
			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n1 * lineHeight + bottomBorderSize, 0.33, TEAM_BLUE );
			y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
			maxClients -= n1;
			n2 = CG_TeamScoreboard( y, TEAM_RED, fade, maxClients, lineHeight );
			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n2 * lineHeight + bottomBorderSize, 0.33, TEAM_RED );
			y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
			maxClients -= n2;
		}
		n1 = CG_TeamScoreboard( y, TEAM_SPECTATOR, fade, maxClients, lineHeight );
		y += (n1 * lineHeight) + BIGCHAR_HEIGHT;

	} else {
		//
		// free for all scoreboard
		//
		n1 = CG_TeamScoreboard( y, TEAM_FREE, fade, maxClients, lineHeight );
		y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
		n2 = CG_TeamScoreboard( y, TEAM_SPECTATOR, fade, maxClients - n1, lineHeight );
		y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
	}

	if (!localClient) {
		// draw local client at the bottom
		for ( i = 0 ; i < cg.numScores ; i++ ) {
			if ( cg.scores[i].client == cg.snap->ps.clientNum ) {
				CG_DrawClientScore( y, &cg.scores[i], fadeColor, fade, lineHeight == SB_NORMAL_HEIGHT );
				break;
			}
		}
	}

	// load any models that have been deferred
// q3app (Added "&& cg_deferPlayers.integer == 1")
        if ( ++cg.deferredPlayerLoading > 10 && cg_deferPlayers.integer == 1 ) {
		CG_LoadDeferredPlayers();
	}

	return qtrue;
}

//================================================================================

/*
================
CG_CenterGiantLine
================
*/
static void CG_CenterGiantLine( float y, const char *string ) {
	float		x;
	vec4_t		color;

	color[0] = 1;
	color[1] = 1;
	color[2] = 1;
	color[3] = 1;

	x = 0.5 * ( 640 - GIANT_WIDTH * CG_DrawStrlen( string ) );

	CG_DrawStringExt( x, y, string, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
}

/*
=================
CG_DrawTourneyScoreboard

Draw the oversize scoreboard for tournements
=================
*/
void CG_DrawTourneyScoreboard( void ) {
	const char		*s;
	vec4_t			color;
	int				min, tens, ones;
	clientInfo_t	*ci;
	int				y;
	int				i;

	// request more scores regularly
	if ( cg.scoresRequestTime + 2000 < cg.time ) {
		cg.scoresRequestTime = cg.time;
		trap_SendClientCommand( "score" );
	}

	color[0] = 1;
	color[1] = 1;
	color[2] = 1;
	color[3] = 1;

	// draw the dialog background
	color[0] = color[1] = color[2] = 0;
	color[3] = 1;
	CG_FillRect( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, color );

	// print the mesage of the day
	s = CG_ConfigString( CS_MOTD );
	if ( !s[0] ) {
		s = "Scoreboard";
	}

	// print optional title
	CG_CenterGiantLine( 8, s );

	// print server time
	ones = cg.time / 1000;
	min = ones / 60;
	ones %= 60;
	tens = ones / 10;
	ones %= 10;
	s = va("%i:%i%i", min, tens, ones );

	CG_CenterGiantLine( 64, s );


	// print the two scores

	y = 160;
	if ( cgs.gametype >= GT_TEAM ) {
		//
		// teamplay scoreboard
		//
		CG_DrawStringExt( 8, y, "Red Team", color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
		s = va("%i", cg.teamScores[0] );
		CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
		
		y += 64;

		CG_DrawStringExt( 8, y, "Blue Team", color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
		s = va("%i", cg.teamScores[1] );
		CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
	} else {
		//
		// free for all scoreboard
		//
		for ( i = 0 ; i < MAX_CLIENTS ; i++ ) {
			ci = &cgs.clientinfo[i];
			if ( !ci->infoValid ) {
				continue;
			}
			if ( ci->team != TEAM_FREE ) {
				continue;
			}

			CG_DrawStringExt( 8, y, ci->name, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
			s = va("%i", ci->score );
			CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
			y += 64;
		}
	}


}

