// Copyright (C) 1999-2000 Id Software, Inc.
//
// cg_main.c -- initialization and primary entry point for cgame
#include "cg_local.h"

void CG_Init( int serverMessageNum, int serverCommandSequence );
void CG_Shutdown( void );

// q3app
int     forceModificationCount;

/*
================
vmMain

This is the only way control passes into the module.
This must be the very first function compiled into the .q3vm file
================
*/
int vmMain( int command, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6 ) {
	switch ( command ) {
	case CG_INIT:
		CG_Init( arg0, arg1 );
		return 0;
	case CG_SHUTDOWN:
		CG_Shutdown();
		return 0;
	case CG_CONSOLE_COMMAND:
		return CG_ConsoleCommand();
	case CG_DRAW_ACTIVE_FRAME:
		CG_DrawActiveFrame( arg0, arg1, arg2 );
		return 0;
	case CG_CROSSHAIR_PLAYER:
		return CG_CrosshairPlayer();
	case CG_LAST_ATTACKER:
		return CG_LastAttacker();
	default:
		CG_Error( "vmMain: unknown command %i", command );
		break;
	}
	return -1;
}


cg_t				cg;
cgs_t				cgs;
// q3app
cgcvars_t                        cgv;
centity_t			cg_entities[MAX_GENTITIES];
weaponInfo_t		cg_weapons[MAX_WEAPONS];
itemInfo_t			cg_items[MAX_ITEMS];

// q3app (erased many cvars)
vmCvar_t        cg_blood;
vmCvar_t        cg_buildScript;
vmCvar_t        cg_deferPlayers;
vmCvar_t        cg_fastRespawn;
vmCvar_t	cg_footsteps;
vmCvar_t        cg_fov;
vmCvar_t	cg_paused;
vmCvar_t        cg_simpleItems;
vmCvar_t        cg_shadows;
vmCvar_t	cg_stereoSeparation;
vmCvar_t	cg_syncronousClients;
vmCvar_t	cg_teamOverlayUserinfo;
vmCvar_t        cg_viewsize;
// (colapsed cvars)
vmCvar_t        cg_3rdPerson;
vmCvar_t        cg_alpha;
vmCvar_t        cg_announcer;
vmCvar_t        cg_bob;
vmCvar_t        cg_color;
vmCvar_t        cg_debug;
vmCvar_t        cg_draw;
vmCvar_t        cg_force;
vmCvar_t        cg_fx;
vmCvar_t        cg_gun;
vmCvar_t        cg_noBeeps;
vmCvar_t        cg_predict;
vmCvar_t        cg_run;
vmCvar_t        cg_scoreboard;
vmCvar_t        cg_switch;
vmCvar_t        cg_team;
vmCvar_t        cg_tracer;
vmCvar_t        cg_xhair;
vmCvar_t        cg_zoom;
// --

typedef struct {
	vmCvar_t	*vmCvar;
	char		*cvarName;
	char		*defaultString;
	int			cvarFlags;
// q3app (add help variable)
        char            *cvarHelp;
} cvarTable_t;

cvarTable_t		cvarTable[] = {
// q3app (all cvars with CVAR_ROM had CVAR_NORESTART added)
        { &cg_blood, "com_blood", "1", CVAR_ARCHIVE, "" },
        { &cg_buildScript, "com_buildScript", "0", 0, "" }, // force loading of all possible data amd error on failures
        { &cg_deferPlayers, "cg_deferPlayers", "1", CVAR_ARCHIVE, "" },
        { &cg_fastRespawn, "cg_fastRespawn", "1", CVAR_ARCHIVE | CVAR_USERINFO, "cg_fastRespawn <value>\nEnables fast respawning.\n^2 0^7 wait at least 1.5 seconds before respawn\n^2 1^7 respawn when button is released then pressed\n^2 2^7 respawn ASAP" },
        { &cg_footsteps, "cg_footsteps", "1", CVAR_CHEAT, "" },
        { &cg_fov, "cg_fov", "90", CVAR_ARCHIVE, "" },
        { &cg_paused, "cl_paused", "0", CVAR_ROM | CVAR_NORESTART, "" },
        { &cg_simpleItems, "cg_simpleItems", "0", CVAR_ARCHIVE, "" },
        { &cg_shadows, "cg_shadows", "1", CVAR_ARCHIVE, ""  },
        { &cg_stereoSeparation, "cg_stereoSeparation", "0.4", CVAR_ARCHIVE, "" },
        { &cg_syncronousClients, "g_syncronousClients", "0", 0, "" },       // communicated by systeminfo
        { &cg_teamOverlayUserinfo, "teamoverlay", "0", CVAR_ROM | CVAR_NORESTART | CVAR_USERINFO, "" },
        { &cg_viewsize, "cg_viewsize", "100", CVAR_ARCHIVE, "" },

// (collapsed variables:)
        { &cg_3rdPerson,  "cg_3rdPerson",  "0 0", CVAR_CHEAT, "cg_3rdPerson <range> <angle>^7\nSets third person camera range and angle\n^51 range^7 how far camera is from player. Range 0 disables 3rd person view\n^52 angle^7 angle camera is relative to player" },
        { &cg_alpha,      "cg_alpha",      "0.33 1", CVAR_ARCHIVE, "cg_alpha <smoke> <blood>\nSets transparency of some game elements\n^51 smoke^7 rocket/grenade smoke trail and shotgun puffs\n^52 blood^7 blood trails from gibs" },
        { &cg_announcer,  "cg_announcer",  "0", CVAR_ARCHIVE, "cg_announcer <bitflags>\nDisables announcer voice\n^51 bitflags\n^2  1 leadtied ^7lead/tied announcements\n^2  2 countdown ^7timelimit and fraglimit countdowns\n^2  4 awards ^7awards\n^2  8 powerup ^7powerup pickup announcements\n^2 16 extra ^7other stuff like 'fight!', 'denied', etc." },
        { &cg_bob,        "cg_bob",        "0 0 0", CVAR_ARCHIVE, "cg_bob <up> <pitch> <roll>\nView bobbing parameters\n^51 up ^7bobbing upward scale\n^52 pitch ^7bobbing pitch scale\n^53 roll ^7bobbing roll scale" },
// q3app (remove)
//        { &cg_color,      "cg_color",      "4 13 13", CVAR_ARCHIVE | CVAR_USERINFO, "cg_color <fx> <tc> <lc>\nSets user's color preferences\n^51 fx ^7effects color\n^52 tc ^7shirt color\n^53 lc ^7pants color" },
        { &cg_color,      "cg_color",      "16 16", CVAR_ARCHIVE | CVAR_USERINFO, "cg_color <tc> <lc>\nSets user's color preferences\n^51 tc ^7shirt color\n^52 lc ^7pants color" },
        { &cg_debug,      "cg_debug",      "0 0.3", CVAR_CHEAT, "cg_debug <bitflags> <swingspeed>\nDebug cvars used by developers solely for testing\n^51 bitflags\n^2  1 anim^7 display player animation frame\n^2  2 event^7 display events\n^2  4 pos^7 for CG_ResetPlayerEntity\n^2  8 noplayeranims^7 set player animation frame to 0\n^2 16 showmiss^7 shows prediction errors\n^2 32 stats^7 shows clientframe number\n^2 64 animspeed^7 sets player animation frame to 0\n^52 swingspeed^7 speed player adjusts legs and torso to face head direction" },
        { &cg_draw,       "cg_draw",       "0 2 3", CVAR_ARCHIVE, "cg_draw <bitflags> <icons> <centertime>\nSets HUD-related preferences\n^51 bitflags\n^2    1 nothing ^7disables HUD\n^2    2 nostatus ^7disables status bar\n^2    4 noscores ^7disables score display on lower-right corner\n^2    8 noattacker^7 disables attacker display on upper-right corner\n^2   16 FPS^7 frames per second display\n^2   32 notimer^7 disables timer display\n^2   64 noammowarn^7 disables low/no ammo warning\n^2  128 nodamage^7 disables directional damage indicators\n^2  256 noreward^7 disables reward display\n^2  512 nolagometer^7 disables lagometer\n^2 1024 allammo^7 condensed ammo display\n^2 2048 snapshot^7 displays snapshot info\n^2 4096 nopickup^7 disables item pickup display\n^2 8192 memory^7 displays available memory\n"
"^52 icons^7 specifies how icons are displayed\n^2 0^7 no icons\n^2 1^7 2d icons\n^2 2^7 3d icons\n^2 3^7 3d icons also on pickup display\n^2 4^7 3d icons also on weapon display\n^53 centertime^7 how many seconds messages display centered on screen" },
        { &cg_force,      "cg_force",      "1", CVAR_ARCHIVE, "cg_force <bitflags>\nForce players to use same model or standard skins, model, sounds or strict team colors\n^51 bitflags\n^2  1 std_skin^7 all players use standard color-enabled skins\n^2  2 std_model^7 all players use standard model for body\n^2  4 std_sound^7 all players use standard male, female and neuter sounds\n^2  8 same_model^7 all players use same model and skin as yours\n^2 16 team_color^7 strict color policy for team games" },
        { &cg_fx,         "cg_fx",         "256 10000 9 5000 1250 400", CVAR_ARCHIVE, "cg_fx <marks> <marktime> <gibs> <gibtime> <brasstime> <railTime>\nSpecial effects and local entity related preferences\n^51 marks^7 max number of marks at one time. 0 disables marks\n^52 marktime^7 time (msecs) marks stay before fading out\n^53 gibs^7 how many gibs pop out of an exploding dead body, 9 is default, 18 is anatomically correct, > 20 is just extra blood\n^54 gibtime^7 time (msecs) that gibs stay\n^55 brasstime^7 time (msecs) brass stays\n^56 railtime^7 time (msecs) rail trails stay" },
        { &cg_gun,        "cg_gun",        "0 0 0 1 1", CVAR_ARCHIVE, "cg_gun <x> <y> <z> <pos> <flash>\nPreferences regarding the view weapon\n^51 x^7 nudge view weapon on the x axis\n^52 y^7 nudge view weapon on the y axis\n^53 z^7 nudge the view weapon on the z axis\n^54 pos^7 weapon display and position\n^2 0^7 no view weapon\n^2 1^7 view weapon on the right\n^2 2^7 centered view weapon\n^55 flash^7 muzzle flash size scale" },
        { &cg_noBeeps,    "cg_noBeeps",    "0", CVAR_ARCHIVE, "cg_noBeeps <bitflags>\nDisables audible damage, hit and other feedback beeps\n^51 bitflags\n^2  1 nopain^7 disables pain sound\n^2  2 nohit^7 disables hit sound\n^2  4 noteamhit^7 disables team hit sound\n^2  8 noteamwarn^7 disables team callsign sound\n^2 16 notimewarn^7 disables timer sound" },
        { &cg_predict,    "cg_predict",    "2 100", CVAR_ARCHIVE | CVAR_USERINFO, "cg_predict <prediction> <errordecay>\nSets client-side prediction options\n^51 prediction\n^2 0^7 no prediction\n^2 1^7 prediction\n^2 2^7 prediction + item pickup prediction\n^52 errordecay^7 prediction error correction 'smoothness' value" },
        { &cg_run,        "cg_run",        "0.005 0.002", CVAR_ARCHIVE, "cg_run <roll> <pitch>\nView bobbing when running parameters\n^51 roll^7 running roll scale\n^52 pitch^7 running pitch scale" },
        { &cg_scoreboard, "cg_scoreboard", "0 0 0 0 0", CVAR_ARCHIVE | CVAR_USERINFO, "cg_scoreboard <format> <id> <score> <network> <extra>\nScoreboard display settings\n^51 format\n^2 0^7 Normal\n^2 1^7 Single-spaced\n^2 2^7 Small\n^52 id^7 player identification info\n^2  1 noname^7 Disable name\n^2  2 noclan^7 Disable clan\n^2  4 nohead^7 Disable head icon\n^2  8 nocolors^7 Disable skin color\n^2 16 noinfo^7 Disable display of info like bot skill, handicap, etc.\n^53 score^7 player performance info\n^2  1 nofrags^7 Disable frags\n^2  2 awards^7 Show awards\n^2  4 deaths^7 Show deaths\n^2  8 notime^7 Disable time\n^2 16 efficiency^7 Show efficiency\n^2 32 accuracy^7 Show accuracy\n^54 network^7 player's network status\n^2 1 noping^7 Disable ping\n^2 2 pl^7 Show packet loss\n"
"^2 4 variance^7 Show max/avg/min ping\n^55 extra^7 extra settings\n^2  1 noattacker^7 Disable last attacker\n^2  2 victim^7 Show last victim\n^2  4 noheader^7 Disable header\n^2  8 nodeath^7 Disable scoreboard on death\n^2 16 nofun^7 Disable fun names" },
        { &cg_switch,     "cg_switch",     "1 1 1<2<3<4<5<6<7<8<9", CVAR_ARCHIVE, "cg_switch <auto> <noammo> <list>\nSets weapon switching options\n^51 auto^7 sets automatic weapon switching\n^2 0^7 no autoswitch\n^2 1^7 autoswitch on weapon pickup\n^2 2^7 autoswitch on weapon or ammo pickup\n^52 noammo^7 weapon switching when out of ammo\n^2 0^7 switches if server tells you to\n^2 1^7 switches if fire is held when out of ammo\n^2 2^7 switches ASAP when out of ammo\n^53 list^7 weapon priority list. Use '>' or ',' to separate weapon numbers. 'n' option lists weapons that should never be considered for switching.\nEx: \"2<3<5<n<7<9\" = 5 is better than 3 which is better than 2. NEVER switch to 7 or 9." },
        { &cg_team,       "cg_team",       "0 3000 8", CVAR_ARCHIVE, "cg_team <overlay> <time> <lines> <warn>\nSets team HUD options\n^51 overlay^7 team status overlay display and position\n^2 0^7 no team overlay\n^2 1^7 team overlay on upper-right\n^2 2^7 team overlay on lower-right\n^2 3^7 team orverlay on lower-left\n^52 time^7 time (msecs) team chat stays on screen\n^53 lines^7 max # of lines for team chat on screen\n^54 warn^7 string used to warn user if it shows up on team chat" },
        { &cg_tracer,     "cg_tracer",     "0.4 1 100", CVAR_ARCHIVE, "cg_tracer <chance> <width> <length>\nSets bullet tracer parameters\n^51 chance^7 chance of tracer appearing for every shot\n^52 width^7 tracer width\n^53 length^7 tracer length" },
        { &cg_xhair,      "cg_xhair",      "4 1 0 0 24 1 1 1", CVAR_ARCHIVE, "cg_xhair <style> <attrib> <x> <y> <size> <R> <G> <B>\nCrosshair parameters\n^51 style^7 crosshair style (1-10)\n^52 options^7 options bitflags\n^2 1 name^7 displays name of player on crosshair\n^2 2 health^7 health condition changes crosshair color\n^2 4 nopickup^7 disables crosshair pulse on pickup\n^53 x^7 x offset\n^54 y^7 y offset\n^55 size^7 crosshair size\n^56 R^7 red color value\n^57 G^7 green color value\n^58 B^7 blue color value" },
        { &cg_zoom,       "cg_zoom",       "22.5 150 1", CVAR_ARCHIVE, "cg_zoom <fov> <time> <sens>\nSets values used for +zoom command\n^51 fov^7 zoom fov\n^52 time^7 time (msecs) it takes to zoom\n^53 sens^7 additional zoom sensitivity adjustment" },
};
// --

int		cvarTableSize = sizeof( cvarTable ) / sizeof( cvarTable[0] );

// q3app (cvar handling commands)


/*
=================
CG_KeyName

Returns the key number of a key alias
=================
*/
int CG_KeyName (const char *cvar, const char *key, int *bitflags ) {
        int     k;

        k = atoi( key );
        *bitflags = 0;

        if ( k > 8 ) { // just for safety
                k = 8;
        }

        if ( k > 0 ) {
                if ( !Q_stricmp( cvar, "cg_3rdPerson" ) && k > 2 ) k = 2;
                else if ( !Q_stricmp( cvar, "cg_alpha" ) && k > 3 ) k = 3;
                else if ( !Q_stricmp( cvar, "cg_announcer" ) && k > 1 ) k = 1;
                else if ( !Q_stricmp( cvar, "cg_bob" ) && k > 3 ) k = 3;
                else if ( !Q_stricmp( cvar, "cg_color" ) && k > 2 ) k = 2;
                else if ( !Q_stricmp( cvar, "cg_debug" ) && k > 2 ) k = 2;
                else if ( !Q_stricmp( cvar, "cg_draw" ) && k > 3 ) k = 3;
                else if ( !Q_stricmp( cvar, "cg_force" ) && k > 1 ) k = 1;
                else if ( !Q_stricmp( cvar, "cg_fx" ) && k > 6 ) k = 6;
                else if ( !Q_stricmp( cvar, "cg_gun" ) && k > 5 ) k = 5;
                else if ( !Q_stricmp( cvar, "cg_nobeeps" ) && k > 1 ) k = 1;
                else if ( !Q_stricmp( cvar, "cg_predict" ) && k > 2 ) k = 2;
                else if ( !Q_stricmp( cvar, "cg_run" ) && k > 2 ) k = 2;
                else if ( !Q_stricmp( cvar, "cg_scoreboard" ) && k > 10 ) k = 10; // UNDECIDED
                else if ( !Q_stricmp( cvar, "cg_switch" ) && k > 3 ) k = 3;
                else if ( !Q_stricmp( cvar, "cg_team" ) && k > 4 ) k = 4;
                else if ( !Q_stricmp( cvar, "cg_tracer" ) && k > 3 ) k = 3;
                else if ( !Q_stricmp( cvar, "cg_xhair" ) && k > 8 ) k = 8;
                else if ( !Q_stricmp( cvar, "cg_zoom" ) && k > 3 ) k = 3;
                return k;
        } else if ( !Q_stricmp( cvar, "cg_3rdPerson" ) ) {
                if ( !Q_stricmp( key, "range") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "angle") ) {
                        return 2;
                }
        } else if ( !Q_stricmp( cvar, "cg_alpha" ) ) {
                if ( !Q_stricmp( key, "smoke") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "blood") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "gun") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_announcer" ) ) {
                if ( !Q_stricmp( key, "bitflags") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "leadtied") ) {
                        *bitflags = CG_ANNOUNCER_NOLEADTIED;
                        return 1;
                } else if ( !Q_stricmp( key, "countdown") ) {                
                        *bitflags = CG_ANNOUNCER_NOCOUNTDOWN;
                        return 1;
                } else if ( !Q_stricmp( key, "awards") ) {
                        *bitflags = CG_ANNOUNCER_NOAWARDS;
                        return 1;
                } else if ( !Q_stricmp( key, "powerup") ) {
                        *bitflags = CG_ANNOUNCER_NOPOWERUPS;
                        return 1;
                } else if ( !Q_stricmp( key, "extra") ) {
                        *bitflags = CG_ANNOUNCER_NOEXTRA;
                        return 1;
                }
        } else if ( !Q_stricmp( cvar, "cg_bob" ) ) {
                if ( !Q_stricmp( key, "up") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "pitch") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "roll") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_color" ) ) {
                if ( !Q_stricmp( key, "tc") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "lc") ) {
                        return 2;
                }
        } else if ( !Q_stricmp( cvar, "cg_debug" ) ) {
                if ( !Q_stricmp( key, "bitflags") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "anim") ) {
                        *bitflags = CG_DEBUG_ANIM;
                        return 1;
                } else if ( !Q_stricmp( key, "event") ) {
                        *bitflags = CG_DEBUG_EVENT;
                        return 1;
                } else if ( !Q_stricmp( key, "pos") ) {
                        *bitflags = CG_DEBUG_POS;
                        return 1;
                } else if ( !Q_stricmp( key, "noplayeranims") ) {
                        *bitflags = CG_DEBUG_NOPLAYERANIMS;
                        return 1;
                } else if ( !Q_stricmp( key, "showmiss") ) {
                        *bitflags = CG_DEBUG_SHOWMISS;
                        return 1;
                } else if ( !Q_stricmp( key, "stats") ) {
                        *bitflags = CG_DEBUG_STATS;
                        return 1;
                } else if ( !Q_stricmp( key, "animspeed") ) {
                        *bitflags = CG_DEBUG_ANIMSPEED;
                        return 1;
                } else if ( !Q_stricmp( key, "swingspeed") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "gunframe") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_draw" ) ) {
                if ( !Q_stricmp( key, "bitflags") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "nothing") ) {
                        *bitflags = CG_DRAW_NOTHING;
                        return 1;
                } else if ( !Q_stricmp( key, "nostatus") ) {
                        *bitflags = CG_DRAW_NOSTATUSBAR;
                        return 1;
                } else if ( !Q_stricmp( key, "noscores") ) {
                        *bitflags = CG_DRAW_NOSCORES;
                        return 1;
                } else if ( !Q_stricmp( key, "noattacker") ) {
                        *bitflags = CG_DRAW_NOATTACKER;
                        return 1;
                } else if ( !Q_stricmp( key, "FPS") ) {
                        *bitflags = CG_DRAW_FPS;
                        return 1;
                } else if ( !Q_stricmp( key, "notimer") ) {
                        *bitflags = CG_DRAW_NOTIMER;
                        return 1;
                } else if ( !Q_stricmp( key, "noammowarn") ) {
                        *bitflags = CG_DRAW_NOAMMOWARN;
                        return 1;
                } else if ( !Q_stricmp( key, "nodamage") ) {
                        *bitflags = CG_DRAW_NODAMAGE;
                        return 1;
                } else if ( !Q_stricmp( key, "noreward") ) {
                        *bitflags = CG_DRAW_NOREWARDS;
                        return 1;
                } else if ( !Q_stricmp( key, "nolagometer") ) {
                        *bitflags = CG_DRAW_NOLAGOMETER;
                        return 1;
                } else if ( !Q_stricmp( key, "allammo") ) {
                        *bitflags = CG_DRAW_ALLAMMO;
                        return 1;
                } else if ( !Q_stricmp( key, "snapshot") ) {
                        *bitflags = CG_DRAW_SNAPSHOT;
                        return 1;
                } else if ( !Q_stricmp( key, "nopickup") ) {
                        *bitflags = CG_DRAW_NOPICKUP;
                        return 1;
                } else if ( !Q_stricmp( key, "memory") ) {
                        *bitflags = CG_DRAW_MEMORY;
                        return 1;
                } else if ( !Q_stricmp( key, "icons") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "centertime") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_force" ) ) {
                if ( !Q_stricmp( key, "bitflags") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "std_skin") ) {
                        *bitflags = CG_FORCE_STD_SKIN;
                        return 1;
                } else if ( !Q_stricmp( key, "std_model") ) {
                        *bitflags = CG_FORCE_STD_MODEL;
                        return 1;
                } else if ( !Q_stricmp( key, "std_sound") ) {
                        *bitflags = CG_FORCE_STD_SOUND;
                        return 1;
                } else if ( !Q_stricmp( key, "same_model") ) {
                        *bitflags = CG_FORCE_SAME_MODEL;
                        return 1;
                } else if ( !Q_stricmp( key, "team_color") ) {
                        *bitflags = CG_FORCE_TEAM_COLOR;
                        return 1;
                }
        } else if ( !Q_stricmp( cvar, "cg_fx" ) ) {
                if ( !Q_stricmp( key, "marks") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "marktime") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "gibs") ) {
                        return 3;
                } else if ( !Q_stricmp( key, "gibtime") ) {
                        return 4;
                } else if ( !Q_stricmp( key, "brasstime") ) {
                        return 5;
                } else if ( !Q_stricmp( key, "railtime") ) {
                        return 6;
                }
        } else if ( !Q_stricmp( cvar, "cg_gun" ) ) {
                if ( !Q_stricmp( key, "x") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "y") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "z") ) {
                        return 3;
                } else if ( !Q_stricmp( key, "pos") ) {
                        return 4;
                } else if ( !Q_stricmp( key, "flash") ) {
                        return 5;
                }
        } else if ( !Q_stricmp( cvar, "cg_noBeeps" ) ) {
                if ( !Q_stricmp( key, "bitflags") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "nopain") ) {
                        *bitflags = CG_NOBEEPS_PAIN;
                        return 1;
                } else if ( !Q_stricmp( key, "nohit") ) {
                        *bitflags = CG_NOBEEPS_HIT;
                        return 1;
                } else if ( !Q_stricmp( key, "noteamhit") ) {
                        *bitflags = CG_NOBEEPS_TEAMHIT;
                        return 1;
                } else if ( !Q_stricmp( key, "noteamwarn") ) {
                        *bitflags = CG_NOBEEPS_TEAMWARN;
                        return 1;
                } else if ( !Q_stricmp( key, "notimewarn") ) {
                        *bitflags = CG_NOBEEPS_TIMEWARN;
                        return 1;
                }
        } else if ( !Q_stricmp( cvar, "cg_predict" ) ) {
                if ( !Q_stricmp( key, "prediction") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "errordecay") ) {
                        return 2;
                }
        } else if ( !Q_stricmp( cvar, "cg_run" ) ) {
                if ( !Q_stricmp( key, "roll") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "pitch") ) {
                        return 2;
                }
        } else if ( !Q_stricmp( cvar, "cg_scoreboard" ) ) {
                if ( !Q_stricmp( key, "format") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "id") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "noname") ) {
                        *bitflags = CG_SB_ID_NONAME;
                        return 2;
                } else if ( !Q_stricmp( key, "noclan") ) {
                        *bitflags = CG_SB_ID_NOCLAN;
                        return 2;
                } else if ( !Q_stricmp( key, "nohead") ) {
                        *bitflags = CG_SB_ID_NOHEAD;
                        return 2;
                } else if ( !Q_stricmp( key, "nocolors") ) {
                        *bitflags = CG_SB_ID_NOCOLORS;
                        return 2;
                } else if ( !Q_stricmp( key, "noinfo") ) {
                        *bitflags = CG_SB_ID_NOINFO;
                        return 2;
                } else if ( !Q_stricmp( key, "score") ) {
                        return 3;
                } else if ( !Q_stricmp( key, "nofrags") ) {
                        *bitflags = CG_SB_SCORE_NOFRAGS;
                        return 3;
                } else if ( !Q_stricmp( key, "awards") ) {
                        *bitflags = CG_SB_SCORE_AWARDS;
                        return 3;
                } else if ( !Q_stricmp( key, "deaths") ) {
                        *bitflags = CG_SB_SCORE_DEATHS;
                        return 3;
                } else if ( !Q_stricmp( key, "notime") ) {
                        *bitflags = CG_SB_SCORE_NOTIME;
                        return 3;
                } else if ( !Q_stricmp( key, "efficiency") ) {
                        *bitflags = CG_SB_SCORE_EFFICIENCY;
                        return 3;
                } else if ( !Q_stricmp( key, "accuracy") ) {
                        *bitflags = CG_SB_SCORE_ACCURACY;
                        return 3;
                } else if ( !Q_stricmp( key, "network") ) {
                        return 4;
                } else if ( !Q_stricmp( key, "noping") ) {
                        *bitflags = CG_SB_NETWORK_NOPING;
                        return 4;
                } else if ( !Q_stricmp( key, "pl") ) {
                        *bitflags = CG_SB_NETWORK_PL;
                        return 4;
                } else if ( !Q_stricmp( key, "variance") ) {
                        *bitflags = CG_SB_NETWORK_VARIANCE;
                        return 4;
                } else if ( !Q_stricmp( key, "extra") ) {
                        return 5;
                } else if ( !Q_stricmp( key, "noattacker") ) {
                        *bitflags = CG_SB_EXTRA_NOATTACKER;
                        return 5;
                } else if ( !Q_stricmp( key, "victim") ) {
                        *bitflags = CG_SB_EXTRA_VICTIM;
                        return 5;
                } else if ( !Q_stricmp( key, "noheader") ) {
                        *bitflags = CG_SB_EXTRA_NOHEADER;
                        return 5;
                } else if ( !Q_stricmp( key, "nodeath") ) {
                        *bitflags = CG_SB_EXTRA_NODEATH;
                        return 5;
                } else if ( !Q_stricmp( key, "nofun") ) {
                        *bitflags = CG_SB_EXTRA_NOFUN;
                        return 5;
                }                
        } else if ( !Q_stricmp( cvar, "cg_switch" ) ) {
                if ( !Q_stricmp( key, "auto") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "noammo") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "list") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_team" ) ) {
                if ( !Q_stricmp( key, "overlay") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "time") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "lines") ) {
                        return 3;
                } else if ( !Q_stricmp( key, "warn") ) {
                        return 4;
                }
        } else if ( !Q_stricmp( cvar, "cg_tracer" ) ) {
                if ( !Q_stricmp( key, "chance") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "width") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "length") ) {
                        return 3;
                }
        } else if ( !Q_stricmp( cvar, "cg_xhair" ) ) {
                if ( !Q_stricmp( key, "style") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "options") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "name") ) {
                        *bitflags = CG_XHAIR_NAME;
                        return 2;
                } else if ( !Q_stricmp( key, "health") ) {
                        *bitflags = CG_XHAIR_HEALTH;
                        return 2;
                } else if ( !Q_stricmp( key, "nopickup") ) {
                        *bitflags = CG_XHAIR_NOPICKUP;
                        return 2;
                } else if ( !Q_stricmp( key, "x") ) {
                        return 3;
                } else if ( !Q_stricmp( key, "y") ) {
                        return 4;
                } else if ( !Q_stricmp( key, "size") ) {
                        return 5;
                } else if ( !Q_stricmp( key, "R") ) {
                        return 6;
                } else if ( !Q_stricmp( key, "G") ) {
                        return 7;
                } else if ( !Q_stricmp( key, "B") ) {
                        return 8;
                }
        } else if ( !Q_stricmp( cvar, "cg_zoom" ) ) {
                if ( !Q_stricmp( key, "fov") ) {
                        return 1;
                } else if ( !Q_stricmp( key, "time") ) {
                        return 2;
                } else if ( !Q_stricmp( key, "sens") ) {
                        return 3;
                }
        }
        return 0;
}

/*
=================
CG_CommandList

Lists Q3A++ commands
=================
*/
void CG_CommandList (void) {
        CG_Printf("commands: ^5arg, help, def\n^7cvars: ^5cg_3rdPerson, cg_alpha, cg_announcer, cg_bob, cg_color, cg_debug, cg_draw, cg_fastRespawn, cg_force, cg_fx, cg_gun, cg_noBeeps, cg_predict, cg_run, cg_scoreboard, cg_switch, cg_team, cg_tracer, cg_xhair, cg_zoom^7\n");
}

/*
=================
CG_DefaultValue_f

Sets a cvar or a cvar key to its default value
=================
*/
void CG_DefaultCvar_f (void) {
        int             i, k, j;
        const char      *cvar;
        char            temp_cvar[MAX_INFO_STRING], temp_cvar2[MAX_INFO_STRING];

        k = trap_Argc();

        if ( k == 2 ) { // default the value of a cvar
                cvar = CG_Argv(1);
                if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {

                }
                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {
                                trap_Cvar_Set( cvarTable[i].cvarName, cvarTable[i].defaultString );
                                return;
                        }
                }
                CG_Printf( va( "Unknown cvar %s\n", cvar ) );
        } else if ( k == 3 ) { // default the value of a cvar key
                strcpy( (char*)temp_cvar, CG_Argv(2) );
                cvar = CG_Argv(1);
                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {                                
                                j = CG_KeyName( cvar, temp_cvar, &k );
                                if ( !j ) {
                                        CG_Printf( va( "Unknown cvar key %s. Try \"\\help %s\" for more information on this cvar\n", temp_cvar, cvar ) );
                                        return;
                                } else {
                                        strcpy( temp_cvar2, cvar_argv( cvarTable[i].defaultString, j ) );
                                        if ( k ) { // a bitflag is being set
                                                if ( atoi( temp_cvar2 ) & k ) { // enabled
                                                        strcpy( temp_cvar2, va("%i", atoi( cvar_argv( cvarTable[i].vmCvar->string, j ) ) | k ) );
                                                } else { // disable
                                                        strcpy( temp_cvar2, va("%i", atoi( cvar_argv( cvarTable[i].vmCvar->string, j ) ) & ~k) );
                                                }
                                        }
                                        trap_Cvar_Set( cvarTable[i].cvarName, set_argv( &cvarTable[i].vmCvar->string[0], j, temp_cvar2 ) );
                                        return;
                                }
                        }
                }
                CG_Printf( va( "Unknown cvar %s\n", cvar ) );
        } else {
                if ( k == 1 ) {
                        CG_Printf("Sets a cvar or a cvar key to its default value\n");
                } else {
                        CG_Printf("Too many parameters\n");
                }
                CG_Printf("usage: \\def <cvar> [key]\n");
        }
}

/*
=================
CG_ArgumentCvar_f

Sets a cvar key's value
=================
*/
void CG_ArgumentCvar_f (void) {
        int             i, k, j, l;
        const char      *cvar;
        char            temp_cvar[MAX_INFO_STRING], temp_cvar2[MAX_INFO_STRING];

        l = trap_Argc();
        if ( l == 2 ) { // display help on a cvar key
                cvar = CG_Argv(1);
                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {
                                CG_Help_f();
                                trap_SendConsoleCommand( va("%s\n", cvar ) );
                                return;
                        }
                }
                CG_Printf( va( "Unknown cvar key %s\n", cvar ) );
        } else if ( l == 3 ) { // display the value of a cvar key
                strcpy( (char*)temp_cvar, CG_Argv(2) ); // store name of key
                cvar = CG_Argv(1);
                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {
                                j = CG_KeyName( cvar, temp_cvar, &k );
                                if ( !j ) {
                                        CG_Printf( va( "Unknown cvar key %s. Try \"\\help %s\" for more information on this cvar\n", temp_cvar, cvar ) );
                                        return;
                                }
                                strcpy( temp_cvar2, cvar_argv( cvarTable[i].vmCvar->string, j ) );
                                if ( k ) { // bitflag value
                                        if ( atoi( temp_cvar2 ) & k ) { // enabled
                                                strcpy( temp_cvar2, "1" );
                                        } else { // disabled
                                                strcpy( temp_cvar2, "0" );
                                        }
                                }
                                CG_Printf( va( "%s %s = %s\n", cvar, temp_cvar, temp_cvar2 ) );
                                return;
                        }
                }
                CG_Printf( va( "Unknown cvar key %s\n", cvar ) );
        } else if ( l > 3 ) { // change the value of a cvar key
                strcpy( (char*)temp_cvar, CG_Argv( 2 ) ); // store name of key
                strcpy( (char*)temp_cvar2, CG_Argv( 3 ) ); // store value to be assigned
                for ( i = 4; i < l; i++ ) {
                        strcat( (char*)temp_cvar2, " " );
                        strcat( (char*)temp_cvar2, CG_Argv( i ) ); // store value to be assigned
                }
                cvar = CG_Argv(1);
                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {
                                j = CG_KeyName( cvar, temp_cvar, &k );
                                if ( !j ) {
                                        CG_Printf( va( "Unknown cvar key %s. Try \"\\help %s\" for more information on this cvar\n", temp_cvar, cvar ) );
                                        return;
                                } else {
                                        if ( k ) { // a bitflag is being set
                                                if ( atoi( temp_cvar2 ) ) { // enabled
                                                        strcpy( temp_cvar2, va("%i", ( atoi( cvar_argv( cvarTable[i].vmCvar->string, j ) ) | k ) ) );
                                                } else { // disable
                                                        strcpy( temp_cvar2, va("%i", ( atoi( cvar_argv( cvarTable[i].vmCvar->string, j ) ) & ~k ) ) );
                                                }
                                        }
                                        trap_Cvar_Set( cvarTable[i].cvarName, set_argv( &cvarTable[i].vmCvar->string[0], j, temp_cvar2 ) );
                                        return;
                                }
                        }
                }
                CG_Printf( va( "Unknown cvar %s\n", cvar ) );
        } else {
                CG_Printf("Sets or displays a cvar key value\nusage: \\arg <cvar> <key> [value]\n");
        }
}

/*
=================
CG_Help_f

Displays help on a cvar
=================
*/
void CG_Help_f (void) {
        int             i, k;
        const char      *cvar;

        k = trap_Argc();

        if ( k > 1 ) { // show help on a cvar
                cvar = CG_Argv(1);
                if (!Q_stricmp( cvar, "help" ) ) {
                        trap_SendConsoleCommand("help\n");
                        return;
                }
                if (!Q_stricmp( cvar, "def" ) ) {
                        trap_SendConsoleCommand("def\n");
                        return;
                }
                if (!Q_stricmp( cvar, "arg" ) ) {
                        trap_SendConsoleCommand("arg\n");
                        return;
                }

                for ( i = 0 ; i < sizeof( cvarTable ) / sizeof( cvarTable[0] ) ; i++ ) {
                        if ( !Q_stricmp( cvar, cvarTable[i].cvarName ) ) {
                                if ( !cvarTable[i].cvarHelp[0] ) {
                                        CG_Printf( "No help available for this cvar/command\n", cvarTable[i].cvarHelp );
                                        return;
                                }
                                CG_Printf( "usage: %s\n", cvarTable[i].cvarHelp );
                                return;
                        }
                }
                CG_Printf( va( "Unknown cvar %s\n", cvar ) );
        } else {
                CG_Printf("^7Displays information on Q3A++ cvars and commands\nusage: \\help <cvar | command>\n");
                CG_CommandList();
        }
        return;
}

/*
=================
CG_ParseCvars
=================
*/
void CG_ParseCvars( qboolean init ) {
        if ( init || cgv.modcount.cg_3rdPerson != cg_3rdPerson.modificationCount ) {
                cgv.modcount.cg_3rdPerson = cg_3rdPerson.modificationCount;
                cgv.cg_3rdPerson.range = atof( cvar_argv( cg_3rdPerson.string, 1 ) );
                cgv.cg_3rdPerson.angle = atof( cvar_argv( cg_3rdPerson.string, 2 ) );
        }
        if ( init || cgv.modcount.cg_alpha != cg_alpha.modificationCount ) {
                cgv.modcount.cg_alpha = cg_alpha.modificationCount;
                cgv.cg_alpha.smoke = atof( cvar_argv( cg_alpha.string, 1 ) );
                cgv.cg_alpha.blood = atof( cvar_argv( cg_alpha.string, 2 ) );
        }
        if ( init || cgv.modcount.cg_announcer != cg_announcer.modificationCount ) {
                cgv.modcount.cg_announcer = cg_announcer.modificationCount;
                cgv.cg_announcer.bitflags = atoi( cvar_argv( cg_announcer.string, 1 ) );
        }
        if ( init || cgv.modcount.cg_bob != cg_bob.modificationCount ) {
                cgv.modcount.cg_bob = cg_bob.modificationCount;
                cgv.cg_bob.up = atof( cvar_argv( cg_bob.string, 1 ) );
                cgv.cg_bob.pitch = atof( cvar_argv( cg_bob.string, 2 ) );
                cgv.cg_bob.roll = atof( cvar_argv( cg_bob.string, 3 ) );
        }
        if ( init || cgv.modcount.cg_color != cg_color.modificationCount ) {
                cgv.modcount.cg_color = cg_color.modificationCount;
                cgv.cg_color.tc = atoi( cvar_argv( cg_color.string, 1 ) );
                cgv.cg_color.lc = atoi( cvar_argv( cg_color.string, 2 ) );
        }
        if ( init || cgv.modcount.cg_debug != cg_debug.modificationCount ) {
                cgv.modcount.cg_debug = cg_debug.modificationCount;
                cgv.cg_debug.bitflags = atoi( cvar_argv( cg_debug.string, 1 ) );
                cgv.cg_debug.swingspeed = atof( cvar_argv( cg_debug.string, 2 ) );
                cgv.cg_debug.gunframe = atoi( cvar_argv( cg_debug.string, 3 ) );
        }
        if ( init || cgv.modcount.cg_draw != cg_draw.modificationCount ) {
                cgv.modcount.cg_draw = cg_draw.modificationCount;
                cgv.cg_draw.bitflags = atoi( cvar_argv( cg_draw.string, 1 ) );
                cgv.cg_draw.icons = atoi( cvar_argv( cg_draw.string, 2 ) );
                cgv.cg_draw.centertime = atof( cvar_argv( cg_draw.string, 3 ) );
        }
        if ( init || cgv.modcount.cg_force != cg_force.modificationCount ) {
                cgv.modcount.cg_force = cg_force.modificationCount;
                cgv.cg_force.bitflags = atoi( cvar_argv( cg_force.string, 1 ) );
        }
        if ( init || cgv.modcount.cg_fx != cg_fx.modificationCount ) {
                cgv.modcount.cg_fx = cg_fx.modificationCount;
                cgv.cg_fx.marks = atoi( cvar_argv( cg_fx.string, 1 ) );
                cgv.cg_fx.marktime = atof( cvar_argv( cg_fx.string, 2 ) );
                cgv.cg_fx.gibs = atoi( cvar_argv( cg_fx.string, 3 ) );
                cgv.cg_fx.gibtime = atof( cvar_argv( cg_fx.string, 4 ) );
                cgv.cg_fx.brasstime = atof( cvar_argv( cg_fx.string, 5 ) );
                cgv.cg_fx.railtime = atof( cvar_argv( cg_fx.string, 6 ) );
        }
        if ( init || cgv.modcount.cg_gun != cg_gun.modificationCount ) {
                cgv.modcount.cg_gun = cg_gun.modificationCount;
                cgv.cg_gun.x = atof( cvar_argv( cg_gun.string, 1 ) );
                cgv.cg_gun.y = atof( cvar_argv( cg_gun.string, 2 ) );
                cgv.cg_gun.z = atof( cvar_argv( cg_gun.string, 3 ) );
                cgv.cg_gun.pos = atoi( cvar_argv( cg_gun.string, 4 ) );
                cgv.cg_gun.flash = atof( cvar_argv( cg_gun.string, 5 ) );
        }
        if ( init || cgv.modcount.cg_beeps != cg_noBeeps.modificationCount ) {
                cgv.modcount.cg_beeps = cg_noBeeps.modificationCount;
                cgv.cg_beeps.bitflags = atoi( cvar_argv( cg_noBeeps.string, 1 ) );
        }
        if ( init || cgv.modcount.cg_predict != cg_predict.modificationCount ) {
                cgv.modcount.cg_predict = cg_predict.modificationCount;
                cgv.cg_predict.prediction = atoi( cvar_argv( cg_predict.string, 1 ) );
                cgv.cg_predict.errordecay = atof( cvar_argv( cg_predict.string, 2 ) );
        }
        if ( init || cgv.modcount.cg_run != cg_run.modificationCount ) {
                cgv.modcount.cg_run = cg_run.modificationCount;
                cgv.cg_run.roll = atof( cvar_argv( cg_run.string, 1 ) );
                cgv.cg_run.pitch = atof( cvar_argv( cg_run.string, 2 ) );
        }
        if ( init || cgv.modcount.cg_scoreboard != cg_scoreboard.modificationCount ) {
                cgv.modcount.cg_scoreboard = cg_scoreboard.modificationCount;
                cgv.cg_scoreboard.format = atoi( cvar_argv( cg_scoreboard.string, 1 ) );
                cgv.cg_scoreboard.id = atoi( cvar_argv( cg_scoreboard.string, 2 ) );
                cgv.cg_scoreboard.score = atoi( cvar_argv( cg_scoreboard.string, 3 ) );
                cgv.cg_scoreboard.network = atoi( cvar_argv( cg_scoreboard.string, 4 ) );
                cgv.cg_scoreboard.extra = atoi( cvar_argv( cg_scoreboard.string, 5 ) );
                trap_SendClientCommand( "score" );
                cg.scoresRequestTime = cg.time - 2000;
                cg.numScores = 0;
        }
        if ( init || cgv.modcount.cg_switch != cg_switch.modificationCount ) {
                cgv.modcount.cg_switch = cg_switch.modificationCount;
                cgv.cg_switch.autoswitch = atoi( cvar_argv( cg_switch.string, 1 ) );
                cgv.cg_switch.noammo = atoi( cvar_argv( cg_switch.string, 2 ) );
                strcpy( cgv.cg_switch.list, cvar_argv( cg_switch.string, 3 ) );
        }
        if ( init || cgv.modcount.cg_team != cg_team.modificationCount ) {
                cgv.modcount.cg_team = cg_team.modificationCount;
                cgv.cg_team.overlay = atoi( cvar_argv( cg_team.string, 1 ) );
                cgv.cg_team.time = atof( cvar_argv( cg_team.string, 2 ) );
                cgv.cg_team.lines = atoi( cvar_argv( cg_team.string, 3 ) );
                strcpy( cgv.cg_team.warn, cvar_argv( cg_team.string, 4 ) );
        }
        if ( init || cgv.modcount.cg_tracer != cg_tracer.modificationCount ) {
                cgv.modcount.cg_tracer = cg_tracer.modificationCount;
                cgv.cg_tracer.chance = atof( cvar_argv( cg_tracer.string, 1 ) );
                cgv.cg_tracer.width = atof( cvar_argv( cg_tracer.string, 2 ) );
                cgv.cg_tracer.length = atof( cvar_argv( cg_tracer.string, 3 ) );
        }
        if ( init || cgv.modcount.cg_xhair != cg_xhair.modificationCount ) {
                cgv.modcount.cg_xhair = cg_xhair.modificationCount;
                cgv.cg_xhair.style = atoi( cvar_argv( cg_xhair.string, 1 ) );
                cgv.cg_xhair.attrib = atoi( cvar_argv( cg_xhair.string, 2 ) );
                cgv.cg_xhair.x = atof( cvar_argv( cg_xhair.string, 3 ) );
                cgv.cg_xhair.y = atof( cvar_argv( cg_xhair.string, 4 ) );
                cgv.cg_xhair.size = atof( cvar_argv( cg_xhair.string, 5 ) );
                cgv.cg_xhair.R = atof( cvar_argv( cg_xhair.string, 6 ) );
                cgv.cg_xhair.G = atof( cvar_argv( cg_xhair.string, 7 ) );
                cgv.cg_xhair.B = atof( cvar_argv( cg_xhair.string, 8 ) );
        }
        if ( init || cgv.modcount.cg_zoom != cg_zoom.modificationCount ) {
                cgv.modcount.cg_zoom = cg_zoom.modificationCount;
                cgv.cg_zoom.fov = atoi( cvar_argv( cg_zoom.string, 1 ) );
                cgv.cg_zoom.time = atof( cvar_argv( cg_zoom.string, 2 ) );
                cgv.cg_zoom.sens = atof( cvar_argv( cg_zoom.string, 3 ) );
        }
}

// --


/*
=================
CG_RegisterCvars
=================
*/
void CG_RegisterCvars( void ) {
	int			i;
	cvarTable_t	*cv;
	char		var[MAX_TOKEN_CHARS];

	for ( i = 0, cv = cvarTable ; i < cvarTableSize ; i++, cv++ ) {
		trap_Cvar_Register( cv->vmCvar, cv->cvarName,
			cv->defaultString, cv->cvarFlags );
	}

	// see if we are also running the server on this machine
	trap_Cvar_VariableStringBuffer( "sv_running", var, sizeof( var ) );
	cgs.localServer = atoi( var );
}

/*
=================
CG_UpdateCvars
=================
*/
void CG_UpdateCvars( void ) {
	int			i;
	cvarTable_t	*cv;
// q3app (added modelStr)
        char            modelStr[MAX_QPATH];

	for ( i = 0, cv = cvarTable ; i < cvarTableSize ; i++, cv++ ) {
		trap_Cvar_Update( cv->vmCvar );
	}

	// check for modications here

	// If team overlay is on, ask for updates from the server.  If its off,
	// let the server know so we don't receive it
        if ( drawTeamOverlayModificationCount != cg_team.modificationCount ) {
                drawTeamOverlayModificationCount = cg_team.modificationCount;

                if ( cgv.cg_team.overlay > 0 ) {
			trap_Cvar_Set( "teamoverlay", "1" );
		} else {
			trap_Cvar_Set( "teamoverlay", "0" );
		}
	}

// q3app
        CG_ParseCvars( qfalse );

// q3app (reload all players if cg_force rules change)

        trap_Cvar_VariableStringBuffer( "model", modelStr, MAX_QPATH );
        if ( forceModificationCount != cg_force.modificationCount ) {
                CG_ReloadPlayers();
                forceModificationCount = cg_force.modificationCount;
        }

// --
}


int CG_CrosshairPlayer( void ) {
	if ( cg.time > ( cg.crosshairClientTime + 1000 ) ) {
		return -1;
	}
	return cg.crosshairClientNum;
}


int CG_LastAttacker( void ) {
	if ( !cg.attackerTime ) {
		return -1;
	}
	return cg.snap->ps.persistant[PERS_ATTACKER];
}


void QDECL CG_Printf( const char *msg, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	trap_Print( text );
}

void QDECL CG_Error( const char *msg, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	trap_Error( text );
}

#ifndef CGAME_HARD_LINKED
// this is only here so the functions in q_shared.c and bg_*.c can link (FIXME)

void QDECL Com_Error( int level, const char *error, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, error);
	vsprintf (text, error, argptr);
	va_end (argptr);

	CG_Error( "%s", text);
}

void QDECL Com_Printf( const char *msg, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	CG_Printf ("%s", text);
}

#endif



/*
================
CG_Argv
================
*/
const char *CG_Argv( int arg ) {
	static char	buffer[MAX_STRING_CHARS];

	trap_Argv( arg, buffer, sizeof( buffer ) );

	return buffer;
}


//========================================================================

/*
=================
CG_RegisterItemSounds

The server says this item is used on this level
=================
*/
static void CG_RegisterItemSounds( int itemNum ) {
	gitem_t			*item;
	char			data[MAX_QPATH];
	char			*s, *start;
	int				len;

	item = &bg_itemlist[ itemNum ];

	trap_S_RegisterSound( item->pickup_sound );

	// parse the space seperated precache string for other media
	s = item->sounds;
	if (!s || !s[0])
		return;

	while (*s) {
		start = s;
		while (*s && *s != ' ') {
			s++;
		}

		len = s-start;
		if (len >= MAX_QPATH || len < 5) {
			CG_Error( "PrecacheItem: %s has bad precache string", 
				item->classname);
			return;
		}
		memcpy (data, start, len);
		data[len] = 0;
		if ( *s ) {
			s++;
		}

		if ( !strcmp(data+len-3, "wav" )) {
			trap_S_RegisterSound( data );
		}
	}
}


/*
=================
CG_RegisterSounds

called during a precache command
=================
*/
static void CG_RegisterSounds( void ) {
	int		i;
	char	items[MAX_ITEMS+1];
	char	name[MAX_QPATH];
	const char	*soundName;

	if ( cgs.timelimit || cg_buildScript.integer ) {	// should we always load this?
		cgs.media.oneMinuteSound = trap_S_RegisterSound( "sound/feedback/1_minute.wav" );
		cgs.media.fiveMinuteSound = trap_S_RegisterSound( "sound/feedback/5_minute.wav" );
		cgs.media.suddenDeathSound = trap_S_RegisterSound( "sound/feedback/sudden_death.wav" );
	}

	if ( cgs.fraglimit || cg_buildScript.integer ) {
		cgs.media.oneFragSound = trap_S_RegisterSound( "sound/feedback/1_frag.wav" );
		cgs.media.twoFragSound = trap_S_RegisterSound( "sound/feedback/2_frags.wav" );
		cgs.media.threeFragSound = trap_S_RegisterSound( "sound/feedback/3_frags.wav" );
	}

//	if ( cgs.gametype == GT_TOURNAMENT || cg_buildScript.integer ) {
//  We always need this since a warmup can be enabled in any game mode
		cgs.media.count3Sound = trap_S_RegisterSound( "sound/feedback/three.wav" );
		cgs.media.count2Sound = trap_S_RegisterSound( "sound/feedback/two.wav" );
		cgs.media.count1Sound = trap_S_RegisterSound( "sound/feedback/one.wav" );
		cgs.media.countFightSound = trap_S_RegisterSound( "sound/feedback/fight.wav" );
		cgs.media.countPrepareSound = trap_S_RegisterSound( "sound/feedback/prepare.wav" );
//	}

	if ( cgs.gametype >= GT_TEAM || cg_buildScript.integer ) {
		cgs.media.redLeadsSound = trap_S_RegisterSound( "sound/feedback/redleads.wav" );
		cgs.media.blueLeadsSound = trap_S_RegisterSound( "sound/feedback/blueleads.wav" );
		cgs.media.teamsTiedSound = trap_S_RegisterSound( "sound/feedback/teamstied.wav" );
		cgs.media.hitTeamSound = trap_S_RegisterSound( "sound/feedback/hit_teammate.wav" );
	}

	cgs.media.tracerSound = trap_S_RegisterSound( "sound/weapons/machinegun/buletby1.wav" );
	cgs.media.selectSound = trap_S_RegisterSound( "sound/weapons/change.wav" );
	cgs.media.wearOffSound = trap_S_RegisterSound( "sound/items/wearoff.wav" );
	cgs.media.useNothingSound = trap_S_RegisterSound( "sound/items/use_nothing.wav" );
	cgs.media.gibSound = trap_S_RegisterSound( "sound/player/gibsplt1.wav" );
	cgs.media.gibBounce1Sound = trap_S_RegisterSound( "sound/player/gibimp1.wav" );
	cgs.media.gibBounce2Sound = trap_S_RegisterSound( "sound/player/gibimp2.wav" );
	cgs.media.gibBounce3Sound = trap_S_RegisterSound( "sound/player/gibimp3.wav" );

	cgs.media.teleInSound = trap_S_RegisterSound( "sound/world/telein.wav" );
	cgs.media.teleOutSound = trap_S_RegisterSound( "sound/world/teleout.wav" );
	cgs.media.respawnSound = trap_S_RegisterSound( "sound/items/respawn1.wav" );

	cgs.media.noAmmoSound = trap_S_RegisterSound( "sound/weapons/noammo.wav" );

	cgs.media.talkSound = trap_S_RegisterSound( "sound/player/talk.wav" );
	cgs.media.landSound = trap_S_RegisterSound( "sound/player/land1.wav");

	cgs.media.hitSound = trap_S_RegisterSound( "sound/feedback/hit.wav" );
// q3app (register beep sounds)
        cgs.media.painBeepSound = trap_S_RegisterSound( "sound/feedback/painbeep.wav" );
        cgs.media.timeBeepSound = trap_S_RegisterSound( "sound/feedback/timebeep.wav" );
        cgs.media.warnBeepSound = trap_S_RegisterSound( "sound/feedback/warnbeep1.wav" );
// --

	cgs.media.impressiveSound = trap_S_RegisterSound( "sound/feedback/impressive.wav" );
	cgs.media.excellentSound = trap_S_RegisterSound( "sound/feedback/excellent.wav" );
	cgs.media.deniedSound = trap_S_RegisterSound( "sound/feedback/denied.wav" );
	cgs.media.humiliationSound = trap_S_RegisterSound( "sound/feedback/humiliation.wav" );

	cgs.media.takenLeadSound = trap_S_RegisterSound( "sound/feedback/takenlead.wav");
	cgs.media.tiedLeadSound = trap_S_RegisterSound( "sound/feedback/tiedlead.wav");
	cgs.media.lostLeadSound = trap_S_RegisterSound( "sound/feedback/lostlead.wav");

	cgs.media.watrInSound = trap_S_RegisterSound( "sound/player/watr_in.wav");
	cgs.media.watrOutSound = trap_S_RegisterSound( "sound/player/watr_out.wav");
	cgs.media.watrUnSound = trap_S_RegisterSound( "sound/player/watr_un.wav");

	cgs.media.jumpPadSound = trap_S_RegisterSound ("sound/world/jumppad.wav" );

	for (i=0 ; i<4 ; i++) {
		Com_sprintf (name, sizeof(name), "sound/player/footsteps/step%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_NORMAL][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/boot%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_BOOT][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/flesh%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_FLESH][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/mech%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_MECH][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/energy%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_ENERGY][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/splash%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_SPLASH][i] = trap_S_RegisterSound (name);

		Com_sprintf (name, sizeof(name), "sound/player/footsteps/clank%i.wav", i+1);
		cgs.media.footsteps[FOOTSTEP_METAL][i] = trap_S_RegisterSound (name);
	}

	// only register the items that the server says we need
	strcpy( items, CG_ConfigString( CS_ITEMS ) );

	for ( i = 1 ; i < bg_numItems ; i++ ) {
		if ( items[ i ] == '1' || cg_buildScript.integer ) {
			CG_RegisterItemSounds( i );
		}
	}

	for ( i = 1 ; i < MAX_SOUNDS ; i++ ) {
		soundName = CG_ConfigString( CS_SOUNDS+i );
		if ( !soundName[0] ) {
			break;
		}
		if ( soundName[0] == '*' ) {
			continue;	// custom sound
		}
		cgs.gameSounds[i] = trap_S_RegisterSound( soundName );
	}

	// FIXME: only needed with item
	cgs.media.flightSound = trap_S_RegisterSound( "sound/items/flight.wav" );
	cgs.media.medkitSound = trap_S_RegisterSound ("sound/items/use_medkit.wav");
	cgs.media.quadSound = trap_S_RegisterSound("sound/items/damage3.wav");
	cgs.media.sfx_ric1 = trap_S_RegisterSound ("sound/weapons/machinegun/ric1.wav");
	cgs.media.sfx_ric2 = trap_S_RegisterSound ("sound/weapons/machinegun/ric2.wav");
	cgs.media.sfx_ric3 = trap_S_RegisterSound ("sound/weapons/machinegun/ric3.wav");
	cgs.media.sfx_railg = trap_S_RegisterSound ("sound/weapons/railgun/railgf1a.wav");
	cgs.media.sfx_rockexp = trap_S_RegisterSound ("sound/weapons/rocket/rocklx1a.wav");
	cgs.media.sfx_plasmaexp = trap_S_RegisterSound ("sound/weapons/plasma/plasmx1a.wav");
}


//===================================================================================


/*
=================
CG_RegisterGraphics

This function may execute for a couple of minutes with a slow disk.
=================
*/
static void CG_RegisterGraphics( void ) {
	int			i;
	char		items[MAX_ITEMS+1];
	static char		*sb_nums[11] = {
		"gfx/2d/numbers/zero_32b",
		"gfx/2d/numbers/one_32b",
		"gfx/2d/numbers/two_32b",
		"gfx/2d/numbers/three_32b",
		"gfx/2d/numbers/four_32b",
		"gfx/2d/numbers/five_32b",
		"gfx/2d/numbers/six_32b",
		"gfx/2d/numbers/seven_32b",
		"gfx/2d/numbers/eight_32b",
		"gfx/2d/numbers/nine_32b",
		"gfx/2d/numbers/minus_32b",
	};

	// clear any references to old media
	memset( &cg.refdef, 0, sizeof( cg.refdef ) );
	trap_R_ClearScene();

	CG_LoadingString( cgs.mapname );

	trap_R_LoadWorldMap( cgs.mapname );

	// precache status bar pics
	CG_LoadingString( "game media" );

	for ( i=0 ; i<11 ; i++) {
		cgs.media.numberShaders[i] = trap_R_RegisterShader( sb_nums[i] );
	}
// q3app (skill shaders now are "no mip")
        cgs.media.botSkillShaders[0] = trap_R_RegisterShaderNoMip( "menu/art/skill1.tga" );
        cgs.media.botSkillShaders[1] = trap_R_RegisterShaderNoMip( "menu/art/skill2.tga" );
        cgs.media.botSkillShaders[2] = trap_R_RegisterShaderNoMip( "menu/art/skill3.tga" );
        cgs.media.botSkillShaders[3] = trap_R_RegisterShaderNoMip( "menu/art/skill4.tga" );
        cgs.media.botSkillShaders[4] = trap_R_RegisterShaderNoMip( "menu/art/skill5.tga" );
// -- 
	cgs.media.viewBloodShader = trap_R_RegisterShader( "viewBloodBlend" );

	cgs.media.deferShader = trap_R_RegisterShaderNoMip( "gfx/2d/defer.tga" );
/* q3app (not used anymore)
	cgs.media.scoreboardName = trap_R_RegisterShaderNoMip( "menu/tab/name.tga" );
	cgs.media.scoreboardPing = trap_R_RegisterShaderNoMip( "menu/tab/ping.tga" );
	cgs.media.scoreboardScore = trap_R_RegisterShaderNoMip( "menu/tab/score.tga" );
	cgs.media.scoreboardTime = trap_R_RegisterShaderNoMip( "menu/tab/time.tga" );
*/
	cgs.media.smokePuffShader = trap_R_RegisterShader( "smokePuff" );
	cgs.media.smokePuffRageProShader = trap_R_RegisterShader( "smokePuffRagePro" );
	cgs.media.shotgunSmokePuffShader = trap_R_RegisterShader( "shotgunSmokePuff" );
	cgs.media.plasmaBallShader = trap_R_RegisterShader( "sprites/plasma1" );
	cgs.media.bloodTrailShader = trap_R_RegisterShader( "bloodTrail" );
	cgs.media.lagometerShader = trap_R_RegisterShader("lagometer" );
	cgs.media.connectionShader = trap_R_RegisterShader( "disconnected" );

	cgs.media.waterBubbleShader = trap_R_RegisterShader( "waterBubble" );

	cgs.media.tracerShader = trap_R_RegisterShader( "gfx/misc/tracer" );
	cgs.media.selectShader = trap_R_RegisterShader( "gfx/2d/select" );

	for ( i = 0 ; i < NUM_CROSSHAIRS ; i++ ) {
// q3app ( nomip on crosshairs)
                cgs.media.crosshairShader[i] = trap_R_RegisterShaderNoMip( va("gfx/2d/crosshair%c", 'a'+i) );
	}

	cgs.media.backTileShader = trap_R_RegisterShader( "gfx/2d/backtile" );
// q3app (noammo icon now is "no mip")
        cgs.media.noammoShader = trap_R_RegisterShaderNoMip( "icons/noammo" );

	// powerup shaders
	cgs.media.quadShader = trap_R_RegisterShader("powerups/quad" );
	cgs.media.quadWeaponShader = trap_R_RegisterShader("powerups/quadWeapon" );
	cgs.media.battleSuitShader = trap_R_RegisterShader("powerups/battleSuit" );
	cgs.media.battleWeaponShader = trap_R_RegisterShader("powerups/battleWeapon" );
	cgs.media.invisShader = trap_R_RegisterShader("powerups/invisibility" );
	cgs.media.regenShader = trap_R_RegisterShader("powerups/regen" );
	cgs.media.hastePuffShader = trap_R_RegisterShader("hasteSmokePuff" );

	if ( cgs.gametype == GT_CTF || cg_buildScript.integer ) {
		cgs.media.redFlagModel = trap_R_RegisterModel( "models/flags/r_flag.md3" );
		cgs.media.blueFlagModel = trap_R_RegisterModel( "models/flags/b_flag.md3" );
		cgs.media.redFlagShader[0] = trap_R_RegisterShaderNoMip( "icons/iconf_red1" );
		cgs.media.redFlagShader[1] = trap_R_RegisterShaderNoMip( "icons/iconf_red2" );
		cgs.media.redFlagShader[2] = trap_R_RegisterShaderNoMip( "icons/iconf_red3" );
		cgs.media.blueFlagShader[0] = trap_R_RegisterShaderNoMip( "icons/iconf_blu1" );
		cgs.media.blueFlagShader[1] = trap_R_RegisterShaderNoMip( "icons/iconf_blu2" );
		cgs.media.blueFlagShader[2] = trap_R_RegisterShaderNoMip( "icons/iconf_blu3" );
	}

	if ( cgs.gametype >= GT_TEAM || cg_buildScript.integer ) {
		cgs.media.friendShader = trap_R_RegisterShader( "sprites/foe" );
		cgs.media.redQuadShader = trap_R_RegisterShader("powerups/blueflag" );
		cgs.media.teamStatusBar = trap_R_RegisterShader( "gfx/2d/colorbar.tga" );
	}

	cgs.media.armorModel = trap_R_RegisterModel( "models/powerups/armor/armor_yel.md3" );
	cgs.media.armorIcon  = trap_R_RegisterShaderNoMip( "icons/iconr_yellow" );

// q3app (red armor and shard icons)
        cgs.media.armorRedModel = trap_R_RegisterModel( "models/powerups/armor/armor_red.md3" );
        cgs.media.armorRedIcon  = trap_R_RegisterShaderNoMip( "icons/iconr_red" );

        cgs.media.armorShardModel = trap_R_RegisterModel( "models/powerups/armor/shard.md3" );
        cgs.media.armorShardIcon  = trap_R_RegisterShaderNoMip( "icons/iconr_shard" );

// --

	cgs.media.machinegunBrassModel = trap_R_RegisterModel( "models/weapons2/shells/m_shell.md3" );
	cgs.media.shotgunBrassModel = trap_R_RegisterModel( "models/weapons2/shells/s_shell.md3" );

	cgs.media.gibAbdomen = trap_R_RegisterModel( "models/gibs/abdomen.md3" );
	cgs.media.gibArm = trap_R_RegisterModel( "models/gibs/arm.md3" );
	cgs.media.gibChest = trap_R_RegisterModel( "models/gibs/chest.md3" );
	cgs.media.gibFist = trap_R_RegisterModel( "models/gibs/fist.md3" );
	cgs.media.gibFoot = trap_R_RegisterModel( "models/gibs/foot.md3" );
	cgs.media.gibForearm = trap_R_RegisterModel( "models/gibs/forearm.md3" );
	cgs.media.gibIntestine = trap_R_RegisterModel( "models/gibs/intestine.md3" );
	cgs.media.gibLeg = trap_R_RegisterModel( "models/gibs/leg.md3" );
	cgs.media.gibSkull = trap_R_RegisterModel( "models/gibs/skull.md3" );
	cgs.media.gibBrain = trap_R_RegisterModel( "models/gibs/brain.md3" );
	
	cgs.media.balloonShader = trap_R_RegisterShader( "sprites/balloon3" );

	cgs.media.bloodExplosionShader = trap_R_RegisterShader( "bloodExplosion" );

	cgs.media.bulletFlashModel = trap_R_RegisterModel("models/weaphits/bullet.md3");
	cgs.media.ringFlashModel = trap_R_RegisterModel("models/weaphits/ring02.md3");

        cgs.media.dishFlashModel = trap_R_RegisterModel("models/weaphits/boom01.md3");
	cgs.media.teleportEffectModel = trap_R_RegisterModel( "models/misc/telep.md3" );
	cgs.media.teleportEffectShader = trap_R_RegisterShader( "teleportEffect" );

	cgs.media.medalImpressive = trap_R_RegisterShaderNoMip( "medal_impressive" );
	cgs.media.medalExcellent = trap_R_RegisterShaderNoMip( "medal_excellent" );
	cgs.media.medalGauntlet = trap_R_RegisterShaderNoMip( "medal_gauntlet" );
// q3app
        cgs.media.medalAccuracy = trap_R_RegisterShaderNoMip( "medal_accuracy" );
        cgs.media.medalFrags = trap_R_RegisterShaderNoMip( "medal_frags" );
// --

// q3app (damage view stuff)
        cgs.media.damageArrow1 = trap_R_RegisterShaderNoMip( "menu/art/narrow_0" );
        cgs.media.damageArrow2 = trap_R_RegisterShaderNoMip( "menu/art/narrow2_0" );
        cgs.media.damageArrow3 = trap_R_RegisterShaderNoMip( "menu/art/narrow3_0" );
// --
	memset( cg_items, 0, sizeof( cg_items ) );
	memset( cg_weapons, 0, sizeof( cg_weapons ) );

	// only register the items that the server says we need
	strcpy( items, CG_ConfigString( CS_ITEMS) );

	for ( i = 1 ; i < bg_numItems ; i++ ) {
		if ( items[ i ] == '1' || cg_buildScript.integer ) {
			CG_LoadingItem( i );
			CG_RegisterItemVisuals( i );
		}
	}

	// wall marks
	cgs.media.bulletMarkShader = trap_R_RegisterShader( "gfx/damage/bullet_mrk" );
	cgs.media.burnMarkShader = trap_R_RegisterShader( "gfx/damage/burn_med_mrk" );
	cgs.media.holeMarkShader = trap_R_RegisterShader( "gfx/damage/hole_lg_mrk" );
	cgs.media.energyMarkShader = trap_R_RegisterShader( "gfx/damage/plasma_mrk" );
	cgs.media.shadowMarkShader = trap_R_RegisterShader( "markShadow" );
	cgs.media.wakeMarkShader = trap_R_RegisterShader( "wake" );
	cgs.media.bloodMarkShader = trap_R_RegisterShader( "bloodMark" );

	// register the inline models
	cgs.numInlineModels = trap_CM_NumInlineModels();
	for ( i = 1 ; i < cgs.numInlineModels ; i++ ) {
		char	name[10];
		vec3_t			mins, maxs;
		int				j;

		Com_sprintf( name, sizeof(name), "*%i", i );
		cgs.inlineDrawModel[i] = trap_R_RegisterModel( name );
		trap_R_ModelBounds( cgs.inlineDrawModel[i], mins, maxs );
		for ( j = 0 ; j < 3 ; j++ ) {
			cgs.inlineModelMidpoints[i][j] = mins[j] + 0.5 * ( maxs[j] - mins[j] );
		}
	}

	// register all the server specified models
	for (i=1 ; i<MAX_MODELS ; i++) {
		const char		*modelName;

		modelName = CG_ConfigString( CS_MODELS+i );
		if ( !modelName[0] ) {
			break;
		}
		cgs.gameModels[i] = trap_R_RegisterModel( modelName );
	}
}

/*
===================
CG_RegisterClients

===================
*/
static void CG_RegisterClients( void ) {
	int		i;

	for (i=0 ; i<MAX_CLIENTS ; i++) {
		const char		*clientInfo;

		clientInfo = CG_ConfigString( CS_PLAYERS+i );
		if ( !clientInfo[0] ) {
			continue;
		}
		CG_LoadingClient( i );
		CG_NewClientInfo( i );
	}
}

//===========================================================================

/*
=================
CG_ConfigString
=================
*/
const char *CG_ConfigString( int index ) {
	if ( index < 0 || index >= MAX_CONFIGSTRINGS ) {
		CG_Error( "CG_ConfigString: bad index: %i", index );
	}
	return cgs.gameState.stringData + cgs.gameState.stringOffsets[ index ];
}

//==================================================================

/*
======================
CG_StartMusic

======================
*/
void CG_StartMusic( void ) {
	char	*s;
	char	parm1[MAX_QPATH], parm2[MAX_QPATH];

	// start the background music
	s = (char *)CG_ConfigString( CS_MUSIC );
	Q_strncpyz( parm1, COM_Parse( &s ), sizeof( parm1 ) );
	Q_strncpyz( parm2, COM_Parse( &s ), sizeof( parm2 ) );

	trap_S_StartBackgroundTrack( parm1, parm2 );
}


/*
=================
CG_Init

Called after every level change or subsystem restart
Will perform callbacks to make the loading info screen update.
=================
*/
void CG_Init( int serverMessageNum, int serverCommandSequence ) {
	const char	*s;

	// clear everything
	memset( &cgs, 0, sizeof( cgs ) );
	memset( &cg, 0, sizeof( cg ) );
	memset( cg_entities, 0, sizeof(cg_entities) );
	memset( cg_weapons, 0, sizeof(cg_weapons) );
	memset( cg_items, 0, sizeof(cg_items) );

	cgs.processedSnapshotNum = serverMessageNum;
	cgs.serverCommandSequence = serverCommandSequence;

	// load a few needed things before we do any screen updates
	cgs.media.charsetShader = trap_R_RegisterShader( "gfx/2d/bigchars" );
	cgs.media.whiteShader = trap_R_RegisterShader( "white" );
	cgs.media.charsetProp		= trap_R_RegisterShaderNoMip( "menu/art/font1_prop.tga" );
	cgs.media.charsetPropGlow	= trap_R_RegisterShaderNoMip( "menu/art/font1_prop_glo.tga" );
	cgs.media.charsetPropB	= trap_R_RegisterShaderNoMip( "menu/art/font2_prop.tga" );

	CG_RegisterCvars();
// q3app
        forceModificationCount = cg_force.modificationCount;
        cg.plNotifyTime = 0;

// q3app
        CG_ParseCvars( qtrue );
        
	CG_InitConsoleCommands();

	cg.weaponSelect = WP_MACHINEGUN;

	cgs.redflag = cgs.blueflag = -1; // For compatibily, default to unset for
	// old servers

	// get the rendering configuration from the client system
	trap_GetGlconfig( &cgs.glconfig );
	cgs.screenXScale = cgs.glconfig.vidWidth / 640.0;
	cgs.screenYScale = cgs.glconfig.vidHeight / 480.0;

	// get the gamestate from the client system
	trap_GetGameState( &cgs.gameState );

	// check version
	s = CG_ConfigString( CS_GAME_VERSION );
	if ( strcmp( s, GAME_VERSION ) ) {
		CG_Error( "Client/Server game mismatch: %s/%s", GAME_VERSION, s );
	}

	s = CG_ConfigString( CS_LEVEL_START_TIME );
	cgs.levelStartTime = atoi( s );

	CG_ParseServerinfo();

	// load the new map
	CG_LoadingString( "collision map" );

	trap_CM_LoadMap( cgs.mapname );

	cg.loading = qtrue;		// force players to load instead of defer

	CG_LoadingString( "sounds" );

	CG_RegisterSounds();

	CG_RegisterGraphics();

	CG_RegisterClients();		// if low on memory, some clients will be deferred

	cg.loading = qfalse;	// future players will be deferred

	CG_InitLocalEntities();

	CG_InitMarkPolys();

	// remove the last loading update
	cg.infoScreenText[0] = 0;

	// Make sure we have update values (scores)
	CG_SetConfigValues();

	CG_StartMusic();

	CG_LoadingString( "" );
}

/*
=================
CG_Shutdown

Called before every level change or subsystem restart
=================
*/
void CG_Shutdown( void ) {
	// some mods may need to do cleanup work here,
	// like closing files or archiving session data
}


