// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=============================================================================

START SERVER MENU *****

=============================================================================
*/


#include "ui_local.h"
static char oldcurrentmap[64];
static char oldcurrentmap2[64];
static char newcurrentmap[64];
static int addmapvalue;
static int nummaps;
#define GAMESERVER_ADD0           "menu/art/add_0"
#define GAMESERVER_ADD1           "menu/art/add_1"
#define GAMESERVER_BACK0		"menu/art/back_0"
#define GAMESERVER_BACK1		"menu/art/back_1"
#define GAMESERVER_NEXT0		"menu/art/next_0"
#define GAMESERVER_NEXT1		"menu/art/next_1"
#define GAMESERVER_FRAMEL		"menu/art/frame2_l"
#define GAMESERVER_FRAMER		"menu/art/frame1_r"
#define GAMESERVER_SELECT		"menu/art/maps_select"
#define GAMESERVER_SELECTED        "menu/art/maps_selected"
#define GAMESERVER_FIGHT0		"menu/art/fight_0"
#define GAMESERVER_FIGHT1		"menu/art/fight_1"
#define GAMESERVER_UNKNOWNMAP	"menu/art/unknownmap"
#define GAMESERVER_ARROWS		"menu/art/gs_arrows_0"
#define GAMESERVER_ARROWSL		"menu/art/gs_arrows_l"
#define GAMESERVER_ARROWSR		"menu/art/gs_arrows_r"
#define GAMESERVER_GO              "menu/go"
#define GAMESERVER_GO2              "menu/go2"

#define MAX_MAPROWS         4 // up-down
#define MAX_MAPCOLS         4 // left-right
#define MAX_MAPSPERPAGE     12 // 12
#define MAX_LISTMODEMAPROWS        17 // 24
#define MAX_LISTMODEMAPCOLS		2
#define MAX_LISTMODEMAPSPERPAGE    34 // 48

#define	MAX_SERVERSTEXT	8192

#define MAX_SERVERMAPS      1024
#define MAX_NAMELENGTH	16

#define ID_GAMETYPE				10
#define ID_PREVPAGE                       16
#define ID_NEXTPAGE				12
#define ID_STARTSERVERBACK		13
#define ID_STARTSERVERNEXT		14
#define ID_LISTMODE				15
#define ID_PICTURES                       11     // etc
#define ID_MAPSOURCE               17
#define ID_GO2                     18
#define ID_RANDOMBOTS              19
#define ID_ADDMAP                  26
#define ID_ADDMAP2                 27
#define ID_ALLMAPS                               28
#define ID_SPECTATOR               29
#define ID_RECORD                  30


#define ID_PLAYER_TYPE			20
#define ID_MAXCLIENTS			21
#define ID_DEDICATED			22
#define ID_GO					23
#define ID_BACK					24
#define ID_CLEAR                                 25

#define PLAYER_SLOTS			12

typedef struct {
	menuframework_s	menu;

	menuradiobutton_s	listmode;
       menuradiobutton_s    allmaps;
	menutext_s		maplistmode[MAX_LISTMODEMAPSPERPAGE];

	menutext_s		banner;
       menutext_s           banner2;
       menutext_s           banner3;
       menutext_s           banner4;
       menutext_s           banner5;
       menutext_s           banner6;
       menutext_s           banner7;
       menutext_s           banner8;
       menutext_s           banner9;
       menutext_s           banner10;
	menulist_s		gametype;
	menubitmap_s	mappics[MAX_MAPSPERPAGE];
       menubitmap_s  mappics2;
       menutext_s           listmapname;
	menubitmap_s	mapbuttons[MAX_MAPSPERPAGE];
	menubitmap_s	arrows;
	menubitmap_s	prevpage;
	menubitmap_s	nextpage;
	menubitmap_s	back;
       menubitmap_s  go;
	menubitmap_s	next;

	menutext_s		mapname;
       menutext_s           mapname2;
       menutext_s           pagenum;
       menubitmap_s         pagenum2;
	menubitmap_s	item_null;

	qboolean		multiplayer;
	int				currentmap;
	int				nummaps;
	int				page;
	int				maxpages;
       menubitmap_s                         add;
       char                 maplist[MAX_SERVERMAPS][MAX_NAMELENGTH];
//       char                 maplist2[MAX_SERVERMAPS][MAX_NAMELENGTH];
       char                 maplist2[MAX_SERVERMAPS][32];
	int				mapGamebits[MAX_SERVERMAPS];
	menulist_s		mapsource;
	menufield_s		filter;

} startserver_t;
typedef struct {
	menuframework_s		menu;

	menutext_s			banner;

	menubitmap_s		mappic;
	menubitmap_s		picframe;
	menulist_s			dedicated;
	menufield_s			timelimit;
	menufield_s			fraglimit;
	menufield_s			flaglimit;
       menufield_s                 maplist;
	menuradiobutton_s	friendlyfire;
	menufield_s			hostname;
//       menuradiobutton_s    pure;
	menulist_s			botSkill;

	menutext_s			player0;
       menutext_s                  mapname;
	menulist_s			playerType[PLAYER_SLOTS];
	menutext_s			playerName[PLAYER_SLOTS];
       menutext_s                  oldplayerName[PLAYER_SLOTS];
	menulist_s			playerTeam[PLAYER_SLOTS];

	menubitmap_s		go;
	menubitmap_s		next;
	menubitmap_s		back;

	qboolean			multiplayer;
	int					gametype;
	char				mapnamebuffer[32];
       char                        mapnamebuffer2[32];
       char                        pagenumbuffer[32];
	char				playerNameBuffers[PLAYER_SLOTS][16];

	qboolean			newBot;
	int					newBotIndex;
	char				newBotName[16];
       menuradiobutton_s    randombot;
       menuradiobutton_s    spectator;
       menuradiobutton_s    record;
       menutext_s           clear;
       menutext_s           addmap;
} serveroptions_t;

static serveroptions_t s_serveroptions;


static startserver_t s_startserver;

static const char *gametype_items[] = {
	"Free For All",
	"Team Deathmatch",
	"Tournament",
	"Capture the Flag",
	0
};

static int gametype_remap[] = {GT_FFA, GT_TEAM, GT_TOURNAMENT, GT_CTF};
static int gametype_remap2[] = {0, 2, 0, 1, 3};

#define MS_ALL_MAPS		 0
#define MS_ID_MAPS		 1
#define MS_ADDON_MAPS	 2
#define MS_ID_MAPS2          3
#define MS_NEW_MAPS          4

static const char *mapsource_items[] = {
	"All Maps",
	"id Maps",
	"Addon Maps",
       "Fav. Maps",
       "New Maps",
	0
};

static char *s_idmaps[] = {
       "q3dm0",
       "q3dm1",
	"q3dm2",
	"q3dm3",
	"q3dm4",
	"q3dm5",
	"q3dm6",
	"q3dm7",
	"q3dm8",
	"q3dm9",
	"q3dm10",
	"q3dm11",
	"q3dm12",
	"q3dm13",
	"q3dm14",
	"q3dm15",
	"q3dm16",
	"q3dm17",
	"q3dm18",
	"q3dm19",
	"q3tourney1",
	"q3tourney2",
	"q3tourney3",
	"q3tourney4",
	"q3tourney5",
	"q3tourney6",
	"q3ctf1",
	"q3ctf2",
	"q3ctf3",
	"q3ctf4",
       "q3tourney6_ctf",
       "mpq3tourney6",
       "mptourney4",
       "mptourney3",
       "mptourney2",
       "mptourney1",
       "mpq3ctf1",
       "mpq3ctf2",
       "mpq3ctf3",
       "mpq3ctf4",
       "mpteam1",
       "mpteam2",
       "mpteam3",
       "mpteam4",
       "mpteam5",
       "mpteam6",
       "mpteam7",
       "mpteam8",
       "mpterra1",
       "mpterra2",
       "mpterra3",
	"test_bigbox",
       NULL
};

// Proj
static int s_mappage[GT_MAX_GAME_TYPE];
static int s_map[GT_MAX_GAME_TYPE];

static void UI_ServerOptionsMenu( qboolean multiplayer );
static void PlayerName_Draw( void *item );

// Proj
#define FILE_BUFFER2 32768
static char     server_script2[FILE_BUFFER2];

#define MAX_FAVMAPS 1024
#define MAX_NEWMAPS 1024
#define MAX_REMMAPS 1024
static int num_NewMaps = 0;
static char *s_newmaps[MAX_NEWMAPS];
static int num_FavMaps = 0;
static char *s_favmaps[MAX_FAVMAPS];
static int num_RemMaps = 0;
static char *s_remmaps[MAX_REMMAPS];

// Proj
static int           com_lines2;
static char *SkipWhitespace2( char *data, qboolean *hasNewLines ) {
	int c;

	while( (c = *data) <= ' ') {
		if( !c ) {
			return NULL;
		}
		if( c == '\n' ) {
                     com_lines2++;
			*hasNewLines = qtrue;
		}
		data++;
	}

	return data;
}

qboolean StartServer_LoadFromFile2( const char* filename)
{
        fileHandle_t    handle;
        char *text_p;
        char *token;
        char *save;     // Hypo
        qboolean newline = qfalse;      // Hypo
        int             len;

        len = trap_FS_FOpenFile(filename, &handle, FS_READ);
        if (len <= 0)
        {
                Com_Printf("Config file not found: %s\n", filename);
                return qfalse;
        }

        if (len >= FILE_BUFFER2)
                len = FILE_BUFFER2 - 1;

        trap_FS_Read(server_script2, len, handle);
        server_script2[len] = 0;
        trap_FS_FCloseFile(handle);
        text_p = server_script2;
        save = text_p;

        num_FavMaps = 0;
        num_NewMaps = 0;
        num_RemMaps = 0;
        while ( 1 ) {
              token = COM_Parse(&text_p);
              if (!token || !token[0]) {        // Hypo
                        return qtrue;
              }

              // find the start of the next token
              // so we don't leave text_p on a '\0' char
              text_p = SkipWhitespace2(text_p, &newline);

              if (num_FavMaps < MAX_FAVMAPS)
              {
                     if( Q_stricmp( token, "[fav]" ) == 0 )
                            continue;
                     if( Q_stricmp( token, "[new]" ) == 0 )
                            break;
                     strcpy(save, token);
                     s_favmaps[num_FavMaps++] = save;
                     save += strlen(token) + 1;
              }
              else {
                     break;
              }
        }

        while ( 1 ) {
              token = COM_Parse(&text_p);
              if (!token || !token[0]) {        // Hypo
                        return qtrue;
              }

              // find the start of the next token
              // so we don't leave text_p on a '\0' char
              text_p = SkipWhitespace2(text_p, &newline);

              if (num_NewMaps < MAX_NEWMAPS)
              {
                     if( Q_stricmp( token, "[new]" ) == 0 )
                            continue;
                     if( Q_stricmp( token, "[remove]" ) == 0 )
                            break;
                     strcpy(save, token);
                     s_newmaps[num_NewMaps++] = save;
                     save += strlen(token) + 1;
              }
              else {
                     break;
              }
        }
        while ( 1 ) {
              token = COM_Parse(&text_p);
              if (!token || !token[0]) {        // Hypo
                        return qtrue;
              }

              // find the start of the next token
              // so we don't leave text_p on a '\0' char
              text_p = SkipWhitespace2(text_p, &newline);

              if (num_RemMaps < MAX_REMMAPS)
              {
                     if( Q_stricmp( token, "[remove]" ) == 0 )
                            continue;
                     strcpy(save, token);
                     s_remmaps[num_RemMaps++] = save;
                     save += strlen(token) + 1;
              }
              else {
                     break;
              }
        }
        return qtrue;
}

/*
=================
GametypeBits
=================
*/
static int GametypeBits( char *string ) {
	int		bits;
	char	*p;
	char	*token;

	bits = 0;
	p = string;
	while( 1 ) {
		token = COM_ParseExt( &p, qfalse );
		if( token[0] == 0 ) {
			break;
		}
              if (s_startserver.allmaps.curvalue)
              {
                     if( Q_stricmp( token, "ctf" ) == 0 ) {
                            bits |= 1 << GT_CTF;
                     }
                     if( Q_stricmp( token, "ffa" ) == 0 || Q_stricmp( token, "ctf" ) == 0 || Q_stricmp( token, "team" ) == 0 || Q_stricmp( token, "tourney" ) == 0)  {
                            bits |= 1 << GT_FFA;
                            bits |= 1 << GT_TOURNAMENT;
                            bits |= 1 << GT_TEAM;
                            continue;
                     }
                     /*
                     if( Q_stricmp( token, "ffa" ) == 0 || Q_stricmp( token, "ctf" ) == 0 || Q_stricmp( token, "team" ) == 0 || Q_stricmp( token, "tourney" ) == 0)  {
                            bits |= 1 << GT_TOURNAMENT;
                            continue;
                     }
                     if( Q_stricmp( token, "ffa" ) == 0 || Q_stricmp( token, "ctf" ) == 0 || Q_stricmp( token, "team" ) == 0 || Q_stricmp( token, "tourney" ) == 0)  {
                            bits |= 1 << GT_TEAM;
                            continue;
                     }
                     */
                     /*
                     if( Q_stricmp( token, "ctf" ) == 0 ) {
                            bits |= 1 << GT_CTF;
                            continue;
                     }
                     */
              }
              else
              {
              if( Q_stricmp( token, "ffa" ) == 0)  {
			bits |= 1 << GT_FFA;
			continue;
		}
		if( Q_stricmp( token, "tourney" ) == 0 ) {
			bits |= 1 << GT_TOURNAMENT;
			continue;
		}

		if( Q_stricmp( token, "single" ) == 0 ) {
			bits |= 1 << GT_SINGLE_PLAYER;
			continue;
		}

		if( Q_stricmp( token, "team" ) == 0 ) {
			bits |= 1 << GT_TEAM;
			continue;
		}
		if( Q_stricmp( token, "ctf" ) == 0 ) {
			bits |= 1 << GT_CTF;
			continue;
		}
              }
	}
       /*
       if (ui_allmaps.integer)
       {
              bits |= 1 << GT_FFA;
              bits |= 1 << GT_TOURNAMENT;
              bits |= 1 << GT_TEAM;
              bits |= 1 << GT_CTF;
       }
       */
	return bits;
}


/*
=================
StartServer_Update
=================
*/
static void StartServer_Update( void ) {
       int                         i,j;
       int                         listmode;
	int				top;
	static	char	picname[MAX_MAPSPERPAGE][64];
       static char   picname2[64];

	listmode = s_startserver.listmode.curvalue;
	if (listmode) {
              top = s_startserver.page*MAX_LISTMODEMAPSPERPAGE;
		for (j=0; j<MAX_LISTMODEMAPSPERPAGE; j++)
		{
			if (top+j >= s_startserver.nummaps)
				break;
			s_startserver.maplistmode[j].string	= s_startserver.maplist[top+j];
                     s_startserver.maplistmode[j].generic.flags = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
			s_startserver.maplistmode[j].color	= color_orange;

		}
              Com_sprintf( picname2, 64, "levelshots/%s", s_startserver.maplist[s_startserver.currentmap] );
              s_startserver.mappics2.generic.name   = picname2;
              s_startserver.mappics2.shader         = 0;

		i = 0;
	} else {
		top = s_startserver.page*MAX_MAPSPERPAGE;
		for (i=0; i<MAX_MAPSPERPAGE; i++)
		{
			if (top+i >= s_startserver.nummaps)
				break;

			Com_sprintf( picname[i], sizeof(picname[i]), "levelshots/%s", s_startserver.maplist[top+i] );

                     s_startserver.mappics[i].generic.flags &= ~QMF_HIGHLIGHT;
                     s_startserver.mappics[i].generic.name   = picname[i];
                     s_startserver.mappics[i].shader         = 0;

			// reset
			s_startserver.mapbuttons[i].generic.flags |= QMF_PULSEIFFOCUS;
			s_startserver.mapbuttons[i].generic.flags &= ~QMF_INACTIVE;
		}
		j = 0;
	}

	for (; i<MAX_MAPSPERPAGE; i++)
	{
		s_startserver.mappics[i].generic.flags &= ~QMF_HIGHLIGHT;
		s_startserver.mappics[i].generic.name   = NULL;
		s_startserver.mappics[i].shader         = 0;

		// disable
		s_startserver.mapbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;
		s_startserver.mapbuttons[i].generic.flags |= QMF_INACTIVE;
	}
	for (; j<MAX_LISTMODEMAPSPERPAGE; j++)
	{
		s_startserver.maplistmode[j].generic.flags &= ~QMF_HIGHLIGHT;
		s_startserver.maplistmode[j].string   = NULL;
		s_startserver.maplistmode[j].generic.flags &= ~QMF_PULSEIFFOCUS;
		s_startserver.maplistmode[j].generic.flags |= QMF_INACTIVE;
	}


	// no servers to start
	if( !s_startserver.nummaps ) {
		s_startserver.next.generic.flags |= QMF_INACTIVE;

		// set the map name
		strcpy( s_startserver.mapname.string, "NO MAPS FOUND" );
	}
	else {
		// set the highlight
		s_startserver.next.generic.flags &= ~QMF_INACTIVE;
		i = s_startserver.currentmap - top;
              j = s_startserver.currentmap - top;
		if (listmode) {
                     if ( j >=0 && j < MAX_LISTMODEMAPSPERPAGE ) 
			{
                            s_startserver.maplistmode[j].generic.flags &= ~QMF_PULSEIFFOCUS;
                            s_startserver.maplistmode[j].generic.flags |= QMF_INACTIVE;
			}
		} else {
			if ( i >=0 && i < MAX_MAPSPERPAGE ) 
			{
				s_startserver.mappics[i].generic.flags    |= QMF_HIGHLIGHT;
				s_startserver.mapbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;
			}
		}

		// set the map name
//              strcpy( s_startserver.mapname.string, s_startserver.maplist[s_startserver.currentmap] );
              strcpy( s_startserver.mapname.string, s_startserver.maplist2[s_startserver.currentmap] );
              strcpy( s_startserver.mapname2.string, s_startserver.maplist[s_startserver.currentmap] );
	}
	
      Q_strupr( s_startserver.mapname.string );
      Q_strupr( s_startserver.mapname2.string );
//      Com_sprintf( s_startserver.pagenum.string, 15, "Page %d / %d", s_startserver.page+1, s_startserver.maxpages );
}


/*
=================
StartServer_MapEvent
=================
*/
static void StartServer_MapEvent( void* ptr, int event ) {
       int listmode;
       listmode = s_startserver.listmode.curvalue;

	if( event != QM_ACTIVATED) {
		return;
	}
       if (listmode)
              s_startserver.currentmap = (s_startserver.page*MAX_LISTMODEMAPSPERPAGE) + (((menucommon_s*)ptr)->id - ID_PICTURES);
       else
              s_startserver.currentmap = (s_startserver.page*MAX_MAPSPERPAGE) + (((menucommon_s*)ptr)->id - ID_PICTURES);
       s_map[s_startserver.gametype.curvalue] = s_startserver.currentmap;
	StartServer_Update();
}


static void RefreshMapList()
{
	int			i;
	int			count;
       int                  listmode;
	int			gamebits;
	int			matchbits;
	const char	*info;
	static qboolean bfirsttime = qtrue;
       char mapname[64];
//       char mapname2[64];

       listmode = s_startserver.listmode.curvalue;
	if (bfirsttime) {
		for (i = 0; i < GT_MAX_GAME_TYPE; i++) {
			s_mappage[i] = 0;
			s_map[i] = 0;
		}
		bfirsttime = qfalse;
	}

	count = UI_GetNumArenas();
	s_startserver.nummaps = 0;
	matchbits = 1 << gametype_remap[s_startserver.gametype.curvalue];
	if( gametype_remap[s_startserver.gametype.curvalue] == GT_FFA ) {
		matchbits |= ( 1 << GT_SINGLE_PLAYER );
	}
	for( i = 0; i < count; i++ ) {
		char *filter = s_startserver.filter.field.buffer;
		char *p;

		info = UI_GetArenaInfoByNumber( i );
              strcpy(mapname, Info_ValueForKey(info, "map"));
//              strcpy(mapname2, Info_ValueForKey(info, "longname"));

		p = mapname;
		while (*p) {
			*p = tolower(*p);
			p++;
		}
		
		if (filter[0] != '\0') {
			if (strstr(mapname, filter) == NULL) {
				continue;
			}
		}

		gamebits = GametypeBits( Info_ValueForKey( info, "type") );
		if( !( gamebits & matchbits ) ) {
			continue;
		}

              if (s_startserver.mapsource.curvalue != MS_ALL_MAPS) {
			char **idmapname = s_idmaps;
			qboolean idmap = qfalse;

                     while (*idmapname != NULL) {
				if (strcmp(mapname, *idmapname) == 0) {
					idmap = qtrue;
					break;
				}
                            idmapname++;
                     }
			if ((s_startserver.mapsource.curvalue == MS_ID_MAPS && !idmap) ||
				(s_startserver.mapsource.curvalue == MS_ADDON_MAPS && idmap)) {
				continue;
			}
		}
              if (s_startserver.mapsource.curvalue == MS_ID_MAPS2) {
                     int count;
                     char **idmapname2 = s_favmaps;
                     qboolean idmap2 = qfalse;

                     while (*idmapname2 != NULL) {
                            if (Q_stricmp(mapname, *idmapname2) == 0) {
                                   idmap2 = qtrue;
					break;
				}
                            idmapname2++;
                     }
                     if ((s_startserver.mapsource.curvalue == MS_ID_MAPS2 && !idmap2) ||
                            (s_startserver.mapsource.curvalue == MS_ADDON_MAPS && idmap2)) {
				continue;
			}
		}
              if (s_startserver.mapsource.curvalue == MS_NEW_MAPS) {
                     int count;
                     char **idmapname3 = s_newmaps;
                     qboolean idmap3 = qfalse;

                     while (*idmapname3 != NULL) {
                            if (Q_stricmp(mapname, *idmapname3) == 0) {
                                   idmap3 = qtrue;
                                   break;
				}
                            idmapname3++;
                     }
                     if ((s_startserver.mapsource.curvalue == MS_NEW_MAPS && !idmap3) ||
                            (s_startserver.mapsource.curvalue == MS_ADDON_MAPS && idmap3)) {
                            continue;
                     }
//                    if (s_startserver.mapsource.curvalue == MS_NEW_MAPS && idmap3)
//                     continue;
		}
              if (s_startserver.mapsource.curvalue == MS_ALL_MAPS || s_startserver.mapsource.curvalue == MS_ID_MAPS || s_startserver.mapsource.curvalue == MS_ADDON_MAPS) {
                     char **idmapname5 = s_remmaps;
                     qboolean idmap5 = qfalse;

                     while (*idmapname5 != NULL) {
                            if (strcmp(mapname, *idmapname5) == 0) {
                                   idmap5 = qtrue;
                                   break;
                            }
                            idmapname5++;
                     }
                     if ((s_startserver.mapsource.curvalue == MS_ALL_MAPS || s_startserver.mapsource.curvalue == MS_ID_MAPS || s_startserver.mapsource.curvalue == MS_ADDON_MAPS ) && idmap5)
                            continue;
		}
              Q_strncpyz( s_startserver.maplist[s_startserver.nummaps], Info_ValueForKey( info, "map"), MAX_NAMELENGTH );
              Q_strncpyz( s_startserver.maplist2[s_startserver.nummaps], Info_ValueForKey( info, "longname"), 32 );

		Q_strupr( s_startserver.maplist[s_startserver.nummaps] );
              Q_strupr( s_startserver.maplist2[s_startserver.nummaps] );
		s_startserver.mapGamebits[s_startserver.nummaps] = gamebits;
		s_startserver.nummaps++;
	}
       if (listmode)
              s_startserver.maxpages = (s_startserver.nummaps + MAX_LISTMODEMAPSPERPAGE-1)/MAX_LISTMODEMAPSPERPAGE;
       else
              s_startserver.maxpages = (s_startserver.nummaps + MAX_MAPSPERPAGE-1)/MAX_MAPSPERPAGE;
	s_startserver.page = s_mappage[s_startserver.gametype.curvalue];
	s_startserver.currentmap = s_map[s_startserver.gametype.curvalue];
	s_startserver.page = 0;

	StartServer_Update();
}

/*
=================
StartServer_GametypeEvent
=================
*/
static void StartServer_GametypeEvent( void* ptr, int event ) 
{
	if( event != QM_ACTIVATED) {
		return;
	}
	RefreshMapList();
       if (s_startserver.gametype.curvalue == 3)
       {
              s_startserver.allmaps.generic.flags      = QMF_GRAYED|QMF_SMALLFONT;
       }
       else
       {
              s_startserver.allmaps.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       }
}

/*
=================
StartServer_MapSourceEvent
=================
*/
static void StartServer_MapSourceEvent( void* ptr, int event ) 
{
	if( event != QM_ACTIVATED) {
		return;
	}

	RefreshMapList();
}

/*
=================
StartServer_FilterEvent
=================
*/
static void StartServer_FilterEvent( void* ptr, int event ) 
{
	char *p;

	if( event != QM_EDITCHANGED) {
		return;
	}

	p = s_startserver.filter.field.buffer;
	while (*p) {
		*p = tolower(*p);
		p++;
	}

	RefreshMapList();
}


/*
=================
StartServer_MenuEvent
=================
*/
static void StartServer_MenuEvent( void* ptr, int event ) {
       int i;
       char temp[64], *pos, *pos2;
	if( event != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_PREVPAGE:
		s_startserver.page = (s_startserver.page + s_startserver.maxpages - 1) % s_startserver.maxpages;
		s_mappage[s_startserver.gametype.curvalue] = s_startserver.page;
		StartServer_Update();
		break;

	case ID_NEXTPAGE:
		s_startserver.page = (s_startserver.page + 1) % s_startserver.maxpages;
		s_mappage[s_startserver.gametype.curvalue] = s_startserver.page;
		StartServer_Update();
		break;

	case ID_LISTMODE:
		if (s_startserver.listmode.curvalue) {
                     s_startserver.mappics2.generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE|QMF_HIGHLIGHT;
			s_startserver.maxpages = (s_startserver.nummaps + MAX_LISTMODEMAPSPERPAGE-1)/MAX_LISTMODEMAPSPERPAGE;
			s_startserver.page = 0;
		} else {
                     s_startserver.mappics2.generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE|QMF_HIGHLIGHT|QMF_HIDDEN;
			s_startserver.maxpages = (s_startserver.nummaps + MAX_MAPSPERPAGE-1)/MAX_MAPSPERPAGE;
			s_startserver.page = 0;
		}
		StartServer_Update();
		break;

       case ID_ALLMAPS:
              if (s_startserver.allmaps.curvalue)
                     trap_Cvar_SetValue("ui_allmaps", 0);
              else
                     trap_Cvar_SetValue("ui_allmaps", 1);
              RefreshMapList();
              break;

	case ID_STARTSERVERNEXT:
              trap_Cvar_SetValue( "ui_gametype", s_startserver.gametype.curvalue);
              trap_Cvar_SetValue( "ui_mapsource", s_startserver.mapsource.curvalue);
              trap_Cvar_SetValue( "ui_listmode", s_startserver.listmode.curvalue);
		trap_Cvar_SetValue( "g_gameType", gametype_remap[s_startserver.gametype.curvalue] );
              trap_Cvar_SetValue("ui_allmaps", s_startserver.allmaps.curvalue);
		UI_ServerOptionsMenu( s_startserver.multiplayer );
		break;

       case ID_ADDMAP:
              Q_strncpyz( newcurrentmap, s_startserver.maplist[s_startserver.currentmap], 64 );
              Q_strncpyz( s_startserver.maplist[s_startserver.currentmap],oldcurrentmap, 64 );
              Q_strncpyz( s_startserver.maplist2[s_startserver.currentmap],oldcurrentmap2, 64 );
              strcpy( s_startserver.mapname.string, s_startserver.maplist2[s_startserver.currentmap] );
              strcpy( s_startserver.mapname2.string, s_startserver.maplist[s_startserver.currentmap] );
              Q_strupr( s_startserver.mapname.string );
              Q_strupr( s_startserver.mapname2.string );
              strcpy( s_serveroptions.mapnamebuffer2, s_startserver.mapname2.string );
              strcpy( s_serveroptions.mapnamebuffer, s_startserver.mapname.string );
              Q_strupr( s_serveroptions.mapnamebuffer2 );
              Q_strupr( s_serveroptions.mapnamebuffer );
              UI_ServerOptionsMenu( s_startserver.multiplayer );
              if (s_serveroptions.maplist.field.buffer[0] != '\0')
                     Q_strcat(s_serveroptions.maplist.field.buffer,256,";");
              Q_strcat(s_serveroptions.maplist.field.buffer,256, newcurrentmap);
		break;

       case ID_GO2:
              RefreshMapList();
		break;

	case ID_STARTSERVERBACK:
              if (addmapvalue == 1)
              {
                     Q_strncpyz( s_startserver.maplist[s_startserver.currentmap],oldcurrentmap, 64 );
                     Q_strncpyz( s_startserver.maplist2[s_startserver.currentmap],oldcurrentmap2, 64 );
                     strcpy( s_startserver.mapname.string, s_startserver.maplist2[s_startserver.currentmap] );
                     strcpy( s_startserver.mapname2.string, s_startserver.maplist[s_startserver.currentmap] );
                     Q_strupr( s_startserver.mapname.string );
                     Q_strupr( s_startserver.mapname2.string );
                     strcpy( s_serveroptions.mapnamebuffer2, s_startserver.mapname2.string );
                     strcpy( s_serveroptions.mapnamebuffer, s_startserver.mapname.string );
                     Q_strupr( s_serveroptions.mapnamebuffer2 );
                     Q_strupr( s_serveroptions.mapnamebuffer );
                     UI_ServerOptionsMenu( s_startserver.multiplayer );
              }
              else
                     UI_PopMenu();
		break;
	}
}


/*
===============
StartServer_LevelshotDraw
===============
*/
static void StartServer_LevelshotDraw( void *self ) {
	menubitmap_s	*b;
	int				x;
	int				y;
	int				w;
	int				h;
       int                         n,m;
       int                         stringcount;
       int                         z=106;
       char *p, *pos;
       int count;
       char mystring[255];
       char mystring2[255];
       char mystring3[255];

	b = (menubitmap_s *)self;

	if( !b->generic.name ) {
		return;
	}

	if( b->generic.name && !b->shader ) {
		b->shader = trap_R_RegisterShaderNoMip( b->generic.name );
		if( !b->shader && b->errorpic ) {
			b->shader = trap_R_RegisterShaderNoMip( b->errorpic );
		}
	}

	if( b->focuspic && !b->focusshader ) {
		b->focusshader = trap_R_RegisterShaderNoMip( b->focuspic );
	}

       x = b->generic.x;
       y = b->generic.y;
	w = b->width;
       h = b->height;
	if( b->shader ) {
		UI_DrawHandlePic( x, y, w, h, b->shader );
	}

       x = b->generic.x;
       y = b->generic.y + b->height; // b->height
       UI_FillRect( x, y, b->width, 28, colorBlack ); // 28

       x += b->width / 2; // 2
       y += 4; // 4
	n = s_startserver.page * MAX_MAPSPERPAGE + b->generic.id - ID_PICTURES;
       if (s_startserver.listmode.curvalue == 1)
              UI_DrawString( x, y, s_startserver.maplist[s_startserver.currentmap], UI_CENTER|UI_SMALLFONT, color_orange );
       else
              UI_DrawString( x, y, s_startserver.maplist[n], UI_CENTER|UI_SMALLFONT, color_orange );
/*
       strcpy( mystring, s_startserver.maplist2[n] );
       for (m = 0; m < 64; m++)
       {
                if (m <= 15)
                     mystring2[m] = mystring[m];
                if (m >= 16 && strlen(mystring) >= 17)
                     mystring3[m-16] = mystring[m];
       }
       UI_DrawString( x, y-66, mystring2, UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW, color_orange );
       if (strlen(mystring) >= 17)
             UI_DrawString( x, y-46, mystring3, UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW, color_orange );
       stringcount = strlen(mystring);
       if (strlen(mystring) >= 17)
       {
       p = (char *)strtok(mystring," \n\r");
       if (p)
              pos = (char *)strtok(NULL," \n\r");
	else
              pos = NULL;
              while( p != NULL)
              {
                     if (count > 0)
                            z -= 16;
                     if (pos && stringcount != count)
                            UI_DrawString( x, y-z, p, UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW, color_orange );
                     Com_Printf( "Token %d: %s\n", count, p );
                     p = pos;
                     if (p)
                            pos = (char *)strtok(NULL," \n\r");
                     ++count;
              }
       }
*/
       x = b->generic.x;
       y = b->generic.y;
       w = b->width;
       h = b->height + 28; // 28
	if( b->generic.flags & QMF_HIGHLIGHT ) {	
		UI_DrawHandlePic( x, y, w, h, b->focusshader );
	}
}

/*
=================
Startserver_SaveChanges
=================
*/
static void Startserver_SaveChanges( void ) {
       RefreshMapList();
}

/*
=================
Startserver_MenuKey
=================
*/
static sfxHandle_t Startserver_MenuKey( int key ) {
       switch(key)
       {
              case K_ENTER:
                     Startserver_SaveChanges();
                     break;
       }
       return Menu_DefaultKey( &s_startserver.menu, key );
}

static void Pagenum_Draw( void *self ) {
      UI_DrawProportionalString( 190, 430, s_startserver.pagenum.string , UI_CENTER|UI_SMALLFONT, color_orange );
}

/*
=================
StartServer_MenuInit
=================
*/
static void StartServer_MenuInit( int addmap) {
	int	i;
	int j;
	int k;
	int	x;
	int	y;
       int    num;
       vmCvar_t curlist;
       char temp2[64];
	static char mapnamebuffer[64];
       static char mapnamebuffer2[64];
       static char pagenumbuffer[64];

	// zero set all our globals
	memset( &s_startserver, 0 ,sizeof(startserver_t) );

       StartServer_Cache();

       s_startserver.menu.key        = Startserver_MenuKey;
	s_startserver.menu.wrapAround = qtrue;
	s_startserver.menu.fullscreen = qtrue;

	s_startserver.banner.generic.type  = MTYPE_BTEXT;
       s_startserver.banner.generic.x        = 30;
	s_startserver.banner.generic.y	   = 16;
       s_startserver.banner.string        = "G";
	s_startserver.banner.color         = color_white;
	s_startserver.banner.style         = UI_CENTER;

       s_startserver.banner2.generic.type  = MTYPE_BTEXT;
       s_startserver.banner2.generic.x        = 30;
       s_startserver.banner2.generic.y        = 51;
       s_startserver.banner2.string        = "A";
       s_startserver.banner2.color         = color_white;
       s_startserver.banner2.style         = UI_CENTER;

       s_startserver.banner3.generic.type  = MTYPE_BTEXT;
       s_startserver.banner3.generic.x        = 30;
       s_startserver.banner3.generic.y        = 86;
       s_startserver.banner3.string        = "M";
       s_startserver.banner3.color         = color_white;
       s_startserver.banner3.style         = UI_CENTER;

       s_startserver.banner4.generic.type  = MTYPE_BTEXT;
       s_startserver.banner4.generic.x        = 30;
       s_startserver.banner4.generic.y        = 121;
       s_startserver.banner4.string        = "E";
       s_startserver.banner4.color         = color_white;
       s_startserver.banner4.style         = UI_CENTER;

       s_startserver.banner5.generic.type  = MTYPE_BTEXT;
       s_startserver.banner5.generic.x        = 30;
       s_startserver.banner5.generic.y        = 191;
       s_startserver.banner5.string        = "S";
       s_startserver.banner5.color         = color_white;
       s_startserver.banner5.style         = UI_CENTER;

       s_startserver.banner6.generic.type  = MTYPE_BTEXT;
       s_startserver.banner6.generic.x        = 30;
       s_startserver.banner6.generic.y        = 226;
       s_startserver.banner6.string        = "E";
       s_startserver.banner6.color         = color_white;
       s_startserver.banner6.style         = UI_CENTER;

       s_startserver.banner7.generic.type  = MTYPE_BTEXT;
       s_startserver.banner7.generic.x        = 30;
       s_startserver.banner7.generic.y        = 261;
       s_startserver.banner7.string        = "R";
       s_startserver.banner7.color         = color_white;
       s_startserver.banner7.style         = UI_CENTER;

       s_startserver.banner8.generic.type  = MTYPE_BTEXT;
       s_startserver.banner8.generic.x        = 30;
       s_startserver.banner8.generic.y        = 296;
       s_startserver.banner8.string        = "V";
       s_startserver.banner8.color         = color_white;
       s_startserver.banner8.style         = UI_CENTER;

       s_startserver.banner9.generic.type  = MTYPE_BTEXT;
       s_startserver.banner9.generic.x        = 30;
       s_startserver.banner9.generic.y        = 331;
       s_startserver.banner9.string        = "E";
       s_startserver.banner9.color         = color_white;
       s_startserver.banner9.style         = UI_CENTER;

       s_startserver.banner10.generic.type  = MTYPE_BTEXT;
       s_startserver.banner10.generic.x        = 30;
       s_startserver.banner10.generic.y        = 366;
       s_startserver.banner10.string        = "R";
       s_startserver.banner10.color         = color_white;
       s_startserver.banner10.style         = UI_CENTER;

	s_startserver.gametype.generic.type		= MTYPE_SPINCONTROL;
	s_startserver.gametype.generic.name		= "Game Type:";
       if (addmap == 1)
       {
              addmapvalue = 1;
              s_startserver.gametype.generic.flags      = QMF_GRAYED|QMF_SMALLFONT;
       }
       else
       {
              addmapvalue = 0;
              s_startserver.gametype.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       }
	s_startserver.gametype.generic.callback	= StartServer_GametypeEvent;
	s_startserver.gametype.generic.id		= ID_GAMETYPE;
       s_startserver.gametype.generic.y          = 401;
       s_startserver.gametype.generic.x          = 100;
	s_startserver.gametype.itemnames		= gametype_items;

	s_startserver.filter.generic.type       = MTYPE_FIELD;
       s_startserver.filter.generic.name       = "Filter:";
	s_startserver.filter.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_startserver.filter.generic.callback	= StartServer_FilterEvent;
       s_startserver.filter.generic.x           = 320; // 300
       s_startserver.filter.generic.y           = 401;
	s_startserver.filter.field.widthInChars = 10;
	s_startserver.filter.field.maxchars     = 80;

       s_startserver.go.generic.type        = MTYPE_BITMAP;
       s_startserver.go.generic.name     = GAMESERVER_GO;
       s_startserver.go.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_startserver.go.generic.callback = StartServer_MenuEvent;
       s_startserver.go.generic.id          = ID_GO2;
       s_startserver.go.generic.x              = 410;
       s_startserver.go.generic.y              = 401;
       s_startserver.go.width               = 32;
       s_startserver.go.height              = 16;
       s_startserver.go.focuspic         = GAMESERVER_GO2;

	s_startserver.mapsource.generic.type		= MTYPE_SPINCONTROL;
	s_startserver.mapsource.generic.name		= "Map Source:";
	s_startserver.mapsource.generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_startserver.mapsource.generic.callback	= StartServer_MapSourceEvent;
	s_startserver.mapsource.generic.id			= ID_MAPSOURCE;
	s_startserver.mapsource.generic.x			= 640 - 100;
       s_startserver.mapsource.generic.y                = 401;
	s_startserver.mapsource.itemnames			= mapsource_items;

	j = 0;
	k = 0;
	for (i=0; i<MAX_MAPSPERPAGE; i++)
	{
              x =    j * (128+14) + 66;
              y = k * (128+4) + 8; // + 8
		j++;
		if (j >= MAX_MAPCOLS) {
			j = 0;
			k++;
		}
		s_startserver.mappics[i].generic.type   = MTYPE_BITMAP;
              s_startserver.mappics[i].generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
              s_startserver.mappics[i].generic.x     = x;
              s_startserver.mappics[i].generic.y     = y;
		s_startserver.mappics[i].generic.id		= ID_PICTURES+i;
              s_startserver.mappics[i].width            = 128; // 128
              s_startserver.mappics[i].height        = 96; // 96
		s_startserver.mappics[i].focuspic       = GAMESERVER_SELECTED;
		s_startserver.mappics[i].errorpic       = GAMESERVER_UNKNOWNMAP;
		s_startserver.mappics[i].generic.ownerdraw = StartServer_LevelshotDraw;

		s_startserver.mapbuttons[i].generic.type     = MTYPE_BITMAP;
		s_startserver.mapbuttons[i].generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS|QMF_NODEFAULTINIT;
		s_startserver.mapbuttons[i].generic.id       = ID_PICTURES+i;
		s_startserver.mapbuttons[i].generic.callback = StartServer_MapEvent;
		s_startserver.mapbuttons[i].generic.x	     = x - 30;
              s_startserver.mapbuttons[i].generic.y          = y - 32;
              s_startserver.mapbuttons[i].width                     = 256; // 256
              s_startserver.mapbuttons[i].height             = 248; // 248
		s_startserver.mapbuttons[i].generic.left     = x;
		s_startserver.mapbuttons[i].generic.top  	 = y;
              s_startserver.mapbuttons[i].generic.right    = x + 128; // 128
              s_startserver.mapbuttons[i].generic.bottom   = y + 128; // 128
		s_startserver.mapbuttons[i].focuspic         = GAMESERVER_SELECT;
	}

       j = 0;
       k = 0;
	for (i = 0; i<MAX_LISTMODEMAPSPERPAGE; i++)
	{
//              x =    j * 300 + 64;
//              y = k * 16 + 8;
              x =    j * 300 + 64;
              y = k * 16 + 125;
		j++;
		if (j >= MAX_LISTMODEMAPCOLS) {
                     s_startserver.maplistmode[i].style   = UI_RIGHT|UI_SMALLFONT; // UI_LEFT
                     s_startserver.maplistmode[i].generic.flags = QMF_INACTIVE|QMF_SILENT|QMF_RIGHT_JUSTIFY;
                     x =    j * 300 + 20; // + 10
			j = 0;
			k++;
		}
              else
              {
                     s_startserver.maplistmode[i].style   = UI_LEFT|UI_SMALLFONT; // UI_LEFT
                     s_startserver.maplistmode[i].generic.flags = QMF_INACTIVE|QMF_SILENT|QMF_LEFT_JUSTIFY;
              }
		s_startserver.maplistmode[i].generic.type  = MTYPE_PTEXT;
		s_startserver.maplistmode[i].generic.name   = NULL;
		s_startserver.maplistmode[i].string = "BLANK MAP ENTRY";
		s_startserver.maplistmode[i].generic.callback = StartServer_MapEvent;
		s_startserver.maplistmode[i].generic.x   = x;
		s_startserver.maplistmode[i].generic.y   = y;
		s_startserver.maplistmode[i].generic.id		= ID_PICTURES+i;
//              s_startserver.maplistmode[i].generic.flags = QMF_INACTIVE|QMF_SILENT;
//              s_startserver.maplistmode[i].style   = UI_LEFT|UI_SMALLFONT; // UI_LEFT
	}

              s_startserver.mappics2.generic.type   = MTYPE_BITMAP;
              s_startserver.mappics2.generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE|QMF_HIGHLIGHT|QMF_HIDDEN;
              s_startserver.mappics2.generic.x     = 256;
              s_startserver.mappics2.generic.y     = 0; // 300
              s_startserver.mappics2.generic.id              = 250;
              s_startserver.mappics2.width            = 128; // 128
              s_startserver.mappics2.height        = 96; // 96
              s_startserver.mappics2.focuspic       = GAMESERVER_SELECTED;
              s_startserver.mappics2.errorpic       = GAMESERVER_UNKNOWNMAP;
              s_startserver.mappics2.generic.ownerdraw = StartServer_LevelshotDraw;


	s_startserver.arrows.generic.type  = MTYPE_BITMAP;
	s_startserver.arrows.generic.name  = GAMESERVER_ARROWS;
	s_startserver.arrows.generic.flags = QMF_INACTIVE;
       s_startserver.arrows.generic.x        = 259; // 340
       s_startserver.arrows.generic.y        = 426;
	s_startserver.arrows.width  	   = 128;
	s_startserver.arrows.height  	   = 32;

	s_startserver.prevpage.generic.type	    = MTYPE_BITMAP;
	s_startserver.prevpage.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_startserver.prevpage.generic.callback = StartServer_MenuEvent;
	s_startserver.prevpage.generic.id	    = ID_PREVPAGE;
       s_startserver.prevpage.generic.x          = 259; // 340
       s_startserver.prevpage.generic.y          = 426;
	s_startserver.prevpage.width  		    = 64;
	s_startserver.prevpage.height  		    = 32;
	s_startserver.prevpage.focuspic         = GAMESERVER_ARROWSL;

	s_startserver.nextpage.generic.type	    = MTYPE_BITMAP;
	s_startserver.nextpage.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_startserver.nextpage.generic.callback = StartServer_MenuEvent;
	s_startserver.nextpage.generic.id	    = ID_NEXTPAGE;
       s_startserver.nextpage.generic.x          = 320; // 401
       s_startserver.nextpage.generic.y          = 426;
	s_startserver.nextpage.width  		    = 64;
	s_startserver.nextpage.height  		    = 32;
	s_startserver.nextpage.focuspic         = GAMESERVER_ARROWSR;

       s_startserver.allmaps.generic.type     = MTYPE_RADIOBUTTON;
       s_startserver.allmaps.generic.callback = StartServer_MenuEvent;
       s_startserver.allmaps.generic.id         = ID_ALLMAPS;
       s_startserver.allmaps.generic.flags    = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_startserver.allmaps.generic.x         = 208; // 200
       s_startserver.allmaps.generic.y         = 432; // 408
       s_startserver.allmaps.generic.name         = "All Maps:";

/*
       s_startserver.pagenum.generic.type  = MTYPE_PTEXT;
       s_startserver.pagenum.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_startserver.pagenum.generic.x        = 158; // 208
       s_startserver.pagenum.generic.y        = 430;
       s_startserver.pagenum.generic.x        = 343; // 208
       s_startserver.pagenum.generic.y        = 460;
       s_startserver.pagenum.string        = pagenumbuffer;
       s_startserver.pagenum.style         = UI_CENTER|UI_SMALLFONT;
       s_startserver.pagenum.color         = text_color_normal;

              s_startserver.pagenum2.generic.type   = MTYPE_BITMAP;
              s_startserver.pagenum2.generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
              s_startserver.pagenum2.generic.x     = x;
              s_startserver.pagenum2.generic.y     = y;
              s_startserver.pagenum2.generic.id              = ID_PICTURES+120;
              s_startserver.pagenum2.width            = 128; // 128
              s_startserver.pagenum2.height        = 96; // 96
              s_startserver.pagenum2.generic.ownerdraw = Pagenum_Draw;
*/
	s_startserver.mapname.generic.type  = MTYPE_PTEXT;
	s_startserver.mapname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
//       s_startserver.mapname.generic.x        = 343; // 208
       s_startserver.mapname.generic.x        = 320; // 208
       s_startserver.mapname.generic.y        = 460;
	s_startserver.mapname.string        = mapnamebuffer;
       s_startserver.mapname.style         = UI_CENTER|UI_SMALLFONT;
	s_startserver.mapname.color         = text_color_normal;

       s_startserver.mapname2.generic.type  = MTYPE_PTEXT;
       s_startserver.mapname2.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_startserver.mapname2.generic.x        = 320; // 208
       s_startserver.mapname2.generic.y        = 460;
       s_startserver.mapname2.string        = mapnamebuffer2;
       s_startserver.mapname2.style         = UI_CENTER|UI_SMALLFONT;
       s_startserver.mapname2.color         = text_color_normal;

	s_startserver.listmode.generic.type     = MTYPE_RADIOBUTTON;
	s_startserver.listmode.generic.callback = StartServer_MenuEvent;
	s_startserver.listmode.generic.id		= ID_LISTMODE;
	s_startserver.listmode.generic.flags    = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_startserver.listmode.generic.x         = 450; // 200
       s_startserver.listmode.generic.y         = 432; // 408
       s_startserver.listmode.generic.name         = "List:";

	s_startserver.back.generic.type	    = MTYPE_BITMAP;
	s_startserver.back.generic.name     = GAMESERVER_BACK0;
	s_startserver.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_startserver.back.generic.callback = StartServer_MenuEvent;
	s_startserver.back.generic.id	    = ID_STARTSERVERBACK;
	s_startserver.back.generic.x		= 0;
	s_startserver.back.generic.y		= 480-64;
	s_startserver.back.width  		    = 128;
	s_startserver.back.height  		    = 64;
	s_startserver.back.focuspic         = GAMESERVER_BACK1;

       if (addmap == 0)
       {
	s_startserver.next.generic.type	    = MTYPE_BITMAP;
	s_startserver.next.generic.name     = GAMESERVER_NEXT0;
	s_startserver.next.generic.flags    = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_startserver.next.generic.callback = StartServer_MenuEvent;
	s_startserver.next.generic.id	    = ID_STARTSERVERNEXT;
	s_startserver.next.generic.x		= 640;
	s_startserver.next.generic.y		= 480-64;
	s_startserver.next.width  		    = 128;
	s_startserver.next.height  		    = 64;
	s_startserver.next.focuspic         = GAMESERVER_NEXT1;
       }
       else
       {
       s_startserver.add.generic.type        = MTYPE_BITMAP;
       s_startserver.add.generic.name     = GAMESERVER_ADD0;
       s_startserver.add.generic.flags    = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_startserver.add.generic.callback = StartServer_MenuEvent;
       s_startserver.add.generic.id          = ID_ADDMAP;
       s_startserver.add.generic.x              = 640;
       s_startserver.add.generic.y              = 480-64;
       s_startserver.add.width               = 128;
       s_startserver.add.height              = 64;
       s_startserver.add.focuspic         = GAMESERVER_ADD1;
       }
	s_startserver.item_null.generic.type	= MTYPE_BITMAP;
	s_startserver.item_null.generic.flags	= QMF_LEFT_JUSTIFY|QMF_MOUSEONLY|QMF_SILENT;
	s_startserver.item_null.generic.x		= 0;
	s_startserver.item_null.generic.y		= 0;
	s_startserver.item_null.width			= 640;
	s_startserver.item_null.height			= 480;

	Menu_AddItem( &s_startserver.menu, &s_startserver.banner );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner2 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner3 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner4 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner5 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner6 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner7 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner8 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner9 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.banner10 );
       Menu_AddItem( &s_startserver.menu, &s_startserver.listmode );
       Menu_AddItem( &s_startserver.menu, &s_startserver.allmaps );
//       Menu_AddItem( &s_startserver.menu, &s_startserver.pagenum2 );
	Menu_AddItem( &s_startserver.menu, &s_startserver.gametype );
	Menu_AddItem( &s_startserver.menu, &s_startserver.filter );
       Menu_AddItem( &s_startserver.menu, &s_startserver.go );
	Menu_AddItem( &s_startserver.menu, &s_startserver.mapsource );
	for (i=0; i<MAX_MAPSPERPAGE; i++)
	{
		Menu_AddItem( &s_startserver.menu, &s_startserver.mappics[i] );
		Menu_AddItem( &s_startserver.menu, &s_startserver.mapbuttons[i] );
	}
       Menu_AddItem( &s_startserver.menu, &s_startserver.mappics2 );
	for (i=0; i<MAX_LISTMODEMAPSPERPAGE; i++)
	{
		Menu_AddItem( &s_startserver.menu, &s_startserver.maplistmode[i] );
	}

	Menu_AddItem( &s_startserver.menu, &s_startserver.arrows );
	Menu_AddItem( &s_startserver.menu, &s_startserver.prevpage );
	Menu_AddItem( &s_startserver.menu, &s_startserver.nextpage );
	Menu_AddItem( &s_startserver.menu, &s_startserver.back );
       if (addmap == 0)
	Menu_AddItem( &s_startserver.menu, &s_startserver.next );
       else
       Menu_AddItem( &s_startserver.menu, &s_startserver.add );
	Menu_AddItem( &s_startserver.menu, &s_startserver.mapname );
	Menu_AddItem( &s_startserver.menu, &s_startserver.item_null );
       s_startserver.mapsource.curvalue = Com_Clamp( 0, 4, trap_Cvar_VariableValue( "ui_mapsource" ) );
       s_startserver.listmode.curvalue = Com_Clamp( 0, 2, trap_Cvar_VariableValue( "ui_listmode" ) );
       s_startserver.allmaps.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "ui_allmaps" ) );
       s_startserver.gametype.curvalue = Com_Clamp( 0, 3, trap_Cvar_VariableValue( "ui_gametype" ) );
	StartServer_GametypeEvent( NULL, QM_ACTIVATED );
       if (ui_listmode.integer)
              s_startserver.mappics2.generic.flags  = QMF_LEFT_JUSTIFY|QMF_INACTIVE|QMF_HIGHLIGHT;
       StartServer_LoadFromFile2("maps.txt");
       RefreshMapList();
       /*
       num = random() * s_startserver.nummaps;
       s_startserver.currentmap = (s_startserver.page*MAX_MAPSPERPAGE) + num;
       s_map[s_startserver.gametype.curvalue] = s_startserver.currentmap;
       trap_Cvar_SetValue( "ui_gametype", s_startserver.gametype.curvalue);
       trap_Cvar_SetValue( "ui_mapsource", s_startserver.mapsource.curvalue);
       trap_Cvar_SetValue( "ui_listmode", s_startserver.listmode.curvalue);
       trap_Cvar_SetValue( "g_gameType", gametype_remap[s_startserver.gametype.curvalue] );
       UI_ServerOptionsMenu( s_startserver.multiplayer );
       */
       /*
       while (num <= 0)
              num = random() * (s_startserver.nummaps-1);
       s_startserver.currentmap = (s_startserver.page*MAX_MAPSPERPAGE) + num;
       s_map[s_startserver.gametype.curvalue] = s_startserver.currentmap;
       Com_Printf("num : %i\n", num);
       num = s_startserver.nummaps;
       Com_Printf("nummaps : %i\n", num);
       temp2[0] = '\0';
       Q_strcat(temp2,64,"map ");
       Q_strcat(temp2,64, s_startserver.maplist[s_startserver.currentmap]);
       trap_Cvar_Register(&curlist, "test","", CVAR_ARCHIVE);
       trap_Cvar_Set(va("test",1),temp2);
       */
//       StartServer_Update();
}


/*
=================
StartServer_Cache
=================
*/
void StartServer_Cache( void )
{
	int				i;
	const char		*info;
	qboolean		precache;
	char			picname[64];

	trap_R_RegisterShaderNoMip( GAMESERVER_BACK0 );	
	trap_R_RegisterShaderNoMip( GAMESERVER_BACK1 );	
	trap_R_RegisterShaderNoMip( GAMESERVER_NEXT0 );	
	trap_R_RegisterShaderNoMip( GAMESERVER_NEXT1 );	
	trap_R_RegisterShaderNoMip( GAMESERVER_SELECT );	
       trap_R_RegisterShaderNoMip( GAMESERVER_SELECTED );
	trap_R_RegisterShaderNoMip( GAMESERVER_UNKNOWNMAP );
	trap_R_RegisterShaderNoMip( GAMESERVER_ARROWS );
	trap_R_RegisterShaderNoMip( GAMESERVER_ARROWSL );
	trap_R_RegisterShaderNoMip( GAMESERVER_ARROWSR );

	precache = trap_Cvar_VariableValue("com_buildscript");

       s_startserver.nummaps = UI_GetNumArenas();
	for( i = 0; i < s_startserver.nummaps; i++ ) {
		info = UI_GetArenaInfoByNumber( i );

              Q_strncpyz( s_startserver.maplist[i], Info_ValueForKey( info, "map"), MAX_NAMELENGTH );
		Q_strupr( s_startserver.maplist[i] );
		s_startserver.mapGamebits[i] = GametypeBits( Info_ValueForKey( info, "type") );

              if( precache && ui_cache.integer == 0 || ui_cache.integer == 1) {
			Com_sprintf( picname, sizeof(picname), "levelshots/%s", s_startserver.maplist[i] );
			trap_R_RegisterShaderNoMip(picname);
              }
	}
       s_startserver.maxpages = (s_startserver.nummaps + MAX_MAPSPERPAGE-1)/MAX_MAPSPERPAGE;
}


/*
=================
UI_StartServerMenu
=================
*/
void UI_StartServerMenu( qboolean multiplayer, int addmap ) {
       StartServer_MenuInit(addmap);
	s_startserver.multiplayer = multiplayer;
	UI_PushMenu( &s_startserver.menu );
}

/*
===============
UI_StartServerMenuSP_f
===============
*/
void UI_StartServerMenuSP_f( void ) {

       UI_StartServerMenu(qfalse,0);
}

/*
===============
UI_StartServerMenuMP_f
===============
*/
void UI_StartServerMenuMP_f( void ) {

       UI_StartServerMenu(qtrue,0);
}


/*
=============================================================================

SERVER OPTIONS MENU *****

=============================================================================
*/


static const char *dedicated_list[] = {
	"No",
	"LAN",
	"Internet",
	0
};

static const char *playerType_list[] = {
       "Open", // 0
       "Bot", // 1
       "----", // 2
	0
};

static const char *playerTeam_list[] = {
	"Blue",
	"Red",
	0
};

static const char *botSkill_list[] = {
	"I Can Win",
	"Bring It On",
	"Hurt Me Plenty",
	"Hardcore",
	"Nightmare!",
	0
};


/*
=================
BotAlreadySelected
=================
*/
static qboolean BotAlreadySelected( const char *checkName ) {
	int		n;

	for( n = 1; n < PLAYER_SLOTS; n++ ) {
		if( s_serveroptions.playerType[n].curvalue != 1 ) {
			continue;
		}
		if( (s_serveroptions.gametype >= GT_TEAM) &&
			(s_serveroptions.playerTeam[n].curvalue != s_serveroptions.playerTeam[s_serveroptions.newBotIndex].curvalue ) ) {
			continue;
		}
		if( Q_stricmp( checkName, s_serveroptions.playerNameBuffers[n] ) == 0 ) {
			return qtrue;
		}
	}

	return qfalse;
}


/*
=================
ServerOptions_SetMapList
=================
*/
static char *ServerOptions_SetMapList( void ) {
	static vmCvar_t maplistvar[1024];
       vmCvar_t curlist;
	static char mapcmd[64];
       char maplist[1024];
       char temp[64];
       char temp2[64];
       char *pos;
       char *pos2;
       int i,j;

	mapcmd[0] = '\0';
	//Set up the vars from the map list stuff
	//set d1 "map q3jbcath ; set nextmap vstr d2"

       Q_strncpyz(maplist,s_serveroptions.maplist.field.buffer,1024);
	//Use a kind of chasing pointers so we know when we're at the end before we get there
	pos = (char *)strtok(maplist,";\n\r");
	if (pos)
		pos2 = (char *)strtok(NULL,";\n\r");
	else
		pos2 = NULL;
	i = 1;
       temp2[0] = '\0';
       Q_strcat(temp2,64,"map ");
       Q_strcat(temp2,64, s_startserver.maplist[s_startserver.currentmap]);
       Q_strcat(temp2,64,"; set nextmap vstr maplist1");
       trap_Cvar_Register(&curlist, "begincycle","", CVAR_ARCHIVE);
       trap_Cvar_Set(va("begincycle",i),temp2);
	while (pos != NULL) {
		temp[0] = '\0';
		Q_strcat(temp,64,"map ");
		Q_strcat(temp,64,pos);
		if (pos2)
			Q_strcat(temp,64,va("; set nextmap vstr maplist%d",i+1));
		else
              {
                     Q_strcat(temp,64,"; set nextmap vstr begincycle"); // vstr begincycle
                     for (j = i+1; j < 32; j++)
                            trap_Cvar_Set(va("maplist%d",j), "");
              }
		trap_Cvar_Register(&maplistvar[1],va("maplist%d",i),"", CVAR_ARCHIVE);
		trap_Cvar_Set(va("maplist%d",i),temp);
		if (!Q_stricmp(pos, s_startserver.maplist[s_startserver.currentmap]))
			Q_strncpyz(mapcmd,va("maplist%d",i),64);
		pos = pos2;
		if (pos)
			pos2 = (char *)strtok(NULL,";\n\r");
		i++;
	}
	return mapcmd;
}

/*
=================
ServerOptions_TeamSetMapList
=================
*/
static char *ServerOptions_TeamSetMapList( void ) {
	static vmCvar_t maplistvar[1024];
       vmCvar_t curlist;
	static char mapcmd[64];
       char maplist[1024];
       char temp[64];
       char temp2[64];
       char *pos;
       char *pos2;
       int i,j;

	mapcmd[0] = '\0';
	//Set up the vars from the map list stuff
	//set d1 "map q3jbcath ; set nextmap vstr d2"

       Q_strncpyz(maplist,s_serveroptions.maplist.field.buffer,1024);
	//Use a kind of chasing pointers so we know when we're at the end before we get there
	pos = (char *)strtok(maplist,";\n\r");
	if (pos)
		pos2 = (char *)strtok(NULL,";\n\r");
	else
		pos2 = NULL;
	i = 1;
       temp2[0] = '\0';
       Q_strcat(temp2,64,"map ");
       Q_strcat(temp2,64, s_startserver.maplist[s_startserver.currentmap]);
       Q_strcat(temp2,64,"; set nextmap vstr team_maplist1");
       trap_Cvar_Register(&curlist, "team_begincycle","", CVAR_ARCHIVE);
       trap_Cvar_Set(va("team_begincycle",i),temp2);
	while (pos != NULL) {
		temp[0] = '\0';
		Q_strcat(temp,64,"map ");
		Q_strcat(temp,64,pos);
		if (pos2)
                     Q_strcat(temp,64,va("; set nextmap vstr team_maplist%d",i+1));
		else
              {
                     Q_strcat(temp,64,"; set nextmap vstr team_begincycle"); // vstr begincycle
                     for (j = i+1; j < 32; j++)
                            trap_Cvar_Set(va("team_maplist%d",j), "");
              }
              trap_Cvar_Register(&maplistvar[1],va("team_maplist%d",i),"", CVAR_ARCHIVE);
              trap_Cvar_Set(va("team_maplist%d",i),temp);
		if (!Q_stricmp(pos, s_startserver.maplist[s_startserver.currentmap]))
                     Q_strncpyz(mapcmd,va("team_maplist%d",i),64);
		pos = pos2;
		if (pos)
			pos2 = (char *)strtok(NULL,";\n\r");
		i++;
	}
	return mapcmd;
}

/*
=================
ServerOptions_TournamentSetMapList
=================
*/
static char *ServerOptions_TournamentSetMapList( void ) {
	static vmCvar_t maplistvar[1024];
       vmCvar_t curlist;
	static char mapcmd[64];
       char maplist[1024];
       char temp[64];
       char temp2[64];
       char *pos;
       char *pos2;
       int i,j;

	mapcmd[0] = '\0';
	//Set up the vars from the map list stuff
	//set d1 "map q3jbcath ; set nextmap vstr d2"

       Q_strncpyz(maplist,s_serveroptions.maplist.field.buffer,1024);
	//Use a kind of chasing pointers so we know when we're at the end before we get there
	pos = (char *)strtok(maplist,";\n\r");
	if (pos)
		pos2 = (char *)strtok(NULL,";\n\r");
	else
		pos2 = NULL;
	i = 1;
       temp2[0] = '\0';
       Q_strcat(temp2,64,"map ");
       Q_strcat(temp2,64, s_startserver.maplist[s_startserver.currentmap]);
       Q_strcat(temp2,64,"; set nextmap vstr tournament_maplist1");
       trap_Cvar_Register(&curlist, "tournament_begincycle","", CVAR_ARCHIVE);
       trap_Cvar_Set(va("tournament_begincycle",i),temp2);
	while (pos != NULL) {
		temp[0] = '\0';
		Q_strcat(temp,64,"map ");
		Q_strcat(temp,64,pos);
		if (pos2)
                     Q_strcat(temp,64,va("; set nextmap vstr tournament_maplist%d",i+1));
		else
              {
                     Q_strcat(temp,64,"; set nextmap vstr tournament_begincycle"); // vstr begincycle
                     for (j = i+1; j < 32; j++)
                            trap_Cvar_Set(va("tournament_maplist%d",j), "");
              }
              trap_Cvar_Register(&maplistvar[1],va("tournament_maplist%d",i),"", CVAR_ARCHIVE);
              trap_Cvar_Set(va("tournament_maplist%d",i),temp);
		if (!Q_stricmp(pos, s_startserver.maplist[s_startserver.currentmap]))
                     Q_strncpyz(mapcmd,va("tournament_maplist%d",i),64);
		pos = pos2;
		if (pos)
			pos2 = (char *)strtok(NULL,";\n\r");
		i++;
	}
	return mapcmd;
}

/*
=================
ServerOptions_CTFSetMapList
=================
*/
static char *ServerOptions_CTFSetMapList( void ) {
	static vmCvar_t maplistvar[1024];
       vmCvar_t curlist;
	static char mapcmd[64];
       char maplist[1024];
       char temp[64];
       char temp2[64];
       char *pos;
       char *pos2;
       int i,j;

	mapcmd[0] = '\0';
	//Set up the vars from the map list stuff
	//set d1 "map q3jbcath ; set nextmap vstr d2"

       Q_strncpyz(maplist,s_serveroptions.maplist.field.buffer,1024);
	//Use a kind of chasing pointers so we know when we're at the end before we get there
	pos = (char *)strtok(maplist,";\n\r");
	if (pos)
		pos2 = (char *)strtok(NULL,";\n\r");
	else
		pos2 = NULL;
	i = 1;
       temp2[0] = '\0';
       Q_strcat(temp2,64,"map ");
       Q_strcat(temp2,64, s_startserver.maplist[s_startserver.currentmap]);
       Q_strcat(temp2,64,"; set nextmap vstr ctf_maplist1");
       trap_Cvar_Register(&curlist, "ctf_begincycle","", CVAR_ARCHIVE);
       trap_Cvar_Set(va("ctf_begincycle",i),temp2);
	while (pos != NULL) {
		temp[0] = '\0';
		Q_strcat(temp,64,"map ");
		Q_strcat(temp,64,pos);
		if (pos2)
                     Q_strcat(temp,64,va("; set nextmap vstr ctf_maplist%d",i+1));
		else
              {
                     Q_strcat(temp,64,"; set nextmap vstr ctf_begincycle"); // vstr begincycle
                     for (j = i+1; j < 32; j++)
                            trap_Cvar_Set(va("ctf_maplist%d",j), "");
              }
              trap_Cvar_Register(&maplistvar[1],va("ctf_maplist%d",i),"", CVAR_ARCHIVE);
              trap_Cvar_Set(va("ctf_maplist%d",i),temp);
		if (!Q_stricmp(pos, s_startserver.maplist[s_startserver.currentmap]))
                     Q_strncpyz(mapcmd,va("ctf_maplist%d",i),64);
		pos = pos2;
		if (pos)
			pos2 = (char *)strtok(NULL,";\n\r");
		i++;
	}
	return mapcmd;
}

/*
=================
ServerOptions_GetMapList
=================
*/
static void ServerOptions_GetMapList( void ) {
	char temp[64], *pos, *pos2;
	int i;
	//Pull the maplistdefs out of the vars
	//set d1 "map q3jbcath ; set nextmap vstr d2"
	for (i = 1; i < 128; i++) {
		Q_strncpyz(temp,UI_Cvar_VariableString(va("maplist%d",i)), 64);
		if (temp[0] == '\0') break;
		pos = (char *)strtok(temp,";");
		if (!pos) continue;
              pos2 = strstr(temp,"map");
		if (!pos2) continue;
		pos2 += 4;
		if (s_serveroptions.maplist.field.buffer[0] != '\0')
                     Q_strcat(s_serveroptions.maplist.field.buffer,256,";");
              Q_strcat(s_serveroptions.maplist.field.buffer,256, pos2);
	}
}

/*
=================
ServerOptions_TeamGetMapList
=================
*/
static void ServerOptions_TeamGetMapList( void ) {
	char temp[64], *pos, *pos2;
	int i;
	//Pull the maplistdefs out of the vars
	//set d1 "map q3jbcath ; set nextmap vstr d2"
	for (i = 1; i < 128; i++) {
              Q_strncpyz(temp,UI_Cvar_VariableString(va("team_maplist%d",i)), 64);
		if (temp[0] == '\0') break;
		pos = (char *)strtok(temp,";");
		if (!pos) continue;
              pos2 = strstr(temp,"map");
		if (!pos2) continue;
		pos2 += 4;
		if (s_serveroptions.maplist.field.buffer[0] != '\0')
                     Q_strcat(s_serveroptions.maplist.field.buffer,256,";");
              Q_strcat(s_serveroptions.maplist.field.buffer,256, pos2);
	}
}

/*
=================
ServerOptions_TournamentGetMapList
=================
*/
static void ServerOptions_TournamentGetMapList( void ) {
	char temp[64], *pos, *pos2;
	int i;
	//Pull the maplistdefs out of the vars
	//set d1 "map q3jbcath ; set nextmap vstr d2"
	for (i = 1; i < 128; i++) {
              Q_strncpyz(temp,UI_Cvar_VariableString(va("tournament_maplist%d",i)), 64);
		if (temp[0] == '\0') break;
		pos = (char *)strtok(temp,";");
		if (!pos) continue;
              pos2 = strstr(temp,"map");
		if (!pos2) continue;
		pos2 += 4;
		if (s_serveroptions.maplist.field.buffer[0] != '\0')
                     Q_strcat(s_serveroptions.maplist.field.buffer,256,";");
              Q_strcat(s_serveroptions.maplist.field.buffer,256, pos2);
	}
}

/*
=================
ServerOptions_CTFGetMapList
=================
*/
static void ServerOptions_CTFGetMapList( void ) {
	char temp[64], *pos, *pos2;
	int i;
	//Pull the maplistdefs out of the vars
	//set d1 "map q3jbcath ; set nextmap vstr d2"
	for (i = 1; i < 128; i++) {
              Q_strncpyz(temp,UI_Cvar_VariableString(va("ctf_maplist%d",i)), 64);
		if (temp[0] == '\0') break;
		pos = (char *)strtok(temp,";");
		if (!pos) continue;
              pos2 = strstr(temp,"map");
		if (!pos2) continue;
		pos2 += 4;
		if (s_serveroptions.maplist.field.buffer[0] != '\0')
                     Q_strcat(s_serveroptions.maplist.field.buffer,256,";");
              Q_strcat(s_serveroptions.maplist.field.buffer,256, pos2);
	}
}
//END

void CheckBlankBuffer ( void ) {
              int i;
              if (s_serveroptions.gametype == GT_FFA)
              {
                     trap_Cvar_Set("begincycle", "");
                     for (i = 1; i < 32; i++)
                            trap_Cvar_Set(va("maplist%d",i), "");
              }
              else if (s_serveroptions.gametype == GT_TEAM)
              {
                     trap_Cvar_Set("team_begincycle", "");
                     for (i = 1; i < 32; i++)
                            trap_Cvar_Set(va("team_maplist%d",i), "");
              }
              else if (s_serveroptions.gametype == GT_TOURNAMENT)
              {
                     trap_Cvar_Set("tournament_begincycle", "");
                     for (i = 1; i < 32; i++)
                            trap_Cvar_Set(va("tournament_maplist%d",i), "");
              }
              else if (s_serveroptions.gametype == GT_CTF)
              {
                     trap_Cvar_Set("ctf_begincycle", "");
                     for (i = 1; i < 32; i++)
                            trap_Cvar_Set(va("ctf_maplist%d",i), "");
              }
}

/*
=================
ServerOptions_Start
=================
*/
static void ServerOptions_Start( void ) {
	int		timelimit;
	int		fraglimit;
	int		maxclients;
	int		dedicated;
	int		friendlyfire;
	int		flaglimit;
//       int           pure;
       int           skill;
	int		n;
       float           num;
       int           r;
       int amount = 0;
       int           list;
       char   buf[512];
       static char   *mapcmd;
       static char   *mapcmd2;


	timelimit	 = atoi( s_serveroptions.timelimit.field.buffer );
	fraglimit	 = atoi( s_serveroptions.fraglimit.field.buffer );
	flaglimit	 = atoi( s_serveroptions.flaglimit.field.buffer );
	dedicated	 = s_serveroptions.dedicated.curvalue;
	friendlyfire = s_serveroptions.friendlyfire.curvalue;
//       pure           = s_serveroptions.pure.curvalue;
	skill		 = s_serveroptions.botSkill.curvalue + 1;

	//set maxclients
	for( n = 0, maxclients = 0; n < PLAYER_SLOTS; n++ ) {
		if( s_serveroptions.playerType[n].curvalue == 2 ) {
			continue;
		}
              if( (s_serveroptions.playerType[n].curvalue == 1) && (s_serveroptions.playerNameBuffers[n][0] == 0) && s_serveroptions.randombot.curvalue == 0) {
			continue;
		}
		maxclients++;
	}

	switch( s_serveroptions.gametype ) {
	case GT_FFA:
	default:
		trap_Cvar_SetValue( "ui_ffa_fraglimit", fraglimit );
		trap_Cvar_SetValue( "ui_ffa_timelimit", timelimit );
              trap_Cvar_SetValue( "ui_ffa_skill", skill - 1 );
              ServerOptions_SetMapList();
		break;

       case GT_TOURNAMENT:
		trap_Cvar_SetValue( "ui_tourney_fraglimit", fraglimit );
		trap_Cvar_SetValue( "ui_tourney_timelimit", timelimit );
              trap_Cvar_SetValue( "ui_tourney_skill", skill - 1);
              ServerOptions_TournamentSetMapList();
		break;

       case GT_TEAM:
		trap_Cvar_SetValue( "ui_team_fraglimit", fraglimit );
		trap_Cvar_SetValue( "ui_team_timelimit", timelimit );
              trap_Cvar_SetValue( "ui_team_friendly", friendlyfire );
              trap_Cvar_SetValue( "ui_team_skill", skill - 1);
              ServerOptions_TeamSetMapList();
		break;

	case GT_CTF:
		trap_Cvar_SetValue( "ui_ctf_fraglimit", fraglimit );
		trap_Cvar_SetValue( "ui_ctf_timelimit", timelimit );
              trap_Cvar_SetValue( "ui_ctf_friendly", friendlyfire );
              trap_Cvar_SetValue( "ui_ctf_skill", skill - 1);
              ServerOptions_CTFSetMapList();
		break;
	}

	trap_Cvar_SetValue( "sv_maxclients", Com_Clamp( 0, 12, maxclients ) );
	trap_Cvar_SetValue( "dedicated", Com_Clamp( 0, 2, dedicated ) );
	trap_Cvar_SetValue ("timelimit", Com_Clamp( 0, timelimit, timelimit ) );
	trap_Cvar_SetValue ("fraglimit", Com_Clamp( 0, fraglimit, fraglimit ) );
	trap_Cvar_SetValue ("capturelimit", Com_Clamp( 0, flaglimit, flaglimit ) );
	trap_Cvar_SetValue( "g_friendlyfire", friendlyfire );
	trap_Cvar_Set("sv_hostname", s_serveroptions.hostname.field.buffer );
       if (s_serveroptions.maplist.field.buffer[0] != '\0' && s_serveroptions.gametype == GT_FFA)
              trap_Cmd_ExecuteText( EXEC_APPEND, "wait 2; vstr begincycle\n" );
       else if (s_serveroptions.maplist.field.buffer[0] != '\0' && s_serveroptions.gametype == GT_TEAM)
              trap_Cmd_ExecuteText( EXEC_APPEND, "wait 2; vstr team_begincycle\n" );
       else if (s_serveroptions.maplist.field.buffer[0] != '\0' && s_serveroptions.gametype == GT_TOURNAMENT)
              trap_Cmd_ExecuteText( EXEC_APPEND, "wait 2; vstr tournament_begincycle\n" );
       else if (s_serveroptions.maplist.field.buffer[0] != '\0' && s_serveroptions.gametype == GT_CTF)
              trap_Cmd_ExecuteText( EXEC_APPEND, "wait 2; vstr ctf_begincycle\n" );
       else
	// the wait commands will allow the dedicated to take effect
       {
              CheckBlankBuffer();
              trap_Cmd_ExecuteText( EXEC_APPEND, va( "wait ; wait ; map %s\n", s_startserver.maplist[s_startserver.currentmap] ) );
       }
	// add bots
	trap_Cmd_ExecuteText( EXEC_APPEND, "wait 3\n" );
	for( n = 1; n < PLAYER_SLOTS; n++ ) {
		if( s_serveroptions.playerType[n].curvalue != 1 ) {
			continue;
		}
//              if( s_serveroptions.playerNameBuffers[n][0] == 0 ) {
//                     continue;
//              }
              if( s_serveroptions.playerNameBuffers[n][0] == '-' && s_serveroptions.randombot.curvalue == 0) {
                     continue;
              }
              if (s_serveroptions.randombot.curvalue == 0)
              {
                     if( s_serveroptions.gametype >= GT_TEAM ) {
                            Com_sprintf( buf, sizeof(buf), "addbot %s %i %s\n", s_serveroptions.playerNameBuffers[n], skill,
                                   playerTeam_list[s_serveroptions.playerTeam[n].curvalue] );
                     }
                     else {
                            Com_sprintf( buf, sizeof(buf), "addbot %s %i\n", s_serveroptions.playerNameBuffers[n], skill );
                     }
              }
              else if (s_serveroptions.randombot.curvalue == 1)
              {
                     if( s_serveroptions.gametype >= GT_TEAM ) {
                            Com_sprintf( buf, sizeof(buf), "addrandombot %i 1 %s\n", skill,
                                   playerTeam_list[s_serveroptions.playerTeam[n].curvalue] );
                     }
                     else {
                            Com_sprintf( buf, sizeof(buf), "addrandombot %i 1\n", skill );
                     }
              }
              trap_Cmd_ExecuteText( EXEC_APPEND, buf );
	}

	// set player's team
	if( dedicated == 0 && s_serveroptions.gametype >= GT_TEAM ) {
		trap_Cmd_ExecuteText( EXEC_APPEND, va( "wait 5; team %s\n", playerTeam_list[s_serveroptions.playerTeam[0].curvalue] ) );
	}
       if (s_serveroptions.spectator.curvalue == 1)
             trap_Cmd_ExecuteText( EXEC_APPEND, "wait 5;team spectator\n" );
       if (s_serveroptions.record.curvalue == 1)
             trap_Cmd_ExecuteText( EXEC_APPEND, "wait 5;g_synchronousClients 1;wait 5;record\n" );
}


/*
=================
ServerOptions_InitPlayerItems
=================
*/
static void ServerOptions_InitPlayerItems( void ) {
	int		n;
	int		v;
       int           i;

	// init types
	if( s_serveroptions.multiplayer ) {
		v = 0;	// open
	}
	else {
		v = 1;	// bot
	}
	
	for( n = 0; n < PLAYER_SLOTS; n++ ) {
		s_serveroptions.playerType[n].curvalue = v;
	}

	if( s_serveroptions.multiplayer && (s_serveroptions.gametype < GT_TEAM) ) {
		for( n = 8; n < PLAYER_SLOTS; n++ ) {
			s_serveroptions.playerType[n].curvalue = 2;
		}
	}

	// if not a dedicated server, first slot is reserved for the human on the server
	if( s_serveroptions.dedicated.curvalue == 0 ) {
		// human
              s_serveroptions.playerType[0].generic.flags |= QMF_INACTIVE; // newly added
		s_serveroptions.playerType[0].curvalue = 0;
		trap_Cvar_VariableStringBuffer( "name", s_serveroptions.playerNameBuffers[0], sizeof(s_serveroptions.playerNameBuffers[0]) );
		Q_CleanStr( s_serveroptions.playerNameBuffers[0] );
	}
	// init teams
	if( s_serveroptions.gametype >= GT_TEAM ) {
		for( n = 0; n < (PLAYER_SLOTS / 2); n++ ) {
			s_serveroptions.playerTeam[n].curvalue = 0;
		}
		for( ; n < PLAYER_SLOTS; n++ ) {
			s_serveroptions.playerTeam[n].curvalue = 1;
		}
	}
	else {
		for( n = 0; n < PLAYER_SLOTS; n++ ) {
			s_serveroptions.playerTeam[n].generic.flags |= (QMF_INACTIVE|QMF_HIDDEN);
		}
	}
}

/*
=================
PlayerName_Draw2
=================
*/
static void PlayerName_Draw2( void *item ) {
}


/*
=================
ServerOptions_SetPlayerItems
=================
*/
static void ServerOptions_SetPlayerItems( void ) {
	int		start;
	int		n;
       int           i;
       int           j;
	// types
//	for( n = 0; n < PLAYER_SLOTS; n++ ) {
//		if( (!s_serveroptions.multiplayer) && (n > 0) && (s_serveroptions.playerType[n].curvalue == 0) ) {
//			s_serveroptions.playerType[n].curvalue = 1;
//		}
//	}

	// names
	if( s_serveroptions.dedicated.curvalue == 0 ) {
		s_serveroptions.player0.string = "Human";
		s_serveroptions.playerName[0].generic.flags &= ~QMF_HIDDEN;

		start = 1;
	}
	else {
		s_serveroptions.player0.string = "Open";
		start = 0;
	}
	for( n = start; n < PLAYER_SLOTS; n++ ) {
		if( s_serveroptions.playerType[n].curvalue == 1 ) {
			s_serveroptions.playerName[n].generic.flags &= ~(QMF_INACTIVE|QMF_HIDDEN);
		}
		else {
			s_serveroptions.playerName[n].generic.flags |= (QMF_INACTIVE|QMF_HIDDEN);
		}
	}
       if (s_serveroptions.randombot.curvalue == 1)
       {
              for (j = 0; j < 13; j++)
              {
                     if (s_serveroptions.playerType[j].curvalue == 1 && s_serveroptions.randombot.curvalue == 1)
                     {
                            s_serveroptions.oldplayerName[j].generic.flags = (QMF_SMALLFONT|QMF_INACTIVE|QMF_GRAYED); // newly added
                            s_serveroptions.oldplayerName[j].string = "Random Bot"; // newly added
                            s_serveroptions.playerName[j].generic.flags = (QMF_SMALLFONT|QMF_HIDDEN|QMF_INACTIVE); // newly added
                            s_serveroptions.playerName[j].generic.ownerdraw = PlayerName_Draw2; // newly added
                     }
                     if (s_serveroptions.playerType[j].curvalue != 1)
                            s_serveroptions.oldplayerName[j].string = "";
//                            s_serveroptions.oldplayerName[j].generic.flags = (QMF_HIDDEN); // newly added
              }
       }
       else if (s_serveroptions.randombot.curvalue == 0)
       {
              for (i = 0; i < 13; i++)
              {
                     if (s_serveroptions.oldplayerName[i].generic.flags & QMF_GRAYED && s_serveroptions.playerType[i].curvalue == 1 && s_serveroptions.randombot.curvalue == 0)
                     {
                            s_serveroptions.oldplayerName[i].generic.flags = (QMF_SMALLFONT|QMF_HIDDEN); // newly added
                            s_serveroptions.playerName[i].generic.flags = (QMF_SMALLFONT|QMF_PULSEIFFOCUS); // newly added
                            s_serveroptions.playerName[i].generic.ownerdraw = PlayerName_Draw; // newly added
                     }
              }
       }
	// teams
	if( s_serveroptions.gametype < GT_TEAM ) {
		return;
	}
	for( n = start; n < PLAYER_SLOTS; n++ ) {
		if( s_serveroptions.playerType[n].curvalue == 2 ) {
			s_serveroptions.playerTeam[n].generic.flags |= (QMF_INACTIVE|QMF_HIDDEN);
		}
		else {
			s_serveroptions.playerTeam[n].generic.flags &= ~(QMF_INACTIVE|QMF_HIDDEN);
		}
	}
}

/*
=================
ServerOptions_Event
=================
*/
static void ServerOptions_Event( void* ptr, int event ) {
       int i;
       int x;
       int timelimit;
       int fraglimit;
       int flaglimit;
       int friendlyfire;
       int skill;

	timelimit	 = atoi( s_serveroptions.timelimit.field.buffer );
	fraglimit	 = atoi( s_serveroptions.fraglimit.field.buffer );
	flaglimit	 = atoi( s_serveroptions.flaglimit.field.buffer );
	friendlyfire = s_serveroptions.friendlyfire.curvalue;
	skill		 = s_serveroptions.botSkill.curvalue + 1;

	switch( ((menucommon_s*)ptr)->id ) {
	
	//if( event != QM_ACTIVATED && event != QM_LOSTFOCUS) {
	//	return;
	//}
	case ID_PLAYER_TYPE:
		if( event != QM_ACTIVATED ) {
			break;
		}
		ServerOptions_SetPlayerItems();
		break;

	case ID_MAXCLIENTS:
	case ID_DEDICATED:
		ServerOptions_SetPlayerItems();
		break;
       case ID_SPECTATOR:
              trap_Cvar_SetValue("ui_spectator", s_serveroptions.spectator.curvalue);
              break;
       case ID_RECORD:
              trap_Cvar_SetValue("ui_record", s_serveroptions.record.curvalue);
              break;
       case ID_RANDOMBOTS:
              if( event != QM_ACTIVATED ) {
                     break;
              }
              if (s_serveroptions.randombot.curvalue == 1)
              {
                     trap_Cvar_Set("ui_randombot", "1");
                     for (i = 0; i < 13; i++)
                     {
                            if (s_serveroptions.playerType[i].curvalue == 1 && s_serveroptions.randombot.curvalue == 1)
                            {
                                   s_serveroptions.oldplayerName[i].generic.flags = (QMF_SMALLFONT|QMF_INACTIVE|QMF_GRAYED); // newly added
                                   s_serveroptions.oldplayerName[i].string = "Random Bot"; // newly added
                                   s_serveroptions.playerName[i].generic.flags = (QMF_SMALLFONT|QMF_HIDDEN|QMF_INACTIVE); // newly added
                                   s_serveroptions.playerName[i].generic.ownerdraw = PlayerName_Draw2; // newly added
                            }
                     }
              }
              else if (s_serveroptions.randombot.curvalue == 0)
              {
                     trap_Cvar_Set("ui_randombot", "0");
                     for (i = 0; i < 13; i++)
                     {
                            if (s_serveroptions.oldplayerName[i].generic.flags & QMF_GRAYED && s_serveroptions.playerType[i].curvalue == 1 && s_serveroptions.randombot.curvalue == 0 && s_serveroptions.playerType[i].curvalue != 0)
                            {
                                   s_serveroptions.oldplayerName[i].generic.flags = (QMF_SMALLFONT|QMF_HIDDEN); // newly added
                                   s_serveroptions.playerName[i].generic.flags = (QMF_SMALLFONT|QMF_PULSEIFFOCUS); // newly added
                                   s_serveroptions.playerName[i].generic.ownerdraw = PlayerName_Draw; // newly added
                            }
                     }
              }
		break;
	case ID_GO:
		if( event != QM_ACTIVATED ) {
			break;
		}
              trap_Cvar_SetValue( "g_skill", s_serveroptions.botSkill.curvalue+1);
		ServerOptions_Start();
		break;

	case ID_STARTSERVERNEXT:
		if( event != QM_ACTIVATED ) {
			break;
		}
		break;
       case ID_CLEAR:
		if( event != QM_ACTIVATED ) {
			break;
		}
              Q_strncpyz(s_serveroptions.maplist.field.buffer, "", sizeof(s_serveroptions.maplist.field.buffer));
		break;
       case ID_ADDMAP2:
		if( event != QM_ACTIVATED ) {
			break;
		}
              Q_strncpyz( oldcurrentmap, s_startserver.maplist[s_startserver.currentmap], 64 );
              Q_strncpyz( oldcurrentmap2, s_startserver.maplist2[s_startserver.currentmap], 64 );
              UI_StartServerMenu( s_startserver.multiplayer, 1);

              switch( s_serveroptions.gametype ) {
              case GT_FFA:
              default:
                     trap_Cvar_SetValue( "ui_ffa_fraglimit", fraglimit );
                     trap_Cvar_SetValue( "ui_ffa_timelimit", timelimit );
                     trap_Cvar_SetValue( "ui_ffa_skill", skill - 1 );
                     ServerOptions_SetMapList();
                     break;
              
              case GT_TOURNAMENT:
                     trap_Cvar_SetValue( "ui_tourney_fraglimit", fraglimit );
                     trap_Cvar_SetValue( "ui_tourney_timelimit", timelimit );
                     trap_Cvar_SetValue( "ui_tourney_skill", skill - 1);
                     ServerOptions_TournamentSetMapList();
                     break;
       
              case GT_TEAM:
                     trap_Cvar_SetValue( "ui_team_fraglimit", fraglimit );
                     trap_Cvar_SetValue( "ui_team_timelimit", timelimit );
                     trap_Cvar_SetValue( "ui_team_friendly", friendlyfire );
                     trap_Cvar_SetValue( "ui_team_skill", skill - 1);
                     ServerOptions_TeamSetMapList();
                     break;
       
              case GT_CTF:
                     trap_Cvar_SetValue( "ui_ctf_fraglimit", fraglimit );
                     trap_Cvar_SetValue( "ui_ctf_timelimit", timelimit );
                     trap_Cvar_SetValue( "ui_ctf_friendly", friendlyfire );
                     trap_Cvar_SetValue( "ui_ctf_skill", skill - 1);
                     ServerOptions_CTFSetMapList();
                     break;
              }
              if (s_serveroptions.maplist.field.buffer[0] == '\0')
                     CheckBlankBuffer();
		break;
	case ID_BACK:
		if( event != QM_ACTIVATED ) {
			break;
		}
              UI_StartServerMenu( s_startserver.multiplayer, 0);
//              UI_PopMenu();
		break;
	}
}


static void ServerOptions_PlayerNameEvent( void* ptr, int event ) {
	int		n;

	if( event != QM_ACTIVATED ) {
		return;
	}
	n = ((menutext_s*)ptr)->generic.id;
	s_serveroptions.newBotIndex = n;
	UI_BotSelectMenu( s_serveroptions.playerNameBuffers[n] );
}


/*
=================
ServerOptions_StatusBar
=================
*/
static void ServerOptions_StatusBar( void* ptr ) {
	switch( ((menucommon_s*)ptr)->id ) {
	default:
              UI_DrawString( 320, 440, "0 = NO LIMIT", UI_CENTER|UI_SMALLFONT, colorWhite );
		break;
	}
}

/*
=================
ServerOptions_StatusBar2
=================
*/
static void ServerOptions_StatusBar2( void* ptr ) {
	switch( ((menucommon_s*)ptr)->id ) {
	default:
              UI_DrawString( 320, 440, "Toggle The Addition Of Random Bots", UI_CENTER|UI_SMALLFONT, colorWhite );
		break;
	}
}

/*
=================
ServerOptions_StatusBar3
=================
*/
static void ServerOptions_StatusBar3( void* ptr ) {
	switch( ((menucommon_s*)ptr)->id ) {
	default:
              UI_DrawString( 320, 440, "Start as a spectator in the game", UI_CENTER|UI_SMALLFONT, colorWhite );
		break;
	}
}

/*
=================
ServerOptions_StatusBar4
=================
*/
static void ServerOptions_StatusBar4( void* ptr ) {
	switch( ((menucommon_s*)ptr)->id ) {
	default:
              UI_DrawString( 320, 440, "Record A Demo", UI_CENTER|UI_SMALLFONT, colorWhite );
		break;
	}
}

/*
=================
Maplist_StatusBar
=================
*/
static void Maplist_StatusBar( void* ptr ) {
       UI_DrawString( 320, 440, "Separate each map with a semicolon - ';'", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Clear_StatusBar
=================
*/
static void Clear_StatusBar( void* ptr ) {
       UI_DrawString( 320, 440, "Clear map rotation list", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Addmap_StatusBar
=================
*/
static void Addmap_StatusBar( void* ptr ) {
       UI_DrawString( 320, 440, "Add a map to the rotation list", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
===============
ServerOptions_LevelshotDraw
===============
*/
static void ServerOptions_LevelshotDraw( void *self ) {
	menubitmap_s	*b;
	int				x;
	int				y;

	// strange place for this, but it works
	if( s_serveroptions.newBot ) {
		Q_strncpyz( s_serveroptions.playerNameBuffers[s_serveroptions.newBotIndex], s_serveroptions.newBotName, 16 );
		s_serveroptions.newBot = qfalse;
	}

	b = (menubitmap_s *)self;

	Bitmap_Draw( b );

       x = b->generic.x;
       y = b->generic.y + b->height;
       UI_FillRect( x, y, b->width, 90, colorBlack ); // 40

	x += b->width / 2;
	y += 4;
       UI_DrawString( x, y, s_serveroptions.mapnamebuffer2, UI_CENTER|UI_SMALLFONT, color_orange );
//       UI_DrawString( 320, 460, s_serveroptions.mapnamebuffer, UI_CENTER|UI_BIGFONT, color_orange );
	y += SMALLCHAR_HEIGHT;
	UI_DrawString( x, y, gametype_items[gametype_remap2[s_serveroptions.gametype]], UI_CENTER|UI_SMALLFONT, color_orange );
}


static void ServerOptions_InitBotNames( void ) {
	int			count;
	int			n;
	const char	*arenaInfo;
	const char	*botInfo;
	char		*p;
	char		*bot;
	char		bots[MAX_INFO_STRING];
       int i;

	if( s_serveroptions.gametype >= GT_TEAM ) {
              Q_strncpyz( s_serveroptions.playerNameBuffers[1], "wrack", 16 );
              Q_strncpyz( s_serveroptions.playerNameBuffers[2], "doom", 16 );
		if( s_serveroptions.gametype == GT_TEAM ) {
			Q_strncpyz( s_serveroptions.playerNameBuffers[3], "visor", 16 );
		}
		else {
                     s_serveroptions.playerType[3].curvalue = 0;
		}
              s_serveroptions.playerType[4].curvalue = 0;
              s_serveroptions.playerType[5].curvalue = 0;

              Q_strncpyz( s_serveroptions.playerNameBuffers[6], "bones", 16 );
              Q_strncpyz( s_serveroptions.playerNameBuffers[7], "cadavre", 16 );
              Q_strncpyz( s_serveroptions.playerNameBuffers[8], "daemia", 16 );
		if( s_serveroptions.gametype == GT_TEAM ) {
                     Q_strncpyz( s_serveroptions.playerNameBuffers[9], "phobos", 16 );
		}
		else {
                     s_serveroptions.playerType[9].curvalue = 0;
		}
              s_serveroptions.playerType[10].curvalue = 0;
              s_serveroptions.playerType[11].curvalue = 0;

		return;
	}

	count = 1;	// skip the first slot, reserved for a human

	// get info for this map
       arenaInfo = UI_GetArenaInfoByMap( s_serveroptions.mapnamebuffer2 );

	// get the bot info - we'll seed with them if any are listed
	Q_strncpyz( bots, Info_ValueForKey( arenaInfo, "bots" ), sizeof(bots) );
	p = &bots[0];
	while( *p && count < PLAYER_SLOTS ) {
		//skip spaces
		while( *p && *p == ' ' ) {
			p++;
		}
		if( !p ) {
			break;
		}

		// mark start of bot name
		bot = p;

		// skip until space of null
		while( *p && *p != ' ' ) {
			p++;
		}
		if( *p ) {
			*p++ = 0;
		}

		botInfo = UI_GetBotInfoByName( bot );
		bot = Info_ValueForKey( botInfo, "name" );

		Q_strncpyz( s_serveroptions.playerNameBuffers[count], bot, sizeof(s_serveroptions.playerNameBuffers[count]) );
		count++;
	}

	// set the rest of the bot slots to "---"
	for( n = count; n < PLAYER_SLOTS; n++ ) {
		strcpy( s_serveroptions.playerNameBuffers[n], "--------" );
	}
       if (s_serveroptions.randombot.curvalue == 1)
       {
              for (i = 0; i < 13; i++)
              {
                     if (s_serveroptions.playerType[i].curvalue == 1)
                            s_serveroptions.playerName[i].generic.flags |= (QMF_INACTIVE|QMF_GRAYED); // newly added
//                     if (s_serveroptions.playerType[i].curvalue != 0)
//                            s_serveroptions.playerName[i].string = "Random Bot"; // newly added
              }
       }

       // pad up to #12 as open slots
       for( ;count < 12; count++ ) {
		s_serveroptions.playerType[count].curvalue = 0;
	}

	// close off the rest by default
	for( ;count < PLAYER_SLOTS; count++ ) {
		if( s_serveroptions.playerType[count].curvalue == 1 ) {
			s_serveroptions.playerType[count].curvalue = 2;
		}
	}
}

/*
=================
ServerOptions_SetMenuItems
=================
*/
static void ServerOptions_SetMenuItems( void ) {
	static char picname[64];

       switch( s_serveroptions.gametype ) {
	case GT_FFA:
	default:
              ServerOptions_GetMapList();
		Com_sprintf( s_serveroptions.fraglimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_ffa_fraglimit" ) ) );
		Com_sprintf( s_serveroptions.timelimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_ffa_timelimit" ) ) );
              s_serveroptions.botSkill.curvalue = Com_Clamp( 0, 5, trap_Cvar_VariableValue( "ui_ffa_skill" ) );
		break;

	case GT_TOURNAMENT:
              ServerOptions_TournamentGetMapList();
		Com_sprintf( s_serveroptions.fraglimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_tourney_fraglimit" ) ) );
		Com_sprintf( s_serveroptions.timelimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_tourney_timelimit" ) ) );
              s_serveroptions.botSkill.curvalue = Com_Clamp( 0, 5, trap_Cvar_VariableValue( "ui_tourney_skill" ) );
		break;

	case GT_TEAM:
              ServerOptions_TeamGetMapList();
		Com_sprintf( s_serveroptions.fraglimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_team_fraglimit" ) ) );
		Com_sprintf( s_serveroptions.timelimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_team_timelimit" ) ) );
		s_serveroptions.friendlyfire.curvalue = (int)Com_Clamp( 0, 1, trap_Cvar_VariableValue( "ui_team_friendly" ) );
              s_serveroptions.botSkill.curvalue = Com_Clamp( 0, 5, trap_Cvar_VariableValue( "ui_team_skill" ) );
//              trap_Cvar_SetValue( "ui_team_skill", s_serveroptions.botSkill.curvalue);
		break;

	case GT_CTF:
              ServerOptions_CTFGetMapList();
		Com_sprintf( s_serveroptions.flaglimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 100, trap_Cvar_VariableValue( "ui_ctf_capturelimit" ) ) );
		Com_sprintf( s_serveroptions.timelimit.field.buffer, 4, "%i", (int)Com_Clamp( 0, 999, trap_Cvar_VariableValue( "ui_ctf_timelimit" ) ) );
		s_serveroptions.friendlyfire.curvalue = (int)Com_Clamp( 0, 1, trap_Cvar_VariableValue( "ui_ctf_friendly" ) );
//              trap_Cvar_SetValue( "ui_ctf_skill", s_serveroptions.botSkill.curvalue);
              s_serveroptions.botSkill.curvalue = Com_Clamp( 0, 5, trap_Cvar_VariableValue( "ui_ctf_skill" ) );
		break;
	}

	Q_strncpyz( s_serveroptions.hostname.field.buffer, UI_Cvar_VariableString( "sv_hostname" ), sizeof( s_serveroptions.hostname.field.buffer ) );

//       s_serveroptions.pure.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "sv_pure" ) );

	// set the map pic
	Com_sprintf( picname, 64, "levelshots/%s", s_startserver.maplist[s_startserver.currentmap] );
	s_serveroptions.mappic.generic.name = picname;

	// set the map name
       strcpy( s_serveroptions.mapnamebuffer2, s_startserver.mapname2.string );
       strcpy( s_serveroptions.mapnamebuffer, s_startserver.mapname.string );
       Q_strupr( s_serveroptions.mapnamebuffer2 );
       Q_strupr( s_serveroptions.mapnamebuffer );

	// get the player selections initialized
	ServerOptions_InitPlayerItems();
	ServerOptions_SetPlayerItems();

	// seed bot names
	ServerOptions_InitBotNames();
	ServerOptions_SetPlayerItems();
}

/*
=================
PlayerName_Draw
=================
*/
static void PlayerName_Draw( void *item ) {
	menutext_s	*s;
	float		*color;
	int			x, y;
	int			style;
	qboolean	focus;

	s = (menutext_s *)item;

	x = s->generic.x;
	y =	s->generic.y;

	style = UI_SMALLFONT;
	focus = (s->generic.parent->cursor == s->generic.menuPosition);

	if ( s->generic.flags & QMF_GRAYED )
		color = text_color_disabled;
	else if ( focus )
	{
		color = text_color_highlight;
		style |= UI_PULSE;
	}
	else if ( s->generic.flags & QMF_BLINK )
	{
		color = text_color_highlight;
		style |= UI_BLINK;
	}
	else
		color = text_color_normal;

	if ( focus )
	{
		// draw cursor
		UI_FillRect( s->generic.left, s->generic.top, s->generic.right-s->generic.left+1, s->generic.bottom-s->generic.top+1, listbar_color ); 
		UI_DrawChar( x, y, 13, UI_CENTER|UI_BLINK|UI_SMALLFONT, color);
	}

	UI_DrawString( x - SMALLCHAR_WIDTH, y, s->generic.name, style|UI_RIGHT, color );
	UI_DrawString( x + SMALLCHAR_WIDTH, y, s->string, style|UI_LEFT, color );
}


/*
=================
ServerOptions_MenuInit
=================
*/
#define OPTIONS_X	456

static void ServerOptions_MenuInit( qboolean multiplayer ) {
	int		y;
	int		n;
       int           i;
       static char mapnamebuffer[64];
       static char playernamebuffer[64];

	memset( &s_serveroptions, 0 ,sizeof(serveroptions_t) );
	s_serveroptions.multiplayer = multiplayer;
	s_serveroptions.gametype = (int)Com_Clamp( 0, 5, trap_Cvar_VariableValue( "g_gameType" ) );

	ServerOptions_Cache();

	s_serveroptions.menu.wrapAround = qtrue;
	s_serveroptions.menu.fullscreen = qtrue;

	s_serveroptions.banner.generic.type			= MTYPE_BTEXT;
	s_serveroptions.banner.generic.x			= 320;
	s_serveroptions.banner.generic.y			= 16;
       s_serveroptions.banner.string                           = "GAME SERVER";
	s_serveroptions.banner.color  				= color_white;
	s_serveroptions.banner.style  				= UI_CENTER;

	s_serveroptions.mappic.generic.type			= MTYPE_BITMAP;
	s_serveroptions.mappic.generic.flags		= QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_serveroptions.mappic.generic.x			= 352;
	s_serveroptions.mappic.generic.y			= 80;
       s_serveroptions.mappic.width                            = 160; // 160
       s_serveroptions.mappic.height                           = 120; // 120
	s_serveroptions.mappic.errorpic				= GAMESERVER_UNKNOWNMAP;
	s_serveroptions.mappic.generic.ownerdraw	= ServerOptions_LevelshotDraw;

	s_serveroptions.picframe.generic.type		= MTYPE_BITMAP;
	s_serveroptions.picframe.generic.flags		= QMF_LEFT_JUSTIFY|QMF_INACTIVE|QMF_HIGHLIGHT;
       s_serveroptions.picframe.generic.x               = 352;
       s_serveroptions.picframe.generic.y               = 80;
       s_serveroptions.picframe.width                   = 160; // 320
       s_serveroptions.picframe.height                  = 165; // "
       s_serveroptions.picframe.focuspic                = GAMESERVER_SELECTED;

       y = 272-(BIGCHAR_HEIGHT+2);
	if( s_serveroptions.gametype != GT_CTF ) {
		s_serveroptions.fraglimit.generic.type       = MTYPE_FIELD;
		s_serveroptions.fraglimit.generic.name       = "Frag Limit:";
		s_serveroptions.fraglimit.generic.flags      = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_serveroptions.fraglimit.generic.x	         = OPTIONS_X;
		s_serveroptions.fraglimit.generic.y	         = y;
		s_serveroptions.fraglimit.generic.statusbar  = ServerOptions_StatusBar;
		s_serveroptions.fraglimit.field.widthInChars = 3;
		s_serveroptions.fraglimit.field.maxchars     = 3;
	}
	else {
		s_serveroptions.flaglimit.generic.type       = MTYPE_FIELD;
		s_serveroptions.flaglimit.generic.name       = "Capture Limit:";
		s_serveroptions.flaglimit.generic.flags      = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_serveroptions.flaglimit.generic.x	         = OPTIONS_X;
		s_serveroptions.flaglimit.generic.y	         = y;
		s_serveroptions.flaglimit.generic.statusbar  = ServerOptions_StatusBar;
		s_serveroptions.flaglimit.field.widthInChars = 3;
		s_serveroptions.flaglimit.field.maxchars     = 3;
	}

	y += BIGCHAR_HEIGHT+2;
	s_serveroptions.timelimit.generic.type       = MTYPE_FIELD;
	s_serveroptions.timelimit.generic.name       = "Time Limit:";
	s_serveroptions.timelimit.generic.flags      = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_serveroptions.timelimit.generic.x	         = OPTIONS_X;
	s_serveroptions.timelimit.generic.y	         = y;
	s_serveroptions.timelimit.generic.statusbar  = ServerOptions_StatusBar;
	s_serveroptions.timelimit.field.widthInChars = 3;
	s_serveroptions.timelimit.field.maxchars     = 3;

	y += BIGCHAR_HEIGHT+2;
       s_serveroptions.randombot.generic.type       = MTYPE_RADIOBUTTON;
       s_serveroptions.randombot.generic.name       = "Random Bots:";
       s_serveroptions.randombot.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_serveroptions.randombot.generic.x                = OPTIONS_X;
       s_serveroptions.randombot.generic.y                = y;
       s_serveroptions.randombot.generic.id          = ID_RANDOMBOTS;
       s_serveroptions.randombot.generic.callback    = ServerOptions_Event;
       s_serveroptions.randombot.generic.statusbar  = ServerOptions_StatusBar2;

	if( s_serveroptions.gametype >= GT_TEAM ) {
		y += BIGCHAR_HEIGHT+2;
		s_serveroptions.friendlyfire.generic.type     = MTYPE_RADIOBUTTON;
		s_serveroptions.friendlyfire.generic.flags    = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_serveroptions.friendlyfire.generic.x	      = OPTIONS_X;
		s_serveroptions.friendlyfire.generic.y	      = y;
		s_serveroptions.friendlyfire.generic.name	  = "Friendly Fire:";
	}

//       y += BIGCHAR_HEIGHT+2;
       /*
	s_serveroptions.pure.generic.type			= MTYPE_RADIOBUTTON;
	s_serveroptions.pure.generic.flags			= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_serveroptions.pure.generic.x				= OPTIONS_X;
	s_serveroptions.pure.generic.y				= y;
	s_serveroptions.pure.generic.name			= "Pure Server:";
       */
       trap_Cvar_Set("g_scanner", "1");
	if( s_serveroptions.multiplayer ) {
		y += BIGCHAR_HEIGHT+2;
		s_serveroptions.dedicated.generic.type		= MTYPE_SPINCONTROL;
		s_serveroptions.dedicated.generic.id		= ID_DEDICATED;
		s_serveroptions.dedicated.generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
		s_serveroptions.dedicated.generic.callback	= ServerOptions_Event;
		s_serveroptions.dedicated.generic.x			= OPTIONS_X;
		s_serveroptions.dedicated.generic.y			= y;
		s_serveroptions.dedicated.generic.name		= "Dedicated:";
		s_serveroptions.dedicated.itemnames			= dedicated_list;
              trap_Cvar_SetValue("g_scanner", 0);
	}
              s_serveroptions.maplist.generic.type       = MTYPE_FIELD;
              s_serveroptions.maplist.generic.name       = "MapList:";
              s_serveroptions.maplist.generic.flags      = QMF_SMALLFONT;
              s_serveroptions.maplist.generic.x          = 100;
              s_serveroptions.maplist.generic.y          = 380;
              s_serveroptions.maplist.field.widthInChars = 63; // 50
              s_serveroptions.maplist.field.maxchars     = 1024;
              s_serveroptions.maplist.generic.statusbar  = Maplist_StatusBar;

              s_serveroptions.clear.generic.type       = MTYPE_PTEXT;
              s_serveroptions.clear.string     = "Clear";
              s_serveroptions.clear.generic.flags      = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
              s_serveroptions.clear.generic.x          = 572; // 572
              s_serveroptions.clear.generic.y          = 380+BIGCHAR_HEIGHT+2; // 378
              s_serveroptions.clear.generic.id          = ID_CLEAR;
              s_serveroptions.clear.style               = UI_CENTER|UI_SMALLFONT;
              s_serveroptions.clear.color         = color_red;
              s_serveroptions.clear.generic.callback = ServerOptions_Event;
              s_serveroptions.clear.generic.statusbar  = Clear_StatusBar;

              s_serveroptions.addmap.generic.type       = MTYPE_PTEXT;
              s_serveroptions.addmap.string     = "Add Map";
              s_serveroptions.addmap.generic.flags      = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
              s_serveroptions.addmap.generic.x          = 78;
              s_serveroptions.addmap.generic.y          = 380+BIGCHAR_HEIGHT+2;
              s_serveroptions.addmap.generic.id          = ID_ADDMAP2;
              s_serveroptions.addmap.style               = UI_CENTER|UI_SMALLFONT;
              s_serveroptions.addmap.color         = color_red;
              s_serveroptions.addmap.generic.callback = ServerOptions_Event;
              s_serveroptions.addmap.generic.statusbar  = Addmap_StatusBar;

	if( s_serveroptions.multiplayer ) {
		y += BIGCHAR_HEIGHT+2;
		s_serveroptions.hostname.generic.type       = MTYPE_FIELD;
		s_serveroptions.hostname.generic.name       = "Hostname:";
		s_serveroptions.hostname.generic.flags      = QMF_SMALLFONT;
		s_serveroptions.hostname.generic.x          = OPTIONS_X;
		s_serveroptions.hostname.generic.y	        = y;
		s_serveroptions.hostname.field.widthInChars = 18;
		s_serveroptions.hostname.field.maxchars     = 64;
	}
	y += BIGCHAR_HEIGHT+2;
       s_serveroptions.spectator.generic.type       = MTYPE_RADIOBUTTON;
       s_serveroptions.spectator.generic.name       = "Spawn As Spectator:";
       s_serveroptions.spectator.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_serveroptions.spectator.generic.x                = OPTIONS_X;
       s_serveroptions.spectator.generic.y                = y;
       s_serveroptions.spectator.generic.id          = ID_SPECTATOR;
       s_serveroptions.spectator.generic.callback    = ServerOptions_Event;
       s_serveroptions.spectator.generic.statusbar  = ServerOptions_StatusBar3;

	y += BIGCHAR_HEIGHT+2;
       s_serveroptions.record.generic.type       = MTYPE_RADIOBUTTON;
       s_serveroptions.record.generic.name       = "Record Demo:";
       s_serveroptions.record.generic.flags      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_serveroptions.record.generic.x                = OPTIONS_X;
       s_serveroptions.record.generic.y                = y;
       s_serveroptions.record.generic.id          = ID_RECORD;
       s_serveroptions.record.generic.callback    = ServerOptions_Event;
       s_serveroptions.record.generic.statusbar  = ServerOptions_StatusBar4;

	y = 80;
	s_serveroptions.botSkill.generic.type			= MTYPE_SPINCONTROL;
	s_serveroptions.botSkill.generic.flags			= QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_serveroptions.botSkill.generic.name			= "Bot Skill:  ";
	s_serveroptions.botSkill.generic.x				= 32 + (strlen(s_serveroptions.botSkill.generic.name) + 2 ) * SMALLCHAR_WIDTH;
	s_serveroptions.botSkill.generic.y				= y;
	s_serveroptions.botSkill.itemnames				= botSkill_list;
       s_serveroptions.botSkill.curvalue                       = 2;

	y += ( 2 * SMALLCHAR_HEIGHT );
	s_serveroptions.player0.generic.type			= MTYPE_TEXT;
	s_serveroptions.player0.generic.flags			= QMF_SMALLFONT;
	s_serveroptions.player0.generic.x				= 32 + SMALLCHAR_WIDTH;
	s_serveroptions.player0.generic.y				= y;
	s_serveroptions.player0.color					= color_orange;
	s_serveroptions.player0.style					= UI_LEFT|UI_SMALLFONT;

	for( n = 0; n < PLAYER_SLOTS; n++ ) {
		s_serveroptions.playerType[n].generic.type		= MTYPE_SPINCONTROL;
		s_serveroptions.playerType[n].generic.flags		= QMF_SMALLFONT;
		s_serveroptions.playerType[n].generic.id		= ID_PLAYER_TYPE;
		s_serveroptions.playerType[n].generic.callback	= ServerOptions_Event;
		s_serveroptions.playerType[n].generic.x			= 32;
		s_serveroptions.playerType[n].generic.y			= y;
		s_serveroptions.playerType[n].itemnames			= playerType_list;

		s_serveroptions.playerName[n].generic.type		= MTYPE_TEXT;
		s_serveroptions.playerName[n].generic.flags		= QMF_SMALLFONT;
		s_serveroptions.playerName[n].generic.x			= 96;
		s_serveroptions.playerName[n].generic.y			= y;
		s_serveroptions.playerName[n].generic.callback	= ServerOptions_PlayerNameEvent;
		s_serveroptions.playerName[n].generic.id		= n;
		s_serveroptions.playerName[n].generic.ownerdraw	= PlayerName_Draw;
		s_serveroptions.playerName[n].color				= color_orange;
		s_serveroptions.playerName[n].style				= UI_SMALLFONT;
		s_serveroptions.playerName[n].string			= s_serveroptions.playerNameBuffers[n];
		s_serveroptions.playerName[n].generic.top		= s_serveroptions.playerName[n].generic.y;
		s_serveroptions.playerName[n].generic.bottom	= s_serveroptions.playerName[n].generic.y + SMALLCHAR_HEIGHT;
		s_serveroptions.playerName[n].generic.left		= s_serveroptions.playerName[n].generic.x - SMALLCHAR_HEIGHT/ 2;
		s_serveroptions.playerName[n].generic.right		= s_serveroptions.playerName[n].generic.x + 16 * SMALLCHAR_WIDTH;

              s_serveroptions.oldplayerName[n].generic.type              = MTYPE_TEXT;
              s_serveroptions.oldplayerName[n].generic.flags             = QMF_SMALLFONT|QMF_HIDDEN;
              s_serveroptions.oldplayerName[n].generic.x                 = 96;
              s_serveroptions.oldplayerName[n].generic.y                 = y;
              s_serveroptions.oldplayerName[n].generic.callback   = ServerOptions_PlayerNameEvent;
              s_serveroptions.oldplayerName[n].generic.id         = n;
              s_serveroptions.oldplayerName[n].generic.ownerdraw  = PlayerName_Draw;
              s_serveroptions.oldplayerName[n].color                            = color_orange;
              s_serveroptions.oldplayerName[n].style                            = UI_SMALLFONT;
              s_serveroptions.oldplayerName[n].string                    = s_serveroptions.playerNameBuffers[n];
              s_serveroptions.oldplayerName[n].generic.top        = s_serveroptions.oldplayerName[n].generic.y;
              s_serveroptions.oldplayerName[n].generic.bottom     = s_serveroptions.oldplayerName[n].generic.y + SMALLCHAR_HEIGHT;
              s_serveroptions.oldplayerName[n].generic.left              = s_serveroptions.oldplayerName[n].generic.x - SMALLCHAR_HEIGHT/ 2;
              s_serveroptions.oldplayerName[n].generic.right             = s_serveroptions.oldplayerName[n].generic.x + 16 * SMALLCHAR_WIDTH;

		s_serveroptions.playerTeam[n].generic.type		= MTYPE_SPINCONTROL;
		s_serveroptions.playerTeam[n].generic.flags		= QMF_SMALLFONT;
		s_serveroptions.playerTeam[n].generic.x			= 240;
		s_serveroptions.playerTeam[n].generic.y			= y;
		s_serveroptions.playerTeam[n].itemnames			= playerTeam_list;

		y += ( SMALLCHAR_HEIGHT + 4 );
	}

	s_serveroptions.back.generic.type	  = MTYPE_BITMAP;
	s_serveroptions.back.generic.name     = GAMESERVER_BACK0;
	s_serveroptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_serveroptions.back.generic.callback = ServerOptions_Event;
	s_serveroptions.back.generic.id	      = ID_BACK;
	s_serveroptions.back.generic.x		  = 0;
	s_serveroptions.back.generic.y		  = 480-64;
	s_serveroptions.back.width  		  = 128;
	s_serveroptions.back.height  		  = 64;
	s_serveroptions.back.focuspic         = GAMESERVER_BACK1;

	s_serveroptions.next.generic.type	  = MTYPE_BITMAP;
	s_serveroptions.next.generic.name     = GAMESERVER_NEXT0;
	s_serveroptions.next.generic.flags    = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS|QMF_INACTIVE|QMF_GRAYED|QMF_HIDDEN;
	s_serveroptions.next.generic.callback = ServerOptions_Event;
	s_serveroptions.next.generic.id	      = ID_STARTSERVERNEXT;
	s_serveroptions.next.generic.x		  = 640;
	s_serveroptions.next.generic.y		  = 480-64-72;
	s_serveroptions.next.generic.statusbar  = ServerOptions_StatusBar;
	s_serveroptions.next.width  		  = 128;
	s_serveroptions.next.height  		  = 64;
	s_serveroptions.next.focuspic         = GAMESERVER_NEXT1;

       s_serveroptions.mapname.generic.type  = MTYPE_PTEXT;
       s_serveroptions.mapname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_serveroptions.mapname.generic.x        = 320; // 208
       s_serveroptions.mapname.generic.y        = 460;
       s_serveroptions.mapname.string        = s_serveroptions.mapnamebuffer;
       s_serveroptions.mapname.style         = UI_CENTER|UI_SMALLFONT;
       s_serveroptions.mapname.color         = text_color_normal;

	s_serveroptions.go.generic.type	    = MTYPE_BITMAP;
	s_serveroptions.go.generic.name     = GAMESERVER_FIGHT0;
	s_serveroptions.go.generic.flags    = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_serveroptions.go.generic.callback = ServerOptions_Event;
	s_serveroptions.go.generic.id	    = ID_GO;
	s_serveroptions.go.generic.x		= 640;
	s_serveroptions.go.generic.y		= 480-64;
	s_serveroptions.go.width  		    = 128;
	s_serveroptions.go.height  		    = 64;
	s_serveroptions.go.focuspic         = GAMESERVER_FIGHT1;

	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.banner );

	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.mappic );
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.picframe );

	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.botSkill );
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.player0 );
	for( n = 0; n < PLAYER_SLOTS; n++ ) {
		if( n != 0 ) {
			Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.playerType[n] );
		}
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.playerName[n] );
              Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.oldplayerName[n] );
		if( s_serveroptions.gametype >= GT_TEAM ) {
			Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.playerTeam[n] );
		}
	}

	if( s_serveroptions.gametype != GT_CTF ) {
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.fraglimit );
	}
	else {
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.flaglimit );
	}
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.timelimit );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.randombot );
	if( s_serveroptions.gametype >= GT_TEAM ) {
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.friendlyfire );
	}
//       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.pure );
	if( s_serveroptions.multiplayer ) {
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.dedicated );
	}
	if( s_serveroptions.multiplayer ) {
		Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.hostname );
	}
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.spectator );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.record );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.maplist );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.clear );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.addmap );
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.back );
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.next );
       Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.mapname );
	Menu_AddItem( &s_serveroptions.menu, &s_serveroptions.go );

	ServerOptions_SetMenuItems();
       if (ui_spectator.integer)
              s_serveroptions.spectator.curvalue = 1;
       if (ui_record.integer)
              s_serveroptions.record.curvalue = 1;
       if (ui_randombot.integer)
       {
              s_serveroptions.randombot.curvalue = 1;
              for (i = 0; i < 13; i++)
              {
                     if (s_serveroptions.playerType[i].curvalue == 1 && s_serveroptions.randombot.curvalue == 1)
                     {
                            s_serveroptions.oldplayerName[i].generic.flags = (QMF_SMALLFONT|QMF_INACTIVE|QMF_GRAYED); // newly added
                            s_serveroptions.oldplayerName[i].string = "Random Bot"; // newly added
                            s_serveroptions.playerName[i].generic.flags = (QMF_SMALLFONT|QMF_HIDDEN|QMF_INACTIVE); // newly added
                            s_serveroptions.playerName[i].generic.ownerdraw = PlayerName_Draw2; // newly added
                     }
              }
       }
}

/*
=================
ServerOptions_Cache
=================
*/
void ServerOptions_Cache( void ) {
	trap_R_RegisterShaderNoMip( GAMESERVER_BACK0 );
	trap_R_RegisterShaderNoMip( GAMESERVER_BACK1 );
	trap_R_RegisterShaderNoMip( GAMESERVER_FIGHT0 );
	trap_R_RegisterShaderNoMip( GAMESERVER_FIGHT1 );
	trap_R_RegisterShaderNoMip( GAMESERVER_SELECT );
	trap_R_RegisterShaderNoMip( GAMESERVER_UNKNOWNMAP );
}


/*
=================
UI_ServerOptionsMenu
=================
*/
static void UI_ServerOptionsMenu( qboolean multiplayer ) {
	ServerOptions_MenuInit( multiplayer );
	UI_PushMenu( &s_serveroptions.menu );
}



/*
=============================================================================

BOT SELECT MENU *****

=============================================================================
*/


#define BOTSELECT_BACK0			"menu/art/back_0"
#define BOTSELECT_BACK1			"menu/art/back_1"
#define BOTSELECT_ACCEPT0		"menu/art/accept_0"
#define BOTSELECT_ACCEPT1		"menu/art/accept_1"
#define BOTSELECT_SELECT		"menu/art/opponents_select"
#define BOTSELECT_SELECTED		"menu/art/opponents_selected"
#define BOTSELECT_ARROWS		"menu/art/gs_arrows_0"
#define BOTSELECT_ARROWSL		"menu/art/gs_arrows_l"
#define BOTSELECT_ARROWSR		"menu/art/gs_arrows_r"

#define PLAYERGRID_COLS			4
#define PLAYERGRID_ROWS			4
#define MAX_MODELSPERPAGE		(PLAYERGRID_ROWS * PLAYERGRID_COLS)


typedef struct {
	menuframework_s	menu;

	menutext_s		banner;

	menubitmap_s	pics[MAX_MODELSPERPAGE];
	menubitmap_s	picbuttons[MAX_MODELSPERPAGE];
	menutext_s		picnames[MAX_MODELSPERPAGE];

	menubitmap_s	arrows;
	menubitmap_s	left;
	menubitmap_s	right;

	menubitmap_s	go;
	menubitmap_s	back;

	int				numBots;
	int				modelpage;
	int				numpages;
	int				selectedmodel;
	int				sortedBotNums[MAX_BOTS];
	char			boticons[MAX_MODELSPERPAGE][MAX_QPATH];
	char			botnames[MAX_MODELSPERPAGE][16];
} botSelectInfo_t;

static botSelectInfo_t	botSelectInfo;


/*
=================
UI_BotSelectMenu_SortCompare
=================
*/
static int QDECL UI_BotSelectMenu_SortCompare( const void *arg1, const void *arg2 ) {
	int			num1, num2;
	const char	*info1, *info2;
	const char	*name1, *name2;

	num1 = *(int *)arg1;
	num2 = *(int *)arg2;

	info1 = UI_GetBotInfoByNumber( num1 );
	info2 = UI_GetBotInfoByNumber( num2 );

	name1 = Info_ValueForKey( info1, "name" );
	name2 = Info_ValueForKey( info2, "name" );

	return Q_stricmp( name1, name2 );
}


/*
=================
UI_BotSelectMenu_BuildList
=================
*/
static void UI_BotSelectMenu_BuildList( void ) {
	int		n;

	botSelectInfo.modelpage = 0;
	botSelectInfo.numBots = UI_GetNumBots();
	botSelectInfo.numpages = botSelectInfo.numBots / MAX_MODELSPERPAGE;
	if( botSelectInfo.numBots % MAX_MODELSPERPAGE ) {
		botSelectInfo.numpages++;
	}

	// initialize the array
	for( n = 0; n < botSelectInfo.numBots; n++ ) {
		botSelectInfo.sortedBotNums[n] = n;
	}

	// now sort it
	qsort( botSelectInfo.sortedBotNums, botSelectInfo.numBots, sizeof(botSelectInfo.sortedBotNums[0]), UI_BotSelectMenu_SortCompare );
}


/*
=================
ServerPlayerIcon
=================
*/
static void ServerPlayerIcon( const char *modelAndSkin, char *iconName, int iconNameMaxSize ) {
	char	*skin;
	char	model[MAX_QPATH];

	Q_strncpyz( model, modelAndSkin, sizeof(model));
	skin = Q_strrchr( model, '/' );
	if ( skin ) {
		*skin++ = '\0';
	}
	else {
		skin = "default";
	}

	Com_sprintf(iconName, iconNameMaxSize, "models/players/%s/icon_%s.tga", model, skin );

	if( !trap_R_RegisterShaderNoMip( iconName ) && Q_stricmp( skin, "default" ) != 0 ) {
		Com_sprintf(iconName, iconNameMaxSize, "models/players/%s/icon_default.tga", model );
	}
}


/*
=================
UI_BotSelectMenu_UpdateGrid
=================
*/
static void UI_BotSelectMenu_UpdateGrid( void ) {
	const char	*info;
	int			i;
    int			j;

	j = botSelectInfo.modelpage * MAX_MODELSPERPAGE;
	for( i = 0; i < (PLAYERGRID_ROWS * PLAYERGRID_COLS); i++, j++) {
		if( j < botSelectInfo.numBots ) { 
			info = UI_GetBotInfoByNumber( botSelectInfo.sortedBotNums[j] );
			ServerPlayerIcon( Info_ValueForKey( info, "model" ), botSelectInfo.boticons[i], MAX_QPATH );
			Q_strncpyz( botSelectInfo.botnames[i], Info_ValueForKey( info, "name" ), 16 );
			Q_CleanStr( botSelectInfo.botnames[i] );
 			botSelectInfo.pics[i].generic.name = botSelectInfo.boticons[i];
			if( BotAlreadySelected( botSelectInfo.botnames[i] ) ) {
				botSelectInfo.picnames[i].color = color_red;
			}
			else {
				botSelectInfo.picnames[i].color = color_orange;
			}
			botSelectInfo.picbuttons[i].generic.flags &= ~QMF_INACTIVE;
		}
		else {
			// dead slot
 			botSelectInfo.pics[i].generic.name         = NULL;
			botSelectInfo.picbuttons[i].generic.flags |= QMF_INACTIVE;
			botSelectInfo.botnames[i][0] = 0;
		}

 		botSelectInfo.pics[i].generic.flags       &= ~QMF_HIGHLIGHT;
 		botSelectInfo.pics[i].shader               = 0;
 		botSelectInfo.picbuttons[i].generic.flags |= QMF_PULSEIFFOCUS;
	}

	// set selected model
	i = botSelectInfo.selectedmodel % MAX_MODELSPERPAGE;
	botSelectInfo.pics[i].generic.flags |= QMF_HIGHLIGHT;
	botSelectInfo.picbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;

	if( botSelectInfo.numpages > 1 ) {
		if( botSelectInfo.modelpage > 0 ) {
			botSelectInfo.left.generic.flags &= ~QMF_INACTIVE;
		}
		else {
			botSelectInfo.left.generic.flags |= QMF_INACTIVE;
		}

		if( botSelectInfo.modelpage < (botSelectInfo.numpages - 1) ) {
			botSelectInfo.right.generic.flags &= ~QMF_INACTIVE;
		}
		else {
			botSelectInfo.right.generic.flags |= QMF_INACTIVE;
		}
	}
	else {
		// hide left/right markers
		botSelectInfo.left.generic.flags |= QMF_INACTIVE;
		botSelectInfo.right.generic.flags |= QMF_INACTIVE;
	}
}


/*
=================
UI_BotSelectMenu_Default
=================
*/
static void UI_BotSelectMenu_Default( char *bot ) {
	const char	*botInfo;
	const char	*test;
	int			n;
	int			i;

	for( n = 0; n < botSelectInfo.numBots; n++ ) {
		botInfo = UI_GetBotInfoByNumber( n );
		test = Info_ValueForKey( botInfo, "name" );
		if( Q_stricmp( bot, test ) == 0 ) {
			break;
		}
	}
	if( n == botSelectInfo.numBots ) {
		botSelectInfo.selectedmodel = 0;
		return;
	}

	for( i = 0; i < botSelectInfo.numBots; i++ ) {
		if( botSelectInfo.sortedBotNums[i] == n ) {
			break;
		}
	}
	if( i == botSelectInfo.numBots ) {
		botSelectInfo.selectedmodel = 0;
		return;
	}

	botSelectInfo.selectedmodel = i;
}


/*
=================
UI_BotSelectMenu_LeftEvent
=================
*/
static void UI_BotSelectMenu_LeftEvent( void* ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}
	if( botSelectInfo.modelpage > 0 ) {
		botSelectInfo.modelpage--;
		botSelectInfo.selectedmodel = botSelectInfo.modelpage * MAX_MODELSPERPAGE;
		UI_BotSelectMenu_UpdateGrid();
	}
}


/*
=================
UI_BotSelectMenu_RightEvent
=================
*/
static void UI_BotSelectMenu_RightEvent( void* ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}
	if( botSelectInfo.modelpage < botSelectInfo.numpages - 1 ) {
		botSelectInfo.modelpage++;
		botSelectInfo.selectedmodel = botSelectInfo.modelpage * MAX_MODELSPERPAGE;
		UI_BotSelectMenu_UpdateGrid();
	}
}


/*
=================
UI_BotSelectMenu_BotEvent
=================
*/
static void UI_BotSelectMenu_BotEvent( void* ptr, int event ) {
	int		i;

	if( event != QM_ACTIVATED ) {
		return;
	}

	for( i = 0; i < (PLAYERGRID_ROWS * PLAYERGRID_COLS); i++ ) {
 		botSelectInfo.pics[i].generic.flags &= ~QMF_HIGHLIGHT;
 		botSelectInfo.picbuttons[i].generic.flags |= QMF_PULSEIFFOCUS;
	}

	// set selected
	i = ((menucommon_s*)ptr)->id;
	botSelectInfo.pics[i].generic.flags |= QMF_HIGHLIGHT;
	botSelectInfo.picbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;
	botSelectInfo.selectedmodel = botSelectInfo.modelpage * MAX_MODELSPERPAGE + i;
}


/*
=================
UI_BotSelectMenu_BackEvent
=================
*/
static void UI_BotSelectMenu_BackEvent( void* ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}
	UI_PopMenu();
}


/*
=================
UI_BotSelectMenu_SelectEvent
=================
*/
static void UI_BotSelectMenu_SelectEvent( void* ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}
	UI_PopMenu();

	s_serveroptions.newBot = qtrue;
	Q_strncpyz( s_serveroptions.newBotName, botSelectInfo.botnames[botSelectInfo.selectedmodel % MAX_MODELSPERPAGE], 16 );
}


/*
=================
UI_BotSelectMenu_Cache
=================
*/
void UI_BotSelectMenu_Cache( void ) {
	trap_R_RegisterShaderNoMip( BOTSELECT_BACK0 );
	trap_R_RegisterShaderNoMip( BOTSELECT_BACK1 );
	trap_R_RegisterShaderNoMip( BOTSELECT_ACCEPT0 );
	trap_R_RegisterShaderNoMip( BOTSELECT_ACCEPT1 );
	trap_R_RegisterShaderNoMip( BOTSELECT_SELECT );
	trap_R_RegisterShaderNoMip( BOTSELECT_SELECTED );
	trap_R_RegisterShaderNoMip( BOTSELECT_ARROWS );
	trap_R_RegisterShaderNoMip( BOTSELECT_ARROWSL );
	trap_R_RegisterShaderNoMip( BOTSELECT_ARROWSR );
}


static void UI_BotSelectMenu_Init( char *bot ) {
	int		i, j, k;
	int		x, y;

	memset( &botSelectInfo, 0 ,sizeof(botSelectInfo) );
	botSelectInfo.menu.wrapAround = qtrue;
	botSelectInfo.menu.fullscreen = qtrue;

	UI_BotSelectMenu_Cache();

	botSelectInfo.banner.generic.type	= MTYPE_BTEXT;
	botSelectInfo.banner.generic.x		= 320;
	botSelectInfo.banner.generic.y		= 16;
	botSelectInfo.banner.string			= "SELECT BOT";
	botSelectInfo.banner.color			= color_white;
	botSelectInfo.banner.style			= UI_CENTER;

	y =	80;
	for( i = 0, k = 0; i < PLAYERGRID_ROWS; i++) {
		x =	180;
		for( j = 0; j < PLAYERGRID_COLS; j++, k++ ) {
			botSelectInfo.pics[k].generic.type				= MTYPE_BITMAP;
			botSelectInfo.pics[k].generic.flags				= QMF_LEFT_JUSTIFY|QMF_INACTIVE;
			botSelectInfo.pics[k].generic.x					= x;
			botSelectInfo.pics[k].generic.y					= y;
 			botSelectInfo.pics[k].generic.name				= botSelectInfo.boticons[k];
			botSelectInfo.pics[k].width						= 64;
			botSelectInfo.pics[k].height					= 64;
			botSelectInfo.pics[k].focuspic					= BOTSELECT_SELECTED;
			botSelectInfo.pics[k].focuscolor				= colorRed;

			botSelectInfo.picbuttons[k].generic.type		= MTYPE_BITMAP;
			botSelectInfo.picbuttons[k].generic.flags		= QMF_LEFT_JUSTIFY|QMF_NODEFAULTINIT|QMF_PULSEIFFOCUS;
			botSelectInfo.picbuttons[k].generic.callback	= UI_BotSelectMenu_BotEvent;
			botSelectInfo.picbuttons[k].generic.id			= k;
			botSelectInfo.picbuttons[k].generic.x			= x - 16;
			botSelectInfo.picbuttons[k].generic.y			= y - 16;
			botSelectInfo.picbuttons[k].generic.left		= x;
			botSelectInfo.picbuttons[k].generic.top			= y;
			botSelectInfo.picbuttons[k].generic.right		= x + 64;
			botSelectInfo.picbuttons[k].generic.bottom		= y + 64;
			botSelectInfo.picbuttons[k].width				= 128;
			botSelectInfo.picbuttons[k].height				= 128;
			botSelectInfo.picbuttons[k].focuspic			= BOTSELECT_SELECT;
			botSelectInfo.picbuttons[k].focuscolor			= colorRed;

			botSelectInfo.picnames[k].generic.type			= MTYPE_TEXT;
			botSelectInfo.picnames[k].generic.flags			= QMF_SMALLFONT;
			botSelectInfo.picnames[k].generic.x				= x + 32;
			botSelectInfo.picnames[k].generic.y				= y + 64;
			botSelectInfo.picnames[k].string				= botSelectInfo.botnames[k];
			botSelectInfo.picnames[k].color					= color_orange;
			botSelectInfo.picnames[k].style					= UI_CENTER|UI_SMALLFONT;

			x += (64 + 6);
		}
		y += (64 + SMALLCHAR_HEIGHT + 6);
	}

	botSelectInfo.arrows.generic.type		= MTYPE_BITMAP;
	botSelectInfo.arrows.generic.name		= BOTSELECT_ARROWS;
	botSelectInfo.arrows.generic.flags		= QMF_INACTIVE;
	botSelectInfo.arrows.generic.x			= 260;
	botSelectInfo.arrows.generic.y			= 440;
	botSelectInfo.arrows.width				= 128;
	botSelectInfo.arrows.height				= 32;

	botSelectInfo.left.generic.type			= MTYPE_BITMAP;
	botSelectInfo.left.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	botSelectInfo.left.generic.callback		= UI_BotSelectMenu_LeftEvent;
	botSelectInfo.left.generic.x			= 260;
	botSelectInfo.left.generic.y			= 440;
	botSelectInfo.left.width  				= 64;
	botSelectInfo.left.height  				= 32;
	botSelectInfo.left.focuspic				= BOTSELECT_ARROWSL;

	botSelectInfo.right.generic.type	    = MTYPE_BITMAP;
	botSelectInfo.right.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	botSelectInfo.right.generic.callback	= UI_BotSelectMenu_RightEvent;
	botSelectInfo.right.generic.x			= 321;
	botSelectInfo.right.generic.y			= 440;
	botSelectInfo.right.width  				= 64;
	botSelectInfo.right.height  		    = 32;
	botSelectInfo.right.focuspic			= BOTSELECT_ARROWSR;

	botSelectInfo.back.generic.type		= MTYPE_BITMAP;
	botSelectInfo.back.generic.name		= BOTSELECT_BACK0;
	botSelectInfo.back.generic.flags	= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	botSelectInfo.back.generic.callback	= UI_BotSelectMenu_BackEvent;
	botSelectInfo.back.generic.x		= 0;
	botSelectInfo.back.generic.y		= 480-64;
	botSelectInfo.back.width			= 128;
	botSelectInfo.back.height			= 64;
	botSelectInfo.back.focuspic			= BOTSELECT_BACK1;

	botSelectInfo.go.generic.type		= MTYPE_BITMAP;
	botSelectInfo.go.generic.name		= BOTSELECT_ACCEPT0;
	botSelectInfo.go.generic.flags		= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	botSelectInfo.go.generic.callback	= UI_BotSelectMenu_SelectEvent;
	botSelectInfo.go.generic.x			= 640;
	botSelectInfo.go.generic.y			= 480-64;
	botSelectInfo.go.width				= 128;
	botSelectInfo.go.height				= 64;
	botSelectInfo.go.focuspic			= BOTSELECT_ACCEPT1;

	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.banner );
	for( i = 0; i < MAX_MODELSPERPAGE; i++ ) {
		Menu_AddItem( &botSelectInfo.menu,	&botSelectInfo.pics[i] );
		Menu_AddItem( &botSelectInfo.menu,	&botSelectInfo.picbuttons[i] );
		Menu_AddItem( &botSelectInfo.menu,	&botSelectInfo.picnames[i] );
	}
	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.arrows );
	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.left );
	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.right );
	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.back );
	Menu_AddItem( &botSelectInfo.menu, &botSelectInfo.go );

	UI_BotSelectMenu_BuildList();
	UI_BotSelectMenu_Default( bot );
	botSelectInfo.modelpage = botSelectInfo.selectedmodel / MAX_MODELSPERPAGE;
	UI_BotSelectMenu_UpdateGrid();
}


/*
=================
UI_BotSelectMenu
=================
*/
void UI_BotSelectMenu( char *bot ) {
	UI_BotSelectMenu_Init( bot );
	UI_PushMenu( &botSelectInfo.menu );
}
