// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=============================================================================

SAVE CONFIG MENU

=============================================================================
*/

#include "ui_local.h"


#define ART_BACK0			"menu/art/back_0"
#define ART_BACK1			"menu/art/back_1"	
#define ART_SAVE0			"menu/art/save_0"
#define ART_SAVE1			"menu/art/save_1"
#define ART_BACKGROUND		"menu/art/cut_frame"
#define ART_FRAME                 "menu/art/frame"

#define ID_NAME			10
#define ID_BACK			11
#define ID_SAVE			12


typedef struct {
	menuframework_s	menu;

	menutext_s		banner;
	menubitmap_s	background;
	menufield_s		savename;
	menubitmap_s	back;
       menubitmap_s  frame;
	menubitmap_s	save;
} saveConfig_t;

static saveConfig_t		saveConfig;


/*
===============
UI_SaveConfigMenu_BackEvent
===============
*/
static void UI_SaveConfigMenu_BackEvent( void *ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}

	UI_PopMenu();
}


/*
===============
UI_SaveConfigMenu_SaveEvent
===============
*/
static void UI_SaveConfigMenu_SaveEvent( void *ptr, int event ) {
	char	configname[MAX_QPATH];
       char          string[8192];
       fileHandle_t f;

	if( event != QM_ACTIVATED ) {
		return;
	}

	if( !saveConfig.savename.field.buffer[0] ) {
		return;
	}

	COM_StripExtension(saveConfig.savename.field.buffer, configname );
       strcpy (string, "// Script generated by Hellfire Arena v1.5, written by Malcolm Lim\n// Hellfire Arena's homepage is located at : http://hfarena.cjb.net\n\n");
       strcat (string, va("set starthealth \"%i\"\nset startarmor \"%i\"\nset maxhealth \"%i\"\nset ui_music \"%i\"\nset ui_cache \"%i\"\n\nset g_instagib \"%i\"\nset g_vampire \"%i\"\nset g_vampiresteal \"%f\"\nset g_vampiremax \"%i\"\nset homingmissile \"%i\"\nset doublerockets \"%i\"\nset guidedrockets \"%i\"\nset gravity \"%i\"\n\nset bot_nochat \"%i\"\nset bot_fastchat \"%i\"\nset bot_challenge \"%i\"\nset bot_rocketjump \"%i\"\n\nset cg_directionaldamage \"%i\"\nset cg_scorePlums \"%i\"\nset cg_drawMiniScore \"%i\"\nset cg_drawsmoke \"%i\"\nset cg_hud \"%i\"\nset cg_centerhud \"%i\"\nset cg_autouse \"%i\"\nset cg_autousehealth \"%i\"\nset cg_drawTimer \"%i\"\nset cg_drawFPS \"%i\"\nset cg_draw3dIcons \"%i\"\nset cg_drawAmmoWarning \"%i\"\nset cg_drawRewards \"%i\"\nset cg_drawStatus \"%i\"\nset cg_drawAttacker \"%i\"\nset cg_drawscanner \"%i\"\nset cg_rocketshaders \"%i\"\nset cg_weaponselectstyle \"%i\"\n\n",
       starthealth.integer,
       startarmor.integer,
       maxhealth.integer,
       ui_music.integer,
       ui_cache.integer,
       g_instagib.integer,
       g_vampire.integer,
       g_vampiresteal.value,
       g_vampiremax.integer,
       homingmissile.integer,
       doublerockets.integer,
       guidedrockets.integer,
       gravity.integer,
       bot_nochat.integer,
       bot_fastchat.integer,
       bot_challenge.integer,
       bot_rocketjump.integer,
       cg_directionaldamage.integer,
       cg_scorePlum.integer,
       cg_drawMiniScore.integer,
       cg_drawsmoke.integer,
       cg_hud.integer,
       cg_centerhud.integer,
       cg_autouse.integer,
       cg_autousehealth.integer,
       cg_drawTimer.integer,
       cg_drawFPS.integer,
       cg_draw3dIcons.integer,
       cg_drawAmmoWarning.integer,
       cg_drawRewards.integer,
       cg_drawStatus.integer,
       cg_drawAttacker.integer,
       cg_drawscanner.integer,
       cg_rocketshaders.integer,
       cg_weaponselectstyle.integer
));
       strcat (string, va("set g_falling \"%i\"\nset g_nofootsteps \"%i\"\nset g_fixedfov \"%i\"\nset g_selfdamage \"%i\"\nset g_knockback \"%i\"\nset g_quadfactor \"%i\"\nset g_damagescale \"%i\"\nset g_intermissiontime \"%i\"\nset g_podiumscores \"%i\"\nset g_forcerespawn \"%i\"\nset g_spawnprotect \"%i\"\nset g_teamcoloredskins \"%i\"\n\nset randomweap \"%i\"\nset g_weaponchangetime \"%i\"\nset g_mg \"%i\"\nset g_sg \"%i\"\nset g_gl \"%i\"\nset g_rl \"%i\"\nset g_lg \"%i\"\nset g_rg \"%i\"\nset g_pg \"%i\"\nset g_bfg \"%i\"\nset g_ft \"%i\"\nset fastswitch \"%i\"\nset cg_weaponposition \"%i\"\nset grenadetype \"%i\"\nset cg_railtype \"%i\"\nset lightningtype \"%i\"\nset g_proxytime \"%i\"\nset cg_progressivezooming \"%i\"\nset cg_3rdpersoncrosshair \"%i\"\n\n",
       g_falling.integer,
       g_nofootsteps.integer,
       g_fixedfov.integer,
       g_selfdamage.integer,
       g_knockback.integer,
       g_quadfactor.integer,
       g_damagescale.integer,
       g_intermissiontime.integer,
       g_podiumscores.integer,
       g_forcerespawn.integer,
       g_spawnprotect.integer,
       g_teamcoloredskins.integer,
       randomweap.integer,
       g_weaponchangetime.integer,
       g_mg.integer,
       g_sg.integer,
       g_gl.integer,
       g_rl.integer,
       g_lg.integer,
       g_rg.integer,
       g_pg.integer,
       g_bfg.integer,
       g_ft.integer,
       fastswitch.integer,
       cg_weaponposition.integer,
       grenadetype.integer,
       cg_railtype.integer,
       lightningtype.integer,
       g_proxytime.integer,
       cg_progressivezooming.integer,
       cg_3rdpersoncrosshair.integer));

       strcat (string, va("set startwithpowerups \"%i\"\nset g_powerupchangetime \"%i\"\nset g_invisibility \"%i\"\nset g_quad \"%i\"\nset g_flight \"%i\"\nset g_haste \"%i\"\nset g_regen \"%i\"\nset g_battlesuit \"%i\"\n\nset startwithmg \"%i\"\nset startwithsg \"%i\"\nset startwithgl \"%i\"\nset startwithrl \"%i\"\nset startwithlg \"%i\"\nset startwithrg \"%i\"\nset startwithpg \"%i\"\nset startwithbfg \"%i\"\nset startwithft \"%i\"\nset startwithmgammo \"%i\"\nset startwithsgammo \"%i\"\nset startwithglammo \"%i\"\nset startwithrlammo \"%i\"\nset startwithlgammo \"%i\"\nset startwithrgammo \"%i\"\nset startwithpgammo \"%i\"\nset startwithbfgammo \"%i\"\nset startwithftammo \"%i\"\n\n",
       startwithpowerups.integer,
       g_powerupchangetime.integer,
       g_invisibility.integer,
       g_quad.integer,
       g_flight.integer,
       g_haste.integer,
       g_regen.integer,
       g_battlesuit.integer,
       startwithmg.integer,
       startwithsg.integer,
       startwithgl.integer,
       startwithrl.integer,
       startwithlg.integer,
       startwithrg.integer,
       startwithpg.integer,
       startwithbfg.integer,
       startwithft.integer,
       startwithmgammo.integer,
       startwithsgammo.integer,
       startwithglammo.integer,
       startwithrlammo.integer,
       startwithlgammo.integer,
       startwithrgammo.integer,
       startwithpgammo.integer,
       startwithbfgammo.integer,
       startwithftammo.integer));

       strcat (string, va("set g_campprotect \"%i\"\nset g_camptimeout \"%i\"\nset g_campshuffle \"%i\"\n\nset g_mgweap \"%i\"\nset g_sgweap \"%i\"\nset g_glweap \"%i\"\nset g_rlweap \"%i\"\nset g_lgweap \"%i\"\nset g_rgweap \"%i\"\nset g_pgweap \"%i\"\nset g_bfgweap \"%i\"\nset g_mgammo \"%i\"\nset g_sgammo \"%i\"\nset g_glammo \"%i\"\nset g_rlammo \"%i\"\nset g_lgammo \"%i\"\nset g_rgammo \"%i\"\nset g_pgammo \"%i\"\nset g_bfgammo \"%i\"\nset g_mgrespawn \"%i\"\nset g_sgrespawn \"%i\"\nset g_glrespawn \"%i\"\nset g_rlrespawn \"%i\"\nset g_lgrespawn \"%i\"\nset g_rgrespawn \"%i\"\nset g_pgrespawn \"%i\"\nset g_bfgrespawn \"%i\"\nset g_ftrespawn \"%i\"\nset g_mgammorespawn \"%i\"\nset g_sgammorespawn \"%i\"\nset g_glammorespawn \"%i\"\nset g_rlammorespawn \"%i\"\nset g_lgammorespawn \"%i\"\nset g_rgammorespawn \"%i\"\nset g_pgammorespawn \"%i\"\nset g_bfgammorespawn \"%i\"\nset g_ftammorespawn \"%i\"\n",
       g_campprotect.integer,
       g_camptimeout.integer,
       g_campshuffle.integer,
       g_mgweap.integer,
       g_sgweap.integer,
       g_glweap.integer,
       g_rlweap.integer,
       g_lgweap.integer,
       g_rgweap.integer,
       g_pgweap.integer,
       g_bfgweap.integer,
       g_mgammo.integer,
       g_sgammo.integer,
       g_glammo.integer,
       g_rlammo.integer,
       g_lgammo.integer,
       g_rgammo.integer,
       g_pgammo.integer,
       g_bfgammo.integer,
       g_mgrespawn.integer,
       g_sgrespawn.integer,
       g_glrespawn.integer,
       g_rlrespawn.integer,
       g_lgrespawn.integer,
       g_rgrespawn.integer,
       g_pgrespawn.integer,
       g_bfgrespawn.integer,
       g_ftrespawn.integer,
       g_mgammorespawn.integer,
       g_sgammorespawn.integer,
       g_glammorespawn.integer,
       g_rlammorespawn.integer,
       g_lgammorespawn.integer,
       g_rgammorespawn.integer,
       g_pgammorespawn.integer,
       g_bfgammorespawn.integer,
       g_ftammorespawn.integer));

strcat(string, va("set gtdamage \"%i\"\nset mgdamage \"%i\"\nset sgdamage \"%i\"\nset gldamage \"%i\"\nset rldamage \"%i\"\nset lgdamage \"%i\"\nset rgdamage \"%i\"\nset pgdamage \"%i\"\nset bfgdamage \"%i\"\nset ftdamage \"%i\"\nset machinegunammo \"%i\"\nset shotgunammo \"%i\"\nset grenadeammo \"%i\"\nset rocketammo \"%i\"\nset lightningammo \"%i\"\nset railgunammo \"%i\"\nset plasmaammo \"%i\"\nset bfgammo \"%i\"\nset ftammo \"%i\"\nset g_mgreload \"%i\"\nset g_sgreload \"%i\"\nset g_glreload \"%i\"\nset g_rlreload \"%i\"\nset g_lgreload \"%i\"\nset g_rgreload \"%i\"\nset g_pgreload \"%i\"\nset g_bfgreload \"%i\"\nset g_ftreload \"%i\"\nset cg_weaponOrder \"%s\"\n",
       gtdamage.integer,
       mgdamage.integer,
       sgdamage.integer,
       gldamage.integer,
       rldamage.integer,
       lgdamage.integer,
       rgdamage.integer,
       pgdamage.integer,
       bfgdamage.integer,
       ftdamage.integer,
       machinegunammo.integer,
       shotgunammo.integer,
       grenadeammo.integer,
       rocketammo.integer,
       lightningammo.integer,
       railgunammo.integer,
       plasmaammo.integer,
       bfgammo.integer,
       ftammo.integer,
       g_mgreload.integer,
       g_sgreload.integer,
       g_glreload.integer,
       g_rlreload.integer,
       g_lgreload.integer,
       g_rgreload.integer,
       g_pgreload.integer,
       g_bfgreload.integer,
       g_ftreload.integer,
       cg_weaponOrder.string));
strcat(string, va("\nset grenadevelocity \"%i\"\nset rocketvelocity \"%i\"\nset plasmavelocity \"%i\"\nset bfgvelocity \"%i\"\n",
       grenadevelocity.integer,
       rocketvelocity.integer,
       plasmavelocity.integer,
       bfgvelocity.integer));

strcat(string, va("\nset g_maxpenetration \"%i\"\nset g_telefraginstagib \"%i\"\nset g_camtype \"%i\"\nset g_camstyle \"%i\"\nset startwithpoweruptime \"%i\"\nset cg_selectgauntlet \"%i\"\nset cg_selectgrapple \"%i\"\nset bfgtype \"%i\"\n",
       g_maxpenetration.integer,
       g_telefraginstagib.integer,
       g_camtype.integer,
       g_camstyle.integer,
       startwithpoweruptime.integer,
       cg_selectgauntlet.integer,
       cg_selectgrapple.integer,
       bfgtype.integer));

strcat(string, va("\nset runeflags \"%i\"\n",
       runeflags.integer));

strcat(string, va("\nset g_spawnrandomsg \"%i\"\nset g_spawnrandomgl \"%i\"\nset g_spawnrandomrl \"%i\"\nset g_spawnrandomlg \"%i\"\nset g_spawnrandomrg \"%i\"\nset g_spawnrandompg \"%i\"\nset g_spawnrandombfg \"%i\"\nset g_spawnrandomft \"%i\"\nset gtscore \"%i\"\nset mgscore \"%i\"\nset sgscore \"%i\"\nset glscore \"%i\"\nset rlscore \"%i\"\nset lgscore \"%i\"\nset rgscore \"%i\"\nset pgscore \"%i\"\nset bfgscore \"%i\"\nset ftscore \"%i\"\nset glsdamage \"%i\"\nset glsradius \"%i\"\nset rlsdamage \"%i\"\nset rlsradius \"%i\"\nset pgsdamage \"%i\"\nset pgsradius \"%i\"\nset bfgsdamage \"%i\"\nset bfgsradius \"%i\"\n",
       g_spawnrandomsg.integer,
       g_spawnrandomgl.integer,
       g_spawnrandomrl.integer,
       g_spawnrandomlg.integer,
       g_spawnrandomrg.integer,
       g_spawnrandompg.integer,
       g_spawnrandombfg.integer,
       g_spawnrandomft.integer,
       gtscore.integer,
       mgscore.integer,
       sgscore.integer,
       glscore.integer,
       rlscore.integer,
       lgscore.integer,
       rgscore.integer,
       pgscore.integer,
       bfgscore.integer,
       ftscore.integer,
       glsdamage.integer,
       glsradius.integer,
       rlsdamage.integer,
       rlsradius.integer,
       pgsdamage.integer,
       pgsradius.integer,
       bfgsdamage.integer,
       bfgsradius.integer));

       trap_FS_FOpenFile(va("configs/%s.cfg",configname), &f, FS_WRITE);
       trap_FS_Write( string, strlen( string ), f );
       trap_FS_FCloseFile(f);
	UI_PopMenu();
}


/*
===============
UI_SaveConfigMenu_SavenameDraw
===============
*/
static void UI_SaveConfigMenu_SavenameDraw( void *self ) {
	menufield_s		*f;
	int				style;
	float			*color;

	f = (menufield_s *)self;

	if( f == Menu_ItemAtCursor( &saveConfig.menu ) ) {
		style = UI_LEFT|UI_PULSE|UI_SMALLFONT;
		color = text_color_highlight;
	}
	else {
		style = UI_LEFT|UI_SMALLFONT;
		color = colorRed;
	}

	UI_DrawProportionalString( 320, 192, "Enter filename:", UI_CENTER|UI_SMALLFONT, color_orange );
	UI_FillRect( f->generic.x, f->generic.y, f->field.widthInChars*SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, colorBlack );
	MField_Draw( &f->field, f->generic.x, f->generic.y, style, color );
}


/*
=================
UI_SaveConfigMenu_Init
=================
*/
static void UI_SaveConfigMenu_Init( void ) {
	memset( &saveConfig, 0, sizeof(saveConfig) );

	UI_SaveConfigMenu_Cache();
	saveConfig.menu.wrapAround = qtrue;
	saveConfig.menu.fullscreen = qtrue;

	saveConfig.banner.generic.type		= MTYPE_BTEXT;
	saveConfig.banner.generic.x			= 320;
	saveConfig.banner.generic.y			= 16;
	saveConfig.banner.string			= "SAVE CONFIG";
	saveConfig.banner.color				= color_white;
	saveConfig.banner.style				= UI_CENTER;

       saveConfig.frame.generic.type      = MTYPE_BITMAP;
       saveConfig.frame.generic.name      = ART_FRAME;
       saveConfig.frame.generic.flags     = QMF_INACTIVE;
       saveConfig.frame.generic.x         = 0;
       saveConfig.frame.generic.y         = 0;
       saveConfig.frame.width                    = 640;
       saveConfig.frame.height                   = 480;

	saveConfig.background.generic.type		= MTYPE_BITMAP;
	saveConfig.background.generic.name		= ART_BACKGROUND;
	saveConfig.background.generic.flags		= QMF_INACTIVE;
	saveConfig.background.generic.x			= 142;
	saveConfig.background.generic.y			= 118;
	saveConfig.background.width				= 359;
	saveConfig.background.height			= 256;

	saveConfig.savename.generic.type		= MTYPE_FIELD;
	saveConfig.savename.generic.flags		= QMF_NODEFAULTINIT|QMF_UPPERCASE;
	saveConfig.savename.generic.ownerdraw	= UI_SaveConfigMenu_SavenameDraw;
	saveConfig.savename.field.widthInChars	= 20;
	saveConfig.savename.field.maxchars		= 20;
	saveConfig.savename.generic.x			= 240;
	saveConfig.savename.generic.y			= 155+72;
	saveConfig.savename.generic.left		= 240;
	saveConfig.savename.generic.top			= 155+72;
	saveConfig.savename.generic.right		= 233 + 20*SMALLCHAR_WIDTH;
	saveConfig.savename.generic.bottom		= 155+72 + SMALLCHAR_HEIGHT+2;

	saveConfig.back.generic.type		= MTYPE_BITMAP;
	saveConfig.back.generic.name		= ART_BACK0;
	saveConfig.back.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	saveConfig.back.generic.id			= ID_BACK;
	saveConfig.back.generic.callback	= UI_SaveConfigMenu_BackEvent;
	saveConfig.back.generic.x			= 0;
       saveConfig.back.generic.y                 = 475-64;
	saveConfig.back.width				= 128;
	saveConfig.back.height				= 64;
	saveConfig.back.focuspic			= ART_BACK1;

	saveConfig.save.generic.type		= MTYPE_BITMAP;
	saveConfig.save.generic.name		= ART_SAVE0;
	saveConfig.save.generic.flags		= QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
	saveConfig.save.generic.id			= ID_SAVE;
	saveConfig.save.generic.callback	= UI_SaveConfigMenu_SaveEvent;
	saveConfig.save.generic.x			= 640;
       saveConfig.save.generic.y                 = 475-64;
	saveConfig.save.width  				= 128;
	saveConfig.save.height  		    = 64;
	saveConfig.save.focuspic			= ART_SAVE1;

	Menu_AddItem( &saveConfig.menu, &saveConfig.banner );
       Menu_AddItem( &saveConfig.menu, &saveConfig.frame );
	Menu_AddItem( &saveConfig.menu, &saveConfig.background );
	Menu_AddItem( &saveConfig.menu, &saveConfig.savename );
	Menu_AddItem( &saveConfig.menu, &saveConfig.back );
	Menu_AddItem( &saveConfig.menu, &saveConfig.save );
}


/*
=================
UI_SaveConfigMenu_Cache
=================
*/
void UI_SaveConfigMenu_Cache( void ) {
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
	trap_R_RegisterShaderNoMip( ART_SAVE0 );
	trap_R_RegisterShaderNoMip( ART_SAVE1 );
	trap_R_RegisterShaderNoMip( ART_BACKGROUND );
}


/*
===============
UI_SaveConfigMenu
===============
*/
void UI_SaveConfigMenu( void ) {
	UI_SaveConfigMenu_Init();
	UI_PushMenu( &saveConfig.menu );
}
