// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

HELLFIRE OPTIONS MENU

=======================================================================
*/

#include "ui_local.h"

#define ART_ACCEPT0		"menu/art/accept_0"
#define ART_ACCEPT1		"menu/art/accept_1"	
#define ART_LOAD0         "menu/art/load_0"
#define ART_LOAD1         "menu/art/load_1" 
#define ART_SAVE0         "menu/art/save_0"
#define ART_SAVE1         "menu/art/save_1" 
#define ART_RESET0					"menu/art/reset_0"
#define ART_RESET1					"menu/art/reset_1"	
#define ART_FRAMEL                        ""
#define ART_FRAMER                        "menu/art/frame"
#define ART_FRAME                        "menu/art/frame"
#define ART_BACK0				"menu/art/back_0"
#define ART_BACK1				"menu/art/back_1"
#define ART_AP                         "icons/iconm_amp"
#define ART_BS                         "icons/iconm_boost"
#define ART_CK                         "icons/iconm_cloak"
#define ART_DP                         "icons/iconm_damp"
#define ART_LT                         "icons/iconm_lift"
#define ART_HL                         "icons/iconm_heal"
#define ART_GT                         "icons/iconw_gauntlet"
#define ART_MG                         "icons/iconw_machinegun"
#define ART_GP                         "icons/iconw_grapple"
#define ART_SG                         "icons/iconw_shotgun"
#define ART_GL                         "icons/iconw_grenade"
#define ART_RL                         "icons/iconw_rocket"
#define ART_LG                         "icons/iconw_lightning"
#define ART_RG                         "icons/iconw_railgun"
#define ART_PG                         "icons/iconw_plasma"
#define ART_BFG                        "icons/iconw_bfg"
#define ART_FT                         "icons/iconw_flame"
#define ART_QUAD                        "icons/quad"
#define ART_REGEN                        "icons/regen"
#define ART_INVIS                        "icons/invis"
#define ART_BATTLESUIT                        "icons/envirosuit"
#define ART_HASTE                        "icons/haste"
#define ART_FLIGHT                        "icons/flight"

#define Hellfire_X_POS          390
#define Hellfire2_X_POS          360

#define ID_LAMEBOTS                    127
#define ID_BOTOPTIONS           128
#define ID_GRENADETYPE          129
#define ID_STARTHEALTH          130
#define ID_STARTARMOR           131
#define ID_MAXHEALTH            132
#define ID_WEAPSWITCHDELAY      133
#define ID_STARTMG              134
#define ID_STARTSG              135
#define ID_STARTGL              136
#define ID_STARTRL              137
#define ID_STARTLG              138
#define ID_STARTRG              139
#define ID_STARTPG              140
#define ID_STARTBFG             141
#define ID_STARTWEAPONS           143
#define ID_STARTBACK              144
#define ID_WEAPONPOSITION              145
#define ID_BOTCHAT              146
#define ID_MUSIC              147
#define ID_POWERUP              148
#define ID_BOTFASTCHAT              149
#define ID_BOTOPTIONSBACK              150
#define ID_CACHEMAPS              151
#define ID_GRAVITY              152
#define ID_FORCERESPAWN              153
#define ID_RANDOMWEAP                154
#define ID_BACK                                  155
#define ID_PODIUM                                156
#define ID_POWERUPS           157
#define ID_POWERUPSBACK              158
#define ID_QUAD                      159
#define ID_REGEN                     160
#define ID_HASTE                     161
#define ID_INVISIBILITY              162
#define ID_BATTLESUIT                163
#define ID_RANDOM                164
#define ID_RANDOMTIME                165
#define ID_BOTCHALLENGE                166
#define ID_BOTROCKETJUMP             167
#define ID_FLIGHT                    168
#define ID_SPAWNPROTECT              169
#define ID_MG                        170
#define ID_SG                        171
#define ID_GL                        172
#define ID_RL                        173
#define ID_LG                        174
#define ID_RG                        175
#define ID_PG                        176
#define ID_BFG                       177
#define ID_WEAPONSBACK               178
#define ID_WEAPONS                   179
#define ID_WEAPONOPTIONS             180
#define ID_VAMPIRE                   181
#define ID_VAMPIREFRACTION           182
#define ID_DOUBLE                    183
#define ID_HOMING                    184
#define ID_GAMEMODES                 185
#define ID_GAMEMODESBACK             186
#define ID_INSTAGIB                  187
#define ID_VAMPIREMAX                188
#define ID_GAMEOPTIONS               189
#define ID_GAMEOPTIONSBACK           190
#define ID_FALLING                   191
#define ID_FOOTSTEPS                 192
#define ID_FIXEDFOV                  193
#define ID_SELFDAMAGE                194
#define ID_KNOCKBACK                 195
#define ID_QUADFACTOR                196
#define ID_WEAPONRESPAWN             197
#define ID_RAILTYPE                  198
#define ID_CAMPOPTIONS               199
#define ID_CAMPOPTIONSBACK           200
#define ID_CAMPPROTECT               201
#define ID_CAMPSHUFFLE               202
#define ID_CAMPTIMEOUT               203
#define ID_DIRECTIONALDAMAGE         204
#define ID_INTERMISSIONTIME          205
#define ID_WEAPONCONFIG              206
#define ID_MGAMMO                    207
#define ID_SGAMMO                    208
#define ID_GLAMMO                    209
#define ID_RLAMMO                    210
#define ID_LGAMMO                    211
#define ID_RGAMMO                    212
#define ID_PGAMMO                    213
#define ID_BFGAMMO                   214
#define ID_MGWEAP                    215
#define ID_SGWEAP                    216
#define ID_GLWEAP                    217
#define ID_RLWEAP                    218
#define ID_LGWEAP                    219
#define ID_RGWEAP                    220
#define ID_PGWEAP                    221
#define ID_BFGWEAP                   222
#define ID_WEAPONCONFIGBACK          223
#define ID_MGRELOAD                  224
#define ID_SGRELOAD                  225
#define ID_GLRELOAD                  226
#define ID_RLRELOAD                  227
#define ID_LGRELOAD                  228
#define ID_RGRELOAD                  229
#define ID_PGRELOAD                  230
#define ID_BFGRELOAD                 231
#define ID_STARTMGA              232
#define ID_STARTSGA              233
#define ID_STARTGLA              234
#define ID_STARTRLA              235
#define ID_STARTLGA              236
#define ID_STARTRGA              237
#define ID_STARTPGA              238
#define ID_STARTBFGA             239
#define ID_MGAMMOCOUNT               240
#define ID_SGAMMOCOUNT               241
#define ID_GLAMMOCOUNT               242
#define ID_RLAMMOCOUNT               243
#define ID_LGAMMOCOUNT               244
#define ID_RGAMMOCOUNT               245
#define ID_PGAMMOCOUNT               246
#define ID_BFGAMMOCOUNT              247
#define ID_MGRESPAWN             248
#define ID_SGRESPAWN             249
#define ID_GLRESPAWN             250
#define ID_RLRESPAWN             251
#define ID_LGRESPAWN             252
#define ID_RGRESPAWN             253
#define ID_PGRESPAWN             254
#define ID_BFGRESPAWN            255
#define ID_MGAMMORESPAWN             256
#define ID_SGAMMORESPAWN             257
#define ID_GLAMMORESPAWN             258
#define ID_RLAMMORESPAWN             259
#define ID_LGAMMORESPAWN             260
#define ID_RGAMMORESPAWN             261
#define ID_PGAMMORESPAWN             262
#define ID_BFGAMMORESPAWN            263
#define ID_DAMAGESCALE               264
#define ID_RESET                     265
#define ID_GTDAMAGE              266
#define ID_MGDAMAGE              267
#define ID_SGDAMAGE              268
#define ID_GLDAMAGE              269
#define ID_RLDAMAGE              270
#define ID_LGDAMAGE              271
#define ID_RGDAMAGE              272
#define ID_PGDAMAGE              273
#define ID_BFGDAMAGE              274
#define ID_ACCEPT           275
#define ID_LOAD                                  276
#define ID_SAVE                                  277
#define ID_HUD                                   278
#define ID_HUDOPTIONS           279
#define ID_DRAW3D               280
#define ID_DRAWATTACKER         281
#define ID_DRAWSTATUS           282
#define ID_DRAWTIMER            283
#define ID_DRAWFPS              284
#define ID_DRAWAMMOWARNING      285
#define ID_DRAWREWARDS          286
#define ID_DRAWSMOKE            287
#define ID_CHAIN                288
#define ID_PROXYTIME            289
#define ID_AUTOUSE              290
#define ID_AUTOUSEHEALTH        291
#define ID_CENTERHUD            292
#define ID_WARMUP               293
#define ID_STARTFT              294
#define ID_STARTFTA             295
#define ID_FTAMMO               296
#define ID_FTWEAP               297
#define ID_FTRELOAD             298
#define ID_FTAMMOCOUNT          299
#define ID_FTAMMORESPAWN        300
#define ID_FTDAMAGE             301
#define ID_WEAPONIMAGE          302
#define ID_FTRESPAWN            303
#define ID_SCOREPLUMS           304
#define ID_MINISCORE            305
#define ID_GRENADEVELOCITY      306
#define ID_ROCKETVELOCITY       307
#define ID_PLASMAVELOCITY       308
#define ID_BFGVELOCITY          309
#define ID_RANDOMMENU           310
#define ID_BFGTYPE              311
#define ID_FT                   312
#define ID_SCANNER              313
#define ID_TESTFIELD            314
#define ID_WEAPON               315
#define ID_WEAPON2              316
#define ID_TESTFIELD2           317
#define ID_WEAPON3              318
#define ID_WEAPON4              319
#define ID_WEAPON5              320
#define ID_WEAPON6              321
#define ID_WEAPON7              322
#define ID_WEAPON8              323
#define ID_WEAPON9              324
#define ID_WEAPON10             325
#define ID_WEAPONRANKING        326
#define ID_ROCKETSHADERS        327
#define ID_GUIDEDROCKETS        328
#define ID_ZOOM                 329
#define ID_TEAMCOLOREDSKINS     330
#define ID_RANDOMFT             331
#define ID_WEAPONSELECTSTYLE    332
#define ID_3RDPERSONCROSSHAIR   333
#define ID_CAMOPTIONS           334
#define ID_CAMSTYLE             335
#define ID_CAMTYPE              336
#define ID_WEAPONCONFIG2        337
#define ID_GLSPLASHDAM          338
#define ID_GLSPLASHRAD          339
#define ID_RLSPLASHDAM          340
#define ID_RLSPLASHRAD          341
#define ID_PGSPLASHDAM          342
#define ID_PGSPLASHRAD          343
#define ID_BFGSPLASHDAM          344
#define ID_BFGSPLASHRAD          345
#define ID_MOREOPTIONS           346
#define ID_POWERUPTIME           347
#define ID_TELEFRAGINSTAGIB                  348
#define ID_GRAPPLEVELOCITY      349
#define ID_GPRELOAD                350
#define ID_MAXPENETRATION          351
#define ID_GTSCORE                 352
#define ID_MGSCORE                 353
#define ID_SGSCORE                 354
#define ID_GLSCORE                 355
#define ID_RLSCORE                 356
#define ID_LGSCORE                 357
#define ID_RGSCORE                 358
#define ID_PGSCORE                 359
#define ID_BFGSCORE                360
#define ID_FTSCORE                 361
#define ID_RUNEOPTIONS             362
#define ID_AMPLIFIER               363
#define ID_RESIST                  364
#define ID_HEALER                  365
#define ID_BOOSTER                 366
#define ID_LIFTER                  367
#define ID_CLOAKER                 368
#define ID_SELECTGAUNTLET          369
#define ID_SELECTGRAPPLE           370

#define MD_AMPLIFIER 1
#define MD_RESIST    2
#define MD_HEALER    4
#define MD_BOOSTER   8
#define MD_LIFTER    16
#define MD_CLOAKER   32

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menubitmap_s         frame;

       menuradiobutton_s    lamebots;
       menuradiobutton_s    cachemaps;
       menutext_s           startweapons;
       menutext_s           weaponoptions;
       menutext_s           weaponconfig;
       menutext_s           botoptions;
       menutext_s           hudoptions;
       menutext_s           camoptions;
       menutext_s           gamemodes;
       menutext_s           campoptions;
       menutext_s           gameoptions;
       menutext_s           runeoptions;
       menutext_s           powerups;
       menulist_s           music;
       menufield_s    starthealth;
       menufield_s    startarmor;
       menufield_s    maxhealth;
	menubitmap_s		back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} Hellfire_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menubitmap_s         frame;

       menubitmap_s         mg;
       menubitmap_s         sg;
       menubitmap_s         gl;
       menubitmap_s         rl;
       menubitmap_s         lg;
       menubitmap_s         pg;
       menubitmap_s         rg;
       menubitmap_s         bfg;
       menubitmap_s         ft;

       menuradiobutton_s    startwithmg;
       menuradiobutton_s    startwithsg;
       menuradiobutton_s    startwithgl;
       menuradiobutton_s    startwithrl;
       menuradiobutton_s    startwithlg;
       menuradiobutton_s    startwithrg;
       menuradiobutton_s    startwithpg;
       menuradiobutton_s    startwithbfg;
       menuradiobutton_s    startwithft;

       menufield_s    startwithmga;
       menufield_s    startwithsga;
       menufield_s    startwithgla;
       menufield_s    startwithrla;
       menufield_s    startwithlga;
       menufield_s    startwithrga;
       menufield_s    startwithpga;
       menufield_s    startwithbfga;
       menufield_s    startwithfta;
	menubitmap_s		back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} start_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menubitmap_s         frame;

       menubitmap_s         ap;
       menubitmap_s         dp;
       menubitmap_s         hl;
       menubitmap_s         bs;
       menubitmap_s         lt;
       menubitmap_s         ck;

       menuradiobutton_s    amplifier;
       menuradiobutton_s    resist;
       menuradiobutton_s    healer;
       menuradiobutton_s    booster;
       menuradiobutton_s    lifter;
       menuradiobutton_s    cloaker;

	menubitmap_s		back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} runes_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menubitmap_s         frame;

       menufield_s   testfield;
       menufield_s   testfield2;
       menufield_s   testfield3;
       menufield_s   testfield4;
       menufield_s   testfield5;
       menufield_s   testfield6;
       menufield_s   testfield7;
       menufield_s   testfield8;
       menufield_s   testfield9;
       menufield_s   testfield10;
       menulist_s   weapon;
       menulist_s   weapon2;
       menulist_s   weapon3;
       menulist_s   weapon4;
       menulist_s   weapon5;
       menulist_s   weapon6;
       menulist_s   weapon7;
       menulist_s   weapon8;
       menulist_s   weapon9;
       menulist_s   weapon10;

	menubitmap_s		back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} weaponranking_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menuradiobutton_s   fastchat;
       menulist_s   botchat;
       menuradiobutton_s   challenge;
       menuradiobutton_s   rocketjump;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s         accept;
       menubitmap_s           load;
       menubitmap_s           save;

} botoptions_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menulist_s                  vampirefraction;
       menufield_s    vampiremax;
       menuradiobutton_s   instagib;
       menuradiobutton_s   telefraginstagib;
       menuradiobutton_s   vampire;
       menuradiobutton_s   doublerockets;
       menuradiobutton_s   homingmissile;
       menuradiobutton_s   gravity;
       menuradiobutton_s   guidedrockets;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} gamemodes_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menulist_s                  damagescale;

       menuradiobutton_s   falling;
       menuradiobutton_s   footsteps;
       menuradiobutton_s   fixedfov;
       menuradiobutton_s   selfdamage;
       menufield_s    intermissiontime;
       menufield_s    quadfactor;
       menufield_s    knockback;
       menufield_s    warmup;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menuradiobutton_s    podium;
       menuradiobutton_s    teamcoloredskins;
       menufield_s    spawnprotect;
       menufield_s    forcerespawn;
       menubitmap_s           load;
       menubitmap_s           save;

} gameoptions_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;
       menulist_s           random;
       menulist_s           powerup;
       menufield_s    randomtime;
       menufield_s    poweruptime;
       menuradiobutton_s          quad;
       menuradiobutton_s          invis;
       menuradiobutton_s          regen;
       menuradiobutton_s          battlesuit;
       menuradiobutton_s          haste;
       menuradiobutton_s          flight;

       menubitmap_s         q;
       menubitmap_s         i;
       menubitmap_s         r;
       menubitmap_s         b;
       menubitmap_s         h;
       menubitmap_s         f;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} powerups_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menufield_s    weapons;
       menulist_s           random;
       menutext_s           weaponranking;
       menulist_s           railtype;
       menulist_s           chain;
       menulist_s           bfgtype;
       menufield_s    proxytime;
       menulist_s                  weaponposition;
       menulist_s                  grenadetype;
       menuradiobutton_s    selectgauntlet;
       menuradiobutton_s    selectgrapple;
       menuradiobutton_s    weaponswitch;
       menuradiobutton_s    drawsmoke;
       menuradiobutton_s    rocketshaders;
       menuradiobutton_s    progressivezoom;
       menuradiobutton_s    maxpenetration;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;
       menutext_s           randomweapons;

} weapons_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menufield_s    weapons;
       menuradiobutton_s          mg;
       menuradiobutton_s          sg;
       menuradiobutton_s          gl;
       menuradiobutton_s          rl;
       menuradiobutton_s          lg;
       menuradiobutton_s          rg;
       menuradiobutton_s          pg;
       menuradiobutton_s          bfg;
       menuradiobutton_s          ft;
       menuradiobutton_s    randomweap;
       menulist_s           random;

       menubitmap_s         i_mg;
       menubitmap_s         i_sg;
       menubitmap_s         i_gl;
       menubitmap_s         i_rl;
       menubitmap_s         i_lg;
       menubitmap_s         i_rg;
       menubitmap_s         i_pg;
       menubitmap_s         i_bfg;
       menubitmap_s         i_ft;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} randomweapons_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
       menubitmap_s         frame;

       menufield_s    weaponconfig;
       menuradiobutton_s          mg;
       menuradiobutton_s          sg;
       menuradiobutton_s          gl;
       menuradiobutton_s          rl;
       menuradiobutton_s          lg;
       menuradiobutton_s          rg;
       menuradiobutton_s          pg;
       menuradiobutton_s          bfg;
       menuradiobutton_s          mga;
       menuradiobutton_s          sga;
       menuradiobutton_s          gla;
       menuradiobutton_s          rla;
       menuradiobutton_s          lga;
       menuradiobutton_s          rga;
       menuradiobutton_s          pga;
       menuradiobutton_s          bfga;
       menuradiobutton_s          randomft;
       menufield_s          mgr;
       menufield_s          sgr;
       menufield_s          glr;
       menufield_s          gpr;
       menufield_s          rlr;
       menufield_s          lgr;
       menufield_s          rgr;
       menufield_s          pgr;
       menufield_s          bfgr;
       menufield_s          ftr;
       menufield_s          mgac;
       menufield_s          sgac;
       menufield_s          glac;
       menufield_s          rlac;
       menufield_s          lgac;
       menufield_s          rgac;
       menufield_s          pgac;
       menufield_s          bfgac;
       menufield_s          ftac;

       menufield_s          mgres;
       menufield_s          sgres;
       menufield_s          glres;
       menufield_s          rlres;
       menufield_s          lgres;
       menufield_s          rgres;
       menufield_s          pgres;
       menufield_s          bfgres;
       menufield_s          ftres;

       menufield_s          mgresa;
       menufield_s          sgresa;
       menufield_s          glresa;
       menufield_s          rlresa;
       menufield_s          lgresa;
       menufield_s          rgresa;
       menufield_s          pgresa;
       menufield_s          bfgresa;
       menufield_s          ftresa;

       menufield_s          gtdam;
       menufield_s          mgdam;
       menufield_s          sgdam;
       menufield_s          gldam;
       menufield_s          rldam;
       menufield_s          lgdam;
       menufield_s          rgdam;
       menufield_s          pgdam;
       menufield_s          bfgdam;
       menufield_s          ftdam;
       menufield_s          grenadevelocity;
       menufield_s          grapplevelocity;
       menufield_s          rocketvelocity;
       menufield_s          plasmavelocity;
       menufield_s          bfgvelocity;

       menubitmap_s         i_gt;
       menubitmap_s         i_mg;
       menubitmap_s         i_gp;
       menubitmap_s         i_sg;
       menubitmap_s         i_gl;
       menubitmap_s         i_rl;
       menubitmap_s         i_lg;
       menubitmap_s         i_rg;
       menubitmap_s         i_pg;
       menubitmap_s         i_bfg;
       menubitmap_s         i_ft;
       menulist_s           weaponimage;
       menutext_s           moreoptions;
       qhandle_t                   weaponshader;
       qhandle_t                   weaponshader2;
       qhandle_t                   weaponshader3;
       qhandle_t                   weaponshader4;
       qhandle_t                   weaponshader5;
       qhandle_t                   weaponshader6;
       qhandle_t                   weaponshader7;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  item_reset;
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;
       qhandle_t                   picture;

} weaponconfig_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
       menubitmap_s         frame;

       menufield_s    weaponconfig;
       menuradiobutton_s          mg;
       menuradiobutton_s          sg;
       menuradiobutton_s          gl;
       menuradiobutton_s          rl;
       menuradiobutton_s          lg;
       menuradiobutton_s          rg;
       menuradiobutton_s          pg;
       menuradiobutton_s          bfg;
       menuradiobutton_s          randomft;
       menufield_s          glsd;
       menufield_s          rlsd;
       menufield_s          pgsd;
       menufield_s          bfgsd;
       menufield_s          glsr;
       menufield_s          rlsr;
       menufield_s          pgsr;
       menufield_s          bfgsr;

       menufield_s          sgdam;
       menufield_s          gldam;
       menufield_s          rldam;
       menufield_s          lgdam;
       menufield_s          rgdam;
       menufield_s          pgdam;
       menufield_s          bfgdam;
       menufield_s          ftdam;
       menufield_s          gtscore;
       menufield_s          mgscore;
       menufield_s          sgscore;
       menufield_s          glscore;
       menufield_s          rlscore;
       menufield_s          lgscore;
       menufield_s          rgscore;
       menufield_s          pgscore;
       menufield_s          bfgscore;
       menufield_s          ftscore;
       menufield_s          grenadevelocity;
       menufield_s          rocketvelocity;
       menufield_s          plasmavelocity;
       menufield_s          bfgvelocity;

       menubitmap_s         i_gt;
       menubitmap_s         i_mg;
       menubitmap_s         i_sg;
       menubitmap_s         i_gl;
       menubitmap_s         i_rl;
       menubitmap_s         i_lg;
       menubitmap_s         i_rg;
       menubitmap_s         i_pg;
       menubitmap_s         i_bfg;
       menubitmap_s         i_ft;
       qhandle_t                   weaponshader;
       qhandle_t                   weaponshader2;
       qhandle_t                   weaponshader3;
       qhandle_t                   weaponshader4;
       qhandle_t                   weaponshader5;
       qhandle_t                   weaponshader6;
       qhandle_t                   weaponshader7;

       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  item_reset;
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;
       qhandle_t                   picture;

} weaponconfig2_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menufield_s    campshuffle;
       menuradiobutton_s   campprotect;
       menufield_s    camptimeout;
       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s  accept;
       menubitmap_s           load;
       menubitmap_s           save;

} campoptions_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menuradiobutton_s    directionaldamage;
       menuradiobutton_s    draw3dIcons;
       menuradiobutton_s    drawAttacker;
       menuradiobutton_s    drawStatus;
       menuradiobutton_s    drawTimer;
       menuradiobutton_s    drawFPS;
       menuradiobutton_s    drawAmmoWarning;
       menuradiobutton_s    drawRewards;
       menuradiobutton_s    autouse;
       menuradiobutton_s    centerhud;
       menuradiobutton_s    scoreplums;
       menuradiobutton_s    miniscore;
       menuradiobutton_s    scanner;
       menuradiobutton_s    thirdpersoncrosshair;
       menufield_s    autousehealth;
       menulist_s           hud;
       menulist_s           weaponselectstyle;


       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s         accept;
       menubitmap_s           load;
       menubitmap_s           save;

} hudoptions_t;

typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
	menubitmap_s		framel;
	menubitmap_s		framer;

       menulist_s           camtype;
       menulist_s           camstyle;


       menubitmap_s         back;
       void                 (*draw)( void );
       menubitmap_s         accept;
       menubitmap_s           load;
       menubitmap_s           save;

} camoptions_t;

static Hellfire_t s_hellfire;
static start_t s_start;
static runes_t s_runes;
static botoptions_t s_botoptions;
static powerups_t s_powerups;
static weapons_t s_weapons;
static gamemodes_t s_gamemodes;
static weaponranking_t s_weaponranking;
static gameoptions_t s_gameoptions;
static campoptions_t s_campoptions;
static weaponconfig_t s_weaponconfig;
static weaponconfig2_t s_weaponconfig2;
static randomweapons_t s_randomweapons;
static hudoptions_t s_hudoptions;
static camoptions_t s_camoptions;

static const char *vampire_items[] = {
       "0.1",
       "0.15",
       "0.2",
       "0.25",
       "0.3",
       "0.35",
       "0.4",
       "0.45",
       "0.5",
       "0.55",
       "0.6",
       "0.65",
       "0.7",
       "0.75",
       "0.8",
       "0.85",
       "0.9",
       "0.95",
       "1",
	0
};

static const char *damagescale_items[] = {
       "0.25",
       "0.5",
       "0.75",
       "1",
       "1.25",
       "1.5",
       "1.75",
       "2",
       "2.25",
       "2.5",
       "2.75",
       "3",
       "3.25",
       "3.5",
       "3.75",
       "4",
       "4.25",
       "4.5",
       "4.75",
       "5",
       "5.25",
       "5.5",
       "5.75",
       "6",
       "6.25",
       "6.5",
       "6.75",
       "7",
       "7.25",
       "7.5",
       "7.75",
       "8",
       "8.25",
       "8.5",
       "8.75",
       "9",
       "9.25",
       "9.5",
       "9.75",
       "10",
	0
};

static const char *grenadetype_items[] = {
       "Standard",
       "Cluster",
       "Vortex",
       "Sticky",
       "Impact",
       0
};

static const char *botchat_items[] = {
       "Enable",
       "Disable",
       0
};

static const char *railtype_items[] = {
       "Standard",
       "Spiral",
       0
};

static const char *chain_items[] = {
       "Standard",
       "Chain",
       0
};

static const char *bfgtype_items[] = {
       "Standard",
       "Enhanced",
       0
};

static const char *weaponposition_items[] = {
// right = 1, center = 2, left = 3
       "None", // bluff
       "Right",
       "Center",
       "Left",
       0
};

static const char *powerup_items[] = {
       "None",
       "Quad Damage",
       "Haste",
       "Regeneration",
       "Battle Suit",
       "Invisibility",
       "Flight",
       "Random",
       0
};

static const char *music_items[] = {
       "None",
       "Q3A Music 1",
       "Q3A Music 2",
       "Q3A Music 3",
       "Q3A Music 4",
       "Q3A Music 5",
       "Q3A Music 6",
       "Sonic 1",
       "Sonic 2",
       "Sonic 3",
       "Sonic 4",
       "Sonic 5",
       "Sonic 6",
       0
};

static const char *hud_items[] = {
       "Standard",
       "Hud Style 1",
       "Hud Style 2",
       "Hud Style 3",
       "Hud Style 4",
       "Hud Style 5",
       0
};

static const char *weaponselectstyle_items[] = {
       "Standard",
       "Enhanced",
       0
};

static const char *weapon_items[] = {
       "Gauntlet",
       "Machinegun",
       "Shotgun",
       "Grenade Launcher",
       "Rocket Launcher",
       "Lightning Gun",
       "Railgun",
       "Plasma Gun",
       "BFG10K",
       "Flame Thrower",
       0
};

static const char *camtype_items[] = {
       "Follow Mode",
       "Normal Mode",
       0
};

static const char *camstyle_items[] = {
       "Quake 3 Style",
       "Q3Cam Style",
       0
};

static void UI_RANDOMWEAPONS_MENU( void );
static void testdraw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_hellfire.menu );

       if( s_hellfire.draw ) {
              s_hellfire.draw();
       }
}
/*
=================
Hellfire_SaveChanges
=================
*/
static void Hellfire_SaveChanges( void ) {
       trap_Cvar_SetValue( "g_vampiresteal", 0.1 + (s_gamemodes.vampirefraction.curvalue * 0.05) );
}

/*
=================
Hellfire_MenuKey
=================
*/
static sfxHandle_t Hellfire_MenuKey( int key ) {
	if( key == K_MOUSE2 || key == K_ESCAPE ) {
              Hellfire_SaveChanges();
	}
       return Menu_DefaultKey( &s_gamemodes.menu, key );
}

/*
=================
Hellfire2_SaveChanges
=================
*/
static void Hellfire2_SaveChanges( void ) {
       trap_Cvar_SetValue( "g_damagescale", 0.25 + (s_gameoptions.damagescale.curvalue * 0.25) );
}

/*
=================
Hellfire2_MenuKey
=================
*/
static sfxHandle_t Hellfire2_MenuKey( int key ) {
	if( key == K_MOUSE2 || key == K_ESCAPE ) {
              Hellfire2_SaveChanges();
	}
       return Menu_DefaultKey( &s_gameoptions.menu, key );
}

static void Hellfire_SetMenuItems( void ) {

       s_hellfire.lamebots.curvalue        = trap_Cvar_VariableValue( "lamebots" ) != 0;
       Q_strncpyz( s_hellfire.starthealth.field.buffer, UI_Cvar_VariableString("starthealth"), sizeof(s_hellfire.starthealth.field.buffer) );
       Q_strncpyz( s_hellfire.startarmor.field.buffer, UI_Cvar_VariableString("startarmor"), sizeof(s_hellfire.startarmor.field.buffer) );
       Q_strncpyz( s_hellfire.maxhealth.field.buffer, UI_Cvar_VariableString("maxhealth"), sizeof(s_hellfire.maxhealth.field.buffer) );
       s_hellfire.music.curvalue = Com_Clamp( 0, 12, trap_Cvar_VariableValue( "ui_music" ) );
       s_hellfire.cachemaps.curvalue        = trap_Cvar_VariableValue( "ui_cache" ) != 0;
}

static void Start_Event( void* ptr, int notification ) {
       int startwithmga,startwithsga,startwithgla,startwithrla,startwithlga,startwithrga,startwithpga,startwithbfga,startwithfta;
       startwithmga        = atoi( s_start.startwithmga.field.buffer );
       startwithsga        = atoi( s_start.startwithsga.field.buffer );
       startwithgla        = atoi( s_start.startwithgla.field.buffer );
       startwithrla        = atoi( s_start.startwithrla.field.buffer );
       startwithlga        = atoi( s_start.startwithlga.field.buffer );
       startwithrga        = atoi( s_start.startwithrga.field.buffer );
       startwithpga        = atoi( s_start.startwithpga.field.buffer );
       startwithbfga        = atoi( s_start.startwithbfga.field.buffer );
       startwithfta        = atoi( s_start.startwithfta.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}
	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_STARTMG:
              trap_Cvar_SetValue( "startwithmg", s_start.startwithmg.curvalue );
              break;

       case ID_STARTMGA:
              trap_Cvar_SetValue( "startwithmgammo", startwithmga );
              break;

       case ID_STARTSG:
              trap_Cvar_SetValue( "startwithsg", s_start.startwithsg.curvalue );
              break;

       case ID_STARTSGA:
              trap_Cvar_SetValue( "startwithsgammo", startwithsga );
              break;

       case ID_STARTGL:
              trap_Cvar_SetValue( "startwithgl", s_start.startwithgl.curvalue );
              break;

       case ID_STARTGLA:
              trap_Cvar_SetValue( "startwithglammo", startwithgla );
              break;

       case ID_STARTRL:
              trap_Cvar_SetValue( "startwithrl", s_start.startwithrl.curvalue );
              break;

       case ID_STARTRLA:
              trap_Cvar_SetValue( "startwithrlammo", startwithrla );
              break;

       case ID_STARTLG:
              trap_Cvar_SetValue( "startwithlg", s_start.startwithlg.curvalue );
              break;

       case ID_STARTLGA:
              trap_Cvar_SetValue( "startwithlgammo", startwithlga );
              break;

       case ID_STARTPG:
              trap_Cvar_SetValue( "startwithpg", s_start.startwithpg.curvalue );
              break;

       case ID_STARTPGA:
              trap_Cvar_SetValue( "startwithpgammo", startwithpga );
              break;

       case ID_STARTRG:
              trap_Cvar_SetValue( "startwithrg", s_start.startwithrg.curvalue );
              break;

       case ID_STARTRGA:
              trap_Cvar_SetValue( "startwithrgammo", startwithrga );
              break;

       case ID_STARTBFG:
              trap_Cvar_SetValue( "startwithbfg", s_start.startwithbfg.curvalue );
              break;

       case ID_STARTBFGA:
              trap_Cvar_SetValue( "startwithbfgammo", startwithbfga );
              break;
       */
       case ID_ACCEPT:
              trap_Cvar_SetValue( "startwithmg", s_start.startwithmg.curvalue );
              trap_Cvar_SetValue( "startwithsg", s_start.startwithsg.curvalue );
              trap_Cvar_SetValue( "startwithgl", s_start.startwithgl.curvalue );
              trap_Cvar_SetValue( "startwithrl", s_start.startwithrl.curvalue );
              trap_Cvar_SetValue( "startwithlg", s_start.startwithlg.curvalue );
              trap_Cvar_SetValue( "startwithpg", s_start.startwithpg.curvalue );
              trap_Cvar_SetValue( "startwithrg", s_start.startwithrg.curvalue );
              trap_Cvar_SetValue( "startwithbfg", s_start.startwithbfg.curvalue );
              trap_Cvar_SetValue( "startwithft", s_start.startwithft.curvalue );
              trap_Cvar_SetValue( "startwithmgammo", startwithmga );
              trap_Cvar_SetValue( "startwithsgammo", startwithsga );
              trap_Cvar_SetValue( "startwithglammo", startwithgla );
              trap_Cvar_SetValue( "startwithrlammo", startwithrla );
              trap_Cvar_SetValue( "startwithlgammo", startwithlga );
              trap_Cvar_SetValue( "startwithrgammo", startwithrga );
              trap_Cvar_SetValue( "startwithpgammo", startwithpga );
              trap_Cvar_SetValue( "startwithbfgammo", startwithbfga );
              trap_Cvar_SetValue( "startwithftammo", startwithfta );
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_STARTBACK:
              UI_PopMenu();
              break;

	}
}

static void StartWeapons_Draw( void ) {
       UI_DrawString( 217, 120, "Weapons", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+85, 120, "Ammo", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_start.menu );

       if( s_start.draw ) {
              s_start.draw();
	}
}

/*
=================
Hellfire_StatusBar
=================
*/
static void Hellfire_StatusBar( void* ptr ) {
       UI_DrawString( 320, 400, "Time In Seconds", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar2
=================
*/
static void Hellfire_StatusBar2( void* ptr ) {
       UI_DrawString( 320, 400, "Go back, discarding changes", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar3
=================
*/
static void Hellfire_StatusBar3( void* ptr ) {
       UI_DrawString( 320, 400, "Save changes & go back", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar4
=================
*/
static void Hellfire_StatusBar4( void* ptr ) {
       UI_DrawString( 320, 400, "Go Back, Discarding Changes", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar5
=================
*/
static void Hellfire_StatusBar5( void* ptr ) {
       UI_DrawString( 320, 400, "Save Changes & Go Back", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar6
=================
*/
static void Hellfire_StatusBar6( void* ptr ) {
       UI_DrawString( 320, 400, "Reset Settings To Default", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar7
=================
*/
static void Hellfire_StatusBar7( void* ptr ) {
       UI_DrawString( 320, 400, "Load Settings", UI_CENTER|UI_SMALLFONT, colorWhite );
}

/*
=================
Hellfire_StatusBar8
=================
*/
static void Hellfire_StatusBar8( void* ptr ) {
       UI_DrawString( 320, 400, "Save Settings", UI_CENTER|UI_SMALLFONT, colorWhite );
}

static void UI_STARTWEAPONS_MENU( void )
{
	int				y;

       memset( &s_start, 0 ,sizeof(start_t) );

       Hellfire_Cache();

       s_start.menu.wrapAround = qtrue;
       s_start.menu.fullscreen = qtrue;
       s_start.menu.draw = StartWeapons_Draw;

       s_start.banner.generic.type  = MTYPE_PTEXT;
       s_start.banner.generic.x        = 320;
       s_start.banner.generic.y        = 32;
       s_start.banner.string           = "STARTING WEAPONS";
       s_start.banner.color         = color_orange;
       s_start.banner.style         = UI_CENTER;

       s_start.framel.generic.type  = MTYPE_BITMAP;
       s_start.framel.generic.name  = ART_FRAMEL;
       s_start.framel.generic.flags = QMF_INACTIVE;
       s_start.framel.generic.x        = 0;
       s_start.framel.generic.y        = 78;
       s_start.framel.width            = 256;
       s_start.framel.height           = 329;

       s_start.framer.generic.type  = MTYPE_BITMAP;
       s_start.framer.generic.name  = ART_FRAMER;
       s_start.framer.generic.flags = QMF_INACTIVE;
       s_start.framer.generic.x        = 0;
       s_start.framer.generic.y        = 0;
       s_start.framer.width            = 640;
       s_start.framer.height           = 480;

       y = 134;
	y += BIGCHAR_HEIGHT+2+4;

       s_start.mg.generic.type  = MTYPE_BITMAP;
       s_start.mg.generic.name  = ART_MG;
       s_start.mg.generic.flags = QMF_INACTIVE;
       s_start.mg.generic.x        = 165;
       s_start.mg.generic.y        = y;
       s_start.mg.width            = 16;
       s_start.mg.height           = 16;

       s_start.startwithmg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithmg.generic.name          = "MachineGun        ";
       s_start.startwithmg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithmg.generic.callback    = Start_Event;
       s_start.startwithmg.generic.id          = ID_STARTMGA;
       s_start.startwithmg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithmg.generic.y                 = y;

       s_start.startwithmga.generic.type        = MTYPE_FIELD;
       s_start.startwithmga.generic.name          = "";
       s_start.startwithmga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithmga.generic.callback    = Start_Event;
       s_start.startwithmga.field.maxchars             = 3;
       s_start.startwithmga.field.widthInChars        = 3;
       s_start.startwithmga.generic.id          = ID_STARTMG;
       s_start.startwithmga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithmga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.sg.generic.type  = MTYPE_BITMAP;
       s_start.sg.generic.name  = ART_SG;
       s_start.sg.generic.flags = QMF_INACTIVE;
       s_start.sg.generic.x        = 165;
       s_start.sg.generic.y        = y;
       s_start.sg.width            = 16;
       s_start.sg.height           = 16;

       s_start.startwithsg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithsg.generic.name          = "Shotgun           ";
       s_start.startwithsg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithsg.generic.callback    = Start_Event;
       s_start.startwithsg.generic.id          = ID_STARTSG;
       s_start.startwithsg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithsg.generic.y                 = y;

       s_start.startwithsga.generic.type        = MTYPE_FIELD;
       s_start.startwithsga.generic.name          = "";
       s_start.startwithsga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithsga.generic.callback    = Start_Event;
       s_start.startwithsga.field.maxchars             = 3;
       s_start.startwithsga.field.widthInChars        = 3;
       s_start.startwithsga.generic.id          = ID_STARTSGA;
       s_start.startwithsga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithsga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.gl.generic.type  = MTYPE_BITMAP;
       s_start.gl.generic.name  = ART_GL;
       s_start.gl.generic.flags = QMF_INACTIVE;
       s_start.gl.generic.x        = 165;
       s_start.gl.generic.y        = y;
       s_start.gl.width            = 16;
       s_start.gl.height           = 16;

       s_start.startwithgl.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithgl.generic.name          = "Grenade Launcher  ";
       s_start.startwithgl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithgl.generic.callback    = Start_Event;
       s_start.startwithgl.generic.id          = ID_STARTGL;
       s_start.startwithgl.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithgl.generic.y                 = y;

       s_start.startwithgla.generic.type        = MTYPE_FIELD;
       s_start.startwithgla.generic.name          = "";
       s_start.startwithgla.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithgla.generic.callback    = Start_Event;
       s_start.startwithgla.field.maxchars             = 3;
       s_start.startwithgla.field.widthInChars        = 3;
       s_start.startwithgla.generic.id          = ID_STARTGLA;
       s_start.startwithgla.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithgla.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.rl.generic.type  = MTYPE_BITMAP;
       s_start.rl.generic.name  = ART_RL;
       s_start.rl.generic.flags = QMF_INACTIVE;
       s_start.rl.generic.x        = 165;
       s_start.rl.generic.y        = y;
       s_start.rl.width            = 16;
       s_start.rl.height           = 16;

       s_start.startwithrl.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithrl.generic.name          = "Rocket Launcher   ";
       s_start.startwithrl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithrl.generic.callback    = Start_Event;
       s_start.startwithrl.generic.id          = ID_STARTRL;
       s_start.startwithrl.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithrl.generic.y                 = y;

       s_start.startwithrla.generic.type        = MTYPE_FIELD;
       s_start.startwithrla.generic.name          = "";
       s_start.startwithrla.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithrla.generic.callback    = Start_Event;
       s_start.startwithrla.field.maxchars             = 3;
       s_start.startwithrla.field.widthInChars        = 3;
       s_start.startwithrla.generic.id          = ID_STARTRLA;
       s_start.startwithrla.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithrla.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.lg.generic.type  = MTYPE_BITMAP;
       s_start.lg.generic.name  = ART_LG;
       s_start.lg.generic.flags = QMF_INACTIVE;
       s_start.lg.generic.x        = 165;
       s_start.lg.generic.y        = y;
       s_start.lg.width            = 16;
       s_start.lg.height           = 16;

       s_start.startwithlg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithlg.generic.name          = "Lightning Gun     ";
       s_start.startwithlg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithlg.generic.callback    = Start_Event;
       s_start.startwithlg.generic.id          = ID_STARTLG;
       s_start.startwithlg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithlg.generic.y                 = y;

       s_start.startwithlga.generic.type        = MTYPE_FIELD;
       s_start.startwithlga.generic.name          = "";
       s_start.startwithlga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithlga.generic.callback    = Start_Event;
       s_start.startwithlga.field.maxchars             = 3;
       s_start.startwithlga.field.widthInChars        = 3;
       s_start.startwithlga.generic.id          = ID_STARTLGA;
       s_start.startwithlga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithlga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.pg.generic.type  = MTYPE_BITMAP;
       s_start.pg.generic.name  = ART_PG;
       s_start.pg.generic.flags = QMF_INACTIVE;
       s_start.pg.generic.x        = 165;
       s_start.pg.generic.y        = y;
       s_start.pg.width            = 16;
       s_start.pg.height           = 16;

       s_start.startwithpg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithpg.generic.name          = "Plasma Gun        ";
       s_start.startwithpg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithpg.generic.callback    = Start_Event;
       s_start.startwithpg.generic.id          = ID_STARTPG;
       s_start.startwithpg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithpg.generic.y                 = y;

       s_start.startwithpga.generic.type        = MTYPE_FIELD;
       s_start.startwithpga.generic.name          = "";
       s_start.startwithpga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithpga.generic.callback    = Start_Event;
       s_start.startwithpga.field.maxchars             = 3;
       s_start.startwithpga.field.widthInChars        = 3;
       s_start.startwithpga.generic.id          = ID_STARTPGA;
       s_start.startwithpga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithpga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.rg.generic.type  = MTYPE_BITMAP;
       s_start.rg.generic.name  = ART_RG;
       s_start.rg.generic.flags = QMF_INACTIVE;
       s_start.rg.generic.x        = 165;
       s_start.rg.generic.y        = y;
       s_start.rg.width            = 16;
       s_start.rg.height           = 16;

       s_start.startwithrg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithrg.generic.name          = "RailGun           ";
       s_start.startwithrg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithrg.generic.callback    = Start_Event;
       s_start.startwithrg.generic.id          = ID_STARTRG;
       s_start.startwithrg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithrg.generic.y                 = y;

       s_start.startwithrga.generic.type        = MTYPE_FIELD;
       s_start.startwithrga.generic.name          = "";
       s_start.startwithrga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithrga.generic.callback    = Start_Event;
       s_start.startwithrga.field.maxchars             = 3;
       s_start.startwithrga.field.widthInChars        = 3;
       s_start.startwithrga.generic.id          = ID_STARTRGA;
       s_start.startwithrga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithrga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.bfg.generic.type  = MTYPE_BITMAP;
       s_start.bfg.generic.name  = ART_BFG;
       s_start.bfg.generic.flags = QMF_INACTIVE;
       s_start.bfg.generic.x        = 165;
       s_start.bfg.generic.y        = y;
       s_start.bfg.width            = 16;
       s_start.bfg.height           = 16;

       s_start.startwithbfg.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithbfg.generic.name         = "BFG10k            ";
       s_start.startwithbfg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithbfg.generic.callback    = Start_Event;
       s_start.startwithbfg.generic.id          = ID_STARTBFG;
       s_start.startwithbfg.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithbfg.generic.y                 = y;

       s_start.startwithbfga.generic.type        = MTYPE_FIELD;
       s_start.startwithbfga.generic.name          = "";
       s_start.startwithbfga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithbfga.generic.callback    = Start_Event;
       s_start.startwithbfga.field.maxchars             = 3;
       s_start.startwithbfga.field.widthInChars        = 3;
       s_start.startwithbfga.generic.id          = ID_STARTBFGA;
       s_start.startwithbfga.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithbfga.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_start.ft.generic.type  = MTYPE_BITMAP;
       s_start.ft.generic.name  = ART_FT;
       s_start.ft.generic.flags = QMF_INACTIVE;
       s_start.ft.generic.x        = 165;
       s_start.ft.generic.y        = y;
       s_start.ft.width            = 16;
       s_start.ft.height           = 16;

       s_start.startwithft.generic.type        = MTYPE_RADIOBUTTON;
       s_start.startwithft.generic.name         = "Flame Thrower     ";
       s_start.startwithft.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithft.generic.callback    = Start_Event;
       s_start.startwithft.generic.id          = ID_STARTFT;
       s_start.startwithft.generic.x                 = Hellfire2_X_POS-20;
       s_start.startwithft.generic.y                 = y;

       s_start.startwithfta.generic.type        = MTYPE_FIELD;
       s_start.startwithfta.generic.name          = "";
       s_start.startwithfta.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_start.startwithfta.generic.callback    = Start_Event;
       s_start.startwithfta.field.maxchars             = 3;
       s_start.startwithfta.field.widthInChars        = 3;
       s_start.startwithfta.generic.id          = ID_STARTFTA;
       s_start.startwithfta.generic.x                 = Hellfire2_X_POS+70;
       s_start.startwithfta.generic.y                 = y;

       s_start.back.generic.type        = MTYPE_BITMAP;
       s_start.back.generic.name     = ART_BACK0;
       s_start.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_start.back.generic.callback = Start_Event;
       s_start.back.generic.id          = ID_STARTBACK;
       s_start.back.generic.x           = 0;
       s_start.back.generic.y           = 475-64;
       s_start.back.width               = 128;
       s_start.back.height              = 64;
       s_start.back.focuspic         = ART_BACK1;
       s_start.back.generic.statusbar            = Hellfire_StatusBar2;

       s_start.load.generic.type        = MTYPE_BITMAP;
       s_start.load.generic.name     = ART_LOAD0;
       s_start.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_start.load.generic.callback = Start_Event;
       s_start.load.generic.id          = ID_LOAD;
       s_start.load.generic.x           = 128;
       s_start.load.generic.y           = 475-64;
       s_start.load.width               = 128;
       s_start.load.height              = 64;
       s_start.load.focuspic         = ART_LOAD1;
       s_start.load.generic.statusbar            = Hellfire_StatusBar7;

       s_start.save.generic.type        = MTYPE_BITMAP;
       s_start.save.generic.name     = ART_SAVE0;
       s_start.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_start.save.generic.callback = Start_Event;
       s_start.save.generic.id          = ID_SAVE;
       s_start.save.generic.x           = 384;
       s_start.save.generic.y           = 475-64;
       s_start.save.width               = 128;
       s_start.save.height              = 64;
       s_start.save.focuspic         = ART_SAVE1;
       s_start.save.generic.statusbar            = Hellfire_StatusBar8;

       s_start.accept.generic.type        = MTYPE_BITMAP;
       s_start.accept.generic.name     = ART_ACCEPT0;
       s_start.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_start.accept.generic.callback = Start_Event;
       s_start.accept.generic.id          = ID_ACCEPT;
       s_start.accept.generic.x           = 512;
       s_start.accept.generic.y           = 475-64;
       s_start.accept.width               = 128;
       s_start.accept.height              = 64;
       s_start.accept.focuspic         = ART_ACCEPT1;
       s_start.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_start.menu, &s_start.banner );
       Menu_AddItem( &s_start.menu, &s_start.framel );
       Menu_AddItem( &s_start.menu, &s_start.framer );
       Menu_AddItem( &s_start.menu, &s_start.mg );
       Menu_AddItem( &s_start.menu, &s_start.sg );
       Menu_AddItem( &s_start.menu, &s_start.gl );
       Menu_AddItem( &s_start.menu, &s_start.rl );
       Menu_AddItem( &s_start.menu, &s_start.lg );
       Menu_AddItem( &s_start.menu, &s_start.rg );
       Menu_AddItem( &s_start.menu, &s_start.pg );
       Menu_AddItem( &s_start.menu, &s_start.bfg );
       Menu_AddItem( &s_start.menu, &s_start.ft );

       Menu_AddItem( &s_start.menu, &s_start.startwithmg );
       Menu_AddItem( &s_start.menu, &s_start.startwithmga );
       Menu_AddItem( &s_start.menu, &s_start.startwithsg );
       Menu_AddItem( &s_start.menu, &s_start.startwithsga );
       Menu_AddItem( &s_start.menu, &s_start.startwithgl );
       Menu_AddItem( &s_start.menu, &s_start.startwithgla );
       Menu_AddItem( &s_start.menu, &s_start.startwithrl );
       Menu_AddItem( &s_start.menu, &s_start.startwithrla );
       Menu_AddItem( &s_start.menu, &s_start.startwithlg );
       Menu_AddItem( &s_start.menu, &s_start.startwithlga );
       Menu_AddItem( &s_start.menu, &s_start.startwithpg );
       Menu_AddItem( &s_start.menu, &s_start.startwithpga );
       Menu_AddItem( &s_start.menu, &s_start.startwithrg );
       Menu_AddItem( &s_start.menu, &s_start.startwithrga );
       Menu_AddItem( &s_start.menu, &s_start.startwithbfg );
       Menu_AddItem( &s_start.menu, &s_start.startwithbfga );
       Menu_AddItem( &s_start.menu, &s_start.startwithft );
       Menu_AddItem( &s_start.menu, &s_start.startwithfta );
       Menu_AddItem( &s_start.menu, &s_start.back );
       Menu_AddItem( &s_start.menu, &s_start.load );
       Menu_AddItem( &s_start.menu, &s_start.save );
       Menu_AddItem( &s_start.menu, &s_start.accept );

       s_start.startwithmg.curvalue        = trap_Cvar_VariableValue( "startwithmg" ) != 0;
       s_start.startwithsg.curvalue        = trap_Cvar_VariableValue( "startwithsg" ) != 0;
       s_start.startwithgl.curvalue        = trap_Cvar_VariableValue( "startwithgl" ) != 0;
       s_start.startwithrl.curvalue        = trap_Cvar_VariableValue( "startwithrl" ) != 0;
       s_start.startwithlg.curvalue        = trap_Cvar_VariableValue( "startwithlg" ) != 0;
       s_start.startwithpg.curvalue        = trap_Cvar_VariableValue( "startwithpg" ) != 0;
       s_start.startwithrg.curvalue        = trap_Cvar_VariableValue( "startwithrg" ) != 0;
       s_start.startwithbfg.curvalue        = trap_Cvar_VariableValue( "startwithbfg" ) != 0;
       s_start.startwithft.curvalue        = trap_Cvar_VariableValue( "startwithft" ) != 0;
       Q_strncpyz( s_start.startwithmga.field.buffer, UI_Cvar_VariableString("startwithmgammo"), sizeof(s_start.startwithmga.field.buffer) );
       Q_strncpyz( s_start.startwithsga.field.buffer, UI_Cvar_VariableString("startwithsgammo"), sizeof(s_start.startwithsga.field.buffer) );
       Q_strncpyz( s_start.startwithgla.field.buffer, UI_Cvar_VariableString("startwithglammo"), sizeof(s_start.startwithgla.field.buffer) );
       Q_strncpyz( s_start.startwithrla.field.buffer, UI_Cvar_VariableString("startwithrlammo"), sizeof(s_start.startwithrla.field.buffer) );
       Q_strncpyz( s_start.startwithlga.field.buffer, UI_Cvar_VariableString("startwithlgammo"), sizeof(s_start.startwithlga.field.buffer) );
       Q_strncpyz( s_start.startwithrga.field.buffer, UI_Cvar_VariableString("startwithrgammo"), sizeof(s_start.startwithrga.field.buffer) );
       Q_strncpyz( s_start.startwithpga.field.buffer, UI_Cvar_VariableString("startwithpgammo"), sizeof(s_start.startwithpga.field.buffer) );
       Q_strncpyz( s_start.startwithbfga.field.buffer, UI_Cvar_VariableString("startwithbfgammo"), sizeof(s_start.startwithbfga.field.buffer) );
       Q_strncpyz( s_start.startwithfta.field.buffer, UI_Cvar_VariableString("startwithftammo"), sizeof(s_start.startwithfta.field.buffer) );
       UI_PushMenu( &s_start.menu );
}

static void Runes_Event( void* ptr, int notification ) {
       int num=0;
	if( notification != QM_ACTIVATED ) {
		return;
	}
	switch( ((menucommon_s*)ptr)->id ) {
       case ID_ACCEPT:
       /*
              trap_Cvar_SetValue( "amplifier", s_start.amplifier.curvalue );
              trap_Cvar_SetValue( "startwithsg", s_start.startwithsg.curvalue );
              trap_Cvar_SetValue( "startwithgl", s_start.startwithgl.curvalue );
              trap_Cvar_SetValue( "startwithrl", s_start.startwithrl.curvalue );
              trap_Cvar_SetValue( "startwithlg", s_start.startwithlg.curvalue );
              trap_Cvar_SetValue( "startwithpg", s_start.startwithpg.curvalue );
              trap_Cvar_SetValue( "startwithrg", s_start.startwithrg.curvalue );
              trap_Cvar_SetValue( "startwithbfg", s_start.startwithbfg.curvalue );
              trap_Cvar_SetValue( "startwithft", s_start.startwithft.curvalue );
       */
              if (s_runes.amplifier.curvalue == 1)
                     num++;
              if (s_runes.resist.curvalue == 1)
                     num+=2;
              if (s_runes.healer.curvalue == 1)
                     num+=4;
              if (s_runes.booster.curvalue == 1)
                     num+=8;
              if (s_runes.lifter.curvalue == 1)
                     num+=16;
              if (s_runes.cloaker.curvalue == 1)
                     num+=32;
              trap_Cvar_SetValue( "runeflags", num );
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_STARTBACK:
              UI_PopMenu();
              break;

	}
}

static void Runes_Draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_runes.menu );

       if( s_runes.draw ) {
              s_runes.draw();
	}
}


static void UI_RUNES_MENU( void )
{
	int				y;

       memset( &s_runes, 0 ,sizeof(runes_t) );

       Hellfire_Cache();

       s_runes.menu.wrapAround = qtrue;
       s_runes.menu.fullscreen = qtrue;
       s_runes.menu.draw = Runes_Draw;

       s_runes.banner.generic.type  = MTYPE_PTEXT;
       s_runes.banner.generic.x        = 320;
       s_runes.banner.generic.y        = 32;
       s_runes.banner.string           = "RUNE OPTIONS";
       s_runes.banner.color         = color_orange;
       s_runes.banner.style         = UI_CENTER;

       s_runes.framel.generic.type  = MTYPE_BITMAP;
       s_runes.framel.generic.name  = ART_FRAMEL;
       s_runes.framel.generic.flags = QMF_INACTIVE;
       s_runes.framel.generic.x        = 0;
       s_runes.framel.generic.y        = 78;
       s_runes.framel.width            = 256;
       s_runes.framel.height           = 329;

       s_runes.framer.generic.type  = MTYPE_BITMAP;
       s_runes.framer.generic.name  = ART_FRAMER;
       s_runes.framer.generic.flags = QMF_INACTIVE;
       s_runes.framer.generic.x        = 0;
       s_runes.framer.generic.y        = 0;
       s_runes.framer.width            = 640;
       s_runes.framer.height           = 480;

       y = 154;
	y += BIGCHAR_HEIGHT+2+4;

       s_runes.ap.generic.type  = MTYPE_BITMAP;
       s_runes.ap.generic.name  = ART_AP;
       s_runes.ap.generic.flags = QMF_INACTIVE;
       s_runes.ap.generic.x        = 185;
       s_runes.ap.generic.y        = y;
       s_runes.ap.width            = 16;
       s_runes.ap.height           = 16;

       s_runes.amplifier.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.amplifier.generic.name          = "Amplifier         ";
       s_runes.amplifier.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.amplifier.generic.callback    = Runes_Event;
       s_runes.amplifier.generic.id          = ID_AMPLIFIER;
       s_runes.amplifier.generic.x                 = Hellfire2_X_POS;
       s_runes.amplifier.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_runes.dp.generic.type  = MTYPE_BITMAP;
       s_runes.dp.generic.name  = ART_DP;
       s_runes.dp.generic.flags = QMF_INACTIVE;
       s_runes.dp.generic.x        = 185;
       s_runes.dp.generic.y        = y;
       s_runes.dp.width            = 16;
       s_runes.dp.height           = 16;

       s_runes.resist.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.resist.generic.name          = "Resist            ";
       s_runes.resist.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.resist.generic.callback    = Runes_Event;
       s_runes.resist.generic.id          = ID_RESIST;
       s_runes.resist.generic.x                 = Hellfire2_X_POS;
       s_runes.resist.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_runes.hl.generic.type  = MTYPE_BITMAP;
       s_runes.hl.generic.name  = ART_HL;
       s_runes.hl.generic.flags = QMF_INACTIVE;
       s_runes.hl.generic.x        = 185;
       s_runes.hl.generic.y        = y;
       s_runes.hl.width            = 16;
       s_runes.hl.height           = 16;

       s_runes.healer.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.healer.generic.name          = "Auto Doc          ";
       s_runes.healer.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.healer.generic.callback    = Runes_Event;
       s_runes.healer.generic.id          = ID_HEALER;
       s_runes.healer.generic.x                 = Hellfire2_X_POS;
       s_runes.healer.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_runes.bs.generic.type  = MTYPE_BITMAP;
       s_runes.bs.generic.name  = ART_BS;
       s_runes.bs.generic.flags = QMF_INACTIVE;
       s_runes.bs.generic.x        = 185;
       s_runes.bs.generic.y        = y;
       s_runes.bs.width            = 16;
       s_runes.bs.height           = 16;

       s_runes.booster.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.booster.generic.name          = "Haste             ";
       s_runes.booster.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.booster.generic.callback    = Runes_Event;
       s_runes.booster.generic.id          = ID_BOOSTER;
       s_runes.booster.generic.x                 = Hellfire2_X_POS;
       s_runes.booster.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_runes.lt.generic.type  = MTYPE_BITMAP;
       s_runes.lt.generic.name  = ART_LT;
       s_runes.lt.generic.flags = QMF_INACTIVE;
       s_runes.lt.generic.x        = 185;
       s_runes.lt.generic.y        = y;
       s_runes.lt.width            = 16;
       s_runes.lt.height           = 16;

       s_runes.lifter.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.lifter.generic.name          = "Anti-Gravity      ";
       s_runes.lifter.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.lifter.generic.callback    = Runes_Event;
       s_runes.lifter.generic.id          = ID_LIFTER;
       s_runes.lifter.generic.x                 = Hellfire2_X_POS;
       s_runes.lifter.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2+4;
       s_runes.ck.generic.type  = MTYPE_BITMAP;
       s_runes.ck.generic.name  = ART_CK;
       s_runes.ck.generic.flags = QMF_INACTIVE;
       s_runes.ck.generic.x        = 185;
       s_runes.ck.generic.y        = y;
       s_runes.ck.width            = 16;
       s_runes.ck.height           = 16;

       s_runes.cloaker.generic.type        = MTYPE_RADIOBUTTON;
       s_runes.cloaker.generic.name          = "Cloak             ";
       s_runes.cloaker.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_runes.cloaker.generic.callback    = Runes_Event;
       s_runes.cloaker.generic.id          = ID_CLOAKER;
       s_runes.cloaker.generic.x                 = Hellfire2_X_POS;
       s_runes.cloaker.generic.y                 = y;

       s_runes.back.generic.type        = MTYPE_BITMAP;
       s_runes.back.generic.name     = ART_BACK0;
       s_runes.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_runes.back.generic.callback = Runes_Event;
       s_runes.back.generic.id          = ID_STARTBACK;
       s_runes.back.generic.x           = 0;
       s_runes.back.generic.y           = 475-64;
       s_runes.back.width               = 128;
       s_runes.back.height              = 64;
       s_runes.back.focuspic         = ART_BACK1;
       s_runes.back.generic.statusbar            = Hellfire_StatusBar2;

       s_runes.load.generic.type        = MTYPE_BITMAP;
       s_runes.load.generic.name     = ART_LOAD0;
       s_runes.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_runes.load.generic.callback = Runes_Event;
       s_runes.load.generic.id          = ID_LOAD;
       s_runes.load.generic.x           = 128;
       s_runes.load.generic.y           = 475-64;
       s_runes.load.width               = 128;
       s_runes.load.height              = 64;
       s_runes.load.focuspic         = ART_LOAD1;
       s_runes.load.generic.statusbar            = Hellfire_StatusBar7;

       s_runes.save.generic.type        = MTYPE_BITMAP;
       s_runes.save.generic.name     = ART_SAVE0;
       s_runes.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_runes.save.generic.callback = Runes_Event;
       s_runes.save.generic.id          = ID_SAVE;
       s_runes.save.generic.x           = 384;
       s_runes.save.generic.y           = 475-64;
       s_runes.save.width               = 128;
       s_runes.save.height              = 64;
       s_runes.save.focuspic         = ART_SAVE1;
       s_runes.save.generic.statusbar            = Hellfire_StatusBar8;

       s_runes.accept.generic.type        = MTYPE_BITMAP;
       s_runes.accept.generic.name     = ART_ACCEPT0;
       s_runes.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_runes.accept.generic.callback = Runes_Event;
       s_runes.accept.generic.id          = ID_ACCEPT;
       s_runes.accept.generic.x           = 512;
       s_runes.accept.generic.y           = 475-64;
       s_runes.accept.width               = 128;
       s_runes.accept.height              = 64;
       s_runes.accept.focuspic         = ART_ACCEPT1;
       s_runes.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_runes.menu, &s_runes.banner );
       Menu_AddItem( &s_runes.menu, &s_runes.framel );
       Menu_AddItem( &s_runes.menu, &s_runes.framer );
       Menu_AddItem( &s_runes.menu, &s_runes.ap );
       Menu_AddItem( &s_runes.menu, &s_runes.dp );
       Menu_AddItem( &s_runes.menu, &s_runes.hl );
       Menu_AddItem( &s_runes.menu, &s_runes.bs );
       Menu_AddItem( &s_runes.menu, &s_runes.lt );
       Menu_AddItem( &s_runes.menu, &s_runes.ck );

       Menu_AddItem( &s_runes.menu, &s_runes.amplifier);
       Menu_AddItem( &s_runes.menu, &s_runes.resist );
       Menu_AddItem( &s_runes.menu, &s_runes.healer );
       Menu_AddItem( &s_runes.menu, &s_runes.booster );
       Menu_AddItem( &s_runes.menu, &s_runes.lifter );
       Menu_AddItem( &s_runes.menu, &s_runes.cloaker );
       Menu_AddItem( &s_runes.menu, &s_runes.back );
       Menu_AddItem( &s_runes.menu, &s_runes.load );
       Menu_AddItem( &s_runes.menu, &s_runes.save );
       Menu_AddItem( &s_runes.menu, &s_runes.accept );
       if (runeflags.integer & MD_AMPLIFIER)
              s_runes.amplifier.curvalue = 1;
       if (runeflags.integer & MD_RESIST)
              s_runes.resist.curvalue = 1;
       if (runeflags.integer & MD_HEALER)
              s_runes.healer.curvalue = 1;
       if (runeflags.integer & MD_BOOSTER)
              s_runes.booster.curvalue = 1;
       if (runeflags.integer & MD_LIFTER)
              s_runes.lifter.curvalue = 1;
       if (runeflags.integer & MD_CLOAKER)
              s_runes.cloaker.curvalue = 1;

       UI_PushMenu( &s_runes.menu );
}
static void WeaponRanking_Event( void* ptr, int notification ) {
       char temp[8192];

	if( notification != QM_ACTIVATED ) {
		return;
	}
	switch( ((menucommon_s*)ptr)->id ) {

       case ID_WEAPON:
              if (s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon.curvalue++;
                     if (s_weaponranking.weapon.curvalue > 9)
                            s_weaponranking.weapon.curvalue = 0;
              }
              break;

       case ID_WEAPON2:
              if (s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon2.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon2.curvalue++;
                     if (s_weaponranking.weapon2.curvalue > 9)
                            s_weaponranking.weapon2.curvalue = 0;
              }
              break;

       case ID_WEAPON3:
              if (s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon3.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon3.curvalue++;
                     if (s_weaponranking.weapon3.curvalue > 9)
                            s_weaponranking.weapon3.curvalue = 0;
              }
              break;

       case ID_WEAPON4:
              if (s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon4.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon4.curvalue++;
                     if (s_weaponranking.weapon4.curvalue > 9)
                            s_weaponranking.weapon4.curvalue = 0;
              }
              break;

       case ID_WEAPON5:
              if (s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9
               || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon5.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon5.curvalue++;
                     if (s_weaponranking.weapon5.curvalue > 9)
                            s_weaponranking.weapon5.curvalue = 0;
              }
              break;

       case ID_WEAPON6:
              if (s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9
               || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon6.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon6.curvalue++;
                     if (s_weaponranking.weapon6.curvalue > 9)
                            s_weaponranking.weapon6.curvalue = 0;
              }
              break;

       case ID_WEAPON7:
              if (s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon7.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon7.curvalue++;
                     if (s_weaponranking.weapon7.curvalue > 9)
                            s_weaponranking.weapon7.curvalue = 0;
              }
              break;

       case ID_WEAPON8:
              if (s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon8.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon8.curvalue++;
                     if (s_weaponranking.weapon8.curvalue > 9)
                            s_weaponranking.weapon8.curvalue = 0;
              }
              break;

       case ID_WEAPON9:
              if (s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9 || s_weaponranking.weapon9.curvalue == 9 && s_weaponranking.weapon10.curvalue == 9)
              {
                     s_weaponranking.weapon9.curvalue++;
                     if (s_weaponranking.weapon9.curvalue > 9)
                            s_weaponranking.weapon9.curvalue = 0;
              }
              break;

       case ID_WEAPON10:
              if (s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon3.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon4.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon5.curvalue == 9
               || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon6.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon7.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon8.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon9.curvalue == 9 || s_weaponranking.weapon10.curvalue == 9 && s_weaponranking.weapon2.curvalue == 9)
              {
                     s_weaponranking.weapon10.curvalue++;
                     if (s_weaponranking.weapon10.curvalue > 9)
                            s_weaponranking.weapon10.curvalue = 0;
              }
              break;

       case ID_ACCEPT:
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon2.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield2.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield2.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon3.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield3.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield3.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon4.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield4.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield4.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon5.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield5.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield5.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon6.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield6.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield6.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon7.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield7.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield7.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon8.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield8.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield8.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon9.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield9.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield9.field.buffer) );
              trap_Cvar_SetValue("temporder", s_weaponranking.weapon10.curvalue+1);
              Q_strncpyz( s_weaponranking.testfield10.field.buffer, UI_Cvar_VariableString("temporder"), sizeof(s_weaponranking.testfield10.field.buffer) );

              strcpy(temp, "11/");
              strcat(temp, s_weaponranking.testfield.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield2.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield3.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield4.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield5.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield6.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield7.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield8.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield9.field.buffer);
              strcat(temp, "/");
              strcat(temp, s_weaponranking.testfield10.field.buffer);
              trap_Cvar_Set("cg_weaponOrder", temp);
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_BACK:
              UI_PopMenu();
              break;

	}
}

static void WeaponRanking_Draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_weaponranking.menu );

       if( s_weaponranking.draw ) {
              s_weaponranking.draw();
	}
}

static void UI_WEAPONRANKING_MENU( void )
{
	int				y;
       int                         num;
       memset( &s_weaponranking, 0 ,sizeof(weaponranking_t) );

       Hellfire_Cache();

       s_weaponranking.menu.wrapAround = qtrue;
       s_weaponranking.menu.fullscreen = qtrue;
       s_weaponranking.menu.draw = WeaponRanking_Draw;

       s_weaponranking.banner.generic.type  = MTYPE_PTEXT;
       s_weaponranking.banner.generic.x        = 320;
       s_weaponranking.banner.generic.y        = 32;
       s_weaponranking.banner.string           = "WEAPON RANKING";
       s_weaponranking.banner.color         = color_orange;
       s_weaponranking.banner.style         = UI_CENTER;

       s_weaponranking.framel.generic.type  = MTYPE_BITMAP;
       s_weaponranking.framel.generic.name  = ART_FRAMEL;
       s_weaponranking.framel.generic.flags = QMF_INACTIVE;
       s_weaponranking.framel.generic.x        = 0;
       s_weaponranking.framel.generic.y        = 78;
       s_weaponranking.framel.width            = 256;
       s_weaponranking.framel.height           = 329;

       s_weaponranking.framer.generic.type  = MTYPE_BITMAP;
       s_weaponranking.framer.generic.name  = ART_FRAMER;
       s_weaponranking.framer.generic.flags = QMF_INACTIVE;
       s_weaponranking.framer.generic.x        = 0;
       s_weaponranking.framer.generic.y        = 0;
       s_weaponranking.framer.width            = 640;
       s_weaponranking.framer.height           = 480;

       y = 100;
	y += BIGCHAR_HEIGHT+2+4;

       s_weaponranking.testfield.generic.type              = MTYPE_FIELD;
       s_weaponranking.testfield.generic.name             = "Weapon Order";
       s_weaponranking.testfield.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.testfield.field.maxchars             = 21;
       s_weaponranking.testfield.field.widthInChars        = 21;
       s_weaponranking.testfield.generic.callback          = WeaponRanking_Event;
       s_weaponranking.testfield.generic.id                = ID_TESTFIELD;
       s_weaponranking.testfield.generic.x                    = Hellfire_X_POS-50;
       s_weaponranking.testfield.generic.y                    = y;

       s_weaponranking.testfield2.generic.type              = MTYPE_FIELD;
       s_weaponranking.testfield2.generic.name             = "Weapon Order";
       s_weaponranking.testfield2.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.testfield2.field.maxchars             = 21;
       s_weaponranking.testfield2.field.widthInChars        = 21;
       s_weaponranking.testfield2.generic.callback          = WeaponRanking_Event;
       s_weaponranking.testfield2.generic.id                = ID_TESTFIELD2;
       s_weaponranking.testfield2.generic.x                    = Hellfire_X_POS-50;
       s_weaponranking.testfield2.generic.y                    = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon10.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon10.generic.name          = " Top Priority - 1st:";
       s_weaponranking.weapon10.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon10.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon10.generic.id          = ID_WEAPON10;
       s_weaponranking.weapon10.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon10.generic.y                 = y;
       s_weaponranking.weapon10.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon9.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon9.generic.name          = "                 2nd:";
       s_weaponranking.weapon9.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon9.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon9.generic.id          = ID_WEAPON9;
       s_weaponranking.weapon9.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon9.generic.y                 = y;
       s_weaponranking.weapon9.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon8.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon8.generic.name          = "                 3rd:";
       s_weaponranking.weapon8.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon8.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon8.generic.id          = ID_WEAPON8;
       s_weaponranking.weapon8.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon8.generic.y                 = y;
       s_weaponranking.weapon8.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon7.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon7.generic.name          = "                 4th:";
       s_weaponranking.weapon7.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon7.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon7.generic.id          = ID_WEAPON7;
       s_weaponranking.weapon7.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon7.generic.y                 = y;
       s_weaponranking.weapon7.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon6.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon6.generic.name          = "                 5th:";
       s_weaponranking.weapon6.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon6.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon6.generic.id          = ID_WEAPON6;
       s_weaponranking.weapon6.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon6.generic.y                 = y;
       s_weaponranking.weapon6.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon5.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon5.generic.name          = "                 6th:";
       s_weaponranking.weapon5.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon5.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon5.generic.id          = ID_WEAPON5;
       s_weaponranking.weapon5.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon5.generic.y                 = y;
       s_weaponranking.weapon5.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon4.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon4.generic.name          = "                 7th:";
       s_weaponranking.weapon4.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon4.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon4.generic.id          = ID_WEAPON4;
       s_weaponranking.weapon4.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon4.generic.y                 = y;
       s_weaponranking.weapon4.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon3.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon3.generic.name          = "                 8th:";
       s_weaponranking.weapon3.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon3.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon3.generic.id          = ID_WEAPON3;
       s_weaponranking.weapon3.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon3.generic.y                 = y;
       s_weaponranking.weapon3.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon2.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon2.generic.name          = "                 9th:";
       s_weaponranking.weapon2.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon2.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon2.generic.id          = ID_WEAPON2;
       s_weaponranking.weapon2.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon2.generic.y                 = y;
       s_weaponranking.weapon2.itemnames             = weapon_items;

       y += BIGCHAR_HEIGHT+2;
       s_weaponranking.weapon.generic.type              = MTYPE_SPINCONTROL;
       s_weaponranking.weapon.generic.name          = "Lowest Priority - 10th:";
       s_weaponranking.weapon.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponranking.weapon.generic.callback    = WeaponRanking_Event;
       s_weaponranking.weapon.generic.id          = ID_WEAPON;
       s_weaponranking.weapon.generic.x                 = Hellfire_X_POS-50;
       s_weaponranking.weapon.generic.y                 = y;
       s_weaponranking.weapon.itemnames             = weapon_items;

       s_weaponranking.back.generic.type        = MTYPE_BITMAP;
       s_weaponranking.back.generic.name     = ART_BACK0;
       s_weaponranking.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponranking.back.generic.callback = WeaponRanking_Event;
       s_weaponranking.back.generic.id          = ID_BACK;
       s_weaponranking.back.generic.x           = 0;
       s_weaponranking.back.generic.y           = 475-64;
       s_weaponranking.back.width               = 128;
       s_weaponranking.back.height              = 64;
       s_weaponranking.back.focuspic         = ART_BACK1;
       s_weaponranking.back.generic.statusbar            = Hellfire_StatusBar2;

       s_weaponranking.load.generic.type        = MTYPE_BITMAP;
       s_weaponranking.load.generic.name     = ART_LOAD0;
       s_weaponranking.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponranking.load.generic.callback = WeaponRanking_Event;
       s_weaponranking.load.generic.id          = ID_LOAD;
       s_weaponranking.load.generic.x           = 128;
       s_weaponranking.load.generic.y           = 475-64;
       s_weaponranking.load.width               = 128;
       s_weaponranking.load.height              = 64;
       s_weaponranking.load.focuspic         = ART_LOAD1;
       s_weaponranking.load.generic.statusbar            = Hellfire_StatusBar7;

       s_weaponranking.save.generic.type        = MTYPE_BITMAP;
       s_weaponranking.save.generic.name     = ART_SAVE0;
       s_weaponranking.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponranking.save.generic.callback = WeaponRanking_Event;
       s_weaponranking.save.generic.id          = ID_SAVE;
       s_weaponranking.save.generic.x           = 384;
       s_weaponranking.save.generic.y           = 475-64;
       s_weaponranking.save.width               = 128;
       s_weaponranking.save.height              = 64;
       s_weaponranking.save.focuspic         = ART_SAVE1;
       s_weaponranking.save.generic.statusbar            = Hellfire_StatusBar8;

       s_weaponranking.accept.generic.type        = MTYPE_BITMAP;
       s_weaponranking.accept.generic.name     = ART_ACCEPT0;
       s_weaponranking.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponranking.accept.generic.callback = WeaponRanking_Event;
       s_weaponranking.accept.generic.id          = ID_ACCEPT;
       s_weaponranking.accept.generic.x           = 512;
       s_weaponranking.accept.generic.y           = 475-64;
       s_weaponranking.accept.width               = 128;
       s_weaponranking.accept.height              = 64;
       s_weaponranking.accept.focuspic         = ART_ACCEPT1;
       s_weaponranking.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.banner );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.framel );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.framer );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon10);
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon9 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon8 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon7 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon6 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon5 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon4 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon3 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon2 );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.weapon );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.back );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.load );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.save );
       Menu_AddItem( &s_weaponranking.menu, &s_weaponranking.accept );

       Q_strncpyz( s_weaponranking.testfield.field.buffer, UI_Cvar_VariableString("cg_weaponOrder"), sizeof(s_weaponranking.testfield.field.buffer) );
       if (s_weaponranking.testfield.field.buffer[0] == '1' && s_weaponranking.testfield.field.buffer[1] == '1' && s_weaponranking.testfield.field.buffer[2] == '/')
              num = 3;
       else
              num = 0;
       s_weaponranking.weapon.curvalue = (int)(s_weaponranking.testfield.field.buffer[0+num]) - 49;
       if (s_weaponranking.testfield.field.buffer[1+num] == '0' )
              s_weaponranking.weapon.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[2+num] == '/')
              s_weaponranking.weapon2.curvalue = (int)(s_weaponranking.testfield.field.buffer[3+num]) - 49;
       else
              s_weaponranking.weapon2.curvalue = (int)(s_weaponranking.testfield.field.buffer[2+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[3+num] == '0' )
              s_weaponranking.weapon2.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[4+num] == '/')
              s_weaponranking.weapon3.curvalue = (int)(s_weaponranking.testfield.field.buffer[5+num]) - 49;
       else
              s_weaponranking.weapon3.curvalue = (int)(s_weaponranking.testfield.field.buffer[4+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[5+num] == '0' )
              s_weaponranking.weapon3.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[6+num] == '/')
              s_weaponranking.weapon4.curvalue = (int)(s_weaponranking.testfield.field.buffer[7+num]) - 49;
       else
              s_weaponranking.weapon4.curvalue = (int)(s_weaponranking.testfield.field.buffer[6+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[7+num] == '0' )
              s_weaponranking.weapon4.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[8+num] == '/')
              s_weaponranking.weapon5.curvalue = (int)(s_weaponranking.testfield.field.buffer[9+num]) - 49;
       else
              s_weaponranking.weapon5.curvalue = (int)(s_weaponranking.testfield.field.buffer[8+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[9+num] == '0' )
              s_weaponranking.weapon5.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[10+num] == '/')
              s_weaponranking.weapon6.curvalue = (int)(s_weaponranking.testfield.field.buffer[11+num]) - 49;
       else
              s_weaponranking.weapon6.curvalue = (int)(s_weaponranking.testfield.field.buffer[10+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[11+num] == '0')
              s_weaponranking.weapon6.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[12+num] == '/')
              s_weaponranking.weapon7.curvalue = (int)(s_weaponranking.testfield.field.buffer[13+num]) - 49;
       else
              s_weaponranking.weapon7.curvalue = (int)(s_weaponranking.testfield.field.buffer[12+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[13+num] == '0')
              s_weaponranking.weapon7.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[14+num] == '/')
              s_weaponranking.weapon8.curvalue = (int)(s_weaponranking.testfield.field.buffer[15+num]) - 49;
       else
              s_weaponranking.weapon8.curvalue = (int)(s_weaponranking.testfield.field.buffer[14+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[15+num] == '0')
              s_weaponranking.weapon8.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[16+num] == '/')
              s_weaponranking.weapon9.curvalue = (int)(s_weaponranking.testfield.field.buffer[17+num]) - 49;
       else
              s_weaponranking.weapon9.curvalue = (int)(s_weaponranking.testfield.field.buffer[16+num]) - 49;

       if (s_weaponranking.testfield.field.buffer[17+num] == '0')
              s_weaponranking.weapon9.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[18+num] == '/')
              s_weaponranking.weapon10.curvalue = (int)(s_weaponranking.testfield.field.buffer[19+num])- 49;
       else
              s_weaponranking.weapon10.curvalue = (int)(s_weaponranking.testfield.field.buffer[18+num])- 49;

       if (s_weaponranking.testfield.field.buffer[19+num] == '0')
              s_weaponranking.weapon10.curvalue = 9;
       if (s_weaponranking.testfield.field.buffer[18+num] == '\0')
              s_weaponranking.weapon10.curvalue = 9;
       UI_PushMenu( &s_weaponranking.menu );
}
static void BotOptions_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_BOTCHAT:
              trap_Cvar_SetValue( "bot_nochat", s_botoptions.botchat.curvalue);
              break;

       case ID_BOTFASTCHAT:
              trap_Cvar_SetValue( "bot_fastchat", s_botoptions.fastchat.curvalue);
              break;

       case ID_BOTCHALLENGE:
              trap_Cvar_SetValue( "bot_challenge", s_botoptions.challenge.curvalue);
              break;

       case ID_BOTROCKETJUMP:
              trap_Cvar_SetValue( "bot_rocketjump", s_botoptions.rocketjump.curvalue);
              break;
       */
       case ID_ACCEPT:
              trap_Cvar_SetValue( "bot_nochat", s_botoptions.botchat.curvalue );
              trap_Cvar_SetValue( "bot_fastchat", s_botoptions.fastchat.curvalue );
              trap_Cvar_SetValue( "bot_challenge", s_botoptions.challenge.curvalue );
              trap_Cvar_SetValue( "bot_rocketjump", s_botoptions.rocketjump.curvalue );
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_BOTOPTIONSBACK:
              UI_PopMenu();
              break;

	}
}

static void botoptions_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_botoptions.menu );

       if( s_botoptions.draw ) {
              s_botoptions.draw();
       }
}

static void UI_BOTOPTIONS_MENU( void )
{
	int				y;
       vmCvar_t botnochat;
       vmCvar_t botfastchat;
       vmCvar_t botchallenge;
       vmCvar_t botrocketjump;
       memset( &s_botoptions, 0 ,sizeof(botoptions_t) );

       Hellfire_Cache();

       s_botoptions.menu.wrapAround = qtrue;
       s_botoptions.menu.fullscreen = qtrue;
       s_botoptions.menu.draw       = botoptions_draw;

       s_botoptions.banner.generic.type  = MTYPE_PTEXT;
       s_botoptions.banner.generic.x        = 320;
       s_botoptions.banner.generic.y        = 32;
       s_botoptions.banner.string           = "BOT OPTIONS";
       s_botoptions.banner.color         = color_orange;
       s_botoptions.banner.style         = UI_CENTER;

       s_botoptions.framel.generic.type  = MTYPE_BITMAP;
       s_botoptions.framel.generic.name  = ART_FRAMEL;
       s_botoptions.framel.generic.flags = QMF_INACTIVE;
       s_botoptions.framel.generic.x        = 0;
       s_botoptions.framel.generic.y        = 78;
       s_botoptions.framel.width            = 256;
       s_botoptions.framel.height           = 329;

       s_botoptions.framer.generic.type  = MTYPE_BITMAP;
       s_botoptions.framer.generic.name  = ART_FRAMER;
       s_botoptions.framer.generic.flags = QMF_INACTIVE;
       s_botoptions.framer.generic.x        = 0;
       s_botoptions.framer.generic.y        = 0;
       s_botoptions.framer.width            = 640;
       s_botoptions.framer.height           = 480;

       y = 184;
	y += BIGCHAR_HEIGHT+2;
       s_botoptions.botchat.generic.type              = MTYPE_SPINCONTROL;
       s_botoptions.botchat.generic.name          = "Bot Chatting:";
       s_botoptions.botchat.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_botoptions.botchat.generic.callback    = BotOptions_Event;
       s_botoptions.botchat.generic.id          = ID_BOTCHAT;
       s_botoptions.botchat.generic.x                 = Hellfire_X_POS;
       s_botoptions.botchat.generic.y                 = y;
       s_botoptions.botchat.itemnames             = botchat_items;

	y += BIGCHAR_HEIGHT+2;
       s_botoptions.fastchat.generic.type              = MTYPE_RADIOBUTTON;
       s_botoptions.fastchat.generic.name          = "Bot Fast Chatting:";
       s_botoptions.fastchat.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_botoptions.fastchat.generic.callback    = BotOptions_Event;
       s_botoptions.fastchat.generic.id          = ID_BOTFASTCHAT;
       s_botoptions.fastchat.generic.x                 = Hellfire_X_POS;
       s_botoptions.fastchat.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_botoptions.rocketjump.generic.type              = MTYPE_RADIOBUTTON;
       s_botoptions.rocketjump.generic.name          = "Bot Rocketjump:";
       s_botoptions.rocketjump.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_botoptions.rocketjump.generic.callback    = BotOptions_Event;
       s_botoptions.rocketjump.generic.id          = ID_BOTROCKETJUMP;
       s_botoptions.rocketjump.generic.x                 = Hellfire_X_POS;
       s_botoptions.rocketjump.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_botoptions.challenge.generic.type              = MTYPE_RADIOBUTTON;
       s_botoptions.challenge.generic.name          = "More Challenging Bots:";
       s_botoptions.challenge.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_botoptions.challenge.generic.callback    = BotOptions_Event;
       s_botoptions.challenge.generic.id          = ID_BOTCHALLENGE;
       s_botoptions.challenge.generic.x                 = Hellfire_X_POS;
       s_botoptions.challenge.generic.y                 = y;

       s_botoptions.back.generic.type        = MTYPE_BITMAP;
       s_botoptions.back.generic.name     = ART_BACK0;
       s_botoptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_botoptions.back.generic.callback = BotOptions_Event;
       s_botoptions.back.generic.id          = ID_BOTOPTIONSBACK;
       s_botoptions.back.generic.x           = 0;
       s_botoptions.back.generic.y           = 475-64;
       s_botoptions.back.width               = 128;
       s_botoptions.back.height              = 64;
       s_botoptions.back.focuspic         = ART_BACK1;
       s_botoptions.back.generic.statusbar            = Hellfire_StatusBar2;

       s_botoptions.load.generic.type        = MTYPE_BITMAP;
       s_botoptions.load.generic.name     = ART_LOAD0;
       s_botoptions.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_botoptions.load.generic.callback = BotOptions_Event;
       s_botoptions.load.generic.id          = ID_LOAD;
       s_botoptions.load.generic.x           = 128;
       s_botoptions.load.generic.y           = 475-64;
       s_botoptions.load.width               = 128;
       s_botoptions.load.height              = 64;
       s_botoptions.load.focuspic         = ART_LOAD1;
       s_botoptions.load.generic.statusbar            = Hellfire_StatusBar7;

       s_botoptions.save.generic.type        = MTYPE_BITMAP;
       s_botoptions.save.generic.name     = ART_SAVE0;
       s_botoptions.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_botoptions.save.generic.callback = BotOptions_Event;
       s_botoptions.save.generic.id          = ID_SAVE;
       s_botoptions.save.generic.x           = 384;
       s_botoptions.save.generic.y           = 475-64;
       s_botoptions.save.width               = 128;
       s_botoptions.save.height              = 64;
       s_botoptions.save.focuspic         = ART_SAVE1;
       s_botoptions.save.generic.statusbar            = Hellfire_StatusBar8;

       s_botoptions.accept.generic.type        = MTYPE_BITMAP;
       s_botoptions.accept.generic.name     = ART_ACCEPT0;
       s_botoptions.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_botoptions.accept.generic.callback = BotOptions_Event;
       s_botoptions.accept.generic.id          = ID_ACCEPT;
       s_botoptions.accept.generic.x           = 512;
       s_botoptions.accept.generic.y           = 475-64;
       s_botoptions.accept.width               = 128;
       s_botoptions.accept.height              = 64;
       s_botoptions.accept.focuspic         = ART_ACCEPT1;
       s_botoptions.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_botoptions.menu, &s_botoptions.banner );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.framel );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.framer );

       Menu_AddItem( &s_botoptions.menu, &s_botoptions.botchat );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.fastchat );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.rocketjump );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.challenge );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.back );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.load );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.save );
       Menu_AddItem( &s_botoptions.menu, &s_botoptions.accept );

       trap_Cvar_Register(&botnochat, "bot_nochat","", CVAR_ARCHIVE);
       trap_Cvar_Register(&botfastchat, "bot_fastchat","", CVAR_ARCHIVE);
       trap_Cvar_Register(&botchallenge, "bot_challenge","", CVAR_ARCHIVE);
       trap_Cvar_Register(&botrocketjump, "bot_rocketjump","", CVAR_ARCHIVE);
       s_botoptions.botchat.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "bot_nochat" ) );
       s_botoptions.fastchat.curvalue        = trap_Cvar_VariableValue( "bot_fastchat" ) != 0;
       s_botoptions.challenge.curvalue        = trap_Cvar_VariableValue( "bot_challenge" ) != 0;
       s_botoptions.rocketjump.curvalue        = trap_Cvar_VariableValue( "bot_rocketjump" ) != 0;
       UI_PushMenu( &s_botoptions.menu );
}

static void GameModes_Event( void* ptr, int notification ) {
       int vampiremax;
       vampiremax        = atoi( s_gamemodes.vampiremax.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_INSTAGIB:
              trap_Cvar_SetValue( "g_instagib", s_gamemodes.instagib.curvalue);
              break;

       case ID_VAMPIRE:
              trap_Cvar_SetValue( "g_vampire", s_gamemodes.vampire.curvalue);
              break;

       case ID_VAMPIREMAX:
              trap_Cvar_SetValue( "g_vampiremax", vampiremax);
              break;

       case ID_HOMING:
              trap_Cvar_SetValue( "homingmissile", s_gamemodes.homingmissile.curvalue);
              break;

       case ID_DOUBLE:
              trap_Cvar_SetValue( "doublerockets", s_gamemodes.doublerockets.curvalue);
              break;

       case ID_GRAVITY:
              trap_Cvar_SetValue( "gravity", s_gamemodes.gravity.curvalue);
              break;
       */

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_ACCEPT:
              Hellfire_SaveChanges();
              trap_Cvar_SetValue( "g_vampire", s_gamemodes.vampire.curvalue);
              trap_Cvar_SetValue( "g_vampiremax", vampiremax);
              trap_Cvar_SetValue( "g_instagib", s_gamemodes.instagib.curvalue);
              trap_Cvar_SetValue( "g_telefraginstagib", s_gamemodes.telefraginstagib.curvalue);
              trap_Cvar_SetValue( "homingmissile", s_gamemodes.homingmissile.curvalue);
              trap_Cvar_SetValue( "doublerockets", s_gamemodes.doublerockets.curvalue);
              trap_Cvar_SetValue( "gravity", s_gamemodes.gravity.curvalue);
              trap_Cvar_SetValue( "guidedrockets", s_gamemodes.guidedrockets.curvalue);
              UI_PopMenu();
              break;

       case ID_GAMEMODESBACK:
              UI_PopMenu();
              break;

	}
}

static void gamemodes_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_gamemodes.menu );

       if( s_gamemodes.draw ) {
              s_gamemodes.draw();
       }
}

static void UI_GAMEMODES_MENU( void )
{
	int				y;
       float                       h;
       vmCvar_t botnochat;
       vmCvar_t botfastchat;
       vmCvar_t botchallenge;
       vmCvar_t botrocketjump;
       memset( &s_gamemodes, 0 ,sizeof(gamemodes_t) );

       Hellfire_Cache();

       s_gamemodes.menu.key        = Hellfire_MenuKey;
       s_gamemodes.menu.wrapAround = qtrue;
       s_gamemodes.menu.fullscreen = qtrue;
       s_gamemodes.menu.draw       = gamemodes_draw;

       s_gamemodes.banner.generic.type  = MTYPE_PTEXT;
       s_gamemodes.banner.generic.x        = 320;
       s_gamemodes.banner.generic.y        = 32;
       s_gamemodes.banner.string           = "GAME MODES";
       s_gamemodes.banner.color         = color_orange;
       s_gamemodes.banner.style         = UI_CENTER;

       s_gamemodes.framel.generic.type  = MTYPE_BITMAP;
       s_gamemodes.framel.generic.name  = ART_FRAMEL;
       s_gamemodes.framel.generic.flags = QMF_INACTIVE;
       s_gamemodes.framel.generic.x        = 0;
       s_gamemodes.framel.generic.y        = 78;
       s_gamemodes.framel.width            = 256;
       s_gamemodes.framel.height           = 329;

       s_gamemodes.framer.generic.type  = MTYPE_BITMAP;
       s_gamemodes.framer.generic.name  = ART_FRAMER;
       s_gamemodes.framer.generic.flags = QMF_INACTIVE;
       s_gamemodes.framer.generic.x        = 0;
       s_gamemodes.framer.generic.y        = 0;
       s_gamemodes.framer.width            = 640;
       s_gamemodes.framer.height           = 480;

       y = 150;
	y += BIGCHAR_HEIGHT+2;
       s_gamemodes.instagib.generic.type              = MTYPE_RADIOBUTTON;
       s_gamemodes.instagib.generic.name          = "Instagib:";
       s_gamemodes.instagib.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.instagib.generic.callback    = GameModes_Event;
       s_gamemodes.instagib.generic.id          = ID_INSTAGIB;
       s_gamemodes.instagib.generic.x                 = Hellfire_X_POS;
       s_gamemodes.instagib.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gamemodes.telefraginstagib.generic.type              = MTYPE_RADIOBUTTON;
       s_gamemodes.telefraginstagib.generic.name          = "Telefrag Instagib:";
       s_gamemodes.telefraginstagib.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.telefraginstagib.generic.callback    = GameModes_Event;
       s_gamemodes.telefraginstagib.generic.id          = ID_TELEFRAGINSTAGIB;
       s_gamemodes.telefraginstagib.generic.x                 = Hellfire_X_POS;
       s_gamemodes.telefraginstagib.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gamemodes.vampire.generic.type              = MTYPE_RADIOBUTTON;
       s_gamemodes.vampire.generic.name          = "Vampire:";
       s_gamemodes.vampire.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.vampire.generic.callback    = GameModes_Event;
       s_gamemodes.vampire.generic.id          = ID_VAMPIRE;
       s_gamemodes.vampire.generic.x                 = Hellfire_X_POS;
       s_gamemodes.vampire.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_gamemodes.vampirefraction.generic.type           = MTYPE_SPINCONTROL;
       s_gamemodes.vampirefraction.generic.name          = "Vampire Fraction:";
       s_gamemodes.vampirefraction.generic.flags          = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.vampirefraction.generic.id             = ID_VAMPIREFRACTION;
       s_gamemodes.vampirefraction.generic.x                     = Hellfire_X_POS;
       s_gamemodes.vampirefraction.generic.y                     = y;
       s_gamemodes.vampirefraction.itemnames                  = vampire_items;
       s_gamemodes.vampirefraction.numitems               = 19;

       y += BIGCHAR_HEIGHT+2;
       s_gamemodes.vampiremax.generic.type           = MTYPE_FIELD;
       s_gamemodes.vampiremax.generic.name          = "Vampire's Maximum Health:";
       s_gamemodes.vampiremax.generic.flags          = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.vampiremax.field.maxchars             = 3;
       s_gamemodes.vampiremax.field.widthInChars        = 3;
       s_gamemodes.vampiremax.generic.id             = ID_VAMPIREMAX;
       s_gamemodes.vampiremax.generic.x                     = Hellfire_X_POS;
       s_gamemodes.vampiremax.generic.y                     = y;

	y += BIGCHAR_HEIGHT+2;
       s_gamemodes.homingmissile.generic.type              = MTYPE_RADIOBUTTON;
       s_gamemodes.homingmissile.generic.name          = "Homing Missiles:";
       s_gamemodes.homingmissile.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.homingmissile.generic.callback    = GameModes_Event;
       s_gamemodes.homingmissile.generic.id          = ID_HOMING;
       s_gamemodes.homingmissile.generic.x                 = Hellfire_X_POS;
       s_gamemodes.homingmissile.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gamemodes.doublerockets.generic.type              = MTYPE_RADIOBUTTON;
       s_gamemodes.doublerockets.generic.name          = "Double Rockets:";
       s_gamemodes.doublerockets.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.doublerockets.generic.callback    = GameModes_Event;
       s_gamemodes.doublerockets.generic.id          = ID_DOUBLE;
       s_gamemodes.doublerockets.generic.x                 = Hellfire_X_POS;
       s_gamemodes.doublerockets.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_gamemodes.guidedrockets.generic.type        = MTYPE_RADIOBUTTON;
       s_gamemodes.guidedrockets.generic.name          = "Guided Rockets:";
       s_gamemodes.guidedrockets.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_gamemodes.guidedrockets.generic.callback    = GameModes_Event;
       s_gamemodes.guidedrockets.generic.id          = ID_GUIDEDROCKETS;
       s_gamemodes.guidedrockets.generic.x                 = Hellfire_X_POS;
       s_gamemodes.guidedrockets.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_gamemodes.gravity.generic.type        = MTYPE_RADIOBUTTON;
       s_gamemodes.gravity.generic.name          = "Low Gravity:";
       s_gamemodes.gravity.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gamemodes.gravity.generic.callback    = GameModes_Event;
       s_gamemodes.gravity.generic.id          = ID_GRAVITY;
       s_gamemodes.gravity.generic.x                 = Hellfire_X_POS;
       s_gamemodes.gravity.generic.y                 = y;

       s_gamemodes.back.generic.type        = MTYPE_BITMAP;
       s_gamemodes.back.generic.name     = ART_BACK0;
       s_gamemodes.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gamemodes.back.generic.callback = GameModes_Event;
       s_gamemodes.back.generic.id          = ID_GAMEMODESBACK;
       s_gamemodes.back.generic.x           = 0;
       s_gamemodes.back.generic.y           = 475-64;
       s_gamemodes.back.width               = 128;
       s_gamemodes.back.height              = 64;
       s_gamemodes.back.focuspic         = ART_BACK1;
       s_gamemodes.back.generic.statusbar            = Hellfire_StatusBar2;

       s_gamemodes.load.generic.type        = MTYPE_BITMAP;
       s_gamemodes.load.generic.name     = ART_LOAD0;
       s_gamemodes.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gamemodes.load.generic.callback = GameModes_Event;
       s_gamemodes.load.generic.id          = ID_LOAD;
       s_gamemodes.load.generic.x           = 128;
       s_gamemodes.load.generic.y           = 475-64;
       s_gamemodes.load.width               = 128;
       s_gamemodes.load.height              = 64;
       s_gamemodes.load.focuspic         = ART_LOAD1;
       s_gamemodes.load.generic.statusbar            = Hellfire_StatusBar7;

       s_gamemodes.save.generic.type        = MTYPE_BITMAP;
       s_gamemodes.save.generic.name     = ART_SAVE0;
       s_gamemodes.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gamemodes.save.generic.callback = GameModes_Event;
       s_gamemodes.save.generic.id          = ID_SAVE;
       s_gamemodes.save.generic.x           = 384;
       s_gamemodes.save.generic.y           = 475-64;
       s_gamemodes.save.width               = 128;
       s_gamemodes.save.height              = 64;
       s_gamemodes.save.focuspic         = ART_SAVE1;
       s_gamemodes.save.generic.statusbar            = Hellfire_StatusBar8;

       s_gamemodes.accept.generic.type        = MTYPE_BITMAP;
       s_gamemodes.accept.generic.name     = ART_ACCEPT0;
       s_gamemodes.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gamemodes.accept.generic.callback = GameModes_Event;
       s_gamemodes.accept.generic.id          = ID_ACCEPT;
       s_gamemodes.accept.generic.x           = 512;
       s_gamemodes.accept.generic.y           = 475-64;
       s_gamemodes.accept.width               = 128;
       s_gamemodes.accept.height              = 64;
       s_gamemodes.accept.focuspic         = ART_ACCEPT1;
       s_gamemodes.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.banner );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.framel );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.framer );

       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.instagib );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.telefraginstagib );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.vampire );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.vampirefraction );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.vampiremax );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.homingmissile );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.doublerockets );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.guidedrockets );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.gravity );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.back );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.load );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.save );
       Menu_AddItem( &s_gamemodes.menu, &s_gamemodes.accept );

       s_gamemodes.doublerockets.curvalue        = trap_Cvar_VariableValue( "doublerockets" ) != 0;
       s_gamemodes.guidedrockets.curvalue        = trap_Cvar_VariableValue( "guidedrockets" ) != 0;
       s_gamemodes.homingmissile.curvalue        = trap_Cvar_VariableValue( "homingmissile" ) != 0;
       s_gamemodes.vampire.curvalue        = trap_Cvar_VariableValue( "g_vampire" ) != 0;
       s_gamemodes.instagib.curvalue        = trap_Cvar_VariableValue( "g_instagib" ) != 0;
       s_gamemodes.telefraginstagib.curvalue        = trap_Cvar_VariableValue( "g_telefraginstagib" ) != 0;
       s_gamemodes.gravity.curvalue        = trap_Cvar_VariableValue( "gravity" ) != 0;
       Q_strncpyz( s_gamemodes.vampiremax.field.buffer, UI_Cvar_VariableString("g_vampiremax"), sizeof(s_gamemodes.vampiremax.field.buffer) );
       h = Com_Clamp( 0.1, 1, trap_Cvar_VariableValue("g_vampiresteal") );
       s_gamemodes.vampirefraction.curvalue = (h / 0.05) - 2;
       UI_PushMenu( &s_gamemodes.menu );
}

static void GameOptions_Event( void* ptr, int notification ) {
       int knockback,quadfactor,intermissiontime,forcerespawn,spawnprotect,warmup;
       knockback         = atoi( s_gameoptions.knockback.field.buffer );
       quadfactor        = atoi( s_gameoptions.quadfactor.field.buffer );
       intermissiontime  = atoi( s_gameoptions.intermissiontime.field.buffer );
       forcerespawn      = atoi( s_gameoptions.forcerespawn.field.buffer );
       spawnprotect      = atoi( s_gameoptions.spawnprotect.field.buffer );
       warmup            = atoi( s_gameoptions.warmup.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_FALLING:
              trap_Cvar_SetValue( "g_falling", s_gameoptions.falling.curvalue);
              break;

       case ID_FOOTSTEPS:
              trap_Cvar_SetValue( "g_nofootsteps", s_gameoptions.footsteps.curvalue);
              break;

       case ID_FIXEDFOV:
              trap_Cvar_SetValue( "g_fixedfov", s_gameoptions.fixedfov.curvalue);
              break;

       case ID_SELFDAMAGE:
              trap_Cvar_SetValue( "g_selfdamage", s_gameoptions.selfdamage.curvalue);
              break;

       case ID_KNOCKBACK:
              trap_Cvar_SetValue( "g_knockback", knockback );
              break;

       case ID_QUADFACTOR:
              trap_Cvar_SetValue( "g_quadfactor", quadfactor );
              break;

       case ID_INTERMISSIONTIME:
              trap_Cvar_SetValue( "g_intermissiontime", intermissiontime );
              break;
       */
	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_ACCEPT:
              Hellfire2_SaveChanges();
              trap_Cvar_SetValue( "g_falling", s_gameoptions.falling.curvalue);
              trap_Cvar_SetValue( "g_nofootsteps", s_gameoptions.footsteps.curvalue);
              trap_Cvar_SetValue( "g_fixedfov", s_gameoptions.fixedfov.curvalue);
              trap_Cvar_SetValue( "g_selfdamage", s_gameoptions.selfdamage.curvalue);
              trap_Cvar_SetValue( "g_quadfactor", quadfactor );
              trap_Cvar_SetValue( "g_knockback", knockback );
              trap_Cvar_SetValue( "g_warmup", warmup );
              trap_Cvar_SetValue( "g_intermissiontime", intermissiontime );
              trap_Cvar_SetValue( "g_podiumscores", s_gameoptions.podium.curvalue );
              trap_Cvar_SetValue( "g_teamcoloredskins", s_gameoptions.teamcoloredskins.curvalue );
              trap_Cvar_SetValue( "g_forcerespawn", forcerespawn );
              trap_Cvar_SetValue( "g_spawnprotect", spawnprotect );
              UI_PopMenu();
              break;

       case ID_GAMEOPTIONSBACK:
              UI_PopMenu();
              break;
	}
}

static void gameoptions_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_gameoptions.menu );

       if( s_gameoptions.draw ) {
              s_gameoptions.draw();
       }
}

static void UI_GAMEOPTIONS_MENU( void )
{
	int				y;
       float                       h;
       vmCvar_t botnochat;
       vmCvar_t botfastchat;
       vmCvar_t botchallenge;
       vmCvar_t quadfactor;
       vmCvar_t botrocketjump;
       memset( &s_gameoptions, 0 ,sizeof(gameoptions_t) );

       Hellfire_Cache();

       s_gameoptions.menu.key        = Hellfire2_MenuKey;
       s_gameoptions.menu.wrapAround = qtrue;
       s_gameoptions.menu.fullscreen = qtrue;
       s_gameoptions.menu.draw       = gameoptions_draw;

       s_gameoptions.banner.generic.type  = MTYPE_PTEXT;
       s_gameoptions.banner.generic.x        = 320;
       s_gameoptions.banner.generic.y        = 32;
       s_gameoptions.banner.string           = "GAME OPTIONS";
       s_gameoptions.banner.color         = color_orange;
       s_gameoptions.banner.style         = UI_CENTER;

       s_gameoptions.framel.generic.type  = MTYPE_BITMAP;
       s_gameoptions.framel.generic.name  = ART_FRAMEL;
       s_gameoptions.framel.generic.flags = QMF_INACTIVE;
       s_gameoptions.framel.generic.x        = 0;
       s_gameoptions.framel.generic.y        = 78;
       s_gameoptions.framel.width            = 256;
       s_gameoptions.framel.height           = 329;

       s_gameoptions.framer.generic.type  = MTYPE_BITMAP;
       s_gameoptions.framer.generic.name  = ART_FRAMER;
       s_gameoptions.framer.generic.flags = QMF_INACTIVE;
       s_gameoptions.framer.generic.x        = 0;
       s_gameoptions.framer.generic.y        = 0;
       s_gameoptions.framer.width            = 640;
       s_gameoptions.framer.height           = 480;

       y = 100;
	y += BIGCHAR_HEIGHT+2;
       s_gameoptions.falling.generic.type              = MTYPE_RADIOBUTTON;
       s_gameoptions.falling.generic.name          = "Falling Damage:";
       s_gameoptions.falling.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.falling.generic.callback    = GameOptions_Event;
       s_gameoptions.falling.generic.id          = ID_FALLING;
       s_gameoptions.falling.generic.x                 = Hellfire_X_POS;
       s_gameoptions.falling.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gameoptions.footsteps.generic.type              = MTYPE_RADIOBUTTON;
       s_gameoptions.footsteps.generic.name          = "No Footsteps:";
       s_gameoptions.footsteps.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.footsteps.generic.callback    = GameOptions_Event;
       s_gameoptions.footsteps.generic.id          = ID_FOOTSTEPS;
       s_gameoptions.footsteps.generic.x                 = Hellfire_X_POS;
       s_gameoptions.footsteps.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gameoptions.fixedfov.generic.type              = MTYPE_RADIOBUTTON;
       s_gameoptions.fixedfov.generic.name          = "Fixed FOV:";
       s_gameoptions.fixedfov.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.fixedfov.generic.callback    = GameOptions_Event;
       s_gameoptions.fixedfov.generic.id          = ID_FIXEDFOV;
       s_gameoptions.fixedfov.generic.x                 = Hellfire_X_POS;
       s_gameoptions.fixedfov.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_gameoptions.selfdamage.generic.type              = MTYPE_RADIOBUTTON;
       s_gameoptions.selfdamage.generic.name          = "Self Damage:";
       s_gameoptions.selfdamage.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.selfdamage.generic.callback    = GameOptions_Event;
       s_gameoptions.selfdamage.generic.id          = ID_SELFDAMAGE;
       s_gameoptions.selfdamage.generic.x                 = Hellfire_X_POS;
       s_gameoptions.selfdamage.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.knockback.generic.type              = MTYPE_FIELD;
       s_gameoptions.knockback.generic.name             = "Knockback:";
       s_gameoptions.knockback.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.knockback.field.maxchars             = 4;
       s_gameoptions.knockback.field.widthInChars        = 4;
       s_gameoptions.knockback.generic.callback          = GameOptions_Event;
       s_gameoptions.knockback.generic.id                = ID_KNOCKBACK;
       s_gameoptions.knockback.generic.x                    = Hellfire_X_POS;
       s_gameoptions.knockback.generic.y                    = y;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.warmup.generic.type              = MTYPE_FIELD;
       s_gameoptions.warmup.generic.name             = "Warmup Time(Tourney):";
       s_gameoptions.warmup.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.warmup.field.maxchars             = 3;
       s_gameoptions.warmup.field.widthInChars        = 3;
       s_gameoptions.warmup.generic.callback          = GameOptions_Event;
       s_gameoptions.warmup.generic.id                = ID_WARMUP;
       s_gameoptions.warmup.generic.x                    = Hellfire_X_POS;
       s_gameoptions.warmup.generic.y                    = y;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.quadfactor.generic.type              = MTYPE_FIELD;
       s_gameoptions.quadfactor.generic.name             = "Quad Factor:";
       s_gameoptions.quadfactor.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.quadfactor.field.maxchars             = 1;
       s_gameoptions.quadfactor.field.widthInChars        = 1;
       s_gameoptions.quadfactor.generic.callback          = GameOptions_Event;
       s_gameoptions.quadfactor.generic.id                = ID_QUADFACTOR;
       s_gameoptions.quadfactor.generic.x                    = Hellfire_X_POS;
       s_gameoptions.quadfactor.generic.y                    = y;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.damagescale.generic.type           = MTYPE_SPINCONTROL;
       s_gameoptions.damagescale.generic.name          = "Damage Scale:";
       s_gameoptions.damagescale.generic.flags          = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.damagescale.generic.id             = ID_DAMAGESCALE;
       s_gameoptions.damagescale.generic.x                     = Hellfire_X_POS;
       s_gameoptions.damagescale.generic.y                     = y;
       s_gameoptions.damagescale.itemnames                  = damagescale_items;
       s_gameoptions.damagescale.numitems               = 40;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.intermissiontime.generic.type              = MTYPE_FIELD;
       s_gameoptions.intermissiontime.generic.name             = "Intermission Wait Time:";
       s_gameoptions.intermissiontime.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.intermissiontime.field.maxchars             = 3;
       s_gameoptions.intermissiontime.field.widthInChars        = 3;
       s_gameoptions.intermissiontime.generic.callback          = GameOptions_Event;
       s_gameoptions.intermissiontime.generic.id                = ID_INTERMISSIONTIME;
       s_gameoptions.intermissiontime.generic.x                    = Hellfire_X_POS;
       s_gameoptions.intermissiontime.generic.y                    = y;
       s_gameoptions.intermissiontime.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.podium.generic.type        = MTYPE_RADIOBUTTON;
       s_gameoptions.podium.generic.name          = "Score On Podiums:";
       s_gameoptions.podium.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.podium.generic.callback    = GameOptions_Event;
       s_gameoptions.podium.generic.id          = ID_PODIUM;
       s_gameoptions.podium.generic.x                 = Hellfire_X_POS;
       s_gameoptions.podium.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.forcerespawn.generic.type              = MTYPE_FIELD;
       s_gameoptions.forcerespawn.generic.name             = "Force Respawn Time:";
       s_gameoptions.forcerespawn.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.forcerespawn.field.maxchars             = 2;
       s_gameoptions.forcerespawn.field.widthInChars        = 2;
       s_gameoptions.forcerespawn.generic.callback          = GameOptions_Event;
       s_gameoptions.forcerespawn.generic.id                = ID_FORCERESPAWN;
       s_gameoptions.forcerespawn.generic.x                    = Hellfire_X_POS;
       s_gameoptions.forcerespawn.generic.y                    = y;
       s_gameoptions.forcerespawn.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.spawnprotect.generic.type              = MTYPE_FIELD;
       s_gameoptions.spawnprotect.generic.name             = "Spawn Protection Duration:";
       s_gameoptions.spawnprotect.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.spawnprotect.field.maxchars             = 2;
       s_gameoptions.spawnprotect.field.widthInChars        = 2;
       s_gameoptions.spawnprotect.generic.callback          = GameOptions_Event;
       s_gameoptions.spawnprotect.generic.id                = ID_SPAWNPROTECT;
       s_gameoptions.spawnprotect.generic.x                    = Hellfire_X_POS;
       s_gameoptions.spawnprotect.generic.y                    = y;
       s_gameoptions.spawnprotect.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2;
       s_gameoptions.teamcoloredskins.generic.type        = MTYPE_RADIOBUTTON;
       s_gameoptions.teamcoloredskins.generic.name          = "Team Colored Skins:";
       s_gameoptions.teamcoloredskins.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_gameoptions.teamcoloredskins.generic.callback    = GameOptions_Event;
       s_gameoptions.teamcoloredskins.generic.id          = ID_TEAMCOLOREDSKINS;
       s_gameoptions.teamcoloredskins.generic.x                 = Hellfire_X_POS;
       s_gameoptions.teamcoloredskins.generic.y                 = y;

       s_gameoptions.load.generic.type        = MTYPE_BITMAP;
       s_gameoptions.load.generic.name     = ART_LOAD0;
       s_gameoptions.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gameoptions.load.generic.callback = GameOptions_Event;
       s_gameoptions.load.generic.id          = ID_LOAD;
       s_gameoptions.load.generic.x           = 128;
       s_gameoptions.load.generic.y           = 475-64;
       s_gameoptions.load.width               = 128;
       s_gameoptions.load.height              = 64;
       s_gameoptions.load.focuspic         = ART_LOAD1;
       s_gameoptions.load.generic.statusbar            = Hellfire_StatusBar7;

       s_gameoptions.save.generic.type        = MTYPE_BITMAP;
       s_gameoptions.save.generic.name     = ART_SAVE0;
       s_gameoptions.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gameoptions.save.generic.callback = GameOptions_Event;
       s_gameoptions.save.generic.id          = ID_SAVE;
       s_gameoptions.save.generic.x           = 384;
       s_gameoptions.save.generic.y           = 475-64;
       s_gameoptions.save.width               = 128;
       s_gameoptions.save.height              = 64;
       s_gameoptions.save.focuspic         = ART_SAVE1;
       s_gameoptions.save.generic.statusbar            = Hellfire_StatusBar8;

       s_gameoptions.back.generic.type        = MTYPE_BITMAP;
       s_gameoptions.back.generic.name     = ART_BACK0;
       s_gameoptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gameoptions.back.generic.callback = GameOptions_Event;
       s_gameoptions.back.generic.id          = ID_GAMEOPTIONSBACK;
       s_gameoptions.back.generic.x           = 0;
       s_gameoptions.back.generic.y           = 475-64;
       s_gameoptions.back.width               = 128;
       s_gameoptions.back.height              = 64;
       s_gameoptions.back.focuspic         = ART_BACK1;
       s_gameoptions.back.generic.statusbar            = Hellfire_StatusBar2;

       s_gameoptions.accept.generic.type        = MTYPE_BITMAP;
       s_gameoptions.accept.generic.name     = ART_ACCEPT0;
       s_gameoptions.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_gameoptions.accept.generic.callback = GameOptions_Event;
       s_gameoptions.accept.generic.id          = ID_ACCEPT;
       s_gameoptions.accept.generic.x           = 512;
       s_gameoptions.accept.generic.y           = 475-64;
       s_gameoptions.accept.width               = 128;
       s_gameoptions.accept.height              = 64;
       s_gameoptions.accept.focuspic         = ART_ACCEPT1;
       s_gameoptions.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.banner );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.framel );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.framer );

       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.falling );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.footsteps );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.fixedfov );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.selfdamage);
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.knockback );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.warmup );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.quadfactor );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.damagescale);
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.intermissiontime );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.podium );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.forcerespawn );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.spawnprotect );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.teamcoloredskins );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.load );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.save );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.back );
       Menu_AddItem( &s_gameoptions.menu, &s_gameoptions.accept );

       s_gameoptions.falling.curvalue        = trap_Cvar_VariableValue( "g_falling" ) != 0;
       s_gameoptions.fixedfov.curvalue        = trap_Cvar_VariableValue( "g_fixedfov" ) != 0;
       s_gameoptions.selfdamage.curvalue        = trap_Cvar_VariableValue( "g_selfdamage" ) != 0;
       s_gameoptions.footsteps.curvalue        = trap_Cvar_VariableValue( "g_nofootsteps" ) != 0;
       s_gameoptions.podium.curvalue        = trap_Cvar_VariableValue( "g_podiumscores" ) != 0;
       s_gameoptions.teamcoloredskins.curvalue        = trap_Cvar_VariableValue( "g_teamcoloredskins" ) != 0;
       Q_strncpyz( s_gameoptions.warmup.field.buffer, UI_Cvar_VariableString("g_warmup"), sizeof(s_gameoptions.warmup.field.buffer) );
       Q_strncpyz( s_gameoptions.spawnprotect.field.buffer, UI_Cvar_VariableString("g_spawnprotect"), sizeof(s_gameoptions.spawnprotect.field.buffer) );
       Q_strncpyz( s_gameoptions.forcerespawn.field.buffer, UI_Cvar_VariableString("g_forcerespawn"), sizeof(s_gameoptions.forcerespawn.field.buffer) );
       trap_Cvar_Register(&quadfactor, "g_quadfactor","", CVAR_ARCHIVE);
       Q_strncpyz( s_gameoptions.quadfactor.field.buffer, UI_Cvar_VariableString("g_quadfactor"), sizeof(s_gameoptions.quadfactor.field.buffer) );
       Q_strncpyz( s_gameoptions.knockback.field.buffer, UI_Cvar_VariableString("g_knockback"), sizeof(s_gameoptions.knockback.field.buffer) );
       Q_strncpyz( s_gameoptions.intermissiontime.field.buffer, UI_Cvar_VariableString("g_intermissiontime"), sizeof(s_gameoptions.intermissiontime.field.buffer) );
       h = Com_Clamp( 0.25, 10, trap_Cvar_VariableValue("g_damagescale") );
       s_gameoptions.damagescale.curvalue = (h / 0.25) - 1;
       UI_PushMenu( &s_gameoptions.menu );
}

static void HudOptions_Event( void* ptr, int notification ) {
       int autousehealth;
       autousehealth     = atoi( s_hudoptions.autousehealth.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       case ID_ACCEPT:
              trap_Cvar_SetValue( "cg_hud", s_hudoptions.hud.curvalue );
              trap_Cvar_SetValue( "cg_directionaldamage", s_hudoptions.directionaldamage.curvalue );
              trap_Cvar_SetValue( "cg_draw3dIcons", s_hudoptions.draw3dIcons.curvalue );
              trap_Cvar_SetValue( "cg_drawAttacker", s_hudoptions.drawAttacker.curvalue );
              trap_Cvar_SetValue( "cg_drawStatus", s_hudoptions.drawStatus.curvalue );
              trap_Cvar_SetValue( "cg_drawTimer", s_hudoptions.drawTimer.curvalue );
              trap_Cvar_SetValue( "cg_drawFPS", s_hudoptions.drawFPS.curvalue );
              trap_Cvar_SetValue( "cg_drawAmmoWarning", s_hudoptions.drawAmmoWarning.curvalue );
              trap_Cvar_SetValue( "cg_drawRewards", s_hudoptions.drawRewards.curvalue );
              trap_Cvar_SetValue( "cg_autouse", s_hudoptions.autouse.curvalue );
              trap_Cvar_SetValue( "cg_centerhud", s_hudoptions.centerhud.curvalue );
              trap_Cvar_SetValue( "cg_scorePlums", s_hudoptions.scoreplums.curvalue );
              trap_Cvar_SetValue( "cg_drawMiniScore", s_hudoptions.miniscore.curvalue );
              trap_Cvar_SetValue( "cg_drawscanner", s_hudoptions.scanner.curvalue );
              trap_Cvar_SetValue( "cg_autousehealth", autousehealth );
              trap_Cvar_SetValue( "cg_weaponselectstyle", s_hudoptions.weaponselectstyle.curvalue );
              trap_Cvar_SetValue( "cg_3rdpersoncrosshair", s_hudoptions.thirdpersoncrosshair.curvalue );
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_BACK:
              UI_PopMenu();
              break;

	}
}

static void hudoptions_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_hudoptions.menu );

       if( s_hudoptions.draw ) {
              s_hudoptions.draw();
       }
}

static void UI_HUDOPTIONS_MENU( void )
{
	int				y;
       memset( &s_hudoptions, 0 ,sizeof(hudoptions_t) );

       Hellfire_Cache();

       s_hudoptions.menu.wrapAround = qtrue;
       s_hudoptions.menu.fullscreen = qtrue;
       s_hudoptions.menu.draw       = hudoptions_draw;

       s_hudoptions.banner.generic.type  = MTYPE_PTEXT;
       s_hudoptions.banner.generic.x        = 320;
       s_hudoptions.banner.generic.y        = 32;
       s_hudoptions.banner.string           = "HUD OPTIONS";
       s_hudoptions.banner.color         = color_orange;
       s_hudoptions.banner.style         = UI_CENTER;

       s_hudoptions.framel.generic.type  = MTYPE_BITMAP;
       s_hudoptions.framel.generic.name  = ART_FRAMEL;
       s_hudoptions.framel.generic.flags = QMF_INACTIVE;
       s_hudoptions.framel.generic.x        = 0;
       s_hudoptions.framel.generic.y        = 78;
       s_hudoptions.framel.width            = 256;
       s_hudoptions.framel.height           = 329;

       s_hudoptions.framer.generic.type  = MTYPE_BITMAP;
       s_hudoptions.framer.generic.name  = ART_FRAMER;
       s_hudoptions.framer.generic.flags = QMF_INACTIVE;
       s_hudoptions.framer.generic.x        = 0;
       s_hudoptions.framer.generic.y        = 0;
       s_hudoptions.framer.width            = 640;
       s_hudoptions.framer.height           = 480;

       y = 56;
	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.hud.generic.type              = MTYPE_SPINCONTROL;
       s_hudoptions.hud.generic.name          = "Hud Style:";
       s_hudoptions.hud.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.hud.generic.callback    = HudOptions_Event;
       s_hudoptions.hud.generic.id          = ID_HUD;
       s_hudoptions.hud.generic.x                 = Hellfire_X_POS;
       s_hudoptions.hud.generic.y                 = y;
       s_hudoptions.hud.itemnames             = hud_items;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.centerhud.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.centerhud.generic.name          = "Toggle Center Heads Up Display & Stats:";
       s_hudoptions.centerhud.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.centerhud.generic.callback    = HudOptions_Event;
       s_hudoptions.centerhud.generic.id          = ID_CENTERHUD;
       s_hudoptions.centerhud.generic.x                 = Hellfire_X_POS;
       s_hudoptions.centerhud.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.directionaldamage.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.directionaldamage.generic.name          = "Directional Damage:";
       s_hudoptions.directionaldamage.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.directionaldamage.generic.callback    = HudOptions_Event;
       s_hudoptions.directionaldamage.generic.id          = ID_DIRECTIONALDAMAGE;
       s_hudoptions.directionaldamage.generic.x                 = Hellfire_X_POS;
       s_hudoptions.directionaldamage.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.draw3dIcons.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.draw3dIcons.generic.name          = "Toggle 3d Icons:";
       s_hudoptions.draw3dIcons.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.draw3dIcons.generic.callback    = HudOptions_Event;
       s_hudoptions.draw3dIcons.generic.id          = ID_DRAW3D;
       s_hudoptions.draw3dIcons.generic.x                 = Hellfire_X_POS;
       s_hudoptions.draw3dIcons.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawAttacker.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawAttacker.generic.name          = "Toggle Attacker:";
       s_hudoptions.drawAttacker.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawAttacker.generic.callback    = HudOptions_Event;
       s_hudoptions.drawAttacker.generic.id          = ID_DRAWATTACKER;
       s_hudoptions.drawAttacker.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawAttacker.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawStatus.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawStatus.generic.name          = "Toggle Hud:";
       s_hudoptions.drawStatus.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawStatus.generic.callback    = HudOptions_Event;
       s_hudoptions.drawStatus.generic.id          = ID_DRAWSTATUS;
       s_hudoptions.drawStatus.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawStatus.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawTimer.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawTimer.generic.name          = "Toggle Timer:";
       s_hudoptions.drawTimer.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawTimer.generic.callback    = HudOptions_Event;
       s_hudoptions.drawTimer.generic.id          = ID_DRAWTIMER;
       s_hudoptions.drawTimer.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawTimer.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawFPS.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawFPS.generic.name          = "Toggle FPS:";
       s_hudoptions.drawFPS.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawFPS.generic.callback    = HudOptions_Event;
       s_hudoptions.drawFPS.generic.id          = ID_DRAWFPS;
       s_hudoptions.drawFPS.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawFPS.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawAmmoWarning.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawAmmoWarning.generic.name          = "Toggle Low Ammo Warning:";
       s_hudoptions.drawAmmoWarning.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawAmmoWarning.generic.callback    = HudOptions_Event;
       s_hudoptions.drawAmmoWarning.generic.id          = ID_DRAWAMMOWARNING;
       s_hudoptions.drawAmmoWarning.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawAmmoWarning.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.drawRewards.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.drawRewards.generic.name          = "Toggle Rewards:";
       s_hudoptions.drawRewards.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.drawRewards.generic.callback    = HudOptions_Event;
       s_hudoptions.drawRewards.generic.id          = ID_DRAWREWARDS;
       s_hudoptions.drawRewards.generic.x                 = Hellfire_X_POS;
       s_hudoptions.drawRewards.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.scoreplums.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.scoreplums.generic.name          = "Toggle Score Plums:";
       s_hudoptions.scoreplums.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.scoreplums.generic.callback    = HudOptions_Event;
       s_hudoptions.scoreplums.generic.id          = ID_SCOREPLUMS;
       s_hudoptions.scoreplums.generic.x                 = Hellfire_X_POS;
       s_hudoptions.scoreplums.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.miniscore.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.miniscore.generic.name          = "Toggle Mini Scoreboard:";
       s_hudoptions.miniscore.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.miniscore.generic.callback    = HudOptions_Event;
       s_hudoptions.miniscore.generic.id          = ID_MINISCORE;
       s_hudoptions.miniscore.generic.x                 = Hellfire_X_POS;
       s_hudoptions.miniscore.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.scanner.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.scanner.generic.name          = "Toggle Motion Tracker:";
       s_hudoptions.scanner.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.scanner.generic.callback    = HudOptions_Event;
       s_hudoptions.scanner.generic.id          = ID_SCANNER;
       s_hudoptions.scanner.generic.x                 = Hellfire_X_POS;
       s_hudoptions.scanner.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.autouse.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.autouse.generic.name          = "Toggle Auto Use Holdable:";
       s_hudoptions.autouse.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.autouse.generic.callback    = HudOptions_Event;
       s_hudoptions.autouse.generic.id          = ID_AUTOUSE;
       s_hudoptions.autouse.generic.x                 = Hellfire_X_POS;
       s_hudoptions.autouse.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_hudoptions.autousehealth.generic.type           = MTYPE_FIELD;
       s_hudoptions.autousehealth.generic.name          = "Auto Use Holdable When Health Is Below:";
       s_hudoptions.autousehealth.generic.flags          = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.autousehealth.field.maxchars             = 3;
       s_hudoptions.autousehealth.field.widthInChars        = 3;
       s_hudoptions.autousehealth.generic.id             = ID_AUTOUSEHEALTH;
       s_hudoptions.autousehealth.generic.x                     = Hellfire_X_POS;
       s_hudoptions.autousehealth.generic.y                     = y;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.weaponselectstyle.generic.type              = MTYPE_SPINCONTROL;
       s_hudoptions.weaponselectstyle.generic.name          = "Weapon Select Style:";
       s_hudoptions.weaponselectstyle.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.weaponselectstyle.generic.callback    = HudOptions_Event;
       s_hudoptions.weaponselectstyle.generic.id          = ID_WEAPONSELECTSTYLE;
       s_hudoptions.weaponselectstyle.generic.x                 = Hellfire_X_POS;
       s_hudoptions.weaponselectstyle.generic.y                 = y;
       s_hudoptions.weaponselectstyle.itemnames             = weaponselectstyle_items;

	y += BIGCHAR_HEIGHT+2;
       s_hudoptions.thirdpersoncrosshair.generic.type              = MTYPE_RADIOBUTTON;
       s_hudoptions.thirdpersoncrosshair.generic.name          = "Toggle 3rd Person Crosshair:";
       s_hudoptions.thirdpersoncrosshair.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hudoptions.thirdpersoncrosshair.generic.callback    = HudOptions_Event;
       s_hudoptions.thirdpersoncrosshair.generic.id          = ID_3RDPERSONCROSSHAIR;
       s_hudoptions.thirdpersoncrosshair.generic.x                 = Hellfire_X_POS;
       s_hudoptions.thirdpersoncrosshair.generic.y                 = y;

       s_hudoptions.back.generic.type        = MTYPE_BITMAP;
       s_hudoptions.back.generic.name     = ART_BACK0;
       s_hudoptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hudoptions.back.generic.callback = HudOptions_Event;
       s_hudoptions.back.generic.id          = ID_BACK;
       s_hudoptions.back.generic.x           = 0;
       s_hudoptions.back.generic.y           = 475-64;
       s_hudoptions.back.width               = 128;
       s_hudoptions.back.height              = 64;
       s_hudoptions.back.focuspic         = ART_BACK1;
       s_hudoptions.back.generic.statusbar            = Hellfire_StatusBar2;

       s_hudoptions.load.generic.type        = MTYPE_BITMAP;
       s_hudoptions.load.generic.name     = ART_LOAD0;
       s_hudoptions.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hudoptions.load.generic.callback = HudOptions_Event;
       s_hudoptions.load.generic.id          = ID_LOAD;
       s_hudoptions.load.generic.x           = 128;
       s_hudoptions.load.generic.y           = 475-64;
       s_hudoptions.load.width               = 128;
       s_hudoptions.load.height              = 64;
       s_hudoptions.load.focuspic         = ART_LOAD1;
       s_hudoptions.load.generic.statusbar            = Hellfire_StatusBar7;

       s_hudoptions.save.generic.type        = MTYPE_BITMAP;
       s_hudoptions.save.generic.name     = ART_SAVE0;
       s_hudoptions.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hudoptions.save.generic.callback = HudOptions_Event;
       s_hudoptions.save.generic.id          = ID_SAVE;
       s_hudoptions.save.generic.x           = 384;
       s_hudoptions.save.generic.y           = 475-64;
       s_hudoptions.save.width               = 128;
       s_hudoptions.save.height              = 64;
       s_hudoptions.save.focuspic         = ART_SAVE1;
       s_hudoptions.save.generic.statusbar            = Hellfire_StatusBar8;

       s_hudoptions.accept.generic.type        = MTYPE_BITMAP;
       s_hudoptions.accept.generic.name     = ART_ACCEPT0;
       s_hudoptions.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hudoptions.accept.generic.callback = HudOptions_Event;
       s_hudoptions.accept.generic.id          = ID_ACCEPT;
       s_hudoptions.accept.generic.x           = 512;
       s_hudoptions.accept.generic.y           = 475-64;
       s_hudoptions.accept.width               = 128;
       s_hudoptions.accept.height              = 64;
       s_hudoptions.accept.focuspic         = ART_ACCEPT1;
       s_hudoptions.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.banner );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.framel );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.framer );

       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.hud );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.centerhud );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.directionaldamage );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.draw3dIcons );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawAttacker );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawStatus );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawTimer );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawFPS );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawAmmoWarning );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.drawRewards );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.scoreplums );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.miniscore );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.scanner );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.autouse );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.autousehealth );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.weaponselectstyle );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.thirdpersoncrosshair );

       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.back );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.load );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.save );
       Menu_AddItem( &s_hudoptions.menu, &s_hudoptions.accept );

       s_hudoptions.hud.curvalue = Com_Clamp( 0, 5, trap_Cvar_VariableValue( "cg_hud" ) );
       s_hudoptions.weaponselectstyle.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "cg_weaponselectstyle" ) );
       s_hudoptions.directionaldamage.curvalue        = trap_Cvar_VariableValue( "cg_directionaldamage" ) != 0;
       s_hudoptions.draw3dIcons.curvalue        = trap_Cvar_VariableValue( "cg_draw3dIcons" ) != 0;
       s_hudoptions.drawAttacker.curvalue        = trap_Cvar_VariableValue( "cg_drawAttacker" ) != 0;
       s_hudoptions.drawStatus.curvalue        = trap_Cvar_VariableValue( "cg_drawStatus" ) != 0;
       s_hudoptions.drawTimer.curvalue        = trap_Cvar_VariableValue( "cg_drawTimer" ) != 0;
       s_hudoptions.drawFPS.curvalue        = trap_Cvar_VariableValue( "cg_drawFPS" ) != 0;
       s_hudoptions.drawAmmoWarning.curvalue        = trap_Cvar_VariableValue( "cg_drawAmmoWarning" ) != 0;
       s_hudoptions.drawRewards.curvalue        = trap_Cvar_VariableValue( "cg_drawRewards" ) != 0;
       s_hudoptions.autouse.curvalue        = trap_Cvar_VariableValue( "cg_autouse" ) != 0;
       s_hudoptions.thirdpersoncrosshair.curvalue        = trap_Cvar_VariableValue( "cg_3rdpersoncrosshair" ) != 0;
       s_hudoptions.centerhud.curvalue        = trap_Cvar_VariableValue( "cg_centerhud" ) != 0;
       s_hudoptions.scoreplums.curvalue        = trap_Cvar_VariableValue( "cg_scorePlums" ) != 0;
       s_hudoptions.miniscore.curvalue        = trap_Cvar_VariableValue( "cg_drawMiniScore" ) != 0;
       s_hudoptions.scanner.curvalue        = trap_Cvar_VariableValue( "cg_drawscanner" ) != 0;
       Q_strncpyz( s_hudoptions.autousehealth.field.buffer, UI_Cvar_VariableString("cg_autousehealth"), sizeof(s_hudoptions.autousehealth.field.buffer) );
       UI_PushMenu( &s_hudoptions.menu );
}

static void CampOptions_Event( void* ptr, int notification ) {
       int campshuffle,camptimeout;
       campshuffle       = atoi( s_campoptions.campshuffle.field.buffer );
       camptimeout       = atoi( s_campoptions.camptimeout.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_CAMPSHUFFLE:
              trap_Cvar_SetValue( "g_shuffle", campshuffle);
              break;

       case ID_CAMPTIMEOUT:
              trap_Cvar_SetValue( "g_camptimeout", camptimeout);
              break;

       case ID_CAMPPROTECT:
              trap_Cvar_SetValue( "g_campprotect", s_campoptions.campprotect.curvalue);
              break;
       */
       case ID_ACCEPT:
              trap_Cvar_SetValue( "g_campshuffle", campshuffle);
              trap_Cvar_SetValue( "g_camptimeout", camptimeout);
              trap_Cvar_SetValue( "g_campprotect", s_campoptions.campprotect.curvalue);
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_CAMPOPTIONSBACK:
              UI_PopMenu();
              break;
	}
}

static void campoptions_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_campoptions.menu );

       if( s_campoptions.draw ) {
              s_campoptions.draw();
       }
}

static void UI_CAMPOPTIONS_MENU( void )
{
	int				y;
       float                       h;
       memset( &s_campoptions, 0 ,sizeof(campoptions_t) );

       Hellfire_Cache();

       s_campoptions.menu.wrapAround = qtrue;
       s_campoptions.menu.fullscreen = qtrue;
       s_campoptions.menu.draw       = campoptions_draw;

       s_campoptions.banner.generic.type  = MTYPE_PTEXT;
       s_campoptions.banner.generic.x        = 320;
       s_campoptions.banner.generic.y        = 32;
       s_campoptions.banner.string           = "CAMPING PROTECTION";
       s_campoptions.banner.color         = color_orange;
       s_campoptions.banner.style         = UI_CENTER;

       s_campoptions.framel.generic.type  = MTYPE_BITMAP;
       s_campoptions.framel.generic.name  = ART_FRAMEL;
       s_campoptions.framel.generic.flags = QMF_INACTIVE;
       s_campoptions.framel.generic.x        = 0;
       s_campoptions.framel.generic.y        = 78;
       s_campoptions.framel.width            = 256;
       s_campoptions.framel.height           = 329;

       s_campoptions.framer.generic.type  = MTYPE_BITMAP;
       s_campoptions.framer.generic.name  = ART_FRAMER;
       s_campoptions.framer.generic.flags = QMF_INACTIVE;
       s_campoptions.framer.generic.x        = 0;
       s_campoptions.framer.generic.y        = 0;
       s_campoptions.framer.width            = 640;
       s_campoptions.framer.height           = 480;

       y = 196;
	y += BIGCHAR_HEIGHT+2;
       s_campoptions.campprotect.generic.type              = MTYPE_RADIOBUTTON;
       s_campoptions.campprotect.generic.name          = "Camping Protection:";
       s_campoptions.campprotect.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_campoptions.campprotect.generic.callback    = CampOptions_Event;
       s_campoptions.campprotect.generic.id          = ID_CAMPPROTECT;
       s_campoptions.campprotect.generic.x                 = Hellfire_X_POS;
       s_campoptions.campprotect.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_campoptions.campshuffle.generic.type              = MTYPE_FIELD;
       s_campoptions.campshuffle.generic.name             = "Camping Radius:";
       s_campoptions.campshuffle.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_campoptions.campshuffle.field.maxchars             = 4;
       s_campoptions.campshuffle.field.widthInChars        = 4;
       s_campoptions.campshuffle.generic.callback          = CampOptions_Event;
       s_campoptions.campshuffle.generic.id                = ID_CAMPSHUFFLE;
       s_campoptions.campshuffle.generic.x                    = Hellfire_X_POS;
       s_campoptions.campshuffle.generic.y                    = y;

       y += BIGCHAR_HEIGHT+2;
       s_campoptions.camptimeout.generic.type              = MTYPE_FIELD;
       s_campoptions.camptimeout.generic.name             = "Camping Time:";
       s_campoptions.camptimeout.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_campoptions.camptimeout.field.maxchars             = 3;
       s_campoptions.camptimeout.field.widthInChars        = 3;
       s_campoptions.camptimeout.generic.callback          = CampOptions_Event;
       s_campoptions.camptimeout.generic.id                = ID_CAMPTIMEOUT;
       s_campoptions.camptimeout.generic.x                    = Hellfire_X_POS;
       s_campoptions.camptimeout.generic.y                    = y;
       s_campoptions.camptimeout.generic.statusbar            = Hellfire_StatusBar;

       s_campoptions.back.generic.type        = MTYPE_BITMAP;
       s_campoptions.back.generic.name     = ART_BACK0;
       s_campoptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_campoptions.back.generic.callback = CampOptions_Event;
       s_campoptions.back.generic.id          = ID_CAMPOPTIONSBACK;
       s_campoptions.back.generic.x           = 0;
       s_campoptions.back.generic.y           = 475-64;
       s_campoptions.back.width               = 128;
       s_campoptions.back.height              = 64;
       s_campoptions.back.focuspic         = ART_BACK1;
       s_campoptions.back.generic.statusbar            = Hellfire_StatusBar2;

       s_campoptions.load.generic.type        = MTYPE_BITMAP;
       s_campoptions.load.generic.name     = ART_LOAD0;
       s_campoptions.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_campoptions.load.generic.callback = CampOptions_Event;
       s_campoptions.load.generic.id          = ID_LOAD;
       s_campoptions.load.generic.x           = 128;
       s_campoptions.load.generic.y           = 475-64;
       s_campoptions.load.width               = 128;
       s_campoptions.load.height              = 64;
       s_campoptions.load.focuspic         = ART_LOAD1;
       s_campoptions.load.generic.statusbar            = Hellfire_StatusBar7;

       s_campoptions.accept.generic.type        = MTYPE_BITMAP;
       s_campoptions.accept.generic.name     = ART_ACCEPT0;
       s_campoptions.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_campoptions.accept.generic.callback = CampOptions_Event;
       s_campoptions.accept.generic.id          = ID_ACCEPT;
       s_campoptions.accept.generic.x           = 512;
       s_campoptions.accept.generic.y           = 475-64;
       s_campoptions.accept.width               = 128;
       s_campoptions.accept.height              = 64;
       s_campoptions.accept.focuspic         = ART_ACCEPT1;
       s_campoptions.accept.generic.statusbar            = Hellfire_StatusBar3;

       s_campoptions.save.generic.type        = MTYPE_BITMAP;
       s_campoptions.save.generic.name     = ART_SAVE0;
       s_campoptions.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_campoptions.save.generic.callback = CampOptions_Event;
       s_campoptions.save.generic.id          = ID_SAVE;
       s_campoptions.save.generic.x           = 384;
       s_campoptions.save.generic.y           = 475-64;
       s_campoptions.save.width               = 128;
       s_campoptions.save.height              = 64;
       s_campoptions.save.focuspic         = ART_SAVE1;
       s_campoptions.save.generic.statusbar            = Hellfire_StatusBar8;

       Menu_AddItem( &s_campoptions.menu, &s_campoptions.banner );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.framel );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.framer );


       Menu_AddItem( &s_campoptions.menu, &s_campoptions.campprotect );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.campshuffle );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.camptimeout );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.back );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.load );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.save );
       Menu_AddItem( &s_campoptions.menu, &s_campoptions.accept );
       s_campoptions.campprotect.curvalue        = trap_Cvar_VariableValue( "g_campprotect" ) != 0;
       Q_strncpyz( s_campoptions.campshuffle.field.buffer, UI_Cvar_VariableString("g_campshuffle"), sizeof(s_campoptions.campshuffle.field.buffer) );
       Q_strncpyz( s_campoptions.camptimeout.field.buffer, UI_Cvar_VariableString("g_camptimeout"), sizeof(s_campoptions.camptimeout.field.buffer) );
       UI_PushMenu( &s_campoptions.menu );
}

static void CamOptions_Event( void* ptr, int notification ) {

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       case ID_ACCEPT:
              trap_Cvar_SetValue( "g_camtype", s_camoptions.camtype.curvalue );
              trap_Cvar_SetValue( "g_camstyle", s_camoptions.camstyle.curvalue );
              UI_PopMenu();
              break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_BACK:
              UI_PopMenu();
              break;

	}
}

static void camoptions_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_camoptions.menu );

       if( s_camoptions.draw ) {
              s_camoptions.draw();
       }
}

static void UI_CAMOPTIONS_MENU( void )
{
	int				y;
       memset( &s_camoptions, 0 ,sizeof(camoptions_t) );

       Hellfire_Cache();

       s_camoptions.menu.wrapAround = qtrue;
       s_camoptions.menu.fullscreen = qtrue;
       s_camoptions.menu.draw       = camoptions_draw;

       s_camoptions.banner.generic.type  = MTYPE_PTEXT;
       s_camoptions.banner.generic.x        = 320;
       s_camoptions.banner.generic.y        = 32;
       s_camoptions.banner.string           = "CAMERA OPTIONS";
       s_camoptions.banner.color         = color_orange;
       s_camoptions.banner.style         = UI_CENTER;

       s_camoptions.framel.generic.type  = MTYPE_BITMAP;
       s_camoptions.framel.generic.name  = ART_FRAMEL;
       s_camoptions.framel.generic.flags = QMF_INACTIVE;
       s_camoptions.framel.generic.x        = 0;
       s_camoptions.framel.generic.y        = 78;
       s_camoptions.framel.width            = 256;
       s_camoptions.framel.height           = 329;

       s_camoptions.framer.generic.type  = MTYPE_BITMAP;
       s_camoptions.framer.generic.name  = ART_FRAMER;
       s_camoptions.framer.generic.flags = QMF_INACTIVE;
       s_camoptions.framer.generic.x        = 0;
       s_camoptions.framer.generic.y        = 0;
       s_camoptions.framer.width            = 640;
       s_camoptions.framer.height           = 480;

       y = 204;
	y += BIGCHAR_HEIGHT+2;
       s_camoptions.camstyle.generic.type              = MTYPE_SPINCONTROL;
       s_camoptions.camstyle.generic.name          = "Cam Style:";
       s_camoptions.camstyle.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_camoptions.camstyle.generic.callback    = CamOptions_Event;
       s_camoptions.camstyle.generic.id          = ID_CAMSTYLE;
       s_camoptions.camstyle.generic.x                 = Hellfire_X_POS-60;
       s_camoptions.camstyle.generic.y                 = y;
       s_camoptions.camstyle.itemnames             = camstyle_items;

	y += BIGCHAR_HEIGHT+2;
       s_camoptions.camtype.generic.type              = MTYPE_SPINCONTROL;
       s_camoptions.camtype.generic.name          = "Q3Cam Type:";
       s_camoptions.camtype.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_camoptions.camtype.generic.callback    = CamOptions_Event;
       s_camoptions.camtype.generic.id          = ID_CAMTYPE;
       s_camoptions.camtype.generic.x                 = Hellfire_X_POS-60;
       s_camoptions.camtype.generic.y                 = y;
       s_camoptions.camtype.itemnames             = camtype_items;

       s_camoptions.back.generic.type        = MTYPE_BITMAP;
       s_camoptions.back.generic.name     = ART_BACK0;
       s_camoptions.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_camoptions.back.generic.callback = CamOptions_Event;
       s_camoptions.back.generic.id          = ID_BACK;
       s_camoptions.back.generic.x           = 0;
       s_camoptions.back.generic.y           = 475-64;
       s_camoptions.back.width               = 128;
       s_camoptions.back.height              = 64;
       s_camoptions.back.focuspic         = ART_BACK1;
       s_camoptions.back.generic.statusbar            = Hellfire_StatusBar2;

       s_camoptions.load.generic.type        = MTYPE_BITMAP;
       s_camoptions.load.generic.name     = ART_LOAD0;
       s_camoptions.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_camoptions.load.generic.callback = CamOptions_Event;
       s_camoptions.load.generic.id          = ID_LOAD;
       s_camoptions.load.generic.x           = 128;
       s_camoptions.load.generic.y           = 475-64;
       s_camoptions.load.width               = 128;
       s_camoptions.load.height              = 64;
       s_camoptions.load.focuspic         = ART_LOAD1;
       s_camoptions.load.generic.statusbar            = Hellfire_StatusBar7;

       s_camoptions.save.generic.type        = MTYPE_BITMAP;
       s_camoptions.save.generic.name     = ART_SAVE0;
       s_camoptions.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_camoptions.save.generic.callback = CamOptions_Event;
       s_camoptions.save.generic.id          = ID_SAVE;
       s_camoptions.save.generic.x           = 384;
       s_camoptions.save.generic.y           = 475-64;
       s_camoptions.save.width               = 128;
       s_camoptions.save.height              = 64;
       s_camoptions.save.focuspic         = ART_SAVE1;
       s_camoptions.save.generic.statusbar            = Hellfire_StatusBar8;

       s_camoptions.accept.generic.type        = MTYPE_BITMAP;
       s_camoptions.accept.generic.name     = ART_ACCEPT0;
       s_camoptions.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_camoptions.accept.generic.callback = CamOptions_Event;
       s_camoptions.accept.generic.id          = ID_ACCEPT;
       s_camoptions.accept.generic.x           = 512;
       s_camoptions.accept.generic.y           = 475-64;
       s_camoptions.accept.width               = 128;
       s_camoptions.accept.height              = 64;
       s_camoptions.accept.focuspic         = ART_ACCEPT1;
       s_camoptions.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_camoptions.menu, &s_camoptions.banner );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.framel );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.framer );

       Menu_AddItem( &s_camoptions.menu, &s_camoptions.camtype );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.camstyle );

       Menu_AddItem( &s_camoptions.menu, &s_camoptions.back );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.load );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.save );
       Menu_AddItem( &s_camoptions.menu, &s_camoptions.accept );

       s_camoptions.camstyle.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "g_camstyle" ) );
       s_camoptions.camtype.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "g_camtype" ) );
       UI_PushMenu( &s_camoptions.menu );
}

static void Powerups_Draw( void *self ) {
       UI_DrawString( 282, 195+BIGCHAR_HEIGHT+2, "Random Powerup Toggling   :  ", UI_CENTER|UI_SMALLFONT, color_orange );
}

static void Powerups_Event( void* ptr, int notification ) {
       int randomtime,poweruptime;
       randomtime        = atoi( s_powerups.randomtime.field.buffer );
       poweruptime        = atoi( s_powerups.poweruptime.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_POWERUPS:
             trap_Cvar_SetValue( "startwithpowerups", s_powerups.powerup.curvalue);
             break;

       case ID_QUAD:
             trap_Cvar_SetValue( "g_quad", s_powerups.quad.curvalue);
             break;

       case ID_REGEN:
             trap_Cvar_SetValue( "g_regen", s_powerups.regen.curvalue);
             break;

       case ID_BATTLESUIT:
             trap_Cvar_SetValue( "g_battlesuit", s_powerups.battlesuit.curvalue);
             break;

       case ID_FLIGHT:
             trap_Cvar_SetValue( "g_flight", s_powerups.flight.curvalue);
             break;

       case ID_RANDOMTIME:
             trap_Cvar_SetValue( "g_powerupchangetime", randomtime);
             break;

       case ID_HASTE:
             trap_Cvar_SetValue( "g_haste", s_powerups.haste.curvalue);
             break;

       case ID_INVISIBILITY:
             trap_Cvar_SetValue( "g_invisibility", s_powerups.invis.curvalue);
             break;
       */
       case ID_ACCEPT:
             trap_Cvar_SetValue( "startwithpowerups", s_powerups.powerup.curvalue);
             trap_Cvar_SetValue( "g_quad", s_powerups.quad.curvalue);
             trap_Cvar_SetValue( "g_regen", s_powerups.regen.curvalue);
             trap_Cvar_SetValue( "g_battlesuit", s_powerups.battlesuit.curvalue);
             trap_Cvar_SetValue( "g_haste", s_powerups.haste.curvalue);
             trap_Cvar_SetValue( "g_flight", s_powerups.flight.curvalue);
             trap_Cvar_SetValue( "g_invisibility", s_powerups.invis.curvalue);
             trap_Cvar_SetValue( "g_powerupchangetime", randomtime);
             trap_Cvar_SetValue( "startwithpoweruptime", poweruptime);
             UI_PopMenu();
             break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_POWERUPSBACK:
             UI_PopMenu();
             break;

	}
}

static void Weapons_Draw( void *self ) {
       UI_DrawString( 314, 122, "Random Weapons Toggling :      ", UI_CENTER|UI_SMALLFONT, colorWhite );
}

static void powerups_draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_powerups.menu );

       if( s_powerups.draw ) {
              s_powerups.draw();
       }
}

static void UI_POWERUPS_MENU( void )
{
	int				y;
       vmCvar_t botnochat;
       memset( &s_powerups, 0 ,sizeof(powerups_t) );

       Hellfire_Cache();

       s_powerups.menu.wrapAround = qtrue;
       s_powerups.menu.fullscreen = qtrue;
       s_powerups.menu.draw       = powerups_draw;

       s_powerups.banner.generic.type  = MTYPE_PTEXT;
       s_powerups.banner.generic.x        = 320;
       s_powerups.banner.generic.y        = 32;
       s_powerups.banner.string           = "POWERUP OPTIONS";
       s_powerups.banner.color         = color_orange;
       s_powerups.banner.style         = UI_CENTER;

       s_powerups.framel.generic.type  = MTYPE_BITMAP;
       s_powerups.framel.generic.name  = ART_FRAMEL;
       s_powerups.framel.generic.flags = QMF_INACTIVE;
       s_powerups.framel.generic.x        = 0;
       s_powerups.framel.generic.y        = 78;
       s_powerups.framel.width            = 256;
       s_powerups.framel.height           = 329;

       s_powerups.framer.generic.type  = MTYPE_BITMAP;
       s_powerups.framer.generic.name  = ART_FRAMER;
       s_powerups.framer.generic.flags = QMF_INACTIVE;
       s_powerups.framer.generic.x        = 0;
       s_powerups.framer.generic.y        = 0;
       s_powerups.framer.width            = 640;
       s_powerups.framer.height           = 480;

       y = 124;
	y += BIGCHAR_HEIGHT+2;
       s_powerups.powerup.generic.type              = MTYPE_SPINCONTROL;
       s_powerups.powerup.generic.name       = "Start With Powerup        :";
       s_powerups.powerup.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_powerups.powerup.generic.callback    = Powerups_Event;
       s_powerups.powerup.generic.id          = ID_POWERUPS;
       s_powerups.powerup.generic.x                 = Hellfire_X_POS;
       s_powerups.powerup.generic.y                 = y;
       s_powerups.powerup.itemnames             = powerup_items;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.randomtime.generic.type              = MTYPE_FIELD;
       s_powerups.randomtime.generic.name          = "Random Powerup Duration   :";
       s_powerups.randomtime.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_powerups.randomtime.field.maxchars             = 3;
       s_powerups.randomtime.field.widthInChars        = 3;
       s_powerups.randomtime.generic.callback          = Powerups_Event;
       s_powerups.randomtime.generic.id                = ID_RANDOMTIME;
       s_powerups.randomtime.generic.x                    = Hellfire_X_POS;
       s_powerups.randomtime.generic.y                    = y;
       s_powerups.randomtime.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.poweruptime.generic.type              = MTYPE_FIELD;
       s_powerups.poweruptime.generic.name          = "Starting Powerup Duration :";
       s_powerups.poweruptime.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_powerups.poweruptime.field.maxchars             = 3;
       s_powerups.poweruptime.field.widthInChars        = 3;
       s_powerups.poweruptime.generic.callback          = Powerups_Event;
       s_powerups.poweruptime.generic.id                = ID_POWERUPTIME;
       s_powerups.poweruptime.generic.x                    = Hellfire_X_POS;
       s_powerups.poweruptime.generic.y                    = y;
       s_powerups.poweruptime.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2+40+BIGCHAR_HEIGHT;
       s_powerups.random.generic.type            = MTYPE_BTEXT;
       s_powerups.random.generic.flags           = QMF_SMALLFONT;
       s_powerups.random.generic.id                     = ID_RANDOM;
       s_powerups.random.generic.ownerdraw       = Powerups_Draw;
       s_powerups.random.generic.x                 = Hellfire_X_POS;
       s_powerups.random.generic.y                 = y;

       s_powerups.q.generic.type  = MTYPE_BITMAP;
       s_powerups.q.generic.name  = ART_QUAD;
       s_powerups.q.generic.flags = QMF_INACTIVE;
       s_powerups.q.generic.x        = 165;
       s_powerups.q.generic.y        = y;
       s_powerups.q.width            = 16;
       s_powerups.q.height           = 16;

       s_powerups.quad.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.quad.generic.name          = "Quad                     ";
       s_powerups.quad.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.quad.generic.callback    = Powerups_Event;
       s_powerups.quad.generic.id          = ID_QUAD;
       s_powerups.quad.generic.x                 = Hellfire_X_POS;
       s_powerups.quad.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.r.generic.type  = MTYPE_BITMAP;
       s_powerups.r.generic.name  = ART_REGEN;
       s_powerups.r.generic.flags = QMF_INACTIVE;
       s_powerups.r.generic.x        = 165;
       s_powerups.r.generic.y        = y;
       s_powerups.r.width            = 16;
       s_powerups.r.height           = 16;

       s_powerups.regen.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.regen.generic.name         = "Regeneration             ";
       s_powerups.regen.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.regen.generic.callback    = Powerups_Event;
       s_powerups.regen.generic.id          = ID_REGEN;
       s_powerups.regen.generic.x                 = Hellfire_X_POS;
       s_powerups.regen.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.h.generic.type  = MTYPE_BITMAP;
       s_powerups.h.generic.name  = ART_HASTE;
       s_powerups.h.generic.flags = QMF_INACTIVE;
       s_powerups.h.generic.x        = 165;
       s_powerups.h.generic.y        = y;
       s_powerups.h.width            = 16;
       s_powerups.h.height           = 16;

       s_powerups.haste.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.haste.generic.name         = "Haste                    ";
       s_powerups.haste.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.haste.generic.callback    = Powerups_Event;
       s_powerups.haste.generic.id          = ID_HASTE;
       s_powerups.haste.generic.x                 = Hellfire_X_POS;
       s_powerups.haste.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.i.generic.type  = MTYPE_BITMAP;
       s_powerups.i.generic.name  = ART_INVIS;
       s_powerups.i.generic.flags = QMF_INACTIVE;
       s_powerups.i.generic.x        = 165;
       s_powerups.i.generic.y        = y;
       s_powerups.i.width            = 16;
       s_powerups.i.height           = 16;

       s_powerups.invis.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.invis.generic.name         = "Invisibility             ";
       s_powerups.invis.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.invis.generic.callback    = Powerups_Event;
       s_powerups.invis.generic.id          = ID_INVISIBILITY;
       s_powerups.invis.generic.x                 = Hellfire_X_POS;
       s_powerups.invis.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.b.generic.type  = MTYPE_BITMAP;
       s_powerups.b.generic.name  = ART_BATTLESUIT;
       s_powerups.b.generic.flags = QMF_INACTIVE;
       s_powerups.b.generic.x        = 165;
       s_powerups.b.generic.y        = y;
       s_powerups.b.width            = 16;
       s_powerups.b.height           = 16;

       s_powerups.battlesuit.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.battlesuit.generic.name    = "Battlesuit               ";
       s_powerups.battlesuit.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.battlesuit.generic.callback    = Powerups_Event;
       s_powerups.battlesuit.generic.id          = ID_BATTLESUIT;
       s_powerups.battlesuit.generic.x                 = Hellfire_X_POS;
       s_powerups.battlesuit.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_powerups.f.generic.type  = MTYPE_BITMAP;
       s_powerups.f.generic.name  = ART_FLIGHT;
       s_powerups.f.generic.flags = QMF_INACTIVE;
       s_powerups.f.generic.x        = 165;
       s_powerups.f.generic.y        = y;
       s_powerups.f.width            = 16;
       s_powerups.f.height           = 16;

       s_powerups.flight.generic.type        = MTYPE_RADIOBUTTON;
       s_powerups.flight.generic.name    = "Flight                   ";
       s_powerups.flight.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_powerups.flight.generic.callback    = Powerups_Event;
       s_powerups.flight.generic.id          = ID_FLIGHT;
       s_powerups.flight.generic.x                 = Hellfire_X_POS;
       s_powerups.flight.generic.y                 = y;

       s_powerups.back.generic.type        = MTYPE_BITMAP;
       s_powerups.back.generic.name     = ART_BACK0;
       s_powerups.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_powerups.back.generic.callback = Powerups_Event;
       s_powerups.back.generic.id          = ID_POWERUPSBACK;
       s_powerups.back.generic.x           = 0;
       s_powerups.back.generic.y           = 475-64;
       s_powerups.back.width               = 128;
       s_powerups.back.height              = 64;
       s_powerups.back.focuspic         = ART_BACK1;
       s_powerups.back.generic.statusbar            = Hellfire_StatusBar2;

       s_powerups.load.generic.type        = MTYPE_BITMAP;
       s_powerups.load.generic.name     = ART_LOAD0;
       s_powerups.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_powerups.load.generic.callback = Powerups_Event;
       s_powerups.load.generic.id          = ID_LOAD;
       s_powerups.load.generic.x           = 128;
       s_powerups.load.generic.y           = 475-64;
       s_powerups.load.width               = 128;
       s_powerups.load.height              = 64;
       s_powerups.load.focuspic         = ART_LOAD1;
       s_powerups.load.generic.statusbar            = Hellfire_StatusBar7;

       s_powerups.save.generic.type        = MTYPE_BITMAP;
       s_powerups.save.generic.name     = ART_SAVE0;
       s_powerups.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_powerups.save.generic.callback = Powerups_Event;
       s_powerups.save.generic.id          = ID_SAVE;
       s_powerups.save.generic.x           = 384;
       s_powerups.save.generic.y           = 475-64;
       s_powerups.save.width               = 128;
       s_powerups.save.height              = 64;
       s_powerups.save.focuspic         = ART_SAVE1;
       s_powerups.save.generic.statusbar            = Hellfire_StatusBar8;

       s_powerups.accept.generic.type        = MTYPE_BITMAP;
       s_powerups.accept.generic.name     = ART_ACCEPT0;
       s_powerups.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_powerups.accept.generic.callback = Powerups_Event;
       s_powerups.accept.generic.id          = ID_ACCEPT;
       s_powerups.accept.generic.x           = 512;
       s_powerups.accept.generic.y           = 475-64;
       s_powerups.accept.width               = 128;
       s_powerups.accept.height              = 64;
       s_powerups.accept.focuspic         = ART_ACCEPT1;
       s_powerups.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_powerups.menu, &s_powerups.banner );
       Menu_AddItem( &s_powerups.menu, &s_powerups.framel );
       Menu_AddItem( &s_powerups.menu, &s_powerups.framer );

       Menu_AddItem( &s_powerups.menu, &s_powerups.powerup );
       Menu_AddItem( &s_powerups.menu, &s_powerups.randomtime );
       Menu_AddItem( &s_powerups.menu, &s_powerups.poweruptime );
       Menu_AddItem( &s_powerups.menu, &s_powerups.quad );
       Menu_AddItem( &s_powerups.menu, &s_powerups.regen );
       Menu_AddItem( &s_powerups.menu, &s_powerups.haste );
       Menu_AddItem( &s_powerups.menu, &s_powerups.invis );
       Menu_AddItem( &s_powerups.menu, &s_powerups.battlesuit );
       Menu_AddItem( &s_powerups.menu, &s_powerups.flight );
       Menu_AddItem( &s_powerups.menu, &s_powerups.back );
       Menu_AddItem( &s_powerups.menu, &s_powerups.load );
       Menu_AddItem( &s_powerups.menu, &s_powerups.save );
       Menu_AddItem( &s_powerups.menu, &s_powerups.accept );
       Menu_AddItem( &s_powerups.menu, &s_powerups.q );
       Menu_AddItem( &s_powerups.menu, &s_powerups.r );
       Menu_AddItem( &s_powerups.menu, &s_powerups.i );
       Menu_AddItem( &s_powerups.menu, &s_powerups.b );
       Menu_AddItem( &s_powerups.menu, &s_powerups.h );
       Menu_AddItem( &s_powerups.menu, &s_powerups.f );
       Menu_AddItem( &s_powerups.menu, &s_powerups.random );
       s_powerups.powerup.curvalue = Com_Clamp( 0, 7, trap_Cvar_VariableValue( "startwithpowerups" ) );
       s_powerups.quad.curvalue = trap_Cvar_VariableValue( "g_quad" ) != 0;
       s_powerups.regen.curvalue = trap_Cvar_VariableValue( "g_regen" ) != 0;
       s_powerups.invis.curvalue = trap_Cvar_VariableValue( "g_invisibility" ) != 0;
       s_powerups.haste.curvalue = trap_Cvar_VariableValue( "g_haste" ) != 0;
       s_powerups.battlesuit.curvalue = trap_Cvar_VariableValue( "g_battlesuit" ) != 0;
       s_powerups.flight.curvalue = trap_Cvar_VariableValue( "g_flight" ) != 0;
       Q_strncpyz( s_powerups.randomtime.field.buffer, UI_Cvar_VariableString("g_powerupchangetime"), sizeof(s_powerups.randomtime.field.buffer) );
       Q_strncpyz( s_powerups.poweruptime.field.buffer, UI_Cvar_VariableString("startwithpoweruptime"), sizeof(s_powerups.poweruptime.field.buffer) );
       UI_PushMenu( &s_powerups.menu );
}

static void Weapons_Event( void* ptr, int notification ) {
       int proxytime;
       proxytime     = atoi( s_weapons.proxytime.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_RANDOMWEAP:
              trap_Cvar_SetValue( "randomweap", s_weapons.randomweap.curvalue );
		break;

       case ID_RAILTYPE:
              trap_Cvar_SetValue( "cg_railtype", s_weapons.railtype.curvalue );
		break;

       case ID_MG:
             trap_Cvar_SetValue( "g_mg", s_weapons.mg.curvalue);
             break;

       case ID_SG:
             trap_Cvar_SetValue( "g_sg", s_weapons.sg.curvalue);
             break;

       case ID_GL:
             trap_Cvar_SetValue( "g_gl", s_weapons.gl.curvalue);
             break;

       case ID_RL:
             trap_Cvar_SetValue( "g_rl", s_weapons.rl.curvalue);
             break;

       case ID_LG:
             trap_Cvar_SetValue( "g_lg", s_weapons.lg.curvalue);
             break;

       case ID_RG:
             trap_Cvar_SetValue( "g_rg", s_weapons.rg.curvalue);
             break;

       case ID_PG:
             trap_Cvar_SetValue( "g_pg", s_weapons.pg.curvalue);
             break;

       case ID_BFG:
             trap_Cvar_SetValue( "g_bfg", s_weapons.bfg.curvalue);
             break;

       case ID_WEAPONS:
             trap_Cvar_SetValue( "g_weaponchangetime", weapons);
             break;

       case ID_WEAPSWITCHDELAY:
              trap_Cvar_SetValue( "fastswitch", s_weapons.weaponswitch.curvalue );
              break;

       case ID_GRENADETYPE:
              trap_Cvar_SetValue( "grenadetype", s_weapons.grenadetype.curvalue );
              break;
       */
       case ID_WEAPONPOSITION:
       if (s_weapons.weaponposition.curvalue == 0)
             s_weapons.weaponposition.curvalue = 1;
              break;

       case ID_ACCEPT:
       trap_Cvar_SetValue( "cg_railtype", s_weapons.railtype.curvalue);
       trap_Cvar_SetValue( "lightningtype", s_weapons.chain.curvalue);
       trap_Cvar_SetValue( "bfgtype", s_weapons.bfgtype.curvalue);
       trap_Cvar_SetValue( "g_proxytime", proxytime);
       trap_Cvar_SetValue( "fastswitch", s_weapons.weaponswitch.curvalue );
       if (s_weapons.weaponposition.curvalue == 0)
             s_weapons.weaponposition.curvalue = 1;
       trap_Cvar_SetValue( "cg_weaponposition", s_weapons.weaponposition.curvalue );
       trap_Cvar_SetValue( "grenadetype", s_weapons.grenadetype.curvalue );
       trap_Cvar_SetValue( "cg_progressivezooming", s_weapons.progressivezoom.curvalue );
       trap_Cvar_SetValue( "g_maxpenetration", s_weapons.maxpenetration.curvalue );
       trap_Cvar_SetValue( "cg_rocketshaders", s_weapons.rocketshaders.curvalue );
       trap_Cvar_SetValue( "cg_selectgauntlet", s_weapons.selectgauntlet.curvalue );
       trap_Cvar_SetValue( "cg_selectgrapple", s_weapons.selectgrapple.curvalue );
       trap_Cvar_SetValue( "cg_drawsmoke", s_weapons.drawsmoke.curvalue );
             UI_PopMenu();
             break;

       case ID_RANDOMMENU:
              UI_RANDOMWEAPONS_MENU();
		break;

       case ID_WEAPONRANKING:
              UI_WEAPONRANKING_MENU();
		break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_WEAPONSBACK:
             UI_PopMenu();
             break;

	}
}

static void draw_weapons( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_weapons.menu );

       if( s_weapons.draw ) {
              s_weapons.draw();
       }
}

static void UI_WEAPONS_MENU( void )
{
	int				y;
       vmCvar_t botnochat;
       memset( &s_weapons, 0 ,sizeof(weapons_t) );

       Hellfire_Cache();

       s_weapons.menu.wrapAround = qtrue;
       s_weapons.menu.fullscreen = qtrue;
       s_weapons.menu.draw       = draw_weapons;

       s_weapons.banner.generic.type  = MTYPE_PTEXT;
       s_weapons.banner.generic.x        = 320;
       s_weapons.banner.generic.y        = 32;
       s_weapons.banner.string           = "WEAPON OPTIONS";
       s_weapons.banner.color         = color_orange;
       s_weapons.banner.style         = UI_CENTER;

       s_weapons.framel.generic.type  = MTYPE_BITMAP;
       s_weapons.framel.generic.name  = ART_FRAMEL;
       s_weapons.framel.generic.flags = QMF_INACTIVE;
       s_weapons.framel.generic.x        = 0;
       s_weapons.framel.generic.y        = 78;
       s_weapons.framel.width            = 256;
       s_weapons.framel.height           = 329;

       s_weapons.framer.generic.type  = MTYPE_BITMAP;
       s_weapons.framer.generic.name  = ART_FRAMER;
       s_weapons.framer.generic.flags = QMF_INACTIVE;
       s_weapons.framer.generic.x        = 0;
       s_weapons.framer.generic.y        = 0;
       s_weapons.framer.width            = 640;
       s_weapons.framer.height           = 480;

       y = 61; // 74
       y += BIGCHAR_HEIGHT+2+8;
       s_weapons.weaponswitch.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.weaponswitch.generic.name             = "Fast Weapon Switching            ";
       s_weapons.weaponswitch.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.weaponswitch.generic.callback          = Weapons_Event;
       s_weapons.weaponswitch.generic.id                = ID_WEAPSWITCHDELAY;
       s_weapons.weaponswitch.generic.x                    = Hellfire_X_POS+40;
       s_weapons.weaponswitch.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.weaponposition.generic.type              = MTYPE_SPINCONTROL;
       s_weapons.weaponposition.generic.name           = "Weapon Position                  ";
       s_weapons.weaponposition.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.weaponposition.generic.callback          = Weapons_Event;
       s_weapons.weaponposition.generic.id                = ID_WEAPONPOSITION;
       s_weapons.weaponposition.generic.x                    = Hellfire_X_POS+40;
       s_weapons.weaponposition.generic.y                    = y;
       s_weapons.weaponposition.itemnames             = weaponposition_items;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.grenadetype.generic.type              = MTYPE_SPINCONTROL;
       s_weapons.grenadetype.generic.name              = "Grenade Type                     ";
       s_weapons.grenadetype.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.grenadetype.generic.callback          = Weapons_Event;
       s_weapons.grenadetype.generic.id                = ID_GRENADETYPE;
       s_weapons.grenadetype.generic.x                    = Hellfire_X_POS+40;
       s_weapons.grenadetype.generic.y                    = y;
       s_weapons.grenadetype.itemnames             = grenadetype_items;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.railtype.generic.type              = MTYPE_SPINCONTROL;
       s_weapons.railtype.generic.name           = "Rail Trail Type                  ";
       s_weapons.railtype.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.railtype.generic.callback          = Weapons_Event;
       s_weapons.railtype.generic.id                = ID_RAILTYPE;
       s_weapons.railtype.generic.x                    = Hellfire_X_POS+40;
       s_weapons.railtype.generic.y                    = y;
       s_weapons.railtype.itemnames             = railtype_items;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.chain.generic.type              = MTYPE_SPINCONTROL;
       s_weapons.chain.generic.name           = "Lightning Gun Type               ";
       s_weapons.chain.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.chain.generic.callback          = Weapons_Event;
       s_weapons.chain.generic.id                = ID_CHAIN;
       s_weapons.chain.generic.x                    = Hellfire_X_POS+40;
       s_weapons.chain.generic.y                    = y;
       s_weapons.chain.itemnames             = chain_items;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.bfgtype.generic.type              = MTYPE_SPINCONTROL;
       s_weapons.bfgtype.generic.name           = "BFG10K Type                      ";
       s_weapons.bfgtype.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.bfgtype.generic.callback          = Weapons_Event;
       s_weapons.bfgtype.generic.id                = ID_BFGTYPE;
       s_weapons.bfgtype.generic.x                    = Hellfire_X_POS+40;
       s_weapons.bfgtype.generic.y                    = y;
       s_weapons.bfgtype.itemnames             = bfgtype_items;

       y += BIGCHAR_HEIGHT+2;
       s_weapons.proxytime.generic.type              = MTYPE_FIELD;
       s_weapons.proxytime.generic.name       = "Prox. Detonation Time            ";
       s_weapons.proxytime.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.proxytime.field.maxchars             = 3;
       s_weapons.proxytime.field.widthInChars        = 3;
       s_weapons.proxytime.generic.callback          = Weapons_Event;
       s_weapons.proxytime.generic.id                = ID_PROXYTIME;
       s_weapons.proxytime.generic.x                    = Hellfire_X_POS+40;
       s_weapons.proxytime.generic.y                    = y;
       s_weapons.proxytime.generic.statusbar            = Hellfire_StatusBar;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.progressivezoom.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.progressivezoom.generic.name              = "Progressive Zooming              ";
       s_weapons.progressivezoom.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.progressivezoom.generic.callback          = Weapons_Event;
       s_weapons.progressivezoom.generic.id                = ID_ZOOM;
       s_weapons.progressivezoom.generic.x                    = Hellfire_X_POS+40;
       s_weapons.progressivezoom.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.drawsmoke.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.drawsmoke.generic.name          =     "Smoke Trails                     ";
       s_weapons.drawsmoke.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.drawsmoke.generic.callback    = Weapons_Event;
       s_weapons.drawsmoke.generic.id          = ID_DRAWSMOKE;
       s_weapons.drawsmoke.generic.x                 = Hellfire_X_POS+40;
       s_weapons.drawsmoke.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.rocketshaders.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.rocketshaders.generic.name          = "Rocket Launcher Shaders          ";
       s_weapons.rocketshaders.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.rocketshaders.generic.callback    = Weapons_Event;
       s_weapons.rocketshaders.generic.id          = ID_ROCKETSHADERS;
       s_weapons.rocketshaders.generic.x                 = Hellfire_X_POS+40;
       s_weapons.rocketshaders.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.maxpenetration.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.maxpenetration.generic.name          = "Maximum Rail Penetration         ";
       s_weapons.maxpenetration.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.maxpenetration.generic.callback          = Weapons_Event;
       s_weapons.maxpenetration.generic.id                = ID_MAXPENETRATION;
       s_weapons.maxpenetration.generic.x                    = Hellfire_X_POS+40;
       s_weapons.maxpenetration.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.selectgauntlet.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.selectgauntlet.generic.name          = "Weapon Selection Cycle : Gauntlet";
       s_weapons.selectgauntlet.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.selectgauntlet.generic.callback    = Weapons_Event;
       s_weapons.selectgauntlet.generic.id          = ID_SELECTGAUNTLET;
       s_weapons.selectgauntlet.generic.x                 = Hellfire_X_POS+40;
       s_weapons.selectgauntlet.generic.y                 = y;

	y += BIGCHAR_HEIGHT+2;
       s_weapons.selectgrapple.generic.type              = MTYPE_RADIOBUTTON;
       s_weapons.selectgrapple.generic.name          = "Weapon Selection Cycle : Grapple ";
       s_weapons.selectgrapple.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weapons.selectgrapple.generic.callback    = Weapons_Event;
       s_weapons.selectgrapple.generic.id          = ID_SELECTGRAPPLE;
       s_weapons.selectgrapple.generic.x                 = Hellfire_X_POS+40;
       s_weapons.selectgrapple.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2+10;
       s_weapons.weaponranking.generic.type     = MTYPE_PTEXT;
       s_weapons.weaponranking.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.weaponranking.generic.callback = Weapons_Event;
       s_weapons.weaponranking.generic.id       = ID_WEAPONRANKING;
       s_weapons.weaponranking.generic.x        = 320;
       s_weapons.weaponranking.generic.y        = y;
       s_weapons.weaponranking.string           = "Weapon Ranking";
       s_weapons.weaponranking.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_weapons.weaponranking.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_weapons.randomweapons.generic.type     = MTYPE_PTEXT;
       s_weapons.randomweapons.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.randomweapons.generic.callback = Weapons_Event;
       s_weapons.randomweapons.generic.id       = ID_RANDOMMENU;
       s_weapons.randomweapons.generic.x        = 320;
       s_weapons.randomweapons.generic.y        = y;
       s_weapons.randomweapons.string           = "Random Weapons Options";
       s_weapons.randomweapons.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_weapons.randomweapons.color            = color_red;

       s_weapons.back.generic.type        = MTYPE_BITMAP;
       s_weapons.back.generic.name     = ART_BACK0;
       s_weapons.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.back.generic.callback = Weapons_Event;
       s_weapons.back.generic.id          = ID_WEAPONSBACK;
       s_weapons.back.generic.x           = 0;
       s_weapons.back.generic.y           = 475-64;
       s_weapons.back.width               = 128;
       s_weapons.back.height              = 64;
       s_weapons.back.focuspic         = ART_BACK1;
       s_weapons.back.generic.statusbar            = Hellfire_StatusBar2;

       s_weapons.load.generic.type        = MTYPE_BITMAP;
       s_weapons.load.generic.name     = ART_LOAD0;
       s_weapons.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.load.generic.callback = Weapons_Event;
       s_weapons.load.generic.id          = ID_LOAD;
       s_weapons.load.generic.x           = 128;
       s_weapons.load.generic.y           = 475-64;
       s_weapons.load.width               = 128;
       s_weapons.load.height              = 64;
       s_weapons.load.focuspic         = ART_LOAD1;
       s_weapons.load.generic.statusbar            = Hellfire_StatusBar7;

       s_weapons.save.generic.type        = MTYPE_BITMAP;
       s_weapons.save.generic.name     = ART_SAVE0;
       s_weapons.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.save.generic.callback = Weapons_Event;
       s_weapons.save.generic.id          = ID_SAVE;
       s_weapons.save.generic.x           = 384;
       s_weapons.save.generic.y           = 475-64;
       s_weapons.save.width               = 128;
       s_weapons.save.height              = 64;
       s_weapons.save.focuspic         = ART_SAVE1;
       s_weapons.save.generic.statusbar            = Hellfire_StatusBar8;

       s_weapons.accept.generic.type        = MTYPE_BITMAP;
       s_weapons.accept.generic.name     = ART_ACCEPT0;
       s_weapons.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weapons.accept.generic.callback = Weapons_Event;
       s_weapons.accept.generic.id          = ID_ACCEPT;
       s_weapons.accept.generic.x           = 512;
       s_weapons.accept.generic.y           = 475-64;
       s_weapons.accept.width               = 128;
       s_weapons.accept.height              = 64;
       s_weapons.accept.focuspic         = ART_ACCEPT1;
       s_weapons.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_weapons.menu, &s_weapons.banner );
       Menu_AddItem( &s_weapons.menu, &s_weapons.framel );
       Menu_AddItem( &s_weapons.menu, &s_weapons.framer );

//       Menu_AddItem( &s_weapons.menu, &s_weapons.weapons );
       Menu_AddItem( &s_weapons.menu, &s_weapons.weaponswitch );
       Menu_AddItem( &s_weapons.menu, &s_weapons.weaponposition );
       Menu_AddItem( &s_weapons.menu, &s_weapons.grenadetype );
       Menu_AddItem( &s_weapons.menu, &s_weapons.railtype );
       Menu_AddItem( &s_weapons.menu, &s_weapons.chain );
       Menu_AddItem( &s_weapons.menu, &s_weapons.bfgtype );
       Menu_AddItem( &s_weapons.menu, &s_weapons.proxytime );
       Menu_AddItem( &s_weapons.menu, &s_weapons.progressivezoom );
       Menu_AddItem( &s_weapons.menu, &s_weapons.drawsmoke );
       Menu_AddItem( &s_weapons.menu, &s_weapons.rocketshaders );
       Menu_AddItem( &s_weapons.menu, &s_weapons.maxpenetration );
       Menu_AddItem( &s_weapons.menu, &s_weapons.selectgauntlet );
       Menu_AddItem( &s_weapons.menu, &s_weapons.selectgrapple );
       Menu_AddItem( &s_weapons.menu, &s_weapons.weaponranking );
       Menu_AddItem( &s_weapons.menu, &s_weapons.randomweapons );
       Menu_AddItem( &s_weapons.menu, &s_weapons.back );
       Menu_AddItem( &s_weapons.menu, &s_weapons.load );
       Menu_AddItem( &s_weapons.menu, &s_weapons.save );
       Menu_AddItem( &s_weapons.menu, &s_weapons.accept );
       s_weapons.weaponswitch.curvalue        = trap_Cvar_VariableValue( "fastswitch" ) != 0;
       s_weapons.progressivezoom.curvalue        = trap_Cvar_VariableValue( "cg_progressivezooming" ) != 0;
       s_weapons.maxpenetration.curvalue        = trap_Cvar_VariableValue( "g_maxpenetration" ) != 0;
       s_weapons.selectgauntlet.curvalue        = trap_Cvar_VariableValue( "cg_selectgauntlet" ) != 0;
       s_weapons.selectgrapple.curvalue        = trap_Cvar_VariableValue( "cg_selectgrapple" ) != 0;
       s_weapons.drawsmoke.curvalue        = trap_Cvar_VariableValue( "cg_drawsmoke" ) != 0;
       s_weapons.rocketshaders.curvalue        = trap_Cvar_VariableValue( "cg_rocketshaders" ) != 0;
       s_weapons.weaponposition.curvalue = Com_Clamp( 1, 3, trap_Cvar_VariableValue( "cg_weaponposition" ) );
       s_weapons.grenadetype.curvalue = Com_Clamp( 0, 4, trap_Cvar_VariableValue( "grenadetype" ) );
       s_weapons.railtype.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "cg_railtype" ) );
       s_weapons.chain.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "lightningtype" ) );
       s_weapons.bfgtype.curvalue = Com_Clamp( 0, 1, trap_Cvar_VariableValue( "bfgtype" ) );
       Q_strncpyz( s_weapons.proxytime.field.buffer, UI_Cvar_VariableString("g_proxytime"), sizeof(s_weapons.proxytime.field.buffer) );
       UI_PushMenu( &s_weapons.menu );
}

static void RandomWeapons_Event( void* ptr, int notification ) {
       int randomweapons,proxytime;
       randomweapons       = atoi( s_randomweapons.weapons.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {

       case ID_ACCEPT:
       trap_Cvar_SetValue( "g_mg", s_randomweapons.mg.curvalue);
       trap_Cvar_SetValue( "g_sg", s_randomweapons.sg.curvalue);
       trap_Cvar_SetValue( "g_gl", s_randomweapons.gl.curvalue);
       trap_Cvar_SetValue( "g_rl", s_randomweapons.rl.curvalue);
       trap_Cvar_SetValue( "g_lg", s_randomweapons.lg.curvalue);
       trap_Cvar_SetValue( "g_rg", s_randomweapons.rg.curvalue);
       trap_Cvar_SetValue( "g_pg", s_randomweapons.pg.curvalue);
       trap_Cvar_SetValue( "g_bfg", s_randomweapons.bfg.curvalue);
       trap_Cvar_SetValue( "g_ft", s_randomweapons.ft.curvalue);
       trap_Cvar_SetValue( "g_weaponchangetime", randomweapons);
       trap_Cvar_SetValue( "randomweap", s_randomweapons.randomweap.curvalue );
             UI_PopMenu();
             break;

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_WEAPONSBACK:
             UI_PopMenu();
             break;

	}
}

static void draw_randomweapons( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       Menu_Draw( &s_randomweapons.menu );

       if( s_randomweapons.draw ) {
              s_randomweapons.draw();
       }
}

static void UI_RANDOMWEAPONS_MENU( void )
{
	int				y;
       vmCvar_t botnochat;
       memset( &s_randomweapons, 0 ,sizeof(randomweapons_t) );

       Hellfire_Cache();

       s_randomweapons.menu.wrapAround = qtrue;
       s_randomweapons.menu.fullscreen = qtrue;
       s_randomweapons.menu.draw       = draw_randomweapons;

       s_randomweapons.banner.generic.type  = MTYPE_PTEXT;
       s_randomweapons.banner.generic.x        = 320;
       s_randomweapons.banner.generic.y        = 32;
       s_randomweapons.banner.string           = "RANDOM WEAPON OPTIONS";
       s_randomweapons.banner.color         = color_orange;
       s_randomweapons.banner.style         = UI_CENTER;

       s_randomweapons.framel.generic.type  = MTYPE_BITMAP;
       s_randomweapons.framel.generic.name  = ART_FRAMEL;
       s_randomweapons.framel.generic.flags = QMF_INACTIVE;
       s_randomweapons.framel.generic.x        = 0;
       s_randomweapons.framel.generic.y        = 78;
       s_randomweapons.framel.width            = 256;
       s_randomweapons.framel.height           = 329;

       s_randomweapons.framer.generic.type  = MTYPE_BITMAP;
       s_randomweapons.framer.generic.name  = ART_FRAMER;
       s_randomweapons.framer.generic.flags = QMF_INACTIVE;
       s_randomweapons.framer.generic.x        = 0;
       s_randomweapons.framer.generic.y        = 0;
       s_randomweapons.framer.width            = 640;
       s_randomweapons.framer.height           = 480;

       y = 61; // 74
       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.randomweap.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.randomweap.generic.name       = "Random Weapons          ";
       s_randomweapons.randomweap.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_randomweapons.randomweap.generic.callback    = RandomWeapons_Event;
       s_randomweapons.randomweap.generic.id          = ID_RANDOMWEAP;
       s_randomweapons.randomweap.generic.x                 = Hellfire_X_POS;
       s_randomweapons.randomweap.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.weapons.generic.type              = MTYPE_FIELD;
       s_randomweapons.weapons.generic.name          = "Random Weapon Duration  ";
       s_randomweapons.weapons.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_randomweapons.weapons.field.maxchars             = 3;
       s_randomweapons.weapons.field.widthInChars        = 3;
       s_randomweapons.weapons.generic.callback          = RandomWeapons_Event;
       s_randomweapons.weapons.generic.id                = ID_WEAPONS;
       s_randomweapons.weapons.generic.x                    = Hellfire_X_POS;
       s_randomweapons.weapons.generic.y                    = y;
       s_randomweapons.weapons.generic.statusbar            = Hellfire_StatusBar;

       y += BIGCHAR_HEIGHT+2+28;
       s_randomweapons.random.generic.type            = MTYPE_BTEXT;
       s_randomweapons.random.generic.flags           = QMF_SMALLFONT;
       s_randomweapons.random.generic.id                     = ID_RANDOM;
       s_randomweapons.random.generic.ownerdraw       = Weapons_Draw;
       s_randomweapons.random.generic.x                 = Hellfire_X_POS;
       s_randomweapons.random.generic.y                 = y;

       s_randomweapons.i_mg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_mg.generic.name  = ART_MG;
       s_randomweapons.i_mg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_mg.generic.x        = 185;
       s_randomweapons.i_mg.generic.y        = y;
       s_randomweapons.i_mg.width            = 16;
       s_randomweapons.i_mg.height           = 16;

       s_randomweapons.mg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.mg.generic.name          =      "Machinegun            ";
       s_randomweapons.mg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.mg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.mg.generic.id          = ID_MG;
       s_randomweapons.mg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.mg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_sg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_sg.generic.name  = ART_SG;
       s_randomweapons.i_sg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_sg.generic.x        = 185;
       s_randomweapons.i_sg.generic.y        = y;
       s_randomweapons.i_sg.width            = 16;
       s_randomweapons.i_sg.height           = 16;

       s_randomweapons.sg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.sg.generic.name          = "Shotgun               ";
       s_randomweapons.sg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.sg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.sg.generic.id          = ID_SG;
       s_randomweapons.sg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.sg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_gl.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_gl.generic.name  = ART_GL;
       s_randomweapons.i_gl.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_gl.generic.x        = 185;
       s_randomweapons.i_gl.generic.y        = y;
       s_randomweapons.i_gl.width            = 16;
       s_randomweapons.i_gl.height           = 16;

       s_randomweapons.gl.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.gl.generic.name         =    "Grenade Launcher      ";
       s_randomweapons.gl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.gl.generic.callback    = RandomWeapons_Event;
       s_randomweapons.gl.generic.id          = ID_GL;
       s_randomweapons.gl.generic.x                 = Hellfire_X_POS;
       s_randomweapons.gl.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_rl.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_rl.generic.name  = ART_RL;
       s_randomweapons.i_rl.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_rl.generic.x        = 185;
       s_randomweapons.i_rl.generic.y        = y;
       s_randomweapons.i_rl.width            = 16;
       s_randomweapons.i_rl.height           = 16;

       s_randomweapons.rl.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.rl.generic.name         = "Rocket Launcher       ";
       s_randomweapons.rl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.rl.generic.callback    = RandomWeapons_Event;
       s_randomweapons.rl.generic.id          = ID_RL;
       s_randomweapons.rl.generic.x                 = Hellfire_X_POS;
       s_randomweapons.rl.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_lg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_lg.generic.name  = ART_LG;
       s_randomweapons.i_lg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_lg.generic.x        = 185;
       s_randomweapons.i_lg.generic.y        = y;
       s_randomweapons.i_lg.width            = 16;
       s_randomweapons.i_lg.height           = 16;

       s_randomweapons.lg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.lg.generic.name    = "Lightning Gun         ";
       s_randomweapons.lg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.lg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.lg.generic.id          = ID_LG;
       s_randomweapons.lg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.lg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_rg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_rg.generic.name  = ART_RG;
       s_randomweapons.i_rg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_rg.generic.x        = 185;
       s_randomweapons.i_rg.generic.y        = y;
       s_randomweapons.i_rg.width            = 16;
       s_randomweapons.i_rg.height           = 16;

       s_randomweapons.rg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.rg.generic.name    = "Railgun               ";
       s_randomweapons.rg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.rg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.rg.generic.id          = ID_RG;
       s_randomweapons.rg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.rg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_pg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_pg.generic.name  = ART_PG;
       s_randomweapons.i_pg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_pg.generic.x        = 185;
       s_randomweapons.i_pg.generic.y        = y;
       s_randomweapons.i_pg.width            = 16;
       s_randomweapons.i_pg.height           = 16;

       s_randomweapons.pg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.pg.generic.name    = "Plasma Gun            ";
       s_randomweapons.pg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.pg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.pg.generic.id          = ID_PG;
       s_randomweapons.pg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.pg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_bfg.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_bfg.generic.name  = ART_BFG;
       s_randomweapons.i_bfg.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_bfg.generic.x        = 185;
       s_randomweapons.i_bfg.generic.y        = y;
       s_randomweapons.i_bfg.width            = 16;
       s_randomweapons.i_bfg.height           = 16;

       s_randomweapons.bfg.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.bfg.generic.name                      = "BFG10k                ";
       s_randomweapons.bfg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.bfg.generic.callback    = RandomWeapons_Event;
       s_randomweapons.bfg.generic.id          = ID_BFG;
       s_randomweapons.bfg.generic.x                 = Hellfire_X_POS;
       s_randomweapons.bfg.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_randomweapons.i_ft.generic.type  = MTYPE_BITMAP;
       s_randomweapons.i_ft.generic.name  = ART_FT;
       s_randomweapons.i_ft.generic.flags = QMF_INACTIVE;
       s_randomweapons.i_ft.generic.x        = 185;
       s_randomweapons.i_ft.generic.y        = y;
       s_randomweapons.i_ft.width            = 16;
       s_randomweapons.i_ft.height           = 16;

       s_randomweapons.ft.generic.type        = MTYPE_RADIOBUTTON;
       s_randomweapons.ft.generic.name                      = "Flame Thrower         ";
       s_randomweapons.ft.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_randomweapons.ft.generic.callback    = RandomWeapons_Event;
       s_randomweapons.ft.generic.id          = ID_FT;
       s_randomweapons.ft.generic.x                 = Hellfire_X_POS;
       s_randomweapons.ft.generic.y                 = y;

       s_randomweapons.back.generic.type        = MTYPE_BITMAP;
       s_randomweapons.back.generic.name     = ART_BACK0;
       s_randomweapons.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_randomweapons.back.generic.callback = RandomWeapons_Event;
       s_randomweapons.back.generic.id          = ID_WEAPONSBACK;
       s_randomweapons.back.generic.x           = 0;
       s_randomweapons.back.generic.y           = 475-64;
       s_randomweapons.back.width               = 128;
       s_randomweapons.back.height              = 64;
       s_randomweapons.back.focuspic         = ART_BACK1;
       s_randomweapons.back.generic.statusbar            = Hellfire_StatusBar2;

       s_randomweapons.load.generic.type        = MTYPE_BITMAP;
       s_randomweapons.load.generic.name     = ART_LOAD0;
       s_randomweapons.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_randomweapons.load.generic.callback = RandomWeapons_Event;
       s_randomweapons.load.generic.id          = ID_LOAD;
       s_randomweapons.load.generic.x           = 128;
       s_randomweapons.load.generic.y           = 475-64;
       s_randomweapons.load.width               = 128;
       s_randomweapons.load.height              = 64;
       s_randomweapons.load.focuspic         = ART_LOAD1;
       s_randomweapons.load.generic.statusbar            = Hellfire_StatusBar7;

       s_randomweapons.save.generic.type        = MTYPE_BITMAP;
       s_randomweapons.save.generic.name     = ART_SAVE0;
       s_randomweapons.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_randomweapons.save.generic.callback = RandomWeapons_Event;
       s_randomweapons.save.generic.id          = ID_SAVE;
       s_randomweapons.save.generic.x           = 384;
       s_randomweapons.save.generic.y           = 475-64;
       s_randomweapons.save.width               = 128;
       s_randomweapons.save.height              = 64;
       s_randomweapons.save.focuspic         = ART_SAVE1;
       s_randomweapons.save.generic.statusbar            = Hellfire_StatusBar8;

       s_randomweapons.accept.generic.type        = MTYPE_BITMAP;
       s_randomweapons.accept.generic.name     = ART_ACCEPT0;
       s_randomweapons.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_randomweapons.accept.generic.callback = RandomWeapons_Event;
       s_randomweapons.accept.generic.id          = ID_ACCEPT;
       s_randomweapons.accept.generic.x           = 512;
       s_randomweapons.accept.generic.y           = 475-64;
       s_randomweapons.accept.width               = 128;
       s_randomweapons.accept.height              = 64;
       s_randomweapons.accept.focuspic         = ART_ACCEPT1;
       s_randomweapons.accept.generic.statusbar            = Hellfire_StatusBar3;

       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.banner );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.framel );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.framer );

       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.randomweap );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.weapons );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.mg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.sg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.gl );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.rl );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.lg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.rg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.pg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.bfg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.ft );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.back );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.load );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.save );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.accept );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_mg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_sg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_gl );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_rl );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_lg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_rg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_pg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_bfg );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.i_ft );
       Menu_AddItem( &s_randomweapons.menu, &s_randomweapons.random );
       s_randomweapons.mg.curvalue = trap_Cvar_VariableValue( "g_mg" ) != 0;
       s_randomweapons.sg.curvalue = trap_Cvar_VariableValue( "g_sg" ) != 0;
       s_randomweapons.gl.curvalue = trap_Cvar_VariableValue( "g_gl" ) != 0;
       s_randomweapons.rl.curvalue = trap_Cvar_VariableValue( "g_rl" ) != 0;
       s_randomweapons.lg.curvalue = trap_Cvar_VariableValue( "g_lg" ) != 0;
       s_randomweapons.rg.curvalue = trap_Cvar_VariableValue( "g_rg" ) != 0;
       s_randomweapons.pg.curvalue = trap_Cvar_VariableValue( "g_pg" ) != 0;
       s_randomweapons.bfg.curvalue = trap_Cvar_VariableValue( "g_bfg" ) != 0;
       s_randomweapons.ft.curvalue = trap_Cvar_VariableValue( "g_ft" ) != 0;
       s_randomweapons.randomweap.curvalue        = trap_Cvar_VariableValue( "randomweap" ) != 0;
       Q_strncpyz( s_randomweapons.weapons.field.buffer, UI_Cvar_VariableString("g_weaponchangetime"), sizeof(s_randomweapons.weapons.field.buffer) );
       UI_PushMenu( &s_randomweapons.menu );
}

static void UI_WEAPONCONFIG2_MENU( void );

static void Weaponconfig_Event( void* ptr, int notification ) {
       int ftreload,mgreload,sgreload,glreload,rlreload,lgreload,rgreload,pgreload,bfgreload,mgammo,sgammo,glammo,rlammo,lgammo,rgammo,pgammo,bfgammo,ftammo;
       int gpreload;
       int ftrespawn,mgrespawn,sgrespawn,glrespawn,rlrespawn,lgrespawn,rgrespawn,pgrespawn,bfgrespawn;
       int ftammorespawn,mgammorespawn,sgammorespawn,glammorespawn,rlammorespawn,lgammorespawn,rgammorespawn,pgammorespawn,bfgammorespawn;
       int ftdamage,gtdamage, mgdamage, sgdamage, gldamage, rldamage, lgdamage, rgdamage, pgdamage, bfgdamage;
       int grenadevelocity,rocketvelocity,plasmavelocity,bfgvelocity,grapplevelocity;
       mgreload       = atoi( s_weaponconfig.mgr.field.buffer );
       gpreload       = atoi( s_weaponconfig.gpr.field.buffer );
       sgreload       = atoi( s_weaponconfig.sgr.field.buffer );
       glreload       = atoi( s_weaponconfig.glr.field.buffer );
       rlreload       = atoi( s_weaponconfig.rlr.field.buffer );
       lgreload       = atoi( s_weaponconfig.lgr.field.buffer );
       rgreload       = atoi( s_weaponconfig.rgr.field.buffer );
       pgreload       = atoi( s_weaponconfig.pgr.field.buffer );
       bfgreload       = atoi( s_weaponconfig.bfgr.field.buffer );
       ftreload       = atoi( s_weaponconfig.ftr.field.buffer );
       mgammo         = atoi( s_weaponconfig.mgac.field.buffer );
       sgammo         = atoi( s_weaponconfig.sgac.field.buffer );
       glammo         = atoi( s_weaponconfig.glac.field.buffer );
       rlammo         = atoi( s_weaponconfig.rlac.field.buffer );
       lgammo         = atoi( s_weaponconfig.lgac.field.buffer );
       rgammo         = atoi( s_weaponconfig.rgac.field.buffer );
       pgammo         = atoi( s_weaponconfig.pgac.field.buffer );
       bfgammo        = atoi( s_weaponconfig.bfgac.field.buffer );
       ftammo        = atoi( s_weaponconfig.ftac.field.buffer );
       mgrespawn      = atoi( s_weaponconfig.mgres.field.buffer );
       sgrespawn      = atoi( s_weaponconfig.sgres.field.buffer );
       glrespawn      = atoi( s_weaponconfig.glres.field.buffer );
       rlrespawn      = atoi( s_weaponconfig.rlres.field.buffer );
       lgrespawn      = atoi( s_weaponconfig.lgres.field.buffer );
       rgrespawn      = atoi( s_weaponconfig.rgres.field.buffer );
       pgrespawn      = atoi( s_weaponconfig.pgres.field.buffer );
       bfgrespawn      = atoi( s_weaponconfig.bfgres.field.buffer );
       ftrespawn      = atoi( s_weaponconfig.ftres.field.buffer );
       mgammorespawn      = atoi( s_weaponconfig.mgresa.field.buffer );
       sgammorespawn      = atoi( s_weaponconfig.sgresa.field.buffer );
       glammorespawn      = atoi( s_weaponconfig.glresa.field.buffer );
       rlammorespawn      = atoi( s_weaponconfig.rlresa.field.buffer );
       lgammorespawn      = atoi( s_weaponconfig.lgresa.field.buffer );
       rgammorespawn      = atoi( s_weaponconfig.rgresa.field.buffer );
       pgammorespawn      = atoi( s_weaponconfig.pgresa.field.buffer );
       bfgammorespawn      = atoi( s_weaponconfig.bfgresa.field.buffer );
       ftammorespawn      = atoi( s_weaponconfig.ftresa.field.buffer );
       gtdamage      = atoi( s_weaponconfig.gtdam.field.buffer );
       mgdamage      = atoi( s_weaponconfig.mgdam.field.buffer );
       sgdamage      = atoi( s_weaponconfig.sgdam.field.buffer );
       gldamage      = atoi( s_weaponconfig.gldam.field.buffer );
       rldamage      = atoi( s_weaponconfig.rldam.field.buffer );
       lgdamage      = atoi( s_weaponconfig.lgdam.field.buffer );
       rgdamage      = atoi( s_weaponconfig.rgdam.field.buffer );
       pgdamage      = atoi( s_weaponconfig.pgdam.field.buffer );
       bfgdamage      = atoi( s_weaponconfig.bfgdam.field.buffer );
       ftdamage      = atoi( s_weaponconfig.ftdam.field.buffer );
       grenadevelocity = atoi( s_weaponconfig.grenadevelocity.field.buffer );
       grapplevelocity = atoi( s_weaponconfig.grapplevelocity.field.buffer );
       rocketvelocity = atoi( s_weaponconfig.rocketvelocity.field.buffer );
       plasmavelocity = atoi( s_weaponconfig.plasmavelocity.field.buffer );
       bfgvelocity = atoi( s_weaponconfig.bfgvelocity.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       /*
       case ID_MGWEAP:
              trap_Cvar_SetValue( "g_mgweap", s_weaponconfig.mg.curvalue );
              break;

       case ID_MGAMMO:
              trap_Cvar_SetValue( "g_mgammo", s_weaponconfig.mga.curvalue );
		break;

       case ID_MGAMMOCOUNT:
              trap_Cvar_SetValue( "machinegunammo", mgammo );
		break;

       case ID_SGWEAP:
              trap_Cvar_SetValue( "g_sgweap", s_weaponconfig.sg.curvalue );
		break;

       case ID_SGAMMO:
              trap_Cvar_SetValue( "g_sgammo", s_weaponconfig.sga.curvalue );
		break;

       case ID_SGAMMOCOUNT:
              trap_Cvar_SetValue( "shotgunammo", sgammo );
		break;

       case ID_GLWEAP:
              trap_Cvar_SetValue( "g_glweap", s_weaponconfig.gl.curvalue );
		break;

       case ID_GLAMMO:
              trap_Cvar_SetValue( "g_glammo", s_weaponconfig.gla.curvalue );
		break;

       case ID_GLAMMOCOUNT:
              trap_Cvar_SetValue( "grenadeammo", glammo );
		break;

       case ID_RLWEAP:
              trap_Cvar_SetValue( "g_rlweap", s_weaponconfig.rl.curvalue );
		break;

       case ID_RLAMMO:
              trap_Cvar_SetValue( "g_rlammo", s_weaponconfig.rla.curvalue );
		break;

       case ID_RLAMMOCOUNT:
              trap_Cvar_SetValue( "rocketammo", rlammo );
		break;

       case ID_LGWEAP:
              trap_Cvar_SetValue( "g_lgweap", s_weaponconfig.lg.curvalue );
		break;

       case ID_LGAMMO:
              trap_Cvar_SetValue( "g_lgammo", s_weaponconfig.lga.curvalue );
		break;

       case ID_LGAMMOCOUNT:
              trap_Cvar_SetValue( "lightningammo", lgammo );
		break;

       case ID_RGWEAP:
              trap_Cvar_SetValue( "g_rgweap", s_weaponconfig.rg.curvalue );
		break;

       case ID_RGAMMO:
              trap_Cvar_SetValue( "g_rgammo", s_weaponconfig.rga.curvalue );
		break;

       case ID_RGAMMOCOUNT:
              trap_Cvar_SetValue( "railgunammo", rgammo );
		break;

       case ID_PGWEAP:
              trap_Cvar_SetValue( "g_pgweap", s_weaponconfig.pg.curvalue );
		break;

       case ID_PGAMMO:
              trap_Cvar_SetValue( "g_pgammo", s_weaponconfig.pga.curvalue );
		break;

       case ID_PGAMMOCOUNT:
              trap_Cvar_SetValue( "plasmaammo", pgammo );
		break;

       case ID_BFGWEAP:
              trap_Cvar_SetValue( "g_bfgweap", s_weaponconfig.bfg.curvalue );
		break;

       case ID_BFGAMMO:
              trap_Cvar_SetValue( "g_bfgammo", s_weaponconfig.bfga.curvalue );
		break;

       case ID_BFGAMMOCOUNT:
              trap_Cvar_SetValue( "bfgammo", bfgammo );
		break;

       case ID_MGRELOAD:
              trap_Cvar_SetValue( "g_mgreload", mgreload );
		break;

       case ID_SGRELOAD:
              trap_Cvar_SetValue( "g_sgreload", sgreload );
		break;

       case ID_GLRELOAD:
              trap_Cvar_SetValue( "g_glreload", glreload );
		break;

       case ID_RLRELOAD:
              trap_Cvar_SetValue( "g_rlreload", rlreload );
		break;

       case ID_LGRELOAD:
              trap_Cvar_SetValue( "g_lgreload", lgreload );
		break;

       case ID_RGRELOAD:
              trap_Cvar_SetValue( "g_rgreload", rgreload );
		break;

       case ID_PGRELOAD:
              trap_Cvar_SetValue( "g_pgreload", pgreload );
		break;

       case ID_BFGRELOAD:
              trap_Cvar_SetValue( "g_bfgreload", bfgreload );
		break;

       case ID_MGRESPAWN:
              trap_Cvar_SetValue( "g_mgrespawn", mgrespawn );
		break;

       case ID_SGRESPAWN:
              trap_Cvar_SetValue( "g_sgrespawn", sgrespawn );
		break;

       case ID_GLRESPAWN:
              trap_Cvar_SetValue( "g_glrespawn", glrespawn );
		break;

       case ID_RLRESPAWN:
              trap_Cvar_SetValue( "g_rlrespawn", rlrespawn );
		break;

       case ID_LGRESPAWN:
              trap_Cvar_SetValue( "g_lgrespawn", lgrespawn );
		break;

       case ID_RGRESPAWN:
              trap_Cvar_SetValue( "g_rgrespawn", rgrespawn );
		break;

       case ID_PGRESPAWN:
              trap_Cvar_SetValue( "g_pgrespawn", pgrespawn );
		break;

       case ID_BFGRESPAWN:
              trap_Cvar_SetValue( "g_bfgrespawn", bfgrespawn );
		break;

       case ID_MGAMMORESPAWN:
              trap_Cvar_SetValue( "g_mgammorespawn", mgammorespawn );
		break;

       case ID_SGAMMORESPAWN:
              trap_Cvar_SetValue( "g_sgammorespawn", sgammorespawn );
		break;

       case ID_GLAMMORESPAWN:
              trap_Cvar_SetValue( "g_glammorespawn", glammorespawn );
		break;

       case ID_RLAMMORESPAWN:
              trap_Cvar_SetValue( "g_rlammorespawn", rlammorespawn );
		break;

       case ID_LGAMMORESPAWN:
              trap_Cvar_SetValue( "g_lgammorespawn", lgammorespawn );
		break;

       case ID_RGAMMORESPAWN:
              trap_Cvar_SetValue( "g_rgammorespawn", rgammorespawn );
		break;

       case ID_PGAMMORESPAWN:
              trap_Cvar_SetValue( "g_pgammorespawn", pgammorespawn );
		break;

       case ID_BFGAMMORESPAWN:
              trap_Cvar_SetValue( "g_bfgammorespawn", bfgammorespawn );
		break;

       case ID_GTDAMAGE:
              trap_Cvar_SetValue( "gtdamage", gtdamage );
		break;

       case ID_MGDAMAGE:
              trap_Cvar_SetValue( "mgdamage", mgdamage );
		break;

       case ID_SGDAMAGE:
              trap_Cvar_SetValue( "sgdamage", sgdamage );
		break;

       case ID_GLDAMAGE:
              trap_Cvar_SetValue( "gldamage", gldamage );
		break;

       case ID_RLDAMAGE:
              trap_Cvar_SetValue( "rldamage", rldamage );
		break;

       case ID_LGDAMAGE:
              trap_Cvar_SetValue( "lgdamage", lgdamage );
		break;

       case ID_RGDAMAGE:
              trap_Cvar_SetValue( "rgdamage", rgdamage );
		break;

       case ID_PGDAMAGE:
              trap_Cvar_SetValue( "pgdamage", pgdamage );
		break;

       case ID_BFGDAMAGE:
              trap_Cvar_SetValue( "bfgdamage", bfgdamage );
		break;
       */

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_WEAPONCONFIGBACK:
             UI_PopMenu();
             break;

       case ID_MOREOPTIONS:
             UI_WEAPONCONFIG2_MENU();
             break;

       case ID_WEAPONIMAGE:
              s_weaponconfig.weaponimage.curvalue++;
              if( s_weaponconfig.weaponimage.curvalue == 8 ) {
                     s_weaponconfig.weaponimage.curvalue = 0;
		}
		break;

       case ID_ACCEPT:
       trap_Cvar_SetValue( "g_mgweap", s_weaponconfig.mg.curvalue);
       trap_Cvar_SetValue( "g_sgweap", s_weaponconfig.sg.curvalue);
       trap_Cvar_SetValue( "g_glweap", s_weaponconfig.gl.curvalue);
       trap_Cvar_SetValue( "g_rlweap", s_weaponconfig.rl.curvalue);
       trap_Cvar_SetValue( "g_lgweap", s_weaponconfig.lg.curvalue);
       trap_Cvar_SetValue( "g_rgweap", s_weaponconfig.rg.curvalue);
       trap_Cvar_SetValue( "g_pgweap", s_weaponconfig.pg.curvalue);
       trap_Cvar_SetValue( "g_bfgweap", s_weaponconfig.bfg.curvalue);
       trap_Cvar_SetValue( "g_mgammo", s_weaponconfig.mga.curvalue);
       trap_Cvar_SetValue( "g_sgammo", s_weaponconfig.sga.curvalue);
       trap_Cvar_SetValue( "g_glammo", s_weaponconfig.gla.curvalue);
       trap_Cvar_SetValue( "g_rlammo", s_weaponconfig.rla.curvalue);
       trap_Cvar_SetValue( "g_lgammo", s_weaponconfig.lga.curvalue);
       trap_Cvar_SetValue( "g_rgammo", s_weaponconfig.rga.curvalue);
       trap_Cvar_SetValue( "g_pgammo", s_weaponconfig.pga.curvalue);
       trap_Cvar_SetValue( "g_bfgammo", s_weaponconfig.bfga.curvalue);
       trap_Cvar_SetValue( "g_mgreload", mgreload );
       trap_Cvar_SetValue( "g_sgreload", sgreload );
       trap_Cvar_SetValue( "g_glreload", glreload );
       trap_Cvar_SetValue( "g_rlreload", rlreload );
       trap_Cvar_SetValue( "g_gpreload", gpreload );
       trap_Cvar_SetValue( "g_lgreload", lgreload );
       trap_Cvar_SetValue( "g_rgreload", rgreload );
       trap_Cvar_SetValue( "g_pgreload", pgreload );
       trap_Cvar_SetValue( "g_bfgreload", bfgreload );
       trap_Cvar_SetValue( "g_ftreload", ftreload );
       trap_Cvar_SetValue( "g_mgrespawn", mgrespawn );
       trap_Cvar_SetValue( "g_sgrespawn", sgrespawn );
       trap_Cvar_SetValue( "g_glrespawn", glrespawn );
       trap_Cvar_SetValue( "g_rlrespawn", rlrespawn );
       trap_Cvar_SetValue( "g_lgrespawn", lgrespawn );
       trap_Cvar_SetValue( "g_rgrespawn", rgrespawn );
       trap_Cvar_SetValue( "g_pgrespawn", pgrespawn );
       trap_Cvar_SetValue( "g_bfgrespawn", bfgrespawn );
       trap_Cvar_SetValue( "g_ftrespawn", ftrespawn );
       trap_Cvar_SetValue( "machinegunammo", mgammo );
       trap_Cvar_SetValue( "shotgunammo", sgammo );
       trap_Cvar_SetValue( "grenadeammo", glammo );
       trap_Cvar_SetValue( "rocketammo", rlammo );
       trap_Cvar_SetValue( "lightningammo", lgammo );
       trap_Cvar_SetValue( "railgunammo", rgammo );
       trap_Cvar_SetValue( "plasmaammo", pgammo );
       trap_Cvar_SetValue( "bfgammo", bfgammo );
       trap_Cvar_SetValue( "ftammo", ftammo );
       trap_Cvar_SetValue( "g_mgammorespawn", mgammorespawn );
       trap_Cvar_SetValue( "g_sgammorespawn", sgammorespawn );
       trap_Cvar_SetValue( "g_glammorespawn", glammorespawn );
       trap_Cvar_SetValue( "g_rlammorespawn", rlammorespawn );
       trap_Cvar_SetValue( "g_lgammorespawn", lgammorespawn );
       trap_Cvar_SetValue( "g_rgammorespawn", rgammorespawn );
       trap_Cvar_SetValue( "g_pgammorespawn", pgammorespawn );
       trap_Cvar_SetValue( "g_bfgammorespawn", bfgammorespawn );
       trap_Cvar_SetValue( "g_ftammorespawn", ftammorespawn );
       trap_Cvar_SetValue( "gtdamage", gtdamage );
       trap_Cvar_SetValue( "mgdamage", mgdamage );
       trap_Cvar_SetValue( "sgdamage", sgdamage );
       trap_Cvar_SetValue( "gldamage", gldamage );
       trap_Cvar_SetValue( "rldamage", rldamage );
       trap_Cvar_SetValue( "lgdamage", lgdamage );
       trap_Cvar_SetValue( "rgdamage", rgdamage );
       trap_Cvar_SetValue( "pgdamage", pgdamage );
       trap_Cvar_SetValue( "bfgdamage", bfgdamage );
       trap_Cvar_SetValue( "ftdamage", ftdamage );
       trap_Cvar_SetValue( "grenadevelocity", grenadevelocity );
       trap_Cvar_SetValue( "grapplevelocity", grapplevelocity );
       trap_Cvar_SetValue( "rocketvelocity", rocketvelocity );
       trap_Cvar_SetValue( "plasmavelocity", plasmavelocity );
       trap_Cvar_SetValue( "bfgvelocity", bfgvelocity );
       trap_Cvar_SetValue( "replaceftwith", s_weaponconfig.weaponimage.curvalue );
             UI_PopMenu();
             break;

	}
}

static void WeaponConfig_ResetDraw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, s_weaponconfig.picture );
	UI_DrawProportionalString( SCREEN_WIDTH/2, 356 + PROP_HEIGHT * 0, "WARNING: This resets all of the", UI_CENTER|UI_SMALLFONT, color_yellow );
       UI_DrawProportionalString( SCREEN_WIDTH/2, 356 + PROP_HEIGHT * 1, "weapons configuration variables.", UI_CENTER|UI_SMALLFONT, color_yellow );
}

/*
=================
WeaponImage_Draw
=================
*/
static void WeaponImage_Draw( void *self ) {
	menulist_s	*s;
	float		*color;
	int			x, y;
	int			style;
	qboolean	focus;

	s = (menulist_s *)self;
	x = s->generic.x;
	y =	s->generic.y;

	style = UI_SMALLFONT;
	focus = (s->generic.parent->cursor == s->generic.menuPosition);

	if ( s->generic.flags & QMF_GRAYED )
		color = text_color_disabled;
	else if ( focus )
	{
		color = text_color_highlight;
		style |= UI_PULSE;
	}
	else if ( s->generic.flags & QMF_BLINK )
	{
		color = text_color_highlight;
		style |= UI_BLINK;
	}
	else
		color = text_color_normal;

	if ( focus )
	{
		// draw cursor
              UI_FillRect( s->generic.left, s->generic.top, s->generic.right-s->generic.left+1, s->generic.bottom-s->generic.top+1, listbar_color ); 
              UI_DrawChar( x+40, y, 13, UI_CENTER|UI_BLINK|UI_SMALLFONT, color);
	}

       UI_DrawString( x - SMALLCHAR_WIDTH, y, s->generic.name, style|UI_RIGHT, color );
       UI_DrawString( x+50, y-BIGCHAR_HEIGHT-2, " Replace Weapon:", UI_CENTER|UI_SMALLFONT, colorWhite );
	if( !s->curvalue ) {
		return;
	}
       if (s_weaponconfig.weaponimage.curvalue == 1)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader );
       if (s_weaponconfig.weaponimage.curvalue == 2)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader2 );
       if (s_weaponconfig.weaponimage.curvalue == 3)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader3 );
       if (s_weaponconfig.weaponimage.curvalue == 4)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader4 );
       if (s_weaponconfig.weaponimage.curvalue == 5)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader5 );
       if (s_weaponconfig.weaponimage.curvalue == 6)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader6 );
       if (s_weaponconfig.weaponimage.curvalue == 7)
              UI_DrawHandlePic( x + SMALLCHAR_WIDTH+40, y + 2, 16, 16, s_weaponconfig.weaponshader7 );
}

static void UI_WEAPONCONFIG_MENU( void );

static void WeaponConfig_ResetAction( qboolean result ) {
	if( !result ) {
		return;
	}

	// clear game variables
       trap_Cvar_SetValue( "g_mgweap", 1);
       trap_Cvar_SetValue( "g_sgweap", 1);
       trap_Cvar_SetValue( "g_glweap", 1);
       trap_Cvar_SetValue( "g_rlweap", 1);
       trap_Cvar_SetValue( "g_lgweap", 1);
       trap_Cvar_SetValue( "g_rgweap", 1);
       trap_Cvar_SetValue( "g_pgweap", 1);
       trap_Cvar_SetValue( "g_bfgweap", 1);
       trap_Cvar_SetValue( "g_mgammo", 1);
       trap_Cvar_SetValue( "g_sgammo", 1);
       trap_Cvar_SetValue( "g_glammo", 1);
       trap_Cvar_SetValue( "g_rlammo", 1);
       trap_Cvar_SetValue( "g_lgammo", 1);
       trap_Cvar_SetValue( "g_rgammo", 1);
       trap_Cvar_SetValue( "g_pgammo", 1);
       trap_Cvar_SetValue( "g_bfgammo", 1);
       trap_Cvar_SetValue( "g_mgreload", 100 );
       trap_Cvar_SetValue( "g_sgreload", 1000 );
       trap_Cvar_SetValue( "g_glreload", 800 );
       trap_Cvar_SetValue( "g_rlreload", 800 );
       trap_Cvar_SetValue( "g_lgreload", 50 );
       trap_Cvar_SetValue( "g_rgreload", 1500 );
       trap_Cvar_SetValue( "g_pgreload", 100 );
       trap_Cvar_SetValue( "g_bfgreload", 200 );
       trap_Cvar_SetValue( "g_ftreload", 40 );
       trap_Cvar_SetValue( "g_mgrespawn", 5 );
       trap_Cvar_SetValue( "g_sgrespawn", 5 );
       trap_Cvar_SetValue( "g_glrespawn", 5 );
       trap_Cvar_SetValue( "g_rlrespawn", 5 );
       trap_Cvar_SetValue( "g_lgrespawn", 5 );
       trap_Cvar_SetValue( "g_rgrespawn", 5 );
       trap_Cvar_SetValue( "g_pgrespawn", 5 );
       trap_Cvar_SetValue( "g_bfgrespawn", 5 );
       trap_Cvar_SetValue( "g_ftrespawn", 5 );
       trap_Cvar_SetValue( "machinegunammo", 50 );
       trap_Cvar_SetValue( "shotgunammo", 10 );
       trap_Cvar_SetValue( "grenadeammo", 6 );
       trap_Cvar_SetValue( "rocketammo", 5 );
       trap_Cvar_SetValue( "lightningammo", 60 );
       trap_Cvar_SetValue( "railgunammo", 10 );
       trap_Cvar_SetValue( "plasmaammo", 30 );
       trap_Cvar_SetValue( "bfgammo", 50 );
       trap_Cvar_SetValue( "ftammo", 80 );
       trap_Cvar_SetValue( "g_mgammorespawn", 40 );
       trap_Cvar_SetValue( "g_sgammorespawn", 40 );
       trap_Cvar_SetValue( "g_glammorespawn", 40 );
       trap_Cvar_SetValue( "g_rlammorespawn", 40 );
       trap_Cvar_SetValue( "g_lgammorespawn", 40 );
       trap_Cvar_SetValue( "g_rgammorespawn", 40 );
       trap_Cvar_SetValue( "g_pgammorespawn", 40 );
       trap_Cvar_SetValue( "g_bfgammorespawn", 40 );
       trap_Cvar_SetValue( "g_ftammorespawn", 40 );
       trap_Cvar_SetValue( "gtdamage", 50 );
       trap_Cvar_SetValue( "mgdamage", 7 );
       trap_Cvar_SetValue( "sgdamage", 10 );
       trap_Cvar_SetValue( "gldamage", 100 );
       trap_Cvar_SetValue( "rldamage", 100 );
       trap_Cvar_SetValue( "lgdamage", 8 );
       trap_Cvar_SetValue( "rgdamage", 100 );
       trap_Cvar_SetValue( "pgdamage", 20 );
       trap_Cvar_SetValue( "bfgdamage", 100 );
       trap_Cvar_SetValue( "ftdamage", 15 );
       trap_Cvar_SetValue( "grenadevelocity", 700 );
       trap_Cvar_SetValue( "rocketvelocity", 900 );
       trap_Cvar_SetValue( "plasmavelocity", 2000 );
       trap_Cvar_SetValue( "bfgvelocity", 2000 );
       trap_Cvar_SetValue( "replaceftwith", 0 );
       trap_Cvar_SetValue( "g_spawnrandomsg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomgl", 0 );
       trap_Cvar_SetValue( "g_spawnrandomrl", 0 );
       trap_Cvar_SetValue( "g_spawnrandomlg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomrg", 0 );
       trap_Cvar_SetValue( "g_spawnrandompg", 0 );
       trap_Cvar_SetValue( "g_spawnrandombfg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomft", 1 );
       trap_Cvar_SetValue( "glsdamage", 100 );
       trap_Cvar_SetValue( "glsradius", 150 );
       trap_Cvar_SetValue( "rlsdamage", 100 );
       trap_Cvar_SetValue( "rlsradius", 120 );
       trap_Cvar_SetValue( "pgsdamage", 15 );
       trap_Cvar_SetValue( "pgsradius", 20 );
       trap_Cvar_SetValue( "bfgsdamage", 100 );
       trap_Cvar_SetValue( "bfgsradius", 120 );

	UI_PopMenu();
       UI_WEAPONCONFIG_MENU();
}

static void WeaponConfig_ResetEvent( void* ptr, int event )
{
	if (event != QM_ACTIVATED) {
		return;
	}
       UI_ConfirmMenu( "RESET WEAPONS?", WeaponConfig_ResetDraw, WeaponConfig_ResetAction );
}

static void WeaponConfig_Draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       UI_DrawString( 88, 94+((BIGCHAR_HEIGHT+2)*2), "Gauntlet  ", UI_CENTER|UI_SMALLFONT, color_orange );
       UI_DrawString( 104, 94+((BIGCHAR_HEIGHT+2)*11), "Grappling Hook", UI_CENTER|UI_SMALLFONT, color_orange );
       UI_DrawString( 88, 94+((BIGCHAR_HEIGHT+2) * 3), "Machinegun", UI_CENTER|UI_SMALLFONT, color_orange );
       UI_DrawString( Hellfire2_X_POS-152, 78, "Toggle", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-152, 93, "Weapon", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-89, 78, "Toggle", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-89, 93, "Ammo", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-34, 78, "Firing", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-34, 93, "Rate", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+16, 78, "Ammo", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+16, 93, "Box", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+90, 78, "Weapon/Ammo", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+90, 93, "Respawn Time", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+170, 78, "Damage", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+235, 78, "Proj.", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+235, 93, "Velocity", UI_CENTER|UI_SMALLFONT, colorWhite );
       Menu_Draw( &s_weaponconfig.menu );

       if( s_weaponconfig.draw ) {
              s_weaponconfig.draw();
	}
}

static void UI_WEAPONCONFIG_MENU( void )
{
	int				y;
       memset( &s_weaponconfig, 0 ,sizeof(weaponconfig_t) );

       Hellfire_Cache();

       s_weaponconfig.menu.draw = WeaponConfig_Draw;
       s_weaponconfig.menu.wrapAround = qtrue;
       s_weaponconfig.menu.fullscreen = qtrue;

       s_weaponconfig.banner.generic.type  = MTYPE_PTEXT;
       s_weaponconfig.banner.generic.x        = 320;
       s_weaponconfig.banner.generic.y        = 32;
       s_weaponconfig.banner.string           = "WEAPONS CONFIG";
       s_weaponconfig.banner.color         = color_orange;
       s_weaponconfig.banner.style         = UI_CENTER;

       s_weaponconfig.frame.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.frame.generic.name  = ART_FRAME;
       s_weaponconfig.frame.generic.flags = QMF_INACTIVE;
       s_weaponconfig.frame.generic.x        = 0;
       s_weaponconfig.frame.generic.y        = 0;
       s_weaponconfig.frame.width            = 640;
       s_weaponconfig.frame.height           = 480;

       y = 94;
       y += BIGCHAR_HEIGHT+2;
       y += BIGCHAR_HEIGHT+2;

       s_weaponconfig.i_gt.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_gt.generic.name  = ART_GT;
       s_weaponconfig.i_gt.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_gt.generic.x        = 9+20;
       s_weaponconfig.i_gt.generic.y        = y;
       s_weaponconfig.i_gt.width            = 16;
       s_weaponconfig.i_gt.height           = 16;

       s_weaponconfig.gtdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.gtdam.generic.name          =      "";
       s_weaponconfig.gtdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.gtdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.gtdam.generic.id          = ID_GTDAMAGE;
       s_weaponconfig.gtdam.field.maxchars             = 4;
       s_weaponconfig.gtdam.field.widthInChars        = 4;
       s_weaponconfig.gtdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.gtdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_mg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_mg.generic.name  = ART_MG;
       s_weaponconfig.i_mg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_mg.generic.x        = 9+20;
       s_weaponconfig.i_mg.generic.y        = y;
       s_weaponconfig.i_mg.width            = 16;
       s_weaponconfig.i_mg.height           = 16;

       s_weaponconfig.mga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.mga.generic.name          =      "";
       s_weaponconfig.mga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.mga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mga.generic.id          = ID_MGAMMO;
       s_weaponconfig.mga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.mga.generic.y                 = y;

       s_weaponconfig.mgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.mgr.generic.name          =      "";
       s_weaponconfig.mgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.mgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mgr.generic.id          = ID_MGRELOAD;
       s_weaponconfig.mgr.field.maxchars             = 4;
       s_weaponconfig.mgr.field.widthInChars        = 4;
       s_weaponconfig.mgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.mgr.generic.y                 = y;

       s_weaponconfig.mgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.mgac.generic.name          =      "";
       s_weaponconfig.mgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.mgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mgac.generic.id          = ID_MGAMMOCOUNT;
       s_weaponconfig.mgac.field.maxchars             = 3;
       s_weaponconfig.mgac.field.widthInChars        = 3;
       s_weaponconfig.mgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.mgac.generic.y                 = y;

       s_weaponconfig.mgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.mgres.generic.name          =      "";
       s_weaponconfig.mgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.mgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mgres.generic.id          = ID_MGRESPAWN;
       s_weaponconfig.mgres.field.maxchars             = 3;
       s_weaponconfig.mgres.field.widthInChars        = 3;
       s_weaponconfig.mgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.mgres.generic.y                 = y;

       s_weaponconfig.mgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.mgresa.generic.name          =      "";
       s_weaponconfig.mgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.mgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mgresa.generic.id          = ID_MGAMMORESPAWN;
       s_weaponconfig.mgresa.field.maxchars             = 3;
       s_weaponconfig.mgresa.field.widthInChars        = 3;
       s_weaponconfig.mgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.mgresa.generic.y                 = y;

       s_weaponconfig.mgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.mgdam.generic.name          =      "";
       s_weaponconfig.mgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.mgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.mgdam.generic.id          = ID_MGDAMAGE;
       s_weaponconfig.mgdam.field.maxchars             = 4;
       s_weaponconfig.mgdam.field.widthInChars        = 4;
       s_weaponconfig.mgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.mgdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_sg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_sg.generic.name  = ART_SG;
       s_weaponconfig.i_sg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_sg.generic.x        = 9+20;
       s_weaponconfig.i_sg.generic.y        = y;
       s_weaponconfig.i_sg.width            = 16;
       s_weaponconfig.i_sg.height           = 16;

       s_weaponconfig.sg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.sg.generic.name          =   "Shotgun         ";
       s_weaponconfig.sg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.sg.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sg.generic.id          = ID_SGWEAP;
       s_weaponconfig.sg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.sg.generic.y                 = y;

       s_weaponconfig.sga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.sga.generic.name          =      "";
       s_weaponconfig.sga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.sga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sga.generic.id          = ID_SGAMMO;
       s_weaponconfig.sga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.sga.generic.y                 = y;

       s_weaponconfig.sgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.sgr.generic.name          =      "";
       s_weaponconfig.sgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.sgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sgr.generic.id          = ID_SGRELOAD;
       s_weaponconfig.sgr.field.maxchars             = 4;
       s_weaponconfig.sgr.field.widthInChars        = 4;
       s_weaponconfig.sgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.sgr.generic.y                 = y;

       s_weaponconfig.sgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.sgac.generic.name          =      "";
       s_weaponconfig.sgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.sgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sgac.generic.id          = ID_SGAMMOCOUNT;
       s_weaponconfig.sgac.field.maxchars             = 3;
       s_weaponconfig.sgac.field.widthInChars        = 3;
       s_weaponconfig.sgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.sgac.generic.y                 = y;

       s_weaponconfig.sgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.sgres.generic.name          =      "";
       s_weaponconfig.sgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.sgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sgres.generic.id          = ID_SGRESPAWN;
       s_weaponconfig.sgres.field.maxchars             = 3;
       s_weaponconfig.sgres.field.widthInChars        = 3;
       s_weaponconfig.sgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.sgres.generic.y                 = y;

       s_weaponconfig.sgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.sgresa.generic.name          =      "";
       s_weaponconfig.sgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.sgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sgresa.generic.id          = ID_SGAMMORESPAWN;
       s_weaponconfig.sgresa.field.maxchars             = 3;
       s_weaponconfig.sgresa.field.widthInChars        = 3;
       s_weaponconfig.sgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.sgresa.generic.y                 = y;

       s_weaponconfig.sgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.sgdam.generic.name          =      "";
       s_weaponconfig.sgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.sgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.sgdam.generic.id          = ID_SGDAMAGE;
       s_weaponconfig.sgdam.field.maxchars             = 4;
       s_weaponconfig.sgdam.field.widthInChars        = 4;
       s_weaponconfig.sgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.sgdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_gl.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_gl.generic.name  = ART_GL;
       s_weaponconfig.i_gl.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_gl.generic.x        = 9+20;
       s_weaponconfig.i_gl.generic.y        = y;
       s_weaponconfig.i_gl.width            = 16;
       s_weaponconfig.i_gl.height           = 16;

       s_weaponconfig.gl.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.gl.generic.name         =    "Grenade Launcher";
       s_weaponconfig.gl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.gl.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.gl.generic.id          = ID_GLWEAP;
       s_weaponconfig.gl.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.gl.generic.y                 = y;

       s_weaponconfig.gla.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.gla.generic.name          =      "";
       s_weaponconfig.gla.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.gla.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.gla.generic.id          = ID_GLAMMO;
       s_weaponconfig.gla.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.gla.generic.y                 = y;

       s_weaponconfig.glr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.glr.generic.name          =      "";
       s_weaponconfig.glr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.glr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.glr.generic.id          = ID_GLRELOAD;
       s_weaponconfig.glr.field.maxchars             = 4;
       s_weaponconfig.glr.field.widthInChars        = 4;
       s_weaponconfig.glr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.glr.generic.y                 = y;

       s_weaponconfig.glac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.glac.generic.name          =      "";
       s_weaponconfig.glac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.glac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.glac.generic.id          = ID_GLAMMOCOUNT;
       s_weaponconfig.glac.field.maxchars             = 3;
       s_weaponconfig.glac.field.widthInChars        = 3;
       s_weaponconfig.glac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.glac.generic.y                 = y;

       s_weaponconfig.glres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.glres.generic.name          =      "";
       s_weaponconfig.glres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.glres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.glres.generic.id          = ID_GLRESPAWN;
       s_weaponconfig.glres.field.maxchars             = 3;
       s_weaponconfig.glres.field.widthInChars        = 3;
       s_weaponconfig.glres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.glres.generic.y                 = y;

       s_weaponconfig.glresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.glresa.generic.name          =      "";
       s_weaponconfig.glresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.glresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.glresa.generic.id          = ID_GLAMMORESPAWN;
       s_weaponconfig.glresa.field.maxchars             = 3;
       s_weaponconfig.glresa.field.widthInChars        = 3;
       s_weaponconfig.glresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.glresa.generic.y                 = y;

       s_weaponconfig.gldam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.gldam.generic.name          =      "";
       s_weaponconfig.gldam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.gldam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.gldam.generic.id          = ID_GLDAMAGE;
       s_weaponconfig.gldam.field.maxchars             = 4;
       s_weaponconfig.gldam.field.widthInChars        = 4;
       s_weaponconfig.gldam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.gldam.generic.y                 = y;

       s_weaponconfig.grenadevelocity.generic.type        = MTYPE_FIELD;
       s_weaponconfig.grenadevelocity.generic.name          =      "";
       s_weaponconfig.grenadevelocity.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.grenadevelocity.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.grenadevelocity.generic.id          = ID_GRENADEVELOCITY;
       s_weaponconfig.grenadevelocity.field.maxchars             = 4;
       s_weaponconfig.grenadevelocity.field.widthInChars        = 4;
       s_weaponconfig.grenadevelocity.generic.x                 = Hellfire_X_POS+180;
       s_weaponconfig.grenadevelocity.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_rl.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_rl.generic.name  = ART_RL;
       s_weaponconfig.i_rl.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_rl.generic.x        = 9+20;
       s_weaponconfig.i_rl.generic.y        = y;
       s_weaponconfig.i_rl.width            = 16;
       s_weaponconfig.i_rl.height           = 16;

       s_weaponconfig.rl.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.rl.generic.name         =    "Rocket Launcher ";
       s_weaponconfig.rl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.rl.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rl.generic.id          = ID_RLWEAP;
       s_weaponconfig.rl.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.rl.generic.y                 = y;

       s_weaponconfig.rla.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.rla.generic.name          =      "";
       s_weaponconfig.rla.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.rla.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rla.generic.id          = ID_RLAMMO;
       s_weaponconfig.rla.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.rla.generic.y                 = y;

       s_weaponconfig.rlr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rlr.generic.name          =      "";
       s_weaponconfig.rlr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rlr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rlr.generic.id          = ID_RLRELOAD;
       s_weaponconfig.rlr.field.maxchars             = 4;
       s_weaponconfig.rlr.field.widthInChars        = 4;
       s_weaponconfig.rlr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.rlr.generic.y                 = y;

       s_weaponconfig.rlac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rlac.generic.name          =      "";
       s_weaponconfig.rlac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rlac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rlac.generic.id          = ID_RLAMMOCOUNT;
       s_weaponconfig.rlac.field.maxchars             = 3;
       s_weaponconfig.rlac.field.widthInChars        = 3;
       s_weaponconfig.rlac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.rlac.generic.y                 = y;

       s_weaponconfig.rlres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rlres.generic.name          =      "";
       s_weaponconfig.rlres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rlres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rlres.generic.id          = ID_RLRESPAWN;
       s_weaponconfig.rlres.field.maxchars             = 3;
       s_weaponconfig.rlres.field.widthInChars        = 3;
       s_weaponconfig.rlres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.rlres.generic.y                 = y;

       s_weaponconfig.rlresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rlresa.generic.name          =      "";
       s_weaponconfig.rlresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rlresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rlresa.generic.id          = ID_RLAMMORESPAWN;
       s_weaponconfig.rlresa.field.maxchars             = 3;
       s_weaponconfig.rlresa.field.widthInChars        = 3;
       s_weaponconfig.rlresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.rlresa.generic.y                 = y;

       s_weaponconfig.rldam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rldam.generic.name          =      "";
       s_weaponconfig.rldam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rldam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rldam.generic.id          = ID_RLDAMAGE;
       s_weaponconfig.rldam.field.maxchars             = 4;
       s_weaponconfig.rldam.field.widthInChars        = 4;
       s_weaponconfig.rldam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.rldam.generic.y                 = y;

       s_weaponconfig.rocketvelocity.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rocketvelocity.generic.name          =      "";
       s_weaponconfig.rocketvelocity.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rocketvelocity.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rocketvelocity.generic.id          = ID_ROCKETVELOCITY;
       s_weaponconfig.rocketvelocity.field.maxchars             = 4;
       s_weaponconfig.rocketvelocity.field.widthInChars        = 4;
       s_weaponconfig.rocketvelocity.generic.x                 = Hellfire_X_POS+180;
       s_weaponconfig.rocketvelocity.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_lg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_lg.generic.name  = ART_LG;
       s_weaponconfig.i_lg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_lg.generic.x        = 9+20;
       s_weaponconfig.i_lg.generic.y        = y;
       s_weaponconfig.i_lg.width            = 16;
       s_weaponconfig.i_lg.height           = 16;

       s_weaponconfig.lg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.lg.generic.name    =         "Lightning Gun   ";
       s_weaponconfig.lg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.lg.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lg.generic.id          = ID_LGWEAP;
       s_weaponconfig.lg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.lg.generic.y                 = y;

       s_weaponconfig.lga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.lga.generic.name          =      "";
       s_weaponconfig.lga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.lga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lga.generic.id          = ID_LGAMMO;
       s_weaponconfig.lga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.lga.generic.y                 = y;

       s_weaponconfig.lgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.lgr.generic.name          =      "";
       s_weaponconfig.lgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.lgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lgr.generic.id          = ID_LGRELOAD;
       s_weaponconfig.lgr.field.maxchars             = 4;
       s_weaponconfig.lgr.field.widthInChars        = 4;
       s_weaponconfig.lgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.lgr.generic.y                 = y;

       s_weaponconfig.lgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.lgac.generic.name          =      "";
       s_weaponconfig.lgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.lgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lgac.generic.id          = ID_LGAMMOCOUNT;
       s_weaponconfig.lgac.field.maxchars             = 3;
       s_weaponconfig.lgac.field.widthInChars        = 3;
       s_weaponconfig.lgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.lgac.generic.y                 = y;

       s_weaponconfig.lgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.lgres.generic.name          =      "";
       s_weaponconfig.lgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.lgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lgres.generic.id          = ID_LGRESPAWN;
       s_weaponconfig.lgres.field.maxchars             = 3;
       s_weaponconfig.lgres.field.widthInChars        = 3;
       s_weaponconfig.lgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.lgres.generic.y                 = y;

       s_weaponconfig.lgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.lgresa.generic.name          =      "";
       s_weaponconfig.lgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.lgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lgresa.generic.id          = ID_LGAMMORESPAWN;
       s_weaponconfig.lgresa.field.maxchars             = 3;
       s_weaponconfig.lgresa.field.widthInChars        = 3;
       s_weaponconfig.lgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.lgresa.generic.y                 = y;

       s_weaponconfig.lgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.lgdam.generic.name          =      "";
       s_weaponconfig.lgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.lgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.lgdam.generic.id          = ID_LGDAMAGE;
       s_weaponconfig.lgdam.field.maxchars             = 4;
       s_weaponconfig.lgdam.field.widthInChars        = 4;
       s_weaponconfig.lgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.lgdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_rg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_rg.generic.name  = ART_RG;
       s_weaponconfig.i_rg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_rg.generic.x        = 9+20;
       s_weaponconfig.i_rg.generic.y        = y;
       s_weaponconfig.i_rg.width            = 16;
       s_weaponconfig.i_rg.height           = 16;

       s_weaponconfig.rg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.rg.generic.name    =         "Railgun         ";
       s_weaponconfig.rg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.rg.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rg.generic.id          = ID_RGWEAP;
       s_weaponconfig.rg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.rg.generic.y                 = y;

       s_weaponconfig.rga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.rga.generic.name          =      "";
       s_weaponconfig.rga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.rga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rga.generic.id          = ID_RGAMMO;
       s_weaponconfig.rga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.rga.generic.y                 = y;

       s_weaponconfig.rgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rgr.generic.name          =      "";
       s_weaponconfig.rgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rgr.generic.id          = ID_RGRELOAD;
       s_weaponconfig.rgr.field.maxchars             = 4;
       s_weaponconfig.rgr.field.widthInChars        = 4;
       s_weaponconfig.rgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.rgr.generic.y                 = y;

       s_weaponconfig.rgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rgac.generic.name          =      "";
       s_weaponconfig.rgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rgac.generic.id          = ID_RGAMMOCOUNT;
       s_weaponconfig.rgac.field.maxchars             = 3;
       s_weaponconfig.rgac.field.widthInChars        = 3;
       s_weaponconfig.rgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.rgac.generic.y                 = y;

       s_weaponconfig.rgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rgres.generic.name          =      "";
       s_weaponconfig.rgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rgres.generic.id          = ID_RGRESPAWN;
       s_weaponconfig.rgres.field.maxchars             = 3;
       s_weaponconfig.rgres.field.widthInChars        = 3;
       s_weaponconfig.rgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.rgres.generic.y                 = y;

       s_weaponconfig.rgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rgresa.generic.name          =      "";
       s_weaponconfig.rgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rgresa.generic.id          = ID_RGAMMORESPAWN;
       s_weaponconfig.rgresa.field.maxchars             = 3;
       s_weaponconfig.rgresa.field.widthInChars        = 3;
       s_weaponconfig.rgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.rgresa.generic.y                 = y;

       s_weaponconfig.rgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.rgdam.generic.name          =      "";
       s_weaponconfig.rgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.rgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.rgdam.generic.id          = ID_RGDAMAGE;
       s_weaponconfig.rgdam.field.maxchars             = 4;
       s_weaponconfig.rgdam.field.widthInChars        = 4;
       s_weaponconfig.rgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.rgdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_pg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_pg.generic.name  = ART_PG;
       s_weaponconfig.i_pg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_pg.generic.x        = 9+20;
       s_weaponconfig.i_pg.generic.y        = y;
       s_weaponconfig.i_pg.width            = 16;
       s_weaponconfig.i_pg.height           = 16;

       s_weaponconfig.pg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.pg.generic.name    =         "Plasma Gun      ";
       s_weaponconfig.pg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.pg.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pg.generic.id          = ID_PGWEAP;
       s_weaponconfig.pg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.pg.generic.y                 = y;

       s_weaponconfig.pga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.pga.generic.name          =      "";
       s_weaponconfig.pga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.pga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pga.generic.id          = ID_PGAMMO;
       s_weaponconfig.pga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.pga.generic.y                 = y;

       s_weaponconfig.pgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.pgr.generic.name          =      "";
       s_weaponconfig.pgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.pgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pgr.generic.id          = ID_PGRELOAD;
       s_weaponconfig.pgr.field.maxchars             = 4;
       s_weaponconfig.pgr.field.widthInChars        = 4;
       s_weaponconfig.pgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.pgr.generic.y                 = y;

       s_weaponconfig.pgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.pgac.generic.name          =      "";
       s_weaponconfig.pgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.pgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pgac.generic.id          = ID_PGAMMOCOUNT;
       s_weaponconfig.pgac.field.maxchars             = 3;
       s_weaponconfig.pgac.field.widthInChars        = 3;
       s_weaponconfig.pgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.pgac.generic.y                 = y;

       s_weaponconfig.pgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.pgres.generic.name          =      "";
       s_weaponconfig.pgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.pgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pgres.generic.id          = ID_PGRESPAWN;
       s_weaponconfig.pgres.field.maxchars             = 3;
       s_weaponconfig.pgres.field.widthInChars        = 3;
       s_weaponconfig.pgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.pgres.generic.y                 = y;

       s_weaponconfig.pgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.pgresa.generic.name          =      "";
       s_weaponconfig.pgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.pgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pgresa.generic.id          = ID_PGAMMORESPAWN;
       s_weaponconfig.pgresa.field.maxchars             = 3;
       s_weaponconfig.pgresa.field.widthInChars        = 3;
       s_weaponconfig.pgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.pgresa.generic.y                 = y;

       s_weaponconfig.pgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.pgdam.generic.name          =      "";
       s_weaponconfig.pgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.pgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.pgdam.generic.id          = ID_PGDAMAGE;
       s_weaponconfig.pgdam.field.maxchars             = 4;
       s_weaponconfig.pgdam.field.widthInChars        = 4;
       s_weaponconfig.pgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.pgdam.generic.y                 = y;

       s_weaponconfig.plasmavelocity.generic.type        = MTYPE_FIELD;
       s_weaponconfig.plasmavelocity.generic.name          =      "";
       s_weaponconfig.plasmavelocity.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.plasmavelocity.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.plasmavelocity.generic.id          = ID_PLASMAVELOCITY;
       s_weaponconfig.plasmavelocity.field.maxchars             = 4;
       s_weaponconfig.plasmavelocity.field.widthInChars        = 4;
       s_weaponconfig.plasmavelocity.generic.x                 = Hellfire_X_POS+180;
       s_weaponconfig.plasmavelocity.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_bfg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_bfg.generic.name  = ART_BFG;
       s_weaponconfig.i_bfg.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_bfg.generic.x        = 9+20;
       s_weaponconfig.i_bfg.generic.y        = y;
       s_weaponconfig.i_bfg.width            = 16;
       s_weaponconfig.i_bfg.height           = 16;

       s_weaponconfig.bfg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.bfg.generic.name           = "BFG10k          ";
       s_weaponconfig.bfg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.bfg.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfg.generic.id          = ID_BFGWEAP;
       s_weaponconfig.bfg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig.bfg.generic.y                 = y;

       s_weaponconfig.bfga.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig.bfga.generic.name          =      "";
       s_weaponconfig.bfga.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig.bfga.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfga.generic.id          = ID_BFGAMMO;
       s_weaponconfig.bfga.generic.x                 = Hellfire_X_POS-144;
       s_weaponconfig.bfga.generic.y                 = y;

       s_weaponconfig.bfgr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgr.generic.name          = "";
       s_weaponconfig.bfgr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgr.generic.id          = ID_BFGRELOAD;
       s_weaponconfig.bfgr.field.maxchars             = 4;
       s_weaponconfig.bfgr.field.widthInChars        = 4;
       s_weaponconfig.bfgr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.bfgr.generic.y                 = y;

       s_weaponconfig.bfgac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgac.generic.name          =      "";
       s_weaponconfig.bfgac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgac.generic.id          = ID_BFGAMMOCOUNT;
       s_weaponconfig.bfgac.field.maxchars             = 3;
       s_weaponconfig.bfgac.field.widthInChars        = 3;
       s_weaponconfig.bfgac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.bfgac.generic.y                 = y;

       s_weaponconfig.bfgres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgres.generic.name          =      "";
       s_weaponconfig.bfgres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgres.generic.id          = ID_BFGRESPAWN;
       s_weaponconfig.bfgres.field.maxchars             = 3;
       s_weaponconfig.bfgres.field.widthInChars        = 3;
       s_weaponconfig.bfgres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.bfgres.generic.y                 = y;

       s_weaponconfig.bfgresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgresa.generic.name          =      "";
       s_weaponconfig.bfgresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgresa.generic.id          = ID_BFGAMMORESPAWN;
       s_weaponconfig.bfgresa.field.maxchars             = 3;
       s_weaponconfig.bfgresa.field.widthInChars        = 3;
       s_weaponconfig.bfgresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.bfgresa.generic.y                 = y;

       s_weaponconfig.bfgdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgdam.generic.name          =      "";
       s_weaponconfig.bfgdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgdam.generic.id          = ID_BFGDAMAGE;
       s_weaponconfig.bfgdam.field.maxchars             = 4;
       s_weaponconfig.bfgdam.field.widthInChars        = 4;
       s_weaponconfig.bfgdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.bfgdam.generic.y                 = y;

       s_weaponconfig.bfgvelocity.generic.type        = MTYPE_FIELD;
       s_weaponconfig.bfgvelocity.generic.name          =      "";
       s_weaponconfig.bfgvelocity.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.bfgvelocity.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.bfgvelocity.generic.id          = ID_BFGVELOCITY;
       s_weaponconfig.bfgvelocity.field.maxchars             = 4;
       s_weaponconfig.bfgvelocity.field.widthInChars        = 4;
       s_weaponconfig.bfgvelocity.generic.x                 = Hellfire_X_POS+180;
       s_weaponconfig.bfgvelocity.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig.i_gp.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_gp.generic.name  = ART_GP;
       s_weaponconfig.i_gp.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_gp.generic.x        = 9+20;
       s_weaponconfig.i_gp.generic.y        = y;
       s_weaponconfig.i_gp.width            = 16;
       s_weaponconfig.i_gp.height           = 16;

       s_weaponconfig.gpr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.gpr.generic.name          =      "";
       s_weaponconfig.gpr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.gpr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.gpr.generic.id          = ID_GPRELOAD;
       s_weaponconfig.gpr.field.maxchars             = 4;
       s_weaponconfig.gpr.field.widthInChars        = 4;
       s_weaponconfig.gpr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.gpr.generic.y                 = y;

       s_weaponconfig.grapplevelocity.generic.type        = MTYPE_FIELD;
       s_weaponconfig.grapplevelocity.generic.name          =      "";
       s_weaponconfig.grapplevelocity.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.grapplevelocity.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.grapplevelocity.generic.id          = ID_GRAPPLEVELOCITY;
       s_weaponconfig.grapplevelocity.field.maxchars             = 4;
       s_weaponconfig.grapplevelocity.field.widthInChars        = 4;
       s_weaponconfig.grapplevelocity.generic.x                 = Hellfire_X_POS+180;
       s_weaponconfig.grapplevelocity.generic.y                 = y;

       y += (BIGCHAR_HEIGHT+2)*2;
       s_weaponconfig.i_ft.generic.type  = MTYPE_BITMAP;
       s_weaponconfig.i_ft.generic.name  = ART_FT;
       s_weaponconfig.i_ft.generic.flags = QMF_INACTIVE;
       s_weaponconfig.i_ft.generic.x        = 9+20;
       s_weaponconfig.i_ft.generic.y        = y;
       s_weaponconfig.i_ft.width            = 16;
       s_weaponconfig.i_ft.height           = 16;

       s_weaponconfig.weaponimage.generic.type             = MTYPE_TEXT;
       s_weaponconfig.weaponimage.generic.flags            = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_NODEFAULTINIT|QMF_OWNERDRAW;
       s_weaponconfig.weaponimage.generic.x                = Hellfire_X_POS-206;
       s_weaponconfig.weaponimage.generic.y                = y;
       s_weaponconfig.weaponimage.generic.name             = "Flame Thrower   ";
       s_weaponconfig.weaponimage.generic.callback  = Weaponconfig_Event;
       s_weaponconfig.weaponimage.generic.ownerdraw = WeaponImage_Draw;
       s_weaponconfig.weaponimage.generic.id               = ID_WEAPONIMAGE;
       s_weaponconfig.weaponimage.generic.top                     = y+1;
       s_weaponconfig.weaponimage.generic.bottom           = y + 18;
       s_weaponconfig.weaponimage.generic.left             = Hellfire_X_POS - (205) - ( ( strlen(s_weaponconfig.weaponimage.generic.name) + 1 ) * SMALLCHAR_WIDTH );
       s_weaponconfig.weaponimage.generic.right            = Hellfire_X_POS-135;

       s_weaponconfig.ftr.generic.type        = MTYPE_FIELD;
       s_weaponconfig.ftr.generic.name          = "";
       s_weaponconfig.ftr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.ftr.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.ftr.generic.id          = ID_FTRELOAD;
       s_weaponconfig.ftr.field.maxchars             = 4;
       s_weaponconfig.ftr.field.widthInChars        = 4;
       s_weaponconfig.ftr.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig.ftr.generic.y                 = y;

       s_weaponconfig.ftac.generic.type        = MTYPE_FIELD;
       s_weaponconfig.ftac.generic.name          =      "";
       s_weaponconfig.ftac.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.ftac.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.ftac.generic.id          = ID_FTAMMOCOUNT;
       s_weaponconfig.ftac.field.maxchars             = 3;
       s_weaponconfig.ftac.field.widthInChars        = 3;
       s_weaponconfig.ftac.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig.ftac.generic.y                 = y;

       s_weaponconfig.ftres.generic.type        = MTYPE_FIELD;
       s_weaponconfig.ftres.generic.name          =      "";
       s_weaponconfig.ftres.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.ftres.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.ftres.generic.id          = ID_FTRESPAWN;
       s_weaponconfig.ftres.field.maxchars             = 3;
       s_weaponconfig.ftres.field.widthInChars        = 3;
       s_weaponconfig.ftres.generic.x                 = Hellfire_X_POS+20;
       s_weaponconfig.ftres.generic.y                 = y;

       s_weaponconfig.ftresa.generic.type        = MTYPE_FIELD;
       s_weaponconfig.ftresa.generic.name          =      "";
       s_weaponconfig.ftresa.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.ftresa.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.ftresa.generic.id          = ID_FTAMMORESPAWN;
       s_weaponconfig.ftresa.field.maxchars             = 3;
       s_weaponconfig.ftresa.field.widthInChars        = 3;
       s_weaponconfig.ftresa.generic.x                 = Hellfire_X_POS+70;
       s_weaponconfig.ftresa.generic.y                 = y;

       s_weaponconfig.ftdam.generic.type        = MTYPE_FIELD;
       s_weaponconfig.ftdam.generic.name          =      "";
       s_weaponconfig.ftdam.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig.ftdam.generic.callback    = Weaponconfig_Event;
       s_weaponconfig.ftdam.generic.id          = ID_FTDAMAGE;
       s_weaponconfig.ftdam.field.maxchars             = 4;
       s_weaponconfig.ftdam.field.widthInChars        = 4;
       s_weaponconfig.ftdam.generic.x                 = Hellfire_X_POS+120;
       s_weaponconfig.ftdam.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2+10;
       s_weaponconfig.moreoptions.generic.type     = MTYPE_PTEXT;
       s_weaponconfig.moreoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.moreoptions.generic.callback = Weaponconfig_Event;
       s_weaponconfig.moreoptions.generic.id       = ID_MOREOPTIONS;
       s_weaponconfig.moreoptions.generic.x        = 320;
       s_weaponconfig.moreoptions.generic.y        = y;
       s_weaponconfig.moreoptions.string           = "More Options";
       s_weaponconfig.moreoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_weaponconfig.moreoptions.color            = color_red;

       s_weaponconfig.back.generic.type        = MTYPE_BITMAP;
       s_weaponconfig.back.generic.name     = ART_BACK0;
       s_weaponconfig.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.back.generic.callback = Weaponconfig_Event;
       s_weaponconfig.back.generic.id          = ID_WEAPONCONFIGBACK;
       s_weaponconfig.back.generic.x           = 0;
       s_weaponconfig.back.generic.y           = 475-64;
       s_weaponconfig.back.width               = 128;
       s_weaponconfig.back.height              = 64;
       s_weaponconfig.back.focuspic         = ART_BACK1;
       s_weaponconfig.back.generic.statusbar            = Hellfire_StatusBar4;

       s_weaponconfig.load.generic.type        = MTYPE_BITMAP;
       s_weaponconfig.load.generic.name     = ART_LOAD0;
       s_weaponconfig.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.load.generic.callback = Weaponconfig_Event;
       s_weaponconfig.load.generic.id          = ID_LOAD;
       s_weaponconfig.load.generic.x           = 128;
       s_weaponconfig.load.generic.y           = 475-64;
       s_weaponconfig.load.width               = 128;
       s_weaponconfig.load.height              = 64;
       s_weaponconfig.load.focuspic         = ART_LOAD1;
       s_weaponconfig.load.generic.statusbar            = Hellfire_StatusBar7;

       s_weaponconfig.item_reset.generic.type                   = MTYPE_BITMAP;
       s_weaponconfig.item_reset.generic.name                   = ART_RESET0;
       s_weaponconfig.item_reset.generic.flags                  = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.item_reset.generic.x                      = 320-128/2;
       s_weaponconfig.item_reset.generic.y                      = 475-64;
       s_weaponconfig.item_reset.generic.callback        = WeaponConfig_ResetEvent;
       s_weaponconfig.item_reset.generic.id                            = ID_RESET;
       s_weaponconfig.item_reset.width                                 = 128;
       s_weaponconfig.item_reset.height                                = 64;
       s_weaponconfig.item_reset.focuspic                       = ART_RESET1;
       s_weaponconfig.item_reset.generic.statusbar            = Hellfire_StatusBar6;

       s_weaponconfig.save.generic.type        = MTYPE_BITMAP;
       s_weaponconfig.save.generic.name     = ART_SAVE0;
       s_weaponconfig.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.save.generic.callback = Weaponconfig_Event;
       s_weaponconfig.save.generic.id          = ID_SAVE;
       s_weaponconfig.save.generic.x           = 384;
       s_weaponconfig.save.generic.y           = 475-64;
       s_weaponconfig.save.width               = 128;
       s_weaponconfig.save.height              = 64;
       s_weaponconfig.save.focuspic         = ART_SAVE1;
       s_weaponconfig.save.generic.statusbar            = Hellfire_StatusBar8;

       s_weaponconfig.accept.generic.type        = MTYPE_BITMAP;
       s_weaponconfig.accept.generic.name     = ART_ACCEPT0;
       s_weaponconfig.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig.accept.generic.callback = Weaponconfig_Event;
       s_weaponconfig.accept.generic.id          = ID_ACCEPT;
       s_weaponconfig.accept.generic.x           = 512;
       s_weaponconfig.accept.generic.y           = 475-64;
       s_weaponconfig.accept.width               = 128;
       s_weaponconfig.accept.height              = 64;
       s_weaponconfig.accept.focuspic         = ART_ACCEPT1;
       s_weaponconfig.accept.generic.statusbar            = Hellfire_StatusBar5;

       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.banner );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.frame );

       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.gtdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.mgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.sgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.gl );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.gla );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.glr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.glac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.glres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.glresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.gldam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.grenadevelocity );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rl );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rla );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rlr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rlac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rlres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rlresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rldam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rocketvelocity );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.lgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.rgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.pgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.plasmavelocity );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfga );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.gpr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.grapplevelocity );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.bfgvelocity );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.weaponimage );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.ftr );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.ftac );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.ftres );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.ftresa );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.ftdam );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.moreoptions );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.back );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.load );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.item_reset );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.save );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.accept );

       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_gt );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_mg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_sg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_gl );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_rl );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_lg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_rg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_pg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_bfg );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_gp );
       Menu_AddItem( &s_weaponconfig.menu, &s_weaponconfig.i_ft );
       s_weaponconfig.mg.curvalue = trap_Cvar_VariableValue( "g_mgweap" ) != 0;
       s_weaponconfig.sg.curvalue = trap_Cvar_VariableValue( "g_sgweap" ) != 0;
       s_weaponconfig.gl.curvalue = trap_Cvar_VariableValue( "g_glweap" ) != 0;
       s_weaponconfig.rl.curvalue = trap_Cvar_VariableValue( "g_rlweap" ) != 0;
       s_weaponconfig.lg.curvalue = trap_Cvar_VariableValue( "g_lgweap" ) != 0;
       s_weaponconfig.rg.curvalue = trap_Cvar_VariableValue( "g_rgweap" ) != 0;
       s_weaponconfig.pg.curvalue = trap_Cvar_VariableValue( "g_pgweap" ) != 0;
       s_weaponconfig.bfg.curvalue = trap_Cvar_VariableValue( "g_bfgweap" ) != 0;
       s_weaponconfig.mga.curvalue = trap_Cvar_VariableValue( "g_mgammo" ) != 0;
       s_weaponconfig.sga.curvalue = trap_Cvar_VariableValue( "g_sgammo" ) != 0;
       s_weaponconfig.gla.curvalue = trap_Cvar_VariableValue( "g_glammo" ) != 0;
       s_weaponconfig.rla.curvalue = trap_Cvar_VariableValue( "g_rlammo" ) != 0;
       s_weaponconfig.lga.curvalue = trap_Cvar_VariableValue( "g_lgammo" ) != 0;
       s_weaponconfig.rga.curvalue = trap_Cvar_VariableValue( "g_rgammo" ) != 0;
       s_weaponconfig.pga.curvalue = trap_Cvar_VariableValue( "g_pgammo" ) != 0;
       s_weaponconfig.bfga.curvalue = trap_Cvar_VariableValue( "g_bfgammo" ) != 0;
       Q_strncpyz( s_weaponconfig.mgr.field.buffer, UI_Cvar_VariableString("g_mgreload"), sizeof(s_weaponconfig.mgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.sgr.field.buffer, UI_Cvar_VariableString("g_sgreload"), sizeof(s_weaponconfig.sgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.glr.field.buffer, UI_Cvar_VariableString("g_glreload"), sizeof(s_weaponconfig.glr.field.buffer) );
       Q_strncpyz( s_weaponconfig.gpr.field.buffer, UI_Cvar_VariableString("g_gpreload"), sizeof(s_weaponconfig.gpr.field.buffer) );
       Q_strncpyz( s_weaponconfig.rlr.field.buffer, UI_Cvar_VariableString("g_rlreload"), sizeof(s_weaponconfig.rlr.field.buffer) );
       Q_strncpyz( s_weaponconfig.lgr.field.buffer, UI_Cvar_VariableString("g_lgreload"), sizeof(s_weaponconfig.lgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.rgr.field.buffer, UI_Cvar_VariableString("g_rgreload"), sizeof(s_weaponconfig.rgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.pgr.field.buffer, UI_Cvar_VariableString("g_pgreload"), sizeof(s_weaponconfig.pgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgr.field.buffer, UI_Cvar_VariableString("g_bfgreload"), sizeof(s_weaponconfig.bfgr.field.buffer) );
       Q_strncpyz( s_weaponconfig.ftr.field.buffer, UI_Cvar_VariableString("g_ftreload"), sizeof(s_weaponconfig.ftr.field.buffer) );
       Q_strncpyz( s_weaponconfig.mgac.field.buffer, UI_Cvar_VariableString("machinegunammo"), sizeof(s_weaponconfig.mgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.sgac.field.buffer, UI_Cvar_VariableString("shotgunammo"), sizeof(s_weaponconfig.sgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.glac.field.buffer, UI_Cvar_VariableString("grenadeammo"), sizeof(s_weaponconfig.glac.field.buffer) );
       Q_strncpyz( s_weaponconfig.rlac.field.buffer, UI_Cvar_VariableString("rocketammo"), sizeof(s_weaponconfig.rlac.field.buffer) );
       Q_strncpyz( s_weaponconfig.lgac.field.buffer, UI_Cvar_VariableString("lightningammo"), sizeof(s_weaponconfig.lgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.rgac.field.buffer, UI_Cvar_VariableString("railgunammo"), sizeof(s_weaponconfig.rgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.pgac.field.buffer, UI_Cvar_VariableString("plasmaammo"), sizeof(s_weaponconfig.pgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgac.field.buffer, UI_Cvar_VariableString("bfgammo"), sizeof(s_weaponconfig.bfgac.field.buffer) );
       Q_strncpyz( s_weaponconfig.ftac.field.buffer, UI_Cvar_VariableString("ftammo"), sizeof(s_weaponconfig.ftac.field.buffer) );
       Q_strncpyz( s_weaponconfig.mgres.field.buffer, UI_Cvar_VariableString("g_mgrespawn"), sizeof(s_weaponconfig.mgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.sgres.field.buffer, UI_Cvar_VariableString("g_sgrespawn"), sizeof(s_weaponconfig.sgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.glres.field.buffer, UI_Cvar_VariableString("g_glrespawn"), sizeof(s_weaponconfig.glres.field.buffer) );
       Q_strncpyz( s_weaponconfig.rlres.field.buffer, UI_Cvar_VariableString("g_rlrespawn"), sizeof(s_weaponconfig.rlres.field.buffer) );
       Q_strncpyz( s_weaponconfig.lgres.field.buffer, UI_Cvar_VariableString("g_lgrespawn"), sizeof(s_weaponconfig.lgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.rgres.field.buffer, UI_Cvar_VariableString("g_rgrespawn"), sizeof(s_weaponconfig.rgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.pgres.field.buffer, UI_Cvar_VariableString("g_pgrespawn"), sizeof(s_weaponconfig.pgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgres.field.buffer, UI_Cvar_VariableString("g_bfgrespawn"), sizeof(s_weaponconfig.bfgres.field.buffer) );
       Q_strncpyz( s_weaponconfig.ftres.field.buffer, UI_Cvar_VariableString("g_ftrespawn"), sizeof(s_weaponconfig.ftres.field.buffer) );
       Q_strncpyz( s_weaponconfig.mgresa.field.buffer, UI_Cvar_VariableString("g_mgammorespawn"), sizeof(s_weaponconfig.mgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.sgresa.field.buffer, UI_Cvar_VariableString("g_sgammorespawn"), sizeof(s_weaponconfig.sgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.glresa.field.buffer, UI_Cvar_VariableString("g_glammorespawn"), sizeof(s_weaponconfig.glresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.rlresa.field.buffer, UI_Cvar_VariableString("g_rlammorespawn"), sizeof(s_weaponconfig.rlresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.lgresa.field.buffer, UI_Cvar_VariableString("g_lgammorespawn"), sizeof(s_weaponconfig.lgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.rgresa.field.buffer, UI_Cvar_VariableString("g_rgammorespawn"), sizeof(s_weaponconfig.rgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.pgresa.field.buffer, UI_Cvar_VariableString("g_pgammorespawn"), sizeof(s_weaponconfig.pgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgresa.field.buffer, UI_Cvar_VariableString("g_bfgammorespawn"), sizeof(s_weaponconfig.bfgresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.ftresa.field.buffer, UI_Cvar_VariableString("g_ftammorespawn"), sizeof(s_weaponconfig.ftresa.field.buffer) );
       Q_strncpyz( s_weaponconfig.mgdam.field.buffer, UI_Cvar_VariableString("mgdamage"), sizeof(s_weaponconfig.mgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.sgdam.field.buffer, UI_Cvar_VariableString("sgdamage"), sizeof(s_weaponconfig.sgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.gtdam.field.buffer, UI_Cvar_VariableString("gtdamage"), sizeof(s_weaponconfig.gtdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.gldam.field.buffer, UI_Cvar_VariableString("gldamage"), sizeof(s_weaponconfig.gldam.field.buffer) );
       Q_strncpyz( s_weaponconfig.rldam.field.buffer, UI_Cvar_VariableString("rldamage"), sizeof(s_weaponconfig.rldam.field.buffer) );
       Q_strncpyz( s_weaponconfig.lgdam.field.buffer, UI_Cvar_VariableString("lgdamage"), sizeof(s_weaponconfig.lgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.rgdam.field.buffer, UI_Cvar_VariableString("rgdamage"), sizeof(s_weaponconfig.rgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.pgdam.field.buffer, UI_Cvar_VariableString("pgdamage"), sizeof(s_weaponconfig.pgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgdam.field.buffer, UI_Cvar_VariableString("bfgdamage"), sizeof(s_weaponconfig.bfgdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.ftdam.field.buffer, UI_Cvar_VariableString("ftdamage"), sizeof(s_weaponconfig.ftdam.field.buffer) );
       Q_strncpyz( s_weaponconfig.grenadevelocity.field.buffer, UI_Cvar_VariableString("grenadevelocity"), sizeof(s_weaponconfig.grenadevelocity.field.buffer) );
       Q_strncpyz( s_weaponconfig.grapplevelocity.field.buffer, UI_Cvar_VariableString("grapplevelocity"), sizeof(s_weaponconfig.grapplevelocity.field.buffer) );
       Q_strncpyz( s_weaponconfig.rocketvelocity.field.buffer, UI_Cvar_VariableString("rocketvelocity"), sizeof(s_weaponconfig.rocketvelocity.field.buffer) );
       Q_strncpyz( s_weaponconfig.plasmavelocity.field.buffer, UI_Cvar_VariableString("plasmavelocity"), sizeof(s_weaponconfig.plasmavelocity.field.buffer) );
       Q_strncpyz( s_weaponconfig.bfgvelocity.field.buffer, UI_Cvar_VariableString("bfgvelocity"), sizeof(s_weaponconfig.bfgvelocity.field.buffer) );
       s_weaponconfig.weaponimage.curvalue = Com_Clamp( 0, 7, trap_Cvar_VariableValue( "replaceftwith" ) );
       UI_PushMenu( &s_weaponconfig.menu );
}

// Start more options

static void Weaponconfig2_Event( void* ptr, int notification ) {
       int glsplash, rlsplash, pgsplash, bfgsplash, glradius, rlradius, pgradius, bfgradius;
       int gtscore, mgscore, sgscore, glscore, rlscore, lgscore, rgscore, pgscore, bfgscore, ftscore;
       glsplash       = atoi( s_weaponconfig2.glsd.field.buffer );
       rlsplash       = atoi( s_weaponconfig2.rlsd.field.buffer );
       pgsplash       = atoi( s_weaponconfig2.pgsd.field.buffer );
       bfgsplash       = atoi( s_weaponconfig2.bfgsd.field.buffer );
       glradius       = atoi( s_weaponconfig2.glsr.field.buffer );
       rlradius       = atoi( s_weaponconfig2.rlsr.field.buffer );
       pgradius       = atoi( s_weaponconfig2.pgsr.field.buffer );
       bfgradius      = atoi( s_weaponconfig2.bfgsr.field.buffer );
       gtscore        = atoi( s_weaponconfig2.gtscore.field.buffer);
       mgscore        = atoi( s_weaponconfig2.mgscore.field.buffer);
       sgscore        = atoi( s_weaponconfig2.sgscore.field.buffer);
       glscore        = atoi( s_weaponconfig2.glscore.field.buffer);
       rlscore        = atoi( s_weaponconfig2.rlscore.field.buffer);
       lgscore        = atoi( s_weaponconfig2.lgscore.field.buffer);
       rgscore        = atoi( s_weaponconfig2.rgscore.field.buffer);
       pgscore        = atoi( s_weaponconfig2.pgscore.field.buffer);
       bfgscore        = atoi( s_weaponconfig2.bfgscore.field.buffer);
       ftscore        = atoi( s_weaponconfig2.ftscore.field.buffer);

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {

	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

       case ID_WEAPONCONFIGBACK:
             UI_PopMenu();
             break;

       case ID_ACCEPT:
       trap_Cvar_SetValue( "g_spawnrandomsg", s_weaponconfig2.sg.curvalue);
       trap_Cvar_SetValue( "g_spawnrandomgl", s_weaponconfig2.gl.curvalue);
       trap_Cvar_SetValue( "g_spawnrandomrl", s_weaponconfig2.rl.curvalue);
       trap_Cvar_SetValue( "g_spawnrandomlg", s_weaponconfig2.lg.curvalue);
       trap_Cvar_SetValue( "g_spawnrandomrg", s_weaponconfig2.rg.curvalue);
       trap_Cvar_SetValue( "g_spawnrandompg", s_weaponconfig2.pg.curvalue);
       trap_Cvar_SetValue( "g_spawnrandombfg", s_weaponconfig2.bfg.curvalue);
       trap_Cvar_SetValue( "g_spawnrandomft", s_weaponconfig2.randomft.curvalue);
       trap_Cvar_SetValue( "glsdamage", glsplash );
       trap_Cvar_SetValue( "rlsdamage", rlsplash );
       trap_Cvar_SetValue( "pgsdamage", pgsplash );
       trap_Cvar_SetValue( "bfgsdamage", bfgsplash );
       trap_Cvar_SetValue( "glsradius", glradius );
       trap_Cvar_SetValue( "rlsradius", rlradius );
       trap_Cvar_SetValue( "pgsradius", pgradius );
       trap_Cvar_SetValue( "bfgsradius", bfgradius );
       trap_Cvar_SetValue( "gtscore", gtscore );
       trap_Cvar_SetValue( "mgscore", mgscore );
       trap_Cvar_SetValue( "sgscore", sgscore );
       trap_Cvar_SetValue( "glscore", glscore );
       trap_Cvar_SetValue( "rlscore", rlscore );
       trap_Cvar_SetValue( "lgscore", lgscore );
       trap_Cvar_SetValue( "rgscore", rgscore );
       trap_Cvar_SetValue( "pgscore", pgscore );
       trap_Cvar_SetValue( "bfgscore", bfgscore );
       trap_Cvar_SetValue( "ftscore", ftscore );
             UI_PopMenu();
             break;

	}
}

static void UI_WEAPONCONFIG2_MENU( void );

static void WeaponConfig2_ResetAction( qboolean result ) {
	if( !result ) {
		return;
	}

	// clear game variables
       trap_Cvar_SetValue( "g_mgweap", 1);
       trap_Cvar_SetValue( "g_sgweap", 1);
       trap_Cvar_SetValue( "g_glweap", 1);
       trap_Cvar_SetValue( "g_rlweap", 1);
       trap_Cvar_SetValue( "g_lgweap", 1);
       trap_Cvar_SetValue( "g_rgweap", 1);
       trap_Cvar_SetValue( "g_pgweap", 1);
       trap_Cvar_SetValue( "g_bfgweap", 1);
       trap_Cvar_SetValue( "g_mgammo", 1);
       trap_Cvar_SetValue( "g_sgammo", 1);
       trap_Cvar_SetValue( "g_glammo", 1);
       trap_Cvar_SetValue( "g_rlammo", 1);
       trap_Cvar_SetValue( "g_lgammo", 1);
       trap_Cvar_SetValue( "g_rgammo", 1);
       trap_Cvar_SetValue( "g_pgammo", 1);
       trap_Cvar_SetValue( "g_bfgammo", 1);
       trap_Cvar_SetValue( "g_mgreload", 100 );
       trap_Cvar_SetValue( "g_sgreload", 1000 );
       trap_Cvar_SetValue( "g_glreload", 800 );
       trap_Cvar_SetValue( "g_rlreload", 800 );
       trap_Cvar_SetValue( "g_lgreload", 50 );
       trap_Cvar_SetValue( "g_rgreload", 1500 );
       trap_Cvar_SetValue( "g_pgreload", 100 );
       trap_Cvar_SetValue( "g_bfgreload", 200 );
       trap_Cvar_SetValue( "g_ftreload", 40 );
       trap_Cvar_SetValue( "g_mgrespawn", 5 );
       trap_Cvar_SetValue( "g_sgrespawn", 5 );
       trap_Cvar_SetValue( "g_glrespawn", 5 );
       trap_Cvar_SetValue( "g_rlrespawn", 5 );
       trap_Cvar_SetValue( "g_lgrespawn", 5 );
       trap_Cvar_SetValue( "g_rgrespawn", 5 );
       trap_Cvar_SetValue( "g_pgrespawn", 5 );
       trap_Cvar_SetValue( "g_bfgrespawn", 5 );
       trap_Cvar_SetValue( "g_ftrespawn", 5 );
       trap_Cvar_SetValue( "machinegunammo", 50 );
       trap_Cvar_SetValue( "shotgunammo", 10 );
       trap_Cvar_SetValue( "grenadeammo", 6 );
       trap_Cvar_SetValue( "rocketammo", 5 );
       trap_Cvar_SetValue( "lightningammo", 60 );
       trap_Cvar_SetValue( "railgunammo", 10 );
       trap_Cvar_SetValue( "plasmaammo", 30 );
       trap_Cvar_SetValue( "bfgammo", 50 );
       trap_Cvar_SetValue( "ftammo", 80 );
       trap_Cvar_SetValue( "g_mgammorespawn", 40 );
       trap_Cvar_SetValue( "g_sgammorespawn", 40 );
       trap_Cvar_SetValue( "g_glammorespawn", 40 );
       trap_Cvar_SetValue( "g_rlammorespawn", 40 );
       trap_Cvar_SetValue( "g_lgammorespawn", 40 );
       trap_Cvar_SetValue( "g_rgammorespawn", 40 );
       trap_Cvar_SetValue( "g_pgammorespawn", 40 );
       trap_Cvar_SetValue( "g_bfgammorespawn", 40 );
       trap_Cvar_SetValue( "g_ftammorespawn", 40 );
       trap_Cvar_SetValue( "gtdamage", 50 );
       trap_Cvar_SetValue( "mgdamage", 7 );
       trap_Cvar_SetValue( "sgdamage", 10 );
       trap_Cvar_SetValue( "gldamage", 100 );
       trap_Cvar_SetValue( "rldamage", 100 );
       trap_Cvar_SetValue( "lgdamage", 8 );
       trap_Cvar_SetValue( "rgdamage", 100 );
       trap_Cvar_SetValue( "pgdamage", 20 );
       trap_Cvar_SetValue( "bfgdamage", 100 );
       trap_Cvar_SetValue( "ftdamage", 15 );
       trap_Cvar_SetValue( "grenadevelocity", 700 );
       trap_Cvar_SetValue( "rocketvelocity", 900 );
       trap_Cvar_SetValue( "plasmavelocity", 2000 );
       trap_Cvar_SetValue( "bfgvelocity", 2000 );
       trap_Cvar_SetValue( "replaceftwith", 0 );
       trap_Cvar_SetValue( "g_spawnrandomsg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomgl", 0 );
       trap_Cvar_SetValue( "g_spawnrandomrl", 0 );
       trap_Cvar_SetValue( "g_spawnrandomlg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomrg", 0 );
       trap_Cvar_SetValue( "g_spawnrandompg", 0 );
       trap_Cvar_SetValue( "g_spawnrandombfg", 0 );
       trap_Cvar_SetValue( "g_spawnrandomft", 0 );
       trap_Cvar_SetValue( "glsdamage", 100 );
       trap_Cvar_SetValue( "glsradius", 150 );
       trap_Cvar_SetValue( "rlsdamage", 100 );
       trap_Cvar_SetValue( "rlsradius", 120 );
       trap_Cvar_SetValue( "pgsdamage", 15 );
       trap_Cvar_SetValue( "pgsradius", 20 );
       trap_Cvar_SetValue( "bfgsdamage", 100 );
       trap_Cvar_SetValue( "bfgsradius", 120 );
       trap_Cvar_SetValue( "gtscore", 1 );
       trap_Cvar_SetValue( "mgscore", 1 );
       trap_Cvar_SetValue( "sgscore", 1 );
       trap_Cvar_SetValue( "glscore", 1 );
       trap_Cvar_SetValue( "rlscore", 1 );
       trap_Cvar_SetValue( "lgscore", 1 );
       trap_Cvar_SetValue( "rgscore", 1 );
       trap_Cvar_SetValue( "pgscore", 1 );
       trap_Cvar_SetValue( "bfgscore", 1 );
       trap_Cvar_SetValue( "ftscore", 1 );

	UI_PopMenu();
       UI_WEAPONCONFIG2_MENU();
}

static void WeaponConfig2_ResetDraw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, s_weaponconfig2.picture );
	UI_DrawProportionalString( SCREEN_WIDTH/2, 356 + PROP_HEIGHT * 0, "WARNING: This resets all of the", UI_CENTER|UI_SMALLFONT, color_yellow );
       UI_DrawProportionalString( SCREEN_WIDTH/2, 356 + PROP_HEIGHT * 1, "weapons configuration variables.", UI_CENTER|UI_SMALLFONT, color_yellow );
}

static void WeaponConfig2_ResetEvent( void* ptr, int event )
{
	if (event != QM_ACTIVATED) {
		return;
	}
       UI_ConfirmMenu( "RESET WEAPONS?", WeaponConfig2_ResetDraw, WeaponConfig2_ResetAction );
}

static void WeaponConfig2_Draw( void ) {
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       UI_DrawString( 88, 94+((BIGCHAR_HEIGHT+2)*2), "Gauntlet  ", UI_CENTER|UI_SMALLFONT, color_orange );
       UI_DrawString( 88, 94+((BIGCHAR_HEIGHT+2)*3), "Machinegun", UI_CENTER|UI_SMALLFONT, color_orange );
       UI_DrawString( Hellfire2_X_POS-142, 78, "Spawn", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-142, 93, "Random Weapon", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-38, 78, "Splash", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS-38, 93, "Damage", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+20, 78, "Splash", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+20, 93, "Radius", UI_CENTER|UI_SMALLFONT, colorWhite );
       UI_DrawString( Hellfire2_X_POS+90, 78, "Points", UI_CENTER|UI_SMALLFONT, colorWhite );
       Menu_Draw( &s_weaponconfig2.menu );

       if( s_weaponconfig2.draw ) {
              s_weaponconfig2.draw();
	}
}

static void UI_WEAPONCONFIG2_MENU( void )
{
	int				y;
       memset( &s_weaponconfig2, 0 ,sizeof(weaponconfig2_t) );

       Hellfire_Cache();

       s_weaponconfig2.menu.draw = WeaponConfig2_Draw;
       s_weaponconfig2.menu.wrapAround = qtrue;
       s_weaponconfig2.menu.fullscreen = qtrue;

       s_weaponconfig2.banner.generic.type  = MTYPE_PTEXT;
       s_weaponconfig2.banner.generic.x        = 320;
       s_weaponconfig2.banner.generic.y        = 32;
       s_weaponconfig2.banner.string           = "WEAPONS CONFIG";
       s_weaponconfig2.banner.color         = color_orange;
       s_weaponconfig2.banner.style         = UI_CENTER;

       s_weaponconfig2.frame.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.frame.generic.name  = ART_FRAME;
       s_weaponconfig2.frame.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.frame.generic.x        = 0;
       s_weaponconfig2.frame.generic.y        = 0;
       s_weaponconfig2.frame.width            = 640;
       s_weaponconfig2.frame.height           = 480;

       y = 94;
       y += BIGCHAR_HEIGHT+2;
       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_gt.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_gt.generic.name  = ART_GT;
       s_weaponconfig2.i_gt.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_gt.generic.x        = 9+20;
       s_weaponconfig2.i_gt.generic.y        = y;
       s_weaponconfig2.i_gt.width            = 16;
       s_weaponconfig2.i_gt.height           = 16;

       s_weaponconfig2.gtscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.gtscore.generic.name          =      "";
       s_weaponconfig2.gtscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.gtscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.gtscore.generic.id          = ID_GTSCORE;
       s_weaponconfig2.gtscore.field.maxchars             = 3;
       s_weaponconfig2.gtscore.field.widthInChars        = 3;
       s_weaponconfig2.gtscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.gtscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_mg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_mg.generic.name  = ART_MG;
       s_weaponconfig2.i_mg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_mg.generic.x        = 9+20;
       s_weaponconfig2.i_mg.generic.y        = y;
       s_weaponconfig2.i_mg.width            = 16;
       s_weaponconfig2.i_mg.height           = 16;

       s_weaponconfig2.mgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.mgscore.generic.name          =      "";
       s_weaponconfig2.mgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.mgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.mgscore.generic.id          = ID_MGSCORE;
       s_weaponconfig2.mgscore.field.maxchars             = 3;
       s_weaponconfig2.mgscore.field.widthInChars        = 3;
       s_weaponconfig2.mgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.mgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_sg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_sg.generic.name  = ART_SG;
       s_weaponconfig2.i_sg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_sg.generic.x        = 9+20;
       s_weaponconfig2.i_sg.generic.y        = y;
       s_weaponconfig2.i_sg.width            = 16;
       s_weaponconfig2.i_sg.height           = 16;

       s_weaponconfig2.sg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.sg.generic.name          =   "Shotgun         ";
       s_weaponconfig2.sg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.sg.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.sg.generic.id          = ID_SGWEAP;
       s_weaponconfig2.sg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.sg.generic.y                 = y;

       s_weaponconfig2.sgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.sgscore.generic.name          =      "";
       s_weaponconfig2.sgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.sgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.sgscore.generic.id          = ID_SGSCORE;
       s_weaponconfig2.sgscore.field.maxchars             = 3;
       s_weaponconfig2.sgscore.field.widthInChars        = 3;
       s_weaponconfig2.sgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.sgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_gl.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_gl.generic.name  = ART_GL;
       s_weaponconfig2.i_gl.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_gl.generic.x        = 9+20;
       s_weaponconfig2.i_gl.generic.y        = y;
       s_weaponconfig2.i_gl.width            = 16;
       s_weaponconfig2.i_gl.height           = 16;

       s_weaponconfig2.gl.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.gl.generic.name         =    "Grenade Launcher";
       s_weaponconfig2.gl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.gl.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.gl.generic.id          = ID_GLWEAP;
       s_weaponconfig2.gl.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.gl.generic.y                 = y;

       s_weaponconfig2.glsd.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.glsd.generic.name          =      "";
       s_weaponconfig2.glsd.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.glsd.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.glsd.generic.id          = ID_GLSPLASHDAM;
       s_weaponconfig2.glsd.field.maxchars             = 4;
       s_weaponconfig2.glsd.field.widthInChars        = 4;
       s_weaponconfig2.glsd.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig2.glsd.generic.y                 = y;

       s_weaponconfig2.glsr.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.glsr.generic.name          =      "";
       s_weaponconfig2.glsr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.glsr.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.glsr.generic.id          = ID_GLSPLASHRAD;
       s_weaponconfig2.glsr.field.maxchars             = 3;
       s_weaponconfig2.glsr.field.widthInChars        = 3;
       s_weaponconfig2.glsr.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig2.glsr.generic.y                 = y;

       s_weaponconfig2.glscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.glscore.generic.name          =      "";
       s_weaponconfig2.glscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.glscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.glscore.generic.id          = ID_GLSCORE;
       s_weaponconfig2.glscore.field.maxchars             = 3;
       s_weaponconfig2.glscore.field.widthInChars        = 3;
       s_weaponconfig2.glscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.glscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_rl.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_rl.generic.name  = ART_RL;
       s_weaponconfig2.i_rl.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_rl.generic.x        = 9+20;
       s_weaponconfig2.i_rl.generic.y        = y;
       s_weaponconfig2.i_rl.width            = 16;
       s_weaponconfig2.i_rl.height           = 16;

       s_weaponconfig2.rl.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.rl.generic.name         =    "Rocket Launcher ";
       s_weaponconfig2.rl.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.rl.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rl.generic.id          = ID_RLWEAP;
       s_weaponconfig2.rl.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.rl.generic.y                 = y;

       s_weaponconfig2.rlsd.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.rlsd.generic.name          =      "";
       s_weaponconfig2.rlsd.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.rlsd.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rlsd.generic.id          = ID_RLSPLASHDAM;
       s_weaponconfig2.rlsd.field.maxchars             = 4;
       s_weaponconfig2.rlsd.field.widthInChars        = 4;
       s_weaponconfig2.rlsd.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig2.rlsd.generic.y                 = y;

       s_weaponconfig2.rlsr.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.rlsr.generic.name          =      "";
       s_weaponconfig2.rlsr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.rlsr.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rlsr.generic.id          = ID_RLSPLASHRAD;
       s_weaponconfig2.rlsr.field.maxchars             = 3;
       s_weaponconfig2.rlsr.field.widthInChars        = 3;
       s_weaponconfig2.rlsr.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig2.rlsr.generic.y                 = y;

       s_weaponconfig2.rlscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.rlscore.generic.name          =      "";
       s_weaponconfig2.rlscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.rlscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rlscore.generic.id          = ID_RLSCORE;
       s_weaponconfig2.rlscore.field.maxchars             = 3;
       s_weaponconfig2.rlscore.field.widthInChars        = 3;
       s_weaponconfig2.rlscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.rlscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_lg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_lg.generic.name  = ART_LG;
       s_weaponconfig2.i_lg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_lg.generic.x        = 9+20;
       s_weaponconfig2.i_lg.generic.y        = y;
       s_weaponconfig2.i_lg.width            = 16;
       s_weaponconfig2.i_lg.height           = 16;

       s_weaponconfig2.lg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.lg.generic.name    =         "Lightning Gun   ";
       s_weaponconfig2.lg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.lg.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.lg.generic.id          = ID_LGWEAP;
       s_weaponconfig2.lg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.lg.generic.y                 = y;

       s_weaponconfig2.lgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.lgscore.generic.name          =      "";
       s_weaponconfig2.lgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.lgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.lgscore.generic.id          = ID_LGSCORE;
       s_weaponconfig2.lgscore.field.maxchars             = 3;
       s_weaponconfig2.lgscore.field.widthInChars        = 3;
       s_weaponconfig2.lgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.lgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_rg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_rg.generic.name  = ART_RG;
       s_weaponconfig2.i_rg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_rg.generic.x        = 9+20;
       s_weaponconfig2.i_rg.generic.y        = y;
       s_weaponconfig2.i_rg.width            = 16;
       s_weaponconfig2.i_rg.height           = 16;

       s_weaponconfig2.rg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.rg.generic.name    =         "Railgun         ";
       s_weaponconfig2.rg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.rg.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rg.generic.id          = ID_RGWEAP;
       s_weaponconfig2.rg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.rg.generic.y                 = y;

       s_weaponconfig2.rgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.rgscore.generic.name          =      "";
       s_weaponconfig2.rgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.rgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.rgscore.generic.id          = ID_RGSCORE;
       s_weaponconfig2.rgscore.field.maxchars             = 3;
       s_weaponconfig2.rgscore.field.widthInChars        = 3;
       s_weaponconfig2.rgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.rgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_pg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_pg.generic.name  = ART_PG;
       s_weaponconfig2.i_pg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_pg.generic.x        = 9+20;
       s_weaponconfig2.i_pg.generic.y        = y;
       s_weaponconfig2.i_pg.width            = 16;
       s_weaponconfig2.i_pg.height           = 16;

       s_weaponconfig2.pg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.pg.generic.name    =         "Plasma Gun      ";
       s_weaponconfig2.pg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.pg.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.pg.generic.id          = ID_PGWEAP;
       s_weaponconfig2.pg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.pg.generic.y                 = y;

       s_weaponconfig2.pgsd.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.pgsd.generic.name          =      "";
       s_weaponconfig2.pgsd.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.pgsd.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.pgsd.generic.id          = ID_PGSPLASHDAM;
       s_weaponconfig2.pgsd.field.maxchars             = 4;
       s_weaponconfig2.pgsd.field.widthInChars        = 4;
       s_weaponconfig2.pgsd.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig2.pgsd.generic.y                 = y;

       s_weaponconfig2.pgsr.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.pgsr.generic.name          =      "";
       s_weaponconfig2.pgsr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.pgsr.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.pgsr.generic.id          = ID_PGSPLASHRAD;
       s_weaponconfig2.pgsr.field.maxchars             = 3;
       s_weaponconfig2.pgsr.field.widthInChars        = 3;
       s_weaponconfig2.pgsr.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig2.pgsr.generic.y                 = y;

       s_weaponconfig2.pgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.pgscore.generic.name          =      "";
       s_weaponconfig2.pgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.pgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.pgscore.generic.id          = ID_PGSCORE;
       s_weaponconfig2.pgscore.field.maxchars             = 3;
       s_weaponconfig2.pgscore.field.widthInChars        = 3;
       s_weaponconfig2.pgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.pgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_bfg.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_bfg.generic.name  = ART_BFG;
       s_weaponconfig2.i_bfg.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_bfg.generic.x        = 9+20;
       s_weaponconfig2.i_bfg.generic.y        = y;
       s_weaponconfig2.i_bfg.width            = 16;
       s_weaponconfig2.i_bfg.height           = 16;

       s_weaponconfig2.bfg.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.bfg.generic.name           = "BFG10k          ";
       s_weaponconfig2.bfg.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.bfg.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.bfg.generic.id          = ID_BFGWEAP;
       s_weaponconfig2.bfg.generic.x                 = Hellfire_X_POS-206;
       s_weaponconfig2.bfg.generic.y                 = y;

       s_weaponconfig2.bfgsd.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.bfgsd.generic.name          = "";
       s_weaponconfig2.bfgsd.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.bfgsd.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.bfgsd.generic.id          = ID_BFGSPLASHDAM;
       s_weaponconfig2.bfgsd.field.maxchars             = 4;
       s_weaponconfig2.bfgsd.field.widthInChars        = 4;
       s_weaponconfig2.bfgsd.generic.x                 = Hellfire_X_POS-88;
       s_weaponconfig2.bfgsd.generic.y                 = y;

       s_weaponconfig2.bfgsr.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.bfgsr.generic.name          =      "";
       s_weaponconfig2.bfgsr.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.bfgsr.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.bfgsr.generic.id          = ID_BFGSPLASHRAD;
       s_weaponconfig2.bfgsr.field.maxchars             = 3;
       s_weaponconfig2.bfgsr.field.widthInChars        = 3;
       s_weaponconfig2.bfgsr.generic.x                 = Hellfire_X_POS-30;
       s_weaponconfig2.bfgsr.generic.y                 = y;

       s_weaponconfig2.bfgscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.bfgscore.generic.name          =      "";
       s_weaponconfig2.bfgscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.bfgscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.bfgscore.generic.id          = ID_BFGSCORE;
       s_weaponconfig2.bfgscore.field.maxchars             = 3;
       s_weaponconfig2.bfgscore.field.widthInChars        = 3;
       s_weaponconfig2.bfgscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.bfgscore.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2;
       s_weaponconfig2.i_ft.generic.type  = MTYPE_BITMAP;
       s_weaponconfig2.i_ft.generic.name  = ART_FT;
       s_weaponconfig2.i_ft.generic.flags = QMF_INACTIVE;
       s_weaponconfig2.i_ft.generic.x        = 9+20;
       s_weaponconfig2.i_ft.generic.y        = y;
       s_weaponconfig2.i_ft.width            = 16;
       s_weaponconfig2.i_ft.height           = 16;

       s_weaponconfig2.randomft.generic.type        = MTYPE_RADIOBUTTON;
       s_weaponconfig2.randomft.generic.name          =      "Flame Thrower   ";
       s_weaponconfig2.randomft.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_LEFT_JUSTIFY;
       s_weaponconfig2.randomft.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.randomft.generic.id          = ID_RANDOMFT;
       s_weaponconfig2.randomft.generic.x                 = Hellfire_X_POS-206; // - 144
       s_weaponconfig2.randomft.generic.y                 = y;

       s_weaponconfig2.ftscore.generic.type        = MTYPE_FIELD;
       s_weaponconfig2.ftscore.generic.name          =      "";
       s_weaponconfig2.ftscore.generic.flags         = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_weaponconfig2.ftscore.generic.callback    = Weaponconfig2_Event;
       s_weaponconfig2.ftscore.generic.id          = ID_FTSCORE;
       s_weaponconfig2.ftscore.field.maxchars             = 3;
       s_weaponconfig2.ftscore.field.widthInChars        = 3;
       s_weaponconfig2.ftscore.generic.x                 = Hellfire_X_POS+46;
       s_weaponconfig2.ftscore.generic.y                 = y;

       s_weaponconfig2.back.generic.type        = MTYPE_BITMAP;
       s_weaponconfig2.back.generic.name     = ART_BACK0;
       s_weaponconfig2.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig2.back.generic.callback = Weaponconfig2_Event;
       s_weaponconfig2.back.generic.id          = ID_WEAPONCONFIGBACK;
       s_weaponconfig2.back.generic.x           = 0;
       s_weaponconfig2.back.generic.y           = 475-64;
       s_weaponconfig2.back.width               = 128;
       s_weaponconfig2.back.height              = 64;
       s_weaponconfig2.back.focuspic         = ART_BACK1;
       s_weaponconfig2.back.generic.statusbar            = Hellfire_StatusBar4;

       s_weaponconfig2.load.generic.type        = MTYPE_BITMAP;
       s_weaponconfig2.load.generic.name     = ART_LOAD0;
       s_weaponconfig2.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig2.load.generic.callback = Weaponconfig2_Event;
       s_weaponconfig2.load.generic.id          = ID_LOAD;
       s_weaponconfig2.load.generic.x           = 128;
       s_weaponconfig2.load.generic.y           = 475-64;
       s_weaponconfig2.load.width               = 128;
       s_weaponconfig2.load.height              = 64;
       s_weaponconfig2.load.focuspic         = ART_LOAD1;
       s_weaponconfig2.load.generic.statusbar            = Hellfire_StatusBar7;

       s_weaponconfig2.item_reset.generic.type                   = MTYPE_BITMAP;
       s_weaponconfig2.item_reset.generic.name                   = ART_RESET0;
       s_weaponconfig2.item_reset.generic.flags                  = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig2.item_reset.generic.x                      = 320-128/2;
       s_weaponconfig2.item_reset.generic.y                      = 475-64;
       s_weaponconfig2.item_reset.generic.callback        = WeaponConfig2_ResetEvent;
       s_weaponconfig2.item_reset.generic.id                            = ID_RESET;
       s_weaponconfig2.item_reset.width                                 = 128;
       s_weaponconfig2.item_reset.height                                = 64;
       s_weaponconfig2.item_reset.focuspic                       = ART_RESET1;
       s_weaponconfig2.item_reset.generic.statusbar            = Hellfire_StatusBar6;

       s_weaponconfig2.save.generic.type        = MTYPE_BITMAP;
       s_weaponconfig2.save.generic.name     = ART_SAVE0;
       s_weaponconfig2.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig2.save.generic.callback = Weaponconfig2_Event;
       s_weaponconfig2.save.generic.id          = ID_SAVE;
       s_weaponconfig2.save.generic.x           = 384;
       s_weaponconfig2.save.generic.y           = 475-64;
       s_weaponconfig2.save.width               = 128;
       s_weaponconfig2.save.height              = 64;
       s_weaponconfig2.save.focuspic         = ART_SAVE1;
       s_weaponconfig2.save.generic.statusbar            = Hellfire_StatusBar8;

       s_weaponconfig2.accept.generic.type        = MTYPE_BITMAP;
       s_weaponconfig2.accept.generic.name     = ART_ACCEPT0;
       s_weaponconfig2.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_weaponconfig2.accept.generic.callback = Weaponconfig2_Event;
       s_weaponconfig2.accept.generic.id          = ID_ACCEPT;
       s_weaponconfig2.accept.generic.x           = 512;
       s_weaponconfig2.accept.generic.y           = 475-64;
       s_weaponconfig2.accept.width               = 128;
       s_weaponconfig2.accept.height              = 64;
       s_weaponconfig2.accept.focuspic         = ART_ACCEPT1;
       s_weaponconfig2.accept.generic.statusbar            = Hellfire_StatusBar5;

       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.banner );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.frame );

       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.gtscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.mgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.sg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.sgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.gl );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.glsd );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.glsr );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.glscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rl );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rlsd );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rlsr );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rlscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.lg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.lgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.rgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.pg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.pgsd );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.pgsr );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.pgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.bfg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.bfgsd );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.bfgsr );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.bfgscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.randomft );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.ftscore );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.back );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.load );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.item_reset );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.save );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.accept );

       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_gt );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_mg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_sg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_gl );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_rl );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_lg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_rg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_pg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_bfg );
       Menu_AddItem( &s_weaponconfig2.menu, &s_weaponconfig2.i_ft );
       s_weaponconfig2.sg.curvalue = trap_Cvar_VariableValue( "g_spawnrandomsg" ) != 0;
       s_weaponconfig2.gl.curvalue = trap_Cvar_VariableValue( "g_spawnrandomgl" ) != 0;
       s_weaponconfig2.rl.curvalue = trap_Cvar_VariableValue( "g_spawnrandomrl" ) != 0;
       s_weaponconfig2.lg.curvalue = trap_Cvar_VariableValue( "g_spawnrandomlg" ) != 0;
       s_weaponconfig2.rg.curvalue = trap_Cvar_VariableValue( "g_spawnrandomrg" ) != 0;
       s_weaponconfig2.pg.curvalue = trap_Cvar_VariableValue( "g_spawnrandompg" ) != 0;
       s_weaponconfig2.bfg.curvalue = trap_Cvar_VariableValue( "g_spawnrandombfg" ) != 0;
       s_weaponconfig2.randomft.curvalue = trap_Cvar_VariableValue( "g_spawnrandomft" ) != 0;
       Q_strncpyz( s_weaponconfig2.glsd.field.buffer, UI_Cvar_VariableString("glsdamage"), sizeof(s_weaponconfig2.glsd.field.buffer) );
       Q_strncpyz( s_weaponconfig2.rlsd.field.buffer, UI_Cvar_VariableString("rlsdamage"), sizeof(s_weaponconfig2.rlsd.field.buffer) );
       Q_strncpyz( s_weaponconfig2.pgsd.field.buffer, UI_Cvar_VariableString("pgsdamage"), sizeof(s_weaponconfig2.pgsd.field.buffer) );
       Q_strncpyz( s_weaponconfig2.bfgsd.field.buffer, UI_Cvar_VariableString("bfgsdamage"), sizeof(s_weaponconfig2.bfgsd.field.buffer) );
       Q_strncpyz( s_weaponconfig2.glsr.field.buffer, UI_Cvar_VariableString("glsradius"), sizeof(s_weaponconfig2.glsr.field.buffer) );
       Q_strncpyz( s_weaponconfig2.rlsr.field.buffer, UI_Cvar_VariableString("rlsradius"), sizeof(s_weaponconfig2.rlsr.field.buffer) );
       Q_strncpyz( s_weaponconfig2.pgsr.field.buffer, UI_Cvar_VariableString("pgsradius"), sizeof(s_weaponconfig2.pgsr.field.buffer) );
       Q_strncpyz( s_weaponconfig2.bfgsr.field.buffer, UI_Cvar_VariableString("bfgsradius"), sizeof(s_weaponconfig2.bfgsr.field.buffer) );
       Q_strncpyz( s_weaponconfig2.gtscore.field.buffer, UI_Cvar_VariableString("gtscore"), sizeof(s_weaponconfig2.gtscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.mgscore.field.buffer, UI_Cvar_VariableString("mgscore"), sizeof(s_weaponconfig2.mgscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.sgscore.field.buffer, UI_Cvar_VariableString("sgscore"), sizeof(s_weaponconfig2.sgscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.glscore.field.buffer, UI_Cvar_VariableString("glscore"), sizeof(s_weaponconfig2.glscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.rlscore.field.buffer, UI_Cvar_VariableString("rlscore"), sizeof(s_weaponconfig2.rlscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.lgscore.field.buffer, UI_Cvar_VariableString("lgscore"), sizeof(s_weaponconfig2.lgscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.rgscore.field.buffer, UI_Cvar_VariableString("rgscore"), sizeof(s_weaponconfig2.rgscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.pgscore.field.buffer, UI_Cvar_VariableString("pgscore"), sizeof(s_weaponconfig2.pgscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.ftscore.field.buffer, UI_Cvar_VariableString("ftscore"), sizeof(s_weaponconfig2.ftscore.field.buffer) );
       Q_strncpyz( s_weaponconfig2.bfgscore.field.buffer, UI_Cvar_VariableString("bfgscore"), sizeof(s_weaponconfig2.bfgscore.field.buffer) );
        UI_PushMenu( &s_weaponconfig2.menu );
}


static void Hellfire_Event( void* ptr, int notification ) {
       int starthealth, startarmor, maxhealth;
       starthealth       = atoi( s_hellfire.starthealth.field.buffer );
       startarmor        = atoi( s_hellfire.startarmor.field.buffer );
       maxhealth         = atoi( s_hellfire.maxhealth.field.buffer );

	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
       case ID_LAMEBOTS:
              trap_Cvar_SetValue( "lamebots", s_hellfire.lamebots.curvalue );
		break;

       case ID_GAMEMODES:
              UI_GAMEMODES_MENU();
		break;

       case ID_CAMPOPTIONS:
              UI_CAMPOPTIONS_MENU();
		break;

       case ID_WEAPONCONFIG:
              UI_WEAPONCONFIG_MENU();
		break;

       case ID_GAMEOPTIONS:
              UI_GAMEOPTIONS_MENU();
		break;

       case ID_RUNEOPTIONS:
              UI_RUNES_MENU();
		break;

       case ID_STARTWEAPONS:
              UI_STARTWEAPONS_MENU();
		break;

       case ID_BOTOPTIONS:
              UI_BOTOPTIONS_MENU();
		break;

       case ID_HUDOPTIONS:
              UI_HUDOPTIONS_MENU();
		break;

       case ID_CAMOPTIONS:
              UI_CAMOPTIONS_MENU();
		break;

       case ID_WEAPONOPTIONS:
              UI_WEAPONS_MENU();
		break;

       case ID_POWERUP:
              UI_POWERUPS_MENU();
		break;
/*
       case ID_STARTHEALTH:
              trap_Cvar_SetValue( "starthealth", starthealth );
              break;

       case ID_STARTARMOR:
              trap_Cvar_SetValue( "startarmor", startarmor );
              break;

       case ID_MAXHEALTH:
              trap_Cvar_SetValue( "maxhealth", maxhealth );
              break;

       case ID_PODIUM:
              trap_Cvar_SetValue( "g_podiumscores", s_hellfire.podium.curvalue );
		break;
*/
	case ID_LOAD:
		UI_LoadConfigMenu();
		break;

	case ID_SAVE:
		UI_SaveConfigMenu();
		break;

	case ID_BACK:
		UI_PopMenu();
		break;

       case ID_ACCEPT:
//              trap_Cvar_SetValue( "lamebots", s_hellfire.lamebots.curvalue );
              trap_Cvar_SetValue( "ui_cache", s_hellfire.cachemaps.curvalue );
              trap_Cvar_SetValue( "ui_music", s_hellfire.music.curvalue );
              trap_Cvar_SetValue( "starthealth", starthealth );
              trap_Cvar_SetValue( "startarmor", startarmor );
              trap_Cvar_SetValue( "maxhealth", maxhealth );
		UI_PopMenu();
		break;

       case ID_MUSIC:
              trap_Cvar_SetValue( "ui_music", s_hellfire.music.curvalue);
              if (s_hellfire.music.curvalue >= 1)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "s_stop\n" );
              if (s_hellfire.music.curvalue == 0)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "s_stop\n" );
              if (s_hellfire.music.curvalue == 1)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_01_loop.wav\n" );
              else if (s_hellfire.music.curvalue == 2)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_02.wav\n" );
              else if (s_hellfire.music.curvalue == 3)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_03.wav\n" );
              else if (s_hellfire.music.curvalue == 4)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_04_loop.wav\n" );
              else if (s_hellfire.music.curvalue == 5)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_05.wav\n" );
              else if (s_hellfire.music.curvalue == 6)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_06.wav\n" );
              else if (s_hellfire.music.curvalue == 7)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic1.wav\n" );
              else if (s_hellfire.music.curvalue == 8)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic2.wav\n" );
              else if (s_hellfire.music.curvalue == 9)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic3.wav\n" );
              else if (s_hellfire.music.curvalue == 10)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic4.wav\n" );
              else if (s_hellfire.music.curvalue == 11)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic5.wav\n" );
              else if (s_hellfire.music.curvalue == 12)
                     trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic6.wav\n" );
                     break;

	}
}

static void Hellfire_MenuInit( void ) {
	int				y;
       float                       r;
       char   array[64];
       int i;
       int temp[64];
       char *temp2;
       int temp3;
       char                 *txt;
	int	len;
	fileHandle_t	f;
       const char *filename="readme.txt";
       static char buf[23020];
       memset( &s_hellfire, 0 ,sizeof(Hellfire_t) );
       len = trap_FS_FOpenFile( filename, &f, FS_READ );

       Hellfire_Cache();

       s_hellfire.menu.wrapAround = qtrue;
       s_hellfire.menu.fullscreen = qtrue;
       s_hellfire.menu.draw = testdraw;

       s_hellfire.banner.generic.type  = MTYPE_PTEXT;
       s_hellfire.banner.generic.x        = 320;
       s_hellfire.banner.generic.y        = 32;
       s_hellfire.banner.string           = "HELLFIRE OPTIONS";
       s_hellfire.banner.color         = color_orange;
       s_hellfire.banner.style         = UI_CENTER;

       s_hellfire.framel.generic.type  = MTYPE_BITMAP;
       s_hellfire.framel.generic.name  = ART_FRAMEL;
       s_hellfire.framel.generic.flags = QMF_INACTIVE;
       s_hellfire.framel.generic.x        = 0;
       s_hellfire.framel.generic.y        = 78;
       s_hellfire.framel.width            = 256;
       s_hellfire.framel.height           = 329;

       s_hellfire.framer.generic.type  = MTYPE_BITMAP;
       s_hellfire.framer.generic.name  = ART_FRAMER;
       s_hellfire.framer.generic.flags = QMF_INACTIVE;
       s_hellfire.framer.generic.x        = 0;
       s_hellfire.framer.generic.y        = 0;
       s_hellfire.framer.width            = 640;
       s_hellfire.framer.height           = 480;

       s_hellfire.frame.generic.type  = MTYPE_BITMAP;
       s_hellfire.frame.generic.name  = ART_FRAME;
       s_hellfire.frame.generic.flags = QMF_INACTIVE;
       s_hellfire.frame.generic.x        = 0;
       s_hellfire.frame.generic.y        = 0;
       s_hellfire.frame.width            = 640;
       s_hellfire.frame.height           = 480;

       y = 61; // 86
       /*
	y += BIGCHAR_HEIGHT+2+4;
       s_hellfire.lamebots.generic.type        = MTYPE_RADIOBUTTON;
       s_hellfire.lamebots.generic.name          = "Lame Bots:";
       s_hellfire.lamebots.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.lamebots.generic.callback    = Hellfire_Event;
       s_hellfire.lamebots.generic.id          = ID_LAMEBOTS;
       s_hellfire.lamebots.generic.x                 = Hellfire_X_POS;
       s_hellfire.lamebots.generic.y                 = y;
       */
       /*
       y += BIGCHAR_HEIGHT+2; // for reference now although not needed
       s_hellfire.startweaps.generic.type              = MTYPE_FIELD;
       s_hellfire.startweaps.generic.name             = "Start Weapons:";
       s_hellfire.startweaps.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.startweaps.field.maxchars             = 3;
       s_hellfire.startweaps.field.widthInChars        = 3;
       s_hellfire.startweaps.generic.callback          = Hellfire_Event;
       s_hellfire.startweaps.generic.id                = ID_STARTWEAPS;
       s_hellfire.startweaps.generic.x                    = Hellfire_X_POS;
       s_hellfire.startweaps.generic.y                    = y;
       */

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.starthealth.generic.type              = MTYPE_FIELD;
       s_hellfire.starthealth.generic.name             = "Starting Health:";
       s_hellfire.starthealth.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.starthealth.field.maxchars             = 3;
       s_hellfire.starthealth.field.widthInChars        = 3;
       s_hellfire.starthealth.generic.callback          = Hellfire_Event;
       s_hellfire.starthealth.generic.id                = ID_STARTHEALTH;
       s_hellfire.starthealth.generic.x                    = Hellfire_X_POS;
       s_hellfire.starthealth.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_hellfire.startarmor.generic.type              = MTYPE_FIELD;
       s_hellfire.startarmor.generic.name             = "Starting Armor:";
       s_hellfire.startarmor.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.startarmor.field.maxchars             = 3;
       s_hellfire.startarmor.field.widthInChars        = 3;
       s_hellfire.startarmor.generic.callback          = Hellfire_Event;
       s_hellfire.startarmor.generic.id                = ID_STARTARMOR;
       s_hellfire.startarmor.generic.x                    = Hellfire_X_POS;
       s_hellfire.startarmor.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_hellfire.maxhealth.generic.type              = MTYPE_FIELD;
       s_hellfire.maxhealth.generic.name             = "Maximum Health:";
       s_hellfire.maxhealth.generic.flags                     = QMF_NUMBERSONLY|QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.maxhealth.field.maxchars             = 3;
       s_hellfire.maxhealth.field.widthInChars        = 3;
       s_hellfire.maxhealth.generic.callback          = Hellfire_Event;
       s_hellfire.maxhealth.generic.id                = ID_MAXHEALTH;
       s_hellfire.maxhealth.generic.x                    = Hellfire_X_POS;
       s_hellfire.maxhealth.generic.y                    = y;

	y += BIGCHAR_HEIGHT+2;
       s_hellfire.music.generic.type              = MTYPE_SPINCONTROL;
       s_hellfire.music.generic.name             = "Play Music On Startup:";
       s_hellfire.music.generic.flags                     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.music.generic.callback          = Hellfire_Event;
       s_hellfire.music.generic.id                = ID_MUSIC;
       s_hellfire.music.generic.x                    = Hellfire_X_POS;
       s_hellfire.music.generic.y                    = y;
       s_hellfire.music.itemnames             = music_items;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.cachemaps.generic.type        = MTYPE_RADIOBUTTON;
       s_hellfire.cachemaps.generic.name          = "Cache All Maps:";
       s_hellfire.cachemaps.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_hellfire.cachemaps.generic.callback    = Hellfire_Event;
       s_hellfire.cachemaps.generic.id          = ID_CACHEMAPS;
       s_hellfire.cachemaps.generic.x                 = Hellfire_X_POS;
       s_hellfire.cachemaps.generic.y                 = y;

       y += BIGCHAR_HEIGHT+2+10;
       s_hellfire.gamemodes.generic.type     = MTYPE_PTEXT;
       s_hellfire.gamemodes.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.gamemodes.generic.callback = Hellfire_Event;
       s_hellfire.gamemodes.generic.id       = ID_GAMEMODES;
       s_hellfire.gamemodes.generic.x        = 320;
       s_hellfire.gamemodes.generic.y        = y;
       s_hellfire.gamemodes.string           = "Game Modes";
       s_hellfire.gamemodes.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.gamemodes.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.botoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.botoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.botoptions.generic.callback = Hellfire_Event;
       s_hellfire.botoptions.generic.id       = ID_BOTOPTIONS;
       s_hellfire.botoptions.generic.x        = 320;
       s_hellfire.botoptions.generic.y        = y;
       s_hellfire.botoptions.string           = "Bot Options";
       s_hellfire.botoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.botoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.hudoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.hudoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.hudoptions.generic.callback = Hellfire_Event;
       s_hellfire.hudoptions.generic.id       = ID_HUDOPTIONS;
       s_hellfire.hudoptions.generic.x        = 320;
       s_hellfire.hudoptions.generic.y        = y;
       s_hellfire.hudoptions.string           = "Hud Options";
       s_hellfire.hudoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.hudoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.camoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.camoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.camoptions.generic.callback = Hellfire_Event;
       s_hellfire.camoptions.generic.id       = ID_CAMOPTIONS;
       s_hellfire.camoptions.generic.x        = 320;
       s_hellfire.camoptions.generic.y        = y;
       s_hellfire.camoptions.string           = "Cam Options";
       s_hellfire.camoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.camoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.gameoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.gameoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.gameoptions.generic.callback = Hellfire_Event;
       s_hellfire.gameoptions.generic.id       = ID_GAMEOPTIONS;
       s_hellfire.gameoptions.generic.x        = 320;
       s_hellfire.gameoptions.generic.y        = y;
       s_hellfire.gameoptions.string           = "Game Options";
       s_hellfire.gameoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.gameoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.runeoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.runeoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.runeoptions.generic.callback = Hellfire_Event;
       s_hellfire.runeoptions.generic.id       = ID_RUNEOPTIONS;
       s_hellfire.runeoptions.generic.x        = 320;
       s_hellfire.runeoptions.generic.y        = y;
       s_hellfire.runeoptions.string           = "Rune Options";
       s_hellfire.runeoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.runeoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.weaponoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.weaponoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.weaponoptions.generic.callback = Hellfire_Event;
       s_hellfire.weaponoptions.generic.id       = ID_WEAPONOPTIONS;
       s_hellfire.weaponoptions.generic.x        = 320;
       s_hellfire.weaponoptions.generic.y        = y;
       s_hellfire.weaponoptions.string           = "Weapon Options";
       s_hellfire.weaponoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.weaponoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.powerups.generic.type     = MTYPE_PTEXT;
       s_hellfire.powerups.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.powerups.generic.callback = Hellfire_Event;
       s_hellfire.powerups.generic.id       = ID_POWERUP;
       s_hellfire.powerups.generic.x        = 320;
       s_hellfire.powerups.generic.y        = y;
       s_hellfire.powerups.string           = "Powerup Options";
       s_hellfire.powerups.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.powerups.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.startweapons.generic.type     = MTYPE_PTEXT;
       s_hellfire.startweapons.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.startweapons.generic.callback = Hellfire_Event;
       s_hellfire.startweapons.generic.id       = ID_STARTWEAPONS;
       s_hellfire.startweapons.generic.x        = 320;
       s_hellfire.startweapons.generic.y        = y;
       s_hellfire.startweapons.string           = "Starting Weapons";
       s_hellfire.startweapons.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.startweapons.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.campoptions.generic.type     = MTYPE_PTEXT;
       s_hellfire.campoptions.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.campoptions.generic.callback = Hellfire_Event;
       s_hellfire.campoptions.generic.id       = ID_CAMPOPTIONS;
       s_hellfire.campoptions.generic.x        = 320;
       s_hellfire.campoptions.generic.y        = y;
       s_hellfire.campoptions.string           = "Camping Protection";
       s_hellfire.campoptions.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.campoptions.color            = color_red;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.weaponconfig.generic.type     = MTYPE_PTEXT;
       s_hellfire.weaponconfig.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.weaponconfig.generic.callback = Hellfire_Event;
       s_hellfire.weaponconfig.generic.id       = ID_WEAPONCONFIG;
       s_hellfire.weaponconfig.generic.x        = 320;
       s_hellfire.weaponconfig.generic.y        = y;
       s_hellfire.weaponconfig.string           = "Weapons Configuration";
       s_hellfire.weaponconfig.style            = UI_CENTER|UI_SMALLFONT|UI_DROPSHADOW;
       s_hellfire.weaponconfig.color            = color_red;

	y += BIGCHAR_HEIGHT+2;
       s_hellfire.back.generic.type        = MTYPE_BITMAP;
       s_hellfire.back.generic.name     = ART_BACK0;
       s_hellfire.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.back.generic.callback = Hellfire_Event;
       s_hellfire.back.generic.id          = ID_BACK;
       s_hellfire.back.generic.x              = 0;
       s_hellfire.back.generic.y              = 475-64;
       s_hellfire.back.width               = 128;
       s_hellfire.back.height              = 64;
       s_hellfire.back.focuspic         = ART_BACK1;
       s_hellfire.back.generic.statusbar            = Hellfire_StatusBar2;

       s_hellfire.load.generic.type        = MTYPE_BITMAP;
       s_hellfire.load.generic.name     = ART_LOAD0;
       s_hellfire.load.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.load.generic.callback = Hellfire_Event;
       s_hellfire.load.generic.id          = ID_LOAD;
       s_hellfire.load.generic.x           = 128;
       s_hellfire.load.generic.y           = 475-64;
       s_hellfire.load.width               = 128;
       s_hellfire.load.height              = 64;
       s_hellfire.load.focuspic         = ART_LOAD1;
       s_hellfire.load.generic.statusbar            = Hellfire_StatusBar7;

       y += BIGCHAR_HEIGHT+2;
       s_hellfire.accept.generic.type        = MTYPE_BITMAP;
       s_hellfire.accept.generic.name     = ART_ACCEPT0;
       s_hellfire.accept.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.accept.generic.callback = Hellfire_Event;
       s_hellfire.accept.generic.id          = ID_ACCEPT;
       s_hellfire.accept.generic.x              = 512;
       s_hellfire.accept.generic.y              = 475-64;
       s_hellfire.accept.width               = 128;
       s_hellfire.accept.height              = 64;
       s_hellfire.accept.focuspic         = ART_ACCEPT1;
       s_hellfire.accept.generic.statusbar            = Hellfire_StatusBar3;

       s_hellfire.save.generic.type        = MTYPE_BITMAP;
       s_hellfire.save.generic.name     = ART_SAVE0;
       s_hellfire.save.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       s_hellfire.save.generic.callback = Hellfire_Event;
       s_hellfire.save.generic.id          = ID_SAVE;
       s_hellfire.save.generic.x           = 384;
       s_hellfire.save.generic.y           = 475-64;
       s_hellfire.save.width               = 128;
       s_hellfire.save.height              = 64;
       s_hellfire.save.focuspic         = ART_SAVE1;
       s_hellfire.save.generic.statusbar            = Hellfire_StatusBar8;

       Menu_AddItem( &s_hellfire.menu, &s_hellfire.banner );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.framel );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.framer );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.frame );

//       Menu_AddItem( &s_hellfire.menu, &s_hellfire.lamebots );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.starthealth );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.startarmor );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.maxhealth );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.music );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.cachemaps );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.gamemodes );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.botoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.hudoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.camoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.gameoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.runeoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.weaponoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.powerups );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.startweapons );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.campoptions );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.weaponconfig );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.back );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.load );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.save );
       Menu_AddItem( &s_hellfire.menu, &s_hellfire.accept );
       Hellfire_SetMenuItems();
	if ( !f ) {
		trap_Print( va( S_COLOR_RED "menu file not found: %s, using default\n", filename ) );
	}
       if ( len >= 204239 ) {
              trap_Print( va( S_COLOR_RED "menu file too large: %s is %i, max allowed is %i", filename, len, 0 ) );
		trap_FS_FCloseFile( f );
	}

	trap_FS_Read( buf, len, f );
	buf[len] = 0;
	trap_FS_FCloseFile( f );
//       Com_Printf("%s\n", buf);
}

/*
===============
Hellfire_Cache
===============
*/
void Hellfire_Cache( void ) {
	int		n;

	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
       trap_R_RegisterShaderNoMip( ART_FRAME );
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
	trap_R_RegisterShaderNoMip( ART_RESET0 );
	trap_R_RegisterShaderNoMip( ART_RESET1 );
	trap_R_RegisterShaderNoMip( ART_ACCEPT0 );
	trap_R_RegisterShaderNoMip( ART_ACCEPT1 );
       s_weaponconfig.picture = trap_R_RegisterShaderNoMip( ART_FRAME );
       s_weaponconfig2.picture = trap_R_RegisterShaderNoMip( ART_FRAME );
       s_weaponconfig.weaponshader = trap_R_RegisterShaderNoMip( "icons/iconw_shotgun");
       s_weaponconfig.weaponshader2 = trap_R_RegisterShaderNoMip( "icons/iconw_grenade");
       s_weaponconfig.weaponshader3 = trap_R_RegisterShaderNoMip( "icons/iconw_rocket");
       s_weaponconfig.weaponshader4 = trap_R_RegisterShaderNoMip( "icons/iconw_lightning");
       s_weaponconfig.weaponshader5 = trap_R_RegisterShaderNoMip( "icons/iconw_railgun");
       s_weaponconfig.weaponshader6 = trap_R_RegisterShaderNoMip( "icons/iconw_plasma");
       s_weaponconfig.weaponshader7 = trap_R_RegisterShaderNoMip( "icons/iconw_bfg");
}


/*
===============
UI_Preferences2Menu
===============
*/
void UI_Preferences2Menu( void ) {
       Hellfire_MenuInit();
       UI_PushMenu( &s_hellfire.menu );
}


