// Copyright (C) 1999-2000 Id Software, Inc.
//
#include "ui_local.h"

#define MODEL_BACK0			"menu/art/back_0"
#define MODEL_BACK1			"menu/art/back_1"
#define MODEL_SELECT		"menu/art/opponents_select"
#define MODEL_SELECTED		"menu/art/opponents_selected"
#define MODEL_FRAMEL		"menu/art/frame1_l"
#define MODEL_FRAMER		"menu/art/frame1_r"
#define MODEL_PORTS                "menu/art/player_models_port"
#define MODEL_ARROWS		"menu/art/gs_arrows_0"
#define MODEL_ARROWSL		"menu/art/gs_arrows_l"
#define MODEL_ARROWSR		"menu/art/gs_arrows_r"

#define LOW_MEMORY			(5 * 1024 * 1024)

static char* playermodel_artlist[] =
{
	MODEL_BACK0,	
	MODEL_BACK1,	
	MODEL_SELECT,
	MODEL_SELECTED,
//SKULL
/*
	MODEL_FRAMEL,
	MODEL_FRAMER,
*/
//END
       MODEL_PORTS, 
	MODEL_ARROWS,
	MODEL_ARROWSL,
	MODEL_ARROWSR,
	NULL
};

//SKULL
//Now 30 models instead of 16. almost x2
#define PLAYERGRID_COLS		6
#define PLAYERGRID_ROWS		5
//END
#define MAX_MODELSPERPAGE	(PLAYERGRID_ROWS*PLAYERGRID_COLS)

//SKULL
#define MAX_PLAYERMODELS	1024

static void PlayerModel_BuildList();
static void PlayerModel_SetMenuItems();
static void PlayerModel_PicEvent( void* ptr, int event );
//END

#define ID_PLAYERPIC0		0
#define ID_PLAYERPIC1		1
#define ID_PLAYERPIC2		2
#define ID_PLAYERPIC3		3
#define ID_PLAYERPIC4		4
#define ID_PLAYERPIC5		5
#define ID_PLAYERPIC6		6
#define ID_PLAYERPIC7		7
#define ID_PLAYERPIC8		8
#define ID_PLAYERPIC9		9
#define ID_PLAYERPIC10		10
#define ID_PLAYERPIC11		11
#define ID_PLAYERPIC12		12
#define ID_PLAYERPIC13		13
#define ID_PLAYERPIC14		14
#define ID_PLAYERPIC15		15
#define ID_PREVPAGE			100
#define ID_NEXTPAGE			101
#define ID_BACK				102
#define ID_MODELTYPE                      103
#define ID_SKINTYPE                      104
#define ID_MATCHPARTS                    105

typedef struct
{
	menuframework_s	menu;
	menubitmap_s	pics[MAX_MODELSPERPAGE];
	menubitmap_s	picbuttons[MAX_MODELSPERPAGE];
//SKULL
	//menubitmap_s	framel;
	//menubitmap_s	framer;
//       menubitmap_s       ports;
       qhandle_t     ports;
//END
	menutext_s		banner;
	menubitmap_s	back;
	menubitmap_s	player;
	menubitmap_s	arrows;
	menubitmap_s	left;
	menubitmap_s	right;
	menutext_s		modelname;
	menutext_s		skinname;
       menutext_s           headmodelname;
       menutext_s           headskinname;
       menutext_s           oldmodelname;
       menutext_s           oldskinname;
       menutext_s           headoldmodelname;
       menutext_s           headoldskinname;
       menutext_s           teammodelname;
       menutext_s           teamskinname;
       menutext_s           headteammodelname;
       menutext_s           headteamskinname;
	menutext_s		playername;
       menutext_s           modeltype2;
       menutext_s           skintype;
       menuradiobutton_s    matchparts;
	playerInfo_t	playerinfo;
	int				nummodels;
       int                         modeltype;
       int                         skintype2;
	char			modelnames[MAX_PLAYERMODELS][128];
	int				modelpage;
	int				numpages;
	char			modelskin[64];
       char                 headskin[64];
       char                 teammodelskin[64];
       char                 teamheadskin[64];
	int				selectedmodel;
       void                 (*draw)( void );
//SKULL
	char			modelfilter[128];
	int				oldmodelpage;
//END
} playermodel_t;

static playermodel_t s_playermodel;

/*
=================
PlayerModel_UpdateGrid
=================
*/
static void PlayerModel_UpdateGrid( void )
{
	int	i;
    int	j;

	j = s_playermodel.modelpage * MAX_MODELSPERPAGE;
	for (i=0; i<PLAYERGRID_ROWS*PLAYERGRID_COLS; i++,j++)
	{
		if (j < s_playermodel.nummodels)
		{ 
			// model/skin portrait
 			s_playermodel.pics[i].generic.name         = s_playermodel.modelnames[j];
			s_playermodel.picbuttons[i].generic.flags &= ~QMF_INACTIVE;
		}
		else
		{
			// dead slot
 			s_playermodel.pics[i].generic.name         = NULL;
			s_playermodel.picbuttons[i].generic.flags |= QMF_INACTIVE;
		}

 		s_playermodel.pics[i].generic.flags       &= ~QMF_HIGHLIGHT;
 		s_playermodel.pics[i].shader               = 0;
 		s_playermodel.picbuttons[i].generic.flags |= QMF_PULSEIFFOCUS;
	}

	if (s_playermodel.selectedmodel/MAX_MODELSPERPAGE == s_playermodel.modelpage)
	{
		// set selected model
		i = s_playermodel.selectedmodel % MAX_MODELSPERPAGE;

		s_playermodel.pics[i].generic.flags       |= QMF_HIGHLIGHT;
		s_playermodel.picbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;
	}

	if (s_playermodel.numpages > 1)
	{
		if (s_playermodel.modelpage > 0)
			s_playermodel.left.generic.flags &= ~QMF_INACTIVE;
		else
			s_playermodel.left.generic.flags |= QMF_INACTIVE;

		if (s_playermodel.modelpage < s_playermodel.numpages-1)
			s_playermodel.right.generic.flags &= ~QMF_INACTIVE;
		else
			s_playermodel.right.generic.flags |= QMF_INACTIVE;
	}
	else
	{
		// hide left/right markers
		s_playermodel.left.generic.flags |= QMF_INACTIVE;
		s_playermodel.right.generic.flags |= QMF_INACTIVE;
	}
//SKULL
	//Left button is always on in skin-view mode
	if (s_playermodel.modelfilter[0] != '\0') {
		s_playermodel.left.generic.flags &= ~QMF_INACTIVE;
	}
//END
}

/*
=================
PlayerModel_UpdateModel
=================
*/
static void PlayerModel_UpdateModel( void )
{
	vec3_t	viewangles;
	vec3_t	moveangles;

	memset( &s_playermodel.playerinfo, 0, sizeof(playerInfo_t) );
	
	viewangles[YAW]   = 180 - 30;
	viewangles[PITCH] = 0;
	viewangles[ROLL]  = 0;
	VectorClear( moveangles );
       if (s_playermodel.skintype2 == 0)
              UI_PlayerInfo_SetModel( &s_playermodel.playerinfo, s_playermodel.modelskin, s_playermodel.headskin );
       else if (s_playermodel.skintype2 == 1)
              UI_PlayerInfo_SetModel( &s_playermodel.playerinfo, s_playermodel.teammodelskin, s_playermodel.teamheadskin );
	UI_PlayerInfo_SetInfo( &s_playermodel.playerinfo, LEGS_IDLE, TORSO_STAND, viewangles, moveangles, WP_MACHINEGUN, qfalse );
}

/*
=================
PlayerModel_SaveChanges
=================
*/
static void PlayerModel_SaveChanges( void )
{
             trap_Cvar_Set( "team_model", s_playermodel.teammodelskin );
             trap_Cvar_Set( "team_headmodel", s_playermodel.teamheadskin );
             trap_Cvar_Set( "model", s_playermodel.modelskin );
             trap_Cvar_Set( "headmodel", s_playermodel.headskin );
             PlayerModel_SetMenuItems();
}

/*
=================
PlayerModel_MenuEvent
=================
*/
static void PlayerModel_MenuEvent( void* ptr, int event )
{
	int				modelnum;
	int				maxlen;
	char			modelskin[64];
       char                 headskin[64];
       char                 teammodelskin[64];
       char                 teamheadskin[64];
	char*			buffptr;
	char*			pdest;
       char                 searchmodelskin[64],*temp;
	int				i;

	if (event != QM_ACTIVATED)
		return;

	switch (((menucommon_s*)ptr)->id)
	{
		case ID_PREVPAGE:
			if (s_playermodel.modelpage > 0)
			{
				s_playermodel.modelpage--;
				PlayerModel_UpdateGrid();
			}
//SKULL
			//if in skin-view mode go back to model-view
			else if (s_playermodel.modelfilter[0] != '\0') {
				s_playermodel.modelfilter[0] = '\0';
				//Save model off
				PlayerModel_SaveChanges();
				//Rebuild the list
				PlayerModel_BuildList();
				PlayerModel_SetMenuItems();
				PlayerModel_UpdateGrid();
			}
//END
			break;

		case ID_NEXTPAGE:
			if (s_playermodel.modelpage < s_playermodel.numpages-1)
			{
				s_playermodel.modelpage++;
				PlayerModel_UpdateGrid();
			}
			break;

              case ID_MATCHPARTS:
                     if (s_playermodel.matchparts.curvalue == 1)
                            s_playermodel.modeltype2.generic.flags = QMF_CENTER_JUSTIFY|QMF_GRAYED;
                     else
                            s_playermodel.modeltype2.generic.flags = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
                     trap_Cvar_SetValue( "ui_matchparts", s_playermodel.matchparts.curvalue );
                     break;
		case ID_BACK:
			PlayerModel_SaveChanges();
			UI_PopMenu();
			break;
              case ID_MODELTYPE:
                     if (s_playermodel.modeltype == 0)
                     {
                            s_playermodel.modeltype2.string           = "Model Part : Head";
                            s_playermodel.modeltype = 1;
                     }
                     else if (s_playermodel.modeltype == 1)
                     {
                            s_playermodel.modeltype2.string           = "Model Part : Body";
                            s_playermodel.modeltype = 0;
                     }
                     break;
              case ID_SKINTYPE:
                     if (s_playermodel.skintype2 == 0)
                     {
                            s_playermodel.skintype.string           = "Game Type : Team/CTF";
                            s_playermodel.skintype2 = 1;
                            PlayerModel_SetMenuItems();
                            PlayerModel_UpdateGrid();
                            PlayerModel_UpdateModel();
                            trap_Cvar_VariableStringBuffer( "team_model", s_playermodel.teammodelskin, 64 );
                            trap_Cvar_VariableStringBuffer( "team_headmodel", s_playermodel.teamheadskin, 64 );
                            PlayerModel_UpdateModel();
                            Q_strncpyz( s_playermodel.oldmodelname.string, s_playermodel.modelname.string, 32 );
                            Q_strncpyz( s_playermodel.modelname.string, s_playermodel.teammodelname.string, 32 );
                            Q_strncpyz( s_playermodel.oldskinname.string, s_playermodel.skinname.string, 32 );
                            Q_strncpyz( s_playermodel.skinname.string, s_playermodel.teamskinname.string, 32 );
                            Q_strncpyz( s_playermodel.headoldmodelname.string, s_playermodel.headmodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headmodelname.string, s_playermodel.headteammodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headoldskinname.string, s_playermodel.headskinname.string, 32 );
                            Q_strncpyz( s_playermodel.headskinname.string, s_playermodel.headteamskinname.string, 32 );
                            // find model in our list
                     }
                     else if (s_playermodel.skintype2 == 1)
                     {
                            s_playermodel.skintype.string           = "Game Type : FFA/Tourney";
                            s_playermodel.skintype2 = 0;
                            PlayerModel_SetMenuItems();
                            PlayerModel_UpdateGrid();
                            PlayerModel_UpdateModel();
                            trap_Cvar_VariableStringBuffer( "model", s_playermodel.modelskin, 64 );
                            trap_Cvar_VariableStringBuffer( "headmodel", s_playermodel.headskin, 64 );
                            Q_strncpyz( s_playermodel.modelname.string, s_playermodel.oldmodelname.string, 32 );
                            Q_strncpyz( s_playermodel.skinname.string, s_playermodel.oldskinname.string, 32 );
                            Q_strncpyz( s_playermodel.headmodelname.string, s_playermodel.headoldmodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headskinname.string, s_playermodel.headoldskinname.string, 32 );
                     }
                     break;
	}
}

/*
=================
PlayerModel_MenuKey
=================
*/
static sfxHandle_t PlayerModel_MenuKey( int key )
{
	menucommon_s*	m;
	int				picnum;

	switch (key)
	{
		case K_KP_LEFTARROW:
		case K_LEFTARROW:
			m = Menu_ItemAtCursor(&s_playermodel.menu);
			picnum = m->id - ID_PLAYERPIC0;
			if (picnum >= 0 && picnum <= 15)
			{
				if (picnum > 0)
				{
					Menu_SetCursor(&s_playermodel.menu,s_playermodel.menu.cursor-1);
					return (menu_move_sound);
					
				}
				else if (s_playermodel.modelpage > 0)
				{
					s_playermodel.modelpage--;
					Menu_SetCursor(&s_playermodel.menu,s_playermodel.menu.cursor+15);
					PlayerModel_UpdateGrid();
					return (menu_move_sound);
				}
				else
					return (menu_buzz_sound);
			}
			break;

		case K_KP_RIGHTARROW:
		case K_RIGHTARROW:
			m = Menu_ItemAtCursor(&s_playermodel.menu);
			picnum = m->id - ID_PLAYERPIC0;
			if (picnum >= 0 && picnum <= 15)
			{
				if ((picnum < 15) && (s_playermodel.modelpage*MAX_MODELSPERPAGE + picnum+1 < s_playermodel.nummodels))
				{
					Menu_SetCursor(&s_playermodel.menu,s_playermodel.menu.cursor+1);
					return (menu_move_sound);
				}					
				else if ((picnum == 15) && (s_playermodel.modelpage < s_playermodel.numpages-1))
				{
					s_playermodel.modelpage++;
					Menu_SetCursor(&s_playermodel.menu,s_playermodel.menu.cursor-15);
					PlayerModel_UpdateGrid();
					return (menu_move_sound);
				}
				else
					return (menu_buzz_sound);
			}
			break;
			
		case K_MOUSE2:
		case K_ESCAPE:
			PlayerModel_SaveChanges();
//SKULL
			//If we're in skin view mode then go back to model view mode instead
			if (s_playermodel.modelfilter[0] != '\0')
			{
				s_playermodel.modelfilter[0] = '\0';
				//rebuild the list
				PlayerModel_BuildList();
				PlayerModel_SetMenuItems();
				s_playermodel.modelpage = s_playermodel.oldmodelpage;
				PlayerModel_UpdateGrid();
				return (menu_move_sound);
			}
//END
			break;
	}

	return ( Menu_DefaultKey( &s_playermodel.menu, key ) );
}

/*
=================
PlayerModel_PicEvent
=================
*/
static void PlayerModel_PicEvent( void* ptr, int event )
{
	int				modelnum;
	int				maxlen;
	char*			buffptr;
	char*			pdest;
	int				i;

	if (event != QM_ACTIVATED)
		return;

	for (i=0; i<PLAYERGRID_ROWS*PLAYERGRID_COLS; i++)
	{
		// reset
 		s_playermodel.pics[i].generic.flags       &= ~QMF_HIGHLIGHT;
 		s_playermodel.picbuttons[i].generic.flags |= QMF_PULSEIFFOCUS;
	}

	// set selected
	i = ((menucommon_s*)ptr)->id - ID_PLAYERPIC0;
	s_playermodel.pics[i].generic.flags       |= QMF_HIGHLIGHT;
	s_playermodel.picbuttons[i].generic.flags &= ~QMF_PULSEIFFOCUS;

	// get model and strip icon_
	modelnum = s_playermodel.modelpage*MAX_MODELSPERPAGE + i;
	buffptr  = s_playermodel.modelnames[modelnum] + strlen("models/players/");
	pdest    = strstr(buffptr,"icon_");
	if (pdest)
	{
//SKULL
		//Change to skin-view instead of selecting the model
		if (s_playermodel.modelfilter[0] == '\0') {
			// seperate the model name
			maxlen = pdest-buffptr;
			if (maxlen > 16)
				maxlen = 16;
			s_playermodel.oldmodelpage = s_playermodel.modelpage;
			Q_strncpyz( s_playermodel.modelfilter, buffptr, maxlen );
			Q_strupr( s_playermodel.modelfilter );
			//rebuild the list
			PlayerModel_BuildList();
			//if we're back to model view then there must be only one skin for this model
			if (s_playermodel.modelfilter[0] != '\0') {
				PlayerModel_SetMenuItems();
				PlayerModel_UpdateGrid();
				return;
			}
			else
				PlayerModel_BuildList();
		}
//END
		// track the whole model/skin name
              if (s_playermodel.modeltype == 0 || s_playermodel.matchparts.curvalue == 1)
              {
                     if (s_playermodel.skintype2 == 0)
                     {
                            Q_strncpyz(s_playermodel.modelskin,buffptr,pdest-buffptr+1);
                            strcat(s_playermodel.modelskin,pdest + 5);
                            // test
//                            Q_strncpyz(s_playermodel.headskin,buffptr,pdest-buffptr+1);
//                            strcat(s_playermodel.headskin,pdest + 5);
                     }
                     else if (s_playermodel.skintype2 == 1)
                     {
                            Q_strncpyz(s_playermodel.teammodelskin,buffptr,pdest-buffptr+1);
                            strcat(s_playermodel.teammodelskin,pdest + 5);
                     }
              }
              if (s_playermodel.modeltype == 1 || s_playermodel.matchparts.curvalue == 1)
              {
                     if (s_playermodel.skintype2 == 0)
                     {
                            Q_strncpyz(s_playermodel.headskin,buffptr,pdest-buffptr+1);
                            strcat(s_playermodel.headskin,pdest + 5);
                     }
                     else if (s_playermodel.skintype2 == 1)
                     {
                            Q_strncpyz(s_playermodel.teamheadskin,buffptr,pdest-buffptr+1);
                            strcat(s_playermodel.teamheadskin,pdest + 5);
                     }
              }

		// seperate the model name
		maxlen = pdest-buffptr;
		if (maxlen > 16)
			maxlen = 16;
              if (s_playermodel.modeltype == 1 || s_playermodel.matchparts.curvalue == 1)
              {
                     Q_strncpyz( s_playermodel.headmodelname.string, buffptr, maxlen );
                     Q_strupr( s_playermodel.headmodelname.string );
              }
              if (s_playermodel.modeltype == 0 || s_playermodel.matchparts.curvalue == 1)
              {
                     Q_strncpyz( s_playermodel.modelname.string, buffptr, maxlen );
                     Q_strupr( s_playermodel.modelname.string );
              }
		// seperate the skin name
		maxlen = strlen(pdest+5)+1;
		if (maxlen > 16)
			maxlen = 16;
              if (s_playermodel.modeltype == 1 || s_playermodel.matchparts.curvalue == 1)
              {
                     Q_strncpyz( s_playermodel.headskinname.string, pdest+5, maxlen );
                     Q_strupr( s_playermodel.headskinname.string );
              }
              if (s_playermodel.modeltype == 0 || s_playermodel.matchparts.curvalue == 1)
              {
                     Q_strncpyz( s_playermodel.skinname.string, pdest+5, maxlen );
                     Q_strupr( s_playermodel.skinname.string );
              }

		s_playermodel.selectedmodel = modelnum;

		if( trap_MemoryRemaining() > LOW_MEMORY ) {
			PlayerModel_UpdateModel();
		}
	}
       PlayerModel_SaveChanges();
}

/* q3app
=================
PlayerModel_DrawPorts
=================
*/
#define PORTS_POS_X 5
#define PORTS_POS_Y 59
static void PlayerModel_DrawPorts() {
int     x, y, i;
//     x = 5; x < 5+270; x+= 70
        for ( x = PORTS_POS_X; x < PORTS_POS_X + 415; x += 70 ) {
                for ( y = PORTS_POS_Y; y < PORTS_POS_Y + 345; y += 70 ) {
                        UI_DrawHandlePic( x, y, 64, 64, s_playermodel.ports );
                }
        }
}

/*
=================
PlayerModel_DrawPlayer
=================
*/
static void PlayerModel_DrawPlayer( void *self )
{
	menubitmap_s*	b;

	b = (menubitmap_s*) self;
	if( trap_MemoryRemaining() <= LOW_MEMORY ) {
		UI_DrawProportionalString( b->generic.x, b->generic.y + b->height / 2, "LOW MEMORY", UI_LEFT, color_red );
		return;
	}

	UI_DrawPlayer( b->generic.x, b->generic.y, b->width, b->height, &s_playermodel.playerinfo, uis.realtime/2 );
}

/*
=================
PlayerModel_BuildList
=================
*/
static void PlayerModel_BuildList( void )
{
	int		numdirs;
	int		numfiles;
	char	dirlist[2048];
	char	filelist[2048];
	char	skinname[64];
	char*	dirptr;
	char*	fileptr;
	int		i;
	int		j;
	int		dirlen;
	int		filelen;
	qboolean precache;

	precache = trap_Cvar_VariableValue("com_buildscript");

	s_playermodel.modelpage = 0;
	s_playermodel.nummodels = 0;

	// iterate directory of all player models
//SKULL
	//Filter directory if needed
	if (s_playermodel.modelfilter[0] != '\0')
	{
		numdirs = 1;
		strcpy(dirlist,s_playermodel.modelfilter);
	}
	else
//END
	numdirs = trap_FS_GetFileList("models/players", "/", dirlist, 2048 );
	dirptr  = dirlist;
	for (i=0; i<numdirs && s_playermodel.nummodels < MAX_PLAYERMODELS; i++,dirptr+=dirlen+1)
	{
		dirlen = strlen(dirptr);
		
		if (dirlen && dirptr[dirlen-1]=='/') dirptr[dirlen-1]='\0';

		if (!strcmp(dirptr,".") || !strcmp(dirptr,".."))
			continue;
			
		// iterate all skin files in directory
		numfiles = trap_FS_GetFileList( va("models/players/%s",dirptr), "tga", filelist, 2048 );
		fileptr  = filelist;
		for (j=0; j<numfiles && s_playermodel.nummodels < MAX_PLAYERMODELS;j++,fileptr+=filelen+1)
		{
			filelen = strlen(fileptr);

			COM_StripExtension(fileptr,skinname);
//SKULL
			//if in model mode we only load the default icon
			if (s_playermodel.modelfilter[0] == '\0')
			{
				// look for icon_default
				if (!Q_stricmpn(skinname,"icon_default",12))
				{
					Com_sprintf( s_playermodel.modelnames[s_playermodel.nummodels++],
						sizeof( s_playermodel.modelnames[s_playermodel.nummodels] ),
						"models/players/%s/%s", dirptr, skinname );
					if (s_playermodel.nummodels >= MAX_PLAYERMODELS)
						return;
				}
			} else {
				// look for icon_????
				if (!Q_stricmpn(skinname,"icon_",5))
				{
					Com_sprintf( s_playermodel.modelnames[s_playermodel.nummodels++],
						sizeof( s_playermodel.modelnames[s_playermodel.nummodels] ),
						"models/players/%s/%s", dirptr, skinname );
					if (s_playermodel.nummodels >= MAX_PLAYERMODELS)
						return;
				}
			}
//END
			if( precache ) {
				trap_S_RegisterSound( va( "sound/player/announce/%s_wins.wav", skinname), qfalse );
			}
		}
	}	
	//APSFIXME - Degenerate no models case

	s_playermodel.numpages = s_playermodel.nummodels/MAX_MODELSPERPAGE;
	if (s_playermodel.nummodels % MAX_MODELSPERPAGE)
		s_playermodel.numpages++;
//SKULL
	//If there is only one skin then select it and go back
	if ((s_playermodel.modelfilter[0] != '\0') && (s_playermodel.nummodels == 1)) {
		s_playermodel.modelfilter[0] = '\0';
	}
//END
}

/*
=================
PlayerModel_SetMenuItems
=================
*/
static void PlayerModel_SetMenuItems( void )
{
	int				i;
	int				maxlen;
//SKULL
	char			searchmodelskin[64],*temp;
       char                 headsearchmodelskin[64],*headtemp;
//END
	char			modelskin[64];
       char                 headskin[64];
       char                 teammodelskin[64];
       char                 teamheadskin[64];
	char*			buffptr;
	char*			pdest;

	s_playermodel.selectedmodel = MAX_MODELS;
	s_playermodel.modelpage     = 0;

	// name
	trap_Cvar_VariableStringBuffer( "name", s_playermodel.playername.string, 16 );
	Q_CleanStr( s_playermodel.playername.string );

	// model
       trap_Cvar_VariableStringBuffer( "team_model", s_playermodel.teammodelskin, 64 );
       trap_Cvar_VariableStringBuffer( "team_headmodel", s_playermodel.teamheadskin, 64 );
       trap_Cvar_VariableStringBuffer( "model", s_playermodel.modelskin, 64 );
       trap_Cvar_VariableStringBuffer( "headmodel", s_playermodel.headskin, 64 );
//SKULL
	//Create search string
       Q_strncpyz(searchmodelskin,s_playermodel.modelskin,64);
       Q_strncpyz(headsearchmodelskin,s_playermodel.headskin,64);
	if (s_playermodel.modelfilter[0] == '\0') {
		temp    = strchr(searchmodelskin,'/');
              headtemp = strchr(headsearchmodelskin,'/');
		if (temp)
			strcpy(temp+1,"default");
              if (headtemp)
                     strcpy(headtemp+1,"default");
	}
//END
	
	// find model in our list
	for (i=0; i<s_playermodel.nummodels; i++)
	{
		// strip icon_
		buffptr  = s_playermodel.modelnames[i] + strlen("models/players/");
		pdest    = strstr(buffptr,"icon_");
		if (pdest)
		{
                       Q_strncpyz(modelskin,buffptr,pdest-buffptr+1);
                       strcat(modelskin,pdest + 5);
		}
		else
			continue;

//SKULL
		//Search for the search string
              if (!Q_stricmp( searchmodelskin, modelskin ))
		{
//END
			// found pic, set selection here
                     s_playermodel.selectedmodel = i;
			s_playermodel.modelpage     = i/MAX_MODELSPERPAGE;

			// seperate the model name
			maxlen = pdest-buffptr;
			if (maxlen > 16)
				maxlen = 16;
			Q_strncpyz( s_playermodel.modelname.string, buffptr, maxlen );
			Q_strupr( s_playermodel.modelname.string );

//SKULL
			//If in model view mode we must pull the skin name from the players model, not the list of models to select
			if (s_playermodel.modelfilter[0] == '\0') {
                            temp = strchr(s_playermodel.modelskin,'/');
				if (temp)
					pdest = temp + 1;
			} else
				pdest+=5;
			// seperate the skin name
			maxlen = strlen(pdest)+1;
			if (maxlen > 16)
				maxlen = 16;
			Q_strncpyz( s_playermodel.skinname.string, pdest, maxlen );
			Q_strupr( s_playermodel.skinname.string );
//END
			break;
		}
       }
	for (i=0; i<s_playermodel.nummodels; i++)
	{
		// strip icon_
		buffptr  = s_playermodel.modelnames[i] + strlen("models/players/");
		pdest    = strstr(buffptr,"icon_");
		if (pdest)
		{
                       Q_strncpyz(headskin,buffptr,pdest-buffptr+1);
                       strcat(headskin,pdest + 5);
		}
		else
			continue;

              if (!Q_stricmp( headsearchmodelskin, headskin ))
		{
//END
			// found pic, set selection here
                     s_playermodel.selectedmodel = i;
			s_playermodel.modelpage     = i/MAX_MODELSPERPAGE;

			// seperate the model name
			maxlen = pdest-buffptr;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.headmodelname.string, buffptr, maxlen );
                     Q_strupr( s_playermodel.headmodelname.string );

//SKULL
			//If in model view mode we must pull the skin name from the players model, not the list of models to select
			if (s_playermodel.modelfilter[0] == '\0') {
                            temp = strchr(s_playermodel.headskin,'/');
				if (temp)
					pdest = temp + 1;
			} else
				pdest+=5;
			// seperate the skin name
			maxlen = strlen(pdest)+1;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.headskinname.string, pdest, maxlen );
                     Q_strupr( s_playermodel.headskinname.string );
//END
			break;
		}
       }
// team models start here 
	//Create search string
       Q_strncpyz(searchmodelskin,s_playermodel.teammodelskin,64);
	if (s_playermodel.modelfilter[0] == '\0') {
		temp    = strchr(searchmodelskin,'/');
		if (temp)
			strcpy(temp+1,"default");
	}
//END
//SKULL
	// find model in our list
	for (i=0; i<s_playermodel.nummodels; i++)
	{
		// strip icon_
		buffptr  = s_playermodel.modelnames[i] + strlen("models/players/");
		pdest    = strstr(buffptr,"icon_");
		if (pdest)
		{
                       Q_strncpyz(modelskin,buffptr,pdest-buffptr+1);
                       strcat(modelskin,pdest + 5);
		}
		else
			continue;

//SKULL
		//Search for the search string
              if (!Q_stricmp( searchmodelskin, modelskin ))
		{
//END
			// found pic, set selection here
                     if (s_playermodel.skintype2 == 1)
                     {
                            s_playermodel.selectedmodel = i;
                            s_playermodel.modelpage     = i/MAX_MODELSPERPAGE;
                     }

			// seperate the model name
			maxlen = pdest-buffptr;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.teammodelname.string, buffptr, maxlen );
                     Q_strupr( s_playermodel.teammodelname.string );

//SKULL
			//If in model view mode we must pull the skin name from the players model, not the list of models to select
			if (s_playermodel.modelfilter[0] == '\0') {
                            temp = strchr(s_playermodel.teammodelskin,'/');
				if (temp)
					pdest = temp + 1;
			} else
				pdest+=5;
			// seperate the skin name
			maxlen = strlen(pdest)+1;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.teamskinname.string, pdest, maxlen );
                     Q_strupr( s_playermodel.teamskinname.string );
//END
			break;
		}
	}
       Q_strncpyz(headsearchmodelskin,s_playermodel.teamheadskin,64);
	if (s_playermodel.modelfilter[0] == '\0') {
              headtemp    = strchr(headsearchmodelskin,'/');
              if (headtemp)
                     strcpy(headtemp+1,"default");
	}
//END
//SKULL
	// find model in our list
	for (i=0; i<s_playermodel.nummodels; i++)
	{
		// strip icon_
		buffptr  = s_playermodel.modelnames[i] + strlen("models/players/");
		pdest    = strstr(buffptr,"icon_");
		if (pdest)
		{
                       Q_strncpyz(headskin,buffptr,pdest-buffptr+1);
                       strcat(headskin,pdest + 5);
		}
		else
			continue;

//SKULL
		//Search for the search string
              if (!Q_stricmp( headsearchmodelskin, headskin ))
		{
//END
			// found pic, set selection here
                     if (s_playermodel.skintype2 == 1)
                     {
                            s_playermodel.selectedmodel = i;
                            s_playermodel.modelpage     = i/MAX_MODELSPERPAGE;
                     }

			// seperate the model name
			maxlen = pdest-buffptr;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.headteammodelname.string, buffptr, maxlen );
                     Q_strupr( s_playermodel.headteammodelname.string );

//SKULL
			//If in model view mode we must pull the skin name from the players model, not the list of models to select
			if (s_playermodel.modelfilter[0] == '\0') {
                            headtemp = strchr(s_playermodel.teamheadskin,'/');
                            if (headtemp)
                                   pdest = headtemp + 1;
			} else
				pdest+=5;
			// seperate the skin name
			maxlen = strlen(pdest)+1;
			if (maxlen > 16)
				maxlen = 16;
                     Q_strncpyz( s_playermodel.headteamskinname.string, pdest, maxlen );
                     Q_strupr( s_playermodel.headteamskinname.string );
//END
			break;
		}
	}
       if (Com_Clamp( 0, 4, (int)trap_Cvar_VariableValue( "g_gametype" )) >= 2 || s_playermodel.skintype2 == 1)
       {
              s_playermodel.skintype2 = 1;
              s_playermodel.skintype.string           = "Game Type : Team/CTF";
              trap_Cvar_VariableStringBuffer( "team_model", s_playermodel.teammodelskin, 64 );
              trap_Cvar_VariableStringBuffer( "team_headmodel", s_playermodel.teamheadskin, 64 );
              PlayerModel_UpdateModel();
              Q_strncpyz( s_playermodel.oldmodelname.string, s_playermodel.modelname.string, 32 );
              Q_strncpyz( s_playermodel.modelname.string, s_playermodel.teammodelname.string, 32 );
              Q_strncpyz( s_playermodel.oldskinname.string, s_playermodel.skinname.string, 32 );
              Q_strncpyz( s_playermodel.skinname.string, s_playermodel.teamskinname.string, 32 );

                            Q_strncpyz( s_playermodel.headoldmodelname.string, s_playermodel.headmodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headmodelname.string, s_playermodel.headteammodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headoldskinname.string, s_playermodel.headskinname.string, 32 );
                            Q_strncpyz( s_playermodel.headskinname.string, s_playermodel.headteamskinname.string, 32 );

       }
       else if (s_playermodel.skintype2 == 1)
       {
              s_playermodel.skintype.string           = "Game Type : FFA/Tourney";
              s_playermodel.skintype2 = 0;
              trap_Cvar_VariableStringBuffer( "model", s_playermodel.modelskin, 64 );
              trap_Cvar_VariableStringBuffer( "headmodel", s_playermodel.headskin, 64 );
              PlayerModel_UpdateModel();
              Q_strncpyz( s_playermodel.modelname.string, s_playermodel.oldmodelname.string, 32 );
              Q_strncpyz( s_playermodel.skinname.string, s_playermodel.oldskinname.string, 32 );
                            Q_strncpyz( s_playermodel.headmodelname.string, s_playermodel.headoldmodelname.string, 32 );
                            Q_strncpyz( s_playermodel.headskinname.string, s_playermodel.headoldskinname.string, 32 );
       }
       s_playermodel.ports = trap_R_RegisterShaderNoMip( MODEL_PORTS );
}

static void Draw_Stuff(void) {
       PlayerModel_DrawPorts();
       Menu_Draw( &s_playermodel.menu );

       if( s_playermodel.draw ) {
              s_playermodel.draw();
       }
}

/*
=================
PlayerModel_MenuInit
=================
*/
static void PlayerModel_MenuInit( void )
{
	int			i;
	int			j;
	int			k;
	int			x;
	int			y;
	static char	playername[32];
	static char	modelname[32];
	static char	skinname[32];
       static char   teammodelname[32];
       static char   teamskinname[32];
       static char   oldmodelname[32];
       static char   oldskinname[32];
       static char   headmodelname[32];
       static char   headoldmodelname[32];
       static char   headoldskinname[32];
       static char   headteammodelname[32];
       static char   headteamskinname[32];
       static char   headskinname[32];

	// zero set all our globals
	memset( &s_playermodel, 0 ,sizeof(playermodel_t) );

	PlayerModel_Cache();

	s_playermodel.menu.key        = PlayerModel_MenuKey;
	s_playermodel.menu.wrapAround = qtrue;
	s_playermodel.menu.fullscreen = qtrue;
       s_playermodel.menu.draw = Draw_Stuff;

       s_playermodel.banner.generic.type  = MTYPE_PTEXT;
       s_playermodel.banner.generic.x     = 228;
	s_playermodel.banner.generic.y     = 6;
	s_playermodel.banner.string        = "PLAYER MODEL";
       s_playermodel.banner.color         = color_orange;
       s_playermodel.banner.style         = UI_CENTER|UI_SMALLFONT;

//SKULL
/*	s_playermodel.framel.generic.type  = MTYPE_BITMAP;
	s_playermodel.framel.generic.name  = MODEL_FRAMEL;
	s_playermodel.framel.generic.flags = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_playermodel.framel.generic.x     = 0;
	s_playermodel.framel.generic.y     = 78;
	s_playermodel.framel.width         = 256;
	s_playermodel.framel.height        = 329;

	s_playermodel.framer.generic.type  = MTYPE_BITMAP;
	s_playermodel.framer.generic.name  = MODEL_FRAMER;
	s_playermodel.framer.generic.flags = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_playermodel.framer.generic.x     = 376;
	s_playermodel.framer.generic.y     = 76;
	s_playermodel.framer.width         = 256;
	s_playermodel.framer.height        = 334;
*/
/*
	s_playermodel.ports.generic.type  = MTYPE_BITMAP;
	s_playermodel.ports.generic.name  = MODEL_PORTS;
	s_playermodel.ports.generic.flags = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
	s_playermodel.ports.generic.x     = 50;
	s_playermodel.ports.generic.y     = 59;
	s_playermodel.ports.width         = 274;
       s_playermodel.ports.height        = 274;
*/
//END

	y =	59;
	for (i=0,k=0; i<PLAYERGRID_ROWS; i++)
	{
//SKULL
		x =	5;
//END
		for (j=0; j<PLAYERGRID_COLS; j++,k++)
		{
			s_playermodel.pics[k].generic.type	   = MTYPE_BITMAP;
			s_playermodel.pics[k].generic.flags    = QMF_LEFT_JUSTIFY|QMF_INACTIVE;
			s_playermodel.pics[k].generic.x		   = x;
			s_playermodel.pics[k].generic.y		   = y;
			s_playermodel.pics[k].width  		   = 64;
			s_playermodel.pics[k].height  		   = 64;
			s_playermodel.pics[k].focuspic         = MODEL_SELECTED;
			s_playermodel.pics[k].focuscolor       = colorRed;

			s_playermodel.picbuttons[k].generic.type	 = MTYPE_BITMAP;
			s_playermodel.picbuttons[k].generic.flags    = QMF_LEFT_JUSTIFY|QMF_NODEFAULTINIT|QMF_PULSEIFFOCUS;
			s_playermodel.picbuttons[k].generic.id	     = ID_PLAYERPIC0+k;
			s_playermodel.picbuttons[k].generic.callback = PlayerModel_PicEvent;
			s_playermodel.picbuttons[k].generic.x    	 = x - 16;
			s_playermodel.picbuttons[k].generic.y		 = y - 16;
			s_playermodel.picbuttons[k].generic.left	 = x;
			s_playermodel.picbuttons[k].generic.top		 = y;
			s_playermodel.picbuttons[k].generic.right	 = x + 64;
			s_playermodel.picbuttons[k].generic.bottom   = y + 64;
			s_playermodel.picbuttons[k].width  		     = 128;
			s_playermodel.picbuttons[k].height  		 = 128;
			s_playermodel.picbuttons[k].focuspic  		 = MODEL_SELECT;
			s_playermodel.picbuttons[k].focuscolor  	 = colorRed;

			x += 64+6;
		}
		y += 64+6;
	}

       s_playermodel.modeltype2.generic.type  = MTYPE_PTEXT;
       s_playermodel.modeltype2.generic.flags = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_playermodel.modeltype2.generic.x    = 228;
       s_playermodel.modeltype2.generic.y    = 410;
       s_playermodel.modeltype2.generic.callback = PlayerModel_MenuEvent;
       s_playermodel.modeltype2.generic.id       = ID_MODELTYPE;
       s_playermodel.modeltype2.string           = "Model Part : Body";
       s_playermodel.modeltype2.style               = UI_CENTER|UI_SMALLFONT;
       s_playermodel.modeltype2.color         = color_red;

       s_playermodel.skintype.generic.type  = MTYPE_PTEXT;
       s_playermodel.skintype.generic.flags = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_playermodel.skintype.generic.x    = 228;
       s_playermodel.skintype.generic.y    = 24;
       s_playermodel.skintype.generic.callback = PlayerModel_MenuEvent;
       s_playermodel.skintype.generic.id       = ID_SKINTYPE;
       s_playermodel.skintype.string           = "Game Type : FFA/Tourney";
       s_playermodel.skintype.style               = UI_CENTER|UI_SMALLFONT;
       s_playermodel.skintype.color         = color_red;

	s_playermodel.playername.generic.type  = MTYPE_PTEXT;
	s_playermodel.playername.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.playername.generic.x    = 228;
       s_playermodel.playername.generic.y    = 410;
	s_playermodel.playername.string	       = playername;
	s_playermodel.playername.style		   = UI_CENTER;
	s_playermodel.playername.color         = text_color_normal;

	s_playermodel.modelname.generic.type  = MTYPE_PTEXT;
	s_playermodel.modelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
	s_playermodel.modelname.generic.x	  = 497;
       s_playermodel.modelname.generic.y    = 446-BIGCHAR_HEIGHT-2; // 34
	s_playermodel.modelname.string	      = modelname;
       s_playermodel.modelname.style               = UI_CENTER|UI_SMALLFONT;
	s_playermodel.modelname.color         = text_color_normal;

       s_playermodel.skinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.skinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.skinname.generic.x     = 497;
       s_playermodel.skinname.generic.y     = 450;
       s_playermodel.skinname.string            = skinname;
       s_playermodel.skinname.style                = UI_CENTER|UI_SMALLFONT;
       s_playermodel.skinname.color          = text_color_normal;

       s_playermodel.headmodelname.generic.type  = MTYPE_PTEXT;
       s_playermodel.headmodelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headmodelname.generic.x    = 497;
       s_playermodel.headmodelname.generic.y    = 34; // 34
       s_playermodel.headmodelname.string           = headmodelname;
       s_playermodel.headmodelname.style               = UI_CENTER|UI_SMALLFONT;
       s_playermodel.headmodelname.color         = text_color_normal;

       s_playermodel.headskinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.headskinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headskinname.generic.x     = 497;
       s_playermodel.headskinname.generic.y     = 38+BIGCHAR_HEIGHT+2;
       s_playermodel.headskinname.string            = headskinname;
       s_playermodel.headskinname.style                = UI_CENTER|UI_SMALLFONT;
       s_playermodel.headskinname.color          = text_color_normal;

       s_playermodel.teammodelname.generic.type  = MTYPE_PTEXT;
       s_playermodel.teammodelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.teammodelname.generic.x    = 497;
       s_playermodel.teammodelname.generic.y    = 34; // 54
       s_playermodel.teammodelname.string           = teammodelname;
       s_playermodel.teammodelname.style               = UI_CENTER|UI_SMALLFONT;
       s_playermodel.teammodelname.color         = text_color_normal;

       s_playermodel.headteammodelname.generic.type  = MTYPE_PTEXT;
       s_playermodel.headteammodelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headteammodelname.generic.x    = 497;
       s_playermodel.headteammodelname.generic.y    = 34; // 54
       s_playermodel.headteammodelname.string           = headteammodelname;
       s_playermodel.headteammodelname.style               = UI_CENTER|UI_SMALLFONT;
       s_playermodel.headteammodelname.color         = text_color_normal;

       s_playermodel.oldmodelname.generic.type  = MTYPE_PTEXT;
       s_playermodel.oldmodelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.oldmodelname.generic.x    = 497;
       s_playermodel.oldmodelname.generic.y    = 34; // 54
       s_playermodel.oldmodelname.string           = oldmodelname;
       s_playermodel.oldmodelname.style               = UI_CENTER;
       s_playermodel.oldmodelname.color         = text_color_normal;

       s_playermodel.headoldmodelname.generic.type  = MTYPE_PTEXT;
       s_playermodel.headoldmodelname.generic.flags = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headoldmodelname.generic.x    = 497;
       s_playermodel.headoldmodelname.generic.y    = 34; // 54
       s_playermodel.headoldmodelname.string           = headoldmodelname;
       s_playermodel.headoldmodelname.style               = UI_CENTER;
       s_playermodel.headoldmodelname.color         = text_color_normal;

       s_playermodel.teamskinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.teamskinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.teamskinname.generic.x     = 497;
       s_playermodel.teamskinname.generic.y     = 440;
       s_playermodel.teamskinname.string            = teamskinname;
       s_playermodel.teamskinname.style                = UI_CENTER;
       s_playermodel.teamskinname.color          = text_color_normal;

       s_playermodel.headteamskinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.headteamskinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headteamskinname.generic.x     = 497;
       s_playermodel.headteamskinname.generic.y     = 440;
       s_playermodel.headteamskinname.string            = headteamskinname;
       s_playermodel.headteamskinname.style                = UI_CENTER;
       s_playermodel.headteamskinname.color          = text_color_normal;

       s_playermodel.oldskinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.oldskinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.oldskinname.generic.x     = 497;
       s_playermodel.oldskinname.generic.y     = 440;
       s_playermodel.oldskinname.string            = oldskinname;
       s_playermodel.oldskinname.style                = UI_CENTER;
       s_playermodel.oldskinname.color          = text_color_normal;

       s_playermodel.headoldskinname.generic.type   = MTYPE_PTEXT;
       s_playermodel.headoldskinname.generic.flags  = QMF_CENTER_JUSTIFY|QMF_INACTIVE;
       s_playermodel.headoldskinname.generic.x     = 497;
       s_playermodel.headoldskinname.generic.y     = 440;
       s_playermodel.headoldskinname.string            = headoldskinname;
       s_playermodel.headoldskinname.style                = UI_CENTER;
       s_playermodel.headoldskinname.color          = text_color_normal;

	s_playermodel.player.generic.type      = MTYPE_BITMAP;
	s_playermodel.player.generic.flags     = QMF_INACTIVE;
	s_playermodel.player.generic.ownerdraw = PlayerModel_DrawPlayer;
	s_playermodel.player.generic.x	       = 400;
	s_playermodel.player.generic.y	       = -40;
	s_playermodel.player.width	           = 32*10;
	s_playermodel.player.height            = 56*10;

       s_playermodel.matchparts.generic.type        = MTYPE_RADIOBUTTON;
       s_playermodel.matchparts.generic.name          = "Match Parts:";
       s_playermodel.matchparts.generic.flags         = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
       s_playermodel.matchparts.generic.callback    = PlayerModel_MenuEvent;
       s_playermodel.matchparts.generic.id          = ID_MATCHPARTS;
       s_playermodel.matchparts.generic.x                 = 288+61;
       s_playermodel.matchparts.generic.y                 = 445;

	s_playermodel.arrows.generic.type		= MTYPE_BITMAP;
	s_playermodel.arrows.generic.name		= MODEL_ARROWS;
	s_playermodel.arrows.generic.flags		= QMF_INACTIVE;
       s_playermodel.arrows.generic.x                   = 118; // 168
	s_playermodel.arrows.generic.y			= 440;
       s_playermodel.arrows.width                       = 128;
	s_playermodel.arrows.height				= 32;

	s_playermodel.left.generic.type			= MTYPE_BITMAP;
	s_playermodel.left.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_playermodel.left.generic.callback		= PlayerModel_MenuEvent;
	s_playermodel.left.generic.id			= ID_PREVPAGE;
       s_playermodel.left.generic.x                     = 118; // 168
	s_playermodel.left.generic.y			= 440;
	s_playermodel.left.width  				= 64;
       s_playermodel.left.height                        = 32;
	s_playermodel.left.focuspic				= MODEL_ARROWSL;

	s_playermodel.right.generic.type	    = MTYPE_BITMAP;
	s_playermodel.right.generic.flags		= QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_playermodel.right.generic.callback	= PlayerModel_MenuEvent;
	s_playermodel.right.generic.id			= ID_NEXTPAGE;
       s_playermodel.right.generic.x                    = 118+61; // 168+61
//SKULL
	s_playermodel.right.generic.y			= 440;
//END
	s_playermodel.right.width  				= 64;
	s_playermodel.right.height  		    = 32;
	s_playermodel.right.focuspic			= MODEL_ARROWSR;

	s_playermodel.back.generic.type	    = MTYPE_BITMAP;
	s_playermodel.back.generic.name     = MODEL_BACK0;
	s_playermodel.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_playermodel.back.generic.callback = PlayerModel_MenuEvent;
	s_playermodel.back.generic.id	    = ID_BACK;
	s_playermodel.back.generic.x		= 0;
       s_playermodel.back.generic.y              = 475-64;
	s_playermodel.back.width  		    = 128;
	s_playermodel.back.height  		    = 64;
	s_playermodel.back.focuspic         = MODEL_BACK1;

	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.banner );
//SKULL
/*	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.framel );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.framer );
*/
//       Menu_AddItem( &s_playermodel.menu, &s_playermodel.ports );
//END
//       Menu_AddItem( &s_playermodel.menu, &s_playermodel.playername );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.modelname );
       Menu_AddItem( &s_playermodel.menu, &s_playermodel.headmodelname );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.skinname );
       Menu_AddItem( &s_playermodel.menu, &s_playermodel.headskinname );
       Menu_AddItem( &s_playermodel.menu, &s_playermodel.modeltype2 );
       Menu_AddItem( &s_playermodel.menu, &s_playermodel.skintype );

	for (i=0; i<MAX_MODELSPERPAGE; i++)
	{
		Menu_AddItem( &s_playermodel.menu,	&s_playermodel.pics[i] );
		Menu_AddItem( &s_playermodel.menu,	&s_playermodel.picbuttons[i] );
	}
       Menu_AddItem( &s_playermodel.menu, &s_playermodel.matchparts );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.player );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.arrows );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.left );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.right );
	Menu_AddItem( &s_playermodel.menu,	&s_playermodel.back );
       s_playermodel.matchparts.curvalue        = trap_Cvar_VariableValue( "ui_matchparts" ) != 0;
       if (s_playermodel.matchparts.curvalue == 1)
             s_playermodel.modeltype2.generic.flags = QMF_CENTER_JUSTIFY|QMF_GRAYED;
       else
              s_playermodel.modeltype2.generic.flags = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	// find all available models
//	PlayerModel_BuildList();

	// set initial states
	PlayerModel_SetMenuItems();

	// update user interface
	PlayerModel_UpdateGrid();
	PlayerModel_UpdateModel();
}

/*
=================
PlayerModel_Cache
=================
*/
void PlayerModel_Cache( void )
{
	int	i;

	for( i = 0; playermodel_artlist[i]; i++ ) {
		trap_R_RegisterShaderNoMip( playermodel_artlist[i] );
	}
//SKULL
	s_playermodel.modelfilter[0] = '\0';
//END

	PlayerModel_BuildList();
	for( i = 0; i < s_playermodel.nummodels; i++ ) {
		trap_R_RegisterShaderNoMip( s_playermodel.modelnames[i] );
	}
}

void UI_PlayerModelMenu(void)
{
	PlayerModel_MenuInit();

	UI_PushMenu( &s_playermodel.menu );

       Menu_SetCursorToItem( &s_playermodel.menu, &s_playermodel.pics[s_playermodel.selectedmodel % MAX_MODELSPERPAGE] );
}


