// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=============================================================================

SAVE CONFIG MENU

=============================================================================
*/

#include "ui_local.h"


#define ART_BACK0			"menu/art/back_0"
#define ART_BACK1			"menu/art/back_1"	
#define ART_SAVE0			"menu/art/save_0"
#define ART_SAVE1			"menu/art/save_1"
#define ART_BACKGROUND		"menu/art/cut_frame"
#define ART_FRAME                 "menu/art/frame"

#define ID_NAME			10
#define ID_BACK			11
#define ID_SAVE			12


typedef struct {
	menuframework_s	menu;

	menutext_s		banner;
	menubitmap_s	background;
	menufield_s		savename;
	menubitmap_s	back;
       menubitmap_s  frame;
	menubitmap_s	save;
} oldsaveConfig_t;

static oldsaveConfig_t         oldsaveConfig;


/*
===============
UI_OldSaveConfigMenu_BackEvent
===============
*/
static void UI_OldSaveConfigMenu_BackEvent( void *ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}

	UI_PopMenu();
}


/*
===============
UI_OldSaveConfigMenu_SaveEvent
===============
*/
static void UI_OldSaveConfigMenu_SaveEvent( void *ptr, int event ) {
	char	configname[MAX_QPATH];

	if( event != QM_ACTIVATED ) {
		return;
	}

       if( !oldsaveConfig.savename.field.buffer[0] ) {
		return;
	}

       COM_StripExtension(oldsaveConfig.savename.field.buffer, configname );
       trap_Cmd_ExecuteText( EXEC_APPEND, va( "writeconfig configs/%s.cfg\n", configname ) );
	UI_PopMenu();
}


/*
===============
UI_OldSaveConfigMenu_SavenameDraw
===============
*/
static void UI_OldSaveConfigMenu_SavenameDraw( void *self ) {
	menufield_s		*f;
	int				style;
	float			*color;

	f = (menufield_s *)self;

       if( f == Menu_ItemAtCursor( &oldsaveConfig.menu ) ) {
		style = UI_LEFT|UI_PULSE|UI_SMALLFONT;
		color = text_color_highlight;
	}
	else {
		style = UI_LEFT|UI_SMALLFONT;
		color = colorRed;
	}

	UI_DrawProportionalString( 320, 192, "Enter filename:", UI_CENTER|UI_SMALLFONT, color_orange );
	UI_FillRect( f->generic.x, f->generic.y, f->field.widthInChars*SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, colorBlack );
	MField_Draw( &f->field, f->generic.x, f->generic.y, style, color );
}


/*
=================
UI_OldSaveConfigMenu_Init
=================
*/
static void UI_OldSaveConfigMenu_Init( void ) {
       memset( &oldsaveConfig, 0, sizeof(oldsaveConfig) );

       UI_OldSaveConfigMenu_Cache();
       oldsaveConfig.menu.wrapAround = qtrue;
       oldsaveConfig.menu.fullscreen = qtrue;

       oldsaveConfig.banner.generic.type            = MTYPE_BTEXT;
       oldsaveConfig.banner.generic.x               = 320;
       oldsaveConfig.banner.generic.y               = 16;
       oldsaveConfig.banner.string                  = "SAVE CONFIG";
       oldsaveConfig.banner.color                          = color_white;
       oldsaveConfig.banner.style                          = UI_CENTER;

       oldsaveConfig.frame.generic.type      = MTYPE_BITMAP;
       oldsaveConfig.frame.generic.name      = ART_FRAME;
       oldsaveConfig.frame.generic.flags     = QMF_INACTIVE;
       oldsaveConfig.frame.generic.x         = 0;
       oldsaveConfig.frame.generic.y         = 0;
       oldsaveConfig.frame.width                    = 640;
       oldsaveConfig.frame.height                   = 480;

       oldsaveConfig.background.generic.type        = MTYPE_BITMAP;
       oldsaveConfig.background.generic.name        = ART_BACKGROUND;
       oldsaveConfig.background.generic.flags              = QMF_INACTIVE;
       oldsaveConfig.background.generic.x                  = 142;
       oldsaveConfig.background.generic.y                  = 118;
       oldsaveConfig.background.width                      = 359;
       oldsaveConfig.background.height                     = 256;

       oldsaveConfig.savename.generic.type          = MTYPE_FIELD;
       oldsaveConfig.savename.generic.flags         = QMF_NODEFAULTINIT|QMF_UPPERCASE;
       oldsaveConfig.savename.generic.ownerdraw     = UI_OldSaveConfigMenu_SavenameDraw;
       oldsaveConfig.savename.field.widthInChars    = 20;
       oldsaveConfig.savename.field.maxchars        = 20;
       oldsaveConfig.savename.generic.x                    = 240;
       oldsaveConfig.savename.generic.y                    = 155+72;
       oldsaveConfig.savename.generic.left          = 240;
       oldsaveConfig.savename.generic.top                  = 155+72;
       oldsaveConfig.savename.generic.right         = 233 + 20*SMALLCHAR_WIDTH;
       oldsaveConfig.savename.generic.bottom        = 155+72 + SMALLCHAR_HEIGHT+2;

       oldsaveConfig.back.generic.type              = MTYPE_BITMAP;
       oldsaveConfig.back.generic.name              = ART_BACK0;
       oldsaveConfig.back.generic.flags             = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       oldsaveConfig.back.generic.id                = ID_BACK;
       oldsaveConfig.back.generic.callback   = UI_OldSaveConfigMenu_BackEvent;
       oldsaveConfig.back.generic.x                 = 0;
       oldsaveConfig.back.generic.y                 = 475-64;
       oldsaveConfig.back.width                            = 128;
       oldsaveConfig.back.height                           = 64;
       oldsaveConfig.back.focuspic                  = ART_BACK1;

       oldsaveConfig.save.generic.type              = MTYPE_BITMAP;
       oldsaveConfig.save.generic.name              = ART_SAVE0;
       oldsaveConfig.save.generic.flags             = QMF_RIGHT_JUSTIFY|QMF_PULSEIFFOCUS;
       oldsaveConfig.save.generic.id                = ID_SAVE;
       oldsaveConfig.save.generic.callback   = UI_OldSaveConfigMenu_SaveEvent;
       oldsaveConfig.save.generic.x                 = 640;
       oldsaveConfig.save.generic.y                 = 475-64;
       oldsaveConfig.save.width                            = 128;
       oldsaveConfig.save.height                 = 64;
       oldsaveConfig.save.focuspic                  = ART_SAVE1;

       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.banner );
       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.frame );
       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.background );
       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.savename );
       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.back );
       Menu_AddItem( &oldsaveConfig.menu, &oldsaveConfig.save );
}


/*
=================
UI_OldSaveConfigMenu_Cache
=================
*/
void UI_OldSaveConfigMenu_Cache( void ) {
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
	trap_R_RegisterShaderNoMip( ART_SAVE0 );
	trap_R_RegisterShaderNoMip( ART_SAVE1 );
	trap_R_RegisterShaderNoMip( ART_BACKGROUND );
}


/*
===============
UI_OldSaveConfigMenu
===============
*/
void UI_OldSaveConfigMenu( void ) {
       UI_OldSaveConfigMenu_Init();
       UI_PushMenu( &oldsaveConfig.menu );
}
