// Copyright (C) 1999-2000 Id Software, Inc.
//
#include "ui_local.h"


#define ART_BACK0		"menu/art/back_0"
#define ART_BACK1		"menu/art/back_1"	
#define ART_FRAMEL		"menu/art/frame2_l"
#define ART_FRAMER		"menu/art/frame1_r"
#define ART_BACKGROUND             "menu/art/addbotframe"

#define VERTICAL_SPACING    20

#define ID_BACK			10
#define ID_CIN_INTRO       11
#define ID_CIN_MUSIC1 12
#define ID_CIN_MUSIC2 13
#define ID_CIN_MUSIC3 14
#define ID_CIN_MUSIC4 15
#define ID_CIN_MUSIC5 16
#define ID_CIN_MUSIC6 17
#define ID_CIN_MUSIC7 18
#define ID_CIN_MUSIC8 19
#define ID_CIN_MUSIC9 20
#define ID_CIN_MUSIC10 21
#define ID_CIN_MUSIC11 22
#define ID_CIN_MUSIC12 23

typedef struct {
	menuframework_s	menu;
       menutext_s           cin_intro;
       menutext_s           cin_music1;
       menutext_s           cin_music2;
       menutext_s           cin_music3;
       menutext_s           cin_music4;
       menutext_s           cin_music5;
       menutext_s           cin_music6;
       menutext_s           cin_music7;
       menutext_s           cin_music8;
       menutext_s           cin_music9;
       menutext_s           cin_music10;
       menutext_s           cin_music11;
       menutext_s           cin_music12;
       menubitmap_s  back;
} MusicMenuInfo_t;

static MusicMenuInfo_t MusicMenuInfo;

static char *music[] = {
       "fla22k_01_loop.wav",
//       "fla22k_01_intro.wav",
       "fla22k_02.wav",
       "fla22k_03.wav",
       "fla22k_04_loop.wav",
//       "fla22k_04_intro.wav",
       "fla22k_05.wav",
       "fla22k_06.wav",
       "sonic1.wav",
       "sonic2.wav",
       "sonic3.wav",
       "sonic4.wav",
       "sonic5.wav",
       "sonic6.wav"
};

static char *music2[] = {
       "fla22k_01_loop.wav",
       "fla22k_03.wav",
       "fla22k_02.wav",
       "fla22k_04_loop.wav",
       "fla22k_02.wav",
       "fla22k_03.wav",
       "sonic2.wav",
       "sonic3.wav",
       "sonic4.wav",
       "sonic1.wav",
       "sonic2.wav",
       "sonic4.wav"
};

/*
===============
UI_MusicMenu_BackEvent
===============
*/
static void UI_MusicMenu_BackEvent( void *ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}
	UI_PopMenu();
}


/*
===============
UI_MusicMenu_Event
===============
*/
static void UI_MusicMenu_Event( void *ptr, int event ) {
	int		n;

	if (event != QM_ACTIVATED)
		return;
       n = ((menucommon_s*)ptr)->id - ID_CIN_MUSIC1;
       if (((menucommon_s*)ptr)->id == ID_CIN_MUSIC12 )
       {
              trap_Cmd_ExecuteText( EXEC_APPEND, "s_stop\n" );
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic6.wav music/sonic4.wav \n" );
       }
       else
       {
              trap_Cmd_ExecuteText( EXEC_APPEND, "s_stop\n" );
              trap_Cmd_ExecuteText( EXEC_APPEND, va( "music music/%s music/%s\n", music[n], music2[n] ) );
       }
}


static void UI_MusicMenu_Draw( void ) {
       UI_DrawBannerString( 320, 16, "MUSIC", UI_CENTER, color_white );
	UI_DrawNamedPic( 320-233, 240-166, 466, 332, ART_BACKGROUND );

	// standard menu drawing
       Menu_Draw( &MusicMenuInfo.menu );
}

/*
===============
UI_MusicMenu_Init
===============
*/
static void UI_MusicMenu_Init( void ) {
	int		y;
       UI_MusicMenu_Cache();
       memset( &MusicMenuInfo, 0, sizeof(MusicMenuInfo) );
       MusicMenuInfo.menu.draw = UI_MusicMenu_Draw;
       MusicMenuInfo.menu.fullscreen = qfalse;
       MusicMenuInfo.menu.wrapAround = qtrue;

       y = 95;
	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music1.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music1.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music1.generic.x                  = 320;
       MusicMenuInfo.cin_music1.generic.y                  = y;
       MusicMenuInfo.cin_music1.generic.id                 = ID_CIN_MUSIC1;
       MusicMenuInfo.cin_music1.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music1.string                            = "Q3A Music 1";
       MusicMenuInfo.cin_music1.color                      = color_red;
       MusicMenuInfo.cin_music1.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music2.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music2.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music2.generic.x                  = 320;
       MusicMenuInfo.cin_music2.generic.y                  = y;
       MusicMenuInfo.cin_music2.generic.id                 = ID_CIN_MUSIC2;
       MusicMenuInfo.cin_music2.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music2.string                            = "Q3A Music 2";
       MusicMenuInfo.cin_music2.color                      = color_red;
       MusicMenuInfo.cin_music2.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music3.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music3.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music3.generic.x                  = 320;
       MusicMenuInfo.cin_music3.generic.y                  = y;
       MusicMenuInfo.cin_music3.generic.id                 = ID_CIN_MUSIC3;
       MusicMenuInfo.cin_music3.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music3.string                            = "Q3A Music 3";
       MusicMenuInfo.cin_music3.color                      = color_red;
       MusicMenuInfo.cin_music3.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music4.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music4.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music4.generic.x                  = 320;
       MusicMenuInfo.cin_music4.generic.y                  = y;
       MusicMenuInfo.cin_music4.generic.id                 = ID_CIN_MUSIC4;
       MusicMenuInfo.cin_music4.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music4.string                            = "Q3A Music 4";
       MusicMenuInfo.cin_music4.color                      = color_red;
       MusicMenuInfo.cin_music4.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music5.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music5.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music5.generic.x                  = 320;
       MusicMenuInfo.cin_music5.generic.y                  = y;
       MusicMenuInfo.cin_music5.generic.id                 = ID_CIN_MUSIC5;
       MusicMenuInfo.cin_music5.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music5.string                            = "Q3A Music 5";
       MusicMenuInfo.cin_music5.color                      = color_red;
       MusicMenuInfo.cin_music5.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music6.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music6.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music6.generic.x                  = 320;
       MusicMenuInfo.cin_music6.generic.y                  = y;
       MusicMenuInfo.cin_music6.generic.id                 = ID_CIN_MUSIC6;
       MusicMenuInfo.cin_music6.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music6.string                            = "Q3A Music 6";
       MusicMenuInfo.cin_music6.color                      = color_red;
       MusicMenuInfo.cin_music6.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music7.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music7.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music7.generic.x                  = 320;
       MusicMenuInfo.cin_music7.generic.y                  = y;
       MusicMenuInfo.cin_music7.generic.id                 = ID_CIN_MUSIC7;
       MusicMenuInfo.cin_music7.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music7.string                            = "Q3A Sonic Music 1";
       MusicMenuInfo.cin_music7.color                      = color_red;
       MusicMenuInfo.cin_music7.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music8.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music8.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music8.generic.x                  = 320;
       MusicMenuInfo.cin_music8.generic.y                  = y;
       MusicMenuInfo.cin_music8.generic.id                 = ID_CIN_MUSIC8;
       MusicMenuInfo.cin_music8.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music8.string                            = "Q3A Sonic Music 2";
       MusicMenuInfo.cin_music8.color                      = color_red;
       MusicMenuInfo.cin_music8.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music9.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music9.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music9.generic.x                  = 320;
       MusicMenuInfo.cin_music9.generic.y                  = y;
       MusicMenuInfo.cin_music9.generic.id                 = ID_CIN_MUSIC9;
       MusicMenuInfo.cin_music9.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music9.string                            = "Q3A Sonic Music 3";
       MusicMenuInfo.cin_music9.color                      = color_red;
       MusicMenuInfo.cin_music9.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music10.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music10.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music10.generic.x                  = 320;
       MusicMenuInfo.cin_music10.generic.y                  = y;
       MusicMenuInfo.cin_music10.generic.id                 = ID_CIN_MUSIC10;
       MusicMenuInfo.cin_music10.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music10.string                            = "Q3A Sonic Music 4";
       MusicMenuInfo.cin_music10.color                      = color_red;
       MusicMenuInfo.cin_music10.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music11.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music11.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music11.generic.x                  = 320;
       MusicMenuInfo.cin_music11.generic.y                  = y;
       MusicMenuInfo.cin_music11.generic.id                 = ID_CIN_MUSIC11;
       MusicMenuInfo.cin_music11.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music11.string                            = "Q3A Sonic Music 5";
       MusicMenuInfo.cin_music11.color                      = color_red;
       MusicMenuInfo.cin_music11.style                      = UI_CENTER|UI_SMALLFONT;

	y += VERTICAL_SPACING;
       MusicMenuInfo.cin_music12.generic.type        = MTYPE_PTEXT;
       MusicMenuInfo.cin_music12.generic.flags              = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.cin_music12.generic.x                  = 320;
       MusicMenuInfo.cin_music12.generic.y                  = y;
       MusicMenuInfo.cin_music12.generic.id                 = ID_CIN_MUSIC12;
       MusicMenuInfo.cin_music12.generic.callback    = UI_MusicMenu_Event; 
       MusicMenuInfo.cin_music12.string                            = "Q3A Sonic Music 6";
       MusicMenuInfo.cin_music12.color                      = color_red;
       MusicMenuInfo.cin_music12.style                      = UI_CENTER|UI_SMALLFONT;

       MusicMenuInfo.back.generic.type         = MTYPE_BITMAP;
       MusicMenuInfo.back.generic.name         = ART_BACK0;
       MusicMenuInfo.back.generic.flags        = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
       MusicMenuInfo.back.generic.id                  = ID_BACK;
       MusicMenuInfo.back.generic.callback     = UI_MusicMenu_BackEvent;
       MusicMenuInfo.back.generic.x                   = 125;
       MusicMenuInfo.back.generic.y                   = 158;
       MusicMenuInfo.back.width                       = 128;
       MusicMenuInfo.back.height                      = 64;
       MusicMenuInfo.back.focuspic                    = ART_BACK1;

       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music1 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music2 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music3 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music4 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music5 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music6 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music7 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music8 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music9 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music10 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music11 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.cin_music12 );
       Menu_AddItem( &MusicMenuInfo.menu, &MusicMenuInfo.back );
}


/*
=================
UI_MusicMenu_Cache
=================
*/
void UI_MusicMenu_Cache( void ) {
	trap_R_RegisterShaderNoMip( ART_BACK0 );
	trap_R_RegisterShaderNoMip( ART_BACK1 );
	trap_R_RegisterShaderNoMip( ART_FRAMEL );
	trap_R_RegisterShaderNoMip( ART_FRAMER );
}


/*
===============
UI_MusicMenu
===============
*/
void UI_MusicMenu( void ) {
       UI_MusicMenu_Init();
       UI_PushMenu( &MusicMenuInfo.menu );
}
