// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

MAIN MENU

=======================================================================
*/


#include "ui_local.h"

#define ID_SINGLEPLAYER			10
#define ID_MULTIPLAYER			11
#define ID_SETUP				12
#define ID_DEMOS				13
#define ID_CINEMATICS			14
#define ID_TEAMARENA		15
#define ID_MODS					16
#define ID_EXIT					17
#define ID_HELLFIRE                              18
#define ID_SKIRMISH                              19

#define MAIN_BANNER_MODEL				"models/mapobjects/banner/banner5.md3"
#define MAIN_MENU_VERTICAL_SPACING		34


typedef struct {
	menuframework_s	menu;

	menutext_s		singleplayer;
       menutext_s           banner;
	menutext_s		multiplayer;
	menutext_s		setup;
       menutext_s           hellfire;
       menutext_s           skirmish;
	menutext_s		demos;
	menutext_s		cinematics;
	menutext_s		teamArena;
	menutext_s		mods;
	menutext_s		exit;

	qhandle_t		bannerModel;
} mainmenu_t;


static mainmenu_t s_main;


/*
=================
MainMenu_ExitAction
=================
*/
static void MainMenu_ExitAction( qboolean result ) {
	if( !result ) {
		return;
	}
	UI_PopMenu();
       UI_CreditMenu();
//       trap_Cmd_ExecuteText( EXEC_APPEND, "quit\n" );
}



/*
=================
Main_MenuEvent
=================
*/
void Main_MenuEvent (void* ptr, int event) {
	if( event != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_SINGLEPLAYER:
		UI_SPLevelMenu();
		break;

	case ID_MULTIPLAYER:
              if (ui_cache.integer)
                     trap_Cmd_ExecuteText( EXEC_NOW, "s_stop\n" );

              UI_ArenaServersMenu();

              if (ui_cache.integer)
                     DoMusic();
		break;

	case ID_SETUP:
		UI_SetupMenu();
		break;

       case ID_HELLFIRE:
              UI_Preferences2Menu();
              break;

       case ID_SKIRMISH:
              if (ui_cache.integer)
                     trap_Cmd_ExecuteText( EXEC_NOW, "s_stop\n" );

              UI_StartServerMenu( qfalse,0 );

              if (ui_cache.integer)
                     DoMusic();
              break;
	case ID_DEMOS:
		UI_DemosMenu();
		break;

	case ID_CINEMATICS:
		UI_CinematicsMenu();
		break;

	case ID_MODS:
		UI_ModsMenu();
		break;

	case ID_TEAMARENA:
//              trap_Cvar_Set( "fs_game", "missionpack");
//              trap_Cmd_ExecuteText( EXEC_APPEND, "vid_restart;" );
              UI_CreditMenu2();
		break;

	case ID_EXIT:
		UI_ConfirmMenu( "EXIT GAME?", NULL, MainMenu_ExitAction );
		break;
	}
}


/*
===============
MainMenu_Cache
===============
*/
void MainMenu_Cache( void ) {
	s_main.bannerModel = trap_R_RegisterModel( MAIN_BANNER_MODEL );
}


/*
===============
Main_MenuDraw
===============
*/
static void Main_MenuDraw( void ) {
	refdef_t		refdef;
	refEntity_t		ent;
	vec3_t			origin;
	vec3_t			angles;
	float			adjust;
	float			x, y, w, h;
	vec4_t			color = {0.5, 0, 0, 1};

	// standard menu drawing
       UI_DrawHandlePic( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, uis.title2Shader );
       UI_DrawHandlePic( 64, 68, 512, 64, uis.titleShader );

	Menu_Draw( &s_main.menu );

	if (uis.demoversion) {
              UI_DrawProportionalString( 320, 372, "DEMO      FOR MATURE AUDIENCES      DEMO", UI_CENTER|UI_SMALLFONT, color );
		UI_DrawString( 320, 400, "Quake III Arena(c) 1999-2000, Id Software, Inc.  All Rights Reserved", UI_CENTER|UI_SMALLFONT, color );
	} else {
              UI_DrawProportionalString( 320, 32, "QUAKE III", UI_CENTER|UI_BIGFONT|UI_PULSE, colorRed );
              UI_DrawString( 320, 436, "Hellfire Arena Ver 1.5(c) 1999-2001, Malcolm Lim.  All Rights Reserved", UI_CENTER|UI_SMALLFONT, color );
		UI_DrawString( 320, 450, "Quake III Arena(c) 1999-2000, Id Software, Inc.  All Rights Reserved", UI_CENTER|UI_SMALLFONT, color );
	}
}


/*
===============
UI_TeamArenaExists
===============
*/
static qboolean UI_TeamArenaExists( void ) {
	int		numdirs;
	char	dirlist[2048];
	char	*dirptr;
  char  *descptr;
	int		i;
	int		dirlen;

	numdirs = trap_FS_GetFileList( "$modlist", "", dirlist, sizeof(dirlist) );
	dirptr  = dirlist;
	for( i = 0; i < numdirs; i++ ) {
		dirlen = strlen( dirptr ) + 1;
    descptr = dirptr + dirlen;
		if (Q_stricmp(dirptr, "missionpack") == 0) {
			return qtrue;
		}
    dirptr += dirlen + strlen(descptr) + 1;
	}
	return qfalse;
}

void DoMusic ( void ) {

       if (ui_music.integer == 1)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_01_intro.wav music/fla22k_01_loop.wav\n" );
       else if (ui_music.integer == 2)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_02.wav music/fla22k_03.wav\n" );
       else if (ui_music.integer == 3)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_03.wav music/fla22k_02.wav\n" );
       else if (ui_music.integer == 4)
//              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_04_intro.wav music/fla22k_04_loop.wav\n" );
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_04_loop.wav\n" );
       else if (ui_music.integer == 5)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_05.wav music/fla22k_06.wav\n" );
       else if (ui_music.integer == 6)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_06.wav music/fla22k_05.wav\n" );
       else if (ui_music.integer == 7)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic1.wav music/sonic2.wav\n" );
       else if (ui_music.integer == 8)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic2.wav music/sonic3.wav\n" );
       else if (ui_music.integer == 9)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic3.wav music/sonic4.wav\n" );
       else if (ui_music.integer == 10)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic4.wav music/sonic1.wav\n" );
       else if (ui_music.integer == 11)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic5.wav music/sonic2.wav\n" );
       else if (ui_music.integer == 12)
              trap_Cmd_ExecuteText( EXEC_APPEND, "music music/sonic6.wav music/sonic4.wav\n" );
}

/*
===============
UI_MainMenu

The main menu only comes up when not in a game,
so make sure that the attract loop server is down
and that local cinematics are killed
===============
*/
void UI_MainMenu( void ) {
	int		y;
	qboolean teamArena = qfalse;
	int		style = UI_CENTER | UI_DROPSHADOW;

	trap_Cvar_Set( "sv_killserver", "1" );
       trap_Cvar_Set( "cg_predictitems", "0" );
       trap_Cvar_Set( "sv_pure", "0" );

	if( !uis.demoversion && !ui_cdkeychecked.integer ) {
		char	key[17];

		trap_GetCDKey( key, sizeof(key) );
		if( trap_VerifyCDKey( key, NULL ) == qfalse ) {
			UI_CDKeyMenu();
			return;
		}
	}
       DoMusic();
	memset( &s_main, 0 ,sizeof(mainmenu_t) );

	MainMenu_Cache();

	s_main.menu.draw = Main_MenuDraw;
	s_main.menu.fullscreen = qtrue;
	s_main.menu.wrapAround = qtrue;
//       s_main.menu.showlogo = qtrue;

       s_main.banner.generic.type                     = MTYPE_BTEXT;
       s_main.banner.generic.x                 = 320;
       s_main.banner.generic.y                 = 32;
       s_main.banner.string                           = "";
       s_main.banner.color                            = color_white;
       s_main.banner.style                            = UI_CENTER;

	y = 134;
	s_main.singleplayer.generic.type		= MTYPE_PTEXT;
	s_main.singleplayer.generic.flags		= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.singleplayer.generic.x			= 320;
	s_main.singleplayer.generic.y			= y;
	s_main.singleplayer.generic.id			= ID_SINGLEPLAYER;
	s_main.singleplayer.generic.callback	= Main_MenuEvent; 
	s_main.singleplayer.string				= "SINGLE PLAYER";
	s_main.singleplayer.color				= color_red;
	s_main.singleplayer.style				= style;

       y += MAIN_MENU_VERTICAL_SPACING;
       s_main.skirmish.generic.type                                = MTYPE_PTEXT;
       s_main.skirmish.generic.flags                        = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_main.skirmish.generic.x                                   = 320;
       s_main.skirmish.generic.y                                   = y;
       s_main.skirmish.generic.id                                  = ID_SKIRMISH;
       s_main.skirmish.generic.callback                            = Main_MenuEvent; 
       s_main.skirmish.string                                      = "SKIRMISH";
       s_main.skirmish.color                                       = color_red;
       s_main.skirmish.style                                       = style;

	y += MAIN_MENU_VERTICAL_SPACING;
	s_main.multiplayer.generic.type			= MTYPE_PTEXT;
	s_main.multiplayer.generic.flags		= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.multiplayer.generic.x			= 320;
	s_main.multiplayer.generic.y			= y;
	s_main.multiplayer.generic.id			= ID_MULTIPLAYER;
	s_main.multiplayer.generic.callback		= Main_MenuEvent; 
	s_main.multiplayer.string				= "MULTIPLAYER";
	s_main.multiplayer.color				= color_red;
	s_main.multiplayer.style				= style;

       y += MAIN_MENU_VERTICAL_SPACING;
       s_main.hellfire.generic.type                                = MTYPE_PTEXT;
       s_main.hellfire.generic.flags                        = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
       s_main.hellfire.generic.x                                   = 320;
       s_main.hellfire.generic.y                                   = y;
       s_main.hellfire.generic.id                                  = ID_HELLFIRE;
       s_main.hellfire.generic.callback                            = Main_MenuEvent; 
       s_main.hellfire.string                                      = "HELLFIRE OPTIONS";
       s_main.hellfire.color                                       = color_red;
       s_main.hellfire.style                                       = style;

	y += MAIN_MENU_VERTICAL_SPACING;
	s_main.setup.generic.type				= MTYPE_PTEXT;
	s_main.setup.generic.flags				= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.setup.generic.x					= 320;
	s_main.setup.generic.y					= y;
	s_main.setup.generic.id					= ID_SETUP;
	s_main.setup.generic.callback			= Main_MenuEvent; 
	s_main.setup.string						= "SETUP";
	s_main.setup.color						= color_red;
	s_main.setup.style						= style;

	y += MAIN_MENU_VERTICAL_SPACING;
	s_main.demos.generic.type				= MTYPE_PTEXT;
	s_main.demos.generic.flags				= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.demos.generic.x					= 320;
	s_main.demos.generic.y					= y;
	s_main.demos.generic.id					= ID_DEMOS;
	s_main.demos.generic.callback			= Main_MenuEvent; 
	s_main.demos.string						= "DEMOS";
	s_main.demos.color						= color_red;
	s_main.demos.style						= style;

	y += MAIN_MENU_VERTICAL_SPACING;
	s_main.cinematics.generic.type			= MTYPE_PTEXT;
	s_main.cinematics.generic.flags			= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.cinematics.generic.x				= 320;
	s_main.cinematics.generic.y				= y;
	s_main.cinematics.generic.id			= ID_CINEMATICS;
	s_main.cinematics.generic.callback		= Main_MenuEvent; 
	s_main.cinematics.string				= "CINEMATICS";
	s_main.cinematics.color					= color_red;
	s_main.cinematics.style					= style;

		y += MAIN_MENU_VERTICAL_SPACING;
		s_main.teamArena.generic.type			= MTYPE_PTEXT;
		s_main.teamArena.generic.flags			= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
		s_main.teamArena.generic.x				= 320;
		s_main.teamArena.generic.y				= y;
		s_main.teamArena.generic.id				= ID_TEAMARENA;
		s_main.teamArena.generic.callback		= Main_MenuEvent; 
              s_main.teamArena.string                                 = "CREDITS";
		s_main.teamArena.color					= color_red;
		s_main.teamArena.style					= style;

	y += MAIN_MENU_VERTICAL_SPACING;
	s_main.exit.generic.type				= MTYPE_PTEXT;
	s_main.exit.generic.flags				= QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_main.exit.generic.x					= 320;
	s_main.exit.generic.y					= y;
	s_main.exit.generic.id					= ID_EXIT;
	s_main.exit.generic.callback			= Main_MenuEvent; 
	s_main.exit.string						= "EXIT";
	s_main.exit.color						= color_red;
	s_main.exit.style						= style;

       Menu_AddItem( &s_main.menu, &s_main.banner );
	Menu_AddItem( &s_main.menu,	&s_main.singleplayer );
       Menu_AddItem( &s_main.menu, &s_main.skirmish );
	Menu_AddItem( &s_main.menu,	&s_main.multiplayer );
       Menu_AddItem( &s_main.menu, &s_main.hellfire );
	Menu_AddItem( &s_main.menu,	&s_main.setup );
	Menu_AddItem( &s_main.menu,	&s_main.demos );
	Menu_AddItem( &s_main.menu,	&s_main.cinematics );
       Menu_AddItem( &s_main.menu, &s_main.teamArena );
	Menu_AddItem( &s_main.menu,	&s_main.exit );             

	trap_Key_SetCatcher( KEYCATCH_UI );
	uis.menusp = 0;
	UI_PushMenu ( &s_main.menu );
}
