// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

USER INTERFACE MAIN

=======================================================================
*/


#include "ui_local.h"


/*
================
vmMain

This is the only way control passes into the module.
This must be the very first function compiled into the .qvm file
================
*/
int vmMain( int command, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11  ) {
	switch ( command ) {
	case UI_GETAPIVERSION:
		return UI_API_VERSION;

	case UI_INIT:
		UI_Init();
		return 0;

	case UI_SHUTDOWN:
		UI_Shutdown();
		return 0;

	case UI_KEY_EVENT:
		UI_KeyEvent( arg0, arg1 );
		return 0;

	case UI_MOUSE_EVENT:
		UI_MouseEvent( arg0, arg1 );
		return 0;

	case UI_REFRESH:
		UI_Refresh( arg0 );
		return 0;

	case UI_IS_FULLSCREEN:
		return UI_IsFullscreen();

	case UI_SET_ACTIVE_MENU:
		UI_SetActiveMenu( arg0 );
		return 0;

	case UI_CONSOLE_COMMAND:
		return UI_ConsoleCommand(arg0);

	case UI_DRAW_CONNECT_SCREEN:
		UI_DrawConnectScreen( arg0 );
		return 0;
	case UI_HASUNIQUECDKEY:				// mod authors need to observe this
              return qfalse;
	}

	return -1;
}


/*
================
cvars
================
*/

typedef struct {
	vmCvar_t	*vmCvar;
	char		*cvarName;
	char		*defaultString;
	int			cvarFlags;
} cvarTable_t;

vmCvar_t      fastswitch;
vmCvar_t      ui_matchparts;
vmCvar_t      ui_ffa_fraglimit;
vmCvar_t	ui_ffa_timelimit;

vmCvar_t	ui_tourney_fraglimit;
vmCvar_t	ui_tourney_timelimit;

vmCvar_t	ui_team_fraglimit;
vmCvar_t	ui_team_timelimit;
vmCvar_t	ui_team_friendly;

vmCvar_t	ui_ctf_capturelimit;
vmCvar_t	ui_ctf_timelimit;
vmCvar_t	ui_ctf_friendly;

vmCvar_t	ui_arenasFile;
vmCvar_t	ui_botsFile;
vmCvar_t	ui_spScores1;
vmCvar_t	ui_spScores2;
vmCvar_t	ui_spScores3;
vmCvar_t	ui_spScores4;
vmCvar_t	ui_spScores5;
vmCvar_t	ui_spAwards;
vmCvar_t	ui_spVideos;
vmCvar_t	ui_spSkill;

vmCvar_t	ui_spSelection;

vmCvar_t	ui_browserMaster;
vmCvar_t	ui_browserGameType;
vmCvar_t	ui_browserSortKey;
vmCvar_t	ui_browserShowFull;
vmCvar_t	ui_browserShowEmpty;

vmCvar_t	ui_brassTime;
vmCvar_t	ui_drawCrosshair;
vmCvar_t	ui_drawCrosshairNames;
vmCvar_t	ui_marks;
vmCvar_t      runeflags;

vmCvar_t	ui_server1;
vmCvar_t	ui_server2;
vmCvar_t	ui_server3;
vmCvar_t	ui_server4;
vmCvar_t	ui_server5;
vmCvar_t	ui_server6;
vmCvar_t	ui_server7;
vmCvar_t	ui_server8;
vmCvar_t	ui_server9;
vmCvar_t	ui_server10;
vmCvar_t	ui_server11;
vmCvar_t	ui_server12;
vmCvar_t	ui_server13;
vmCvar_t	ui_server14;
vmCvar_t	ui_server15;
vmCvar_t	ui_server16;

vmCvar_t	ui_cdkeychecked;
vmCvar_t      ui_cache;
vmCvar_t      ui_allmaps;
vmCvar_t      ui_listmode;
vmCvar_t      ui_randombot;
vmCvar_t      ui_spectator;
vmCvar_t      ui_record;
vmCvar_t      ui_music;
vmCvar_t      ui_gravity;
vmCvar_t      gravity;
vmCvar_t      randomweap;
vmCvar_t      g_instagib;
vmCvar_t      g_maxpenetration;
vmCvar_t      g_telefraginstagib;
vmCvar_t      homingmissile;
vmCvar_t      doublerockets;
vmCvar_t      guidedrockets;
vmCvar_t      cg_rocketshaders;
vmCvar_t      cg_weaponselectstyle;
vmCvar_t      cg_progressivezooming;
vmCvar_t      cg_3rdpersoncrosshair;
vmCvar_t      g_teamcoloredskins;
vmCvar_t      cg_selectgauntlet;
vmCvar_t      cg_selectgrapple;
vmCvar_t      starthealth;
vmCvar_t      startwithsg;
vmCvar_t      startwithrl;
vmCvar_t      startwithgl;
vmCvar_t      startwithlg;
vmCvar_t      startwithpg;
vmCvar_t      startwithmg;
vmCvar_t      startwithbfg;
vmCvar_t      startwithft;
vmCvar_t      startwithrg;
vmCvar_t      startarmor;
vmCvar_t      maxhealth;
vmCvar_t      g_spawnprotect;
vmCvar_t      gtscore;
vmCvar_t      mgscore;
vmCvar_t      sgscore;
vmCvar_t      glscore;
vmCvar_t      rlscore;
vmCvar_t      lgscore;
vmCvar_t      rgscore;
vmCvar_t      pgscore;
vmCvar_t      bfgscore;
vmCvar_t      ftscore;
vmCvar_t      glsdamage;
vmCvar_t      glsradius;
vmCvar_t      rlsdamage;
vmCvar_t      rlsradius;
vmCvar_t      bfgsdamage;
vmCvar_t      bfgsradius;
vmCvar_t      pgsdamage;
vmCvar_t      pgsradius;
vmCvar_t      g_spawnrandomsg;
vmCvar_t      g_spawnrandomgl;
vmCvar_t      g_spawnrandomrl;
vmCvar_t      g_spawnrandomlg;
vmCvar_t      g_spawnrandomrg;
vmCvar_t      g_spawnrandompg;
vmCvar_t      g_spawnrandombfg;
vmCvar_t      g_spawnrandomft;
vmCvar_t      g_vampire;
vmCvar_t      g_vampiremax;
vmCvar_t      g_vampiresteal;
vmCvar_t      g_forcerespawn;
vmCvar_t      g_weaponchangetime;
vmCvar_t      g_powerupchangetime;
vmCvar_t      g_weaponRespawn;
vmCvar_t	g_knockback;
vmCvar_t	g_quadfactor;
vmCvar_t      grenadetype;
vmCvar_t      ui_defaultBots;
vmCvar_t      gametype;
vmCvar_t      g_mgweap;
vmCvar_t      g_sgweap;
vmCvar_t      g_glweap;
vmCvar_t      g_rlweap;
vmCvar_t      g_lgweap;
vmCvar_t      g_rgweap;
vmCvar_t      g_pgweap;
vmCvar_t      g_bfgweap;
vmCvar_t      g_mgammo;
vmCvar_t      g_sgammo;
vmCvar_t      g_glammo;
vmCvar_t      g_rlammo;
vmCvar_t      g_lgammo;
vmCvar_t      g_rgammo;
vmCvar_t      g_pgammo;
vmCvar_t      g_bfgammo;
vmCvar_t      gtscore;
vmCvar_t      mgscore;
vmCvar_t      sgscore;
vmCvar_t      glscore;
vmCvar_t      rlscore;
vmCvar_t      lgscore;
vmCvar_t      rgscore;
vmCvar_t      pgscore;
vmCvar_t      bfgscore;
vmCvar_t      ftscore;
vmCvar_t      g_mgrespawn;
vmCvar_t      g_sgrespawn;
vmCvar_t      g_glrespawn;
vmCvar_t      g_rlrespawn;
vmCvar_t      g_lgrespawn;
vmCvar_t      g_rgrespawn;
vmCvar_t      g_pgrespawn;
vmCvar_t      g_bfgrespawn;
vmCvar_t      g_ftrespawn;
vmCvar_t      g_mgammorespawn;
vmCvar_t      g_sgammorespawn;
vmCvar_t      g_glammorespawn;
vmCvar_t      g_rlammorespawn;
vmCvar_t      g_lgammorespawn;
vmCvar_t      g_rgammorespawn;
vmCvar_t      g_pgammorespawn;
vmCvar_t      g_bfgammorespawn;
vmCvar_t      g_ftammorespawn;
vmCvar_t      g_mgreload;
vmCvar_t      g_gpreload;
vmCvar_t      g_sgreload;
vmCvar_t      g_glreload;
vmCvar_t      g_rlreload;
vmCvar_t      g_lgreload;
vmCvar_t      g_rgreload;
vmCvar_t      g_pgreload;
vmCvar_t      g_bfgreload;
vmCvar_t      g_ftreload;
vmCvar_t      g_intermissiontime;
vmCvar_t      startwithsgammo;
vmCvar_t      startwithrlammo;
vmCvar_t      startwithglammo;
vmCvar_t      startwithlgammo;
vmCvar_t      startwithpgammo;
vmCvar_t      startwithmgammo;
vmCvar_t      startwithbfgammo;
vmCvar_t      startwithftammo;
vmCvar_t      startwithrgammo;
vmCvar_t      machinegunammo;
vmCvar_t      shotgunammo;
vmCvar_t      grenadeammo;
vmCvar_t      rocketammo;
vmCvar_t      lightningammo;
vmCvar_t      railgunammo;
vmCvar_t      plasmaammo;
vmCvar_t      bfgammo;
vmCvar_t      ftammo;
vmCvar_t      g_campprotect;
vmCvar_t      g_camptimeout;
vmCvar_t      g_campshuffle;
vmCvar_t      g_falling;
vmCvar_t      g_selfdamage;
vmCvar_t      g_damagescale;
vmCvar_t      ui_mapsource;
vmCvar_t      ui_gametype;
vmCvar_t      mgdamage;
vmCvar_t      gtdamage;
vmCvar_t      sgdamage;
vmCvar_t      gldamage;
vmCvar_t      rldamage;
vmCvar_t      lgdamage;
vmCvar_t      rgdamage;
vmCvar_t      pgdamage;
vmCvar_t      bfgdamage;
vmCvar_t      ftdamage;
vmCvar_t      bot_nochat;
vmCvar_t      bot_fastchat;
vmCvar_t      bot_challenge;
vmCvar_t      bot_rocketjump;
vmCvar_t      cg_directionaldamage;
vmCvar_t      cg_drawsmoke;
vmCvar_t      cg_drawscanner;
vmCvar_t      cg_hud;
vmCvar_t      cg_centerhud;       
vmCvar_t      cg_autouse;
vmCvar_t      cg_autousehealth;
vmCvar_t	cg_drawTimer;
vmCvar_t	cg_drawFPS;
vmCvar_t      cg_draw3dIcons;
vmCvar_t      cg_drawAmmoWarning;
vmCvar_t      cg_drawRewards;
vmCvar_t      cg_drawStatus;
vmCvar_t      cg_drawAttacker;
vmCvar_t      g_fixedfov;
vmCvar_t      g_nofootsteps;
vmCvar_t      g_podiumscores;
vmCvar_t      cg_weaponposition;
vmCvar_t             cg_railtype;
vmCvar_t      lightningtype;
vmCvar_t      g_proxytime;
vmCvar_t      g_mg;
vmCvar_t      g_sg;
vmCvar_t      g_gl;
vmCvar_t      g_rl;
vmCvar_t      g_lg;
vmCvar_t      g_rg;
vmCvar_t      g_pg;
vmCvar_t      g_bfg;
vmCvar_t      g_ft;
vmCvar_t      startwithpowerups;
vmCvar_t      startwithpoweruptime;
vmCvar_t      g_invisibility;
vmCvar_t      g_camstyle;
vmCvar_t      g_camtype;
vmCvar_t      g_quad;
vmCvar_t      g_flight;
vmCvar_t      g_haste;
vmCvar_t      g_regen;
vmCvar_t      g_battlesuit;
vmCvar_t      ui_ffa_skill;
vmCvar_t      ui_team_skill;
vmCvar_t      ui_tourney_skill;
vmCvar_t      ui_ctf_skill;
vmCvar_t      g_warmup;
vmCvar_t      cg_weaponOrder;
vmCvar_t      grenadevelocity;
vmCvar_t      grapplevelocity;
vmCvar_t      rocketvelocity;
vmCvar_t      plasmavelocity;
vmCvar_t      bfgvelocity;
vmCvar_t      bfgtype;
vmCvar_t      cg_drawMiniScore;
vmCvar_t      cg_scorePlum;

cvarTable_t		cvarTable[] = {
       { &ui_matchparts, "ui_matchparts", "0", CVAR_ARCHIVE },
	{ &ui_ffa_fraglimit, "ui_ffa_fraglimit", "20", CVAR_ARCHIVE },
	{ &ui_ffa_timelimit, "ui_ffa_timelimit", "0", CVAR_ARCHIVE },

	{ &ui_tourney_fraglimit, "ui_tourney_fraglimit", "0", CVAR_ARCHIVE },
	{ &ui_tourney_timelimit, "ui_tourney_timelimit", "15", CVAR_ARCHIVE },

	{ &ui_team_fraglimit, "ui_team_fraglimit", "0", CVAR_ARCHIVE },
	{ &ui_team_timelimit, "ui_team_timelimit", "20", CVAR_ARCHIVE },
	{ &ui_team_friendly, "ui_team_friendly",  "1", CVAR_ARCHIVE },

	{ &ui_ctf_capturelimit, "ui_ctf_capturelimit", "8", CVAR_ARCHIVE },
	{ &ui_ctf_timelimit, "ui_ctf_timelimit", "30", CVAR_ARCHIVE },
	{ &ui_ctf_friendly, "ui_ctf_friendly",  "0", CVAR_ARCHIVE },

       { &ui_mapsource, "ui_mapsource", "0", CVAR_ARCHIVE },
       { &ui_gametype, "ui_gametype", "0", CVAR_ARCHIVE },

	{ &ui_arenasFile, "g_arenasFile", "", CVAR_INIT|CVAR_ROM },
	{ &ui_botsFile, "g_botsFile", "", CVAR_INIT|CVAR_ROM },
	{ &ui_spScores1, "g_spScores1", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spScores2, "g_spScores2", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spScores3, "g_spScores3", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spScores4, "g_spScores4", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spScores5, "g_spScores5", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spAwards, "g_spAwards", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spVideos, "g_spVideos", "", CVAR_ARCHIVE | CVAR_ROM },
	{ &ui_spSkill, "g_spSkill", "2", CVAR_ARCHIVE | CVAR_LATCH },

	{ &ui_spSelection, "ui_spSelection", "", CVAR_ROM },

	{ &ui_browserMaster, "ui_browserMaster", "0", CVAR_ARCHIVE },
	{ &ui_browserGameType, "ui_browserGameType", "0", CVAR_ARCHIVE },
	{ &ui_browserSortKey, "ui_browserSortKey", "4", CVAR_ARCHIVE },
	{ &ui_browserShowFull, "ui_browserShowFull", "1", CVAR_ARCHIVE },
	{ &ui_browserShowEmpty, "ui_browserShowEmpty", "1", CVAR_ARCHIVE },

	{ &ui_brassTime, "cg_brassTime", "2500", CVAR_ARCHIVE },
	{ &ui_drawCrosshair, "cg_drawCrosshair", "4", CVAR_ARCHIVE },
	{ &ui_drawCrosshairNames, "cg_drawCrosshairNames", "1", CVAR_ARCHIVE },
	{ &ui_marks, "cg_marks", "1", CVAR_ARCHIVE },

	{ &ui_server1, "server1", "", CVAR_ARCHIVE },
	{ &ui_server2, "server2", "", CVAR_ARCHIVE },
	{ &ui_server3, "server3", "", CVAR_ARCHIVE },
	{ &ui_server4, "server4", "", CVAR_ARCHIVE },
	{ &ui_server5, "server5", "", CVAR_ARCHIVE },
	{ &ui_server6, "server6", "", CVAR_ARCHIVE },
	{ &ui_server7, "server7", "", CVAR_ARCHIVE },
	{ &ui_server8, "server8", "", CVAR_ARCHIVE },
	{ &ui_server9, "server9", "", CVAR_ARCHIVE },
	{ &ui_server10, "server10", "", CVAR_ARCHIVE },
	{ &ui_server11, "server11", "", CVAR_ARCHIVE },
	{ &ui_server12, "server12", "", CVAR_ARCHIVE },
	{ &ui_server13, "server13", "", CVAR_ARCHIVE },
	{ &ui_server14, "server14", "", CVAR_ARCHIVE },
	{ &ui_server15, "server15", "", CVAR_ARCHIVE },
	{ &ui_server16, "server16", "", CVAR_ARCHIVE },
       { &ui_music, "ui_music", "0", CVAR_ARCHIVE },
       { &ui_cache, "ui_cache", "0", CVAR_ARCHIVE },
       { &ui_allmaps, "ui_allmaps", "0", CVAR_ARCHIVE },
       { &ui_ffa_skill, "ui_ffa_skill", "2", CVAR_ARCHIVE },
       { &ui_team_skill, "ui_team_skill", "2", CVAR_ARCHIVE },
       { &ui_tourney_skill, "ui_tourney_skill", "2", CVAR_ARCHIVE },
       { &ui_ctf_skill, "ui_ctf_skill", "2", CVAR_ARCHIVE },
       { &ui_listmode, "ui_listmode", "0", CVAR_ARCHIVE },
       { &ui_randombot, "ui_randombot", "0", CVAR_ARCHIVE },
       { &ui_spectator, "ui_spectator", "0", CVAR_ARCHIVE },
       { &ui_record, "ui_record", "0", CVAR_ARCHIVE },
       { &ui_gravity, "gravity", "0", CVAR_ARCHIVE | CVAR_LATCH},
       { &bot_rocketjump, "bot_rocketjump", "1", CVAR_ARCHIVE},
       { &bot_challenge, "bot_challenge", "0", CVAR_ARCHIVE},
       { &bot_fastchat, "bot_fastchat", "0", CVAR_ARCHIVE},
       { &bot_nochat, "bot_nochat", "0", CVAR_ARCHIVE},
       { &g_podiumscores, "g_podiumscores", "1", CVAR_ARCHIVE  },
       { &gravity, "gravity", "0", CVAR_ARCHIVE},
       { &starthealth, "starthealth", "125", CVAR_ARCHIVE }, // start health
       { &startarmor, "startarmor", "0", CVAR_ARCHIVE }, // start armor
       { &maxhealth, "maxhealth", "100", CVAR_ARCHIVE }, // max health
       { &g_vampire, "g_vampire", "0", CVAR_ARCHIVE  },
       { &g_vampiremax, "g_vampiremax", "500", CVAR_ARCHIVE  },
       { &g_vampiresteal, "g_vampiresteal", "0.25", CVAR_ARCHIVE  },
       { &g_spawnprotect, "g_spawnprotect", "10", CVAR_ARCHIVE  },
       { &gtscore, "gtscore", "1",  CVAR_ARCHIVE  },
       { &mgscore, "mgscore", "1",  CVAR_ARCHIVE  },
       { &sgscore, "sgscore", "1",  CVAR_ARCHIVE  },
       { &glscore, "glscore", "1",  CVAR_ARCHIVE  },
       { &rlscore, "rlscore", "1",  CVAR_ARCHIVE  },
       { &lgscore, "lgscore", "1",  CVAR_ARCHIVE  },
       { &rgscore, "rgscore", "1",  CVAR_ARCHIVE  },
       { &pgscore, "pgscore", "1",  CVAR_ARCHIVE  },
       { &bfgscore, "bfgscore", "1",  CVAR_ARCHIVE  },
       { &ftscore, "ftscore", "1",  CVAR_ARCHIVE  },
       { &g_spawnrandomsg, "g_spawnrandomsg", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandomgl, "g_spawnrandomgl", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandomrl, "g_spawnrandomrl", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandomlg, "g_spawnrandomlg", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandomrg, "g_spawnrandomrg", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandompg, "g_spawnrandompg", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandombfg, "g_spawnrandombfg", "0",  CVAR_ARCHIVE  },
       { &g_spawnrandomft, "g_spawnrandomft", "0", CVAR_ARCHIVE  },
       { &startwithmg, "startwithmg", "1", CVAR_ARCHIVE },
       { &startwithsg, "startwithsg", "0", CVAR_ARCHIVE },
       { &startwithgl, "startwithgl", "0", CVAR_ARCHIVE },
       { &startwithrl, "startwithrl", "0", CVAR_ARCHIVE },
       { &startwithlg, "startwithlg", "0", CVAR_ARCHIVE },
       { &startwithpg, "startwithpg", "0", CVAR_ARCHIVE },
       { &startwithrg, "startwithrg", "0", CVAR_ARCHIVE },
       { &startwithbfg, "startwithbfg", "0", CVAR_ARCHIVE },
       { &startwithft, "startwithft", "0", CVAR_ARCHIVE },
       { &pgsradius, "pgsradius", "20",  CVAR_ARCHIVE },
       { &pgsdamage, "pgsdamage", "15",  CVAR_ARCHIVE },
       { &glsradius, "glsradius", "150",  CVAR_ARCHIVE },
       { &glsdamage, "glsdamage", "100",  CVAR_ARCHIVE },
       { &rlsradius, "rlsradius", "120",  CVAR_ARCHIVE },
       { &rlsdamage, "rlsdamage", "100",  CVAR_ARCHIVE },
       { &bfgsradius, "bfgsradius", "120",  CVAR_ARCHIVE },
       { &bfgsdamage, "bfgsdamage", "100",  CVAR_ARCHIVE },
       { &g_forcerespawn, "g_forcerespawn", "20", 0 },
       { &g_weaponchangetime, "g_weaponchangetime", "60", CVAR_ARCHIVE },
       { &g_weaponRespawn, "g_weaponrespawn", "5", CVAR_ARCHIVE  },
       { &g_warmup, "g_warmup", "20", CVAR_ARCHIVE  },
       { &g_knockback, "g_knockback", "1000", CVAR_ARCHIVE  },
       { &g_quadfactor, "g_quadfactor", "4", CVAR_ARCHIVE  },
       { &grenadetype, "grenadetype", "0", CVAR_ARCHIVE }, // grenade type
       { &gametype, "g_gametype", "0", CVAR_SERVERINFO },
       { &g_mgammo, "g_mgammo", "1", CVAR_ARCHIVE},
       { &g_sgammo, "g_sgammo", "1", CVAR_ARCHIVE},
       { &g_glammo, "g_glammo", "1",  CVAR_ARCHIVE},
       { &g_rlammo, "g_rlammo", "1",  CVAR_ARCHIVE},
       { &g_lgammo, "g_lgammo", "1",  CVAR_ARCHIVE},
       { &g_rgammo, "g_rgammo", "1",  CVAR_ARCHIVE},
       { &g_pgammo, "g_pgammo", "1",  CVAR_ARCHIVE},
       { &g_bfgammo, "g_bfgammo", "1",  CVAR_ARCHIVE},
       { &gtscore, "gtscore", "1",  CVAR_ARCHIVE  },
       { &mgscore, "mgscore", "1",  CVAR_ARCHIVE  },
       { &sgscore, "sgscore", "1",  CVAR_ARCHIVE  },
       { &glscore, "glscore", "1",  CVAR_ARCHIVE  },
       { &rlscore, "rlscore", "1",  CVAR_ARCHIVE  },
       { &lgscore, "lgscore", "1",  CVAR_ARCHIVE  },
       { &rgscore, "rgscore", "1",  CVAR_ARCHIVE  },
       { &pgscore, "pgscore", "1",  CVAR_ARCHIVE  },
       { &bfgscore, "bfgscore", "1",  CVAR_ARCHIVE  },
       { &ftscore, "ftscore", "1",  CVAR_ARCHIVE  },
       { &g_mgreload, "g_mgreload", "100",  CVAR_ARCHIVE},
       { &g_gpreload, "g_gpreload", "400",  CVAR_ARCHIVE},
       { &g_sgreload, "g_sgreload", "1000",  CVAR_ARCHIVE},
       { &g_glreload, "g_glreload", "800",  CVAR_ARCHIVE},
       { &g_rlreload, "g_rlreload", "800",  CVAR_ARCHIVE},
       { &g_lgreload, "g_lgreload", "50",  CVAR_ARCHIVE},
       { &g_rgreload, "g_rgreload", "1500",  CVAR_ARCHIVE},
       { &g_pgreload, "g_pgreload", "100",  CVAR_ARCHIVE},
       { &g_bfgreload, "g_bfgreload", "200",  CVAR_ARCHIVE},
       { &g_ftreload, "g_ftreload", "40",  CVAR_ARCHIVE},
       { &g_mgweap, "g_mgweap", "1",  CVAR_ARCHIVE},
       { &g_sgweap, "g_sgweap", "1",  CVAR_ARCHIVE},
       { &g_glweap, "g_glweap", "1",  CVAR_ARCHIVE},
       { &g_rlweap, "g_rlweap", "1",  CVAR_ARCHIVE},
       { &g_lgweap, "g_lgweap", "1",  CVAR_ARCHIVE},
       { &g_rgweap, "g_rgweap", "1",  CVAR_ARCHIVE},
       { &g_pgweap, "g_pgweap", "1",  CVAR_ARCHIVE},
       { &g_bfgweap, "g_bfgweap", "1",  CVAR_ARCHIVE},
       { &g_mg, "g_mg", "1", CVAR_ARCHIVE },
       { &g_sg, "g_sg", "1", CVAR_ARCHIVE },
       { &g_gl, "g_gl", "1", CVAR_ARCHIVE },
       { &g_rl, "g_rl", "1", CVAR_ARCHIVE },
       { &g_lg, "g_lg", "1", CVAR_ARCHIVE },
       { &g_rg, "g_rg", "1", CVAR_ARCHIVE },
       { &g_pg, "g_pg", "1", CVAR_ARCHIVE },
       { &g_bfg, "g_bfg", "1", CVAR_ARCHIVE  },
       { &g_ft, "g_ft", "1", CVAR_ARCHIVE  },
       { &g_mgammorespawn, "g_mgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_sgammorespawn, "g_sgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_glammorespawn, "g_glammorespawn", "40",  CVAR_ARCHIVE},
       { &g_rlammorespawn, "g_rlammorespawn", "40",  CVAR_ARCHIVE},
       { &g_lgammorespawn, "g_lgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_rgammorespawn, "g_rgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_pgammorespawn, "g_pgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_bfgammorespawn, "g_bfgammorespawn", "40",  CVAR_ARCHIVE},
       { &g_ftammorespawn, "g_ftammorespawn", "40",  CVAR_ARCHIVE},
       { &g_mgrespawn, "g_mgrespawn", "5",  CVAR_ARCHIVE},
       { &g_sgrespawn, "g_sgrespawn", "5",  CVAR_ARCHIVE},
       { &g_glrespawn, "g_glrespawn", "5",  CVAR_ARCHIVE},
       { &g_rlrespawn, "g_rlrespawn", "5",  CVAR_ARCHIVE},
       { &g_lgrespawn, "g_lgrespawn", "5",  CVAR_ARCHIVE},
       { &g_rgrespawn, "g_rgrespawn", "5",  CVAR_ARCHIVE},
       { &g_pgrespawn, "g_pgrespawn", "5",  CVAR_ARCHIVE},
       { &g_bfgrespawn, "g_bfgrespawn", "5",  CVAR_ARCHIVE},
       { &g_ftrespawn, "g_ftrespawn", "5",  CVAR_ARCHIVE},
       { &g_nofootsteps, "g_nofootsteps", "0", CVAR_ARCHIVE  },
       { &g_fixedfov, "g_fixedfov", "0", CVAR_ARCHIVE  },
       { &g_selfdamage, "g_selfdamage", "1", CVAR_ARCHIVE  },
       { &startwithmgammo, "startwithmgammo", "100",  CVAR_ARCHIVE },
       { &startwithsgammo, "startwithsgammo", "0",  CVAR_ARCHIVE },
       { &startwithglammo, "startwithglammo", "0",  CVAR_ARCHIVE },
       { &startwithrlammo, "startwithrlammo", "0",  CVAR_ARCHIVE },
       { &startwithlgammo, "startwithlgammo", "0",  CVAR_ARCHIVE },
       { &startwithpgammo, "startwithpgammo", "0",  CVAR_ARCHIVE },
       { &startwithrgammo, "startwithrgammo", "0",  CVAR_ARCHIVE },
       { &startwithbfgammo, "startwithbfgammo", "0",  CVAR_ARCHIVE },
       { &startwithftammo, "startwithftammo", "0",  CVAR_ARCHIVE },
       { &startwithpowerups, "startwithpowerups", "0", CVAR_ARCHIVE },
       { &startwithpoweruptime, "startwithpoweruptime", "60", CVAR_ARCHIVE },
       { &g_intermissiontime, "g_intermissiontime", "15",  CVAR_ARCHIVE },
       { &g_powerupchangetime, "g_powerupchangetime", "60", CVAR_ARCHIVE },
       { &g_invisibility, "g_invisibility", "1", CVAR_ARCHIVE },
       { &g_quad, "g_quad", "1", CVAR_ARCHIVE },
       { &g_regen, "g_regen", "1", CVAR_ARCHIVE },
       { &g_haste, "g_haste", "1", CVAR_ARCHIVE },
       { &g_battlesuit, "g_battlesuit", "1", 0 },
       { &g_flight, "g_flight", "1", CVAR_ARCHIVE },
       { &machinegunammo, "machinegunammo", "50", CVAR_ARCHIVE },
       { &shotgunammo, "shotgunammo", "10", CVAR_ARCHIVE },
       { &grenadeammo, "grenadeammo", "6", CVAR_ARCHIVE },
       { &rocketammo, "rocketammo", "5", CVAR_ARCHIVE },
       { &lightningammo, "lightningammo", "60", CVAR_ARCHIVE },
       { &railgunammo, "railgunammo", "10", CVAR_ARCHIVE },
       { &plasmaammo, "plasmaammo", "30", CVAR_ARCHIVE },
       { &bfgammo, "bfgammo", "50", CVAR_ARCHIVE },
       { &ftammo, "ftammo", "80", CVAR_ARCHIVE },
       { &g_instagib, "g_instagib", "0", CVAR_ARCHIVE },
       { &g_maxpenetration, "g_maxpenetration", "0", CVAR_ARCHIVE },
       { &g_telefraginstagib, "g_telefraginstagib", "0", CVAR_ARCHIVE },
       { &doublerockets, "doublerockets", "0", CVAR_ARCHIVE },
       { &guidedrockets, "guidedrockets", "0", CVAR_ARCHIVE },
       { &cg_rocketshaders, "cg_rocketshaders", "0", CVAR_ARCHIVE },
       { &cg_selectgauntlet, "cg_selectgauntlet", "0", CVAR_ARCHIVE },
       { &cg_selectgrapple, "cg_selectgrapple", "1", CVAR_ARCHIVE },
       { &cg_weaponselectstyle, "cg_weaponselectstyle", "0", CVAR_ARCHIVE },
       { &g_teamcoloredskins, "g_teamcoloredskins", "1", CVAR_ARCHIVE },
       { &cg_progressivezooming, "cg_progressivezooming", "0", CVAR_ARCHIVE },
       { &cg_3rdpersoncrosshair, "cg_3rdpersoncrosshair", "0", CVAR_ARCHIVE },
       { &homingmissile, "homingmissile", "0", CVAR_ARCHIVE },
       { &g_camptimeout, "g_camptimeout", "15", CVAR_ARCHIVE },
       { &g_campprotect, "g_campprotect", "0", CVAR_SERVERINFO | CVAR_ARCHIVE },
       { &g_campshuffle, "g_campshuffle", "100", CVAR_ARCHIVE },
       { &g_falling, "g_falling", "1",  CVAR_ARCHIVE  },
       { &g_selfdamage, "g_selfdamage", "1",  CVAR_ARCHIVE  },
       { &g_damagescale, "g_damagescale", "1",  CVAR_ARCHIVE  },
       { &gtdamage, "gtdamage", "50",  CVAR_ARCHIVE },
       { &mgdamage, "mgdamage", "7",  CVAR_ARCHIVE },
       { &sgdamage, "sgdamage", "10",  CVAR_ARCHIVE },
       { &gldamage, "gldamage", "100",  CVAR_ARCHIVE },
       { &rldamage, "rldamage", "100",  CVAR_ARCHIVE },
       { &lgdamage, "lgdamage", "8",  CVAR_ARCHIVE },
       { &rgdamage, "rgdamage", "100",  CVAR_ARCHIVE },
       { &runeflags, "runeflags", "63",  CVAR_ARCHIVE },
       { &pgdamage, "pgdamage", "20",  CVAR_ARCHIVE },
       { &bfgdamage, "bfgdamage", "100",  CVAR_ARCHIVE },
       { &ftdamage, "ftdamage", "15",  CVAR_ARCHIVE },
       { &randomweap, "randomweap", "0", CVAR_ARCHIVE }, // randomweapons
       { &g_camstyle, "g_camstyle", "0", CVAR_ARCHIVE },
       { &g_camtype, "g_camtype", "0", CVAR_ARCHIVE },
       { &fastswitch, "fastswitch", "0", CVAR_ARCHIVE }, // fast weapon switching
       { &lightningtype, "lightningtype", "0", CVAR_ARCHIVE },
       { &grenadevelocity, "grenadevelocity", "700",  CVAR_ARCHIVE },
       { &grapplevelocity, "grapplevelocity", "800",  CVAR_ARCHIVE },
       { &rocketvelocity, "rocketvelocity", "900",  CVAR_ARCHIVE },
       { &plasmavelocity, "plasmavelocity", "2000",  CVAR_ARCHIVE },
       { &bfgvelocity, "bfgvelocity", "2000",  CVAR_ARCHIVE },
       { &bfgtype, "bfgtype", "0",  CVAR_ARCHIVE  },
       { &g_proxytime, "g_proxytime", "15", 0  },
       { &cg_railtype, "cg_railtype", "0", CVAR_ARCHIVE },
       { &cg_weaponposition, "cg_weaponposition", "1", CVAR_ARCHIVE },
	{ &cg_drawAmmoWarning, "cg_drawAmmoWarning", "1", CVAR_ARCHIVE  },
       { &cg_drawscanner, "cg_drawscanner", "0", CVAR_ARCHIVE  },
	{ &cg_drawAttacker, "cg_drawAttacker", "1", CVAR_ARCHIVE  },
       { &cg_directionaldamage, "cg_directionaldamage", "0", CVAR_ARCHIVE },
	{ &cg_drawStatus, "cg_drawStatus", "1", CVAR_ARCHIVE  },
       { &cg_drawsmoke, "cg_drawsmoke", "1", CVAR_ARCHIVE  },
	{ &cg_drawTimer, "cg_drawTimer", "0", CVAR_ARCHIVE  },
	{ &cg_drawFPS, "cg_drawFPS", "0", CVAR_ARCHIVE  },
	{ &cg_draw3dIcons, "cg_draw3dIcons", "1", CVAR_ARCHIVE  },
       { &cg_drawRewards, "cg_drawRewards", "1", CVAR_ARCHIVE },
       { &cg_autouse, "cg_autouse", "0", CVAR_ARCHIVE},
       { &cg_drawMiniScore, "cg_drawMiniScore", "1", CVAR_ARCHIVE },
       { &cg_scorePlum, "cg_scorePlums", "1", CVAR_USERINFO | CVAR_ARCHIVE},
       { &cg_autousehealth, "cg_autousehealth", "20", CVAR_ARCHIVE},
       { &cg_hud, "cg_hud", "0", CVAR_ARCHIVE },
       { &cg_centerhud, "cg_centerhud", "0", CVAR_ARCHIVE },
       { &cg_weaponOrder, "cg_weaponOrder", "1/2/3/4/5/6/7/8/9/10", CVAR_ARCHIVE }, //WarZone
       { &ui_defaultBots, "ui_defaultBots", "daemia phobos mynx", CVAR_ARCHIVE },
	{ &ui_cdkeychecked, "ui_cdkeychecked", "0", CVAR_ROM }
};

int		cvarTableSize = sizeof(cvarTable) / sizeof(cvarTable[0]);


/*
=================
UI_RegisterCvars
=================
*/
void UI_RegisterCvars( void ) {
	int			i;
	cvarTable_t	*cv;

	for ( i = 0, cv = cvarTable ; i < cvarTableSize ; i++, cv++ ) {
		trap_Cvar_Register( cv->vmCvar, cv->cvarName, cv->defaultString, cv->cvarFlags );
	}
}

/*
=================
UI_UpdateCvars
=================
*/
void UI_UpdateCvars( void ) {
	int			i;
	cvarTable_t	*cv;

	for ( i = 0, cv = cvarTable ; i < cvarTableSize ; i++, cv++ ) {
		trap_Cvar_Update( cv->vmCvar );
	}
}
