// Copyright (C) 1999-2000 Id Software, Inc.
//
#ifndef __UI_LOCAL_H__
#define __UI_LOCAL_H__

#include "../game/q_shared.h"
#include "../cgame/tr_types.h"
//NOTE: include the ui_public.h from the new UI
#include "../ui/ui_public.h"
//redefine to old API version
#undef UI_API_VERSION
#define UI_API_VERSION	4
#include "keycodes.h"
#include "../game/bg_public.h"

extern vmCvar_t      ui_matchparts;
extern vmCvar_t	ui_ffa_fraglimit;
extern vmCvar_t	ui_ffa_timelimit;

extern vmCvar_t	ui_tourney_fraglimit;
extern vmCvar_t	ui_tourney_timelimit;

extern vmCvar_t	ui_team_fraglimit;
extern vmCvar_t	ui_team_timelimit;
extern vmCvar_t	ui_team_friendly;

extern vmCvar_t	ui_ctf_capturelimit;
extern vmCvar_t	ui_ctf_timelimit;
extern vmCvar_t	ui_ctf_friendly;

extern vmCvar_t	ui_arenasFile;
extern vmCvar_t	ui_botsFile;
extern vmCvar_t	ui_spScores1;
extern vmCvar_t	ui_spScores2;
extern vmCvar_t	ui_spScores3;
extern vmCvar_t	ui_spScores4;
extern vmCvar_t	ui_spScores5;
extern vmCvar_t	ui_spAwards;
extern vmCvar_t	ui_spVideos;
extern vmCvar_t	ui_spSkill;

extern vmCvar_t	ui_spSelection;

extern vmCvar_t	ui_browserMaster;
extern vmCvar_t	ui_browserGameType;
extern vmCvar_t	ui_browserSortKey;
extern vmCvar_t	ui_browserShowFull;
extern vmCvar_t	ui_browserShowEmpty;

extern vmCvar_t	ui_brassTime;
extern vmCvar_t	ui_drawCrosshair;
extern vmCvar_t	ui_drawCrosshairNames;
extern vmCvar_t	ui_marks;

extern vmCvar_t	ui_server1;
extern vmCvar_t	ui_server2;
extern vmCvar_t	ui_server3;
extern vmCvar_t	ui_server4;
extern vmCvar_t	ui_server5;
extern vmCvar_t	ui_server6;
extern vmCvar_t	ui_server7;
extern vmCvar_t	ui_server8;
extern vmCvar_t	ui_server9;
extern vmCvar_t	ui_server10;
extern vmCvar_t	ui_server11;
extern vmCvar_t	ui_server12;
extern vmCvar_t	ui_server13;
extern vmCvar_t	ui_server14;
extern vmCvar_t	ui_server15;
extern vmCvar_t	ui_server16;

extern vmCvar_t	ui_cdkey;
extern vmCvar_t	ui_cdkeychecked;
extern vmCvar_t      ui_cache;
extern vmCvar_t      ui_allmaps;
extern vmCvar_t      ui_listmode;
extern vmCvar_t      ui_randombot;
extern vmCvar_t      ui_spectator;
extern vmCvar_t      ui_record;
extern vmCvar_t      ui_music;
extern vmCvar_t      ui_gravity;
extern vmCvar_t      randomweap;
extern vmCvar_t      homingmissile;
extern vmCvar_t      grenadetype;
extern vmCvar_t      gametype;
extern vmCvar_t ui_defaultBots;
extern vmCvar_t      g_mgweap;
extern vmCvar_t      g_sgweap;
extern vmCvar_t      g_glweap;
extern vmCvar_t      g_rlweap;
extern vmCvar_t      g_lgweap;
extern vmCvar_t      g_rgweap;
extern vmCvar_t      g_pgweap;
extern vmCvar_t      g_bfgweap;
extern vmCvar_t      g_mgammo;
extern vmCvar_t      g_sgammo;
extern vmCvar_t      g_glammo;
extern vmCvar_t      g_rlammo;
extern vmCvar_t      g_lgammo;
extern vmCvar_t      g_rgammo;
extern vmCvar_t      g_pgammo;
extern vmCvar_t      g_bfgammo;
extern vmCvar_t      gtscore;
extern vmCvar_t      mgscore;
extern vmCvar_t      sgscore;
extern vmCvar_t      glscore;
extern vmCvar_t      rlscore;
extern vmCvar_t      lgscore;
extern vmCvar_t      rgscore;
extern vmCvar_t      pgscore;
extern vmCvar_t      bfgscore;
extern vmCvar_t      ftscore;
extern vmCvar_t      g_mgrespawn;
extern vmCvar_t      g_sgrespawn;
extern vmCvar_t      g_glrespawn;
extern vmCvar_t      g_rlrespawn;
extern vmCvar_t      g_lgrespawn;
extern vmCvar_t      g_rgrespawn;
extern vmCvar_t      g_pgrespawn;
extern vmCvar_t      g_bfgrespawn;
extern vmCvar_t      g_mgammorespawn;
extern vmCvar_t      g_sgammorespawn;
extern vmCvar_t      g_glammorespawn;
extern vmCvar_t      g_rlammorespawn;
extern vmCvar_t      g_lgammorespawn;
extern vmCvar_t      g_rgammorespawn;
extern vmCvar_t      g_pgammorespawn;
extern vmCvar_t      g_bfgammorespawn;
extern vmCvar_t      g_mgreload;
extern vmCvar_t      g_gpreload;
extern vmCvar_t      g_sgreload;
extern vmCvar_t      g_glreload;
extern vmCvar_t      g_rlreload;
extern vmCvar_t      runeflags;
extern vmCvar_t      g_lgreload;
extern vmCvar_t      g_rgreload;
extern vmCvar_t      g_pgreload;
extern vmCvar_t      g_bfgreload;
extern vmCvar_t      startwithsgammo;
extern vmCvar_t      startwithrlammo;
extern vmCvar_t      startwithglammo;
extern vmCvar_t      startwithlgammo;
extern vmCvar_t      startwithpgammo;
extern vmCvar_t      startwithmgammo;
extern vmCvar_t      startwithbfgammo;
extern vmCvar_t      startwithftammo;
extern vmCvar_t      startwithrgammo;
extern vmCvar_t      g_intermissiontime;
extern vmCvar_t      machinegunammo;
extern vmCvar_t      shotgunammo;
extern vmCvar_t      grenadeammo;
extern vmCvar_t      rocketammo;
extern vmCvar_t      lightningammo;
extern vmCvar_t      railgunammo;
extern vmCvar_t      plasmaammo;
extern vmCvar_t      bfgammo;
extern vmCvar_t      g_falling;
extern vmCvar_t      g_selfdamage;
extern vmCvar_t      ui_mapsource;
extern vmCvar_t      starthealth;
extern vmCvar_t      startarmor;
extern vmCvar_t      maxhealth;
extern vmCvar_t      ui_gametype;
extern vmCvar_t      gravity;
extern vmCvar_t      g_instagib;
extern vmCvar_t      g_maxpenetration;
extern vmCvar_t      g_telefraginstagib;
extern vmCvar_t      g_vampire;
extern vmCvar_t      g_vampiresteal;
extern vmCvar_t      g_vampiremax;
extern vmCvar_t      doublerockets;
extern vmCvar_t      guidedrockets;
extern vmCvar_t      cg_selectgauntlet;
extern vmCvar_t      cg_selectgrapple;
extern vmCvar_t      cg_rocketshaders;
extern vmCvar_t      cg_weaponselectstyle;
extern vmCvar_t      cg_progressivezooming;
extern vmCvar_t      cg_3rdpersoncrosshair;
extern vmCvar_t      g_teamcoloredskins;
extern vmCvar_t      homingmissile;
extern vmCvar_t      bot_nochat;
extern vmCvar_t      bot_fastchat;
extern vmCvar_t      bot_challenge;
extern vmCvar_t      bot_rocketjump;
extern vmCvar_t      cg_directionaldamage;
extern vmCvar_t      cg_drawsmoke;
extern vmCvar_t      cg_drawscanner;
extern vmCvar_t      cg_hud;
extern vmCvar_t      cg_centerhud;       
extern vmCvar_t      cg_autouse;
extern vmCvar_t      cg_autousehealth;
extern vmCvar_t      cg_drawTimer;
extern vmCvar_t      cg_drawFPS;
extern vmCvar_t      cg_draw3dIcons;
extern vmCvar_t      cg_drawAmmoWarning;
extern vmCvar_t      cg_drawRewards;
extern vmCvar_t      cg_drawStatus;
extern vmCvar_t      cg_drawAttacker;
extern vmCvar_t      g_falling;
extern vmCvar_t      g_selfdamage;
extern vmCvar_t      g_fixedfov;
extern vmCvar_t      g_nofootsteps;
extern vmCvar_t      g_knockback;
extern vmCvar_t      g_quadfactor;
extern vmCvar_t      g_damagescale;
extern vmCvar_t      g_podiumscores;
extern vmCvar_t      g_forcerespawn;
extern vmCvar_t      g_spawnprotect;
extern vmCvar_t      gtscore;
extern vmCvar_t      mgscore;
extern vmCvar_t      sgscore;
extern vmCvar_t      glscore;
extern vmCvar_t      rlscore;
extern vmCvar_t      lgscore;
extern vmCvar_t      rgscore;
extern vmCvar_t      pgscore;
extern vmCvar_t      bfgscore;
extern vmCvar_t      ftscore;
extern vmCvar_t      g_spawnrandomsg;
extern vmCvar_t      g_spawnrandomgl;
extern vmCvar_t      g_spawnrandomrl;
extern vmCvar_t      g_spawnrandomlg;
extern vmCvar_t      g_spawnrandomrg;
extern vmCvar_t      g_spawnrandompg;
extern vmCvar_t      g_spawnrandombfg;
extern vmCvar_t      g_spawnrandomft;
extern vmCvar_t      cg_weaponposition;
extern vmCvar_t      startwithpoweruptime;
extern vmCvar_t      g_camstyle;
extern vmCvar_t      g_camtype;
extern vmCvar_t             cg_railtype;
extern vmCvar_t      lightningtype;
extern vmCvar_t      g_proxytime;
extern vmCvar_t      g_mg;
extern vmCvar_t      g_sg;
extern vmCvar_t      g_gl;
extern vmCvar_t      g_rl;
extern vmCvar_t      g_lg;
extern vmCvar_t      g_rg;
extern vmCvar_t      g_pg;
extern vmCvar_t      g_bfg;
extern vmCvar_t      g_ft;
extern vmCvar_t      g_weaponchangetime;
extern vmCvar_t      g_powerupchangetime;
extern vmCvar_t      startwithpowerups;
extern vmCvar_t      g_invisibility;
extern vmCvar_t      glsradius;
extern vmCvar_t      glsdamage;
extern vmCvar_t      rlsradius;
extern vmCvar_t      rlsdamage;
extern vmCvar_t      bfgsradius;
extern vmCvar_t      bfgsdamage;
extern vmCvar_t      pgsradius;
extern vmCvar_t      pgsdamage;
extern vmCvar_t      g_quad;
extern vmCvar_t      g_flight;
extern vmCvar_t      g_haste;
extern vmCvar_t      g_regen;
extern vmCvar_t      g_battlesuit;
extern vmCvar_t      startwithsg;
extern vmCvar_t      startwithrl;
extern vmCvar_t      startwithgl;
extern vmCvar_t      startwithlg;
extern vmCvar_t      startwithpg;
extern vmCvar_t      startwithmg;
extern vmCvar_t      startwithbfg;
extern vmCvar_t      startwithft;
extern vmCvar_t      startwithrg;
extern vmCvar_t      g_campprotect;
extern vmCvar_t      g_camptimeout;
extern vmCvar_t      g_campshuffle;
extern vmCvar_t      gtdamage;
extern vmCvar_t      mgdamage;
extern vmCvar_t      sgdamage;
extern vmCvar_t      gldamage;
extern vmCvar_t      rldamage;
extern vmCvar_t      lgdamage;
extern vmCvar_t      rgdamage;
extern vmCvar_t      pgdamage;
extern vmCvar_t      bfgdamage;
extern vmCvar_t      ftdamage;
extern vmCvar_t      ui_ffa_skill;
extern vmCvar_t      ui_team_skill;
extern vmCvar_t      ui_tourney_skill;
extern vmCvar_t      ui_ctf_skill;
extern vmCvar_t      g_warmup;
extern vmCvar_t      g_ftrespawn;
extern vmCvar_t      g_ftammorespawn;
extern vmCvar_t      g_ftreload;
extern vmCvar_t      ftammo;
extern vmCvar_t      grenadevelocity;
extern vmCvar_t      grapplevelocity;
extern vmCvar_t      rocketvelocity;
extern vmCvar_t      plasmavelocity;
extern vmCvar_t      bfgvelocity;
extern vmCvar_t      bfgtype;
extern vmCvar_t      cg_weaponOrder;
extern vmCvar_t      cg_drawMiniScore;
extern vmCvar_t      cg_scorePlum;

//
// ui_qmenu.c
//

#define RCOLUMN_OFFSET			( BIGCHAR_WIDTH )
#define LCOLUMN_OFFSET			(-BIGCHAR_WIDTH )

#define SLIDER_RANGE			10
#define	MAX_EDIT_LINE			256

#define MAX_MENUDEPTH			8
#define MAX_MENUITEMS                     128

#define MTYPE_NULL				0
#define MTYPE_SLIDER			1	
#define MTYPE_ACTION			2
#define MTYPE_SPINCONTROL		3
#define MTYPE_FIELD				4
#define MTYPE_RADIOBUTTON		5
#define MTYPE_BITMAP			6	
#define MTYPE_TEXT				7
#define MTYPE_SCROLLLIST		8
#define MTYPE_PTEXT				9
#define MTYPE_BTEXT				10

#define QMF_BLINK				0x00000001
#define QMF_SMALLFONT			0x00000002
#define QMF_LEFT_JUSTIFY		0x00000004
#define QMF_CENTER_JUSTIFY		0x00000008
#define QMF_RIGHT_JUSTIFY		0x00000010
#define QMF_NUMBERSONLY			0x00000020	// edit field is only numbers
#define QMF_HIGHLIGHT			0x00000040
#define QMF_HIGHLIGHT_IF_FOCUS	0x00000080	// steady focus
#define QMF_PULSEIFFOCUS		0x00000100	// pulse if focus
#define QMF_HASMOUSEFOCUS		0x00000200
#define QMF_NOONOFFTEXT			0x00000400
#define QMF_MOUSEONLY			0x00000800	// only mouse input allowed
#define QMF_HIDDEN				0x00001000	// skips drawing
#define QMF_GRAYED				0x00002000	// grays and disables
#define QMF_INACTIVE			0x00004000	// disables any input
#define QMF_NODEFAULTINIT		0x00008000	// skip default initialization
#define QMF_OWNERDRAW			0x00010000
#define QMF_PULSE				0x00020000
#define QMF_LOWERCASE			0x00040000	// edit field is all lower case
#define QMF_UPPERCASE			0x00080000	// edit field is all upper case
#define QMF_SILENT				0x00100000

// callback notifications
#define QM_GOTFOCUS				1
#define QM_LOSTFOCUS			2
#define QM_ACTIVATED			3
#define QM_EDITCHANGED                    4
typedef struct _tag_menuframework
{
	int	cursor;
	int cursor_prev;

	int	nitems;
	void *items[MAX_MENUITEMS];

	void (*draw) (void);
	sfxHandle_t (*key) (int key);

	qboolean	wrapAround;
	qboolean	fullscreen;
	qboolean	showlogo;
} menuframework_s;

typedef struct
{
	int type;
	const char *name;
	int	id;
	int x, y;
	int left;
	int	top;
	int	right;
	int	bottom;
	menuframework_s *parent;
	int menuPosition;
	unsigned flags;

	void (*callback)( void *self, int event );
	void (*statusbar)( void *self );
	void (*ownerdraw)( void *self );
} menucommon_s;

typedef struct {
	int		cursor;
	int		scroll;
	int		widthInChars;
	char	buffer[MAX_EDIT_LINE];
	int		maxchars;
} mfield_t;

typedef struct
{
	menucommon_s	generic;
	mfield_t		field;
} menufield_s;

typedef struct 
{
	menucommon_s generic;

	float minvalue;
	float maxvalue;
	float curvalue;

	float range;
} menuslider_s;

typedef struct
{
	menucommon_s generic;

	int	oldvalue;
	int curvalue;
	int	numitems;
	int	top;
		
	const char **itemnames;

	int width;
	int height;
	int	columns;
	int	seperation;
} menulist_s;

typedef struct
{
	menucommon_s generic;
} menuaction_s;

typedef struct
{
	menucommon_s generic;
	int curvalue;
} menuradiobutton_s;

typedef struct
{
	menucommon_s	generic;
	char*			focuspic;	
	char*			errorpic;
	qhandle_t		shader;
	qhandle_t		focusshader;
	int				width;
	int				height;
	float*			focuscolor;
} menubitmap_s;

typedef struct
{
	menucommon_s	generic;
	char*			string;
	int				style;
	float*			color;
} menutext_s;

extern void                 Menu_Cache( void );
extern void			Menu_Focus( menucommon_s *m );
extern void			Menu_AddItem( menuframework_s *menu, void *item );
extern void			Menu_AdjustCursor( menuframework_s *menu, int dir );
extern void			Menu_Draw( menuframework_s *menu );
extern void			*Menu_ItemAtCursor( menuframework_s *m );
extern sfxHandle_t	Menu_ActivateItem( menuframework_s *s, menucommon_s* item );
extern void			Menu_SetCursor( menuframework_s *s, int cursor );
extern void			Menu_SetCursorToItem( menuframework_s *m, void* ptr );
extern sfxHandle_t	Menu_DefaultKey( menuframework_s *s, int key );
extern void			Bitmap_Init( menubitmap_s *b );
extern void			Bitmap_Draw( menubitmap_s *b );
extern void			ScrollList_Draw( menulist_s *l );
extern sfxHandle_t	ScrollList_Key( menulist_s *l, int key );
extern sfxHandle_t	menu_in_sound;
extern sfxHandle_t	menu_move_sound;
extern sfxHandle_t	menu_out_sound;
extern sfxHandle_t	menu_buzz_sound;
extern sfxHandle_t	menu_null_sound;
extern sfxHandle_t	weaponChangeSound;
extern vec4_t		menu_text_color;
extern vec4_t		menu_grayed_color;
extern vec4_t		menu_dark_color;
extern vec4_t		menu_highlight_color;
extern vec4_t		menu_red_color;
extern vec4_t		menu_black_color;
extern vec4_t		menu_dim_color;
extern vec4_t		color_black;
extern vec4_t		color_white;
extern vec4_t		color_yellow;
extern vec4_t		color_blue;
extern vec4_t		color_orange;
extern vec4_t		color_red;
extern vec4_t		color_dim;
extern vec4_t		name_color;
extern vec4_t		list_color;
extern vec4_t		listbar_color;
extern vec4_t		text_color_disabled; 
extern vec4_t		text_color_normal;
extern vec4_t		text_color_highlight;

extern char	*ui_medalNames[];
extern char	*ui_medalPicNames[];
extern char	*ui_medalSounds[];

//
// ui_mfield.c
//
extern void			MField_Clear( mfield_t *edit );
extern void			MField_KeyDownEvent( mfield_t *edit, int key );
extern void			MField_CharEvent( mfield_t *edit, int ch );
extern void			MField_Draw( mfield_t *edit, int x, int y, int style, vec4_t color );
extern void			MenuField_Init( menufield_s* m );
extern void			MenuField_Draw( menufield_s *f );
extern sfxHandle_t	MenuField_Key( menufield_s* m, int* key );

//
// ui_menu.c
//
extern void MainMenu_Cache( void );
extern void UI_MainMenu(void);
extern void UI_RegisterCvars( void );
extern void UI_UpdateCvars( void );

//
// ui_credits.c
//
extern void UI_CreditMenu( void );

//
// ui_ingame.c
//
extern void InGame_Cache( void );
extern void UI_InGameMenu(void);

//
// ui_confirm.c
//
extern void ConfirmMenu_Cache( void );
extern void UI_ConfirmMenu( const char *question, void (*draw)( void ), void (*action)( qboolean result ) );

//
// ui_setup.c
//
extern void UI_SetupMenu_Cache( void );
extern void UI_SetupMenu(void);

//
// ui_team.c
//
extern void UI_TeamMainMenu( void );
extern void TeamMain_Cache( void );

//
// ui_connect.c
//
extern void UI_DrawConnectScreen( qboolean overlay );

//
// ui_controls2.c
//
extern void UI_ControlsMenu( void );
extern void Controls_Cache( void );

//
// ui_demo2.c
//
extern void UI_DemosMenu( void );
extern void Demos_Cache( void );

//
// ui_cinematics.c
//
extern void UI_CinematicsMenu( void );
extern void UI_CinematicsMenu_f( void );
extern void UI_CinematicsMenu_Cache( void );

//
// ui_music.c
//
extern void UI_MusicMenu( void );
extern void UI_MusicMenu_Cache( void );

//
// ui_mods.c
//
extern void UI_ModsMenu( void );
extern void UI_ModsMenu_Cache( void );

//
// ui_cdkey.c
//
extern void UI_CDKeyMenu( void );
extern void UI_CDKeyMenu_Cache( void );
extern void UI_CDKeyMenu_f( void );

//
// ui_playermodel.c
//
extern void UI_PlayerModelMenu( void );
extern void PlayerModel_Cache( void );

//
// ui_playersettings.c
//
extern void UI_PlayerSettingsMenu( void );
extern void PlayerSettings_Cache( void );

//
// ui_preferences.c
//
extern void UI_PreferencesMenu( void );
extern void Preferences_Cache( void );

//
// ui_specifyleague.c
//
extern void UI_SpecifyLeagueMenu( void );
extern void SpecifyLeague_Cache( void );

//
// ui_specifyserver.c
//
extern void UI_SpecifyServerMenu( void );
extern void SpecifyServer_Cache( void );

//
// ui_preftest.c
//
extern void UI_Preferences2Menu( void );
extern void Hellfire_Cache( void );

//
// ui_servers2.c
//
#define MAX_FAVORITESERVERS 16

extern void UI_ArenaServersMenu( void );
extern void ArenaServers_Cache( void );

//
// ui_startserver.c
//
extern void UI_StartServerMenu( qboolean multiplayer, int addmap );
extern void StartServer_Cache( void );
extern void ServerOptions_Cache( void );
extern void UI_BotSelectMenu( char *bot );
extern void UI_BotSelectMenu_Cache( void );

//
// ui_serverinfo.c
//
extern void UI_ServerInfoMenu( void );
extern void ServerInfo_Cache( void );

extern void UI_StartServerMenuSP_f( void );
extern void UI_StartServerMenuMP_f( void );

//
// ui_video.c
//
extern void UI_GraphicsOptionsMenu( void );
extern void GraphicsOptions_Cache( void );
extern void DriverInfo_Cache( void );

//
// ui_players.c
//

//FIXME ripped from cg_local.h
typedef struct {
	int			oldFrame;
	int			oldFrameTime;		// time when ->oldFrame was exactly on

	int			frame;
	int			frameTime;			// time when ->frame will be exactly on

	float		backlerp;

	float		yawAngle;
	qboolean	yawing;
	float		pitchAngle;
	qboolean	pitching;

	int			animationNumber;	// may include ANIM_TOGGLEBIT
	animation_t	*animation;
	int			animationTime;		// time when the first frame of the animation will be exact
} lerpFrame_t;

typedef struct {
	// model info
	qhandle_t		legsModel;
	qhandle_t		legsSkin;
	lerpFrame_t		legs;

	qhandle_t		torsoModel;
	qhandle_t		torsoSkin;
	lerpFrame_t		torso;

	qhandle_t		headModel;
	qhandle_t		headSkin;

	animation_t		animations[MAX_ANIMATIONS];

	qhandle_t		weaponModel;
	qhandle_t		barrelModel;
	qhandle_t		flashModel;
	vec3_t			flashDlightColor;
	int				muzzleFlashTime;

	// currently in use drawing parms
	vec3_t			viewAngles;
	vec3_t			moveAngles;
	weapon_t		currentWeapon;
	int				legsAnim;
	int				torsoAnim;

	// animation vars
	weapon_t		weapon;
	weapon_t		lastWeapon;
	weapon_t		pendingWeapon;
	int				weaponTimer;
	int				pendingLegsAnim;
	int				torsoAnimationTimer;

	int				pendingTorsoAnim;
	int				legsAnimationTimer;

	qboolean		chat;
	qboolean		newModel;

	qboolean		barrelSpinning;
	float			barrelAngle;
	int				barrelTime;

	int				realWeapon;
} playerInfo_t;

void UI_DrawPlayer( float x, float y, float w, float h, playerInfo_t *pi, int time );
void UI_PlayerInfo_SetModel( playerInfo_t *pi, const char *model ,const char *headmodel);
void UI_PlayerInfo_SetInfo( playerInfo_t *pi, int legsAnim, int torsoAnim, vec3_t viewAngles, vec3_t moveAngles, weapon_t weaponNum, qboolean chat );
qboolean UI_RegisterClientModelname( playerInfo_t *pi, const char *modelSkinName , const char *modelHeadName);

//
// ui_atoms.c
//
typedef struct {
	int					frametime;
	int					realtime;
	int					cursorx;
	int					cursory;
	int					menusp;
	menuframework_s*	activemenu;
	menuframework_s*	stack[MAX_MENUDEPTH];
	glconfig_t			glconfig;
	qboolean			debug;
	qhandle_t			whiteShader;
	qhandle_t			menuBackShader;
       qhandle_t                   titleShader;
       qhandle_t                   title2Shader;
	qhandle_t			menuBackNoLogoShader;
	qhandle_t			charset;
	qhandle_t			charsetProp;
	qhandle_t			charsetPropGlow;
	qhandle_t			charsetPropB;
	qhandle_t			cursor;
	qhandle_t			rb_on;
	qhandle_t			rb_off;
	float				scale;
	float				bias;
	qboolean			demoversion;
	qboolean			firstdraw;
} uiStatic_t;

extern void			UI_Init( void );
extern void			UI_Shutdown( void );
extern void			UI_KeyEvent( int key, int down );
extern void			UI_MouseEvent( int dx, int dy );
extern void			UI_Refresh( int realtime );
extern qboolean		UI_ConsoleCommand( int realTime );
extern float		UI_ClampCvar( float min, float max, float value );
extern void			UI_DrawNamedPic( float x, float y, float width, float height, const char *picname );
extern void			UI_DrawHandlePic( float x, float y, float w, float h, qhandle_t hShader ); 
extern void			UI_FillRect( float x, float y, float width, float height, const float *color );
extern void			UI_DrawRect( float x, float y, float width, float height, const float *color );
extern void			UI_UpdateScreen( void );
extern void			UI_SetColor( const float *rgba );
extern void			UI_LerpColor(vec4_t a, vec4_t b, vec4_t c, float t);
extern void			UI_DrawBannerString( int x, int y, const char* str, int style, vec4_t color );
extern float		UI_ProportionalSizeScale( int style );
extern void			UI_DrawProportionalString( int x, int y, const char* str, int style, vec4_t color );
extern int			UI_ProportionalStringWidth( const char* str );
extern void			UI_DrawString( int x, int y, const char* str, int style, vec4_t color );
extern void			UI_DrawChar( int x, int y, int ch, int style, vec4_t color );
extern qboolean 	UI_CursorInRect (int x, int y, int width, int height);
extern void			UI_AdjustFrom640( float *x, float *y, float *w, float *h );
extern void			UI_DrawTextBox (int x, int y, int width, int lines);
extern qboolean		UI_IsFullscreen( void );
extern void			UI_SetActiveMenu( uiMenuCommand_t menu );
extern void			UI_PushMenu ( menuframework_s *menu );
extern void			UI_PopMenu (void);
extern void			UI_ForceMenuOff (void);
extern char			*UI_Argv( int arg );
extern char			*UI_Cvar_VariableString( const char *var_name );
extern void			UI_Refresh( int time );
extern void			UI_StartDemoLoop( void );
extern qboolean		m_entersound;
extern uiStatic_t	uis;

//
// ui_spLevel.c
//
void UI_SPLevelMenu_Cache( void );
void UI_SPLevelMenu( void );
void UI_SPLevelMenu_f( void );
void UI_SPLevelMenu_ReInit( void );

//
// ui_spArena.c
//
void UI_SPArena_Start( const char *arenaInfo );

//
// ui_spPostgame.c
//
void UI_SPPostgameMenu_Cache( void );
void UI_SPPostgameMenu_f( void );

//
// ui_spSkill.c
//
void UI_SPSkillMenu( const char *arenaInfo );
void UI_SPSkillMenu_Cache( void );

//
// ui_syscalls.c
//
void			trap_Print( const char *string );
void			trap_Error( const char *string );
int				trap_Milliseconds( void );
void			trap_Cvar_Register( vmCvar_t *vmCvar, const char *varName, const char *defaultValue, int flags );
void			trap_Cvar_Update( vmCvar_t *vmCvar );
void			trap_Cvar_Set( const char *var_name, const char *value );
float			trap_Cvar_VariableValue( const char *var_name );
void			trap_Cvar_VariableStringBuffer( const char *var_name, char *buffer, int bufsize );
void			trap_Cvar_SetValue( const char *var_name, float value );
void			trap_Cvar_Reset( const char *name );
void			trap_Cvar_Create( const char *var_name, const char *var_value, int flags );
void			trap_Cvar_InfoStringBuffer( int bit, char *buffer, int bufsize );
int				trap_Argc( void );
void			trap_Argv( int n, char *buffer, int bufferLength );
void			trap_Cmd_ExecuteText( int exec_when, const char *text );	// don't use EXEC_NOW!
int				trap_FS_FOpenFile( const char *qpath, fileHandle_t *f, fsMode_t mode );
void			trap_FS_Read( void *buffer, int len, fileHandle_t f );
void			trap_FS_Write( const void *buffer, int len, fileHandle_t f );
void			trap_FS_FCloseFile( fileHandle_t f );
int				trap_FS_GetFileList(  const char *path, const char *extension, char *listbuf, int bufsize );
qhandle_t		trap_R_RegisterModel( const char *name );
qhandle_t		trap_R_RegisterSkin( const char *name );
qhandle_t		trap_R_RegisterShaderNoMip( const char *name );
void			trap_R_ClearScene( void );
void			trap_R_AddRefEntityToScene( const refEntity_t *re );
void			trap_R_AddPolyToScene( qhandle_t hShader , int numVerts, const polyVert_t *verts );
void			trap_R_AddLightToScene( const vec3_t org, float intensity, float r, float g, float b );
void			trap_R_RenderScene( const refdef_t *fd );
void			trap_R_SetColor( const float *rgba );
void			trap_R_DrawStretchPic( float x, float y, float w, float h, float s1, float t1, float s2, float t2, qhandle_t hShader );
void			trap_UpdateScreen( void );
int				trap_CM_LerpTag( orientation_t *tag, clipHandle_t mod, int startFrame, int endFrame, float frac, const char *tagName );
void			trap_S_StartLocalSound( sfxHandle_t sfx, int channelNum );
sfxHandle_t	trap_S_RegisterSound( const char *sample, qboolean compressed );
void			trap_Key_KeynumToStringBuf( int keynum, char *buf, int buflen );
void			trap_Key_GetBindingBuf( int keynum, char *buf, int buflen );
void			trap_Key_SetBinding( int keynum, const char *binding );
qboolean		trap_Key_IsDown( int keynum );
qboolean		trap_Key_GetOverstrikeMode( void );
void			trap_Key_SetOverstrikeMode( qboolean state );
void			trap_Key_ClearStates( void );
int				trap_Key_GetCatcher( void );
void			trap_Key_SetCatcher( int catcher );
void			trap_GetClipboardData( char *buf, int bufsize );
void			trap_GetClientState( uiClientState_t *state );
void			trap_GetGlconfig( glconfig_t *glconfig );
int				trap_GetConfigString( int index, char* buff, int buffsize );
int				trap_LAN_GetServerCount( int source );
void			trap_LAN_GetServerAddressString( int source, int n, char *buf, int buflen );
void			trap_LAN_GetServerInfo( int source, int n, char *buf, int buflen );
int				trap_LAN_GetPingQueueCount( void );
int				trap_LAN_ServerStatus( char *serverAddress, char *serverStatus, int maxLen );
void			trap_LAN_ClearPing( int n );
void			trap_LAN_GetPing( int n, char *buf, int buflen, int *pingtime );
void			trap_LAN_GetPingInfo( int n, char *buf, int buflen );
int				trap_MemoryRemaining( void );
void			trap_GetCDKey( char *buf, int buflen );
void			trap_SetCDKey( char *buf );

//
// ui_addbots.c
//
void UI_AddBots_Cache( void );
void UI_AddBotsMenu( void );

//
// ui_removebots.c
//
void UI_RemoveBots_Cache( void );
void UI_RemoveBotsMenu( void );

//
// ui_teamorders.c
//
extern void UI_TeamOrdersMenu( void );
extern void UI_TeamOrdersMenu_f( void );
extern void UI_TeamOrdersMenu_Cache( void );

//
// ui_loadconfig.c
//
void UI_LoadConfig_Cache( void );
void UI_LoadConfigMenu( void );

//
// ui_saveconfig.c
//
void UI_SaveConfigMenu_Cache( void );
void UI_SaveConfigMenu( void );

//
// ui_display.c
//
void UI_DisplayOptionsMenu_Cache( void );
void UI_DisplayOptionsMenu( void );

//
// ui_sound.c
//
void UI_SoundOptionsMenu_Cache( void );
void UI_SoundOptionsMenu( void );

//
// ui_network.c
//
void UI_NetworkOptionsMenu_Cache( void );
void UI_NetworkOptionsMenu( void );

//
// ui_gameinfo.c
//
typedef enum {
	AWARD_ACCURACY,
	AWARD_IMPRESSIVE,
	AWARD_EXCELLENT,
	AWARD_GAUNTLET,
	AWARD_FRAGS,
       AWARD_PERFECT,
       AWARD_ASSIST,
       AWARD_DEFEND,
       AWARD_CAPTURES
} awardType_t;

const char *UI_GetArenaInfoByNumber( int num );
const char *UI_GetArenaInfoByMap( const char *map );
const char *UI_GetSpecialArenaInfo( const char *tag );
int UI_GetNumArenas( void );
int UI_GetNumSPArenas( void );
int UI_GetNumSPTiers( void );

char *UI_GetBotInfoByNumber( int num );
char *UI_GetBotInfoByName( const char *name );
int UI_GetNumBots( void );

void UI_GetBestScore( int level, int *score, int *skill );
void UI_SetBestScore( int level, int score );
int UI_TierCompleted( int levelWon );
qboolean UI_ShowTierVideo( int tier );
qboolean UI_CanShowTierVideo( int tier );
int  UI_GetCurrentGame( void );
void UI_NewGame( void );
void UI_LogAwardData( int award, int data );
int UI_GetAwardLevel( int award );

void UI_SPUnlock_f( void );
void UI_SPUnlockMedals_f( void );

void UI_InitGameinfo( void );

//GRank

//
// ui_rankings.c
//
void Rankings_DrawText( void* self );
void Rankings_DrawName( void* self );
void Rankings_DrawPassword( void* self );
void Rankings_Cache( void );
void UI_RankingsMenu( void );

//
// ui_login.c
//
void Login_Cache( void );
void UI_LoginMenu( void );

//
// ui_signup.c
//
void Signup_Cache( void );
void UI_SignupMenu( void );

//
// ui_rankstatus.c
//
void RankStatus_Cache( void );
void UI_RankStatusMenu( void );

#endif
