// INCLUDE FILES
#include "ui_local.h"

// CONSTANT DEFINITIONS

#define SCROLLSPEED	2.00 // The scrolling speed in pixels per second.
                          // modify as appropriate for our credits
#define BACKGROUND_SHADER "console"
// uncomment this to use a background shader, otherwise a solid color
// defined in the vec4_t "color_background" is filled to the screen
                            
// STRUCTURES

typedef struct {
	menuframework_s	menu;
} creditsmenu_t;

static creditsmenu_t	s_credits;

int starttime; // game time at which credits are started
static float mvolume; // records the original music volume level, as we will
               // modify it for the credits

// change this to change the background colour on credits
vec4_t color_background	        = {0.00, 0.35, 0.69, 1.00};
// these are just example colours that are used in credits[] 
vec4_t color_headertext			= {0.53, 0.77, 1.00, 1.00};
vec4_t color_maintext			= {1.00, 1.00, 1.00, 1.00};

qhandle_t	BackgroundShader; // definition of the background shader pointer
typedef struct
{
	char *string;
	int style;
	vec4_t *colour;
} cr_line;

cr_line credits[] = { // edit this as necessary for your credits
	
{ "-=[ HELLFIRE ARENA v1.5 ]=-", UI_CENTER|UI_BIGFONT|UI_PULSE, &color_red },
{ "Designed by Malcolm Lim", UI_CENTER|UI_SMALLFONT, &color_white },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Special Thanks To:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "ID Software", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Code 3 Arena", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "QuakeStyle", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Inolen", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "W. Ravaine a.k.a. SpK", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Steve Kemper and Manuel Tran", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Spine Design For Advanced UI Code", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "YoGrE For UI Arena Code", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Adam Wright", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Dan 'Neurobasher' Gomes", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Khaile for qwFix Source", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Equim for EliteHud Source", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Chris Hilton for Maxcarnage Source", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Corven for some ideas from Eternal Arena", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Hypothermia for help with some UI related stuff", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Flame Thrower model by Paul Hassett", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Spk & YaYa for Motion Tracker code & graphics", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Paul Jordan for Q3Cam Code", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "The Saracen & Matchmod Team for Rune Stuff", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Human Debris for Telefrag Instagib code", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "iD Software is:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Programming:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "John Carmack, John Cash", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Art:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Adrian Carmack, Kevin Cloud,", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Paul Steed, Kenneth Scott", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Game Designer:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Graeme Devine", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Level Design:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Tim Willits, Christian Antkow", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "Paul Jaquays", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "CEO:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Todd Hollenshead", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Director of Business Development:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Katherine Anna Kang", UI_CENTER|UI_SMALLFONT, &color_maintext },
{ "", UI_CENTER|UI_SMALLFONT, &color_black },
{ "Biz Assist and id mom:", UI_CENTER|UI_SMALLFONT, &color_red },
{ "Donna Jackson", UI_CENTER|UI_SMALLFONT, &color_maintext },

  {NULL}
};
/*
=================
UI_CreditMenu_Key
=================
*/
static sfxHandle_t UI_CreditMenu_Key( int key ) {
	if( key & K_CHAR_FLAG ) {
		return 0;
	}

	// pressing the escape key or clicking the mouse will exit
	// we also reset the music volume to the user's original
	// choice here,  by setting s_musicvolume to the stored var
       trap_Cmd_ExecuteText( EXEC_APPEND, 
                         va("s_musicvolume %f;wait 2;s_stop\n", mvolume));
       trap_Cmd_ExecuteText( EXEC_APPEND, 
                         va("quit\n", mvolume));
	return 0;
}

/*
=================
ScrollingCredits_Draw
This is the main drawing function for the credits. 
Most of the code is self-explanatory.
=================
*/
static void ScrollingCredits_Draw(void)
{
  int x = 320, y, n, ysize = 0, fadetime = 0;
  vec4_t fadecolour = { 0.00, 0.00, 0.00, 0.00 };

  // ysize is used to determine the entire length 
  // of the credits in pixels. 
  // We can then use this in further calculations
  if(!ysize) // ysize not calculated, so calculate it dammit!
  {
    // loop through entire credits array
    for(n = 0; n <= sizeof(credits) - 1; n++) 
    {
      // it is a small character
      if(credits[n].style & UI_SMALLFONT) 
      {
        // add small character height
        ysize += PROP_HEIGHT * PROP_SMALL_SIZE_SCALE;
        
      // it is a big character
      }else if(credits[n].style & UI_BIGFONT) 
      {
        // add big character size
        ysize += PROP_HEIGHT;
        
      // it is a huge character
      }else if(credits[n].style & UI_GIANTFONT) 
      {
        // add giant character size.
        ysize += PROP_HEIGHT * (1 / PROP_SMALL_SIZE_SCALE); 
      }
    }
  }

  // first, fill the background with the specified colour/shader
  // we are drawing a shader
#ifdef BACKGROUND_SHADER 
    UI_DrawHandlePic(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, BackgroundShader);
  
  // we are just filling a color
#else 
    UI_FillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, color_black);
#endif

  // let's draw the stuff
  // set initial y location
  y = 480 - SCROLLSPEED * (float)(uis.realtime - starttime) / 100;
  
  // loop through the entire credits sequence
  for(n = 0; n <= sizeof(credits) - 1; n++)
  {
    // this NULL string marks the end of the credits struct
    if(credits[n].string == NULL) 
    {
      if(y < -16) // credits sequence is completely off screen
      {
       trap_Cmd_ExecuteText( EXEC_APPEND, 
                         va("s_musicvolume %f;wait 2;s_stop\n", mvolume));
       trap_Cmd_ExecuteText( EXEC_APPEND, 
                         va("quit\n", mvolume));
        break; // end of credits
      }
      break;
    }
		
    if( strlen(credits[n].string) == 1) // spacer string, no need to draw
      continue;

    if( y > -(PROP_HEIGHT * (1 / PROP_SMALL_SIZE_SCALE))) 
      // the line is within the visible range of the screen
      UI_DrawProportionalString(x, y, credits[n].string, 
                                credits[n].style, *credits[n].colour );
		
    // re-adjust y for next line
    if(credits[n].style & UI_SMALLFONT)
    {
      y += PROP_HEIGHT * PROP_SMALL_SIZE_SCALE;
    }else if(credits[n].style & UI_BIGFONT)
    {
      y += PROP_HEIGHT;
    }else if(credits[n].style & UI_GIANTFONT)
    {
      y += PROP_HEIGHT * (1 / PROP_SMALL_SIZE_SCALE);
    }

    // if y is off the screen, break out of loop
    if (y > 480)
    break;
  }
}

/*
===============
UI_CreditMenu
===============
*/
void UI_CreditMenu( void ) {
	memset( &s_credits, 0 ,sizeof(s_credits) );

	s_credits.menu.draw = ScrollingCredits_Draw;
	s_credits.menu.key = UI_CreditMenu_Key;
	s_credits.menu.fullscreen = qtrue;
	UI_PushMenu ( &s_credits.menu );

	starttime = uis.realtime; // record start time for credits to scroll properly
	mvolume = trap_Cvar_VariableValue( "s_musicvolume" );
	if(mvolume < 0.5)
		trap_Cmd_ExecuteText( EXEC_APPEND, "s_musicvolume 0.5\n" );
       trap_Cmd_ExecuteText( EXEC_APPEND, "s_stop\n" );
	trap_Cmd_ExecuteText( EXEC_APPEND, "music music/fla22k_02\n" );

	// load the background shader
#ifdef BACKGROUND_SHADER
	BackgroundShader = 
         trap_R_RegisterShaderNoMip("console");
#endif
}
