/*****************************************************************

	Cam Client source code - by Paul Jordan

	..............................................................

	This file is Copyright(c) 2000, Paul Jordan, All Rights Reserved.

	..............................................................

	All other files are Copyright(c) Id Software, Inc.

	Please see QIIIA Game Source License.doc in the source directory for
	the copyright information regarding those files belonging to 
	Id Software, Inc.

	..............................................................
	
	Should you decide to release a modified version of the Camera, you
    MUST include the following text (minus the BEGIN and END lines) in 
    the documentation for your modification, and also on all web pages 
	related to your modifcation, should they exist.

	--- BEGIN ---

	The Client Camera is a product of Paul Jordan, and is available from
	the Quake 3 Camera homepage at http://www.telefragged.com/q3cam, 

	This program is a modification of the Quake 3 Client Camera, and is
    therefore in NO WAY supported by Paul Jordan.

	This program MUST NOT be sold in ANY form. If you have paid for 
	this product, you should contact Paul Jordan immediately, via
	the Quake 3 Camera Client homepage.

	--- END ---

    Adios and have fun,

	Paul Jordan

 *****************************************************************/

#include "g_local.h"
#include "camclient.h"

//#define CAMERA_THOUGHTS

//extern void QDECL G_Printf( const char *fmt, ... ) ;

#define MASK_VISABLE (MASK_OPAQUE)
#define MASK_CAM_COLLISION (MASK_WATER | MASK_PLAYERSOLID)


#define DAMPEN_YAW		10
#define DAMPEN_PITCH	10
#define DAMP_VALUE_XY	5
#define DAMP_VALUE_Z	5

#define TRUE	1
#define FALSE	0

void CameraStaticThink(gentity_t *ent);

gentity_t
    *pDeadPlayer=NULL;

float g_DampenYaw = DAMPEN_YAW;
float g_DampenPitch = DAMPEN_PITCH;
float g_DampenXY = DAMP_VALUE_XY;
float g_DampenZ= DAMP_VALUE_Z;


//============================================================================
//----------------------------------------------------------------------------
//============================================================================
void
CameraCmd(gentity_t *ent, char *cmd)
{
    if ( Q_stricmp(cmd, "follow") == 0)
    {
        ent->client->iMode = CAM_FOLLOW_MODE;
		trap_SendServerCommand( ent->client->ps.clientNum, 
			va("print \"Camera in Follow mode.\n\""));
    }
    else if ( Q_stricmp(cmd, "normal") == 0)
    {
		ent->client->iMode = CAM_NORMAL_MODE;
		trap_SendServerCommand( ent->client->ps.clientNum, 
			va("print \"Camera in Normal mode.\n\""));
    }
    else if ( Q_stricmp(cmd, "qfollow") == 0)
    {
        ent->client->iMode = CAM_QFOLLOW_MODE;
		trap_SendServerCommand( ent->client->ps.clientNum, 
			va("print \"Camera in Quake Follow mode.\n\""));
    }
/*	else if (( Q_stricmp(cmd, "max_xy") == 0) && 
		(ent->client->sess.sessionTeam == TEAM_SPECTATOR))
	{
		if ((fTemp = atof(gi.argv(2))) < 1)
		{
			gi.cprintf (ent, PRINT_HIGH, "Max X/Y delta of %f unchanged!\n",ent->client->fXYLag);
		}
		else
		{
			ent->client->fXYLag = fTemp;
			gi.cprintf (ent, PRINT_HIGH, "Max X/Y delta of %f. set.\n",ent->client->fXYLag);
		}
	}
	else if (( Q_stricmp(gi.argv(1), "max_z") == 0) && ent->client->bIsCamera)
	{
		if ((fTemp = atof(gi.argv(2))) < 1)
		{
			gi.cprintf (ent, PRINT_HIGH, "Max Z delta of %f unchanged!\n",ent->client->fZLag);
		}
		else
		{
			ent->client->fZLag = fTemp;
			gi.cprintf (ent, PRINT_HIGH, "Max Z delta of %f set.\n",ent->client->fZLag);
		}
	}
	else if (( Q_stricmp(gi.argv(1), "max_angle") == 0) && ent->client->bIsCamera)
	{
		if ((fTemp = atof(gi.argv(2))) < 1)
		{
			gi.cprintf (ent, PRINT_HIGH, "Max Yaw Angle delta of %f unchanged!\n",ent->client->fAngleLag);
		}
		else
		{
			ent->client->fAngleLag = fTemp;
			gi.cprintf (ent, PRINT_HIGH, "Max Yaw Angle delta of %f set.\n",ent->client->fAngleLag);
		}
	}*/
}

//============================================================================
// IsVisible
//----------------------------------------------------------------------------
// Used to tell if one player can "see" another.  This does not check if they
// are actually in view of the current player, just that if the player looked
// at any angle that they could see the other player.  Also you long dead
// players are not considered visible.
//============================================================================
qboolean
IsVisible(gentity_t *pPlayer1, gentity_t *pPlayer2)
{
    vec3_t
        vLength;
    int
        distance;
	trace_t
        trace;

	if ((pPlayer1 == NULL) || (pPlayer2 == NULL))
	{
		return FALSE;
	}

	//
	// You cannot see dead people that have been dead for awhile.
	//
	if ((pPlayer2->client->ps.pm_type == PM_DEAD) &&
		(level.time > (pPlayer2->client->respawnTime + CAMERA_DEAD_SWITCH_TIME)))
	{
		return FALSE;
	}

	//
	// You cannot see other spectators.
	//
	if (pPlayer2->client->sess.sessionTeam == TEAM_SPECTATOR)
	{
		return FALSE;
	}

	//
	// If they are not in the same "stuff" then they are not visible
	//
	if (trap_PointContents( pPlayer1->client->ps.origin, pPlayer1->s.clientNum)
		!= trap_PointContents( pPlayer2->client->ps.origin, pPlayer2->s.clientNum))
	{
		return FALSE;
	}

	//
	// Draw a line between the two players and see what we hit.
	//
	trap_Trace(&trace, pPlayer1->client->ps.origin, NULL, NULL,
        pPlayer2->client->ps.origin, ENTITYNUM_NONE, MASK_VISABLE);
	
    vLength[0] = pPlayer1->client->ps.origin[0] - pPlayer2->client->ps.origin[0];
  	vLength[1] = pPlayer1->client->ps.origin[1] - pPlayer2->client->ps.origin[1];
    vLength[2] = pPlayer1->client->ps.origin[2] - pPlayer2->client->ps.origin[2];
    distance = VectorLength(vLength);
    

	//
	// If they are too far away or we hit something the other player
	// is not visible.
	//
    if ((distance < MAX_VISIBLE_RANGE) && (trace.fraction == 1.0))
    {
        return TRUE;
    }
    return FALSE;
}

//============================================================================
// NumPlayersVisible
//----------------------------------------------------------------------------
// How many players can this player "see".
// If we are in teamplay mode then bias toward the highest different team 
// count, this is not great but works ok.
//============================================================================
int
NumPlayersVisible(gentity_t *pViewer)
{
    int
        iTeamCount=0,
		iTotalCount=0,
		i;

	if (pViewer == NULL)
	{
		return 0;
	}
   
    for ( i=0; i < level.maxclients; i++)
    {
		if ( level.clients[i].pers.connected != CON_CONNECTED ) 
		{
			continue;
		}
        if (level.clients[i].sess.sessionTeam == TEAM_SPECTATOR)
		{
			continue;
		}
		
		//
		// You cannot see dead people that have been dead for awhile.
		//
		if ((level.clients[i].ps.pm_type == PM_DEAD) &&
			(level.time > level.clients[i].respawnTime))
		{
			continue;
		}

		//
		// Teammates are not all that interesting??
		//
		if (IsVisible(pViewer, &g_entities[i]))
		{
			iTotalCount++;

			if (pViewer->client->sess.sessionTeam != 
				g_entities[i].client->sess.sessionTeam)
			{
				iTeamCount++;
			}
		}
    }
	
	if (iTeamCount == 0)
	{
		return iTotalCount;
	}
    return iTeamCount;
}

//============================================================================
//----------------------------------------------------------------------------
//============================================================================
float
AngleDiff(float angle1, float angle2)
{
    float 
        fTemp;
    
    fTemp = fabs(AngleMod(angle1 - angle2));

    if (fTemp > 180)
    {
        fTemp = 360 - fTemp;
    }
    return fTemp;
}

//============================================================================
// InView
//----------------------------------------------------------------------------
// Can one origin "see" another given some view angle.  This allows us to 
// check if a player is currently in the view of another player.
//============================================================================
qboolean
InView(vec3_t vViewer, vec3_t vViewAngles, vec3_t vTestPoint)
{
    vec3_t
        vTarget,
        vTargetAngles;
	trace_t
        trace;
	int
		iDistance,
		contents;

	contents = trap_PointContents( vViewer, -1 );
	if (contents & (CONTENTS_NODROP | CONTENTS_PLAYERCLIP))
	{
		return FALSE;
	}

	//
	// Draw a line between the two players and check what we hit.
	//
    trap_Trace(&trace, vViewer, NULL, NULL, vTestPoint, ENTITYNUM_NONE, 
		MASK_VISABLE);

	VectorSubtract(vTestPoint, vViewer, vTarget);
    iDistance = VectorLength(vTarget);

	//
	// Is something blocking our view or is the player too far away?
	//
	if ((iDistance > MAX_VISIBLE_RANGE) || (trace.fraction != 1.0))
 	{
        return FALSE;
    }

	//
	// Now limit our view to what is in front of us.
	//
    vectoangles(vTarget,vTargetAngles);
   
    if (AngleDiff(vTargetAngles[PITCH], vViewAngles[PITCH]) > 45)
    {
        return FALSE;
    }

    if (AngleDiff(vTargetAngles[YAW], vViewAngles[YAW]) > 75)
    {
       return FALSE;
    }

    return TRUE;
}

//============================================================================
// NumPlayersInView
//----------------------------------------------------------------------------
// Counts the number of players that are in view of this player.
//============================================================================
int
NumPlayersInView(gentity_t *pViewer)
{
    int
        iCount=0,
		i;
    vec3_t
        vTarget,
        vTargetAngles;

	if (pViewer == NULL)
	{
		return 0;
	}
   

	for ( i=0 ; i<level.maxclients ; i++ ) 
	{
		if (g_entities[i].client->pers.connected != CON_CONNECTED)
		{
			continue;
		}

        if (level.clients[i].sess.sessionTeam != TEAM_SPECTATOR)
        {
			//
			// You cannot see dead people that have been dead for awhile.
			//
			if ((level.clients[i].ps.pm_type == PM_DEAD) &&
				(level.time > level.clients[i].respawnTime))
			{
				continue;
			}

            vTarget[0] = g_entities[i].client->ps.origin[0] - pViewer->client->ps.origin[0];
  	        vTarget[1] = g_entities[i].client->ps.origin[1] - pViewer->client->ps.origin[1];
            vTarget[2] = g_entities[i].client->ps.origin[2] - pViewer->client->ps.origin[2];
            vectoangles(vTarget,vTargetAngles);

            if (InView(pViewer->client->ps.origin, vTargetAngles, level.clients[i].ps.origin))
            {
                iCount++;
            }
        }
    }
    return iCount;
}

//============================================================================
//----------------------------------------------------------------------------
//============================================================================
/*gentity_t *
ClosestVisible(gentity_t *ent)
{
    vec3_t
        vDistance;
    sPlayerList 
        *pTarget,
        *pBest=NULL;
    unsigned int
        iCurrent,
        iClosest=0xffffffff;

    for ( pTarget = EntityListHead();
        pTarget != NULL;
        pTarget = pTarget->pNext)
    {
        if (!pTarget->pEntity->client->bIsCamera && 
             IsVisible(pTarget->pEntity, ent))
        {
			VectorSubtract(pTarget->pEntity->s.origin, ent->s.origin, vDistance);
			iCurrent = VectorLength(vDistance);
            if (iCurrent < iClosest)
            {
                pBest = pTarget;
                iClosest = iCurrent;
            }
        }
    }
    if (pBest == NULL)
    {
        return NULL;
    }
    return pBest->pEntity;
}*/


//============================================================================
// BestVisible
//----------------------------------------------------------------------------
// Find the player that has the lowest angle change for the camera.
//============================================================================
gentity_t *
BestVisible(gentity_t *ent, qboolean bInView)
{
    vec3_t
		vDiff,
		vAngles;
	float
		fDiff,
		fLowest=360;
    gentity_t 
        *pBest=NULL;
    unsigned int
		i;

	if (ent == NULL)
	{
		return 0;
	}
   
	for ( i=0 ; i<level.maxclients ; i++ ) 
	{
		if (level.clients[i].sess.sessionTeam == TEAM_SPECTATOR)
		{
			continue;
		}
        
		if (bInView)
		{
			if (InView(ent->client->ps.origin,
				ent->client->ps.viewangles, g_entities[i].client->ps.origin))
			{
				VectorSubtract(g_entities[i].client->ps.origin,
					ent->client->ps.origin, vDiff);

				vectoangles(vDiff, vAngles);

				fDiff = AngleDiff(ent->client->ps.viewangles[YAW], vAngles[YAW]);

				if (fDiff > fLowest)
				{
					pBest = &g_entities[i];
					fLowest = fDiff;
				}
			}
		}
		else if (IsVisible(ent, &g_entities[i]))
        {
			VectorSubtract(g_entities[i].client->ps.origin,
				ent->client->ps.origin, vDiff);

			vectoangles(vDiff, vAngles);

			fDiff = AngleDiff(ent->client->ps.viewangles[YAW], vAngles[YAW]);

			if (fDiff > fLowest)
			{
				pBest = &g_entities[i];
				fLowest = fDiff;
			}
        }
    }
    return pBest;
}

//============================================================================
// PlayerToFollow()
//----------------------------------------------------------------------------
// This function is used by the camera logic when it want to find someone else
// to watch.
//============================================================================
gentity_t * 
PlayerToFollow(gentity_t *ent, qboolean bCheckNearFirst)
{
    gentity_t 
        *eBest=NULL;
    int
        iPlayers=0,
        iBestCount=0,
		i;

	if (ent == NULL)
	{
		return NULL;
	}
   
	if (bCheckNearFirst)
	{
		if (ent->client->pTarget != NULL)
		{
			if (ent->client->pTarget->client->pers.connected == CON_CONNECTED)
			{
				iPlayers = NumPlayersVisible(ent->client->pTarget);
			}
			else
			{
				ent->client->pTarget = NULL;
			}
		}
		else
		{
			iPlayers = NumPlayersVisible(ent->client->pTarget);
		}
    }

    iBestCount = iPlayers;
    eBest = ent->client->pTarget;

	for ( i=0 ; i<level.maxclients ; i++ ) 
	{
        //
        // Don't switch to dead people, spectators or unconnected players.
        //
		if ((level.clients[i].sess.sessionTeam == TEAM_SPECTATOR) ||
			(level.clients[i].ps.pm_type == PM_DEAD) ||
			(level.clients[i].pers.connected != CON_CONNECTED))
		{
			continue;
		}
      
		iPlayers = NumPlayersVisible(&g_entities[i]);

		//
		// If a player has the flag they are the best person to watch.
		//
		if (g_entities[i].client->ps.powerups[PW_REDFLAG] ||
			 g_entities[i].client->ps.powerups[PW_BLUEFLAG])
		{
			iPlayers += 2*level.maxclients;
		}
		//
		// Add some randomness to the selection of the player to watch.
		//
		else if (iPlayers > 1)
		{
			iPlayers = iPlayers + (rand() % level.maxclients); 
		}

        if (iPlayers > iBestCount)
        {
            iBestCount = iPlayers;
            eBest = &g_entities[i];
        }
	}
    return eBest;
}

//============================================================================
// PointCamAtOrigin
//----------------------------------------------------------------------------
// Points the camera at a given origin.
//============================================================================
void
PointCamAtOrigin(gentity_t *ent, vec3_t vLocation)
{
    vec3_t
        vDiff,
        vAngles;

	if (ent == NULL)
	{
		return;
	}
   
    VectorSubtract(vLocation,ent->s.origin,vDiff);

    vectoangles(vDiff, vAngles);

	SetClientViewAngle(ent,vAngles);
}


//============================================================================
// PointCamAtTarget
//----------------------------------------------------------------------------
// Point Camera at the current target using the dampen effect.
//============================================================================
void
PointCamAtTarget(gentity_t *ent)
{
    vec3_t
        vDiff,
        vAngles;
    float
        fDifference;

	if ((ent == NULL) || (ent->client->pTarget == NULL))
	{
		return;
	}

	VectorSubtract(ent->client->pTarget->client->ps.origin,
			ent->s.origin, vDiff);

    vectoangles(vDiff, vAngles);

    fDifference = AngleNormalize180(vAngles[PITCH] - ent->s.angles[PITCH]);

	if (abs(fDifference) > g_DampenPitch)
    {
        if (fDifference > 0)
        {
            vAngles[PITCH] =  ent->s.angles[PITCH] + g_DampenPitch;
        }
        else
        {
            vAngles[PITCH] = ent->s.angles[PITCH] - g_DampenPitch;
        }
    }

    fDifference = AngleNormalize180(vAngles[YAW] - ent->s.angles[YAW]);

	if (abs(fDifference) > g_DampenYaw)
    {
        if (fDifference > 0)
        {
            vAngles[YAW] =  ent->s.angles[YAW] + g_DampenYaw;
        }
        else
        {
            vAngles[YAW] = ent->s.angles[YAW] - g_DampenYaw;
        }
    }

	vAngles[ROLL] = 0;

	SetClientViewAngle(ent, vAngles);
}

//============================================================================
// PointCamUsingTarget
//----------------------------------------------------------------------------
//============================================================================
/*void
PointCamUsingTarget(gentity_t *ent)
{
	if (ent->client->pTarget == NULL)
	{
		return;
	}

	SetClientViewAngle(ent, ent->client->pTarget->s.angles);
}*/

//============================================================================
// RepositionAtTarget
//----------------------------------------------------------------------------
// Reposition the camera at a given offset from the current target.
//============================================================================
void
RepositionAtTarget(gentity_t *ent, vec3_t vOffsetPosition)
{
	vec3_t
        vNewPos,
        vCamPos,
        forward,
		vViewAngle,
		vTargetPos;
    trace_t
        trace;

	if ((ent == NULL) || (ent->client->pTarget == NULL))
	{
		return;
	}

	vViewAngle[0]=45;
	vViewAngle[1]=ent->client->pTarget->client->ps.viewangles[1];
    vViewAngle[2]=0;

	VectorCopy(ent->client->pTarget->client->ps.origin, vTargetPos);

    AngleVectors(vViewAngle, forward, NULL,NULL);
    forward[2] = 0;

    VectorNormalize(forward);

    //
    // Calculate the ideal camera position.
    //
    vCamPos[0] = vTargetPos[0] + (vOffsetPosition[0] * forward[0]);
        
    vCamPos[1] = vTargetPos[1] + (vOffsetPosition[1] * forward[1]);

    vCamPos[2] = vTargetPos[2] + vOffsetPosition[2];

    if (abs(vCamPos[0] - ent->s.origin[0]) > g_DampenXY)
    {
        if (vCamPos[0] > ent->s.origin[0])
        {
            vNewPos[0] = ent->s.origin[0] + g_DampenXY; 
        }
        else
        {
            vNewPos[0] = ent->s.origin[0] - g_DampenXY; 
        }
    }
    else
    {
        vNewPos[0] = vCamPos[0];
    }

    if (abs(vCamPos[1] - ent->s.origin[1]) > g_DampenXY)
    {
        if (vCamPos[1] > ent->s.origin[1])
        {
            vNewPos[1] = ent->s.origin[1] + g_DampenXY; 
        }
        else
        {
            vNewPos[1] = ent->s.origin[1] - g_DampenXY; 
        }
    }
    else
    {
        vNewPos[1] = vCamPos[1];
    }
    
    if (abs(vCamPos[2]-ent->s.origin[2]) > g_DampenZ)
    {
        if (vCamPos[2] > ent->s.origin[2])
        {
            vNewPos[2] = ent->s.origin[2] + g_DampenZ; 
        }
        else
        {
            vNewPos[2] = ent->s.origin[2] - g_DampenZ; 
        }
    }
    else
    {
        vNewPos[2] = vCamPos[2];
    }

	//
	// Stay at least even with the curren target.
	//
//    if ( vTargetPos[2] > vNewPos[2])
    //{
        //vNewPos[2] = vCamPos[2];
    //}

	//
	// If we are close, then quit moving for awhile
	//
	if (Distance(vNewPos, vTargetPos) < 80)
	{
		return;
	}

    trap_Trace(&trace, vTargetPos, NULL, NULL,
		vNewPos, ent->client->pTarget->s.clientNum, MASK_CAM_COLLISION);
    
    if (trace.fraction != 1)
    {
		//
		// Calculate the ideal camera position.
		//
		/*vCamPos[0] = ent->client->pTarget->client->ps.origin[0] +
			(-20 * forward[0]);
        
		vCamPos[1] = ent->client->pTarget->client->ps.origin[1] +
			(-20 * forward[1]);

	    vCamPos[2] = ent->client->pTarget->client->ps.origin[2] + 
		    10;*/

		VectorSubtract(trace.endpos, vTargetPos, vNewPos);
		VectorNormalize(vNewPos);
		VectorMA(trace.endpos, -20, vNewPos, vNewPos);
		vNewPos[2] -= 10;
		
	    trap_Trace(&trace, vTargetPos, NULL, NULL,
			vNewPos, ent->client->pTarget->s.clientNum, MASK_CAM_COLLISION);

		if (trace.fraction == 1)
		{
			VectorCopy(vNewPos, ent->s.origin);
		    VectorCopy(ent->s.origin, ent->client->ps.origin);
		}
//		if (trace.plane.normal[2] > 0.8)
//			trace.endpos[2] += 4;
    }
	else
	{
		VectorCopy(vNewPos, ent->s.origin);
	    VectorCopy(ent->s.origin, ent->client->ps.origin);
	}
}

//============================================================================
// RepositionAtOrigin
//----------------------------------------------------------------------------
// Used in Quake 2 camera to watch the flying heads or bodies.
// unused in Quake 3 because bodies are boring and there are no heads :(
//============================================================================
/*void
RepositionAtOrigin(gentity_t *ent, vec3_t vCamPos)
{
    trace_t
        trace;

	if ((ent == NULL) || (ent->client->pTarget == NULL))
	{
		return;
	}

    if (abs(vCamPos[0] - ent->client->ps.origin[0]) > (g_DampenXY * 2))
    {
        if (vCamPos[0] > ent->client->ps.origin[0])
        {
            ent->client->ps.origin[0] += (g_DampenXY * 2); 
        }
        else
        {
            ent->client->ps.origin[0] -= (g_DampenXY * 2); 
        }
    }
    else
    {
        ent->client->ps.origin[0] = vCamPos[0];
    }

    if (abs(vCamPos[1] - ent->client->ps.origin[1]) > (g_DampenXY * 2))
    {
        if (vCamPos[1] > ent->client->ps.origin[1])
        {
            ent->client->ps.origin[1] += (g_DampenXY * 2); 
        }
        else
        {
            ent->client->ps.origin[1] -= (g_DampenXY * 2); 
        }
    }
    else
    {
        ent->client->ps.origin[1] = vCamPos[1];
    }
    
    if (abs(vCamPos[2] - ent->client->ps.origin[2]) > g_DampenZ)
    {
        if (vCamPos[2] > ent->client->ps.origin[2])
        {
            ent->client->ps.origin[2] += g_DampenZ; 
        }
        else
        {
            ent->client->ps.origin[2] -= g_DampenZ; 
        }
    }
    else
    {
        ent->client->ps.origin[2] = vCamPos[2];
    }

    trap_Trace(&trace, ent->s.origin, NULL, NULL, vCamPos,
        ENTITYNUM_NONE, MASK_CAM_COLLISION);

    if (trace.fraction < 1)
    {
		vec3_t vDiff;

		VectorSubtract(trace.endpos, vCamPos, vDiff);
		VectorNormalize(vDiff);
		VectorMA(trace.endpos, -20, vDiff, trace.endpos);

//		if (trace.plane.normal[2] > 0.8)
//			trace.endpos[2] += 4;
	    VectorCopy(trace.endpos, ent->client->ps.origin);
    }
    VectorCopy(ent->client->ps.origin, ent->s.origin);
}*/

//============================================================================
// CameraFollowThink
//----------------------------------------------------------------------------
// What I do when I am following players.
//============================================================================
void
CameraFollowThink(gentity_t *ent)
{
    vec3_t
        vCameraOffset;

	
    //
    // Just keep looking for action!
    //
    vCameraOffset[0] = -60;
    vCameraOffset[1] = -60;
    vCameraOffset[2] = 40;

	g_DampenYaw = 10;
	g_DampenPitch = 1;
	g_DampenXY = 10;
	g_DampenZ = 1;

	if ((ent->client->pTarget != NULL) && IsVisible(ent, ent->client->pTarget))
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("Still Visible\n");
		#endif // CAMERA_THOUGHTS
	}
	//
	// Check if anyone is still in view
	//
	else if ((ent->client->pTarget = BestVisible(ent, TRUE)) != NULL)
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("Some one was in view\n");
		#endif // CAMERA_THOUGHTS
	}
	else if ((ent->client->pTarget = BestVisible(ent, FALSE)) != NULL)
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("Some one was visible\n");
		#endif // CAMERA_THOUGHTS
	}
	else if ((ent->client->pTarget = PlayerToFollow(ent,qfalse)) != NULL)
    {
		#ifdef CAMERA_THOUGHTS
		G_Printf("Found new love\n");
		#endif // CAMERA_THOUGHTS
    }
	else
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("GOING STATIC\n");
		#endif // CAMERA_THOUGHTS
		CameraStaticThink(ent);
		return;
	}

    RepositionAtTarget(ent, vCameraOffset);
    PointCamAtTarget(ent);
}

//============================================================================
// CameraNormalThink
//----------------------------------------------------------------------------
// What I do normally to follow the action.
//============================================================================
void 
CameraThinkFFA(gentity_t *ent)
{
    vec3_t
        vCameraOffset;
    int
        iNumVis;

    gentity_t 
        *pEntity;

	vCameraOffset[0] = -100;
    vCameraOffset[1] = -100;
    vCameraOffset[2] = 50;
	g_DampenYaw = DAMPEN_YAW;
	g_DampenPitch = DAMPEN_PITCH;
	g_DampenXY = DAMP_VALUE_XY;
	g_DampenZ = DAMP_VALUE_Z;

	//
	// If we lost our Target look for a new one if we can't find one then
	// go to static view.
	//
    if (ent->client->pTarget == NULL)
    {
        if ((ent->client->pTarget = PlayerToFollow(ent,qtrue)) == NULL)
        {
			#ifdef CAMERA_THOUGHTS
			G_Printf("Going Static\n");
			#endif // CAMERA_THOUGHTS

            CameraStaticThink(ent);
            return;
        }
		else
		{
			#ifdef CAMERA_THOUGHTS
			G_Printf("New Target\n");
			#endif // CAMERA_THOUGHTS
			RepositionAtTarget(ent, vCameraOffset);
            PointCamAtTarget(ent);
			return;
		}
    }

	//
	// Watch that poor dead soul.
	//
	if ((ent->client->pTarget->client->ps.pm_type == PM_DEAD) &&
		(level.time > ent->client->pTarget->client->respawnTime))
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("Dead Target\n");
		#endif // CAMERA_THOUGHTS
		RepositionAtTarget(ent, vCameraOffset);
        PointCamAtTarget(ent);

		//
		// If player is about to respawn, check for a better place to be.
		//
		if ((level.time - ent->client->pTarget->client->respawnTime) <
			200)
		{
			ent->client->pTarget=NULL;
		}
		return;
	}


	//
	// Bias toward watching the flag carrier.
	//
	if ((ent->client->pTarget->client->ps.powerups[PW_REDFLAG] ||
		ent->client->pTarget->client->ps.powerups[PW_BLUEFLAG]) &&
        (ent->client->pTarget->client->pers.connected == CON_CONNECTED))
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("Watching the flag carrier\n");
		#endif // CAMERA_THOUGHTS
        
		vCameraOffset[0] = -60;
        vCameraOffset[1] = -60;
        vCameraOffset[2] = 100;

        RepositionAtTarget(ent, vCameraOffset);
	    PointCamAtTarget(ent);

		//
		// Add some wait here so we see who killed the flag carrier.
		//
	    ent->client->iCameraNextUpdate = level.time + 5000;
		return;
	}

	//
	// Init the current number of players visible to the camera.
	//
	iNumVis = NumPlayersInView(ent);

	if (iNumVis == 0)
	{
		iNumVis = NumPlayersVisible(ent);
	}

	//
	// We can no longer see anyone
	//
	if (iNumVis == 0)
	{
		#ifdef CAMERA_THOUGHTS
		G_Printf("No one Visable: ");
		#endif // CAMERA_THOUGHTS
        
		//
		// Its time to look for a new person to follow.
		// 
        if ((ent->client->pTarget = PlayerToFollow(ent, qtrue)) == NULL)
        {
			#ifdef CAMERA_THOUGHTS
			G_Printf("Going Static\n");
			#endif // CAMERA_THOUGHTS
        
            CameraStaticThink(ent);
            return;
        }
		else
		{
			#ifdef CAMERA_THOUGHTS
			G_Printf("New Target\n");
			#endif // CAMERA_THOUGHTS
			g_DampenYaw = 360;
			g_DampenPitch = 360;
			g_DampenXY = 20000;
			g_DampenZ = 20000;

			RepositionAtTarget(ent, vCameraOffset);
            PointCamAtTarget(ent);
			return;
		}
	}
    //
    // If we currently can't see more than 1 person then start thinking
	// about looking for a new place to go.
    //
    else if (iNumVis == 1)
    {
		#ifdef CAMERA_THOUGHTS
		G_Printf("Only one Visable: ");
		#endif // CAMERA_THOUGHTS
        
        //
        // If we were just watching a battle wait around awhile and see if 
        // anyone else shows up.
        //
        if (ent->client->iCameraNextUpdate >= level.time) 
        {
			#ifdef CAMERA_THOUGHTS
			G_Printf("waiting for the switch ");
			#endif // CAMERA_THOUGHTS
            //
			// Check if we can still see our current Target.
			//
			if (IsVisible(ent,ent->client->pTarget))
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("follow\n");
				#endif // CAMERA_THOUGHTS
                
				RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }
			//
			// Else we look at the furthest Visible person, well there
			// should only be one of them since we already checked to see 
			// that there is one player visible.
			//
            else if ((pEntity = BestVisible(ent, FALSE)) != NULL)
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("furthest\n");
				#endif // CAMERA_THOUGHTS
                
				ent->client->pTarget = pEntity;

				RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }
			//
			// Just stick with our previous target.
			//
            else if (ent->client->pTarget)
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("new love\n");
				#endif // CAMERA_THOUGHTS

				//
                // Found someone new!
                //
                RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }
			else
			{
				#ifdef CAMERA_THOUGHTS
				G_Printf("I'm lonely\n");
				#endif // CAMERA_THOUGHTS
				return;
			}
        }
        else
        {
			#ifdef CAMERA_THOUGHTS
			G_Printf("No more waiting ");
			#endif // CAMERA_THOUGHTS

            pEntity = PlayerToFollow(ent, qfalse);

            if ((pEntity != NULL) && (NumPlayersVisible(pEntity) > iNumVis))
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("going to a new place\n");
				#endif // CAMERA_THOUGHTS

                ent->client->pTarget = pEntity;

                g_DampenYaw = 360;
				g_DampenPitch = 360;
				g_DampenXY = 20000;
				g_DampenZ = 20000;

				//
                // Go to the new target!
                //
                RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }

            //
            // If there is only one player visible and the current target is
			// not visible then we look for that player that is visible and
			// make them our target.
            //
            else if ((pEntity = BestVisible(ent, FALSE)) != NULL)
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("see 1 looking furthest\n");
				#endif // CAMERA_THOUGHTS

                ent->client->pTarget = pEntity;

                //
                // Found someone new!
                //
                RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }
            //
            // Ok there was nothing better to do so just keep watching the same player.
            //
            else
            {
				#ifdef CAMERA_THOUGHTS
				G_Printf("Stagnate\n");
				#endif // CAMERA_THOUGHTS

                RepositionAtTarget(ent, vCameraOffset);
                PointCamAtTarget(ent);
				return;
            }
        }
    }
    //
    // OK we have waited around here for some time, so now lets look 
	// elsewhere.
    //
    else if(ent->client->iCameraNextUpdate <= level.time) 
    {
		#ifdef CAMERA_THOUGHTS
		G_Printf("Spot may be getting dull %d %d\n", level.time, ent->client->iCameraNextUpdate);
		#endif // CAMERA_THOUGHTS

        if ((ent->client->pTarget = PlayerToFollow(ent, qfalse)) != NULL)
        {
			g_DampenYaw = 360;
			g_DampenPitch = 360;
			g_DampenXY = 20000;
			g_DampenZ = 20000;

            PointCamAtTarget(ent);
            RepositionAtTarget(ent, vCameraOffset);
            ent->client->iCameraNextUpdate = level.time + CAMERA_SWITCH_TIME;
			return;
        }
    }
    
    //
    // Either there is nothing better to do or we are watching a battle and
    // don't want the camera to move.
    //
    else 
    {
		#ifdef CAMERA_THOUGHTS
		G_Printf("Stick around: ");
		#endif // CAMERA_THOUGHTS
		
		//
		// Is the current target still in view if not we need to look for 
		// them or someone else.
		//
		if (!InView(ent->client->ps.origin,
			ent->client->ps.viewangles,ent->client->pTarget->client->ps.origin))
        {
			// 
			// Is the current target visible at all, if they are do not
			// change the current target yet.
			//
			if (!IsVisible(ent, ent->client->pTarget))
			{
				//
				// Check if anyone is still in view
				//
				ent->client->pTarget = BestVisible(ent, TRUE);

				//
				// If not point at the furthest visable person.
				//
				if (ent->client->pTarget == NULL)
				{
					#ifdef CAMERA_THOUGHTS
					G_Printf("lost sight of target noone in view\n");
					#endif // CAMERA_THOUGHTS
					ent->client->pTarget = BestVisible(ent, FALSE);
					g_DampenYaw = 6;
					g_DampenPitch = 2;
					g_DampenXY = 0.5;
					g_DampenZ = 0;
				}
				else
				{
					#ifdef CAMERA_THOUGHTS
					G_Printf("lost sight of target someone in view\n");
					#endif // CAMERA_THOUGHTS
				}
			}
			#ifdef CAMERA_THOUGHTS
				G_Printf("target went outta view but we can still see them.\n");
			#endif // CAMERA_THOUGHTS
			g_DampenYaw = 6;
			g_DampenPitch = 2;
			g_DampenXY = 0.5;
			g_DampenZ = 0;
		}
		else
		{
			#ifdef CAMERA_THOUGHTS
			G_Printf("target in view\n");
			#endif // CAMERA_THOUGHTS
			g_DampenYaw = 6;
			g_DampenPitch = 2;
			g_DampenXY = 0.1F;
			g_DampenZ = 0;
		}
		
		vCameraOffset[0] = -600;
	    vCameraOffset[1] = -600;
		vCameraOffset[2] = 80;
		PointCamAtTarget(ent);
        RepositionAtTarget(ent, vCameraOffset);
    }
}

//============================================================================
// CameraStaticThink
//----------------------------------------------------------------------------
// What I do when I am bored.
//============================================================================
void 
CameraStaticThink(gentity_t *ent)
{
    trace_t
        trace;
    vec3_t
        vEndFloor,
        vEndCeiling,
		vAngles;
    
    vEndFloor[0] = ent->s.origin[0];
    vEndFloor[1] = ent->s.origin[1];
    vEndFloor[2] = ent->s.origin[2] - 40000;
    trap_Trace(&trace, ent->client->ps.origin, NULL, NULL, vEndFloor, 
		ent->s.clientNum, MASK_CAM_COLLISION);

    VectorCopy ( trace.endpos, vEndFloor );

    vEndCeiling[0] = vEndFloor[0];
    vEndCeiling[1] = vEndFloor[1];
    vEndCeiling[2] = vEndFloor[2] + 175;
    trap_Trace(&trace, vEndFloor, NULL, NULL, vEndCeiling, ent->s.clientNum,
		MASK_CAM_COLLISION);

    VectorCopy ( trace.endpos, ent->client->ps.origin );
    
    if ( ent->client->iCameraNextUpdate < level.time )
    {
        ent->client->iCameraNextUpdate = level.time + 2;
        vAngles[0] = 45;
        vAngles[1] = 0;
        vAngles[2] = 0;
		
		SetClientViewAngle(ent,vAngles);
    }
}

//============================================================================
// FollowPlayer
//----------------------------------------------------------------------------
// Follow the given Player.
//============================================================================
void
FollowPlayer(gentity_t *ent, gentity_t *pTarget)
{
	vec3_t
		vCameraOffset;

#ifdef CAMERA_THOUGHTS
	G_Printf("Following Leader\n");
#endif // CAMERA_THOUGHTS

	ent->client->pTarget = pTarget;
    vCameraOffset[0] = -60;
	vCameraOffset[1] = -60;
	vCameraOffset[2] = 40;

	g_DampenYaw = 10;
	g_DampenPitch = 1;
	g_DampenXY = 10;
	g_DampenZ = 1;
	RepositionAtTarget(ent, vCameraOffset);
	PointCamAtTarget(ent);
}


//============================================================================
// CameraThink
//----------------------------------------------------------------------------
// What mode is the camera in.
//============================================================================
void
CameraThink(gentity_t *ent)
{
	int 
		i,
		Best = 0;
	gentity_t 
		*pBest=0;


	ent->client->ps.viewheight = 0;

	if (g_gametype.integer == GT_FFA && g_fraglimit.integer)
	{
		for ( i=0 ; i<level.maxclients ; i++ ) 
		{
			if ((level.clients[i].pers.connected == CON_CONNECTED) &&
				(g_fraglimit.integer - level.clients[i].ps.persistant[PERS_SCORE] < 9))
			{
				if (Best < level.clients[i].ps.persistant[PERS_SCORE])
				{
					Best = level.clients[i].ps.persistant[PERS_SCORE];
					pBest = &g_entities[i];
				}
			}
		}
	}

	//
 	// toggle the teleport bit so the client knows to not lerp
	//
	// Anything to cut down on the live mode jitter effect.
	//
	ent->client->ps.eFlags |= EF_TELEPORT_BIT;

	switch(ent->client->iMode)
	{
        case CAM_FOLLOW_MODE:
		{
			CameraFollowThink(ent);
			break;
		}
        case CAM_NORMAL_MODE:
        default:
		{
			if (pBest)
			{
				FollowPlayer(ent, pBest);
			}
			else
			{
				CameraThinkFFA(ent);
			}
			break;
        }
	}
       if (g_camtype.integer == 0)
           CameraFollowThink(ent);
       else if (g_camtype.integer == 1)
       {
			if (pBest)
			{
				FollowPlayer(ent, pBest);
			}
			else
			{
				CameraThinkFFA(ent);
			}
       }
}
