/*
 *  Portions Copyright (C) 2003 Ben Goodwin
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the OSML - Open Source Modification License v1.0 as
 *  described in the file COPYING which is distributed with this source
 *  code.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


// defines

// Version MUST be in the format of #.# or #.#x
// IE 1.0, 1.0f, 2.3, 2.3a, 1.12, 1.12d, 12.1, etc ...
#define AS_VERSION "1.99p"

#define AS_MAX_BANFILE_SIZE		16384
#define AS_MAX_NOKICKFILE_SIZE	8192

#define AS_MAX_HELPFILE_SIZE	1024

#define	AS_MAX_MAP_ENTSTRING	0x8000
#define	AS_MAX_SPAWNVAR_GROUPS	4000	// mpteam8 has 1838


// typedefs

typedef struct {
	fileHandle_t		debugfile;
	int					voteType;
	char				mapname[MAX_QPATH];
	int					curSpawnVarGroup;
	qboolean			spawnVarGroupDisabled[AS_MAX_SPAWNVAR_GROUPS];
	qboolean			skipRefPrint;	// skip printing next G_Printf to referees?
	int					lastClientTime;	// last level.time we had a client on the server
	int					timeSortedClients[MAX_CLIENTS];
	qboolean			nobalance;
	int					fps;
} as_locals_t;

typedef struct {
	vmCvar_t			*vmCvar;
	char				*cvarName;
	char				*defaultString;
	int					cvarFlags;
	int					modificationCount;  // for tracking changes
	qboolean			trackChange;	    // track this variable, and announce if changed
} as_cvars_t;

// vote type (used for as_vote_mask)
#define AS_VT_BAD			0x00000000
#define AS_VT_RESTARTMAP	0x00000001
#define AS_VT_NEXTMAP		0x00000002
#define AS_VT_MAP			0x00000004
#define AS_VT_GAMETYPE		0x00000008
#define AS_VT_KICK			0x00000010
#define AS_VT_DOWARMUP		0x00000020
#define AS_VT_CLIENTKICK	0x00000040
#define AS_VT_TEAM_LEADER	0x00000080
#define AS_VT_TIMELIMIT		0x00000100
#define AS_VT_FRAGLIMIT		0x00000200
#define AS_VT_CAPTURELIMIT	0x00000400
#define AS_VT_MODE			0x00000800
#define AS_VT_TOGGLEBALANCE	0x00001000

typedef struct {
	char		*string;
	int			type;
} as_string_map_t;

typedef enum {					// Team balancing - scramble players at start of each map
	AS_TB_NONE,					// no balancing
	AS_TB_SCORE,				// By score
	AS_TB_RANDOM,				// Random
	AS_TB_SCORETIME,			// by score / time ('frags'/second)
} as_tb_t;

// message type (used for as_referee_print_mask)
#define AS_MT_SAY				0x00000001
#define AS_MT_SAYTEAM			0x00000002
#define AS_MT_TELL				0x00000004
#define AS_MT_VTELL				0x00000008
#define AS_MT_ITEM				0x00000010
#define AS_MT_VOICE				0x00000020
#define AS_MT_INFOCHANGED		0x00000040
#define AS_MT_CLIENTCONNECT		0x00000080
#define AS_MT_CLIENTBEGIN		0x00000100
#define AS_MT_CLIENTDISCONNECT	0x00000200
#define AS_MT_MISC				0x00000400

// Globals

extern	as_locals_t			as_level;
extern	as_cvars_t			as_cv;
extern	char				spawnVars[];

// CVARS

// From g_main.c
extern	vmCvar_t	g_log;
extern	vmCvar_t	g_logSync;

// From q3as.c

extern	vmCvar_t	as_debug_file;
extern	vmCvar_t	as_debug_console;

extern	vmCvar_t	as_adminlog_file;
extern	vmCvar_t	as_ban_file;
extern	vmCvar_t	as_nokick_file;

extern	vmCvar_t	as_referee_password;
extern	vmCvar_t	as_referee_print_mask;
extern	vmCvar_t	as_log_osp;

extern	vmCvar_t	as_max_intermission;
extern	vmCvar_t	as_time_during_warmup;

extern	vmCvar_t	as_kick_spectator_bots;

extern	vmCvar_t	as_team_balance;

extern	vmCvar_t	as_spam_warn;
extern	vmCvar_t	as_spam_kick;
extern	vmCvar_t	as_spam_interval;
extern	vmCvar_t	as_spam_message;

extern	vmCvar_t	as_rollback_config;
extern	vmCvar_t	as_rollback_timeout;

extern	vmCvar_t	as_chat_filter_file;
extern	vmCvar_t	as_unbalanced_warning;

extern	vmCvar_t	as_max_spectator_time;
extern	vmCvar_t	as_max_spectator_warn;


// Prototypes

void as_debug(char *fmt, ... );
void as_registerCvars( void );
void as_updateCvars( void );
void as_postSpawnCleanup( void );
void as_stripIPPort (char *ip, char *newIP, int len);
qboolean as_isBanned (char *ip);
qboolean as_admin_log(char *fmt, ... );

void as_svcmd_AddIP_f( void );
void as_svcmd_RemoveIP_f( void );
void as_svcmd_AS_MapID_f( void );
void as_openDebugLog( void );

qboolean as_checkToken( char *token );
void as_cmd_Help_f( gentity_t *ent );
void as_cmd_SetReferee_f( gentity_t *ent );
void as_cmd_Referee_f( gentity_t *ent );
void as_sendMessageToReferees(char *text);
void as_svcmd_status_f( void );
void as_doLingerPrint (gentity_t *ent);
void as_balance_teams( void );
qboolean as_readExternalSVFile( void );
qboolean as_parseSpawnVars( qboolean getVersion );
void as_cmd_Players_f( gentity_t *ent );
void as_trackChat (int clientNum);
void as_checkConfigTimeout(void);
void as_setClientIP(int clientNum, qboolean init);
char *as_filterText(char *text);
int QDECL as_sortTimeScore( const void *a, const void *b );
void as_updateChatStats(gentity_t *ent);
void as_cmd_Follow_FC_f( gentity_t *ent, int team );
void as_checkTeams(void);
void as_logOSP(char *fmt, ... );
void as_clientSpectatorTimer( gclient_t *client );
int as_percentConnected (void);
