// Copyright (C) 1999-2000 Id Software, Inc.
//

#include "g_local.h"
#include "q3as.h"

level_locals_t	level;

typedef struct {
	vmCvar_t	*vmCvar;
	char		*cvarName;
	char		*defaultString;
	int			cvarFlags;
	int			modificationCount;  // for tracking changes
	qboolean	trackChange;	// track this variable, and announce if changed
} cvarTable_t;

gentity_t		g_entities[MAX_GENTITIES];
gclient_t		g_clients[MAX_CLIENTS];

vmCvar_t	g_gametype;
vmCvar_t	g_dmflags;
vmCvar_t	g_fraglimit;
vmCvar_t	g_timelimit;
vmCvar_t	g_capturelimit;
vmCvar_t	g_friendlyFire;
vmCvar_t	g_password;
vmCvar_t	g_needpass;
vmCvar_t	g_maxclients;
vmCvar_t	g_maxGameClients;
vmCvar_t	g_dedicated;
vmCvar_t	g_speed;
vmCvar_t	g_gravity;
//vmCvar_t	g_cheats;
vmCvar_t	g_knockback;
vmCvar_t	g_quadfactor;
vmCvar_t	g_forcerespawn;
vmCvar_t	g_inactivity;
vmCvar_t	g_debugMove;
vmCvar_t	g_debugDamage;
vmCvar_t	g_debugAlloc;
vmCvar_t	g_syncronousClients;
vmCvar_t	g_warmup;
vmCvar_t	g_doWarmup;
vmCvar_t	g_restarted;
vmCvar_t	g_log;
vmCvar_t	g_logSync;
vmCvar_t	g_blood;
vmCvar_t	g_podiumDist;
vmCvar_t	g_podiumDrop;
vmCvar_t	g_allowVote;
vmCvar_t	g_teamAutoJoin;
vmCvar_t	g_teamForceBalance;
vmCvar_t	g_banIPs;
vmCvar_t	g_filterBan;



//freeze
vmCvar_t	g_wpflags;
vmCvar_t	g_weaponlimit;
vmCvar_t	g_doReady;
vmCvar_t	g_startArmor;
vmCvar_t	g_votelimit;
//freeze


//ammo
vmCvar_t    ammolimit; 
//
vmCvar_t	ammo_mg;
vmCvar_t	ammo_sg;
vmCvar_t	ammo_rl;
vmCvar_t	ammo_gl;
vmCvar_t	ammo_lg;
vmCvar_t	ammo_rg;
vmCvar_t	ammo_pg;
vmCvar_t	ammo_BFG;
//ammo

  //weapon timing/speed
vmCvar_t        wepswitchdelay;
//
vmCvar_t        firedelay_mg;
vmCvar_t        firedelay_sg;
vmCvar_t        firedelay_gl;
vmCvar_t        firedelay_rl;
vmCvar_t        firedelay_lg;
vmCvar_t        firedelay_rg;
vmCvar_t        firedelay_pg;
vmCvar_t        firedelay_BFG;
vmCvar_t	    rocket_speed;
vmCvar_t	    plasma_speed;
vmCvar_t	    bfg_speed;
vmCvar_t	    grenade_speed;
//weapon timing/speed

// damage
vmCvar_t    customDamage;
//
vmCvar_t	g_damageMachinegun;
vmCvar_t    g_damageTeamMachinegun;
vmCvar_t	g_damageGauntlet;
vmCvar_t	g_damageShotgun;
vmCvar_t	g_damageRailgun;
vmCvar_t	g_damageLightning;
vmCvar_t	g_damagePlasma;
vmCvar_t	g_damagePlasmaSplash;
vmCvar_t	g_PlasmaSplashRadius;
vmCvar_t	g_damageGrenadeLauncher;
vmCvar_t    g_damageGrenadeSplash;
vmCvar_t    g_GrenadeSplashRadius;
vmCvar_t	g_damageBFG;
vmCvar_t	g_damageBFGSplash;
vmCvar_t	g_BFGSplashRadius;
vmCvar_t	g_damageRocketLauncher;
vmCvar_t    g_RocketSplashRadius;
vmCvar_t    g_damageRocketSplash;
//damage
vmCvar_t    railjump;


      // respawn timers
vmCvar_t	g_armorRespawn;
vmCvar_t	g_healthRespawn;
vmCvar_t	g_ammoRespawn;
vmCvar_t	g_holdableRespawn;
vmCvar_t	g_megahealthRespawn;
vmCvar_t	g_powerupRespawn;
vmCvar_t	g_weaponTeamRespawn; //moved here
vmCvar_t	g_weaponRespawn;    //moved here

  //miss
vmCvar_t    g_hardcore;
vmCvar_t    g_llamaPenalty; 
vmCvar_t	g_autoThawTime;
vmCvar_t    g_thawTime;

// Protection
vmCvar_t	g_worldDamage;
vmCvar_t	g_spawnProtect;
vmCvar_t	g_spawnTime;
vmCvar_t	g_DecayArmor;   //count down
vmCvar_t	g_DecayHealth;   //count down  
vmCvar_t	killedby;
// Protection

//Anti-camper
vmCvar_t	g_anticampTime;
vmCvar_t	g_anticampRadius;
vmCvar_t	g_anticamp;
//Anti-camper


//  Hook
vmCvar_t	g_grapple;
vmCvar_t	g_grappleSpeed;
vmCvar_t    g_skyhook;
//  Hook

//MOTD
vmCvar_t	g_motd;
vmCvar_t	g_motd1;
vmCvar_t	g_motd2;
vmCvar_t	g_motd3;
vmCvar_t	g_motd4;
vmCvar_t	g_motd5;
vmCvar_t	g_motd6;
vmCvar_t	g_motd7;
vmCvar_t	g_motd8;
//MOTD

// Invalid password
vmCvar_t	invalid;

//Team/Clan Names
vmCvar_t	g_redteam;
vmCvar_t	g_blueteam;
//Team/Clan Names

//server filters
//vmCvar_t	your_muted;
vmCvar_t	as_spam_mute;
vmCvar_t    detention;
vmCvar_t    g_logfilter;
vmCvar_t	lockRed;
vmCvar_t	lockBlue;
vmCvar_t	lockTeams;
vmCvar_t	buzzer_sound;
//server filters

// testing
vmCvar_t	ace_WallHack;
vmCvar_t	ace_AAim;
vmCvar_t	ace_AShoot;
vmCvar_t	ace_AS_Railgun;
vmCvar_t	ace_AS_Shotgun;
vmCvar_t	ace_AA_keeplocked;
//vmCvar_t	cl_allowDownload;
// testing 


 //powerr ( serverinfo some shown in gamespy window )
vmCvar_t	sv_serversite;
vmCvar_t	sv_modsite;
vmCvar_t	sv_fps;  //powerr - added to fix spe time.

cvarTable_t		gameCvarTable[] = {
	// don't override the cheat state set by the system
//	{ &g_cheats, "sv_cheats", "", 0, 0, qfalse },

	// noset vars
	{ NULL, "gamename", GAMEVERSION , CVAR_SERVERINFO | CVAR_ROM, 0, qfalse  },
	{ NULL, "gamedate", __DATE__ , CVAR_ROM, 0, qfalse  },
	{ &g_restarted, "g_restarted", "0", CVAR_ROM, 0, qfalse  },
	{ NULL, "sv_mapname", "", CVAR_SERVERINFO | CVAR_ROM, 0, qfalse  },
    { NULL, "sv_serversite", "", CVAR_SERVERINFO, 0, qfalse  },
	{ NULL, "sv_modsite", "http://powermods.8m.net", CVAR_SERVERINFO | CVAR_ROM, 0, qfalse  },
		
	// latched vars
    {&sv_fps, "sv_fps", "20", CVAR_SERVERINFO | CVAR_LATCH | CVAR_ARCHIVE, 0, qfalse  },
	
	//freeze ( this is freezetag gametype needs to be 3) //powerr
	{ &g_gametype, "g_gametype", "3", CVAR_SERVERINFO | CVAR_USERINFO | CVAR_LATCH, 0, qfalse },


	{ &g_maxclients, "sv_maxclients", "8", CVAR_SERVERINFO | CVAR_LATCH | CVAR_ARCHIVE, 0, qfalse  },
	{ &g_maxGameClients, "g_maxGameClients", "0", CVAR_SERVERINFO | CVAR_LATCH | CVAR_ARCHIVE, 0, qfalse  },

	// change anytime vars
	{ &g_dmflags, "dmflags", "0", CVAR_SERVERINFO | CVAR_ARCHIVE, 0, qtrue  },
	{ &g_fraglimit, "fraglimit", "20", CVAR_SERVERINFO | CVAR_ARCHIVE | CVAR_NORESTART, 0, qtrue },
	{ &g_timelimit, "timelimit", "0", CVAR_SERVERINFO | CVAR_ARCHIVE | CVAR_NORESTART, 0, qtrue },
	{ &g_capturelimit, "capturelimit", "8", CVAR_SERVERINFO | CVAR_ARCHIVE | CVAR_NORESTART, 0, qtrue },

	{ &g_syncronousClients, "g_syncronousClients", "0", CVAR_SYSTEMINFO, 0, qfalse  },
	{ &g_friendlyFire, "g_friendlyFire", "1", CVAR_ARCHIVE, 0, qtrue  },
	{ &g_teamAutoJoin, "g_teamAutoJoin", "0", CVAR_ARCHIVE  },
	{ &g_teamForceBalance, "g_teamForceBalance", "0", CVAR_ARCHIVE  },
	{ &g_warmup, "g_warmup", "20", CVAR_ARCHIVE, 0, qtrue  },
	{ &g_doWarmup, "g_doWarmup", "0", CVAR_ARCHIVE, 0, qtrue  },
	{ &g_log, "g_log", "games.log", CVAR_ARCHIVE, 0, qfalse  },
	{ &g_logSync, "g_logSync", "0", CVAR_ARCHIVE, 0, qfalse  },
	{ &g_password, "g_password", "", CVAR_USERINFO, 0, qfalse  },
	{ &g_banIPs, "g_banIPs", "", CVAR_ARCHIVE, 0, qfalse  },
	{ &g_filterBan, "g_filterBan", "1", CVAR_ARCHIVE, 0, qfalse  },
	{ &g_needpass, "g_needpass", "0", CVAR_SERVERINFO | CVAR_ROM, 0, qfalse },
	{ &g_dedicated, "dedicated", "0", 0, 0, qfalse  },
	{ &g_speed, "g_speed", "320", 0, 0, qtrue  },
	{ &g_gravity, "g_gravity", "800", 0, 0, qtrue  },
	{ &g_knockback, "g_knockback", "1000", 0, 0, qtrue  },
	{ &g_quadfactor, "g_quadfactor", "3", 0, 0, qtrue  },
	{ &g_forcerespawn, "g_forcerespawn", "20", 0, 0, qtrue },
	{ &g_inactivity, "g_inactivity", "0", 0, 0, qtrue },
	{ &g_debugMove, "g_debugMove", "0", 0, 0, qfalse },
	{ &g_debugDamage, "g_debugDamage", "0", 0, 0, qfalse },
	{ &g_debugAlloc, "g_debugAlloc", "0", 0, 0, qfalse },
	{ &g_blood, "com_blood", "1", 0, 0, qfalse },
	{ &g_podiumDist, "g_podiumDist", "80", 0, 0, qfalse },
	{ &g_podiumDrop, "g_podiumDrop", "70", 0, 0, qfalse },


//freeze
	{ &g_wpflags, "wpflags", "0", 0, 0, qfalse },
	{ &g_weaponlimit, "weaponlimit", "0", 0, 0, qfalse },
	{ &g_doReady, "g_doReady", "0", 0, 0, qfalse },
	{ &g_startArmor, "g_startArmor", "0", 0, 0, qfalse },
	{ &g_votelimit, "votelimit", "0", 0, 0, qfalse },
//freeze

  // Ammo Limit  
    { &ammolimit, "ammolimit", "200", CVAR_ARCHIVE, 0, qfalse },
  // Starting
	{ &ammo_mg, "ammo_mg", "50", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_sg, "ammo_sg", "5", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_rl, "ammo_rl", "5", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_gl, "ammo_gl", "5", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_lg, "ammo_lg", "50", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_rg, "ammo_rg", "5", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_pg, "ammo_pg", "50", CVAR_ARCHIVE, 0, qfalse },
	{ &ammo_BFG, "ammo_bfg", "2", CVAR_ARCHIVE, 0, qfalse }, 
//ammo
	
//firing rates/speeds
    { &wepswitchdelay, "wepswitchdelay", "200", CVAR_ARCHIVE, 0, qfalse },
//
	{ &firedelay_mg, "firedelay_mg", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_sg, "firedelay_sg", "1000", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_gl, "firedelay_gl", "800", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_rl, "firedelay_rl", "800", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_lg, "firedelay_lg", "50", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_rg, "firedelay_rg", "1500", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_pg, "firedelay_pg", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &firedelay_BFG, "firedelay_BFG", "200", CVAR_ARCHIVE, 0, qfalse },
	{ &rocket_speed, "rocket_speed",   "900", CVAR_ARCHIVE, 0, qfalse },
	{ &plasma_speed, "plasma_speed", "2000", CVAR_ARCHIVE, 0, qfalse },
	{ &bfg_speed,    "bfg_speed",    "2000", CVAR_ARCHIVE, 0, qfalse },
	{ &grenade_speed, "grenade_speed", "700", CVAR_ARCHIVE, 0, qfalse },
//fireing rates / speeds

// damage mg_damageTeamplay
    { &customDamage, "customDamage", "0", CVAR_ARCHIVE, 0, qfalse },

	{ &g_damageGauntlet, "g_damagegauntlet", "50", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageMachinegun, "g_damagemachinegun", "5", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageTeamMachinegun, "g_damageteammachinegun", "7", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageShotgun, "g_damageshotgun", "10", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageRailgun, "g_damagerailgun", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageLightning, "g_damagelightning", "8", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damagePlasma, "g_damageplasma", "20", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damagePlasmaSplash, "g_damagePlasmaSplash", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &g_PlasmaSplashRadius, "g_PlasmaSplashRadius", "120", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageGrenadeLauncher, "g_damagegrenadelauncher", "100", CVAR_ARCHIVE, 0, qfalse },
    { &g_damageGrenadeSplash, "g_damageGrenadeSplash", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &g_GrenadeSplashRadius, "g_GrenadeSplashRadius", "120", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageBFG, "g_damagebfg", "150", CVAR_ARCHIVE, 0, qfalse },
    { &g_damageBFGSplash, "g_damageBFGSplash", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &g_BFGSplashRadius, "g_BFGSplashRadius", "120", CVAR_ARCHIVE, 0, qfalse },
	{ &g_damageRocketLauncher, "g_damagerocketlauncher", "100", CVAR_ARCHIVE, 0, qfalse },
    { &g_damageRocketSplash, "g_damageRocketSplash", "100", CVAR_ARCHIVE, 0, qfalse },
	{ &g_RocketSplashRadius, "g_RocketSplashRadius", "120", CVAR_ARCHIVE, 0, qfalse },
// damage
    { &railjump, "railjump", "0", CVAR_ARCHIVE, 0, qfalse },


//other
    // respawn timers
	{ &g_armorRespawn, "g_armorrespawn", "25", CVAR_ARCHIVE, 0, qfalse },
	{ &g_healthRespawn, "g_healthrespawn", "35", CVAR_ARCHIVE, 0, qfalse },
	{ &g_ammoRespawn, "g_ammorespawn", "40", CVAR_ARCHIVE, 0, qfalse },
	{ &g_holdableRespawn, "g_holdablerespawn", "60", CVAR_ARCHIVE, 0, qfalse },
	{ &g_megahealthRespawn, "g_megahealthrespawn", "120",CVAR_ARCHIVE , 0, qfalse },
	{ &g_powerupRespawn, "g_poweruprespawn", "120", CVAR_ARCHIVE, 0, qfalse },
	{ &g_weaponTeamRespawn, "g_weaponteamrespawn", "30", CVAR_ARCHIVE, 0, qfalse },
	{ &g_weaponRespawn, "g_weaponrespawn", "5", CVAR_ARCHIVE, 0, qfalse },
   
	//miss
	{ &g_hardcore, "g_hardcore", "0", CVAR_ARCHIVE, 0, qfalse },
    { &g_llamaPenalty, "g_llamaPenalty", "5", CVAR_ARCHIVE, 0, qfalse },
 	{ &g_autoThawTime, "g_autoThawTime", "120", CVAR_SERVERINFO, 0, qtrue },
	{ &g_thawTime, "g_thawTime", "3", CVAR_SERVERINFO, 0, qtrue },
	{ &g_DecayHealth, "g_decayhealth", "0", CVAR_ARCHIVE, 0, qfalse },
	{ &g_DecayArmor, "g_decayarmor", "0", CVAR_ARCHIVE, 0, qfalse },
	{ &killedby, "killedby", "0", CVAR_ARCHIVE, 0, qfalse },
   //miss
		
	//MOTD
   	{ &g_motd, "g_motd", "", 0, 0, qfalse },
    { &g_motd1, "g_motd1", "", 0, 0, qfalse },
	{ &g_motd2, "g_motd2", "", 0, 0, qfalse },
	{ &g_motd3, "g_motd3", "", 0, 0, qfalse },
	{ &g_motd4, "g_motd4", "", 0, 0, qfalse },
	{ &g_motd5, "g_motd5", "", 0, 0, qfalse },
	{ &g_motd6, "g_motd6", "", 0, 0, qfalse },
	{ &g_motd7, "g_motd7", "", 0, 0, qfalse },
	{ &g_motd8, "g_motd8", "", 0, 0, qfalse },
//other

//Invalid password
	{ &invalid, "invalid", "Invalid password", 0, 0, qfalse },

// Protection
	{ &g_worldDamage, "g_worldDamage", "1", 0, 0, qfalse },
	{ &g_spawnProtect, "g_spawnProtect", "0", 0, 0, qfalse }, 
	{ &g_spawnTime, "g_spawnTime", "3", 0, 0, qfalse},
//	{ &g_selfdamagemod, "g_selfdamagemod", "0.5", 0, 0, qfalse },
// Protection

//Anti-camper
	{ &g_anticampTime, "g_anticampTime", "10", 0, 0, qtrue  },
	{ &g_anticampRadius, "g_anticampRadius", "192", 0, 0, qtrue  },
	{ &g_anticamp, "g_anticamp", "0", 0, 0, qtrue  },
//Anti-camper
  
// hook
	{ &g_grappleSpeed, "g_grappleSpeed", "1600", 0, 0, qtrue  },
	{ &g_grapple, "g_grapple", "0", 0, 0, qfalse },
	{ &g_skyhook, "sky_hook", "0", 0, 0, qfalse },
// hook

//Team/Clan Names
	{ &g_redteam, "RedTeam", "Red", 0, 0, qfalse },
	{ &g_blueteam, "BlueTeam", "Blue", 0, 0, qfalse },
//Team/Clan Names

//test
	{ &ace_WallHack, "ace_WallHack", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
	{ &ace_AAim, "ace_AAim", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
	{ &ace_AShoot, "ace_ASoot", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
	{ &ace_AS_Railgun, "ace_AS_Railgun", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
	{ &ace_AS_Shotgun, "ace_AS_Shotgun", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
	{ &ace_AA_keeplocked, "ace_AA_keeplocked", "0", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
//	{ cl_allowDownload, "cl_allowDownload", "1", CVAR_SYSTEMINFO|CVAR_INIT|CVAR_LATCH, 0, qtrue},
//test

// server filters
   // { &your_muted, "your_muted", "Muted: You should relly not spam or talk like that.", 0, 0, qfalse },
	{ &as_spam_mute, "as_spam_mute", "45", CVAR_ARCHIVE, 0, qtrue},
	{ &detention, "detention", "0", CVAR_ARCHIVE, 0, qtrue },
	{ &g_logfilter, "logfilter", "511", 0, 0, qtrue },
	{ &lockBlue, "lockblue", "0", CVAR_ARCHIVE, 0, qfalse },
	{ &lockRed, "lockred", "0", CVAR_ARCHIVE, 0, qfalse },
	{ &lockTeams, "lockall", "0", CVAR_ARCHIVE, 0, qfalse },
	{ &buzzer_sound, "buzzer_sound", "sound/teamplay/flagcap_red.wav", 0, 0, qfalse },
   
	// server filters


	{ &g_allowVote, "g_allowVote", "1", 0, 0, qfalse }
};

int		gameCvarTableSize = sizeof( gameCvarTable ) / sizeof( gameCvarTable[0] );


void G_InitGame( int levelTime, int randomSeed, int restart );
void G_RunFrame( int levelTime );
void G_ShutdownGame( int restart );
void CheckExitRules( void );


/*
================
vmMain

This is the only way control passes into the module.
This must be the very first function compiled into the .q3vm file
================
*/
int vmMain( int command, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6 ) {
	switch ( command ) {
	case GAME_INIT:
		G_InitGame( arg0, arg1, arg2 );
		return 0;
	case GAME_SHUTDOWN:
		G_ShutdownGame( arg0 );
		return 0;
	case GAME_CLIENT_CONNECT:
		return (int)ClientConnect( arg0, arg1, arg2 );
	case GAME_CLIENT_THINK:
		ClientThink( arg0 );
		return 0;
	case GAME_CLIENT_USERINFO_CHANGED:
		ClientUserinfoChanged( arg0 );
		return 0;
	case GAME_CLIENT_DISCONNECT:
		ClientDisconnect( arg0 );
		return 0;
	case GAME_CLIENT_BEGIN:
		ClientBegin( arg0, arg1);
		return 0;
	case GAME_CLIENT_COMMAND:
		ClientCommand( arg0 );
		return 0;
	case GAME_RUN_FRAME:
		G_RunFrame( arg0 );
		return 0;
	case GAME_CONSOLE_COMMAND:
		return ConsoleCommand();
	case BOTAI_START_FRAME:
		return BotAIStartFrame( arg0 );
	}

	return -1;
}


void QDECL G_Printf( const char *fmt, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, fmt);
	vsprintf (text, fmt, argptr);
	va_end (argptr);

	trap_Printf( text );

	as_sendMessageToReferees(text);	//powerr - q3as
}

void QDECL G_Error( const char *fmt, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, fmt);
	vsprintf (text, fmt, argptr);
	va_end (argptr);

	as_admin_log("Server halting due to fatal error: %s\n", text);	//powerr - q3as

	trap_Error( text );
}

/*
================
G_FindTeams

Chain together all entities with a matching team field.
Entity teams are used for item groups and multi-entity mover groups.

All but the first will have the FL_TEAMSLAVE flag set and teammaster field set
All but the last will have the teamchain field set to the next one
================
*/
void G_FindTeams( void ) {
	gentity_t	*e, *e2;
	int		i, j;
	int		c, c2;

	c = 0;
	c2 = 0;
	for ( i=1, e=g_entities+i ; i < level.num_entities ; i++,e++ ){
		if (!e->inuse)
			continue;
		if (!e->team)
			continue;
		if (e->flags & FL_TEAMSLAVE)
			continue;
		e->teammaster = e;
		c++;
		c2++;
		for (j=i+1, e2=e+1 ; j < level.num_entities ; j++,e2++)
		{
			if (!e2->inuse)
				continue;
			if (!e2->team)
				continue;
			if (e2->flags & FL_TEAMSLAVE)
				continue;
			if (!strcmp(e->team, e2->team))
			{
				c2++;
				e2->teamchain = e->teamchain;
				e->teamchain = e2;
				e2->teammaster = e;
				e2->flags |= FL_TEAMSLAVE;

				// make sure that targets only point at the master
				if ( e2->targetname ) {
					e->targetname = e2->targetname;
					e2->targetname = NULL;
				}
			}
		}
	}

	G_Printf ("%i teams with %i entities\n", c, c2);
}

/*
=================
G_RegisterCvars
=================
*/
void G_RegisterCvars( void ) {
	int			i;
	cvarTable_t	*cv;

	for ( i = 0, cv = gameCvarTable ; i < gameCvarTableSize ; i++, cv++ ) {
		trap_Cvar_Register( cv->vmCvar, cv->cvarName,
			cv->defaultString, cv->cvarFlags );
		if ( cv->vmCvar )
			cv->modificationCount = cv->vmCvar->modificationCount;
	}

	// check some things

	if ( g_gametype.integer < 0 || g_gametype.integer >= GT_MAX_GAME_TYPE ) {
		G_Printf( "g_gametype %i is out of range, defaulting to 0\n", g_gametype.integer );
		trap_Cvar_Set( "g_gametype", "0" );
	}

	level.warmupModificationCount = g_warmup.modificationCount;
}

/*
=================
G_UpdateCvars
=================
*/
void G_UpdateCvars( void ) {
	int			i;
	cvarTable_t	*cv;

	for ( i = 0, cv = gameCvarTable ; i < gameCvarTableSize ; i++, cv++ ) {
		if ( cv->vmCvar ) {
			trap_Cvar_Update( cv->vmCvar );

			if ( cv->modificationCount != cv->vmCvar->modificationCount ) {
				cv->modificationCount = cv->vmCvar->modificationCount;

				if ( cv->trackChange ) {
					trap_SendServerCommand( -1, va("print \"Server: %s changed to %s\n\"", 
						cv->cvarName, cv->vmCvar->string ) );
				}
			}
		}
	}
}


/*
============
G_InitGame

============
*/
void G_InitGame( int levelTime, int randomSeed, int restart ) {
	int					i;

	G_Printf ("------- Game Initialization -------\n");
	G_Printf ("gamename: %s\n", GAMEVERSION);
	G_Printf ("gamedate: %s\n", __DATE__);

	srand( randomSeed );

	G_RegisterCvars();
	as_registerCvars();	//powerr - q3as

	G_ProcessIPBans();

	G_InitMemory();

	// set some level globals
	memset( &level, 0, sizeof( level ) );
	level.time = levelTime;
	level.startTime = levelTime;

	as_openDebugLog();				//powerr - q3as

	level.snd_fry = G_SoundIndex("sound/player/fry.wav");	// FIXME standing in lava / slime

	if ( g_gametype.integer != GT_SINGLE_PLAYER && g_log.string[0] ) {
		if ( g_logSync.integer ) {
			trap_FS_FOpenFile( g_log.string, &level.logFile, FS_APPEND_SYNC );
		} else {
			trap_FS_FOpenFile( g_log.string, &level.logFile, FS_APPEND );
		}
		if ( !level.logFile ) {
			G_Printf( "WARNING: Couldn't open logfile: %s\n", g_log.string );
		} else {
			char	serverinfo[MAX_INFO_STRING];

			trap_GetServerinfo( serverinfo, sizeof( serverinfo ) );

			G_LogPrintf("------------------------------------------------------------\n" );
		    G_LogPrintf(" Starting Loging To File.\n" );
		
			if (g_logfilter.integer & 256 ){ //powerr (log filter - InitGame)	
			G_LogPrintf("InitGame: %s\n", serverinfo );
			}
		}
	} else {
		G_Printf( "Not logging to disk.\n" );
	}

	G_InitWorldSession();

	// initialize all entities for this game
	memset( g_entities, 0, MAX_GENTITIES * sizeof(g_entities[0]) );
	level.gentities = g_entities;

	// initialize all clients for this game
	level.maxclients = g_maxclients.integer;
	memset( g_clients, 0, MAX_CLIENTS * sizeof(g_clients[0]) );
	level.clients = g_clients;

	// set client fields on player ents
	for ( i=0 ; i<level.maxclients ; i++ ) {
		g_entities[i].client = level.clients + i;
	}

	// always leave room for the max number of clients,
	// even if they aren't all used, so numbers inside that
	// range are NEVER anything but clients
	level.num_entities = MAX_CLIENTS;

	// let the server system know where the entites are
	trap_LocateGameData( level.gentities, level.num_entities, sizeof( gentity_t ), 
		&level.clients[0].ps, sizeof( level.clients[0] ) );

	// reserve some spots for dead player bodies
	InitBodyQue();

	ClearRegisteredItems();

	// parse the key/value pairs and spawn gentities
	G_SpawnEntitiesFromString();

	// general initialization
	G_FindTeams();

	// make sure we have flags for CTF, etc
	if( g_gametype.integer >= GT_TEAM ) {
		G_CheckTeamItems();
	}

	SaveRegisteredItems();

	G_Printf ("-----------------------------------\n");

	if( g_gametype.integer == GT_SINGLE_PLAYER || trap_Cvar_VariableIntegerValue( "com_buildScript" ) ) {
		G_ModelIndex( SP_PODIUM_MODEL );
		G_SoundIndex( "sound/player/gurp1.wav" );
		G_SoundIndex( "sound/player/gurp2.wav" );
	}

	if ( trap_Cvar_VariableIntegerValue( "bot_enable" ) ) {
		BotAISetup( restart );
		BotAILoadMap( restart );
		G_InitBots( restart );
	}

//	as_postInitInit();	// q3as
	as_admin_log("Server initialized and ready.\n");		//powerr - q3as

}



/*
=================
G_ShutdownGame
=================
*/
void G_ShutdownGame( int restart ) {
	G_Printf ("==== ShutdownGame ====\n");

	as_admin_log("Server shutting down.\n");	//powerr - q3as

	if ( level.logFile ) {
		G_LogPrintf("ShutdownGame:\n" );
		G_LogPrintf("------------------------------------------------------------\n" );
		trap_FS_FCloseFile( level.logFile );
		level.logFile = 0;	//powerr - q3as
	}

	//powerr - begin q3as
	if ( as_level.debugfile ) {
		trap_FS_FCloseFile( as_level.debugfile );
		as_level.debugfile = 0;
	}
	// end q3as

	// write all the client session data so we can get it back
	G_WriteSessionData();

	if ( trap_Cvar_VariableIntegerValue( "bot_enable" ) ) {
		BotAIShutdown( restart );
	}
}



//===================================================================

#ifndef GAME_HARD_LINKED
// this is only here so the functions in q_shared.c and bg_*.c can link

void QDECL Com_Error ( int level, const char *error, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, error);
	vsprintf (text, error, argptr);
	va_end (argptr);

	G_Error( "%s", text);
}

void QDECL Com_Printf( const char *msg, ... ) {
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	G_Printf ("%s", text);
}

#endif

/*
========================================================================

PLAYER COUNTING / SCORE SORTING

========================================================================
*/

/*
=============
AddTournamentPlayer

If there are less than two tournament players, put a
spectator in the game and restart
=============
*/
void AddTournamentPlayer( void ) {
	int			i;
	gclient_t	*client;
	gclient_t	*nextInLine;

	if ( level.numPlayingClients >= 2 ) {
		return;
	}

	// never change during intermission
	if ( level.intermissiontime ) {
		return;
	}

	nextInLine = NULL;

	for ( i = 0 ; i < level.maxclients ; i++ ) {
		client = &level.clients[i];
		if ( client->pers.connected != CON_CONNECTED ) {
			continue;
		}
		if ( client->sess.sessionTeam != TEAM_SPECTATOR ) {
			continue;
		}
		// never select the dedicated follow or scoreboard clients
		if ( client->sess.spectatorState == SPECTATOR_SCOREBOARD || 
			client->sess.spectatorClient < 0  ) {
			continue;
		}

		if ( !nextInLine || client->sess.spectatorTime < nextInLine->sess.spectatorTime ) {
			nextInLine = client;
		}
	}

	if ( !nextInLine ) {
		return;
	}

	level.warmupTime = -1;

	// set them to free-for-all team
	SetTeam( &g_entities[ nextInLine - level.clients ], "f" );
}


/*
=======================
RemoveTournamentLoser

Make the loser a spectator at the back of the line
=======================
*/
void RemoveTournamentLoser( void ) {
	int			clientNum;

	if ( level.numPlayingClients != 2 ) {
		return;
	}

	clientNum = level.sortedClients[1];

	if ( level.clients[ clientNum ].pers.connected != CON_CONNECTED ) {
		return;
	}

	// make them a spectator
	SetTeam( &g_entities[ clientNum ], "s" );
}


/*
=======================
AdjustTournamentScores
=======================
*/
void AdjustTournamentScores( void ) {
	int			clientNum;

	clientNum = level.sortedClients[0];
	if ( level.clients[ clientNum ].pers.connected == CON_CONNECTED ) {
		level.clients[ clientNum ].sess.wins++;
		ClientUserinfoChanged( clientNum );
	}

	clientNum = level.sortedClients[1];
	if ( level.clients[ clientNum ].pers.connected == CON_CONNECTED ) {
		level.clients[ clientNum ].sess.losses++;
		ClientUserinfoChanged( clientNum );
	}

}

/*
=============
SortRanks

=============
*/
int QDECL SortRanks( const void *a, const void *b ) {
	gclient_t	*ca, *cb;

	ca = &level.clients[*(int *)a];
	cb = &level.clients[*(int *)b];

	// sort special clients last
	if ( ca->sess.spectatorState == SPECTATOR_SCOREBOARD || ca->sess.spectatorClient < 0 ) {
		return 1;
	}
	if ( cb->sess.spectatorState == SPECTATOR_SCOREBOARD || cb->sess.spectatorClient < 0  ) {
		return -1;
	}

	// then connecting clients
	if ( ca->pers.connected == CON_CONNECTING ) {
		return 1;
	}
	if ( cb->pers.connected == CON_CONNECTING ) {
		return -1;
	}


	// then spectators
	if ( ca->sess.sessionTeam == TEAM_SPECTATOR && cb->sess.sessionTeam == TEAM_SPECTATOR ) {
		if ( ca->sess.spectatorTime < cb->sess.spectatorTime ) {
			return -1;
		}
		if ( ca->sess.spectatorTime > cb->sess.spectatorTime ) {
			return 1;
		}
		return 0;
	}
	if ( ca->sess.sessionTeam == TEAM_SPECTATOR ) {
		return 1;
	}
	if ( cb->sess.sessionTeam == TEAM_SPECTATOR ) {
		return -1;
	}

	// then sort by score
	if ( ca->ps.persistant[PERS_SCORE]
		> cb->ps.persistant[PERS_SCORE] ) {
		return -1;
	}
	if ( ca->ps.persistant[PERS_SCORE]
		< cb->ps.persistant[PERS_SCORE] ) {
		return 1;
	}
	return 0;
}

/*
============
CalculateRanks

Recalculates the score ranks of all players
This will be called on every client connect, begin, disconnect, death,
and team change.
============
*/
void CalculateRanks( void ) {
	int		i;
	int		rank;
	int		score;
	int		newScore;
	gclient_t	*cl;

	level.follow1 = -1;
	level.follow2 = -1;
	level.numConnectedClients = 0;
	level.numNonSpectatorClients = 0;
	level.numPlayingClients = 0;
	level.numVotingClients = 0;		// don't count bots
	for ( i = 0 ; i < level.maxclients ; i++ ) {
		if ( level.clients[i].pers.connected != CON_DISCONNECTED ) {
			level.sortedClients[level.numConnectedClients] = i;
			as_level.timeSortedClients[level.numConnectedClients] = i;	//powerr - q3as
			level.numConnectedClients++;

			if ( level.clients[i].sess.sessionTeam != TEAM_SPECTATOR ) {
				level.numNonSpectatorClients++;
			
				// decide if this should be auto-followed
				if ( level.clients[i].pers.connected == CON_CONNECTED ) {
					level.numPlayingClients++;
					if ( !(g_entities[i].r.svFlags & SVF_BOT) ) {
						level.numVotingClients++;
					}
					if ( level.follow1 == -1 ) {
						level.follow1 = i;
					} else if ( level.follow2 == -1 ) {
						level.follow2 = i;
					}
				}
			}
		}
	}

	qsort( level.sortedClients, level.numConnectedClients, 
		sizeof(level.sortedClients[0]), SortRanks );

	qsort( as_level.timeSortedClients, level.numConnectedClients,
		sizeof(as_level.timeSortedClients[0]), as_sortTimeScore );	//powerr - q3as

	// set the rank value for all clients that are connected and not spectators
	if ( g_gametype.integer >= GT_TEAM ) {
		// in team games, rank is just the order of the teams, 0=red, 1=blue, 2=tied
		for ( i = 0;  i < level.numConnectedClients; i++ ) {
			cl = &level.clients[ level.sortedClients[i] ];
			if ( level.teamScores[TEAM_RED] == level.teamScores[TEAM_BLUE] ) {
				cl->ps.persistant[PERS_RANK] = 2;
			} else if ( level.teamScores[TEAM_RED] > level.teamScores[TEAM_BLUE] ) {
				cl->ps.persistant[PERS_RANK] = 0;
			} else {
				cl->ps.persistant[PERS_RANK] = 1;
			}
		}
	} else {	
		rank = -1;
		score = 0;
		for ( i = 0;  i < level.numPlayingClients; i++ ) {
			cl = &level.clients[ level.sortedClients[i] ];
			newScore = cl->ps.persistant[PERS_SCORE];
			if ( i == 0 || newScore != score ) {
				rank = i;
				// assume we aren't tied until the next client is checked
				level.clients[ level.sortedClients[i] ].ps.persistant[PERS_RANK] = rank;
			} else {
				// we are tied with the previous client
				level.clients[ level.sortedClients[i-1] ].ps.persistant[PERS_RANK] = rank | RANK_TIED_FLAG;
				level.clients[ level.sortedClients[i] ].ps.persistant[PERS_RANK] = rank | RANK_TIED_FLAG;
			}
			score = newScore;
			if ( g_gametype.integer == GT_SINGLE_PLAYER && level.numPlayingClients == 1 ) {
				level.clients[ level.sortedClients[i] ].ps.persistant[PERS_RANK] = rank | RANK_TIED_FLAG;
			}
		}
	}

	// set the CS_SCORES1/2 configstrings, which will be visible to everyone
	if ( g_gametype.integer >= GT_TEAM ) {
		trap_SetConfigstring( CS_SCORES1, va("%i", level.teamScores[TEAM_RED] ) );
		trap_SetConfigstring( CS_SCORES2, va("%i", level.teamScores[TEAM_BLUE] ) );
	} else {
		if ( level.numConnectedClients == 0 ) {
			trap_SetConfigstring( CS_SCORES1, va("%i", SCORE_NOT_PRESENT) );
			trap_SetConfigstring( CS_SCORES2, va("%i", SCORE_NOT_PRESENT) );
		} else if ( level.numConnectedClients == 1 ) {
			trap_SetConfigstring( CS_SCORES1, va("%i", level.clients[ level.sortedClients[0] ].ps.persistant[PERS_SCORE] ) );
			trap_SetConfigstring( CS_SCORES2, va("%i", SCORE_NOT_PRESENT) );
		} else {
			trap_SetConfigstring( CS_SCORES1, va("%i", level.clients[ level.sortedClients[0] ].ps.persistant[PERS_SCORE] ) );
			trap_SetConfigstring( CS_SCORES2, va("%i", level.clients[ level.sortedClients[1] ].ps.persistant[PERS_SCORE] ) );
		}
	}

	// see if it is time to end the level
/*freeze
	CheckExitRules();
freeze*/

	// if we are at the intermission, send the new info to everyone
	if ( level.intermissiontime ) {
		SendScoreboardMessageToAllClients();
	}
}


/*
========================================================================

MAP CHANGING

========================================================================
*/

/*
========================
SendScoreboardMessageToAllClients

Do this at BeginIntermission time and whenever ranks are recalculated
due to enters/exits/forced team changes
========================
*/
void SendScoreboardMessageToAllClients( void ) {
	int		i;

	for ( i = 0 ; i < level.maxclients ; i++ ) {
		if ( level.clients[ i ].pers.connected == CON_CONNECTED ) {
			DeathmatchScoreboardMessage( g_entities + i );
		}
	}
}

/*
========================
MoveClientToIntermission

When the intermission starts, this will be called for all players.
If a new client connects, this will be called after the spawn function.
========================
*/
void MoveClientToIntermission( gentity_t *ent ) {
	// take out of follow mode if needed
	if ( ent->client->sess.spectatorState == SPECTATOR_FOLLOW ) {
		StopFollowing( ent );
	}


	// move to the spot
	VectorCopy( level.intermission_origin, ent->s.origin );
	VectorCopy( level.intermission_origin, ent->client->ps.origin );
	VectorCopy (level.intermission_angle, ent->client->ps.viewangles);
	ent->client->ps.pm_type = PM_INTERMISSION;

	// clean up powerup info
	memset( ent->client->ps.powerups, 0, sizeof(ent->client->ps.powerups) );

	ent->client->ps.eFlags = 0;
	ent->s.eFlags = 0;
	ent->s.eType = ET_GENERAL;
	ent->s.modelindex = 0;
	ent->s.loopSound = 0;
	ent->s.event = 0;
	ent->r.contents = 0;
}

/*
==================
FindIntermissionPoint

This is also used for spectator spawns
==================
*/
void FindIntermissionPoint( void ) {
	gentity_t	*ent, *target;
	vec3_t		dir;

	// find the intermission spot
	ent = G_Find (NULL, FOFS(classname), "info_player_intermission");
	if ( !ent ) {	// the map creator forgot to put in an intermission point...
		SelectSpawnPoint ( vec3_origin, level.intermission_origin, level.intermission_angle );
	} else {
		VectorCopy (ent->s.origin, level.intermission_origin);
		VectorCopy (ent->s.angles, level.intermission_angle);
		// if it has a target, look towards it
		if ( ent->target ) {
			target = G_PickTarget( ent->target );
			if ( target ) {
				VectorSubtract( target->s.origin, level.intermission_origin, dir );
				vectoangles( dir, level.intermission_angle );
			}
		}
	}

}

/*
==================
BeginIntermission
==================
*/
void BeginIntermission( void ) {
	int			i;
	gentity_t	*client;

	if ( level.intermissiontime ) {
		return;		// already active
	}

	// if in tournement mode, change the wins / losses
	if ( g_gametype.integer == GT_TOURNAMENT ) {
		AdjustTournamentScores();
	}

	level.intermissiontime = level.time;
	FindIntermissionPoint();

	// if single player game
	if ( g_gametype.integer == GT_SINGLE_PLAYER ) {
		UpdateTournamentInfo();
		SpawnModelsOnVictoryPads();
	}

	// move all clients to the intermission point
	for (i=0 ; i< level.maxclients ; i++) {
		client = g_entities + i;
		if (!client->inuse)
			continue;
		// respawn if dead
		if (client->health <= 0) {
			respawn(client);
		}
		MoveClientToIntermission( client );
	}

	// send the current scoring to all clients
	SendScoreboardMessageToAllClients();
}


/*
=============
ExitLevel

When the intermission has been exited, the server is either killed
or moved to a new level based on the "nextmap" cvar 

=============
*/
void ExitLevel (void) {
	int		i;
// add at top of function - bug fix
	char	nextmap[MAX_STRING_CHARS];
	char	d1[MAX_STRING_CHARS];

	//bot interbreeding
	BotInterbreedEndMatch();

	// if we are running a tournement map, kick the loser to spectator status,
	// which will automatically grab the next spectator and restart
	if ( g_gametype.integer == GT_TOURNAMENT ) {
		if ( !level.restarted ) {
			RemoveTournamentLoser();
			trap_SendConsoleCommand( EXEC_APPEND, "map_restart 0\n" );
			level.restarted = qtrue;
			level.changemap = NULL;
			level.intermissiontime = 0;
		}
		return;	
	}
	//Map rotason bug fix by timbo
// further down
   	trap_Cvar_VariableStringBuffer( "nextmap", nextmap, sizeof(nextmap) );
	trap_Cvar_VariableStringBuffer( "d1", d1, sizeof(d1) );
  
	if( !Q_stricmp( nextmap, "map_restart 0" ) && Q_stricmp( d1, "" ) ) {   	
	
	trap_Cvar_Set( "nextmap", "vstr d2");	
	trap_SendConsoleCommand( EXEC_APPEND, "vstr d1\n" ); 
  } else {

	trap_SendConsoleCommand( EXEC_APPEND, "vstr nextmap\n" );
  }
	level.changemap = NULL;
	level.intermissiontime = 0;

	// we need to do this here before chaning to CON_CONNECTING
	G_WriteSessionData();

	// change all client states to connecting, so the early players into the
	// next level will know the others aren't done reconnecting
	for (i=0 ; i< g_maxclients.integer ; i++) {
		if ( level.clients[i].pers.connected == CON_CONNECTED ) {
			level.clients[i].pers.connected = CON_CONNECTING;
		}
	}

}

/*
=================
G_LogPrintf

Print to the logfile with a time stamp if it is open
=================
*/
void QDECL G_LogPrintf( const char *fmt, ... ) {
	va_list		argptr;
	char		string[1024];
	int			min, tens, sec;

	sec = level.time / 1000;

	min = sec / 60;
	sec -= min * 60;
	tens = sec / 10;
	sec -= tens * 10;

	Com_sprintf( string, sizeof(string), "%3i:%i%i ", min, tens, sec );

	va_start( argptr, fmt );
	vsprintf( string +7 , fmt,argptr );
	va_end( argptr );

	if ( g_dedicated.integer ) {
		G_Printf( "%s", string + 7 );
	}

	if ( !level.logFile ) {
		return;
	}

	trap_FS_Write( string, strlen( string ), level.logFile );
}

/*
================
LogExit

Append information about this game to the log file
================
*/
void LogExit( const char *string ) {
	int				i, numSorted;
	gclient_t		*cl;

	G_LogPrintf( "Exit: %s\n", string );

	level.intermissionQueued = level.time;

	// this will keep the clients from playing any voice sounds
	// that will get cut off when the queued intermission starts
	trap_SetConfigstring( CS_INTERMISSION, "1" );

	// don't send more than 32 scores (FIXME?)
	numSorted = level.numConnectedClients;
	if ( numSorted > 32 ) {
		numSorted = 32;
	}

	if ( g_gametype.integer >= GT_TEAM ) {
		G_LogPrintf( "red:%i  blue:%i\n",
			level.teamScores[TEAM_RED], level.teamScores[TEAM_BLUE] );
	}

	for (i=0 ; i < numSorted ; i++) {
		int		ping;

		cl = &level.clients[level.sortedClients[i]];

		if ( cl->sess.sessionTeam == TEAM_SPECTATOR ) {
			continue;
		}
		if ( cl->pers.connected == CON_CONNECTING ) {
			continue;
		}

		ping = cl->ps.ping < 999 ? cl->ps.ping : 999;

		G_LogPrintf( "score: %i  ping: %i  client: %i %s\n", 
			cl->ps.persistant[PERS_SCORE], ping, level.sortedClients[i],
			cl->pers.netname );
	}
}


/*
=================
CheckIntermissionExit

The level will stay at the intermission for a minimum of 5 seconds
If all players wish to continue, the level will then exit.
If one or more players have not acknowledged the continue, the game will
wait 10 seconds before going on.
=================
*/
void CheckIntermissionExit( void ) {
	int			ready, notReady;
	int			i;
	gclient_t	*cl;
	int			readyMask;

	if ( g_gametype.integer == GT_SINGLE_PLAYER ) {
		return;
	}

	// see which players are ready
	ready = 0;
	notReady = 0;
	readyMask = 0;
	for (i=0 ; i< g_maxclients.integer ; i++) {
		cl = level.clients + i;
		if ( cl->pers.connected != CON_CONNECTED ) {
			continue;
		}
		if ( g_entities[cl->ps.clientNum].r.svFlags & SVF_BOT ) {
			continue;
		}

		if ( cl->readyToExit ) {
			ready++;
			if ( i < 16 ) {
				readyMask |= 1 << i;
			}
		} else {
			notReady++;
		}
	}

	// copy the readyMask to each player's stats so
	// it can be displayed on the scoreboard
	for (i=0 ; i< g_maxclients.integer ; i++) {
		cl = level.clients + i;
		if ( cl->pers.connected != CON_CONNECTED ) {
			continue;
		}
		cl->ps.stats[STAT_CLIENTS_READY] = readyMask;
	}

	// never exit in less than five seconds
	if ( level.time < level.intermissiontime + 5000 ) {
		return;
	}

	//powerr - begin q3as
	if ( as_max_intermission.integer ) {
		if ( level.time > level.intermissiontime + as_max_intermission.integer * 1000 ) {
			as_debug("as_max_intermission reached, exiting level\n");
			ExitLevel();
			return;
		}
	}
	// end q3as

	// if nobody wants to go, clear timer
	if ( !ready && notReady ) {
		level.readyToExit = qfalse;
		return;
	}

	// if everyone wants to go, go now
	if ( !notReady ) {
		ExitLevel();
		return;
	}

	// the first person to ready starts the ten second timeout
	if ( !level.readyToExit ) {
		level.readyToExit = qtrue;
		level.exitTime = level.time;
	}

	// if we have waited ten seconds since at least one player
	// wanted to exit, go ahead
	if ( level.time < level.exitTime + 10000 ) {
		return;
	}

	ExitLevel();
}

/*
=============
ScoreIsTied
=============
*/
qboolean ScoreIsTied( void ) {
	int		a, b;

	if ( level.numPlayingClients < 2 ) {
		return qfalse;
	}
	
	if ( g_gametype.integer >= GT_TEAM ) {
		return level.teamScores[TEAM_RED] == level.teamScores[TEAM_BLUE];
	}

	a = level.clients[level.sortedClients[0]].ps.persistant[PERS_SCORE];
	b = level.clients[level.sortedClients[1]].ps.persistant[PERS_SCORE];

	return a == b;
}

/*
=================
CheckExitRules

There will be a delay between the time the exit is qualified for
and the time everyone is moved to the intermission spot, so you
can see the last frag.
=================
*/
void CheckExitRules( void ) {
	int			i;
	gclient_t	*cl;
	// if at the intermission, wait for all non-bots to
	// signal ready, then go to next level
	if ( level.intermissiontime ) {
		CheckIntermissionExit ();
		return;
	}

	if ( level.intermissionQueued ) {
		if ( level.time - level.intermissionQueued >= INTERMISSION_DELAY_TIME ) {
			level.intermissionQueued = 0;
			BeginIntermission();
		}
		return;
	}
//freeze
	CheckDelay();
//freeze

	// check for sudden death
	if ( ScoreIsTied() ) {
		// always wait for sudden death
		return;
	}

	if ( g_timelimit.integer && !level.warmupTime ) {
		if ( level.time - level.startTime >= g_timelimit.integer*60000 ) {
			trap_SendServerCommand( -1, "print \"Timelimit hit.\n\"");
			LogExit( "Timelimit hit." );
			as_logOSP("Game_End: Timelimit\n");	//powerr - q3as
			return;
		}
	}

	//powerr - begin q3as
	if ( as_time_during_warmup.integer && g_timelimit.integer) {
		if ( level.time - level.startTime >= g_timelimit.integer * 60000 ) {
			as_debug("In warmup; timelimit hit, so exiting because as_time_during_warmup is set\n");
			trap_SendServerCommand( -1, "print \"Timelimit hit.\n\"");
			LogExit( "Timelimit hit." );
			as_logOSP("Game_End: Timelimit\n");	//powerr - q3as
			return;
		}
	}
	//end q3as

	if ( level.numPlayingClients < 2 ) {
		return;
	}

	if ( g_gametype.integer != GT_CTF && g_fraglimit.integer ) {
		if ( level.teamScores[TEAM_RED] >= g_fraglimit.integer ) {
			trap_SendServerCommand( -1, va("print S_COLOR_RED \"%s" S_COLOR_WHITE " hit the fraglimit.\n\"", g_redteam.string ));
			LogExit( "Fraglimit hit." );
			as_logOSP("Game_End: Fraglimit\n");	//powerr - q3as
			return;
		}

		if ( level.teamScores[TEAM_BLUE] >= g_fraglimit.integer ) {
			trap_SendServerCommand( -1, va("print S_COLOR_BLUE \"%s" S_COLOR_WHITE " hit the fraglimit.\n\"", g_blueteam.string ));
			LogExit( "Fraglimit hit." );
			as_logOSP("Game_End: Fraglimit\n");	//powerr - q3as
			return;
		}

		for ( i=0 ; i< g_maxclients.integer ; i++ ) {
			cl = level.clients + i;
			if ( cl->pers.connected != CON_CONNECTED ) {
				continue;
			}
			if ( cl->sess.sessionTeam != TEAM_FREE ) {
				continue;
			}

			if ( cl->ps.persistant[PERS_SCORE] >= g_fraglimit.integer ) {
				LogExit( "Fraglimit hit." );
				as_logOSP("Game_End: Fraglimit\n");	//powerr - q3as
				trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " hit the fraglimit.\n\"",
					cl->pers.netname ) );
				return;
			}
		}
	}

/*freeze
	if ( g_gametype.integer == GT_CTF && g_capturelimit.integer ) {
freeze*/
	if ( g_gametype.integer >= GT_TEAM && g_capturelimit.integer ) {
//freeze

		if ( level.teamScores[TEAM_RED] >= g_capturelimit.integer ) {
			trap_SendServerCommand( -1, "print \"Red hit the capturelimit.\n\"" );
			LogExit( "Capturelimit hit." );
			as_logOSP("Game_End: CaptureLimit\n");	//powerr - q3as
			return;
		}

		if ( level.teamScores[TEAM_BLUE] >= g_capturelimit.integer ) {
			trap_SendServerCommand( -1, "print \"Blue hit the capturelimit.\n\"" );
			LogExit( "Capturelimit hit." );
			as_logOSP("Game_End: Capturelimit\n");	//powerr - q3as
			return;
		}
	}
}



/*
========================================================================

FUNCTIONS CALLED EVERY FRAME

========================================================================
*/


/*
=============
CheckTournement

Once a frame, check for changes in tournement player state
=============
*/
void CheckTournement( void ) {
	// check because we run 3 game frames before calling Connect and/or ClientBegin
	// for clients on a map_restart
	if ( level.numPlayingClients == 0 ) {
		return;
	}

	if ( g_gametype.integer == GT_TOURNAMENT ) {

		// pull in a spectator if needed
		if ( level.numPlayingClients < 2 ) {
			AddTournamentPlayer();
		}

		// if we don't have two players, go back to "waiting for players"
		if ( level.numPlayingClients != 2 ) {
			if ( level.warmupTime != -1 ) {
				level.warmupTime = -1;
				trap_SetConfigstring( CS_WARMUP, va("%i", level.warmupTime) );
				G_LogPrintf( "Warmup:\n" );
			}
			return;
		}

		if ( level.warmupTime == 0 ) {
			return;
		}

		// if the warmup is changed at the console, restart it
		if ( g_warmup.modificationCount != level.warmupModificationCount ) {
			level.warmupModificationCount = g_warmup.modificationCount;
			level.warmupTime = -1;
		}

		// if all players have arrived, start the countdown
		if ( level.warmupTime < 0 ) {
			if ( level.numPlayingClients == 2 ) {
               
				// Bugfix By timbo 
				if( g_warmup.integer > 1 ) {
				// fudge by -1 to account for extra delays
				level.warmupTime = level.time + ( g_warmup.integer - 1 ) * 1000;
			   } else { 
				  level.warmupTime = 0;
			   }  // end fix
				trap_SetConfigstring( CS_WARMUP, va("%i", level.warmupTime) );
			}
			return;
		}

		// if the warmup time has counted down, restart
		if ( level.time > level.warmupTime ) {
			level.warmupTime += 10000;
			trap_Cvar_Set( "g_restarted", "1" );
			trap_SendConsoleCommand( EXEC_APPEND, "map_restart 0\n" );
			level.restarted = qtrue;
			return;
		}
	} else if ( g_gametype.integer != GT_SINGLE_PLAYER && g_doWarmup.integer ) {
		int		counts[TEAM_NUM_TEAMS];
		qboolean	notEnough = qfalse;

		if ( g_gametype.integer > GT_TEAM ) {
			counts[TEAM_BLUE] = TeamCount( -1, TEAM_BLUE );
			counts[TEAM_RED] = TeamCount( -1, TEAM_RED );

			if (counts[TEAM_RED] < 1 || counts[TEAM_BLUE] < 1) {
				notEnough = qtrue;
			}
		} else if ( level.numPlayingClients < 2 ) {
			notEnough = qtrue;
		}

//freeze
		if ( !notEnough ) {
			notEnough = readyCheck();
		}
//freeze
		if ( notEnough ) {
			if ( level.warmupTime != -1 ) {
				level.warmupTime = -1;
				trap_SetConfigstring( CS_WARMUP, va("%i", level.warmupTime) );
				G_LogPrintf( "Warmup:\n" );
			}
			return; // still waiting for team members
		}

		if ( level.warmupTime == 0 ) {
			return;
		}

		// if the warmup is changed at the console, restart it
		if ( g_warmup.modificationCount != level.warmupModificationCount ) {
			level.warmupModificationCount = g_warmup.modificationCount;
			level.warmupTime = -1;
		}

		// if all players have arrived, start the countdown
		if ( level.warmupTime < 0 ) {
			// fudge by -1 to account for extra delays
			level.warmupTime = level.time + ( g_warmup.integer - 1 ) * 1000;
			trap_SetConfigstring( CS_WARMUP, va("%i", level.warmupTime) );
			return;
		}

		// if the warmup time has counted down, restart
		if ( level.time > level.warmupTime ) {
			level.warmupTime += 10000;
			trap_Cvar_Set( "g_restarted", "1" );
			trap_SendConsoleCommand( EXEC_APPEND, "map_restart 0\n" );
			level.restarted = qtrue;
			return;
		}
	}
}


/*
==================
CheckVote
==================
*/
void CheckVote( void ) {
	if ( !level.voteTime ) {
		return;
	}
	if ( level.time - level.voteTime >= VOTE_TIME ) {
		trap_SendServerCommand( -1, "print \"Vote failed.\n\"" );
	} else {
		if ( level.voteYes > level.numVotingClients/2 ) {
			// execute the command, then remove the vote
			trap_SendServerCommand( -1, "print \"Vote passed.\n\"" );
			as_logOSP("Vote Passed: %s\n", level.voteString);	//powerr - q3as
			trap_SendConsoleCommand( EXEC_APPEND, va("%s\n", level.voteString ) );
		} else if ( level.voteNo >= level.numVotingClients/2 ) {
			// same behavior as a timeout
			trap_SendServerCommand( -1, "print \"Vote failed.\n\"" );
			as_logOSP("Vote Failed: %s\n", level.voteString);	//powerr - q3as
		} else {
			// still waiting for a majority
			return;
		}
	}
	level.voteTime = 0;
	trap_SetConfigstring( CS_VOTE_TIME, "" );

}

/*
==================
PrintTeam
==================
*/
void PrintTeam(int team, char *message) {
	int i;

	for ( i = 0 ; i < level.maxclients ; i++ ) {
		if (level.clients[i].sess.sessionTeam != team)
			continue;
		trap_SendServerCommand( i, message );
	}
}


/*
==================
CheckCvars
==================
*/

void CheckCvars( void ) {
/*	static int lastMod = -1;

	if ( g_password.modificationCount != lastMod ) {
		lastMod = g_password.modificationCount;
		if ( *g_password.string && Q_stricmp( g_password.string, "none" ) ) {
			trap_Cvar_Set( "g_needpass", "1" );
		} else {
			trap_Cvar_Set( "g_needpass", "0" );
		}
	}
*/
}

/*
=============
G_RunThink

Runs thinking code for this frame if necessary
=============
*/
void G_RunThink (gentity_t *ent) {
	float	thinktime;

	thinktime = ent->nextthink;
	if (thinktime <= 0) {
		return;
	}
	if (thinktime > level.time) {
		return;
	}
	
	ent->nextthink = 0;
	if (!ent->think) {
		G_Error ( "NULL ent->think");
	}
	ent->think (ent);
}

/*
================
G_RunFrame

Advances the non-player objects in the world
================
*/
void G_RunFrame( int levelTime ) {
	int			i;
	gentity_t	*ent;
	int			msec;
    int start, end;

    //powerr - NT - store the time the frame started
    level.frameStartTime = trap_Milliseconds();

	// if we are waiting for the level to restart, do nothing
	if ( level.restarted ) {
		return;
	}

	level.framenum++;
	level.previousTime = level.time;
	level.time = levelTime;
	msec = level.time - level.previousTime;

	// get any cvar changes
	G_UpdateCvars();
	as_updateCvars();	//powerr - q3as

	//
	// go through all allocated objects
	//
	start = trap_Milliseconds();
	ent = &g_entities[0];
	for (i=0 ; i<level.num_entities ; i++, ent++) {
		if ( !ent->inuse ) {
			continue;
		}

		// clear events that are too old
		if ( level.time - ent->eventTime > EVENT_VALID_MSEC ) {
			if ( ent->s.event ) {
				ent->s.event = 0;	// &= EV_EVENT_BITS;
				if ( ent->client ) {
					ent->client->ps.externalEvent = 0;
					// predicted events should never be set to zero
					//ent->client->ps.events[0] = 0;
					//ent->client->ps.events[1] = 0;
				}
			}
			if ( ent->freeAfterEvent ) {
				// tempEntities or dropped items completely go away after their event
				G_FreeEntity( ent );
				continue;
			} else if ( ent->unlinkAfterEvent ) {
				// items that will respawn will hide themselves after their pickup event
				ent->unlinkAfterEvent = qfalse;
				trap_UnlinkEntity( ent );
			}
		}

		// temporary entities don't think
		if ( ent->freeAfterEvent ) {
			continue;
		}

		if ( !ent->r.linked && ent->neverFree ) {
			continue;
		}

		if ( ent->s.eType == ET_MISSILE ) {
			G_RunMissile( ent );
			continue;
		}

		if ( ent->s.eType == ET_ITEM || ent->physicsObject ) {
			G_RunItem( ent );
			continue;
		}

		if ( ent->s.eType == ET_MOVER ) {
			G_RunMover( ent );
			continue;
		}

		if ( i < MAX_CLIENTS ) {
			G_RunClient( ent );
			continue;
		}

		G_RunThink( ent );
	}
end = trap_Milliseconds();

start = trap_Milliseconds();
	// perform final fixups on the players
	ent = &g_entities[0];
	for (i=0 ; i < level.maxclients ; i++, ent++ ) {
		if ( ent->inuse ) {
			ClientEndFrame( ent );
		}
	}
end = trap_Milliseconds();

	// see if it is time to do a tournement restart
	CheckTournement();

	// see if it is time to end the level
	CheckExitRules();

	// update to team status?
	CheckTeamStatus();

	// cancel vote if timed out
	CheckVote();

	// for tracking changes
	CheckCvars();
	as_checkConfigTimeout();	//powerr - q3as
	as_checkTeams();			//powerr - q3as
}
