// Copyright (C) 1999-2000 Id Software, Inc.
//
/*
=======================================================================

GAME OPTIONS MENU

=======================================================================
*/


#include "ui_local.h"


//#define ART_FRAMEL				"menu/art/frame2_l"
//#define ART_FRAMER				"menu/art/frame1_r"
//#define ART_BACK0				"menu/art/back_0"
//#define ART_BACK1				"menu/art/back_1"

#define PREFERENCES_X_POS		360

#define ID_CROSSHAIR			127
#define ID_SIMPLEITEMS			128
#define ID_HIGHQUALITYSKY		129
#define ID_EJECTINGBRASS		130
#define ID_WALLMARKS			131
#define ID_DYNAMICLIGHTS		132
#define ID_IDENTIFYTARGET		133
#define ID_SYNCEVERYFRAME		134
#define ID_FORCEMODEL			135
#define ID_DRAWTEAMOVERLAY		136
//#define ID_ALLOWDOWNLOAD		137
#define ID_BACK					138
#define ID_LAGOMETER            139
#define ID_BLUEMODEL			140
#define ID_REDMODEL				141
#define ID_TEAMRAIL             142
#define ID_OLDRAIL              143
#define ID_OLDPLASMA            144




#define	NUM_CROSSHAIRS			10


typedef struct {
	menuframework_s		menu;

	menutext_s			banner;
//	menubitmap_s		framel;
//	menubitmap_s		framer;

	menulist_s			crosshair;
   	menulist_s			drawteamoverlay;
	menuradiobutton_s	simpleitems;
	menuradiobutton_s   lagometer;
	menuradiobutton_s	brass;
	menuradiobutton_s	wallmarks;
	menuradiobutton_s	dynamiclights;
	menuradiobutton_s	identifytarget;
	menuradiobutton_s	highqualitysky;
	menuradiobutton_s	synceveryframe;
	menuradiobutton_s	forcemodel;
    menuradiobutton_s	teamrail;      //powerr
    menuradiobutton_s	oldrail;       //powerr
    menuradiobutton_s	oldplasma;     //powerr

 	menutext_s			bluemodel; //powerr
 	menutext_s			redmodel;  //powerr
//	menuradiobutton_s	allowdownload;
//	menubitmap_s		back;
	menutext_s          back;

	qhandle_t			crosshairShader[NUM_CROSSHAIRS];
} preferences_t;

static preferences_t s_preferences;

static const char *teamoverlay_names[] =
{
	"off",
	"upper right",
	"lower right",
	"lower left",
	0
};

static void Preferences_SetMenuItems( void ) {
	s_preferences.crosshair.curvalue		= (int)trap_Cvar_VariableValue( "cg_drawCrosshair" ) % NUM_CROSSHAIRS;
 	s_preferences.simpleitems.curvalue		= trap_Cvar_VariableValue( "cg_simpleItems" ) != 0;
	s_preferences.lagometer.curvalue	    = trap_Cvar_VariableValue( "cg_lagometer" ) != 0;
	s_preferences.drawteamoverlay.curvalue	= Com_Clamp( 0, 3, trap_Cvar_VariableValue( "cg_drawTeamOverlay" ) );
	s_preferences.brass.curvalue			= trap_Cvar_VariableValue( "cg_brassTime" ) != 0;
	s_preferences.wallmarks.curvalue		= trap_Cvar_VariableValue( "cg_marks" ) != 0;
	s_preferences.identifytarget.curvalue	= trap_Cvar_VariableValue( "cg_drawCrosshairNames" ) != 0;
	s_preferences.dynamiclights.curvalue	= trap_Cvar_VariableValue( "r_dynamiclight" ) != 0;
	s_preferences.highqualitysky.curvalue	= trap_Cvar_VariableValue( "r_fastsky" ) == 0;
	s_preferences.synceveryframe.curvalue	= trap_Cvar_VariableValue( "r_finish" ) != 0;
	s_preferences.forcemodel.curvalue		= trap_Cvar_VariableValue( "cg_forcemodel" ) != 0;
	s_preferences.teamrail.curvalue		    = trap_Cvar_VariableValue( "cg_teamrails" ) != 0;
	s_preferences.oldrail.curvalue		    = trap_Cvar_VariableValue( "cg_oldrail" ) != 1;
	s_preferences.oldplasma.curvalue		= trap_Cvar_VariableValue( "cg_oldplasma" ) != 1;
//	s_preferences.allowdownload.curvalue	= trap_Cvar_VariableValue( "cl_allowDownload" ) != 0;
}


static void Preferences_Event( void* ptr, int notification ) {
	if( notification != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_CROSSHAIR:
		s_preferences.crosshair.curvalue++;
		if( s_preferences.crosshair.curvalue == NUM_CROSSHAIRS ) {
			s_preferences.crosshair.curvalue = 0;
		}
		trap_Cvar_SetValue( "cg_drawCrosshair", s_preferences.crosshair.curvalue );
		break;

   case ID_SIMPLEITEMS:
		trap_Cvar_SetValue( "cg_simpleItems", s_preferences.simpleitems.curvalue );
		break;

   
   case ID_LAGOMETER:
		trap_Cvar_SetValue( "cg_lagometer", s_preferences.lagometer.curvalue );
		break;
   
   case ID_HIGHQUALITYSKY:
		trap_Cvar_SetValue( "r_fastsky", !s_preferences.highqualitysky.curvalue );
		break;
   
   case ID_EJECTINGBRASS:
		if ( s_preferences.brass.curvalue )
			trap_Cvar_Reset( "cg_brassTime" );
		else
			trap_Cvar_SetValue( "cg_brassTime", 0 );
		break;
   
   case ID_WALLMARKS:
		trap_Cvar_SetValue( "cg_marks", s_preferences.wallmarks.curvalue );
		break;
   
   case ID_DYNAMICLIGHTS:
		trap_Cvar_SetValue( "r_dynamiclight", s_preferences.dynamiclights.curvalue );
		break;		
  
   case ID_IDENTIFYTARGET:
		trap_Cvar_SetValue( "cg_drawCrosshairNames", s_preferences.identifytarget.curvalue );
		break;

   case ID_SYNCEVERYFRAME:
		trap_Cvar_SetValue( "r_finish", s_preferences.synceveryframe.curvalue );
		break;

   case ID_FORCEMODEL:
		trap_Cvar_SetValue( "cg_forcemodel", s_preferences.forcemodel.curvalue );
		break;


 	case ID_BLUEMODEL:
 		UI_PlayerModelMenuBlue();
 		break;
 
 	case ID_REDMODEL:
 		UI_PlayerModelMenuRed();
 		break;

	case ID_DRAWTEAMOVERLAY:
		trap_Cvar_SetValue( "cg_drawTeamOverlay", s_preferences.drawteamoverlay.curvalue );
		break;

    case ID_TEAMRAIL:
		trap_Cvar_SetValue( "cg_teamrails", s_preferences.teamrail.curvalue );
		break;

    case ID_OLDRAIL:
		trap_Cvar_SetValue( "cg_oldrail", s_preferences.oldrail.curvalue );
		break;

    case ID_OLDPLASMA:
		trap_Cvar_SetValue( "cg_oldplasma", s_preferences.oldplasma.curvalue );
		break;

//	case ID_ALLOWDOWNLOAD:
//		trap_Cvar_SetValue( "cl_allowDownload", s_preferences.allowdownload.curvalue );
//		break;

	case ID_BACK:
		UI_PopMenu();
		break;
	}
}


/*
=================
Crosshair_Draw
=================
*/
static void Crosshair_Draw( void *self ) {
	menulist_s	*s;
	float		*color;
	int			x, y;
	int			style;
	qboolean	focus;

	s = (menulist_s *)self;
	x = s->generic.x;
	y =	s->generic.y;

	style = UI_SMALLFONT;
	focus = (s->generic.parent->cursor == s->generic.menuPosition);

	if ( s->generic.flags & QMF_GRAYED )
		color = text_color_disabled;
	else if ( focus )
	{
		color = text_color_highlight;
		style |= UI_PULSE;
	}
	else if ( s->generic.flags & QMF_BLINK )
	{
		color = text_color_highlight;
		style |= UI_BLINK;
	}
	else
		color = text_color_normal;

	if ( focus )
	{
		// draw cursor
		UI_FillRect( s->generic.left, s->generic.top, s->generic.right-s->generic.left+1, s->generic.bottom-s->generic.top+1, listbar_color ); 
		UI_DrawChar( x, y, 13, UI_CENTER|UI_BLINK|UI_SMALLFONT, color);
	}

	UI_DrawString( x - SMALLCHAR_WIDTH, y, s->generic.name, style|UI_RIGHT, color );
	if( !s->curvalue ) {
		return;
	}
	UI_DrawHandlePic( x + SMALLCHAR_WIDTH, y - 4, 24, 24, s_preferences.crosshairShader[s->curvalue] );
}

/*
=================
Team Model Draw
=================
*/
static void Teammodel_draw( void *self ) {
	menutext_s	*s;
	float		*color;
	int			x, y;
	int			style;
	qboolean	focus;
	char	bmodel[64];
	char	rmodel[64];

	s = (menutext_s *)self;
	x = s->generic.x;
	y =	s->generic.y;
	style = UI_SMALLFONT;
	focus = (s->generic.parent->cursor == s->generic.menuPosition);

	if ( s->generic.flags & QMF_GRAYED )
		color = text_color_disabled;
	else if ( focus )
	{
		color = text_color_highlight;
		style |= UI_PULSE;
	}
	else if ( s->generic.flags & QMF_BLINK )
	{
		color = text_color_highlight;
		style |= UI_BLINK;
	}
	else
		color = text_color_normal;

	if ( focus )
	{
		// draw cursor
		UI_FillRect( s->generic.left, s->generic.top, s->generic.right-s->generic.left+1, s->generic.bottom-s->generic.top+1, listbar_color ); 
		UI_DrawChar( x, y, 13, UI_CENTER|UI_BLINK|UI_SMALLFONT, color);
	}

	UI_DrawString( x - SMALLCHAR_WIDTH, y, s->generic.name, style|UI_RIGHT, color );

	if(s->generic.id == ID_BLUEMODEL){
		trap_Cvar_VariableStringBuffer( "cg_Bluemodel", bmodel, 64 );
		UI_DrawString(x + SMALLCHAR_WIDTH, y ,bmodel,style,color);
	}
	if(s->generic.id == ID_REDMODEL){
		trap_Cvar_VariableStringBuffer( "cg_Redmodel", rmodel, 64 );
		UI_DrawString(x + SMALLCHAR_WIDTH, y ,rmodel,style,color);
	}
}

static void Preferences_MenuInit( void ) {
	int				y;

	memset( &s_preferences, 0 ,sizeof(preferences_t) );

	Preferences_Cache();

	s_preferences.menu.wrapAround = qtrue;
	s_preferences.menu.fullscreen = qtrue;
    s_preferences.menu.powerrbackground = qtrue;

	s_preferences.banner.generic.type  = MTYPE_PTEXT;
	s_preferences.banner.generic.x	   = 320;
	s_preferences.banner.generic.y	   = 16;
	s_preferences.banner.string		   = "GAME OPTIONS";
	s_preferences.banner.color         = color_white;
	s_preferences.banner.style         = UI_CENTER|UI_DROPSHADOW;
/*
	s_preferences.framel.generic.type  = MTYPE_BITMAP;
	s_preferences.framel.generic.name  = ART_FRAMEL;
	s_preferences.framel.generic.flags = QMF_INACTIVE;
	s_preferences.framel.generic.x	   = 0;
	s_preferences.framel.generic.y	   = 78;
	s_preferences.framel.width  	   = 256;
	s_preferences.framel.height  	   = 329;

	s_preferences.framer.generic.type  = MTYPE_BITMAP;
	s_preferences.framer.generic.name  = ART_FRAMER;
	s_preferences.framer.generic.flags = QMF_INACTIVE;
	s_preferences.framer.generic.x	   = 376;
	s_preferences.framer.generic.y	   = 76;
	s_preferences.framer.width  	   = 256;
	s_preferences.framer.height  	   = 334;
*/
	y = 124;
	s_preferences.crosshair.generic.type		= MTYPE_TEXT;
	s_preferences.crosshair.generic.flags		= QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_NODEFAULTINIT|QMF_OWNERDRAW;
	s_preferences.crosshair.generic.x			= PREFERENCES_X_POS;
	s_preferences.crosshair.generic.y			= y;
	s_preferences.crosshair.generic.name		= "Crosshair:";
	s_preferences.crosshair.generic.callback	= Preferences_Event;
	s_preferences.crosshair.generic.ownerdraw	= Crosshair_Draw;
	s_preferences.crosshair.generic.id			= ID_CROSSHAIR;
	s_preferences.crosshair.generic.top			= y - 4;
	s_preferences.crosshair.generic.bottom		= y + 20;
	s_preferences.crosshair.generic.left		= PREFERENCES_X_POS - ( ( strlen(s_preferences.crosshair.generic.name) + 1 ) * SMALLCHAR_WIDTH );
	s_preferences.crosshair.generic.right		= PREFERENCES_X_POS + 48;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.simpleitems.generic.type        = MTYPE_RADIOBUTTON;
	s_preferences.simpleitems.generic.name	      = "Simple Items:";
	s_preferences.simpleitems.generic.flags	      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.simpleitems.generic.callback    = Preferences_Event;
	s_preferences.simpleitems.generic.id          = ID_SIMPLEITEMS;
	s_preferences.simpleitems.generic.x	          = PREFERENCES_X_POS;
	s_preferences.simpleitems.generic.y	          = y;


	y += BIGCHAR_HEIGHT+2;
	s_preferences.lagometer.generic.type        = MTYPE_RADIOBUTTON;
	s_preferences.lagometer.generic.name	      = "Lagometer:";
	s_preferences.lagometer.generic.flags	      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.lagometer.generic.callback    = Preferences_Event;
	s_preferences.lagometer.generic.id          = ID_LAGOMETER;
	s_preferences.lagometer.generic.x	          = PREFERENCES_X_POS;
	s_preferences.lagometer.generic.y	          = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.wallmarks.generic.type          = MTYPE_RADIOBUTTON;
	s_preferences.wallmarks.generic.name	      = "Marks on Walls:";
	s_preferences.wallmarks.generic.flags	      = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.wallmarks.generic.callback      = Preferences_Event;
	s_preferences.wallmarks.generic.id            = ID_WALLMARKS;
	s_preferences.wallmarks.generic.x	          = PREFERENCES_X_POS;
	s_preferences.wallmarks.generic.y	          = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.brass.generic.type              = MTYPE_RADIOBUTTON;
	s_preferences.brass.generic.name	          = "Ejecting Brass:";
	s_preferences.brass.generic.flags	          = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.brass.generic.callback          = Preferences_Event;
	s_preferences.brass.generic.id                = ID_EJECTINGBRASS;
	s_preferences.brass.generic.x	              = PREFERENCES_X_POS;
	s_preferences.brass.generic.y	              = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.dynamiclights.generic.type      = MTYPE_RADIOBUTTON;
	s_preferences.dynamiclights.generic.name	  = "Dynamic Lights:";
	s_preferences.dynamiclights.generic.flags     = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.dynamiclights.generic.callback  = Preferences_Event;
	s_preferences.dynamiclights.generic.id        = ID_DYNAMICLIGHTS;
	s_preferences.dynamiclights.generic.x	      = PREFERENCES_X_POS;
	s_preferences.dynamiclights.generic.y	      = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.identifytarget.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.identifytarget.generic.name	  = "Identify Target:";
	s_preferences.identifytarget.generic.flags    = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.identifytarget.generic.callback = Preferences_Event;
	s_preferences.identifytarget.generic.id       = ID_IDENTIFYTARGET;
	s_preferences.identifytarget.generic.x	      = PREFERENCES_X_POS;
	s_preferences.identifytarget.generic.y	      = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.highqualitysky.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.highqualitysky.generic.name	  = "High Quality Sky:";
	s_preferences.highqualitysky.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.highqualitysky.generic.callback = Preferences_Event;
	s_preferences.highqualitysky.generic.id       = ID_HIGHQUALITYSKY;
	s_preferences.highqualitysky.generic.x	      = PREFERENCES_X_POS;
	s_preferences.highqualitysky.generic.y	      = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.synceveryframe.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.synceveryframe.generic.name	  = "Sync Every Frame:";
	s_preferences.synceveryframe.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.synceveryframe.generic.callback = Preferences_Event;
	s_preferences.synceveryframe.generic.id       = ID_SYNCEVERYFRAME;
	s_preferences.synceveryframe.generic.x	      = PREFERENCES_X_POS;
	s_preferences.synceveryframe.generic.y	      = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.forcemodel.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.forcemodel.generic.name	  = "Force Player Models:";
	s_preferences.forcemodel.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.forcemodel.generic.callback = Preferences_Event;
	s_preferences.forcemodel.generic.id       = ID_FORCEMODEL;
	s_preferences.forcemodel.generic.x	      = PREFERENCES_X_POS;
	s_preferences.forcemodel.generic.y	      = y;


	y += BIGCHAR_HEIGHT+2;
	s_preferences.bluemodel.generic.type      = MTYPE_TEXT;
	s_preferences.bluemodel.generic.name	  = "Blue Team Model:";
	s_preferences.bluemodel.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_NODEFAULTINIT|QMF_OWNERDRAW;
	s_preferences.bluemodel.generic.callback  = Preferences_Event;
	s_preferences.bluemodel.generic.ownerdraw = Teammodel_draw;
	s_preferences.bluemodel.generic.id        = ID_BLUEMODEL;
	s_preferences.bluemodel.generic.x	      = PREFERENCES_X_POS;
	s_preferences.bluemodel.generic.y	      = y;
	s_preferences.bluemodel.color			  = color_white;
	s_preferences.bluemodel.style			  = UI_LEFT|UI_SMALLFONT;
	s_preferences.bluemodel.generic.top		  = s_preferences.bluemodel.generic.y;
	s_preferences.bluemodel.generic.bottom	  = s_preferences.bluemodel.generic.y + SMALLCHAR_HEIGHT;
	s_preferences.bluemodel.generic.left	  = s_preferences.bluemodel.generic.x - 18 * SMALLCHAR_WIDTH;
	s_preferences.bluemodel.generic.right	  = s_preferences.bluemodel.generic.x + 18 * SMALLCHAR_WIDTH;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.redmodel.generic.type      = MTYPE_TEXT;
	s_preferences.redmodel.generic.name	     = "Red Team Model :";
	s_preferences.redmodel.generic.flags	 = QMF_PULSEIFFOCUS|QMF_SMALLFONT|QMF_NODEFAULTINIT|QMF_OWNERDRAW;
	s_preferences.redmodel.generic.callback  = Preferences_Event;
	s_preferences.redmodel.generic.ownerdraw = Teammodel_draw;
	s_preferences.redmodel.generic.id        = ID_REDMODEL;
	s_preferences.redmodel.generic.x	     = PREFERENCES_X_POS;
	s_preferences.redmodel.generic.y	     = y;
	s_preferences.redmodel.color			 = color_white;
	s_preferences.redmodel.style			 = UI_LEFT|UI_SMALLFONT;
	s_preferences.redmodel.generic.top		 = s_preferences.redmodel.generic.y;
	s_preferences.redmodel.generic.bottom	 = s_preferences.redmodel.generic.y + SMALLCHAR_HEIGHT;
	s_preferences.redmodel.generic.left	     = s_preferences.redmodel.generic.x - 18 * SMALLCHAR_WIDTH;
	s_preferences.redmodel.generic.right	 = s_preferences.redmodel.generic.x + 18 * SMALLCHAR_WIDTH;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.drawteamoverlay.generic.type     = MTYPE_SPINCONTROL;
	s_preferences.drawteamoverlay.generic.name	   = "Draw Team Overlay:";
	s_preferences.drawteamoverlay.generic.flags	   = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.drawteamoverlay.generic.callback = Preferences_Event;
	s_preferences.drawteamoverlay.generic.id       = ID_DRAWTEAMOVERLAY;
	s_preferences.drawteamoverlay.generic.x	       = PREFERENCES_X_POS;
	s_preferences.drawteamoverlay.generic.y	       = y;
	s_preferences.drawteamoverlay.itemnames		   = teamoverlay_names;

//powerr (added new crav)
    y += BIGCHAR_HEIGHT+2;
	s_preferences.teamrail.generic.type       = MTYPE_RADIOBUTTON;
	s_preferences.teamrail.generic.name	      = "Team Colored Rail efx:";
	s_preferences.teamrail.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.teamrail.generic.callback   = Preferences_Event;
	s_preferences.teamrail.generic.id         = ID_TEAMRAIL;
	s_preferences.teamrail.generic.x	      = PREFERENCES_X_POS;
	s_preferences.teamrail.generic.y	      = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.oldrail.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.oldrail.generic.name	   = "Old Rail efx:";
	s_preferences.oldrail.generic.flags	   = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.oldrail.generic.callback = Preferences_Event;
	s_preferences.oldrail.generic.id       = ID_OLDRAIL;
	s_preferences.oldrail.generic.x	       = PREFERENCES_X_POS;
	s_preferences.oldrail.generic.y	       = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.oldplasma.generic.type      = MTYPE_RADIOBUTTON;
	s_preferences.oldplasma.generic.name	  = "Old Plasma efx:";
	s_preferences.oldplasma.generic.flags	  = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.oldplasma.generic.callback  = Preferences_Event;
	s_preferences.oldplasma.generic.id        = ID_OLDPLASMA;
	s_preferences.oldplasma.generic.x	      = PREFERENCES_X_POS;
	s_preferences.oldplasma.generic.y	      = y;

// auto download never fucking worked in 1.11-1.16n --powerr
/*
	y += BIGCHAR_HEIGHT+2;
	s_preferences.allowdownload.generic.type     = MTYPE_RADIOBUTTON;
	s_preferences.allowdownload.generic.name	   = "Automatic Downloading:";
	s_preferences.allowdownload.generic.flags	   = QMF_PULSEIFFOCUS|QMF_SMALLFONT;
	s_preferences.allowdownload.generic.callback = Preferences_Event;
	s_preferences.allowdownload.generic.id       = ID_ALLOWDOWNLOAD;
	s_preferences.allowdownload.generic.x	       = PREFERENCES_X_POS;
	s_preferences.allowdownload.generic.y	       = y;

	y += BIGCHAR_HEIGHT+2;
	s_preferences.back.generic.type	    = MTYPE_BITMAP;
	s_preferences.back.generic.name     = ART_BACK0;
	s_preferences.back.generic.flags    = QMF_LEFT_JUSTIFY|QMF_PULSEIFFOCUS;
	s_preferences.back.generic.callback = Preferences_Event;
	s_preferences.back.generic.id	    = ID_BACK;
	s_preferences.back.generic.x		= 0;
	s_preferences.back.generic.y		= 480-36;//64;
	s_preferences.back.width  		    = 110;//128;
	s_preferences.back.height  		    = 36;//64;
	s_preferences.back.focuspic         = ART_BACK1;
*/
    	//--powerr I change all kinds of shit here.

    s_preferences.back.generic.type	      = MTYPE_PTEXT;
	s_preferences.back.generic.flags      = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_preferences.back.generic.callback   = Preferences_Event;
	s_preferences.back.generic.id	      = ID_BACK;
	s_preferences.back.generic.x		  = 60;
	s_preferences.back.generic.y		  = 480-36;
 	s_preferences.back.string			  = "BACK";
	s_preferences.back.color			  = color_white;
	s_preferences.back.style		      = UI_CENTER|UI_DROPSHADOW;


	Menu_AddItem( &s_preferences.menu, &s_preferences.banner );
//	Menu_AddItem( &s_preferences.menu, &s_preferences.framel );
//	Menu_AddItem( &s_preferences.menu, &s_preferences.framer );

	Menu_AddItem( &s_preferences.menu, &s_preferences.crosshair );
	Menu_AddItem( &s_preferences.menu, &s_preferences.simpleitems );
	Menu_AddItem( &s_preferences.menu, &s_preferences.lagometer );
	Menu_AddItem( &s_preferences.menu, &s_preferences.wallmarks );
	Menu_AddItem( &s_preferences.menu, &s_preferences.brass );
	Menu_AddItem( &s_preferences.menu, &s_preferences.dynamiclights );
	Menu_AddItem( &s_preferences.menu, &s_preferences.identifytarget );
	Menu_AddItem( &s_preferences.menu, &s_preferences.highqualitysky );
	Menu_AddItem( &s_preferences.menu, &s_preferences.synceveryframe );
	Menu_AddItem( &s_preferences.menu, &s_preferences.forcemodel );
 	Menu_AddItem( &s_preferences.menu, &s_preferences.bluemodel );
 	Menu_AddItem( &s_preferences.menu, &s_preferences.redmodel );
	Menu_AddItem( &s_preferences.menu, &s_preferences.drawteamoverlay );
    Menu_AddItem( &s_preferences.menu, &s_preferences.teamrail );
	Menu_AddItem( &s_preferences.menu, &s_preferences.oldrail );
	Menu_AddItem( &s_preferences.menu, &s_preferences.oldplasma );
//	Menu_AddItem( &s_preferences.menu, &s_preferences.allowdownload );

	Menu_AddItem( &s_preferences.menu, &s_preferences.back );

	Preferences_SetMenuItems();
}


/*
===============
Preferences_Cache
===============
*/
void Preferences_Cache( void ) {
	int		n;

//	trap_R_RegisterShaderNoMip( ART_FRAMEL );
//	trap_R_RegisterShaderNoMip( ART_FRAMER );
//	trap_R_RegisterShaderNoMip( ART_BACK0 );
//	trap_R_RegisterShaderNoMip( ART_BACK1 );
	for( n = 0; n < NUM_CROSSHAIRS; n++ ) {
		s_preferences.crosshairShader[n] = trap_R_RegisterShaderNoMip( va("gfx/2d/crosshair%c", 'a' + n ) );
	}
}


/*
===============
UI_PreferencesMenu
===============
*/
void UI_PreferencesMenu( void ) {
	Preferences_MenuInit();
	UI_PushMenu( &s_preferences.menu );
}
