// excelautoDlg.cpp : implementation file
//

#include "stdafx.h"

#include "excelauto.h"
#include "excelautoDlg.h"
#include "DlgProxy.h"
#include "excel.h"
#include <string>
using std::string; 

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExcelautoDlg dialog

IMPLEMENT_DYNAMIC(CExcelautoDlg, CDialog);

CExcelautoDlg::CExcelautoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExcelautoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExcelautoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = NULL;
}

CExcelautoDlg::~CExcelautoDlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to NULL, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CExcelautoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExcelautoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CExcelautoDlg, CDialog)
	//{{AFX_MSG_MAP(CExcelautoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDRUN, OnRun)
	ON_BN_CLICKED(IDC_BUTTON1, OnButtonConfig)
	//}}AFX_MSG_MAP

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExcelautoDlg message handlers

BOOL CExcelautoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	iCounter = 0; //initialise the array index
	// TODO: Add extra initialization here
	return TRUE;  // return TRUE  unless you set the focus to a control
}



// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExcelautoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting
	//	Graphics graphics(dc);

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExcelautoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CExcelautoDlg::OnClose() 
{
	if (CanExit())
		CDialog::OnClose();
	
}

void CExcelautoDlg::OnOK() 
{
	if (CanExit())
		CDialog::OnOK();

}

void CExcelautoDlg::OnCancel() 
{
	if (CanExit())
		CDialog::OnCancel();
}

BOOL CExcelautoDlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}

void CExcelautoDlg::OnRun() 
{
	// TODO: Add your control notification handler code here
     
    // OLE Variant for True, False and Optional.
      COleVariant 
		  VTrue((short)TRUE),
	      VFalse((short)FALSE),
		  VOptional((long)DISP_E_PARAMNOTFOUND, VT_ERROR);

      _Application objApp; // Various objects are created for handling Excel spreadsheet
      _Workbook objBook;
      Workbooks objBooks;
      Worksheets objSheets;
      _Worksheet objSheet;
      Range objRange;
      VARIANT ret;
      long index[2]; // array index where the current row and coloum values are stored
	  int iVal[5]; // array iVal stores the values from all the coloums in a row.
	  string sVal [10]; // stores string values
      VARIANT val;
      int row, col; // counter for rows and coloumns in a FOR loop
	  CDC* pDC; // pDC & pDC1 is used for displaying graphics
	  CDC* pDC1;
	  int x1,x2,z1,z2; // coordinates used for displaying rect
	  int width,height,base,eccen; //variables used for manipulating the coordinates
	  Xcenter =10000; // X origin value
	  Zcenter =10000; // Z origin value

      // Instantiate Excel and open an existing workbook.
      objApp.CreateDispatch("Excel.Application");
      objBooks = objApp.GetWorkbooks();
	  objBook = objBooks.Open("C:\\GraphicsTest.xls",
                VOptional, VFalse, VOptional, VOptional,
                VOptional, VTrue, VOptional, VOptional,
                VTrue, VOptional, VOptional, VOptional, VOptional, VOptional);
      objSheets = objBook.GetWorksheets();
      objSheet = objSheets.GetItem(COleVariant((short)1));

      //Get the range object for which you wish to retrieve the
      //data and then retrieve the data (as a variant array, ret).
      objRange = objSheet.GetRange(COleVariant("A1"), COleVariant("E21"));
	  ret = objRange.GetValue2();
	  

      //Create the SAFEARRAY from the VARIANT ret.
      COleSafeArray sa(ret);
      
	  //Determine the array's dimensions.
      long lNumRows = 21;
      long lNumCols = 5;
	
      //Display the elements in the SAFEARRAY. 
	  //All the coloumns values in each row are stored in iVal array.
	  //before moving to the next row, the values in the previous coloumn is displayed and 
	  //the array is initialised.
	for(row=2;row<=lNumRows;row++)
    {
	   for(col=2;col<=lNumCols;col++)
	   {
		   index[0] = row;
		   index [1] = col;
		   
		   sa.GetElement(index, &val);
		   switch(val.vt)
            {
            case VT_R8:
               {
				  iVal[iCounter] = val.dblVal;
				  iCounter++;
                  break;
               }
			case VT_INT:
				{
					iVal[iCounter] = val.intVal;
					iCounter++;
					break;
				}
            case VT_BSTR:
               {
                  string sVal = (CString)val.bstrVal;
				  ::MessageBox(NULL,"Enter the correct values in SpreadSheet","Invalid Value",MB_OK);
                  break;
               }

            case VT_EMPTY:
               {
                  
                  break;
               }
            }

	   }	   
        // if all the coloumns dont have valid values then iCounter value will be not equal to 4.
       // this if loop is used for detecting the error in the spreadsheet.
	  if(iCounter == 4)  
	  {
	  
	// iVal array stores the first row values and those values are assigned to corresponding parameters
	   width = iVal[0];
	   height = iVal[1];
	   base = iVal[2];
	   eccen = iVal[3];

	   // formula
	   z1 = base;
	   z2 = base + height;
	   x1 = Xcenter + eccen - (0.5 * width);
	   x2 = Zcenter + eccen + (0.5 * width);
	
		//Pen is initialised for drawing Lines
	   pDC1 = GetDC();
	   CPen penBlack;
	   penBlack.CreatePen(PS_SOLID, 1, RGB(200,150,100));
	   CPen* pOldPen = pDC1->SelectObject(&penBlack);
	   pDC1->SelectStockObject(NULL_BRUSH);
       
       // Pen is initialised for drawing Rectangle
       pDC = GetDC();
	   CPen penBlack1;
	   penBlack1.CreatePen(PS_SOLID, 1, RGB(100,0,200));
	   CPen* pOldPen1 = pDC->SelectObject(&penBlack1);
	   pDC->SelectStockObject(NULL_BRUSH);
    
        // coordinates factored by 100
	   int xOrigin = Xcenter/100;
	   int zOrigin = Zcenter/100;

	   z1 = z1/ 100;
	   z2 = z2/100;
	   x1 = x1/100;
	   x2 = x2/100;
	
	   //draw the X axes
	   pDC1->MoveTo(xOrigin, zOrigin);
	   pDC1->LineTo(xOrigin+(xOrigin*1.5), zOrigin);
	   pDC1->TextOutA(xOrigin+(xOrigin*1.5), zOrigin,"X Axes");

	   //draw the Z axes
	   pDC1->MoveTo(xOrigin, zOrigin);
	   pDC1->LineTo(xOrigin+(xOrigin*-0.80), zOrigin+(zOrigin*1.5));
	   pDC1->TextOutA(xOrigin+(xOrigin*-0.80), zOrigin+(zOrigin*1.5),"Z Axes");
		
       //draw the rectangle

	   pDC->Rectangle(CRect(x1, z1, x2, z2));
	 

	   }
	   //array counter is initialised before moving to the next row
	   iCounter = 0;
	}
      
    //Release the DC pointer to free up memory.
	  ReleaseDC(pDC1);
      ReleaseDC(pDC);
      //Close the workbook without saving changes
      //and quit Microsoft Excel. 
	  objRange.ReleaseDispatch();
	  objSheet.ReleaseDispatch();
	  objSheets.ReleaseDispatch();
      objBook.Close(COleVariant((short)FALSE), VOptional, VOptional);
      objApp.Quit();


}

void CExcelautoDlg::OnButtonConfig() 
{
	// TODO: Add your control notification handler code here
	      COleVariant 
		  VTrue((short)TRUE),
	      VFalse((short)FALSE),
		  VOptional((long)DISP_E_PARAMNOTFOUND, VT_ERROR);

     _Application objApp;
     _Workbook objBook;
     Workbooks objBooks;
	 
// open the spread sheet for modification.
      objApp.CreateDispatch("Excel.Application");
      objBooks = objApp.GetWorkbooks();
	  objBook = objBooks.Open("C:\\GraphicsTest.xls",
                VOptional, VFalse, VOptional, VOptional,
                VOptional, VTrue, VOptional, VOptional,
                VTrue, VTrue, VOptional, VOptional, VOptional, VOptional);
	  objBook.Activate();
	  objApp.SetVisible(TRUE);
	  
}



