import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;
import javax.swing.*;

/*

NewSnake was created with help from the following authors;

John Croucher at www.jcroucher.com, Rogers Cadenhead and Lauren Lemay at www.java21days.com,
and the people at http:\\java.sun.com.

The GrrZap icon was borrowed from Leo's Icon Archive at www.iconarchive.com

*/

public class NewSnake extends JApplet implements KeyListener, Runnable {


	boolean start = true;
	boolean vertical = false;
	boolean hasStarted = false;

	boolean gameOver = false;
	boolean intro = true;

	Thread gameThread;

	static String fgFile = "dudeRant.gif";
	CubbyHole2 directions = new CubbyHole2();

	Color natural = new Color (224, 227, 144);
	Color brown = new Color (98, 68,34);
	Color darkGreen = new Color (0, 58, 0);

	Color navy = new Color (0, 0, 77);
	Color yellar = new Color (255, 212, 86);
	Color read = new Color (221, 0, 0);

	Color babyBlue = new Color (187, 209, 255);
	Color purpleRed = new Color (181, 37, 80);

	Color darkGray = new Color (86, 80, 83);
	Color lightGray = new Color (190, 190, 190);

	Color brownGreen = new Color (28, 84, 0);
	Color yella = new Color (255, 230, 0);

	JButton rock = new JButton("ROCK");

	int colorIndex = 9;
	Color colorArray[] = {darkGray, Color.black, lightGray, navy, read, yellar, 
		babyBlue, purpleRed, navy, natural, darkGreen, brown, brownGreen, read, yella};

	
	final int LEFT = 37;
	final int RIGHT = 39;
	final int UP = 38;
	final int DOWN = 40;
	final int N = 78;
	final int P = 80;
	final int ENTER = 10;

	int verticalDir = 5;
	int horizontalDir = 5;
	
	int xVal = 10;
	int yVal = 10;

	Point2D.Float food = new Point2D.Float ();
	Random foodPosition = new Random(100L);

	int snakeParts = 6;
	int endOfVector = 0;
	int playersScore = 0;
	int [] partsXs = new int[400];
	int [] partsYs = new int[400];

	int frameRate = 30;
	int pointiculty = 20;
	
	static BufferedImage buffdImage; 
	static Graphics2D imgSurface;
	Image dudeImage;

      public NewSnake() {
		
      }		


		
	public void init () {

		
        	dudeImage = getImage(getCodeBase(), fgFile);
		setBackground(Color.black);
		directions.put(horizontalDir);

		String laf = UIManager.getSystemLookAndFeelClassName();
		try {
		    UIManager.setLookAndFeel(laf);
		} catch (UnsupportedLookAndFeelException exc) {
		    System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
		} catch (Exception exc) {
		    System.err.println("Error loading " + laf + ": " + exc);
		}

		getContentPane().setLayout(new FlowLayout());
		getContentPane().add(rock);
		
		playersScore = 0;
		Integer ps = new Integer (playersScore);
		snakeParts = 6;
		xVal = yVal = 10;

		addKeyListener(this);
		vertical = false;
		directions.get();
		directions.put(5);
		endOfVector = 0;
		for (int j=0; j<400; j++) {
			partsXs[j] = 10;
			partsYs[j] = 10;
		}
		food.setLocation ((int)(foodPosition.nextFloat() * 320), (int)(foodPosition.nextFloat() * 280));
		
	}


	public void paint (Graphics g) {
		update(g);
	}

	public void run () {	

		Thread me = Thread.currentThread();
		while (true) {

			if (start == true  && gameOver == false && intro == false) {
				trackSnakePartPositions();
				repaint();

				try {Thread.sleep(frameRate);}
				catch (InterruptedException ie) {}

				getDirections();
				trackSnakeFoodContact();
				gameHasEndedIf();

			}
			else {
				try {Thread.sleep(50);}
				catch (InterruptedException ie) {}
			}			
		}
	}

	

	public void gameHasEndedIf () {
	
		int distance2 = 21;

		if (yVal < 10 || yVal > 270 || xVal < 10 || xVal > 310)
			gameOver = true;



		if (endOfVector > 6) {
		for (int g=0; g < (snakeParts - 1); g++) {
			distance2 = (int)(Math.sqrt(Math.pow((xVal+20)-((partsXs[4 + 4 * g])+20),2) +Math.pow((yVal+20)-((partsYs[4 + 4 * g])+20),2)));
			if (distance2 < 15) 
				gameOver = true;
		}
		}
		
	}

	public void getDirections () {

		if (vertical == false) {
			horizontalDir = directions.get();
			xVal += horizontalDir;
			}
		
		if (vertical == true) {
			verticalDir = directions.get();
			yVal += verticalDir;
		}
	}

	public void trackSnakePartPositions () {
						
		for (int i=0; i < endOfVector; i++) {
			partsXs[endOfVector-i] = partsXs[endOfVector-(i+1)];
			partsYs[endOfVector-i] = partsYs[endOfVector-(i+1)];
		}

		if (endOfVector < (snakeParts * 4 + 4))
			endOfVector++;

		partsXs[0] = xVal;
		partsYs[0] = yVal;
	}

	public void trackSnakeFoodContact () {
		
		int distance;
		distance = (int)(Math.sqrt(Math.pow((xVal+20)-((food.getX())+20),2) +Math.pow((yVal+20)-((food.getY())+20),2)));
		
		if (distance < 20) {
			food.setLocation ((int)(foodPosition.nextFloat() * 320), (int)(foodPosition.nextFloat() * 280));
			snakeParts++;
			endOfVector += 4;
			playersScore += pointiculty;
			Integer ps = new Integer (playersScore);

		}
	}

	public void update (Graphics g) {

		Dimension d = getSize();
		Graphics2D g2 = createGraphics2D(d.width, d.height);

		if (intro == true)
			drawDemoIntro(d.width, d.height, g2);
		else
			drawDemo(d.width, d.height, g2);
		g2.dispose();
		g.drawImage(buffdImage, 0, 0, this);

	}


	public void drawDemoIntro (int w, int h, Graphics2D g2) {

		g2.setBackground(Color.black);
		g2.clearRect(0, 0, w, h);
		g2.drawImage(dudeImage, 10, 10, this);
	}

	public void drawDemo (int w, int h, Graphics2D g2) {



		Rectangle r = new Rectangle(10, 10, 320, 280);

		g2.setColor(colorArray[colorIndex]);
		g2.fill(r);

		g2.drawString("Player's Score " + Integer.toString(playersScore), 10, 305);
		
		g2.setColor(colorArray[colorIndex+1]);
		g2.fillOval((int)food.getX(), (int)food.getY(), 20 , 20);

		g2.setColor(colorArray[colorIndex+2]);
	

		for (int k=0; k < (snakeParts - 1); k++)
			g2.fillOval(partsXs[4 + 4 * k], partsYs[4 + 4*k], 20, 20);


		g2.fillOval(xVal, yVal, 20, 20);
	
	}

	public Graphics2D createGraphics2D (int w, int h) {

      	Graphics2D g2 = null;
            if (buffdImage == null || buffdImage.getWidth() != w || buffdImage.getHeight() != h) {
                buffdImage = (BufferedImage) createImage(w, h);
                // may need updating reset(w, h);
            } 
            g2 = buffdImage.createGraphics();
            g2.setBackground(getBackground());
            g2.clearRect(0, 0, w, h);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                                RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                                RenderingHints.VALUE_RENDER_QUALITY);
            return g2;
      }


	public void insertData () {

		try {
		FileWriter out = new FileWriter("HighScores.txt", true);
		BufferedWriter scores = new BufferedWriter(out);
		scores.write("Greg Hilberandt");
		scores.write("   ");

		Integer ps = new Integer (playersScore);
		scores.write(ps.toString());
		scores.newLine();
		scores.close();}
		catch (IOException e) {
			System.out.println("Error -- " + e.toString());
		}

	}

	public void keyPressed(KeyEvent evt) {
		

		if(evt.getKeyCode()==N || evt.getKeyCode()==ENTER) {
			intro = false;
			init();
			gameOver = false;
		}

		if (evt.getKeyCode()==P) {
			if (gameOver == false)
				gameOver = true;
			else
				gameOver = false;
		}

		if(evt.getKeyCode()==UP) {
			vertical = true;
			verticalDir = -5;
			directions.put(verticalDir);
		}

		if(evt.getKeyCode()==DOWN) {
			vertical = true;
			verticalDir = 5;
			directions.put(verticalDir);
		}

		if(evt.getKeyCode()==LEFT) {
			vertical = false;
			horizontalDir = -5;
			directions.put(horizontalDir);
		}

		if(evt.getKeyCode()==RIGHT) {
			vertical = false;
			horizontalDir = 5;
			directions.put(horizontalDir);
		}		
	}

	public void keyReleased(KeyEvent evt) {}
	public void keyTyped(KeyEvent evt) {}


	public void start () {
		Thread gameThread = new Thread (this);
		gameThread.start();
	}

}