import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import java.applet.*;
import java.util.*;

/*

NewSnake was created with help from the following authors;

John Croucher at www.jcroucher.com, Rogers Cadenhead and Lauren Lemay at www.java21days.com,
and the people at http:\\java.sun.com.

The GrrZap icon was borrowed from Leo's Icon Archive at www.iconarchive.com

*/

public class NewSnake extends JApplet implements ActionListener, KeyListener, Runnable {

	Thread gameThread;
	boolean start = false;
	boolean vertical = false;
	boolean hasStarted = false;

	boolean gameOver = false;

	CubbyHole2 directions = new CubbyHole2();

	Color natural = new Color (224, 227, 144);
	Color brown = new Color (98, 68,34);
	Color darkGreen = new Color (0, 58, 0);

	Color navy = new Color (0, 0, 77);
	Color yellar = new Color (255, 212, 86);
	Color read = new Color (221, 0, 0);

	Color babyBlue = new Color (187, 209, 255);
	Color purpleRed = new Color (181, 37, 80);

	Color darkGray = new Color (86, 80, 83);
	Color lightGray = new Color (190, 190, 190);

	Color brownGreen = new Color (28, 84, 0);
	Color yella = new Color (255, 230, 0);


	int colorIndex = 9;
	Color colorArray[] = {darkGray, Color.black, lightGray, navy, read, yellar, 
		babyBlue, purpleRed, navy, natural, darkGreen, brown, brownGreen, read, yella};

	
	final int LEFT = 37;
	final int RIGHT = 39;
	final int UP = 38;
	final int DOWN = 40;

	int verticalDir = 5;
	int horizontalDir = 5;

	int currentDir;
	
	int xVal = 10;
	int yVal = 10;

	Point2D.Float food = new Point2D.Float ();
	Random foodPosition = new Random(100L);

	int snakeParts = 6;
	int endOfVector = 0;
	int playersScore = 0;
	int [] partsXs = new int[400];
	int [] partsYs = new int[400];

      ImageIcon george = new ImageIcon("rock.gif");
	ImageIcon tim = new ImageIcon("pause.gif");
	static Image grrZap = Toolkit.getDefaultToolkit().getImage("GrrZap.gif");

      JButton rock = new JButton (george);
	JButton pause = new JButton (tim);
	JButton okay = new JButton ("OK");

	JMenuBar menuBar = new JMenuBar();
	JMenu menu = new JMenu("Colors");
	JMenu file = new JMenu("File");
	JMenu speed = new JMenu("Speed");

	JMenuItem exit = new JMenuItem("Exit");
	JMenuItem news = new JMenuItem("New");

	JMenuItem gray = new JMenuItem("gray");
	JMenuItem  navyBlue = new JMenuItem("navy");
	JMenuItem maroon = new JMenuItem("green");
	JMenuItem purple = new JMenuItem("purple");
	JMenuItem naturalMenuItem = new JMenuItem("natural");

	int frameRate = 30;
	int pointiculty = 20;
	JMenuItem mellow = new JMenuItem("Mellow");
	JMenuItem relaxed = new JMenuItem("Relaxed");
	JMenuItem business = new JMenuItem("Business");

	JComboBox playersName = new JComboBox ();
	JLabel finalScore = new JLabel ("Your Score: 0 ");

	JFrame scoreDialog = new JFrame ("High Scores");

	JPanel container = new JPanel();
	JPanel container4 = new JPanel();
	
	static BufferedImage buffdImage; 
	static Graphics2D imgSurface;

      public NewSnake() {
		
		init();
		directions.put(horizontalDir);
		rock.addActionListener(this);
		pause.addActionListener(this);
		okay.addActionListener(this);
		gray.addActionListener(this);
		purple.addActionListener(this);
		news.addActionListener(this);
		exit.addActionListener(this);
		naturalMenuItem.addActionListener(this);
		maroon.addActionListener(this);
		navyBlue.addActionListener(this);
		mellow.addActionListener(this);
		relaxed.addActionListener(this);
		business.addActionListener(this);

		rock.addKeyListener(this);
		pause.addKeyListener(this);
		container.addKeyListener(this);
		addKeyListener(this);

		container.add(rock);
		container.add(pause);
		container4.add(okay);

		scoreDialog.getContentPane().add(finalScore);
		scoreDialog.setBounds(670, 150, 300, 100);
		scoreDialog.getContentPane().add("East", container4);
		scoreDialog.getContentPane().add("South", playersName);
		scoreDialog.setIconImage(grrZap);


		this.getContentPane().add("North", finalScore);

		playersName.addItem("James VanDerbeek");
		playersName.addItem("AAA");
		playersName.addItem("Dick Johnson");
		playersName.addItem("Henry Winchler");
		playersName.addItem("Captain Kirk");
		playersName.addItem("Mr. T");
		playersName.setEditable(true);

		setJMenuBar(menuBar);

		menuBar.add(file);
		menuBar.add(menu);
		menuBar.add(speed);

		JLabel space = new JLabel("                                       ");
		menuBar.add(space);
		menuBar.add("East", finalScore);

		file.add(news);
		file.add(exit);
		speed.add(mellow);
		speed.add(relaxed);
		speed.add(business);
		menu.add(gray);
		menu.add(navyBlue);
		menu.add(purple);
		menu.add(maroon);
		menu.add(naturalMenuItem);

		gameThread = new Thread (this);
            gameThread.setPriority(Thread.MIN_PRIORITY);


      }		


		
	public void init () {
		setBackground(Color.black);

		currentDir = RIGHT;
		playersScore = 0;
		Integer ps = new Integer (playersScore);
		finalScore.setText("Your Score: " + ps.toString());
	//	finalScore 
		snakeParts = 6;
		xVal = yVal = 10;

		vertical = false;
		directions.get();
		directions.put(5);
		endOfVector = 0;
		for (int j=0; j<400; j++) {
			partsXs[j] = 10;
			partsYs[j] = 10;
		}
		food.setLocation ((int)(foodPosition.nextFloat() * 320), (int)(foodPosition.nextFloat() * 280));
		
	}


	public void run () {	

		Thread me = Thread.currentThread();
		while (me == gameThread) {

			if (start == true  && gameOver == false) {
				trackSnakePartPositions();
				repaint();

				try {Thread.sleep(frameRate);}
				catch (InterruptedException ie) {}

				getDirections();
				trackSnakeFoodContact();
				gameHasEndedIf();

			}
			else {
				try {Thread.sleep(50);}
				catch (InterruptedException ie) {}
			}			
		}
	}

	

	public void gameHasEndedIf () {
	
		int distance2 = 21;

		if (yVal < 10 || yVal > 270 || xVal < 10 || xVal > 310)
			gameOver = true;


		if (endOfVector > 6) {
		for (int g=0; g < (snakeParts - 1); g++) {
			distance2 = (int)(Math.sqrt(Math.pow((xVal+20)-((partsXs[4 + 4 * g])+20),2) +Math.pow((yVal+20)-((partsYs[4 + 4 * g])+20),2)));
			if (distance2 < 15)
				gameOver = true;
		}
		}
		
	}

	public void getDirections () {

		if (vertical == false) {
			horizontalDir = directions.get();
			xVal += horizontalDir;
			}
		
		if (vertical == true) {
			verticalDir = directions.get();
			yVal += verticalDir;
		}
	}

	public void trackSnakePartPositions () {
						
		for (int i=0; i < endOfVector; i++) {
			partsXs[endOfVector-i] = partsXs[endOfVector-(i+1)];
			partsYs[endOfVector-i] = partsYs[endOfVector-(i+1)];
		}

		if (endOfVector < (snakeParts * 4 + 4))
			endOfVector++;

		partsXs[0] = xVal;
		partsYs[0] = yVal;
	}

	public void trackSnakeFoodContact () {
		
		int distance;
		distance = (int)(Math.sqrt(Math.pow((xVal+20)-((food.getX())+20),2) +Math.pow((yVal+20)-((food.getY())+20),2)));
		
		if (distance < 20) {
			food.setLocation ((int)(foodPosition.nextFloat() * 320), (int)(foodPosition.nextFloat() * 280));
			snakeParts++;
			endOfVector += 4;
			playersScore += pointiculty;
			Integer ps = new Integer (playersScore);
			finalScore.setText("Your Score: " + ps.toString());
		}
	}

	public void paint (Graphics g) {

		Dimension d = getSize();
		Graphics2D g2 = createGraphics2D(d.width, d.height);

		drawDemo(d.width, d.height, g2, start);
		g2.dispose();
		g.drawImage(buffdImage, 0, 0, this);

	}


	public void drawDemo (int w, int h, Graphics2D g2, boolean start) {

		g2.setBackground(Color.black);
		g2.clearRect(0, 0, w, h);

		Rectangle r = new Rectangle(10, 10, 320, 280);

		g2.setColor(colorArray[colorIndex]);
		g2.fill(r);
		
		g2.setColor(colorArray[colorIndex+1]);
		g2.fillOval((int)food.getX(), (int)food.getY(), 20 , 20);

		g2.setColor(colorArray[colorIndex+2]);
	

		for (int k=0; k < (snakeParts - 1); k++)
			g2.fillOval(partsXs[4 + 4 * k], partsYs[4 + 4*k], 20, 20);


		g2.fillOval(xVal, yVal, 20, 20);

	}

	public Graphics2D createGraphics2D (int w, int h) {

      	Graphics2D g2 = null;
            if (buffdImage == null || buffdImage.getWidth() != w || buffdImage.getHeight() != h) {
                buffdImage = (BufferedImage) createImage(w, h);
                // may need updating reset(w, h);
            } 
            g2 = buffdImage.createGraphics();
            g2.setBackground(getBackground());
            g2.clearRect(0, 0, w, h);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                                RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                                RenderingHints.VALUE_RENDER_QUALITY);
            return g2;
      }


	public void insertData () {

		try {
		FileWriter out = new FileWriter("HighScores.txt", true);
		BufferedWriter scores = new BufferedWriter(out);
		scores.write((String) playersName.getSelectedItem());
		scores.write("   ");

		Integer ps = new Integer (playersScore);
		scores.write(ps.toString());
		scores.newLine();
		scores.close();}
		catch (IOException e) {
			System.out.println("Error -- " + e.toString());
		}


	}

	public void actionPerformed (ActionEvent evt) {
		Object src = evt.getSource();

		checkColorMenu(src);
		checkFileMenu(src);
		checkSpeedMenu(src);
		checkButtons(src);		
	}

	public void checkFileMenu (Object src) {

		if (src==news)
			System.out.println("News");

		if (src==exit)
			System.exit(0);
	}

	public void checkSpeedMenu (Object src) {
		if (src == business) {
			frameRate = 30;
			pointiculty = 20;
		}

		if (src == mellow) {
			frameRate = 50;
			pointiculty = 10;
		}

		if (src == relaxed) {
			frameRate = 45;
			pointiculty = 12;
		}
	}

	public void checkColorMenu (Object src) {

		if (src == navyBlue) {
			colorIndex = 3;
			repaint();
		}

		if (src == gray) {
			colorIndex = 0;
			repaint();
		}

		if (src == purple) {
			colorIndex = 6;
			repaint();
		}

		if (src == naturalMenuItem) {
			colorIndex = 9;
			repaint();
		}

		if (src == maroon) {
			colorIndex = 12;
			repaint();
		}

	}

	public void checkButtons(Object src) {

		if (src==rock && start == false && hasStarted == false) {
			start = true;
			hasStarted = true;
			gameThread.start();
		}

		else if (src==rock && start==false && hasStarted == true)
			start = true;

		else if (src==rock && gameOver==true) {
			init();
			gameOver = false;
		}
		
		if (src==pause && start==true)
			start = false;

		else if (src==pause && start==false)
			start = true;

		if (src == okay  && gameOver == false) {
			scoreDialog.setVisible(false);
			System.out.println(playersName.getSelectedItem());
			insertData();
		}

		if (src == okay && gameOver == true)
			insertData();
	}

	public void keyPressed(KeyEvent evt) {
		
		if(evt.getKeyCode()==UP && currentDir != DOWN) {
			vertical = true;
			verticalDir = -5;
			currentDir = UP;
			directions.put(verticalDir);
		}

		if(evt.getKeyCode()==DOWN && currentDir != UP) {
			vertical = true;
			verticalDir = 5;
			currentDir = DOWN;
			directions.put(verticalDir);
		}

		if(evt.getKeyCode()==LEFT && currentDir != RIGHT) {
			vertical = false;
			horizontalDir = -5;
			currentDir = LEFT;
			directions.put(horizontalDir);
		}

		if(evt.getKeyCode()==RIGHT && currentDir != LEFT) {
			vertical = false;
			horizontalDir = 5;
			currentDir = RIGHT;
			directions.put(horizontalDir);
		}

	
		
		
	}

	public void keyReleased(KeyEvent evt) {}
	public void keyTyped(KeyEvent evt) {}

      public static void main (String[] arguments) {
	      try {UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());}
	      catch (Exception e) {}
	      
		NewSnake slytherin = new NewSnake();
		//String response = JOptionPane.showInputDialog(frizzle, "Enter Your Name:", "Top Scorer", JOptionPane.PLAIN_MESSAGE );


		JFrame frizzle = new JFrame("Welcome to Snake.");
		frizzle.setJMenuBar(slytherin.menuBar);
		frizzle.addWindowListener(new WindowAdapter() {
            	public void windowClosing(WindowEvent e) {System.exit(0);}
        	});

		frizzle.setBounds(300, 150, 345, 400);
		frizzle.getContentPane().add("South", slytherin.container);
		frizzle.getContentPane().add("Center", slytherin);
		frizzle.setIconImage(grrZap);
		frizzle.setResizable(false);
		
	      slytherin.setVisible(true);
		frizzle.show();


      }
}

