Attribute VB_Name = "TaskAgent"
Declare Function ExitWindowsEx Lib "user32" (ByVal uFlags As Long, ByVal dwReserved As Long) As Long

Public Const EWX_FORCE = 4  'terminates processes that do not respond
Public Const EWX_LOGOFF = 0 'terminates processes, then logs off
Public Const EWX_REBOOT = 2 'reboots system
Public Const EWX_SHUTDOWN = 1 'shuts the system down, powers off if possible

Sub ActivateTask()
    
    Dim lenDate, lenTime As Long
    
    lenDate = Len(frmTaskMain.txtDate.Text)
    lenTime = Len(frmTaskMain.txtTime.Text)
    
    If lenDate <> 10 Or lenTime <> 8 Then
        MsgBox "Invalid date value", vbCritical, "SMB Task Agent 1.0"
        Exit Sub
    End If
    
    frmTaskMain.cmdActivate.Caption = "Deactivate"
    frmTaskMain.txtDate.Enabled = False
    frmTaskMain.txtTime.Enabled = False
    frmTaskMain.fraType.Enabled = False

End Sub



Sub DeactivateTask()

    frmTaskMain.cmdActivate.Caption = "Activate"
    frmTaskMain.txtDate.Enabled = True
    frmTaskMain.txtTime.Enabled = True
    frmTaskMain.fraType.Enabled = True
    
End Sub

Sub DoTask()

    dte$ = frmTaskMain.txtDate.Text
    tme$ = frmTaskMain.txtTime.Text
    
    If dte$ = Date$ And tme$ = Time$ Then GoTo DoTaskNow
    
    Exit Sub
    
DoTaskNow:
    
    If frmTaskMain.optShutDown.Value = True Then
        Call ShutDownWin
    End If
    
    If frmTaskMain.optRestart.Value = True Then
        Call RebootWin
    End If
    
    If frmTaskMain.optCloseApps.Value = True Then
        Call ForceWin
    End If
        
    If frmTaskMain.optLogOff.Value = True Then
        Call LogOffWin
    End If
    
End Sub

Sub ForceWin()
    
    Dim winn As Long

    winn = ExitWindowsEx(EWX_FORCE, 0)

End Sub


Sub LogOffWin()
    
    Dim winn As Long

    winn = ExitWindowsEx(EWX_LOGOFF, 0)

End Sub


Sub RebootWin()
    
    Dim winn As Long

    winn = ExitWindowsEx(EWX_REBOOT, 0)

End Sub


Sub ShutDownWin()
    
    Dim winn As Long

    winn = ExitWindowsEx(EWX_SHUTDOWN, 0)

End Sub


