Attribute VB_Name = "QuickEdit1"
'declarations for API calls:
Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

'constants for API functions:
Public Const HWND_TOPMOST = -1
Public Const HWND_NOTOPMOST = -2
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
Public Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Sub FormOnTop(frm As Form, condition As Boolean)
'toggles whether a form is on top of all other windows
'if condition = true then form is on top
'if condition = false then form is not top

Dim SetOnTop As Long

    Select Case condition
    
    Case True:
        SetOnTop = SetWindowPos(frm.hWnd, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)
    Case False:
        SetOnTop = SetWindowPos(frm.hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS)

    End Select
    
End Sub
Sub main()

    mdiParent.Show

End Sub

Sub CenterForm(frm As Form)
'centers a form on screen

    Dim x As Integer
    Dim y As Integer
    
    x = (Screen.Width - frm.Width) / 2
    y = (Screen.Height - frm.Height) / 2
    
    frm.Move x, y
    
End Sub

Function GetLongDate() As String
'gets the long date format (ex: December 6, 1983)
    Dim month As String
    Dim mnum As Integer
    Dim longdate As String
    Dim theday, theyear As Integer
    
    mnum = Left$(Date$, 2) 'gets month number
    
    Select Case mnum
        Case 1: month = "January"
        Case 2: month = "February"
        Case 3: month = "March"
        Case 4: month = "April"
        Case 5: month = "May"
        Case 6: month = "June"
        Case 7: month = "July"
        Case 8: month = "August"
        Case 9: month = "September"
        Case 10: month = "October"
        Case 11: month = "November"
        Case 12: month = "December"
    End Select
    
    theday = Mid$(Date$, 4, 2) 'gets day value
    theyear = Right$(Date$, 4) 'gets year value
    
    longdate = month & " " & theday & ", " & theyear
    
    GetLongDate = longdate
    
End Function
Function GetRealTime() As String
'gets the longer time, with AM and PM
'sorry, this is really confusing, i got lazy writing
'variable names
    Dim armytime As String
    Dim daytime As Integer
    Dim AMPM As String
    Dim realtime0 As String
    Dim realtime1 As String
    Dim realtime2 As String

    armytime = Time$
    daytime = Left$(armytime, 2)
    realtime0 = Right$(armytime, 6) 'gets minutes and seconds
    
    If daytime >= 12 Then AMPM = "PM"
    If daytime <= 11 Then AMPM = "AM"
    
    If AMPM = "PM" Then
        realtime1 = (daytime - 12) 'gets real hour
        realtime2 = realtime1 + realtime0 + " PM" 'puts it all together
    End If
    
    If AMPM = "AM" Then
        realtime1 = daytime
        realtime2 = realtime1 + realtime0 + " AM"
    End If
    
    GetRealTime = realtime2

End Function
Function GetWindowDir()
'gets windows directory
Dim windr As String
Dim i As Long

    windr = String$(255, 0)
    i = GetWindowsDirectory(windr, 255)
    
    GetWindowDir = windr
End Function

Sub Pause(ByVal nSecond As Single)
'creates a pause in program, in seconds
'works well with timers and slowing a program down
'Note: you may pass a decimal through the interval argument
   
   Dim tOut As Single
   tOut = Timer
   
   Do While Timer - tOut < nSecond
   
      Dim junk As Integer
      
      junk = DoEvents()
      
      If Timer < tOut Then
         tOut = tOut - CLng(24) * CLng(60) * CLng(60)
      End If
      
   Loop
   
End Sub
Function ReplaceCharacter(stringToChange$, charToReplace$, replaceWith$) As String
'Replaces a specified character in a string with another
'character that you specify

    Dim ln, i As Long
    Dim NextLetter As String
    Dim FinalString As String
    Dim txt, char, rep As String

    txt = stringToChange$  'store all arguments in
    char = charToReplace$  'new variables
    rep = replaceWith$
          
    ln = Len(txt)
    
    'starts for loop that reads each character in the string
    'one at a time and replaces it with (rep)
    For i = 1 To ln Step 1
        NextLetter = Mid(txt, i, 1) 'next character
        
        If NextLetter = char Then  'if the character is found
            NextLetter = rep       'then replace it with (rep)
        End If
        
        FinalString = FinalString & NextLetter 'add next letter at end
    Next i
    
    ReplaceCharacter = FinalString
    
End Function
Function ReverseString(txt$)
'Reverses a string (ex: "hello world" = "dlrow olleh")
Dim Words As Long

    For Words = Len(txt$) To 1 Step -1
        ReverseString = ReverseString & Mid(txt$, Words, 1)
    Next Words

End Function

Sub OpenFilesInList(lstBox As ListBox)
Dim idx, i As Long
Dim CurrentItem, VarString As String

idx = lstBox.ListCount - 1

    For i = 0 To idx Step 1
    
    CurrentItem = lstBox.List(i)
    
    Open CurrentItem For Binary As #1
    
    'adds a form to display new file
        AddForm2
    
    'sets the caption of the new form to the filename
        mdiParent.ActiveForm.Caption = CurrentItem
        
    'sets length of VarString to store whole file
        VarString = String(LOF(1), " ")
        
    'gets the text in file #1 and assigns it to VarString
        Get #1, , VarString
        
    'puts the text into the textbox
        mdiParent.ActiveForm.txtEdit.Text = VarString
                
    'closes file
    Close #1
        
    Next i
    
End Sub

Sub SaveFile()
Dim strFileName, strFileContents As String
Dim VarString As String
    
    'defines properties of the commondialog control
        mdiParent.CommonDialog.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*|"
        
    'shows open format of the common dialog control
        mdiParent.CommonDialog.ShowSave
        
    'gets the filename of the file the user selected
        strFileName = mdiParent.CommonDialog.FileName

If strFileName = "" Then Exit Sub
 
    'sets the caption of the new form to the filename
        mdiParent.ActiveForm.Caption = strFileName

    'gets the text in file #1 and assigns it to VarString
        VarString = mdiParent.ActiveForm.txtEdit.Text
        
    'Save document
        SaveDocument (strFileName), (VarString)

'sets filename to null
    mdiParent.CommonDialog.FileName = ""
End Sub
Sub SaveDocument(FileName As String, Source As String)
'Saves document for output method.

    Open FileName For Output As #1
    
'write to file
    Print #1, Source
    
'Close file 1
    Close #1
    
End Sub

Function RemoveLetters(SourceString As String) As String
Dim FinalString As String
Dim i As Integer
Dim repp As String

    FinalString = ReplaceCharacter(SourceString, Chr$(65), "")

'remove A-Z
For i = 66 To 90
    FinalString = ReplaceCharacter(FinalString, Chr$(i), "")
Next i

'remove a-z
For i = 97 To 122
    FinalString = ReplaceCharacter(FinalString, Chr$(i), "")
Next i

    RemoveLetters = FinalString

End Function

Sub ReplaceAction(CaseSense As Boolean)
Dim txt, Trigger As String
Dim EndString As String
Dim ln, pos, Spos As Long

Spos = Val(frmReplace.lblpos.Caption)

Select Case CaseSense

    Case True
        txt = mdiParent.ActiveForm.ActiveControl.Text
        Trigger = frmReplace.txtFind.Text
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
    Case False
        txt = LCase(mdiParent.ActiveForm.ActiveControl.Text)
        Trigger = LCase(frmReplace.txtFind.Text)
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
End Select

    If pos = 0 Then
        MsgBox "No more instances found. The cursor will return to the beginning.", vbExclamation, "Not Found"
        frmReplace.lblpos.Caption = "1"
        Exit Sub
    End If
    
    mdiParent.ActiveForm.ActiveControl.SelStart = pos - 1
    mdiParent.ActiveForm.ActiveControl.SelLength = ln
    mdiParent.ActiveForm.ActiveControl.SelText = frmReplace.txtReplace.Text
    mdiParent.ActiveForm.ActiveControl.SetFocus

    frmReplace.lblpos.Caption = pos + 1
End Sub

Sub ReplaceAll(CaseSense As Boolean)
Dim txt, Trigger As String
Dim EndString As String
Dim ln, pos, Spos As Long
Dim TotalOcc As Long

Spos = Val(frmReplace.lblpos.Caption)

Select Case CaseSense

    Case True
        txt = mdiParent.ActiveForm.ActiveControl.Text
        Trigger = frmReplace.txtFind.Text
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
    Case False
        txt = LCase(mdiParent.ActiveForm.ActiveControl.Text)
        Trigger = LCase(frmReplace.txtFind.Text)
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
End Select

    If pos = 0 Then
        TotalOcc = frmReplace.lblOcc.Caption
        MsgBox "All (" & TotalOcc & ") instances replaced.", vbInformation, "Finished"
        frmReplace.lblpos.Caption = 1
        Exit Sub
        
    Else:
        mdiParent.ActiveForm.ActiveControl.SelStart = pos - 1
        mdiParent.ActiveForm.ActiveControl.SelLength = ln
        mdiParent.ActiveForm.ActiveControl.SelText = frmReplace.txtReplace.Text
        mdiParent.ActiveForm.ActiveControl.SetFocus

        frmReplace.lblpos.Caption = pos + 1
        ReplaceAll CaseSense
    End If

End Sub


Sub SaveListBox(FileName As String, lstBox As ListBox)
Dim idx, i As Long
Dim CurrentItem As String

idx = lstBox.ListCount - 1

'Saves list box contents for output
    Open FileName For Output As #1
        
        For i = 0 To idx Step 1
    
            CurrentItem = lstBox.List(i)
        'write to file
            Print #1, CurrentItem
        
        Next i
    
'Close file 1
    Close #1
    
End Sub

Sub UnloadAllForms()
'Closes all open forms, only works when called
'under unload event
Dim TotalForms As Integer
Dim i As Integer

    TotalForms = Forms.Count - 1

    For i = 0 To TotalForms
        Unload Forms(i)
    Next i

End Sub



Public Function CountOcc(Trigger As String, SourceString As String, CaseSense As Boolean) As Long
    
Dim pos As Long
Dim TotalCount As Long

    TotalCount = 0
    pos = 0

    If CaseSense = False Then
        SourceString = UCase(SourceString)
        Trigger = UCase(Trigger)
    End If


    Do While pos <> -1
        pos = InStr(pos + 1, SourceString, Trigger)
        If pos <> 0 Then TotalCount = TotalCount + 1
        If pos = 0 Then pos = -1
    Loop
    
    CountOcc = TotalCount
End Function
Sub FilesOpen()

    With mdiParent
        .mnuCut.Enabled = True
        .mnuCopy.Enabled = True
        .mnuPaste.Enabled = True
        .mnuDelete.Enabled = True
        .mnuSelectAll.Enabled = True
        .mnuFind.Enabled = True
        .mnuFreplace.Enabled = True
        .mnuTimeDate.Enabled = True
        .mnuManip.Enabled = True
        
        .mnuCount.Enabled = True
        .mnuCountOccur.Enabled = True
        .mnuInsChar.Enabled = True
        .mnuInsTxt.Enabled = True
        .mnuRandom.Enabled = True
        .mnuSaveFile.Enabled = True
        .mnuSaveAs.Enabled = True
    End With
    
End Sub

Sub FindAction(CaseSense As Boolean)
Dim txt, Trigger As String
Dim EndString As String
Dim ln, pos, Spos As Long

Spos = Val(frmFind.lblStart.Caption)

Select Case CaseSense

    Case True
        txt = mdiParent.ActiveForm.ActiveControl.Text
        Trigger = frmFind.txtFind.Text
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
    Case False
        txt = LCase(mdiParent.ActiveForm.ActiveControl.Text)
        Trigger = LCase(frmFind.txtFind.Text)
        ln = Len(Trigger)
        pos = InStr(Spos, txt, Trigger)
End Select

    If pos = 0 Then
        MsgBox "No more instances found. The cursor will return to the beginning.", vbExclamation, "Not Found"
        frmFind.lblStart.Caption = "1"
        Exit Sub
    End If
    
    mdiParent.ActiveForm.ActiveControl.SelStart = pos - 1
    mdiParent.ActiveForm.ActiveControl.SelLength = ln
    mdiParent.ActiveForm.ActiveControl.SetFocus

    frmFind.lblStart.Caption = pos + 1
End Sub

Function GetRealTime2() As String
'gets long time (part 2) ie: 6:30 PM
'GetRealTime() uses format of 6:30:00 PM
    Dim armytime As String
    Dim daytime As Integer
    Dim AMPM As String
    Dim realtime0 As String
    Dim realtime1 As String
    Dim realtime2 As String

    armytime = Time$
    daytime = Left$(armytime, 2)
    realtime0 = Mid$(armytime, 3, 3) 'gets minutes and seconds
    
    If daytime >= 12 Then AMPM = "PM"
    If daytime <= 11 Then AMPM = "AM"
    
    If AMPM = "PM" Then
        realtime1 = (daytime - 12) 'gets real hour
        realtime2 = realtime1 + realtime0 + " PM" 'puts it all together
    End If
    
    If AMPM = "AM" Then
        realtime1 = daytime
        realtime2 = realtime1 + realtime0 + " AM"
    End If
    
    GetRealTime2 = realtime2

End Function
Sub NoFilesOpen()

    With mdiParent
        .mnuCut.Enabled = False
        .mnuCopy.Enabled = False
        .mnuPaste.Enabled = False
        .mnuDelete.Enabled = False
        .mnuSelectAll.Enabled = False
        .mnuFind.Enabled = False
        .mnuFreplace.Enabled = False
        .mnuTimeDate.Enabled = False
        .mnuManip.Enabled = False
        
        .mnuCount.Enabled = False
        .mnuCountOccur.Enabled = False
        .mnuInsChar.Enabled = False
        .mnuInsTxt.Enabled = False
        .mnuRandom.Enabled = False
        .mnuSaveFile.Enabled = False
        .mnuSaveAs.Enabled = False
    End With
        
End Sub


Function RemoveNumbers(SourceString As String) As String
Dim FinalString As String
Dim i As Integer
Dim repp As String

'remove number (0)
    FinalString = ReplaceCharacter(SourceString, "0", "")

'use for...next loop to remove numbers 1 to 9
For i = 1 To 9
    repp = i
    'replace each character
    FinalString = ReplaceCharacter(FinalString, repp, "")
Next i

'return final value (with no numbers)
    RemoveNumbers = FinalString

End Function


Function WordCount(SourceString As String) As Long
'counts number of words in a string
'note: divides length by 4 to find number
'of words (this method is used in in typing
'tutors and so on...)
Dim ln As Long
Dim TotalWords As Integer

ln = Len(SourceString)
TotalWords = ln / 4

    WordCount = TotalWords
    
End Function

Public Function AddForm2() As frmChild
    Set AddForm = New frmChild
    AddForm.Caption = "Untitled" & " (" & (Forms.Count) & ")"
    AddForm.Show vbModeless
End Function

